#!/bin/bash

# @ Martin Kellogg ; July 2015

# This script is used to run one of the main proactive diversity experiments for Martin and Jamie's summer 2015 project

# $1 should be a path to the repair executable
echo "entering martin's control script"

REPAIR=$1

if ! [[ -f pd-weight ]]; then
    if ! [[ -f configuration-cov ]]; then
	echo "control-experiment.sh: Cannot compute or find coverage information. Exiting now."
	exit 2
    fi
    rm -rf *coverage*
    $REPAIR configuration-cov
    cp coverage.path.pos pd-weight
    if ! [[ -f pd-weight ]]; then
	echo "control-experiment.sh: An error occurred while computing coverage. Exiting now."
	exit 3
    fi
fi

if ! [[ -d source ]]; then
    mkdir source
fi

$REPAIR configuration-pd
grep "passed [0-9]" repair.debug.0 | cut -f 1 -d p | sed "s/^..//" > genomes
if ! [[ -d repair.debug ]]; then
    mkdir repair.debug
fi
mv repair.debug.0 repair.debug/repair.debug.original
./run_tests.py $REPAIR