#!/bin/bash

# this script does all the necessary steps to instrument a Siemens benchmark in Jon Dorn format so that the negative tests detect differences from the original instead of check the correct answer directly

# @ Martin Kellogg, 17 June 2015

# $1        the program to be instrumented (e.g. tcas)

cd $1/scripts

sed -i "s/output/original/g" runall.sh

cd ..
mkdir originals

cd ..
if [ $1 = "tot_info" ]; then
    compiler_options=-lm
fi

./compile.sh gcc $1/source/$1.exe preprocessed/source/$1.c $compiler_options

cd $1/scripts
./runall.sh
cp test.sh test-neg.sh
sed -i "s/golden/originals/g" test-neg.sh
sed -i "s/exec/if/g" test-neg.sh
sed -i "s/2>&1/2>\&1; then exit 1; else exit 0; fi /g" test-neg.sh
cd ../../
sed -i "/n[0-9]/s/test/test-neg/g" test.sh

echo "instrumentation of $1 complete"