--TEST--
Bug #60536 (Traits Segfault)
--FILE--
<?php
trait T { private $x = 0; }
class X { 
	use T;
}
class Y extends X {
	  use T;
	  function x() {
	      return ++$this->x; 
      }
}
class Z extends Y {
	  function z() {
		  return ++$this->x; 
      }
}
$a = new Z();
$a->x();
echo "DONE";
?>
--EXPECTF--
Strict Standards: X and T define the same property ($x) in the composition of Y. This might be incompatible, to improve maintainability consider using accessor methods in traits instead. Class was composed in /root/mountpoint-genprog/genprog-many-bugs/php-bug-2011-12-17-db63456a8d-3dc9f0abe6/php/Zend/tests/bug60536_001-detect.php on line 11
DONE