--TEST--
Introducing new private variables of the same name in a subclass is ok, and does not lead to any output. That is consitent with normal inheritance handling.
--FILE--
<?php
error_reporting(E_ALL | E_STRICT);

class Base {
  private $hello;    
}

trait THello1 {
  private $hello;
}

// Now we use the trait, which happens to introduce another private variable
// but they are distinct, and not related to each other, so no warning.
echo "PRE-CLASS-GUARD\n";
class SameNameInSubClassNoNotice extends Base {
    use THello1;
}
echo "POST-CLASS-GUARD\n";

// now the same with a class that defines the property itself,
// that should give the expected strict warning.

class Notice extends Base {
    use THello1;
    private $hello;
}
echo "POST-CLASS-GUARD2\n";
?>
--EXPECTF--	
--TEST--
Introducing new private variables of the same name in a subclass is ok, and does not lead to any output. That is consitent with normal inheritance handling.
--FILE--
<?php
error_reporting(E_ALL | E_STRICT);

class Base {
  private $hello;    
}

trait THello1 {
  private $hello;
}

// Now we use the trait, which happens to introduce another private variable
// but they are distinct, and not related to each other, so no warning.
echo "PRE-CLASS-GUARD\n";
class SameNameInSubClassNoNotice extends Base {
    use THello1;
}
echo "POST-CLASS-GUARD\n";

// now the same with a class that defines the property itself,
// that should give the expected strict warning.

class Notice extends Base {
    use THello1;
    private $hello;
}
echo "POST-CLASS-GUARD2\n";
?>
--EXPECTF--	
PRE-CLASS-GUARD

Strict Standards: Base and THello1 define the same property ($hello) in the composition of SameNameInSubClassNoNotice. This might be incompatible, to improve maintainability consider using accessor methods in traits instead. Class was composed in /root/genprog-many-bugs/php-bug-2011-12-17-db63456a8d-3dc9f0abe6/php/Zend/tests/traits/property006.php on line 17
POST-CLASS-GUARD

Strict Standards: Notice and THello1 define the same property ($hello) in the composition of Notice. This might be incompatible, to improve maintainability consider using accessor methods in traits instead. Class was composed in /root/genprog-many-bugs/php-bug-2011-12-17-db63456a8d-3dc9f0abe6/php/Zend/tests/traits/property006.php on line 26
POST-CLASS-GUARD2