--TEST--
Bug #54089 (token_get_all() does not stop after __halt_compiler)
--SKIPIF--
<?php if (!extension_loaded("tokenizer")) print "skip"; ?>
--FILE--
<?php
$codes = array(
	"<?php __halt_compiler",
	"<?php __halt_compiler(",
	"<?php __halt_compiler();",
	"<?php __halt_compiler();ABC",
	"<?php __halt_compiler\n(\n)\n;ABC",
	"<?php __halt_compiler\nabc\ndef\nghi ABC",
);
foreach ($codes as $code) {
	$tokens = token_get_all($code);
	var_dump($tokens);
	
	$code = '';
	foreach ($tokens as $t)
	{
		$code .= isset($t[1]) ? $t[1] : $t;
	}
	var_dump($code);
}

?>
--EXPECTF--
--TEST--
Bug #54089 (token_get_all() does not stop after __halt_compiler)
--SKIPIF--
<?php if (!extension_loaded("tokenizer")) print "skip"; ?>
--FILE--
<?php
$codes = array(
	"<?php __halt_compiler",
	"<?php __halt_compiler(",
	"<?php __halt_compiler();",
	"<?php __halt_compiler();ABC",
	"<?php __halt_compiler\n(\n)\n;ABC",
	"<?php __halt_compiler\nabc\ndef\nghi ABC",
);
foreach ($codes as $code) {
	$tokens = token_get_all($code);
	var_dump($tokens);
	
	$code = '';
	foreach ($tokens as $t)
	{
		$code .= isset($t[1]) ? $t[1] : $t;
	}
	var_dump($code);
}

?>
--EXPECTF--
array(2) {
  [0]=>
  array(3) {
    [0]=>
    int(372)
    [1]=>
    string(6) "<?php "
    [2]=>
    int(1)
  }
  [1]=>
  array(3) {
    [0]=>
    int(353)
    [1]=>
    string(15) "__halt_compiler"
    [2]=>
    int(1)
  }
}
string(21) "<?php __halt_compiler"
array(2) {
  [0]=>
  array(3) {
    [0]=>
    int(372)
    [1]=>
    string(6) "<?php "
    [2]=>
    int(1)
  }
  [1]=>
  array(3) {
    [0]=>
    int(353)
    [1]=>
    string(15) "__halt_compiler"
    [2]=>
    int(1)
  }
}
string(21) "<?php __halt_compiler"
array(2) {
  [0]=>
  array(3) {
    [0]=>
    int(372)
    [1]=>
    string(6) "<?php "
    [2]=>
    int(1)
  }
  [1]=>
  array(3) {
    [0]=>
    int(353)
    [1]=>
    string(15) "__halt_compiler"
    [2]=>
    int(1)
  }
}
string(21) "<?php __halt_compiler"
array(2) {
  [0]=>
  array(3) {
    [0]=>
    int(372)
    [1]=>
    string(6) "<?php "
    [2]=>
    int(1)
  }
  [1]=>
  array(3) {
    [0]=>
    int(353)
    [1]=>
    string(15) "__halt_compiler"
    [2]=>
    int(1)
  }
}
string(21) "<?php __halt_compiler"
array(2) {
  [0]=>
  array(3) {
    [0]=>
    int(372)
    [1]=>
    string(6) "<?php "
    [2]=>
    int(1)
  }
  [1]=>
  array(3) {
    [0]=>
    int(353)
    [1]=>
    string(15) "__halt_compiler"
    [2]=>
    int(1)
  }
}
string(21) "<?php __halt_compiler"
array(2) {
  [0]=>
  array(3) {
    [0]=>
    int(372)
    [1]=>
    string(6) "<?php "
    [2]=>
    int(1)
  }
  [1]=>
  array(3) {
    [0]=>
    int(353)
    [1]=>
    string(15) "__halt_compiler"
    [2]=>
    int(1)
  }
}
string(21) "<?php __halt_compiler"