--TEST--
Bug #60217 (Requiring the same method from different traits and abstract methods have to be compatible, in both directions.)
--FILE--
<?php

trait TBroken1 {
    public abstract function foo($a, $b = 0);
}

trait TBroken2 {
    public abstract function foo($a);
}

class CBroken {
    use TBroken1, TBroken2;

    public function foo($a) {
        echo 'FOO';
    }
}

$o = new CBroken;
$o->foo(1);

--EXPECTF--
Fatal error: Can't inherit abstract function TBroken2::foo() (previously declared abstract in TBroken1) in /root/mountpoint-genprog/genprog-many-bugs/php-bug-2011-11-04-9da01ac6b6-7334dfd7eb/php/Zend/tests/traits/bug60217c-detect.php on line 17