--TEST--
Bug #60217 (Requiring the same method from different traits.)
--FILE--
<?php

trait T1 {
    public abstract function foo();
}

trait T2 {
    public abstract function foo();
}

class C {
    use T1, T2;

    public function foo() {
        echo "C::foo() works.\n";
    }
}

$o = new C;
$o->foo();

--EXPECTF--
--TEST--
Bug #60217 (Requiring the same method from different traits.)
--FILE--
<?php

trait T1 {
    public abstract function foo();
}

trait T2 {
    public abstract function foo();
}

class C {
    use T1, T2;

    public function foo() {
        echo "C::foo() works.\n";
    }
}

$o = new C;
$o->foo();

--EXPECTF--
Fatal error: Can't inherit abstract function T2::foo() (previously declared abstract in T1) in /root/genprog-many-bugs/php-bug-2011-11-04-9da01ac6b6-7334dfd7eb/php/Zend/tests/traits/bug60217a.php on line 17