/* Generated by re2c 0.13.5 on Mon May 16 10:25:36 2011 */
#line 1 "Zend/zend_language_scanner.l"
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) 1998-2011 Zend Technologies Ltd. (http://www.zend.com) |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   | Flex version authors:                                                |
   |          Andi Gutmans <andi@zend.com>                                |
   |          Zeev Suraski <zeev@zend.com>                                |
   +----------------------------------------------------------------------+
*/

/* $Id$ */

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_language_scanner_defs.h"

#include <errno.h>
#include "zend.h"
#include "zend_alloc.h"
#include <zend_language_parser.h>
#include "zend_compile.h"
#include "zend_language_scanner.h"
#include "zend_highlight.h"
#include "zend_constants.h"
#include "zend_variables.h"
#include "zend_operators.h"
#include "zend_API.h"
#include "zend_strtod.h"
#include "zend_exceptions.h"
#include "tsrm_virtual_cwd.h"
#include "tsrm_config_common.h"

#define YYCTYPE   unsigned char
#define YYFILL(n) { if ((YYCURSOR + n) >= (YYLIMIT + ZEND_MMAP_AHEAD)) { return 0; } }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do { YYCURSOR = (unsigned char*)yytext + x; \
                          yyleng   = (unsigned int)x; } while(0)
#define yymore()     goto yymore_restart

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 16
#if ZEND_MMAP_AHEAD < YYMAXFILL
# error ZEND_MMAP_AHEAD should be greater than or equal to YYMAXFILL
#endif

#ifdef HAVE_STDARG_H
# include <stdarg.h>
#endif

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

/* Globals Macros */
#define SCNG	LANG_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id language_scanner_globals_id;
#else
ZEND_API zend_php_scanner_globals language_scanner_globals;
#endif

#define HANDLE_NEWLINES(s, l)													\
do {																			\
	char *p = (s), *boundary = p+(l);											\
																				\
	while (p<boundary) {														\
		if (*p == '\n' || (*p == '\r' && (*(p+1) != '\n'))) {					\
			CG(zend_lineno)++;													\
		}																		\
		p++;																	\
	}																			\
} while (0)

#define HANDLE_NEWLINE(c) \
{ \
	if (c == '\n' || c == '\r') { \
		CG(zend_lineno)++; \
	} \
}

/* To save initial string length after scanning to first variable, CG(doc_comment_len) can be reused */
#define SET_DOUBLE_QUOTES_SCANNED_LENGTH(len) CG(doc_comment_len) = (len)
#define GET_DOUBLE_QUOTES_SCANNED_LENGTH()    CG(doc_comment_len)

#define IS_LABEL_START(c) (((c) >= 'a' && (c) <= 'z') || ((c) >= 'A' && (c) <= 'Z') || (c) == '_' || (c) >= 0x7F)

#define ZEND_IS_OCT(c)  ((c)>='0' && (c)<='7')
#define ZEND_IS_HEX(c)  (((c)>='0' && (c)<='9') || ((c)>='a' && (c)<='f') || ((c)>='A' && (c)<='F'))

BEGIN_EXTERN_C()

static size_t encoding_filter_script_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length TSRMLS_DC)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding(TSRMLS_C);
	assert(internal_encoding && zend_multibyte_check_lexer_compatibility(internal_encoding));
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, internal_encoding, LANG_SCNG(script_encoding) TSRMLS_CC);
}

static size_t encoding_filter_script_to_intermediate(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length TSRMLS_DC)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, zend_multibyte_encoding_utf8, LANG_SCNG(script_encoding) TSRMLS_CC);
}

static size_t encoding_filter_intermediate_to_script(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length TSRMLS_DC)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
LANG_SCNG(script_encoding), zend_multibyte_encoding_utf8 TSRMLS_CC);
}

static size_t encoding_filter_intermediate_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length TSRMLS_DC)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding(TSRMLS_C);
	assert(internal_encoding && zend_multibyte_check_lexer_compatibility(internal_encoding));
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
internal_encoding, zend_multibyte_encoding_utf8 TSRMLS_CC);
}


static void _yy_push_state(int new_state TSRMLS_DC)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION(), sizeof(int));
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(TSRMLS_D)
{
	int *stack_state;
	zend_stack_top(&SCNG(state_stack), (void **) &stack_state);
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, unsigned int len TSRMLS_DC)
{
	YYCURSOR       = (YYCTYPE*)str;
	YYLIMIT        = YYCURSOR + len;
	if (!SCNG(yy_start)) {
		SCNG(yy_start) = YYCURSOR;
	}
}

void startup_scanner(TSRMLS_D)
{
	CG(heredoc) = NULL;
	CG(heredoc_len) = 0;
	CG(doc_comment) = NULL;
	CG(doc_comment_len) = 0;
	zend_stack_init(&SCNG(state_stack));
}

void shutdown_scanner(TSRMLS_D)
{
	if (CG(heredoc)) {
		efree(CG(heredoc));
		CG(heredoc_len)=0;
	}
	zend_stack_destroy(&SCNG(state_stack));
	RESET_DOC_COMMENT();
}

ZEND_API void zend_save_lexical_state(zend_lex_state *lex_state TSRMLS_DC)
{
	lex_state->yy_leng   = SCNG(yy_leng);
	lex_state->yy_start  = SCNG(yy_start);
	lex_state->yy_text   = SCNG(yy_text);
	lex_state->yy_cursor = SCNG(yy_cursor);
	lex_state->yy_marker = SCNG(yy_marker);
	lex_state->yy_limit  = SCNG(yy_limit);

	lex_state->state_stack = SCNG(state_stack);
	zend_stack_init(&SCNG(state_stack));

	lex_state->in = SCNG(yy_in);
	lex_state->yy_state = YYSTATE;
	lex_state->filename = zend_get_compiled_filename(TSRMLS_C);
	lex_state->lineno = CG(zend_lineno);

	lex_state->script_org = SCNG(script_org);
	lex_state->script_org_size = SCNG(script_org_size);
	lex_state->script_filtered = SCNG(script_filtered);
	lex_state->script_filtered_size = SCNG(script_filtered_size);
	lex_state->input_filter = SCNG(input_filter);
	lex_state->output_filter = SCNG(output_filter);
	lex_state->script_encoding = SCNG(script_encoding);
}

ZEND_API void zend_restore_lexical_state(zend_lex_state *lex_state TSRMLS_DC)
{
	SCNG(yy_leng)   = lex_state->yy_leng;
	SCNG(yy_start)  = lex_state->yy_start;
	SCNG(yy_text)   = lex_state->yy_text;
	SCNG(yy_cursor) = lex_state->yy_cursor;
	SCNG(yy_marker) = lex_state->yy_marker;
	SCNG(yy_limit)  = lex_state->yy_limit;

	zend_stack_destroy(&SCNG(state_stack));
	SCNG(state_stack) = lex_state->state_stack;

	SCNG(yy_in) = lex_state->in;
	YYSETCONDITION(lex_state->yy_state);
	CG(zend_lineno) = lex_state->lineno;
	zend_restore_compiled_filename(lex_state->filename TSRMLS_CC);

	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	SCNG(script_org) = lex_state->script_org;
	SCNG(script_org_size) = lex_state->script_org_size;
	SCNG(script_filtered) = lex_state->script_filtered;
	SCNG(script_filtered_size) = lex_state->script_filtered_size;
	SCNG(input_filter) = lex_state->input_filter;
	SCNG(output_filter) = lex_state->output_filter;
	SCNG(script_encoding) = lex_state->script_encoding;

	if (CG(heredoc)) {
		efree(CG(heredoc));
		CG(heredoc) = NULL;
		CG(heredoc_len) = 0;
	}
}

ZEND_API void zend_destroy_file_handle(zend_file_handle *file_handle TSRMLS_DC)
{
	zend_llist_del_element(&CG(open_files), file_handle, (int (*)(void *, void *)) zend_compare_file_handles);
	/* zend_file_handle_dtor() operates on the copy, so we have to NULLify the original here */
	file_handle->opened_path = NULL;
	if (file_handle->free_filename) {
		file_handle->filename = NULL;
	}
}

#define BOM_UTF32_BE	"\x00\x00\xfe\xff"
#define	BOM_UTF32_LE	"\xff\xfe\x00\x00"
#define	BOM_UTF16_BE	"\xfe\xff"
#define	BOM_UTF16_LE	"\xff\xfe"
#define	BOM_UTF8		"\xef\xbb\xbf"

static const zend_encoding *zend_multibyte_detect_utf_encoding(const unsigned char *script, size_t script_size TSRMLS_DC)
{
	const unsigned char *p;
	int wchar_size = 2;
	int le = 0;

	/* utf-16 or utf-32? */
	p = script;
	while ((p-script) < script_size) {
		p = memchr(p, 0, script_size-(p-script)-2);
		if (!p) {
			break;
		}
		if (*(p+1) == '\0' && *(p+2) == '\0') {
			wchar_size = 4;
			break;
		}

		/* searching for UTF-32 specific byte orders, so this will do */
		p += 4;
	}

	/* BE or LE? */
	p = script;
	while ((p-script) < script_size) {
		if (*p == '\0' && *(p+wchar_size-1) != '\0') {
			/* BE */
			le = 0;
			break;
		} else if (*p != '\0' && *(p+wchar_size-1) == '\0') {
			/* LE* */
			le = 1;
			break;
		}
		p += wchar_size;
	}

	if (wchar_size == 2) {
		return le ? zend_multibyte_encoding_utf16le : zend_multibyte_encoding_utf16be;
	} else {
		return le ? zend_multibyte_encoding_utf32le : zend_multibyte_encoding_utf32be;
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_detect_unicode(TSRMLS_D)
{
	const zend_encoding *script_encoding = NULL;
	int bom_size;
	unsigned char *pos1, *pos2;

	if (LANG_SCNG(script_org_size) < sizeof(BOM_UTF32_LE)-1) {
		return NULL;
	}

	/* check out BOM */
	if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_BE, sizeof(BOM_UTF32_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32be;
		bom_size = sizeof(BOM_UTF32_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_LE, sizeof(BOM_UTF32_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32le;
		bom_size = sizeof(BOM_UTF32_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_BE, sizeof(BOM_UTF16_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16be;
		bom_size = sizeof(BOM_UTF16_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_LE, sizeof(BOM_UTF16_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16le;
		bom_size = sizeof(BOM_UTF16_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF8, sizeof(BOM_UTF8)-1)) {
		script_encoding = zend_multibyte_encoding_utf8;
		bom_size = sizeof(BOM_UTF8)-1;
	}

	if (script_encoding) {
		/* remove BOM */
		LANG_SCNG(script_org) += bom_size;
		LANG_SCNG(script_org_size) -= bom_size;

		return script_encoding;
	}

	/* script contains NULL bytes -> auto-detection */
	if ((pos1 = memchr(LANG_SCNG(script_org), 0, LANG_SCNG(script_org_size)))) {
		/* check if the NULL byte is after the __HALT_COMPILER(); */
		pos2 = LANG_SCNG(script_org);

		while (pos1 - pos2 >= sizeof("__HALT_COMPILER();")-1) {
			pos2 = memchr(pos2, '_', pos1 - pos2);
			if (!pos2) break;
			pos2++;
			if (strncasecmp((char*)pos2, "_HALT_COMPILER", sizeof("_HALT_COMPILER")-1) == 0) {
				pos2 += sizeof("_HALT_COMPILER")-1;
				while (*pos2 == ' '  ||
					   *pos2 == '\t' ||
					   *pos2 == '\r' ||
					   *pos2 == '\n') {
					pos2++;
				}
				if (*pos2 == '(') {
					pos2++;
					while (*pos2 == ' '  ||
						   *pos2 == '\t' ||
						   *pos2 == '\r' ||
						   *pos2 == '\n') {
						pos2++;
					}
					if (*pos2 == ')') {
						pos2++;
						while (*pos2 == ' '  ||
							   *pos2 == '\t' ||
							   *pos2 == '\r' ||
							   *pos2 == '\n') {
							pos2++;
						}
						if (*pos2 == ';') {
							return NULL;
						}
					}
				}
			}
		}
		/* make best effort if BOM is missing */
		return zend_multibyte_detect_utf_encoding(LANG_SCNG(script_org), LANG_SCNG(script_org_size) TSRMLS_CC);
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_find_script_encoding(TSRMLS_D)
{
	const zend_encoding *script_encoding;

	if (CG(detect_unicode)) {
		/* check out bom(byte order mark) and see if containing wchars */
		script_encoding = zend_multibyte_detect_unicode(TSRMLS_C);
		if (script_encoding != NULL) {
			/* bom or wchar detection is prior to 'script_encoding' option */
			return script_encoding;
		}
	}

	/* if no script_encoding specified, just leave alone */
	if (!CG(script_encoding_list) || !CG(script_encoding_list_size)) {
		return NULL;
	}

	/* if multiple encodings specified, detect automagically */
	if (CG(script_encoding_list_size) > 1) {
		return zend_multibyte_encoding_detector(LANG_SCNG(script_org), LANG_SCNG(script_org_size), CG(script_encoding_list), CG(script_encoding_list_size) TSRMLS_CC);
	}

	return CG(script_encoding_list)[0];
}

ZEND_API int zend_multibyte_set_filter(const zend_encoding *onetime_encoding TSRMLS_DC)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding(TSRMLS_C);
	const zend_encoding *script_encoding = onetime_encoding ? onetime_encoding: zend_multibyte_find_script_encoding(TSRMLS_C);

	if (!script_encoding) {
		return FAILURE;
	}

	/* judge input/output filter */
	LANG_SCNG(script_encoding) = script_encoding;
	LANG_SCNG(input_filter) = NULL;
	LANG_SCNG(output_filter) = NULL;

	if (!internal_encoding || LANG_SCNG(script_encoding) == internal_encoding) {
		if (!zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
			/* and if not, work around w/ script_encoding -> utf-8 -> script_encoding conversion */
			LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
			LANG_SCNG(output_filter) = encoding_filter_intermediate_to_script;
		} else {
			LANG_SCNG(input_filter) = NULL;
			LANG_SCNG(output_filter) = NULL;
		}
		return SUCCESS;
	}

	if (zend_multibyte_check_lexer_compatibility(internal_encoding)) {
		LANG_SCNG(input_filter) = encoding_filter_script_to_internal;
		LANG_SCNG(output_filter) = NULL;
	} else if (zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
		LANG_SCNG(input_filter) = NULL;
		LANG_SCNG(output_filter) = encoding_filter_script_to_internal;
	} else {
		/* both script and internal encodings are incompatible w/ flex */
		LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
		LANG_SCNG(output_filter) = encoding_filter_intermediate_to_internal;
	}

	return 0;
}

ZEND_API int open_file_for_scanning(zend_file_handle *file_handle TSRMLS_DC)
{
	char *file_path = NULL, *buf;
	size_t size, offset = 0;

	/* The shebang line was read, get the current position to obtain the buffer start */
	if (CG(start_lineno) == 2 && file_handle->type == ZEND_HANDLE_FP && file_handle->handle.fp) {
		if ((offset = ftell(file_handle->handle.fp)) == -1) {
			offset = 0;
		}
	}

	if (zend_stream_fixup(file_handle, &buf, &size TSRMLS_CC) == FAILURE) {
		return FAILURE;
	}

	zend_llist_add_element(&CG(open_files), file_handle);
	if (file_handle->handle.stream.handle >= (void*)file_handle && file_handle->handle.stream.handle <= (void*)(file_handle+1)) {
		zend_file_handle *fh = (zend_file_handle*)zend_llist_get_last(&CG(open_files));
		size_t diff = (char*)file_handle->handle.stream.handle - (char*)file_handle;
		fh->handle.stream.handle = (void*)(((char*)fh) + diff);
		file_handle->handle.stream.handle = fh->handle.stream.handle;
	}

	/* Reset the scanner for scanning the new file */
	SCNG(yy_in) = file_handle;
	SCNG(yy_start) = NULL;

	if (size != -1) {
		if (CG(multibyte)) {
			SCNG(script_org) = buf;
			SCNG(script_org_size) = size;
			SCNG(script_filtered) = NULL;

			zend_multibyte_set_filter(NULL TSRMLS_CC);

			if (SCNG(input_filter)) {
				if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size) TSRMLS_CC)) {
					zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
							"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
				}
				buf = SCNG(script_filtered);
				size = SCNG(script_filtered_size);
			}
		}
		SCNG(yy_start) = (unsigned char *)buf - offset;
		yy_scan_buffer(buf, size TSRMLS_CC);
	} else {
		zend_error_noreturn(E_COMPILE_ERROR, "zend_stream_mmap() failed");
	}

	BEGIN(INITIAL);

	if (file_handle->opened_path) {
		file_path = file_handle->opened_path;
	} else {
		file_path = file_handle->filename;
	}

	zend_set_compiled_filename(file_path TSRMLS_CC);

	if (CG(start_lineno)) {
		CG(zend_lineno) = CG(start_lineno);
		CG(start_lineno) = 0;
	} else {
		CG(zend_lineno) = 1;
	}

	CG(increment_lineno) = 0;
	return SUCCESS;
}
END_EXTERN_C()


ZEND_API zend_op_array *compile_file(zend_file_handle *file_handle, int type TSRMLS_DC)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = (zend_op_array *) emalloc(sizeof(zend_op_array));
	zend_op_array *original_active_op_array = CG(active_op_array);
	zend_op_array *retval=NULL;
	int compiler_result;
	zend_bool compilation_successful=0;
	znode retval_znode;
	zend_bool original_in_compilation = CG(in_compilation);

	retval_znode.op_type = IS_CONST;
	retval_znode.u.constant.type = IS_LONG;
	retval_znode.u.constant.value.lval = 1;
	Z_UNSET_ISREF(retval_znode.u.constant);
	Z_SET_REFCOUNT(retval_znode.u.constant, 1);

	zend_save_lexical_state(&original_lex_state TSRMLS_CC);

	retval = op_array; /* success oriented */

	if (open_file_for_scanning(file_handle TSRMLS_CC)==FAILURE) {
		if (type==ZEND_REQUIRE) {
			zend_message_dispatcher(ZMSG_FAILED_REQUIRE_FOPEN, file_handle->filename TSRMLS_CC);
			zend_bailout();
		} else {
			zend_message_dispatcher(ZMSG_FAILED_INCLUDE_FOPEN, file_handle->filename TSRMLS_CC);
		}
		compilation_successful=0;
	} else {
		init_op_array(op_array, ZEND_USER_FUNCTION, INITIAL_OP_ARRAY_SIZE TSRMLS_CC);
		CG(in_compilation) = 1;
		CG(active_op_array) = op_array;
		zend_init_compiler_context(TSRMLS_C);
		compiler_result = zendparse(TSRMLS_C);
		zend_do_return(&retval_znode, 0 TSRMLS_CC);
		CG(in_compilation) = original_in_compilation;
		if (compiler_result==1) { /* parser error */
			zend_bailout();
		}
		compilation_successful=1;
	}

	if (retval) {
		CG(active_op_array) = original_active_op_array;
		if (compilation_successful) {
			pass_two(op_array TSRMLS_CC);
			zend_release_labels(TSRMLS_C);
		} else {
			efree(op_array);
			retval = NULL;
		}
	}
	zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
	return retval;
}


zend_op_array *compile_filename(int type, zval *filename TSRMLS_DC)
{
	zend_file_handle file_handle;
	zval tmp;
	zend_op_array *retval;
	char *opened_path = NULL;

	if (filename->type != IS_STRING) {
		tmp = *filename;
		zval_copy_ctor(&tmp);
		convert_to_string(&tmp);
		filename = &tmp;
	}
	file_handle.filename = filename->value.str.val;
	file_handle.free_filename = 0;
	file_handle.type = ZEND_HANDLE_FILENAME;
	file_handle.opened_path = NULL;
	file_handle.handle.fp = NULL;

	retval = zend_compile_file(&file_handle, type TSRMLS_CC);
	if (retval && file_handle.handle.stream.handle) {
		int dummy = 1;

		if (!file_handle.opened_path) {
			file_handle.opened_path = opened_path = estrndup(filename->value.str.val, filename->value.str.len);
		}

		zend_hash_add(&EG(included_files), file_handle.opened_path, strlen(file_handle.opened_path)+1, (void *)&dummy, sizeof(int), NULL);

		if (opened_path) {
			efree(opened_path);
		}
	}
	zend_destroy_file_handle(&file_handle TSRMLS_CC);

	if (filename==&tmp) {
		zval_dtor(&tmp);
	}
	return retval;
}

ZEND_API int zend_prepare_string_for_scanning(zval *str, char *filename TSRMLS_DC)
{
	char *buf;
	size_t size;

	/* enforce two trailing NULLs for flex... */
	if (IS_INTERNED(str->value.str.val)) {
		char *tmp = safe_emalloc(1, str->value.str.len, ZEND_MMAP_AHEAD);
		memcpy(tmp, str->value.str.val, str->value.str.len + ZEND_MMAP_AHEAD);
		str->value.str.val = tmp;
	} else {
		str->value.str.val = safe_erealloc(str->value.str.val, 1, str->value.str.len, ZEND_MMAP_AHEAD);
	}

	memset(str->value.str.val + str->value.str.len, 0, ZEND_MMAP_AHEAD);

	SCNG(yy_in) = NULL;
	SCNG(yy_start) = NULL;

	buf = str->value.str.val;
	size = str->value.str.len;

	if (CG(multibyte)) {
		SCNG(script_org) = buf;
		SCNG(script_org_size) = size;
		SCNG(script_filtered) = NULL;

		zend_multibyte_set_filter(zend_multibyte_get_internal_encoding(TSRMLS_C) TSRMLS_CC);

		if (SCNG(input_filter)) {
			if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size) TSRMLS_CC)) {
				zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
						"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
			}
			buf = SCNG(script_filtered);
			size = SCNG(script_filtered_size);
		}
	}

	yy_scan_buffer(buf, size TSRMLS_CC);

	zend_set_compiled_filename(filename TSRMLS_CC);
	CG(zend_lineno) = 1;
	CG(increment_lineno) = 0;
	return SUCCESS;
}


ZEND_API size_t zend_get_scanned_file_offset(TSRMLS_D)
{
	size_t offset = SCNG(yy_cursor) - SCNG(yy_start);
	if (SCNG(input_filter)) {
		size_t original_offset = offset, length = 0;
		do {
			unsigned char *p = NULL;
			if ((size_t)-1 == SCNG(input_filter)(&p, &length, SCNG(script_org), offset TSRMLS_CC)) {
				return (size_t)-1;
			}
			efree(p);
			if (length > original_offset) {
				offset--;
			} else if (length < original_offset) {
				offset++;
			}
		} while (original_offset != length);
	}
	return offset;
}


zend_op_array *compile_string(zval *source_string, char *filename TSRMLS_DC)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = (zend_op_array *) emalloc(sizeof(zend_op_array));
	zend_op_array *original_active_op_array = CG(active_op_array);
	zend_op_array *retval;
	zval tmp;
	int compiler_result;
	zend_bool original_in_compilation = CG(in_compilation);

	if (source_string->value.str.len==0) {
		efree(op_array);
		return NULL;
	}

	CG(in_compilation) = 1;

	tmp = *source_string;
	zval_copy_ctor(&tmp);
	convert_to_string(&tmp);
	source_string = &tmp;

	zend_save_lexical_state(&original_lex_state TSRMLS_CC);
	if (zend_prepare_string_for_scanning(source_string, filename TSRMLS_CC)==FAILURE) {
		efree(op_array);
		retval = NULL;
	} else {
		zend_bool orig_interactive = CG(interactive);

		CG(interactive) = 0;
		init_op_array(op_array, ZEND_EVAL_CODE, INITIAL_OP_ARRAY_SIZE TSRMLS_CC);
		CG(interactive) = orig_interactive;
		CG(active_op_array) = op_array;
		zend_init_compiler_context(TSRMLS_C);
		BEGIN(ST_IN_SCRIPTING);
		compiler_result = zendparse(TSRMLS_C);

		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
			SCNG(script_filtered) = NULL;
		}

		if (compiler_result==1) {
			CG(active_op_array) = original_active_op_array;
			CG(unclean_shutdown)=1;
			retval = NULL;
		} else {
			zend_do_return(NULL, 0 TSRMLS_CC);
			CG(active_op_array) = original_active_op_array;
			pass_two(op_array TSRMLS_CC);
			zend_release_labels(TSRMLS_C);
			retval = op_array;
		}
	}
	zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
	zval_dtor(&tmp);
	CG(in_compilation) = original_in_compilation;
	return retval;
}


BEGIN_EXTERN_C()
int highlight_file(char *filename, zend_syntax_highlighter_ini *syntax_highlighter_ini TSRMLS_DC)
{
	zend_lex_state original_lex_state;
	zend_file_handle file_handle;

	file_handle.type = ZEND_HANDLE_FILENAME;
	file_handle.filename = filename;
	file_handle.free_filename = 0;
	file_handle.opened_path = NULL;
	zend_save_lexical_state(&original_lex_state TSRMLS_CC);
	if (open_file_for_scanning(&file_handle TSRMLS_CC)==FAILURE) {
		zend_message_dispatcher(ZMSG_FAILED_HIGHLIGHT_FOPEN, filename TSRMLS_CC);
		zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
		return FAILURE;
	}
	zend_highlight(syntax_highlighter_ini TSRMLS_CC);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_destroy_file_handle(&file_handle TSRMLS_CC);
	zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
	return SUCCESS;
}

int highlight_string(zval *str, zend_syntax_highlighter_ini *syntax_highlighter_ini, char *str_name TSRMLS_DC)
{
	zend_lex_state original_lex_state;
	zval tmp = *str;

	str = &tmp;
	zval_copy_ctor(str);
	zend_save_lexical_state(&original_lex_state TSRMLS_CC);
	if (zend_prepare_string_for_scanning(str, str_name TSRMLS_CC)==FAILURE) {
		zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
		return FAILURE;
	}
	BEGIN(INITIAL);
	zend_highlight(syntax_highlighter_ini TSRMLS_CC);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
	zval_dtor(str);
	return SUCCESS;
}

ZEND_API void zend_multibyte_yyinput_again(zend_encoding_filter old_input_filter, zend_encoding *old_encoding TSRMLS_DC)
{
	size_t length;
	unsigned char *new_yy_start;

	/* convert and set */
	if (!SCNG(input_filter)) {
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
			SCNG(script_filtered) = NULL;
		}
		SCNG(script_filtered_size) = 0;
		length = SCNG(script_org_size);
		new_yy_start = SCNG(script_org);
	} else {
		if ((size_t)-1 == SCNG(input_filter)(&new_yy_start, &length, SCNG(script_org), SCNG(script_org_size) TSRMLS_CC)) {
			zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
					"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
		}
		SCNG(script_filtered) = new_yy_start;
		SCNG(script_filtered_size) = length;
	}

	SCNG(yy_cursor) = new_yy_start + (SCNG(yy_cursor) - SCNG(yy_start));
	SCNG(yy_marker) = new_yy_start + (SCNG(yy_marker) - SCNG(yy_start));
	SCNG(yy_text) = new_yy_start + (SCNG(yy_text) - SCNG(yy_start));
	SCNG(yy_limit) = new_yy_start + (SCNG(yy_limit) - SCNG(yy_start));

	SCNG(yy_start) = new_yy_start;
}


# define zend_copy_value(zendlval, yytext, yyleng) \
	if (SCNG(output_filter)) { \
		size_t sz = 0; \
		SCNG(output_filter)((unsigned char **)&(zendlval->value.str.val), &sz, (unsigned char *)yytext, (size_t)yyleng TSRMLS_CC); \
		zendlval->value.str.len = sz; \
	} else { \
		zendlval->value.str.val = (char *) estrndup(yytext, yyleng); \
		zendlval->value.str.len = yyleng; \
	}

static void zend_scan_escape_string(zval *zendlval, char *str, int len, char quote_type TSRMLS_DC)
{
	register char *s, *t;
	char *end;

	ZVAL_STRINGL(zendlval, str, len, 1);

	/* convert escape sequences */
	s = t = zendlval->value.str.val;
	end = s+zendlval->value.str.len;
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				break;
			}

			switch(*s) {
				case 'n':
					*t++ = '\n';
					zendlval->value.str.len--;
					break;
				case 'r':
					*t++ = '\r';
					zendlval->value.str.len--;
					break;
				case 't':
					*t++ = '\t';
					zendlval->value.str.len--;
					break;
				case 'f':
					*t++ = '\f';
					zendlval->value.str.len--;
					break;
				case 'v':
					*t++ = '\v';
					zendlval->value.str.len--;
					break;
				case '"':
				case '`':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
				case '\\':
				case '$':
					*t++ = *s;
					zendlval->value.str.len--;
					break;
				case 'x':
				case 'X':
					if (ZEND_IS_HEX(*(s+1))) {
						char hex_buf[3] = { 0, 0, 0 };

						zendlval->value.str.len--; /* for the 'x' */

						hex_buf[0] = *(++s);
						zendlval->value.str.len--;
						if (ZEND_IS_HEX(*(s+1))) {
							hex_buf[1] = *(++s);
							zendlval->value.str.len--;
						}
						*t++ = (char) strtol(hex_buf, NULL, 16);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
				default:
					/* check for an octal */
					if (ZEND_IS_OCT(*s)) {
						char octal_buf[4] = { 0, 0, 0, 0 };

						octal_buf[0] = *s;
						zendlval->value.str.len--;
						if (ZEND_IS_OCT(*(s+1))) {
							octal_buf[1] = *(++s);
							zendlval->value.str.len--;
							if (ZEND_IS_OCT(*(s+1))) {
								octal_buf[2] = *(++s);
								zendlval->value.str.len--;
							}
						}
						*t++ = (char) strtol(octal_buf, NULL, 8);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
	if (SCNG(output_filter)) {
		size_t sz = 0;
		s = zendlval->value.str.val;
		SCNG(output_filter)((unsigned char **)&(zendlval->value.str.val), &sz, (unsigned char *)s, (size_t)zendlval->value.str.len TSRMLS_CC);
		zendlval->value.str.len = sz;
		efree(s);
	}
}


int lex_scan(zval *zendlval TSRMLS_DC)
{
restart:
	SCNG(yy_text) = YYCURSOR;

yymore_restart:


#line 986 "Zend/zend_language_scanner.c"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if (YYGETCONDITION() < 5) {
		if (YYGETCONDITION() < 2) {
			if (YYGETCONDITION() < 1) {
				goto yyc_ST_IN_SCRIPTING;
			} else {
				goto yyc_ST_LOOKING_FOR_PROPERTY;
			}
		} else {
			if (YYGETCONDITION() < 3) {
				goto yyc_ST_BACKQUOTE;
			} else {
				if (YYGETCONDITION() < 4) {
					goto yyc_ST_DOUBLE_QUOTES;
				} else {
					goto yyc_ST_HEREDOC;
				}
			}
		}
	} else {
		if (YYGETCONDITION() < 7) {
			if (YYGETCONDITION() < 6) {
				goto yyc_ST_LOOKING_FOR_VARNAME;
			} else {
				goto yyc_ST_VAR_OFFSET;
			}
		} else {
			if (YYGETCONDITION() < 8) {
				goto yyc_INITIAL;
			} else {
				if (YYGETCONDITION() < 9) {
					goto yyc_ST_END_HEREDOC;
				} else {
					goto yyc_ST_NOWDOC;
				}
			}
		}
	}
/* *********************************** */
yyc_INITIAL:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128,   0,   0, 128,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};

		YYDEBUG(0, *YYCURSOR);
		YYFILL(8);
		yych = *YYCURSOR;
		if (yych != '<') goto yy4;
		YYDEBUG(2, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '?') {
			if (yych == '%') goto yy7;
			if (yych >= '?') goto yy5;
		} else {
			if (yych <= 'S') {
				if (yych >= 'S') goto yy9;
			} else {
				if (yych == 's') goto yy9;
			}
		}
yy3:
		YYDEBUG(3, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1718 "Zend/zend_language_scanner.l"
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

inline_char_handler:

	while (1) {
		YYCTYPE *ptr = memchr(YYCURSOR, '<', YYLIMIT - YYCURSOR);

		YYCURSOR = ptr ? ptr + 1 : YYLIMIT;

		if (YYCURSOR < YYLIMIT) {
			switch (*YYCURSOR) {
				case '?':
					if (CG(short_tags) || !strncasecmp(YYCURSOR + 1, "php", 3)) { /* Assume [ \t\n\r] follows "php" */
						break;
					}
					continue;
				case '%':
					if (CG(asp_tags)) {
						break;
					}
					continue;
				case 's':
				case 'S':
					/* Probably NOT an opening PHP <script> tag, so don't end the HTML chunk yet
					 * If it is, the PHP <script> tag rule checks for any HTML scanned before it */
					YYCURSOR--;
					yymore();
				default:
					continue;
			}

			YYCURSOR--;
		}

		break;
	}

inline_html:
	yyleng = YYCURSOR - SCNG(yy_text);

	if (SCNG(output_filter)) {
		int readsize;
		size_t sz = 0;
		readsize = SCNG(output_filter)((unsigned char **)&(zendlval->value.str.val), &sz, (unsigned char *)yytext, (size_t)yyleng TSRMLS_CC);
		zendlval->value.str.len = sz;
		if (readsize < yyleng) {
			yyless(readsize);
		}
	} else {
	  zendlval->value.str.val = (char *) estrndup(yytext, yyleng);
	  zendlval->value.str.len = yyleng;
	}
	zendlval->type = IS_STRING;
	HANDLE_NEWLINES(yytext, yyleng);
	return T_INLINE_HTML;
}
#line 1145 "Zend/zend_language_scanner.c"
yy4:
		YYDEBUG(4, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy3;
yy5:
		YYDEBUG(5, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych == '=') goto yy45;
		} else {
			if (yych <= 'P') goto yy47;
			if (yych == 'p') goto yy47;
		}
yy6:
		YYDEBUG(6, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1706 "Zend/zend_language_scanner.l"
		{
	if (CG(short_tags)) {
		zendlval->value.str.val = yytext; /* no copying - intentional */
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
		BEGIN(ST_IN_SCRIPTING);
		return T_OPEN_TAG;
	} else {
		goto inline_char_handler;
	}
}
#line 1175 "Zend/zend_language_scanner.c"
yy7:
		YYDEBUG(7, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy43;
		YYDEBUG(8, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1683 "Zend/zend_language_scanner.l"
		{
	if (CG(asp_tags)) {
		zendlval->value.str.val = yytext; /* no copying - intentional */
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
		BEGIN(ST_IN_SCRIPTING);
		return T_OPEN_TAG;
	} else {
		goto inline_char_handler;
	}
}
#line 1194 "Zend/zend_language_scanner.c"
yy9:
		YYDEBUG(9, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy11;
		if (yych == 'c') goto yy11;
yy10:
		YYDEBUG(10, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 0) {
			goto yy3;
		} else {
			goto yy6;
		}
yy11:
		YYDEBUG(11, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy12;
		if (yych != 'r') goto yy10;
yy12:
		YYDEBUG(12, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy13;
		if (yych != 'i') goto yy10;
yy13:
		YYDEBUG(13, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy14;
		if (yych != 'p') goto yy10;
yy14:
		YYDEBUG(14, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy15;
		if (yych != 't') goto yy10;
yy15:
		YYDEBUG(15, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy10;
		if (yych == 'l') goto yy10;
		goto yy17;
yy16:
		YYDEBUG(16, *YYCURSOR);
		++YYCURSOR;
		YYFILL(8);
		yych = *YYCURSOR;
yy17:
		YYDEBUG(17, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy16;
		}
		if (yych == 'L') goto yy18;
		if (yych != 'l') goto yy10;
yy18:
		YYDEBUG(18, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy19;
		if (yych != 'a') goto yy10;
yy19:
		YYDEBUG(19, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy20;
		if (yych != 'n') goto yy10;
yy20:
		YYDEBUG(20, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy21;
		if (yych != 'g') goto yy10;
yy21:
		YYDEBUG(21, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy22;
		if (yych != 'u') goto yy10;
yy22:
		YYDEBUG(22, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy23;
		if (yych != 'a') goto yy10;
yy23:
		YYDEBUG(23, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy24;
		if (yych != 'g') goto yy10;
yy24:
		YYDEBUG(24, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy25;
		if (yych != 'e') goto yy10;
yy25:
		YYDEBUG(25, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(26, *YYCURSOR);
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy10;
			if (yych <= '\n') goto yy25;
			if (yych <= '\f') goto yy10;
			goto yy25;
		} else {
			if (yych <= ' ') {
				if (yych <= 0x1F) goto yy10;
				goto yy25;
			} else {
				if (yych != '=') goto yy10;
			}
		}
yy27:
		YYDEBUG(27, *YYCURSOR);
		++YYCURSOR;
		YYFILL(5);
		yych = *YYCURSOR;
		YYDEBUG(28, *YYCURSOR);
		if (yych <= '!') {
			if (yych <= '\f') {
				if (yych <= 0x08) goto yy10;
				if (yych <= '\n') goto yy27;
				goto yy10;
			} else {
				if (yych <= '\r') goto yy27;
				if (yych == ' ') goto yy27;
				goto yy10;
			}
		} else {
			if (yych <= 'O') {
				if (yych <= '"') goto yy30;
				if (yych == '\'') goto yy31;
				goto yy10;
			} else {
				if (yych <= 'P') goto yy29;
				if (yych != 'p') goto yy10;
			}
		}
yy29:
		YYDEBUG(29, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy42;
		if (yych == 'h') goto yy42;
		goto yy10;
yy30:
		YYDEBUG(30, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy39;
		if (yych == 'p') goto yy39;
		goto yy10;
yy31:
		YYDEBUG(31, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy32;
		if (yych != 'p') goto yy10;
yy32:
		YYDEBUG(32, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy33;
		if (yych != 'h') goto yy10;
yy33:
		YYDEBUG(33, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy34;
		if (yych != 'p') goto yy10;
yy34:
		YYDEBUG(34, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '\'') goto yy10;
yy35:
		YYDEBUG(35, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(36, *YYCURSOR);
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy10;
			if (yych <= '\n') goto yy35;
			if (yych <= '\f') goto yy10;
			goto yy35;
		} else {
			if (yych <= ' ') {
				if (yych <= 0x1F) goto yy10;
				goto yy35;
			} else {
				if (yych != '>') goto yy10;
			}
		}
		YYDEBUG(37, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(38, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1639 "Zend/zend_language_scanner.l"
		{
	YYCTYPE *bracket = zend_memrchr(yytext, '<', yyleng - (sizeof("script language=php>") - 1));

	if (bracket != SCNG(yy_text)) {
		/* Handle previously scanned HTML, as possible <script> tags found are assumed to not be PHP's */
		YYCURSOR = bracket;
		goto inline_html;
	}

	HANDLE_NEWLINES(yytext, yyleng);
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	BEGIN(ST_IN_SCRIPTING);
	return T_OPEN_TAG;
}
#line 1397 "Zend/zend_language_scanner.c"
yy39:
		YYDEBUG(39, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy40;
		if (yych != 'h') goto yy10;
yy40:
		YYDEBUG(40, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy41;
		if (yych != 'p') goto yy10;
yy41:
		YYDEBUG(41, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '"') goto yy35;
		goto yy10;
yy42:
		YYDEBUG(42, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy35;
		if (yych == 'p') goto yy35;
		goto yy10;
yy43:
		YYDEBUG(43, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(44, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1657 "Zend/zend_language_scanner.l"
		{
	if (CG(asp_tags)) {
		zendlval->value.str.val = yytext; /* no copying - intentional */
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
		BEGIN(ST_IN_SCRIPTING);
		return T_OPEN_TAG_WITH_ECHO;
	} else {
		goto inline_char_handler;
	}
}
#line 1436 "Zend/zend_language_scanner.c"
yy45:
		YYDEBUG(45, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(46, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1670 "Zend/zend_language_scanner.l"
		{
	if (CG(short_tags)) {
		zendlval->value.str.val = yytext; /* no copying - intentional */
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
		BEGIN(ST_IN_SCRIPTING);
		return T_OPEN_TAG_WITH_ECHO;
	} else {
		goto inline_char_handler;
	}
}
#line 1454 "Zend/zend_language_scanner.c"
yy47:
		YYDEBUG(47, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy48;
		if (yych != 'h') goto yy10;
yy48:
		YYDEBUG(48, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy49;
		if (yych != 'p') goto yy10;
yy49:
		YYDEBUG(49, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy10;
			if (yych >= '\v') goto yy10;
		} else {
			if (yych <= '\r') goto yy52;
			if (yych != ' ') goto yy10;
		}
yy50:
		YYDEBUG(50, *YYCURSOR);
		++YYCURSOR;
yy51:
		YYDEBUG(51, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1696 "Zend/zend_language_scanner.l"
		{
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	HANDLE_NEWLINE(yytext[yyleng-1]);
	BEGIN(ST_IN_SCRIPTING);
	return T_OPEN_TAG;
}
#line 1490 "Zend/zend_language_scanner.c"
yy52:
		YYDEBUG(52, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy50;
		goto yy51;
	}
/* *********************************** */
yyc_ST_BACKQUOTE:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(53, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych != '$') goto yy60;
		} else {
			if (yych <= '`') goto yy58;
			if (yych == '{') goto yy57;
			goto yy60;
		}
		YYDEBUG(55, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy56;
			if (yych <= 'Z') goto yy63;
			if (yych >= '_') goto yy63;
		} else {
			if (yych <= 'z') {
				if (yych >= 'a') goto yy63;
			} else {
				if (yych <= '{') goto yy66;
				if (yych >= 0x7F) goto yy63;
			}
		}
yy56:
		YYDEBUG(56, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2169 "Zend/zend_language_scanner.l"
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '`':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng, '`' TSRMLS_CC);
	return T_ENCAPSED_AND_WHITESPACE;
}
#line 1602 "Zend/zend_language_scanner.c"
yy57:
		YYDEBUG(57, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy61;
		goto yy56;
yy58:
		YYDEBUG(58, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(59, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2113 "Zend/zend_language_scanner.l"
		{
	BEGIN(ST_IN_SCRIPTING);
	return '`';
}
#line 1618 "Zend/zend_language_scanner.c"
yy60:
		YYDEBUG(60, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy56;
yy61:
		YYDEBUG(61, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(62, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2100 "Zend/zend_language_scanner.l"
		{
	zendlval->value.lval = (long) '{';
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	yyless(1);
	return T_CURLY_OPEN;
}
#line 1635 "Zend/zend_language_scanner.c"
yy63:
		YYDEBUG(63, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(64, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy63;
		}
		if (yych == '-') goto yy68;
		if (yych == '[') goto yy70;
yy65:
		YYDEBUG(65, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1800 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 1657 "Zend/zend_language_scanner.c"
yy66:
		YYDEBUG(66, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(67, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1432 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME TSRMLS_CC);
	return T_DOLLAR_OPEN_CURLY_BRACES;
}
#line 1668 "Zend/zend_language_scanner.c"
yy68:
		YYDEBUG(68, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy72;
yy69:
		YYDEBUG(69, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy65;
yy70:
		YYDEBUG(70, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(71, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1792 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 1690 "Zend/zend_language_scanner.c"
yy72:
		YYDEBUG(72, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy69;
			if (yych <= 'Z') goto yy73;
			if (yych <= '^') goto yy69;
		} else {
			if (yych <= '`') goto yy69;
			if (yych <= 'z') goto yy73;
			if (yych <= '~') goto yy69;
		}
yy73:
		YYDEBUG(73, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(74, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1782 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 1716 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(75, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '#') {
			if (yych == '"') goto yy80;
			goto yy82;
		} else {
			if (yych <= '$') goto yy77;
			if (yych == '{') goto yy79;
			goto yy82;
		}
yy77:
		YYDEBUG(77, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy78;
			if (yych <= 'Z') goto yy85;
			if (yych >= '_') goto yy85;
		} else {
			if (yych <= 'z') {
				if (yych >= 'a') goto yy85;
			} else {
				if (yych <= '{') goto yy88;
				if (yych >= 0x7F) goto yy85;
			}
		}
yy78:
		YYDEBUG(78, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2119 "Zend/zend_language_scanner.l"
		{
	if (GET_DOUBLE_QUOTES_SCANNED_LENGTH()) {
		YYCURSOR += GET_DOUBLE_QUOTES_SCANNED_LENGTH() - 1;
		SET_DOUBLE_QUOTES_SCANNED_LENGTH(0);

		goto double_quotes_scan_done;
	}

	if (YYCURSOR > YYLIMIT) {
		return 0;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

double_quotes_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng, '"' TSRMLS_CC);
	return T_ENCAPSED_AND_WHITESPACE;
}
#line 1833 "Zend/zend_language_scanner.c"
yy79:
		YYDEBUG(79, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy83;
		goto yy78;
yy80:
		YYDEBUG(80, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(81, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2108 "Zend/zend_language_scanner.l"
		{
	BEGIN(ST_IN_SCRIPTING);
	return '"';
}
#line 1849 "Zend/zend_language_scanner.c"
yy82:
		YYDEBUG(82, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy78;
yy83:
		YYDEBUG(83, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(84, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2100 "Zend/zend_language_scanner.l"
		{
	zendlval->value.lval = (long) '{';
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	yyless(1);
	return T_CURLY_OPEN;
}
#line 1866 "Zend/zend_language_scanner.c"
yy85:
		YYDEBUG(85, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(86, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy85;
		}
		if (yych == '-') goto yy90;
		if (yych == '[') goto yy92;
yy87:
		YYDEBUG(87, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1800 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 1888 "Zend/zend_language_scanner.c"
yy88:
		YYDEBUG(88, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(89, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1432 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME TSRMLS_CC);
	return T_DOLLAR_OPEN_CURLY_BRACES;
}
#line 1899 "Zend/zend_language_scanner.c"
yy90:
		YYDEBUG(90, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy94;
yy91:
		YYDEBUG(91, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy87;
yy92:
		YYDEBUG(92, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(93, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1792 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 1921 "Zend/zend_language_scanner.c"
yy94:
		YYDEBUG(94, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy91;
			if (yych <= 'Z') goto yy95;
			if (yych <= '^') goto yy91;
		} else {
			if (yych <= '`') goto yy91;
			if (yych <= 'z') goto yy95;
			if (yych <= '~') goto yy91;
		}
yy95:
		YYDEBUG(95, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(96, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1782 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 1947 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_END_HEREDOC:
	YYDEBUG(97, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(99, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(100, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
#line 2087 "Zend/zend_language_scanner.l"
	{
	YYCURSOR += CG(heredoc_len) - 1;
	yyleng = CG(heredoc_len);

	Z_STRVAL_P(zendlval) = CG(heredoc);
	Z_STRLEN_P(zendlval) = CG(heredoc_len);
	CG(heredoc) = NULL;
	CG(heredoc_len) = 0;
	BEGIN(ST_IN_SCRIPTING);
	return T_END_HEREDOC;
}
#line 1970 "Zend/zend_language_scanner.c"
/* *********************************** */
yyc_ST_HEREDOC:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(101, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '$') goto yy103;
		if (yych == '{') goto yy105;
		goto yy106;
yy103:
		YYDEBUG(103, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy104;
			if (yych <= 'Z') goto yy109;
			if (yych >= '_') goto yy109;
		} else {
			if (yych <= 'z') {
				if (yych >= 'a') goto yy109;
			} else {
				if (yych <= '{') goto yy112;
				if (yych >= 0x7F) goto yy109;
			}
		}
yy104:
		YYDEBUG(104, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2211 "Zend/zend_language_scanner.l"
		{
	int newline = 0;

	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && CG(heredoc_len) < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, CG(heredoc), CG(heredoc_len))) {
					YYCTYPE *end = YYCURSOR + CG(heredoc_len);

					if (*end == ';') {
						end++;
					}

					if (*end == '\n' || *end == '\r') {
						/* newline before label will be subtracted from returned text, but
						 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
						if (YYCURSOR[-2] == '\r' && YYCURSOR[-1] == '\n') {
							newline = 2; /* Windows newline */
						} else {
							newline = 1;
						}

						CG(increment_lineno) = 1; /* For newline before label */
						BEGIN(ST_END_HEREDOC);

						goto heredoc_scan_done;
					}
				}
				continue;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '\n' && *YYCURSOR != '\r') {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

heredoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng - newline, 0 TSRMLS_CC);
	return T_ENCAPSED_AND_WHITESPACE;
}
#line 2103 "Zend/zend_language_scanner.c"
yy105:
		YYDEBUG(105, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy107;
		goto yy104;
yy106:
		YYDEBUG(106, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy104;
yy107:
		YYDEBUG(107, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(108, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2100 "Zend/zend_language_scanner.l"
		{
	zendlval->value.lval = (long) '{';
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	yyless(1);
	return T_CURLY_OPEN;
}
#line 2125 "Zend/zend_language_scanner.c"
yy109:
		YYDEBUG(109, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(110, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy109;
		}
		if (yych == '-') goto yy114;
		if (yych == '[') goto yy116;
yy111:
		YYDEBUG(111, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1800 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 2147 "Zend/zend_language_scanner.c"
yy112:
		YYDEBUG(112, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(113, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1432 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME TSRMLS_CC);
	return T_DOLLAR_OPEN_CURLY_BRACES;
}
#line 2158 "Zend/zend_language_scanner.c"
yy114:
		YYDEBUG(114, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy118;
yy115:
		YYDEBUG(115, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy111;
yy116:
		YYDEBUG(116, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(117, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1792 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 2180 "Zend/zend_language_scanner.c"
yy118:
		YYDEBUG(118, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy115;
			if (yych <= 'Z') goto yy119;
			if (yych <= '^') goto yy115;
		} else {
			if (yych <= '`') goto yy115;
			if (yych <= 'z') goto yy119;
			if (yych <= '~') goto yy115;
		}
yy119:
		YYDEBUG(119, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(120, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1782 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 2206 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_IN_SCRIPTING:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 192,  64,   0,   0,  64,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			192,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 56,  56,  56,  56,  56,  56,  56,  56, 
			 56,  56,   0,   0,   0,   0,   0,   0, 
			  0,  40,  40,  40,  40,  40,  40,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   0,   0,   0,   0,   8, 
			  0,  40,  40,  40,  40,  40,  40,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   0,   0,   0,   0,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
		};
		YYDEBUG(121, *YYCURSOR);
		YYFILL(16);
		yych = *YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case 0x00:
		case 0x01:
		case 0x02:
		case 0x03:
		case 0x04:
		case 0x05:
		case 0x06:
		case 0x07:
		case 0x08:
		case '\v':
		case '\f':
		case 0x0E:
		case 0x0F:
		case 0x10:
		case 0x11:
		case 0x12:
		case 0x13:
		case 0x14:
		case 0x15:
		case 0x16:
		case 0x17:
		case 0x18:
		case 0x19:
		case 0x1A:
		case 0x1B:
		case 0x1C:
		case 0x1D:
		case 0x1E:
		case 0x1F:	goto yy183;
		case '\t':
		case '\n':
		case '\r':
		case ' ':	goto yy139;
		case '!':	goto yy152;
		case '"':	goto yy179;
		case '#':	goto yy175;
		case '$':	goto yy164;
		case '%':	goto yy158;
		case '&':	goto yy159;
		case '\'':	goto yy177;
		case '(':	goto yy146;
		case ')':
		case ',':
		case ';':
		case '@':
		case '[':
		case ']':
		case '~':	goto yy165;
		case '*':	goto yy155;
		case '+':	goto yy151;
		case '-':	goto yy137;
		case '.':	goto yy157;
		case '/':	goto yy156;
		case '0':	goto yy171;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy173;
		case ':':	goto yy141;
		case '<':	goto yy153;
		case '=':	goto yy149;
		case '>':	goto yy154;
		case '?':	goto yy166;
		case 'A':
		case 'a':	goto yy132;
		case 'B':
		case 'b':	goto yy134;
		case 'C':
		case 'c':	goto yy127;
		case 'D':
		case 'd':	goto yy125;
		case 'E':
		case 'e':	goto yy123;
		case 'F':
		case 'f':	goto yy126;
		case 'G':
		case 'g':	goto yy135;
		case 'I':
		case 'i':	goto yy130;
		case 'L':
		case 'l':	goto yy150;
		case 'N':
		case 'n':	goto yy144;
		case 'O':
		case 'o':	goto yy162;
		case 'P':
		case 'p':	goto yy136;
		case 'R':
		case 'r':	goto yy128;
		case 'S':
		case 's':	goto yy133;
		case 'T':
		case 't':	goto yy129;
		case 'U':
		case 'u':	goto yy147;
		case 'V':
		case 'v':	goto yy145;
		case 'W':
		case 'w':	goto yy131;
		case 'X':
		case 'x':	goto yy163;
		case '\\':	goto yy142;
		case '^':	goto yy161;
		case '_':	goto yy148;
		case '`':	goto yy181;
		case '{':	goto yy167;
		case '|':	goto yy160;
		case '}':	goto yy169;
		default:	goto yy174;
		}
yy123:
		YYDEBUG(123, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(-1, yych);
		switch ((yych = *YYCURSOR)) {
		case 'C':
		case 'c':	goto yy715;
		case 'L':
		case 'l':	goto yy716;
		case 'M':
		case 'm':	goto yy717;
		case 'N':
		case 'n':	goto yy718;
		case 'V':
		case 'v':	goto yy719;
		case 'X':
		case 'x':	goto yy720;
		default:	goto yy186;
		}
yy124:
		YYDEBUG(124, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1823 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, yytext, yyleng);
	zendlval->type = IS_STRING;
	return T_STRING;
}
#line 2393 "Zend/zend_language_scanner.c"
yy125:
		YYDEBUG(125, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych <= 'H') {
				if (yych == 'E') goto yy697;
				goto yy186;
			} else {
				if (yych <= 'I') goto yy698;
				if (yych <= 'N') goto yy186;
				goto yy699;
			}
		} else {
			if (yych <= 'h') {
				if (yych == 'e') goto yy697;
				goto yy186;
			} else {
				if (yych <= 'i') goto yy698;
				if (yych == 'o') goto yy699;
				goto yy186;
			}
		}
yy126:
		YYDEBUG(126, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych <= 'N') {
				if (yych == 'I') goto yy676;
				goto yy186;
			} else {
				if (yych <= 'O') goto yy677;
				if (yych <= 'T') goto yy186;
				goto yy678;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'i') goto yy676;
				goto yy186;
			} else {
				if (yych <= 'o') goto yy677;
				if (yych == 'u') goto yy678;
				goto yy186;
			}
		}
yy127:
		YYDEBUG(127, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych <= 'K') {
				if (yych == 'A') goto yy648;
				goto yy186;
			} else {
				if (yych <= 'L') goto yy649;
				if (yych <= 'N') goto yy186;
				goto yy650;
			}
		} else {
			if (yych <= 'k') {
				if (yych == 'a') goto yy648;
				goto yy186;
			} else {
				if (yych <= 'l') goto yy649;
				if (yych == 'o') goto yy650;
				goto yy186;
			}
		}
yy128:
		YYDEBUG(128, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy630;
		if (yych == 'e') goto yy630;
		goto yy186;
yy129:
		YYDEBUG(129, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'R') {
			if (yych == 'H') goto yy618;
			if (yych <= 'Q') goto yy186;
			goto yy619;
		} else {
			if (yych <= 'h') {
				if (yych <= 'g') goto yy186;
				goto yy618;
			} else {
				if (yych == 'r') goto yy619;
				goto yy186;
			}
		}
yy130:
		YYDEBUG(130, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'S') {
			if (yych <= 'L') {
				if (yych == 'F') goto yy565;
				goto yy186;
			} else {
				if (yych <= 'M') goto yy567;
				if (yych <= 'N') goto yy568;
				if (yych <= 'R') goto yy186;
				goto yy569;
			}
		} else {
			if (yych <= 'm') {
				if (yych == 'f') goto yy565;
				if (yych <= 'l') goto yy186;
				goto yy567;
			} else {
				if (yych <= 'n') goto yy568;
				if (yych == 's') goto yy569;
				goto yy186;
			}
		}
yy131:
		YYDEBUG(131, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy560;
		if (yych == 'h') goto yy560;
		goto yy186;
yy132:
		YYDEBUG(132, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'S') {
			if (yych <= 'M') {
				if (yych == 'B') goto yy542;
				goto yy186;
			} else {
				if (yych <= 'N') goto yy543;
				if (yych <= 'Q') goto yy186;
				if (yych <= 'R') goto yy544;
				goto yy545;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'b') goto yy542;
				if (yych <= 'm') goto yy186;
				goto yy543;
			} else {
				if (yych <= 'q') goto yy186;
				if (yych <= 'r') goto yy544;
				if (yych <= 's') goto yy545;
				goto yy186;
			}
		}
yy133:
		YYDEBUG(133, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'W') {
			if (yych == 'T') goto yy530;
			if (yych <= 'V') goto yy186;
			goto yy531;
		} else {
			if (yych <= 't') {
				if (yych <= 's') goto yy186;
				goto yy530;
			} else {
				if (yych == 'w') goto yy531;
				goto yy186;
			}
		}
yy134:
		YYDEBUG(134, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') {
			if (yych <= '"') {
				if (yych <= '!') goto yy186;
				goto yy522;
			} else {
				if (yych == '\'') goto yy523;
				goto yy186;
			}
		} else {
			if (yych <= 'R') {
				if (yych <= '<') goto yy521;
				if (yych <= 'Q') goto yy186;
				goto yy524;
			} else {
				if (yych == 'r') goto yy524;
				goto yy186;
			}
		}
yy135:
		YYDEBUG(135, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'L') goto yy511;
			if (yych <= 'N') goto yy186;
			goto yy512;
		} else {
			if (yych <= 'l') {
				if (yych <= 'k') goto yy186;
				goto yy511;
			} else {
				if (yych == 'o') goto yy512;
				goto yy186;
			}
		}
yy136:
		YYDEBUG(136, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych == 'R') goto yy487;
			if (yych <= 'T') goto yy186;
			goto yy488;
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy186;
				goto yy487;
			} else {
				if (yych == 'u') goto yy488;
				goto yy186;
			}
		}
yy137:
		YYDEBUG(137, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '<') {
			if (yych == '-') goto yy483;
		} else {
			if (yych <= '=') goto yy481;
			if (yych <= '>') goto yy485;
		}
yy138:
		YYDEBUG(138, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1421 "Zend/zend_language_scanner.l"
		{
	return yytext[0];
}
#line 2623 "Zend/zend_language_scanner.c"
yy139:
		YYDEBUG(139, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy480;
yy140:
		YYDEBUG(140, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1152 "Zend/zend_language_scanner.l"
		{
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	HANDLE_NEWLINES(yytext, yyleng);
	return T_WHITESPACE;
}
#line 2640 "Zend/zend_language_scanner.c"
yy141:
		YYDEBUG(141, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == ':') goto yy477;
		goto yy138;
yy142:
		YYDEBUG(142, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(143, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1181 "Zend/zend_language_scanner.l"
		{
	return T_NS_SEPARATOR;
}
#line 2655 "Zend/zend_language_scanner.c"
yy144:
		YYDEBUG(144, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'E') {
			if (yych == 'A') goto yy465;
			if (yych <= 'D') goto yy186;
			goto yy466;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy186;
				goto yy465;
			} else {
				if (yych == 'e') goto yy466;
				goto yy186;
			}
		}
yy145:
		YYDEBUG(145, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy462;
		if (yych == 'a') goto yy462;
		goto yy186;
yy146:
		YYDEBUG(146, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'D') {
				if (yych <= ' ') {
					if (yych == '\t') goto yy379;
					if (yych <= 0x1F) goto yy138;
					goto yy379;
				} else {
					if (yych <= '@') goto yy138;
					if (yych == 'C') goto yy138;
					goto yy379;
				}
			} else {
				if (yych <= 'I') {
					if (yych == 'F') goto yy379;
					if (yych <= 'H') goto yy138;
					goto yy379;
				} else {
					if (yych == 'O') goto yy379;
					if (yych <= 'Q') goto yy138;
					goto yy379;
				}
			}
		} else {
			if (yych <= 'f') {
				if (yych <= 'b') {
					if (yych == 'U') goto yy379;
					if (yych <= '`') goto yy138;
					goto yy379;
				} else {
					if (yych == 'd') goto yy379;
					if (yych <= 'e') goto yy138;
					goto yy379;
				}
			} else {
				if (yych <= 'o') {
					if (yych == 'i') goto yy379;
					if (yych <= 'n') goto yy138;
					goto yy379;
				} else {
					if (yych <= 's') {
						if (yych <= 'q') goto yy138;
						goto yy379;
					} else {
						if (yych == 'u') goto yy379;
						goto yy138;
					}
				}
			}
		}
yy147:
		YYDEBUG(147, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'S') {
			if (yych == 'N') goto yy370;
			if (yych <= 'R') goto yy186;
			goto yy371;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy186;
				goto yy370;
			} else {
				if (yych == 's') goto yy371;
				goto yy186;
			}
		}
yy148:
		YYDEBUG(148, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy296;
		goto yy186;
yy149:
		YYDEBUG(149, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy138;
		if (yych <= '=') goto yy290;
		if (yych <= '>') goto yy292;
		goto yy138;
yy150:
		YYDEBUG(150, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy286;
		if (yych == 'i') goto yy286;
		goto yy186;
yy151:
		YYDEBUG(151, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '+') goto yy284;
		if (yych == '=') goto yy282;
		goto yy138;
yy152:
		YYDEBUG(152, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy279;
		goto yy138;
yy153:
		YYDEBUG(153, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') {
			if (yych == '/') goto yy251;
			goto yy138;
		} else {
			if (yych <= '<') goto yy249;
			if (yych <= '=') goto yy252;
			if (yych <= '>') goto yy254;
			goto yy138;
		}
yy154:
		YYDEBUG(154, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy138;
		if (yych <= '=') goto yy245;
		if (yych <= '>') goto yy243;
		goto yy138;
yy155:
		YYDEBUG(155, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy241;
		goto yy138;
yy156:
		YYDEBUG(156, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '.') {
			if (yych == '*') goto yy233;
			goto yy138;
		} else {
			if (yych <= '/') goto yy235;
			if (yych == '=') goto yy236;
			goto yy138;
		}
yy157:
		YYDEBUG(157, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '/') goto yy138;
		if (yych <= '9') goto yy229;
		if (yych == '=') goto yy231;
		goto yy138;
yy158:
		YYDEBUG(158, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy138;
		if (yych <= '=') goto yy225;
		if (yych <= '>') goto yy223;
		goto yy138;
yy159:
		YYDEBUG(159, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '&') goto yy219;
		if (yych == '=') goto yy221;
		goto yy138;
yy160:
		YYDEBUG(160, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy217;
		if (yych == '|') goto yy215;
		goto yy138;
yy161:
		YYDEBUG(161, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy213;
		goto yy138;
yy162:
		YYDEBUG(162, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy211;
		if (yych == 'r') goto yy211;
		goto yy186;
yy163:
		YYDEBUG(163, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy208;
		if (yych == 'o') goto yy208;
		goto yy186;
yy164:
		YYDEBUG(164, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy138;
			if (yych <= 'Z') goto yy205;
			if (yych <= '^') goto yy138;
			goto yy205;
		} else {
			if (yych <= '`') goto yy138;
			if (yych <= 'z') goto yy205;
			if (yych <= '~') goto yy138;
			goto yy205;
		}
yy165:
		YYDEBUG(165, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy138;
yy166:
		YYDEBUG(166, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy201;
		goto yy138;
yy167:
		YYDEBUG(167, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(168, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1426 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	return '{';
}
#line 2888 "Zend/zend_language_scanner.c"
yy169:
		YYDEBUG(169, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(170, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1438 "Zend/zend_language_scanner.l"
		{
	RESET_DOC_COMMENT();
	if (!zend_stack_is_empty(&SCNG(state_stack))) {
		yy_pop_state(TSRMLS_C);
	}
	return '}';
}
#line 2902 "Zend/zend_language_scanner.c"
yy171:
		YYDEBUG(171, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'E') {
			if (yych <= '/') {
				if (yych == '.') goto yy187;
			} else {
				if (yych <= '9') goto yy190;
				if (yych >= 'E') goto yy192;
			}
		} else {
			if (yych <= 'd') {
				if (yych == 'X') goto yy197;
			} else {
				if (yych <= 'e') goto yy192;
				if (yych == 'x') goto yy197;
			}
		}
yy172:
		YYDEBUG(172, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1464 "Zend/zend_language_scanner.l"
		{
	if (yyleng < MAX_LENGTH_OF_LONG - 1) { /* Won't overflow */
		zendlval->value.lval = strtol(yytext, NULL, 0);
	} else {
		errno = 0;
		zendlval->value.lval = strtol(yytext, NULL, 0);
		if (errno == ERANGE) { /* Overflow */
			if (yytext[0] == '0') { /* octal overflow */
				zendlval->value.dval = zend_oct_strtod(yytext, NULL);
			} else {
				zendlval->value.dval = zend_strtod(yytext, NULL);
			}
			zendlval->type = IS_DOUBLE;
			return T_DNUMBER;
		}
	}

	zendlval->type = IS_LONG;
	return T_LNUMBER;
}
#line 2946 "Zend/zend_language_scanner.c"
yy173:
		YYDEBUG(173, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '9') {
			if (yych == '.') goto yy187;
			if (yych <= '/') goto yy172;
			goto yy190;
		} else {
			if (yych <= 'E') {
				if (yych <= 'D') goto yy172;
				goto yy192;
			} else {
				if (yych == 'e') goto yy192;
				goto yy172;
			}
		}
yy174:
		YYDEBUG(174, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy186;
yy175:
		YYDEBUG(175, *YYCURSOR);
		++YYCURSOR;
yy176:
		YYDEBUG(176, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1830 "Zend/zend_language_scanner.l"
		{
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				CG(zend_lineno)++;
				break;
			case '%':
				if (!CG(asp_tags)) {
					continue;
				}
				/* fall through */
			case '?':
				if (*YYCURSOR == '>') {
					YYCURSOR--;
					break;
				}
				/* fall through */
			default:
				continue;
		}

		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	return T_COMMENT;
}
#line 3008 "Zend/zend_language_scanner.c"
yy177:
		YYDEBUG(177, *YYCURSOR);
		++YYCURSOR;
yy178:
		YYDEBUG(178, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1921 "Zend/zend_language_scanner.l"
		{
	register char *s, *t;
	char *end;
	int bprefix = (yytext[0] != '\'') ? 1 : 0;

	while (1) {
		if (YYCURSOR < YYLIMIT) {
			if (*YYCURSOR == '\'') {
				YYCURSOR++;
				yyleng = YYCURSOR - SCNG(yy_text);

				break;
			} else if (*YYCURSOR++ == '\\' && YYCURSOR < YYLIMIT) {
				YYCURSOR++;
			}
		} else {
			yyleng = YYLIMIT - SCNG(yy_text);

			/* Unclosed single quotes; treat similar to double quotes, but without a separate token
			 * for ' (unrecognized by parser), instead of old flex fallback to "Unexpected character..."
			 * rule, which continued in ST_IN_SCRIPTING state after the quote */
			return T_ENCAPSED_AND_WHITESPACE;
		}
	}

	zendlval->value.str.val = estrndup(yytext+bprefix+1, yyleng-bprefix-2);
	zendlval->value.str.len = yyleng-bprefix-2;
	zendlval->type = IS_STRING;

	/* convert escape sequences */
	s = t = zendlval->value.str.val;
	end = s+zendlval->value.str.len;
	while (s<end) {
		if (*s=='\\') {
			s++;

			switch(*s) {
				case '\\':
				case '\'':
					*t++ = *s;
					zendlval->value.str.len--;
					break;
				default:
					*t++ = '\\';
					*t++ = *s;
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;

	if (SCNG(output_filter)) {
		size_t sz = 0;
		s = zendlval->value.str.val;
		SCNG(output_filter)((unsigned char **)&(zendlval->value.str.val), &sz, (unsigned char *)s, (size_t)zendlval->value.str.len TSRMLS_CC);
		zendlval->value.str.len = sz;
		efree(s);
	}
	return T_CONSTANT_ENCAPSED_STRING;
}
#line 3083 "Zend/zend_language_scanner.c"
yy179:
		YYDEBUG(179, *YYCURSOR);
		++YYCURSOR;
yy180:
		YYDEBUG(180, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1990 "Zend/zend_language_scanner.l"
		{
	int bprefix = (yytext[0] != '"') ? 1 : 0;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				yyleng = YYCURSOR - SCNG(yy_text);
				zend_scan_escape_string(zendlval, yytext+bprefix+1, yyleng-bprefix-2, '"' TSRMLS_CC);
				return T_CONSTANT_ENCAPSED_STRING;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	/* Remember how much was scanned to save rescanning */
	SET_DOUBLE_QUOTES_SCANNED_LENGTH(YYCURSOR - SCNG(yy_text) - yyleng);

	YYCURSOR = SCNG(yy_text) + yyleng;

	BEGIN(ST_DOUBLE_QUOTES);
	return '"';
}
#line 3131 "Zend/zend_language_scanner.c"
yy181:
		YYDEBUG(181, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(182, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2081 "Zend/zend_language_scanner.l"
		{
	BEGIN(ST_BACKQUOTE);
	return '`';
}
#line 3142 "Zend/zend_language_scanner.c"
yy183:
		YYDEBUG(183, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(184, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2339 "Zend/zend_language_scanner.l"
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	zend_error(E_COMPILE_WARNING,"Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	goto restart;
}
#line 3157 "Zend/zend_language_scanner.c"
yy185:
		YYDEBUG(185, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy186:
		YYDEBUG(186, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy185;
		}
		goto yy124;
yy187:
		YYDEBUG(187, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(188, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy187;
		}
		if (yych == 'E') goto yy192;
		if (yych == 'e') goto yy192;
yy189:
		YYDEBUG(189, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1525 "Zend/zend_language_scanner.l"
		{
	zendlval->value.dval = zend_strtod(yytext, NULL);
	zendlval->type = IS_DOUBLE;
	return T_DNUMBER;
}
#line 3190 "Zend/zend_language_scanner.c"
yy190:
		YYDEBUG(190, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(191, *YYCURSOR);
		if (yych <= '9') {
			if (yych == '.') goto yy187;
			if (yych <= '/') goto yy172;
			goto yy190;
		} else {
			if (yych <= 'E') {
				if (yych <= 'D') goto yy172;
			} else {
				if (yych != 'e') goto yy172;
			}
		}
yy192:
		YYDEBUG(192, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ',') {
			if (yych == '+') goto yy194;
		} else {
			if (yych <= '-') goto yy194;
			if (yych <= '/') goto yy193;
			if (yych <= '9') goto yy195;
		}
yy193:
		YYDEBUG(193, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 2) {
			if (yyaccept <= 1) {
				if (yyaccept <= 0) {
					goto yy124;
				} else {
					goto yy138;
				}
			} else {
				goto yy172;
			}
		} else {
			if (yyaccept <= 4) {
				if (yyaccept <= 3) {
					goto yy189;
				} else {
					goto yy234;
				}
			} else {
				goto yy250;
			}
		}
yy194:
		YYDEBUG(194, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '/') goto yy193;
		if (yych >= ':') goto yy193;
yy195:
		YYDEBUG(195, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(196, *YYCURSOR);
		if (yych <= '/') goto yy189;
		if (yych <= '9') goto yy195;
		goto yy189;
yy197:
		YYDEBUG(197, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 32) {
			goto yy198;
		}
		goto yy193;
yy198:
		YYDEBUG(198, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(199, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy198;
		}
		YYDEBUG(200, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1485 "Zend/zend_language_scanner.l"
		{
	char *hex = yytext + 2; /* Skip "0x" */
	int len = yyleng - 2;

	/* Skip any leading 0s */
	while (*hex == '0') {
		hex++;
		len--;
	}

	if (len < SIZEOF_LONG * 2 || (len == SIZEOF_LONG * 2 && *hex <= '7')) {
		zendlval->value.lval = strtol(hex, NULL, 16);
		zendlval->type = IS_LONG;
		return T_LNUMBER;
	} else {
		zendlval->value.dval = zend_hex_strtod(hex, NULL);
		zendlval->type = IS_DOUBLE;
		return T_DNUMBER;
	}
}
#line 3296 "Zend/zend_language_scanner.c"
yy201:
		YYDEBUG(201, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy203;
		if (yych == '\r') goto yy204;
yy202:
		YYDEBUG(202, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1898 "Zend/zend_language_scanner.l"
		{
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	BEGIN(INITIAL);
	return T_CLOSE_TAG;  /* implicit ';' at php-end tag */
}
#line 3313 "Zend/zend_language_scanner.c"
yy203:
		YYDEBUG(203, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy202;
yy204:
		YYDEBUG(204, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy203;
		goto yy202;
yy205:
		YYDEBUG(205, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(206, *YYCURSOR);
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy205;
			} else {
				if (yych <= '@') goto yy207;
				if (yych <= 'Z') goto yy205;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy205;
			} else {
				if (yych <= 'z') goto yy205;
				if (yych >= 0x7F) goto yy205;
			}
		}
yy207:
		YYDEBUG(207, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1800 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 3353 "Zend/zend_language_scanner.c"
yy208:
		YYDEBUG(208, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy209;
		if (yych != 'r') goto yy186;
yy209:
		YYDEBUG(209, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(210, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1409 "Zend/zend_language_scanner.l"
		{
	return T_LOGICAL_XOR;
}
#line 3371 "Zend/zend_language_scanner.c"
yy211:
		YYDEBUG(211, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(212, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1401 "Zend/zend_language_scanner.l"
		{
	return T_LOGICAL_OR;
}
#line 3384 "Zend/zend_language_scanner.c"
yy213:
		YYDEBUG(213, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(214, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1389 "Zend/zend_language_scanner.l"
		{
	return T_XOR_EQUAL;
}
#line 3394 "Zend/zend_language_scanner.c"
yy215:
		YYDEBUG(215, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(216, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1393 "Zend/zend_language_scanner.l"
		{
	return T_BOOLEAN_OR;
}
#line 3404 "Zend/zend_language_scanner.c"
yy217:
		YYDEBUG(217, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(218, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1385 "Zend/zend_language_scanner.l"
		{
	return T_OR_EQUAL;
}
#line 3414 "Zend/zend_language_scanner.c"
yy219:
		YYDEBUG(219, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(220, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1397 "Zend/zend_language_scanner.l"
		{
	return T_BOOLEAN_AND;
}
#line 3424 "Zend/zend_language_scanner.c"
yy221:
		YYDEBUG(221, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(222, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1381 "Zend/zend_language_scanner.l"
		{
	return T_AND_EQUAL;
}
#line 3434 "Zend/zend_language_scanner.c"
yy223:
		YYDEBUG(223, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy227;
		if (yych == '\r') goto yy228;
yy224:
		YYDEBUG(224, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1907 "Zend/zend_language_scanner.l"
		{
	if (CG(asp_tags)) {
		BEGIN(INITIAL);
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
		zendlval->value.str.val = yytext; /* no copying - intentional */
		return T_CLOSE_TAG;  /* implicit ';' at php-end tag */
	} else {
		yyless(1);
		return yytext[0];
	}
}
#line 3456 "Zend/zend_language_scanner.c"
yy225:
		YYDEBUG(225, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(226, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1369 "Zend/zend_language_scanner.l"
		{
	return T_MOD_EQUAL;
}
#line 3466 "Zend/zend_language_scanner.c"
yy227:
		YYDEBUG(227, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy224;
yy228:
		YYDEBUG(228, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy227;
		goto yy224;
yy229:
		YYDEBUG(229, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(230, *YYCURSOR);
		if (yych <= 'D') {
			if (yych <= '/') goto yy189;
			if (yych <= '9') goto yy229;
			goto yy189;
		} else {
			if (yych <= 'E') goto yy192;
			if (yych == 'e') goto yy192;
			goto yy189;
		}
yy231:
		YYDEBUG(231, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(232, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1365 "Zend/zend_language_scanner.l"
		{
	return T_CONCAT_EQUAL;
}
#line 3501 "Zend/zend_language_scanner.c"
yy233:
		YYDEBUG(233, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '*') goto yy238;
yy234:
		YYDEBUG(234, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1864 "Zend/zend_language_scanner.l"
		{
	int doc_com;

	if (yyleng > 2) {
		doc_com = 1;
		RESET_DOC_COMMENT();
	} else {
		doc_com = 0;
	}

	while (YYCURSOR < YYLIMIT) {
		if (*YYCURSOR++ == '*' && *YYCURSOR == '/') {
			break;
		}
	}

	if (YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	} else {
		zend_error(E_COMPILE_WARNING, "Unterminated comment starting line %d", CG(zend_lineno));
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	HANDLE_NEWLINES(yytext, yyleng);

	if (doc_com) {
		CG(doc_comment) = estrndup(yytext, yyleng);
		CG(doc_comment_len) = yyleng;
		return T_DOC_COMMENT;
	}

	return T_COMMENT;
}
#line 3544 "Zend/zend_language_scanner.c"
yy235:
		YYDEBUG(235, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy176;
yy236:
		YYDEBUG(236, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(237, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1361 "Zend/zend_language_scanner.l"
		{
	return T_DIV_EQUAL;
}
#line 3558 "Zend/zend_language_scanner.c"
yy238:
		YYDEBUG(238, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy239;
		}
		goto yy193;
yy239:
		YYDEBUG(239, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(240, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy239;
		}
		goto yy234;
yy241:
		YYDEBUG(241, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(242, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1357 "Zend/zend_language_scanner.l"
		{
	return T_MUL_EQUAL;
}
#line 3585 "Zend/zend_language_scanner.c"
yy243:
		YYDEBUG(243, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy247;
		YYDEBUG(244, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1417 "Zend/zend_language_scanner.l"
		{
	return T_SR;
}
#line 3596 "Zend/zend_language_scanner.c"
yy245:
		YYDEBUG(245, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(246, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1345 "Zend/zend_language_scanner.l"
		{
	return T_IS_GREATER_OR_EQUAL;
}
#line 3606 "Zend/zend_language_scanner.c"
yy247:
		YYDEBUG(247, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(248, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1377 "Zend/zend_language_scanner.l"
		{
	return T_SR_EQUAL;
}
#line 3616 "Zend/zend_language_scanner.c"
yy249:
		YYDEBUG(249, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') goto yy250;
		if (yych <= '<') goto yy265;
		if (yych <= '=') goto yy263;
yy250:
		YYDEBUG(250, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1413 "Zend/zend_language_scanner.l"
		{
	return T_SL;
}
#line 3631 "Zend/zend_language_scanner.c"
yy251:
		YYDEBUG(251, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy256;
		if (yych == 's') goto yy256;
		goto yy193;
yy252:
		YYDEBUG(252, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(253, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1341 "Zend/zend_language_scanner.l"
		{
	return T_IS_SMALLER_OR_EQUAL;
}
#line 3647 "Zend/zend_language_scanner.c"
yy254:
		YYDEBUG(254, *YYCURSOR);
		++YYCURSOR;
yy255:
		YYDEBUG(255, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1337 "Zend/zend_language_scanner.l"
		{
	return T_IS_NOT_EQUAL;
}
#line 3658 "Zend/zend_language_scanner.c"
yy256:
		YYDEBUG(256, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy257;
		if (yych != 'c') goto yy193;
yy257:
		YYDEBUG(257, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy258;
		if (yych != 'r') goto yy193;
yy258:
		YYDEBUG(258, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy259;
		if (yych != 'i') goto yy193;
yy259:
		YYDEBUG(259, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy260;
		if (yych != 'p') goto yy193;
yy260:
		YYDEBUG(260, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy261;
		if (yych != 't') goto yy193;
yy261:
		YYDEBUG(261, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(262, *YYCURSOR);
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy193;
			if (yych <= '\n') goto yy261;
			if (yych <= '\f') goto yy193;
			goto yy261;
		} else {
			if (yych <= ' ') {
				if (yych <= 0x1F) goto yy193;
				goto yy261;
			} else {
				if (yych == '>') goto yy201;
				goto yy193;
			}
		}
yy263:
		YYDEBUG(263, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(264, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1373 "Zend/zend_language_scanner.l"
		{
	return T_SL_EQUAL;
}
#line 3713 "Zend/zend_language_scanner.c"
yy265:
		YYDEBUG(265, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(266, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy265;
		}
		if (yych <= 'Z') {
			if (yych <= '&') {
				if (yych == '"') goto yy270;
				goto yy193;
			} else {
				if (yych <= '\'') goto yy269;
				if (yych <= '@') goto yy193;
			}
		} else {
			if (yych <= '`') {
				if (yych != '_') goto yy193;
			} else {
				if (yych <= 'z') goto yy267;
				if (yych <= '~') goto yy193;
			}
		}
yy267:
		YYDEBUG(267, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(268, *YYCURSOR);
		if (yych <= '@') {
			if (yych <= '\f') {
				if (yych == '\n') goto yy274;
				goto yy193;
			} else {
				if (yych <= '\r') goto yy276;
				if (yych <= '/') goto yy193;
				if (yych <= '9') goto yy267;
				goto yy193;
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'Z') goto yy267;
				if (yych <= '^') goto yy193;
				goto yy267;
			} else {
				if (yych <= '`') goto yy193;
				if (yych <= 'z') goto yy267;
				if (yych <= '~') goto yy193;
				goto yy267;
			}
		}
yy269:
		YYDEBUG(269, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\'') goto yy193;
		if (yych <= '/') goto yy278;
		if (yych <= '9') goto yy193;
		goto yy278;
yy270:
		YYDEBUG(270, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '"') goto yy193;
		if (yych <= '/') goto yy272;
		if (yych <= '9') goto yy193;
		goto yy272;
yy271:
		YYDEBUG(271, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy272:
		YYDEBUG(272, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych != '"') goto yy193;
			} else {
				if (yych <= '9') goto yy271;
				if (yych <= '@') goto yy193;
				goto yy271;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy271;
				goto yy193;
			} else {
				if (yych <= 'z') goto yy271;
				if (yych <= '~') goto yy193;
				goto yy271;
			}
		}
yy273:
		YYDEBUG(273, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy274;
		if (yych == '\r') goto yy276;
		goto yy193;
yy274:
		YYDEBUG(274, *YYCURSOR);
		++YYCURSOR;
yy275:
		YYDEBUG(275, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2032 "Zend/zend_language_scanner.l"
		{
	char *s;
	int bprefix = (yytext[0] != '<') ? 1 : 0;

	/* save old heredoc label */
	Z_STRVAL_P(zendlval) = CG(heredoc);
	Z_STRLEN_P(zendlval) = CG(heredoc_len);

	CG(zend_lineno)++;
	CG(heredoc_len) = yyleng-bprefix-3-1-(yytext[yyleng-2]=='\r'?1:0);
	s = yytext+bprefix+3;
	while ((*s == ' ') || (*s == '\t')) {
		s++;
		CG(heredoc_len)--;
	}

	if (*s == '\'') {
		s++;
		CG(heredoc_len) -= 2;

		BEGIN(ST_NOWDOC);
	} else {
		if (*s == '"') {
			s++;
			CG(heredoc_len) -= 2;
		}

		BEGIN(ST_HEREDOC);
	}

	CG(heredoc) = estrndup(s, CG(heredoc_len));

	/* Check for ending label on the next line */
	if (CG(heredoc_len) < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, s, CG(heredoc_len))) {
		YYCTYPE *end = YYCURSOR + CG(heredoc_len);

		if (*end == ';') {
			end++;
		}

		if (*end == '\n' || *end == '\r') {
			BEGIN(ST_END_HEREDOC);
		}
	}

	return T_START_HEREDOC;
}
#line 3866 "Zend/zend_language_scanner.c"
yy276:
		YYDEBUG(276, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy274;
		goto yy275;
yy277:
		YYDEBUG(277, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy278:
		YYDEBUG(278, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych == '\'') goto yy273;
				goto yy193;
			} else {
				if (yych <= '9') goto yy277;
				if (yych <= '@') goto yy193;
				goto yy277;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy277;
				goto yy193;
			} else {
				if (yych <= 'z') goto yy277;
				if (yych <= '~') goto yy193;
				goto yy277;
			}
		}
yy279:
		YYDEBUG(279, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '=') goto yy255;
		YYDEBUG(280, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(281, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1329 "Zend/zend_language_scanner.l"
		{
	return T_IS_NOT_IDENTICAL;
}
#line 3910 "Zend/zend_language_scanner.c"
yy282:
		YYDEBUG(282, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(283, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1349 "Zend/zend_language_scanner.l"
		{
	return T_PLUS_EQUAL;
}
#line 3920 "Zend/zend_language_scanner.c"
yy284:
		YYDEBUG(284, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(285, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1317 "Zend/zend_language_scanner.l"
		{
	return T_INC;
}
#line 3930 "Zend/zend_language_scanner.c"
yy286:
		YYDEBUG(286, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy287;
		if (yych != 's') goto yy186;
yy287:
		YYDEBUG(287, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy288;
		if (yych != 't') goto yy186;
yy288:
		YYDEBUG(288, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(289, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1309 "Zend/zend_language_scanner.l"
		{
	return T_LIST;
}
#line 3953 "Zend/zend_language_scanner.c"
yy290:
		YYDEBUG(290, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy294;
		YYDEBUG(291, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1333 "Zend/zend_language_scanner.l"
		{
	return T_IS_EQUAL;
}
#line 3964 "Zend/zend_language_scanner.c"
yy292:
		YYDEBUG(292, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(293, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1305 "Zend/zend_language_scanner.l"
		{
	return T_DOUBLE_ARROW;
}
#line 3974 "Zend/zend_language_scanner.c"
yy294:
		YYDEBUG(294, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(295, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1325 "Zend/zend_language_scanner.l"
		{
	return T_IS_IDENTICAL;
}
#line 3984 "Zend/zend_language_scanner.c"
yy296:
		YYDEBUG(296, *YYCURSOR);
		yych = *++YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case 'C':
		case 'c':	goto yy298;
		case 'D':
		case 'd':	goto yy302;
		case 'F':
		case 'f':	goto yy299;
		case 'H':
		case 'h':	goto yy297;
		case 'L':
		case 'l':	goto yy301;
		case 'M':
		case 'm':	goto yy300;
		case 'N':
		case 'n':	goto yy303;
		default:	goto yy186;
		}
yy297:
		YYDEBUG(297, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy357;
		if (yych == 'a') goto yy357;
		goto yy186;
yy298:
		YYDEBUG(298, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy350;
		if (yych == 'l') goto yy350;
		goto yy186;
yy299:
		YYDEBUG(299, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych == 'I') goto yy334;
			if (yych <= 'T') goto yy186;
			goto yy335;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy186;
				goto yy334;
			} else {
				if (yych == 'u') goto yy335;
				goto yy186;
			}
		}
yy300:
		YYDEBUG(300, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy326;
		if (yych == 'e') goto yy326;
		goto yy186;
yy301:
		YYDEBUG(301, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy320;
		if (yych == 'i') goto yy320;
		goto yy186;
yy302:
		YYDEBUG(302, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy315;
		if (yych == 'i') goto yy315;
		goto yy186;
yy303:
		YYDEBUG(303, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy304;
		if (yych != 'a') goto yy186;
yy304:
		YYDEBUG(304, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy305;
		if (yych != 'm') goto yy186;
yy305:
		YYDEBUG(305, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy306;
		if (yych != 'e') goto yy186;
yy306:
		YYDEBUG(306, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy307;
		if (yych != 's') goto yy186;
yy307:
		YYDEBUG(307, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy308;
		if (yych != 'p') goto yy186;
yy308:
		YYDEBUG(308, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy309;
		if (yych != 'a') goto yy186;
yy309:
		YYDEBUG(309, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy310;
		if (yych != 'c') goto yy186;
yy310:
		YYDEBUG(310, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy311;
		if (yych != 'e') goto yy186;
yy311:
		YYDEBUG(311, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(312, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(313, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(314, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1629 "Zend/zend_language_scanner.l"
		{
	if (CG(current_namespace)) {
		*zendlval = *CG(current_namespace);
		zval_copy_ctor(zendlval);
	} else {
		ZVAL_EMPTY_STRING(zendlval);
	}
	return T_NS_C;
}
#line 4116 "Zend/zend_language_scanner.c"
yy315:
		YYDEBUG(315, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy316;
		if (yych != 'r') goto yy186;
yy316:
		YYDEBUG(316, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(317, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(318, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(319, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1602 "Zend/zend_language_scanner.l"
		{
	char *filename = zend_get_compiled_filename(TSRMLS_C);
	const size_t filename_len = strlen(filename);
	char *dirname;

	if (!filename) {
		filename = "";
	}

	dirname = estrndup(filename, filename_len);
	zend_dirname(dirname, filename_len);

	if (strcmp(dirname, ".") == 0) {
		dirname = erealloc(dirname, MAXPATHLEN);
#if HAVE_GETCWD
		VCWD_GETCWD(dirname, MAXPATHLEN);
#elif HAVE_GETWD
		VCWD_GETWD(dirname);
#endif
	}

	zendlval->value.str.len = strlen(dirname);
	zendlval->value.str.val = dirname;
	zendlval->type = IS_STRING;
	return T_DIR;
}
#line 4163 "Zend/zend_language_scanner.c"
yy320:
		YYDEBUG(320, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy321;
		if (yych != 'n') goto yy186;
yy321:
		YYDEBUG(321, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy322;
		if (yych != 'e') goto yy186;
yy322:
		YYDEBUG(322, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(323, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(324, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(325, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1584 "Zend/zend_language_scanner.l"
		{
	zendlval->value.lval = CG(zend_lineno);
	zendlval->type = IS_LONG;
	return T_LINE;
}
#line 4194 "Zend/zend_language_scanner.c"
yy326:
		YYDEBUG(326, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy327;
		if (yych != 't') goto yy186;
yy327:
		YYDEBUG(327, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy328;
		if (yych != 'h') goto yy186;
yy328:
		YYDEBUG(328, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy329;
		if (yych != 'o') goto yy186;
yy329:
		YYDEBUG(329, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy330;
		if (yych != 'd') goto yy186;
yy330:
		YYDEBUG(330, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(331, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(332, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(333, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1563 "Zend/zend_language_scanner.l"
		{
	char *class_name = CG(active_class_entry) ? CG(active_class_entry)->name : NULL;
	char *func_name = CG(active_op_array)? CG(active_op_array)->function_name : NULL;
	size_t len = 0;

	if (class_name) {
		len += strlen(class_name) + 2;
	}
	if (func_name) {
		len += strlen(func_name);
	}

	zendlval->value.str.len = zend_spprintf(&zendlval->value.str.val, 0, "%s%s%s",
		class_name ? class_name : "",
		class_name && func_name ? "::" : "",
		func_name ? func_name : ""
		);
	zendlval->type = IS_STRING;
	return T_METHOD_C;
}
#line 4250 "Zend/zend_language_scanner.c"
yy334:
		YYDEBUG(334, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy345;
		if (yych == 'l') goto yy345;
		goto yy186;
yy335:
		YYDEBUG(335, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy336;
		if (yych != 'n') goto yy186;
yy336:
		YYDEBUG(336, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy337;
		if (yych != 'c') goto yy186;
yy337:
		YYDEBUG(337, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy338;
		if (yych != 't') goto yy186;
yy338:
		YYDEBUG(338, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy339;
		if (yych != 'i') goto yy186;
yy339:
		YYDEBUG(339, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy340;
		if (yych != 'o') goto yy186;
yy340:
		YYDEBUG(340, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy341;
		if (yych != 'n') goto yy186;
yy341:
		YYDEBUG(341, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(342, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(343, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(344, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1547 "Zend/zend_language_scanner.l"
		{
	char *func_name = NULL;

	if (CG(active_op_array)) {
		func_name = CG(active_op_array)->function_name;
	}

	if (!func_name) {
		func_name = "";
	}
	zendlval->value.str.len = strlen(func_name);
	zendlval->value.str.val = estrndup(func_name, zendlval->value.str.len);
	zendlval->type = IS_STRING;
	return T_FUNC_C;
}
#line 4317 "Zend/zend_language_scanner.c"
yy345:
		YYDEBUG(345, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy346;
		if (yych != 'e') goto yy186;
yy346:
		YYDEBUG(346, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(347, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(348, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(349, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1590 "Zend/zend_language_scanner.l"
		{
	char *filename = zend_get_compiled_filename(TSRMLS_C);

	if (!filename) {
		filename = "";
	}
	zendlval->value.str.len = strlen(filename);
	zendlval->value.str.val = estrndup(filename, zendlval->value.str.len);
	zendlval->type = IS_STRING;
	return T_FILE;
}
#line 4349 "Zend/zend_language_scanner.c"
yy350:
		YYDEBUG(350, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy351;
		if (yych != 'a') goto yy186;
yy351:
		YYDEBUG(351, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy352;
		if (yych != 's') goto yy186;
yy352:
		YYDEBUG(352, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy353;
		if (yych != 's') goto yy186;
yy353:
		YYDEBUG(353, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(354, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(355, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(356, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1531 "Zend/zend_language_scanner.l"
		{
	char *class_name = NULL;

	if (CG(active_class_entry)) {
		class_name = CG(active_class_entry)->name;
	}

	if (!class_name) {
		class_name = "";
	}
	zendlval->value.str.len = strlen(class_name);
	zendlval->value.str.val = estrndup(class_name, zendlval->value.str.len);
	zendlval->type = IS_STRING;
	return T_CLASS_C;
}
#line 4395 "Zend/zend_language_scanner.c"
yy357:
		YYDEBUG(357, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy358;
		if (yych != 'l') goto yy186;
yy358:
		YYDEBUG(358, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy359;
		if (yych != 't') goto yy186;
yy359:
		YYDEBUG(359, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(360, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy361;
		if (yych != 'c') goto yy186;
yy361:
		YYDEBUG(361, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy362;
		if (yych != 'o') goto yy186;
yy362:
		YYDEBUG(362, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy363;
		if (yych != 'm') goto yy186;
yy363:
		YYDEBUG(363, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy364;
		if (yych != 'p') goto yy186;
yy364:
		YYDEBUG(364, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy365;
		if (yych != 'i') goto yy186;
yy365:
		YYDEBUG(365, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy366;
		if (yych != 'l') goto yy186;
yy366:
		YYDEBUG(366, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy367;
		if (yych != 'e') goto yy186;
yy367:
		YYDEBUG(367, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy368;
		if (yych != 'r') goto yy186;
yy368:
		YYDEBUG(368, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(369, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1273 "Zend/zend_language_scanner.l"
		{
	return T_HALT_COMPILER;
}
#line 4461 "Zend/zend_language_scanner.c"
yy370:
		YYDEBUG(370, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy374;
		if (yych == 's') goto yy374;
		goto yy186;
yy371:
		YYDEBUG(371, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy372;
		if (yych != 'e') goto yy186;
yy372:
		YYDEBUG(372, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(373, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1253 "Zend/zend_language_scanner.l"
		{
	return T_USE;
}
#line 4485 "Zend/zend_language_scanner.c"
yy374:
		YYDEBUG(374, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy375;
		if (yych != 'e') goto yy186;
yy375:
		YYDEBUG(375, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy376;
		if (yych != 't') goto yy186;
yy376:
		YYDEBUG(376, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(377, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1301 "Zend/zend_language_scanner.l"
		{
	return T_UNSET;
}
#line 4508 "Zend/zend_language_scanner.c"
yy378:
		YYDEBUG(378, *YYCURSOR);
		++YYCURSOR;
		YYFILL(7);
		yych = *YYCURSOR;
yy379:
		YYDEBUG(379, *YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'D') {
				if (yych <= ' ') {
					if (yych == '\t') goto yy378;
					if (yych <= 0x1F) goto yy193;
					goto yy378;
				} else {
					if (yych <= 'A') {
						if (yych <= '@') goto yy193;
						goto yy383;
					} else {
						if (yych <= 'B') goto yy381;
						if (yych <= 'C') goto yy193;
						goto yy386;
					}
				}
			} else {
				if (yych <= 'I') {
					if (yych == 'F') goto yy387;
					if (yych <= 'H') goto yy193;
					goto yy388;
				} else {
					if (yych <= 'O') {
						if (yych <= 'N') goto yy193;
						goto yy382;
					} else {
						if (yych <= 'Q') goto yy193;
						if (yych <= 'R') goto yy385;
						goto yy384;
					}
				}
			}
		} else {
			if (yych <= 'f') {
				if (yych <= 'a') {
					if (yych == 'U') goto yy380;
					if (yych <= '`') goto yy193;
					goto yy383;
				} else {
					if (yych <= 'c') {
						if (yych <= 'b') goto yy381;
						goto yy193;
					} else {
						if (yych <= 'd') goto yy386;
						if (yych <= 'e') goto yy193;
						goto yy387;
					}
				}
			} else {
				if (yych <= 'q') {
					if (yych <= 'i') {
						if (yych <= 'h') goto yy193;
						goto yy388;
					} else {
						if (yych == 'o') goto yy382;
						goto yy193;
					}
				} else {
					if (yych <= 's') {
						if (yych <= 'r') goto yy385;
						goto yy384;
					} else {
						if (yych != 'u') goto yy193;
					}
				}
			}
		}
yy380:
		YYDEBUG(380, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy455;
		if (yych == 'n') goto yy455;
		goto yy193;
yy381:
		YYDEBUG(381, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'I') goto yy442;
			if (yych <= 'N') goto yy193;
			goto yy443;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy193;
				goto yy442;
			} else {
				if (yych == 'o') goto yy443;
				goto yy193;
			}
		}
yy382:
		YYDEBUG(382, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy434;
		if (yych == 'b') goto yy434;
		goto yy193;
yy383:
		YYDEBUG(383, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy427;
		if (yych == 'r') goto yy427;
		goto yy193;
yy384:
		YYDEBUG(384, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych == 'C') goto yy412;
			if (yych <= 'S') goto yy193;
			goto yy411;
		} else {
			if (yych <= 'c') {
				if (yych <= 'b') goto yy193;
				goto yy412;
			} else {
				if (yych == 't') goto yy411;
				goto yy193;
			}
		}
yy385:
		YYDEBUG(385, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy409;
		if (yych == 'e') goto yy409;
		goto yy193;
yy386:
		YYDEBUG(386, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy405;
		if (yych == 'o') goto yy405;
		goto yy193;
yy387:
		YYDEBUG(387, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy398;
		if (yych == 'l') goto yy398;
		goto yy193;
yy388:
		YYDEBUG(388, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy389;
		if (yych != 'n') goto yy193;
yy389:
		YYDEBUG(389, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy390;
		if (yych != 't') goto yy193;
yy390:
		YYDEBUG(390, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy391;
		if (yych != 'e') goto yy393;
yy391:
		YYDEBUG(391, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy396;
		if (yych == 'g') goto yy396;
		goto yy193;
yy392:
		YYDEBUG(392, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy393:
		YYDEBUG(393, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy392;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy392;
			if (yych != ')') goto yy193;
		}
		YYDEBUG(394, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(395, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1197 "Zend/zend_language_scanner.l"
		{
	return T_INT_CAST;
}
#line 4694 "Zend/zend_language_scanner.c"
yy396:
		YYDEBUG(396, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy397;
		if (yych != 'e') goto yy193;
yy397:
		YYDEBUG(397, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy392;
		if (yych == 'r') goto yy392;
		goto yy193;
yy398:
		YYDEBUG(398, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy399;
		if (yych != 'o') goto yy193;
yy399:
		YYDEBUG(399, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy400;
		if (yych != 'a') goto yy193;
yy400:
		YYDEBUG(400, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy401;
		if (yych != 't') goto yy193;
yy401:
		YYDEBUG(401, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(402, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy401;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy401;
			if (yych != ')') goto yy193;
		}
		YYDEBUG(403, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(404, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1201 "Zend/zend_language_scanner.l"
		{
	return T_DOUBLE_CAST;
}
#line 4742 "Zend/zend_language_scanner.c"
yy405:
		YYDEBUG(405, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy406;
		if (yych != 'u') goto yy193;
yy406:
		YYDEBUG(406, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy407;
		if (yych != 'b') goto yy193;
yy407:
		YYDEBUG(407, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy408;
		if (yych != 'l') goto yy193;
yy408:
		YYDEBUG(408, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy401;
		if (yych == 'e') goto yy401;
		goto yy193;
yy409:
		YYDEBUG(409, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy410;
		if (yych != 'a') goto yy193;
yy410:
		YYDEBUG(410, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy401;
		if (yych == 'l') goto yy401;
		goto yy193;
yy411:
		YYDEBUG(411, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy420;
		if (yych == 'r') goto yy420;
		goto yy193;
yy412:
		YYDEBUG(412, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy413;
		if (yych != 'a') goto yy193;
yy413:
		YYDEBUG(413, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy414;
		if (yych != 'l') goto yy193;
yy414:
		YYDEBUG(414, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy415;
		if (yych != 'a') goto yy193;
yy415:
		YYDEBUG(415, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy416;
		if (yych != 'r') goto yy193;
yy416:
		YYDEBUG(416, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(417, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy416;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy416;
			if (yych != ')') goto yy193;
		}
		YYDEBUG(418, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(419, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1209 "Zend/zend_language_scanner.l"
		{
	return T_SCALAR_CAST;
}
#line 4822 "Zend/zend_language_scanner.c"
yy420:
		YYDEBUG(420, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy421;
		if (yych != 'i') goto yy193;
yy421:
		YYDEBUG(421, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy422;
		if (yych != 'n') goto yy193;
yy422:
		YYDEBUG(422, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy423;
		if (yych != 'g') goto yy193;
yy423:
		YYDEBUG(423, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(424, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy423;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy423;
			if (yych != ')') goto yy193;
		}
		YYDEBUG(425, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(426, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1205 "Zend/zend_language_scanner.l"
		{
	return T_STRING_CAST;
}
#line 4859 "Zend/zend_language_scanner.c"
yy427:
		YYDEBUG(427, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy428;
		if (yych != 'r') goto yy193;
yy428:
		YYDEBUG(428, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy429;
		if (yych != 'a') goto yy193;
yy429:
		YYDEBUG(429, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy430;
		if (yych != 'y') goto yy193;
yy430:
		YYDEBUG(430, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(431, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy430;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy430;
			if (yych != ')') goto yy193;
		}
		YYDEBUG(432, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(433, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1213 "Zend/zend_language_scanner.l"
		{
	return T_ARRAY_CAST;
}
#line 4896 "Zend/zend_language_scanner.c"
yy434:
		YYDEBUG(434, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'J') goto yy435;
		if (yych != 'j') goto yy193;
yy435:
		YYDEBUG(435, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy436;
		if (yych != 'e') goto yy193;
yy436:
		YYDEBUG(436, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy437;
		if (yych != 'c') goto yy193;
yy437:
		YYDEBUG(437, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy438;
		if (yych != 't') goto yy193;
yy438:
		YYDEBUG(438, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(439, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy438;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy438;
			if (yych != ')') goto yy193;
		}
		YYDEBUG(440, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(441, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1217 "Zend/zend_language_scanner.l"
		{
	return T_OBJECT_CAST;
}
#line 4938 "Zend/zend_language_scanner.c"
yy442:
		YYDEBUG(442, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy452;
		if (yych == 'n') goto yy452;
		goto yy193;
yy443:
		YYDEBUG(443, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy444;
		if (yych != 'o') goto yy193;
yy444:
		YYDEBUG(444, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy445;
		if (yych != 'l') goto yy193;
yy445:
		YYDEBUG(445, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy450;
		if (yych == 'e') goto yy450;
		goto yy447;
yy446:
		YYDEBUG(446, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy447:
		YYDEBUG(447, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy446;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy446;
			if (yych != ')') goto yy193;
		}
		YYDEBUG(448, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(449, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1221 "Zend/zend_language_scanner.l"
		{
	return T_BOOL_CAST;
}
#line 4983 "Zend/zend_language_scanner.c"
yy450:
		YYDEBUG(450, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy451;
		if (yych != 'a') goto yy193;
yy451:
		YYDEBUG(451, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy446;
		if (yych == 'n') goto yy446;
		goto yy193;
yy452:
		YYDEBUG(452, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy453;
		if (yych != 'a') goto yy193;
yy453:
		YYDEBUG(453, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy454;
		if (yych != 'r') goto yy193;
yy454:
		YYDEBUG(454, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy423;
		if (yych == 'y') goto yy423;
		goto yy193;
yy455:
		YYDEBUG(455, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy456;
		if (yych != 's') goto yy193;
yy456:
		YYDEBUG(456, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy457;
		if (yych != 'e') goto yy193;
yy457:
		YYDEBUG(457, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy458;
		if (yych != 't') goto yy193;
yy458:
		YYDEBUG(458, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(459, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy458;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy458;
			if (yych != ')') goto yy193;
		}
		YYDEBUG(460, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(461, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1225 "Zend/zend_language_scanner.l"
		{
	return T_UNSET_CAST;
}
#line 5047 "Zend/zend_language_scanner.c"
yy462:
		YYDEBUG(462, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy463;
		if (yych != 'r') goto yy186;
yy463:
		YYDEBUG(463, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(464, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1193 "Zend/zend_language_scanner.l"
		{
	return T_VAR;
}
#line 5065 "Zend/zend_language_scanner.c"
yy465:
		YYDEBUG(465, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy469;
		if (yych == 'm') goto yy469;
		goto yy186;
yy466:
		YYDEBUG(466, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy467;
		if (yych != 'w') goto yy186;
yy467:
		YYDEBUG(467, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(468, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1185 "Zend/zend_language_scanner.l"
		{
	return T_NEW;
}
#line 5089 "Zend/zend_language_scanner.c"
yy469:
		YYDEBUG(469, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy470;
		if (yych != 'e') goto yy186;
yy470:
		YYDEBUG(470, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy471;
		if (yych != 's') goto yy186;
yy471:
		YYDEBUG(471, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy472;
		if (yych != 'p') goto yy186;
yy472:
		YYDEBUG(472, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy473;
		if (yych != 'a') goto yy186;
yy473:
		YYDEBUG(473, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy474;
		if (yych != 'c') goto yy186;
yy474:
		YYDEBUG(474, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy475;
		if (yych != 'e') goto yy186;
yy475:
		YYDEBUG(475, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(476, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1249 "Zend/zend_language_scanner.l"
		{
	return T_NAMESPACE;
}
#line 5132 "Zend/zend_language_scanner.c"
yy477:
		YYDEBUG(477, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(478, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1177 "Zend/zend_language_scanner.l"
		{
	return T_PAAMAYIM_NEKUDOTAYIM;
}
#line 5142 "Zend/zend_language_scanner.c"
yy479:
		YYDEBUG(479, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy480:
		YYDEBUG(480, *YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy140;
			if (yych <= '\n') goto yy479;
			goto yy140;
		} else {
			if (yych <= '\r') goto yy479;
			if (yych == ' ') goto yy479;
			goto yy140;
		}
yy481:
		YYDEBUG(481, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(482, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1353 "Zend/zend_language_scanner.l"
		{
	return T_MINUS_EQUAL;
}
#line 5168 "Zend/zend_language_scanner.c"
yy483:
		YYDEBUG(483, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(484, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1321 "Zend/zend_language_scanner.l"
		{
	return T_DEC;
}
#line 5178 "Zend/zend_language_scanner.c"
yy485:
		YYDEBUG(485, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(486, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1147 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_LOOKING_FOR_PROPERTY TSRMLS_CC);
	return T_OBJECT_OPERATOR;
}
#line 5189 "Zend/zend_language_scanner.c"
yy487:
		YYDEBUG(487, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'I') goto yy494;
			if (yych <= 'N') goto yy186;
			goto yy495;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy186;
				goto yy494;
			} else {
				if (yych == 'o') goto yy495;
				goto yy186;
			}
		}
yy488:
		YYDEBUG(488, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy489;
		if (yych != 'b') goto yy186;
yy489:
		YYDEBUG(489, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy490;
		if (yych != 'l') goto yy186;
yy490:
		YYDEBUG(490, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy491;
		if (yych != 'i') goto yy186;
yy491:
		YYDEBUG(491, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy492;
		if (yych != 'c') goto yy186;
yy492:
		YYDEBUG(492, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(493, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1297 "Zend/zend_language_scanner.l"
		{
	return T_PUBLIC;
}
#line 5238 "Zend/zend_language_scanner.c"
yy494:
		YYDEBUG(494, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'V') {
			if (yych == 'N') goto yy503;
			if (yych <= 'U') goto yy186;
			goto yy504;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy186;
				goto yy503;
			} else {
				if (yych == 'v') goto yy504;
				goto yy186;
			}
		}
yy495:
		YYDEBUG(495, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy496;
		if (yych != 't') goto yy186;
yy496:
		YYDEBUG(496, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy497;
		if (yych != 'e') goto yy186;
yy497:
		YYDEBUG(497, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy498;
		if (yych != 'c') goto yy186;
yy498:
		YYDEBUG(498, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy499;
		if (yych != 't') goto yy186;
yy499:
		YYDEBUG(499, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy500;
		if (yych != 'e') goto yy186;
yy500:
		YYDEBUG(500, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy501;
		if (yych != 'd') goto yy186;
yy501:
		YYDEBUG(501, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(502, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1293 "Zend/zend_language_scanner.l"
		{
	return T_PROTECTED;
}
#line 5297 "Zend/zend_language_scanner.c"
yy503:
		YYDEBUG(503, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy509;
		if (yych == 't') goto yy509;
		goto yy186;
yy504:
		YYDEBUG(504, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy505;
		if (yych != 'a') goto yy186;
yy505:
		YYDEBUG(505, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy506;
		if (yych != 't') goto yy186;
yy506:
		YYDEBUG(506, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy507;
		if (yych != 'e') goto yy186;
yy507:
		YYDEBUG(507, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(508, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1289 "Zend/zend_language_scanner.l"
		{
	return T_PRIVATE;
}
#line 5331 "Zend/zend_language_scanner.c"
yy509:
		YYDEBUG(509, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(510, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1123 "Zend/zend_language_scanner.l"
		{
	return T_PRINT;
}
#line 5344 "Zend/zend_language_scanner.c"
yy511:
		YYDEBUG(511, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy516;
		if (yych == 'o') goto yy516;
		goto yy186;
yy512:
		YYDEBUG(512, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy513;
		if (yych != 't') goto yy186;
yy513:
		YYDEBUG(513, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy514;
		if (yych != 'o') goto yy186;
yy514:
		YYDEBUG(514, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(515, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1115 "Zend/zend_language_scanner.l"
		{
	return T_GOTO;
}
#line 5373 "Zend/zend_language_scanner.c"
yy516:
		YYDEBUG(516, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy517;
		if (yych != 'b') goto yy186;
yy517:
		YYDEBUG(517, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy518;
		if (yych != 'a') goto yy186;
yy518:
		YYDEBUG(518, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy519;
		if (yych != 'l') goto yy186;
yy519:
		YYDEBUG(519, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(520, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1261 "Zend/zend_language_scanner.l"
		{
	return T_GLOBAL;
}
#line 5401 "Zend/zend_language_scanner.c"
yy521:
		YYDEBUG(521, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy529;
		goto yy193;
yy522:
		YYDEBUG(522, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy180;
yy523:
		YYDEBUG(523, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy178;
yy524:
		YYDEBUG(524, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy525;
		if (yych != 'e') goto yy186;
yy525:
		YYDEBUG(525, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy526;
		if (yych != 'a') goto yy186;
yy526:
		YYDEBUG(526, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'K') goto yy527;
		if (yych != 'k') goto yy186;
yy527:
		YYDEBUG(527, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(528, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1107 "Zend/zend_language_scanner.l"
		{
	return T_BREAK;
}
#line 5442 "Zend/zend_language_scanner.c"
yy529:
		YYDEBUG(529, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy265;
		goto yy193;
yy530:
		YYDEBUG(530, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy537;
		if (yych == 'a') goto yy537;
		goto yy186;
yy531:
		YYDEBUG(531, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy532;
		if (yych != 'i') goto yy186;
yy532:
		YYDEBUG(532, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy533;
		if (yych != 't') goto yy186;
yy533:
		YYDEBUG(533, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy534;
		if (yych != 'c') goto yy186;
yy534:
		YYDEBUG(534, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy535;
		if (yych != 'h') goto yy186;
yy535:
		YYDEBUG(535, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(536, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1091 "Zend/zend_language_scanner.l"
		{
	return T_SWITCH;
}
#line 5486 "Zend/zend_language_scanner.c"
yy537:
		YYDEBUG(537, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy538;
		if (yych != 't') goto yy186;
yy538:
		YYDEBUG(538, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy539;
		if (yych != 'i') goto yy186;
yy539:
		YYDEBUG(539, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy540;
		if (yych != 'c') goto yy186;
yy540:
		YYDEBUG(540, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(541, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1277 "Zend/zend_language_scanner.l"
		{
	return T_STATIC;
}
#line 5514 "Zend/zend_language_scanner.c"
yy542:
		YYDEBUG(542, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy553;
		if (yych == 's') goto yy553;
		goto yy186;
yy543:
		YYDEBUG(543, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy551;
		if (yych == 'd') goto yy551;
		goto yy186;
yy544:
		YYDEBUG(544, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy547;
		if (yych == 'r') goto yy547;
		goto yy186;
yy545:
		YYDEBUG(545, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(546, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1087 "Zend/zend_language_scanner.l"
		{
	return T_AS;
}
#line 5545 "Zend/zend_language_scanner.c"
yy547:
		YYDEBUG(547, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy548;
		if (yych != 'a') goto yy186;
yy548:
		YYDEBUG(548, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy549;
		if (yych != 'y') goto yy186;
yy549:
		YYDEBUG(549, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(550, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1313 "Zend/zend_language_scanner.l"
		{
	return T_ARRAY;
}
#line 5568 "Zend/zend_language_scanner.c"
yy551:
		YYDEBUG(551, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(552, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1405 "Zend/zend_language_scanner.l"
		{
	return T_LOGICAL_AND;
}
#line 5581 "Zend/zend_language_scanner.c"
yy553:
		YYDEBUG(553, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy554;
		if (yych != 't') goto yy186;
yy554:
		YYDEBUG(554, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy555;
		if (yych != 'r') goto yy186;
yy555:
		YYDEBUG(555, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy556;
		if (yych != 'a') goto yy186;
yy556:
		YYDEBUG(556, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy557;
		if (yych != 'c') goto yy186;
yy557:
		YYDEBUG(557, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy558;
		if (yych != 't') goto yy186;
yy558:
		YYDEBUG(558, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(559, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1281 "Zend/zend_language_scanner.l"
		{
	return T_ABSTRACT;
}
#line 5619 "Zend/zend_language_scanner.c"
yy560:
		YYDEBUG(560, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy561;
		if (yych != 'i') goto yy186;
yy561:
		YYDEBUG(561, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy562;
		if (yych != 'l') goto yy186;
yy562:
		YYDEBUG(562, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy563;
		if (yych != 'e') goto yy186;
yy563:
		YYDEBUG(563, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(564, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1047 "Zend/zend_language_scanner.l"
		{
	return T_WHILE;
}
#line 5647 "Zend/zend_language_scanner.c"
yy565:
		YYDEBUG(565, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(566, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1031 "Zend/zend_language_scanner.l"
		{
	return T_IF;
}
#line 5660 "Zend/zend_language_scanner.c"
yy567:
		YYDEBUG(567, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy609;
		if (yych == 'p') goto yy609;
		goto yy186;
yy568:
		YYDEBUG(568, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych <= 'C') {
				if (yych <= 'B') goto yy186;
				goto yy576;
			} else {
				if (yych <= 'R') goto yy186;
				if (yych <= 'S') goto yy574;
				goto yy575;
			}
		} else {
			if (yych <= 'r') {
				if (yych == 'c') goto yy576;
				goto yy186;
			} else {
				if (yych <= 's') goto yy574;
				if (yych <= 't') goto yy575;
				goto yy186;
			}
		}
yy569:
		YYDEBUG(569, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy570;
		if (yych != 's') goto yy186;
yy570:
		YYDEBUG(570, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy571;
		if (yych != 'e') goto yy186;
yy571:
		YYDEBUG(571, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy572;
		if (yych != 't') goto yy186;
yy572:
		YYDEBUG(572, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(573, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1265 "Zend/zend_language_scanner.l"
		{
	return T_ISSET;
}
#line 5716 "Zend/zend_language_scanner.c"
yy574:
		YYDEBUG(574, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy595;
		if (yych == 't') goto yy595;
		goto yy186;
yy575:
		YYDEBUG(575, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy588;
		if (yych == 'e') goto yy588;
		goto yy186;
yy576:
		YYDEBUG(576, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy577;
		if (yych != 'l') goto yy186;
yy577:
		YYDEBUG(577, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy578;
		if (yych != 'u') goto yy186;
yy578:
		YYDEBUG(578, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy579;
		if (yych != 'd') goto yy186;
yy579:
		YYDEBUG(579, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy580;
		if (yych != 'e') goto yy186;
yy580:
		YYDEBUG(580, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy185;
			} else {
				if (yych <= '@') goto yy581;
				if (yych <= 'Z') goto yy185;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy582;
			} else {
				if (yych <= 'z') goto yy185;
				if (yych >= 0x7F) goto yy185;
			}
		}
yy581:
		YYDEBUG(581, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1233 "Zend/zend_language_scanner.l"
		{
	return T_INCLUDE;
}
#line 5774 "Zend/zend_language_scanner.c"
yy582:
		YYDEBUG(582, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy583;
		if (yych != 'o') goto yy186;
yy583:
		YYDEBUG(583, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy584;
		if (yych != 'n') goto yy186;
yy584:
		YYDEBUG(584, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy585;
		if (yych != 'c') goto yy186;
yy585:
		YYDEBUG(585, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy586;
		if (yych != 'e') goto yy186;
yy586:
		YYDEBUG(586, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(587, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1237 "Zend/zend_language_scanner.l"
		{
	return T_INCLUDE_ONCE;
}
#line 5807 "Zend/zend_language_scanner.c"
yy588:
		YYDEBUG(588, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy589;
		if (yych != 'r') goto yy186;
yy589:
		YYDEBUG(589, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy590;
		if (yych != 'f') goto yy186;
yy590:
		YYDEBUG(590, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy591;
		if (yych != 'a') goto yy186;
yy591:
		YYDEBUG(591, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy592;
		if (yych != 'c') goto yy186;
yy592:
		YYDEBUG(592, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy593;
		if (yych != 'e') goto yy186;
yy593:
		YYDEBUG(593, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(594, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1131 "Zend/zend_language_scanner.l"
		{
	return T_INTERFACE;
}
#line 5845 "Zend/zend_language_scanner.c"
yy595:
		YYDEBUG(595, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'E') {
			if (yych == 'A') goto yy596;
			if (yych <= 'D') goto yy186;
			goto yy597;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy186;
			} else {
				if (yych == 'e') goto yy597;
				goto yy186;
			}
		}
yy596:
		YYDEBUG(596, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy603;
		if (yych == 'n') goto yy603;
		goto yy186;
yy597:
		YYDEBUG(597, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy598;
		if (yych != 'a') goto yy186;
yy598:
		YYDEBUG(598, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy599;
		if (yych != 'd') goto yy186;
yy599:
		YYDEBUG(599, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy600;
		if (yych != 'o') goto yy186;
yy600:
		YYDEBUG(600, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy601;
		if (yych != 'f') goto yy186;
yy601:
		YYDEBUG(601, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(602, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1257 "Zend/zend_language_scanner.l"
		{
        return T_INSTEADOF;
}
#line 5899 "Zend/zend_language_scanner.c"
yy603:
		YYDEBUG(603, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy604;
		if (yych != 'c') goto yy186;
yy604:
		YYDEBUG(604, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy605;
		if (yych != 'e') goto yy186;
yy605:
		YYDEBUG(605, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy606;
		if (yych != 'o') goto yy186;
yy606:
		YYDEBUG(606, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy607;
		if (yych != 'f') goto yy186;
yy607:
		YYDEBUG(607, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(608, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1083 "Zend/zend_language_scanner.l"
		{
	return T_INSTANCEOF;
}
#line 5932 "Zend/zend_language_scanner.c"
yy609:
		YYDEBUG(609, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy610;
		if (yych != 'l') goto yy186;
yy610:
		YYDEBUG(610, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy611;
		if (yych != 'e') goto yy186;
yy611:
		YYDEBUG(611, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy612;
		if (yych != 'm') goto yy186;
yy612:
		YYDEBUG(612, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy613;
		if (yych != 'e') goto yy186;
yy613:
		YYDEBUG(613, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy614;
		if (yych != 'n') goto yy186;
yy614:
		YYDEBUG(614, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy615;
		if (yych != 't') goto yy186;
yy615:
		YYDEBUG(615, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy616;
		if (yych != 's') goto yy186;
yy616:
		YYDEBUG(616, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(617, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1143 "Zend/zend_language_scanner.l"
		{
	return T_IMPLEMENTS;
}
#line 5980 "Zend/zend_language_scanner.c"
yy618:
		YYDEBUG(618, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy626;
		if (yych == 'r') goto yy626;
		goto yy186;
yy619:
		YYDEBUG(619, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'Y') {
			if (yych == 'A') goto yy622;
			if (yych <= 'X') goto yy186;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy186;
				goto yy622;
			} else {
				if (yych != 'y') goto yy186;
			}
		}
		YYDEBUG(620, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(621, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1019 "Zend/zend_language_scanner.l"
		{
	return T_TRY;
}
#line 6012 "Zend/zend_language_scanner.c"
yy622:
		YYDEBUG(622, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy623;
		if (yych != 'i') goto yy186;
yy623:
		YYDEBUG(623, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy624;
		if (yych != 't') goto yy186;
yy624:
		YYDEBUG(624, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(625, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1135 "Zend/zend_language_scanner.l"
		{
	return T_TRAIT;
}
#line 6035 "Zend/zend_language_scanner.c"
yy626:
		YYDEBUG(626, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy627;
		if (yych != 'o') goto yy186;
yy627:
		YYDEBUG(627, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy628;
		if (yych != 'w') goto yy186;
yy628:
		YYDEBUG(628, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(629, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1027 "Zend/zend_language_scanner.l"
		{
	return T_THROW;
}
#line 6058 "Zend/zend_language_scanner.c"
yy630:
		YYDEBUG(630, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych == 'Q') goto yy632;
			if (yych <= 'S') goto yy186;
		} else {
			if (yych <= 'q') {
				if (yych <= 'p') goto yy186;
				goto yy632;
			} else {
				if (yych != 't') goto yy186;
			}
		}
		YYDEBUG(631, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy644;
		if (yych == 'u') goto yy644;
		goto yy186;
yy632:
		YYDEBUG(632, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy633;
		if (yych != 'u') goto yy186;
yy633:
		YYDEBUG(633, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy634;
		if (yych != 'i') goto yy186;
yy634:
		YYDEBUG(634, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy635;
		if (yych != 'r') goto yy186;
yy635:
		YYDEBUG(635, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy636;
		if (yych != 'e') goto yy186;
yy636:
		YYDEBUG(636, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy185;
			} else {
				if (yych <= '@') goto yy637;
				if (yych <= 'Z') goto yy185;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy638;
			} else {
				if (yych <= 'z') goto yy185;
				if (yych >= 0x7F) goto yy185;
			}
		}
yy637:
		YYDEBUG(637, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1241 "Zend/zend_language_scanner.l"
		{
	return T_REQUIRE;
}
#line 6123 "Zend/zend_language_scanner.c"
yy638:
		YYDEBUG(638, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy639;
		if (yych != 'o') goto yy186;
yy639:
		YYDEBUG(639, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy640;
		if (yych != 'n') goto yy186;
yy640:
		YYDEBUG(640, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy641;
		if (yych != 'c') goto yy186;
yy641:
		YYDEBUG(641, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy642;
		if (yych != 'e') goto yy186;
yy642:
		YYDEBUG(642, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(643, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1245 "Zend/zend_language_scanner.l"
		{
	return T_REQUIRE_ONCE;
}
#line 6156 "Zend/zend_language_scanner.c"
yy644:
		YYDEBUG(644, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy645;
		if (yych != 'r') goto yy186;
yy645:
		YYDEBUG(645, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy646;
		if (yych != 'n') goto yy186;
yy646:
		YYDEBUG(646, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(647, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1015 "Zend/zend_language_scanner.l"
		{
	return T_RETURN;
}
#line 6179 "Zend/zend_language_scanner.c"
yy648:
		YYDEBUG(648, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych <= 'R') goto yy186;
			if (yych <= 'S') goto yy670;
			goto yy669;
		} else {
			if (yych <= 'r') goto yy186;
			if (yych <= 's') goto yy670;
			if (yych <= 't') goto yy669;
			goto yy186;
		}
yy649:
		YYDEBUG(649, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'A') goto yy661;
			if (yych <= 'N') goto yy186;
			goto yy662;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy186;
				goto yy661;
			} else {
				if (yych == 'o') goto yy662;
				goto yy186;
			}
		}
yy650:
		YYDEBUG(650, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy651;
		if (yych != 'n') goto yy186;
yy651:
		YYDEBUG(651, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych <= 'R') goto yy186;
			if (yych >= 'T') goto yy653;
		} else {
			if (yych <= 'r') goto yy186;
			if (yych <= 's') goto yy652;
			if (yych <= 't') goto yy653;
			goto yy186;
		}
yy652:
		YYDEBUG(652, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy659;
		if (yych == 't') goto yy659;
		goto yy186;
yy653:
		YYDEBUG(653, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy654;
		if (yych != 'i') goto yy186;
yy654:
		YYDEBUG(654, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy655;
		if (yych != 'n') goto yy186;
yy655:
		YYDEBUG(655, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy656;
		if (yych != 'u') goto yy186;
yy656:
		YYDEBUG(656, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy657;
		if (yych != 'e') goto yy186;
yy657:
		YYDEBUG(657, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(658, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1111 "Zend/zend_language_scanner.l"
		{
	return T_CONTINUE;
}
#line 6264 "Zend/zend_language_scanner.c"
yy659:
		YYDEBUG(659, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(660, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1011 "Zend/zend_language_scanner.l"
		{
	return T_CONST;
}
#line 6277 "Zend/zend_language_scanner.c"
yy661:
		YYDEBUG(661, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy666;
		if (yych == 's') goto yy666;
		goto yy186;
yy662:
		YYDEBUG(662, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy663;
		if (yych != 'n') goto yy186;
yy663:
		YYDEBUG(663, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy664;
		if (yych != 'e') goto yy186;
yy664:
		YYDEBUG(664, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(665, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1189 "Zend/zend_language_scanner.l"
		{
	return T_CLONE;
}
#line 6306 "Zend/zend_language_scanner.c"
yy666:
		YYDEBUG(666, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy667;
		if (yych != 's') goto yy186;
yy667:
		YYDEBUG(667, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(668, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1127 "Zend/zend_language_scanner.l"
		{
	return T_CLASS;
}
#line 6324 "Zend/zend_language_scanner.c"
yy669:
		YYDEBUG(669, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy673;
		if (yych == 'c') goto yy673;
		goto yy186;
yy670:
		YYDEBUG(670, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy671;
		if (yych != 'e') goto yy186;
yy671:
		YYDEBUG(671, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(672, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1099 "Zend/zend_language_scanner.l"
		{
	return T_CASE;
}
#line 6348 "Zend/zend_language_scanner.c"
yy673:
		YYDEBUG(673, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy674;
		if (yych != 'h') goto yy186;
yy674:
		YYDEBUG(674, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(675, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1023 "Zend/zend_language_scanner.l"
		{
	return T_CATCH;
}
#line 6366 "Zend/zend_language_scanner.c"
yy676:
		YYDEBUG(676, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy693;
		if (yych == 'n') goto yy693;
		goto yy186;
yy677:
		YYDEBUG(677, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy686;
		if (yych == 'r') goto yy686;
		goto yy186;
yy678:
		YYDEBUG(678, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy679;
		if (yych != 'n') goto yy186;
yy679:
		YYDEBUG(679, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy680;
		if (yych != 'c') goto yy186;
yy680:
		YYDEBUG(680, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy681;
		if (yych != 't') goto yy186;
yy681:
		YYDEBUG(681, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy682;
		if (yych != 'i') goto yy186;
yy682:
		YYDEBUG(682, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy683;
		if (yych != 'o') goto yy186;
yy683:
		YYDEBUG(683, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy684;
		if (yych != 'n') goto yy186;
yy684:
		YYDEBUG(684, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(685, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1007 "Zend/zend_language_scanner.l"
		{
	return T_FUNCTION;
}
#line 6421 "Zend/zend_language_scanner.c"
yy686:
		YYDEBUG(686, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy687;
				if (yych <= '9') goto yy185;
			} else {
				if (yych == 'E') goto yy688;
				if (yych <= 'Z') goto yy185;
			}
		} else {
			if (yych <= 'd') {
				if (yych != '`') goto yy185;
			} else {
				if (yych <= 'e') goto yy688;
				if (yych <= 'z') goto yy185;
				if (yych >= 0x7F) goto yy185;
			}
		}
yy687:
		YYDEBUG(687, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1059 "Zend/zend_language_scanner.l"
		{
	return T_FOR;
}
#line 6449 "Zend/zend_language_scanner.c"
yy688:
		YYDEBUG(688, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy689;
		if (yych != 'a') goto yy186;
yy689:
		YYDEBUG(689, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy690;
		if (yych != 'c') goto yy186;
yy690:
		YYDEBUG(690, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy691;
		if (yych != 'h') goto yy186;
yy691:
		YYDEBUG(691, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(692, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1067 "Zend/zend_language_scanner.l"
		{
	return T_FOREACH;
}
#line 6477 "Zend/zend_language_scanner.c"
yy693:
		YYDEBUG(693, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy694;
		if (yych != 'a') goto yy186;
yy694:
		YYDEBUG(694, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy695;
		if (yych != 'l') goto yy186;
yy695:
		YYDEBUG(695, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(696, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1285 "Zend/zend_language_scanner.l"
		{
	return T_FINAL;
}
#line 6500 "Zend/zend_language_scanner.c"
yy697:
		YYDEBUG(697, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'F') {
			if (yych == 'C') goto yy703;
			if (yych <= 'E') goto yy186;
			goto yy704;
		} else {
			if (yych <= 'c') {
				if (yych <= 'b') goto yy186;
				goto yy703;
			} else {
				if (yych == 'f') goto yy704;
				goto yy186;
			}
		}
yy698:
		YYDEBUG(698, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy701;
		if (yych == 'e') goto yy701;
		goto yy186;
yy699:
		YYDEBUG(699, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(700, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1055 "Zend/zend_language_scanner.l"
		{
	return T_DO;
}
#line 6535 "Zend/zend_language_scanner.c"
yy701:
		YYDEBUG(701, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(702, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1003 "Zend/zend_language_scanner.l"
		{
	return T_EXIT;
}
#line 6548 "Zend/zend_language_scanner.c"
yy703:
		YYDEBUG(703, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy710;
		if (yych == 'l') goto yy710;
		goto yy186;
yy704:
		YYDEBUG(704, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy705;
		if (yych != 'a') goto yy186;
yy705:
		YYDEBUG(705, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy706;
		if (yych != 'u') goto yy186;
yy706:
		YYDEBUG(706, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy707;
		if (yych != 'l') goto yy186;
yy707:
		YYDEBUG(707, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy708;
		if (yych != 't') goto yy186;
yy708:
		YYDEBUG(708, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(709, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1103 "Zend/zend_language_scanner.l"
		{
	return T_DEFAULT;
}
#line 6587 "Zend/zend_language_scanner.c"
yy710:
		YYDEBUG(710, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy711;
		if (yych != 'a') goto yy186;
yy711:
		YYDEBUG(711, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy712;
		if (yych != 'r') goto yy186;
yy712:
		YYDEBUG(712, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy713;
		if (yych != 'e') goto yy186;
yy713:
		YYDEBUG(713, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(714, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1075 "Zend/zend_language_scanner.l"
		{
	return T_DECLARE;
}
#line 6615 "Zend/zend_language_scanner.c"
yy715:
		YYDEBUG(715, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy777;
		if (yych == 'h') goto yy777;
		goto yy186;
yy716:
		YYDEBUG(716, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy771;
		if (yych == 's') goto yy771;
		goto yy186;
yy717:
		YYDEBUG(717, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy767;
		if (yych == 'p') goto yy767;
		goto yy186;
yy718:
		YYDEBUG(718, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy733;
		if (yych == 'd') goto yy733;
		goto yy186;
yy719:
		YYDEBUG(719, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy730;
		if (yych == 'a') goto yy730;
		goto yy186;
yy720:
		YYDEBUG(720, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych == 'I') goto yy721;
			if (yych <= 'S') goto yy186;
			goto yy722;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy186;
			} else {
				if (yych == 't') goto yy722;
				goto yy186;
			}
		}
yy721:
		YYDEBUG(721, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy728;
		if (yych == 't') goto yy728;
		goto yy186;
yy722:
		YYDEBUG(722, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy723;
		if (yych != 'e') goto yy186;
yy723:
		YYDEBUG(723, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy724;
		if (yych != 'n') goto yy186;
yy724:
		YYDEBUG(724, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy725;
		if (yych != 'd') goto yy186;
yy725:
		YYDEBUG(725, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy726;
		if (yych != 's') goto yy186;
yy726:
		YYDEBUG(726, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(727, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1139 "Zend/zend_language_scanner.l"
		{
	return T_EXTENDS;
}
#line 6699 "Zend/zend_language_scanner.c"
yy728:
		YYDEBUG(728, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(729, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 999 "Zend/zend_language_scanner.l"
		{
	return T_EXIT;
}
#line 6712 "Zend/zend_language_scanner.c"
yy730:
		YYDEBUG(730, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy731;
		if (yych != 'l') goto yy186;
yy731:
		YYDEBUG(731, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(732, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1229 "Zend/zend_language_scanner.l"
		{
	return T_EVAL;
}
#line 6730 "Zend/zend_language_scanner.c"
yy733:
		YYDEBUG(733, *YYCURSOR);
		yych = *++YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case 'D':
		case 'd':	goto yy734;
		case 'F':
		case 'f':	goto yy735;
		case 'I':
		case 'i':	goto yy736;
		case 'S':
		case 's':	goto yy737;
		case 'W':
		case 'w':	goto yy738;
		default:	goto yy186;
		}
yy734:
		YYDEBUG(734, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy760;
		if (yych == 'e') goto yy760;
		goto yy186;
yy735:
		YYDEBUG(735, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy752;
		if (yych == 'o') goto yy752;
		goto yy186;
yy736:
		YYDEBUG(736, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy750;
		if (yych == 'f') goto yy750;
		goto yy186;
yy737:
		YYDEBUG(737, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy744;
		if (yych == 'w') goto yy744;
		goto yy186;
yy738:
		YYDEBUG(738, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy739;
		if (yych != 'h') goto yy186;
yy739:
		YYDEBUG(739, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy740;
		if (yych != 'i') goto yy186;
yy740:
		YYDEBUG(740, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy741;
		if (yych != 'l') goto yy186;
yy741:
		YYDEBUG(741, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy742;
		if (yych != 'e') goto yy186;
yy742:
		YYDEBUG(742, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(743, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1051 "Zend/zend_language_scanner.l"
		{
	return T_ENDWHILE;
}
#line 6804 "Zend/zend_language_scanner.c"
yy744:
		YYDEBUG(744, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy745;
		if (yych != 'i') goto yy186;
yy745:
		YYDEBUG(745, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy746;
		if (yych != 't') goto yy186;
yy746:
		YYDEBUG(746, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy747;
		if (yych != 'c') goto yy186;
yy747:
		YYDEBUG(747, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy748;
		if (yych != 'h') goto yy186;
yy748:
		YYDEBUG(748, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(749, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1095 "Zend/zend_language_scanner.l"
		{
	return T_ENDSWITCH;
}
#line 6837 "Zend/zend_language_scanner.c"
yy750:
		YYDEBUG(750, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(751, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1039 "Zend/zend_language_scanner.l"
		{
	return T_ENDIF;
}
#line 6850 "Zend/zend_language_scanner.c"
yy752:
		YYDEBUG(752, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy753;
		if (yych != 'r') goto yy186;
yy753:
		YYDEBUG(753, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy754;
				if (yych <= '9') goto yy185;
			} else {
				if (yych == 'E') goto yy755;
				if (yych <= 'Z') goto yy185;
			}
		} else {
			if (yych <= 'd') {
				if (yych != '`') goto yy185;
			} else {
				if (yych <= 'e') goto yy755;
				if (yych <= 'z') goto yy185;
				if (yych >= 0x7F) goto yy185;
			}
		}
yy754:
		YYDEBUG(754, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1063 "Zend/zend_language_scanner.l"
		{
	return T_ENDFOR;
}
#line 6883 "Zend/zend_language_scanner.c"
yy755:
		YYDEBUG(755, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy756;
		if (yych != 'a') goto yy186;
yy756:
		YYDEBUG(756, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy757;
		if (yych != 'c') goto yy186;
yy757:
		YYDEBUG(757, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy758;
		if (yych != 'h') goto yy186;
yy758:
		YYDEBUG(758, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(759, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1071 "Zend/zend_language_scanner.l"
		{
	return T_ENDFOREACH;
}
#line 6911 "Zend/zend_language_scanner.c"
yy760:
		YYDEBUG(760, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy761;
		if (yych != 'c') goto yy186;
yy761:
		YYDEBUG(761, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy762;
		if (yych != 'l') goto yy186;
yy762:
		YYDEBUG(762, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy763;
		if (yych != 'a') goto yy186;
yy763:
		YYDEBUG(763, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy764;
		if (yych != 'r') goto yy186;
yy764:
		YYDEBUG(764, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy765;
		if (yych != 'e') goto yy186;
yy765:
		YYDEBUG(765, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(766, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1079 "Zend/zend_language_scanner.l"
		{
	return T_ENDDECLARE;
}
#line 6949 "Zend/zend_language_scanner.c"
yy767:
		YYDEBUG(767, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy768;
		if (yych != 't') goto yy186;
yy768:
		YYDEBUG(768, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy769;
		if (yych != 'y') goto yy186;
yy769:
		YYDEBUG(769, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(770, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1269 "Zend/zend_language_scanner.l"
		{
	return T_EMPTY;
}
#line 6972 "Zend/zend_language_scanner.c"
yy771:
		YYDEBUG(771, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy772;
		if (yych != 'e') goto yy186;
yy772:
		YYDEBUG(772, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy773;
				if (yych <= '9') goto yy185;
			} else {
				if (yych == 'I') goto yy774;
				if (yych <= 'Z') goto yy185;
			}
		} else {
			if (yych <= 'h') {
				if (yych != '`') goto yy185;
			} else {
				if (yych <= 'i') goto yy774;
				if (yych <= 'z') goto yy185;
				if (yych >= 0x7F) goto yy185;
			}
		}
yy773:
		YYDEBUG(773, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1043 "Zend/zend_language_scanner.l"
		{
	return T_ELSE;
}
#line 7005 "Zend/zend_language_scanner.c"
yy774:
		YYDEBUG(774, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy775;
		if (yych != 'f') goto yy186;
yy775:
		YYDEBUG(775, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(776, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1035 "Zend/zend_language_scanner.l"
		{
	return T_ELSEIF;
}
#line 7023 "Zend/zend_language_scanner.c"
yy777:
		YYDEBUG(777, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy778;
		if (yych != 'o') goto yy186;
yy778:
		YYDEBUG(778, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(779, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1119 "Zend/zend_language_scanner.l"
		{
	return T_ECHO;
}
#line 7041 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_PROPERTY:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128,   0,   0, 128,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,   0,   0,   0,   0,   0,   0, 
			  0,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,   0,   0,   0,   0,  64, 
			  0,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,   0,   0,   0,   0,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
		};
		YYDEBUG(780, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '-') {
			if (yych <= '\r') {
				if (yych <= 0x08) goto yy788;
				if (yych <= '\n') goto yy782;
				if (yych <= '\f') goto yy788;
			} else {
				if (yych == ' ') goto yy782;
				if (yych <= ',') goto yy788;
				goto yy784;
			}
		} else {
			if (yych <= '_') {
				if (yych <= '@') goto yy788;
				if (yych <= 'Z') goto yy786;
				if (yych <= '^') goto yy788;
				goto yy786;
			} else {
				if (yych <= '`') goto yy788;
				if (yych <= 'z') goto yy786;
				if (yych <= '~') goto yy788;
				goto yy786;
			}
		}
yy782:
		YYDEBUG(782, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy794;
yy783:
		YYDEBUG(783, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1152 "Zend/zend_language_scanner.l"
		{
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	HANDLE_NEWLINES(yytext, yyleng);
	return T_WHITESPACE;
}
#line 7122 "Zend/zend_language_scanner.c"
yy784:
		YYDEBUG(784, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '>') goto yy791;
yy785:
		YYDEBUG(785, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1171 "Zend/zend_language_scanner.l"
		{
	yyless(0);
	yy_pop_state(TSRMLS_C);
	goto restart;
}
#line 7136 "Zend/zend_language_scanner.c"
yy786:
		YYDEBUG(786, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy790;
yy787:
		YYDEBUG(787, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1164 "Zend/zend_language_scanner.l"
		{
	yy_pop_state(TSRMLS_C);
	zend_copy_value(zendlval, yytext, yyleng);
	zendlval->type = IS_STRING;
	return T_STRING;
}
#line 7152 "Zend/zend_language_scanner.c"
yy788:
		YYDEBUG(788, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy785;
yy789:
		YYDEBUG(789, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy790:
		YYDEBUG(790, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy789;
		}
		goto yy787;
yy791:
		YYDEBUG(791, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(792, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1160 "Zend/zend_language_scanner.l"
		{
	return T_OBJECT_OPERATOR;
}
#line 7177 "Zend/zend_language_scanner.c"
yy793:
		YYDEBUG(793, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy794:
		YYDEBUG(794, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy793;
		}
		goto yy783;
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_VARNAME:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(795, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy799;
			if (yych <= 'Z') goto yy797;
			if (yych <= '^') goto yy799;
		} else {
			if (yych <= '`') goto yy799;
			if (yych <= 'z') goto yy797;
			if (yych <= '~') goto yy799;
		}
yy797:
		YYDEBUG(797, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy802;
yy798:
		YYDEBUG(798, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1447 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, yytext, yyleng);
	zendlval->type = IS_STRING;
	yy_pop_state(TSRMLS_C);
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	return T_STRING_VARNAME;
}
#line 7255 "Zend/zend_language_scanner.c"
yy799:
		YYDEBUG(799, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(800, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1456 "Zend/zend_language_scanner.l"
		{
	yyless(0);
	yy_pop_state(TSRMLS_C);
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	goto restart;
}
#line 7268 "Zend/zend_language_scanner.c"
yy801:
		YYDEBUG(801, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy802:
		YYDEBUG(802, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy801;
		}
		goto yy798;
	}
/* *********************************** */
yyc_ST_NOWDOC:
	YYDEBUG(803, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(805, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(806, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
#line 2283 "Zend/zend_language_scanner.l"
	{
	int newline = 0;

	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && CG(heredoc_len) < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, CG(heredoc), CG(heredoc_len))) {
					YYCTYPE *end = YYCURSOR + CG(heredoc_len);

					if (*end == ';') {
						end++;
					}

					if (*end == '\n' || *end == '\r') {
						/* newline before label will be subtracted from returned text, but
						 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
						if (YYCURSOR[-2] == '\r' && YYCURSOR[-1] == '\n') {
							newline = 2; /* Windows newline */
						} else {
							newline = 1;
						}

						CG(increment_lineno) = 1; /* For newline before label */
						BEGIN(ST_END_HEREDOC);

						goto nowdoc_scan_done;
					}
				}
				/* fall through */
			default:
				continue;
		}
	}

nowdoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_copy_value(zendlval, yytext, yyleng - newline);
	zendlval->type = IS_STRING;
	HANDLE_NEWLINES(yytext, yyleng - newline);
	return T_ENCAPSED_AND_WHITESPACE;
}
#line 7345 "Zend/zend_language_scanner.c"
/* *********************************** */
yyc_ST_VAR_OFFSET:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			224, 224, 224, 224, 224, 224, 224, 224, 
			224, 224,   0,   0,   0,   0,   0,   0, 
			  0, 160, 160, 160, 160, 160, 160,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,   0,   0,   0,   0,  32, 
			  0, 160, 160, 160, 160, 160, 160,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,   0,   0,   0,   0,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
		};
		YYDEBUG(807, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '/') {
			if (yych <= ' ') {
				if (yych <= '\f') {
					if (yych <= 0x08) goto yy821;
					if (yych <= '\n') goto yy817;
					goto yy821;
				} else {
					if (yych <= '\r') goto yy817;
					if (yych <= 0x1F) goto yy821;
					goto yy817;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy816;
					if (yych <= '#') goto yy817;
					goto yy812;
				} else {
					if (yych == '\'') goto yy817;
					goto yy816;
				}
			}
		} else {
			if (yych <= '\\') {
				if (yych <= '@') {
					if (yych <= '0') goto yy809;
					if (yych <= '9') goto yy811;
					goto yy816;
				} else {
					if (yych <= 'Z') goto yy819;
					if (yych <= '[') goto yy816;
					goto yy817;
				}
			} else {
				if (yych <= '_') {
					if (yych <= ']') goto yy814;
					if (yych <= '^') goto yy816;
					goto yy819;
				} else {
					if (yych <= '`') goto yy816;
					if (yych <= 'z') goto yy819;
					if (yych <= '~') goto yy816;
					goto yy819;
				}
			}
		}
yy809:
		YYDEBUG(809, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'W') {
			if (yych <= '/') goto yy810;
			if (yych <= '9') goto yy832;
		} else {
			if (yych <= 'X') goto yy830;
			if (yych == 'x') goto yy830;
		}
yy810:
		YYDEBUG(810, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1506 "Zend/zend_language_scanner.l"
		{ /* Offset could be treated as a long */
	if (yyleng < MAX_LENGTH_OF_LONG - 1 || (yyleng == MAX_LENGTH_OF_LONG - 1 && strcmp(yytext, long_min_digits) < 0)) {
		zendlval->value.lval = strtol(yytext, NULL, 10);
		zendlval->type = IS_LONG;
	} else {
		zendlval->value.str.val = (char *)estrndup(yytext, yyleng);
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
	}
	return T_NUM_STRING;
}
#line 7457 "Zend/zend_language_scanner.c"
yy811:
		YYDEBUG(811, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy829;
yy812:
		YYDEBUG(812, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy813;
			if (yych <= 'Z') goto yy825;
			if (yych >= '_') goto yy825;
		} else {
			if (yych <= '`') goto yy813;
			if (yych <= 'z') goto yy825;
			if (yych >= 0x7F) goto yy825;
		}
yy813:
		YYDEBUG(813, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1811 "Zend/zend_language_scanner.l"
		{
	/* Only '[' can be valid, but returning other tokens will allow a more explicit parse error */
	return yytext[0];
}
#line 7482 "Zend/zend_language_scanner.c"
yy814:
		YYDEBUG(814, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(815, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1806 "Zend/zend_language_scanner.l"
		{
	yy_pop_state(TSRMLS_C);
	return ']';
}
#line 7493 "Zend/zend_language_scanner.c"
yy816:
		YYDEBUG(816, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy813;
yy817:
		YYDEBUG(817, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(818, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1816 "Zend/zend_language_scanner.l"
		{
	/* Invalid rule to return a more explicit parse error with proper line number */
	yyless(0);
	yy_pop_state(TSRMLS_C);
	return T_ENCAPSED_AND_WHITESPACE;
}
#line 7510 "Zend/zend_language_scanner.c"
yy819:
		YYDEBUG(819, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy824;
yy820:
		YYDEBUG(820, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1823 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, yytext, yyleng);
	zendlval->type = IS_STRING;
	return T_STRING;
}
#line 7525 "Zend/zend_language_scanner.c"
yy821:
		YYDEBUG(821, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(822, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2339 "Zend/zend_language_scanner.l"
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	zend_error(E_COMPILE_WARNING,"Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	goto restart;
}
#line 7540 "Zend/zend_language_scanner.c"
yy823:
		YYDEBUG(823, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy824:
		YYDEBUG(824, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy823;
		}
		goto yy820;
yy825:
		YYDEBUG(825, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(826, *YYCURSOR);
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy825;
			} else {
				if (yych <= '@') goto yy827;
				if (yych <= 'Z') goto yy825;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy825;
			} else {
				if (yych <= 'z') goto yy825;
				if (yych >= 0x7F) goto yy825;
			}
		}
yy827:
		YYDEBUG(827, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1800 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 7582 "Zend/zend_language_scanner.c"
yy828:
		YYDEBUG(828, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy829:
		YYDEBUG(829, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy828;
		}
		goto yy810;
yy830:
		YYDEBUG(830, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy835;
		}
		YYDEBUG(831, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy810;
yy832:
		YYDEBUG(832, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(833, *YYCURSOR);
		if (yych <= '/') goto yy834;
		if (yych <= '9') goto yy832;
yy834:
		YYDEBUG(834, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1518 "Zend/zend_language_scanner.l"
		{ /* Offset must be treated as a string */
	zendlval->value.str.val = (char *)estrndup(yytext, yyleng);
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	return T_NUM_STRING;
}
#line 7621 "Zend/zend_language_scanner.c"
yy835:
		YYDEBUG(835, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(836, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy835;
		}
		goto yy834;
	}
}
#line 2348 "Zend/zend_language_scanner.l"

}
