#!/bin/bash

# @ Martin Kellogg, July 1 2015

# this script is meant to instrument a version of php so that it detects negative test differences instead of checking if we get the negative test exactly right, for the purpose of proactive diversity. It's primary purpose is to reduce human error in this process. Some parts of it are manual; be aware.

# $1 is the path to the genprog executable you want to use
REPAIR=$1

if [ -z "$REPAIR" ]; then
    echo "please supply a path to genprog as the first argument"
    exit 1
fi

if [ ! -f $REPAIR ]; then
    echo "$REPAIR is not a valid file :("
    exit 1
fi

if [ ! -f php-infrastructure.tar.gz ]; then
    echo "please grab the php-infrastructure.tar.gz file from the genprog-pd repo and move it here before running this script"
    exit 1
fi

tar xf php-infrastructure.tar.gz

php-infrastructure/instrument-php-helper.py test-list > php/list_of_tests
php-infrastructure/instrument-php-helper.py find-negs > php/list_of_indices

cp php-infrastructure/test-maker.py php/

# a call needs to be inserted into the compile.pl script to test_maker.py so that it's called after the program is compiled.
# I don't want to do this automatically because every version of compile.pl isn't the same.
# as it turns out this isn't entirely true. They're all the same within the subset that we're worrying about :)

#emacs +75 compile.pl
cp compile.pl ../compile.pl-old
cp ../compile.pl-new compile.pl

# similarly, the php test script has to be modified
# and similarly I'm not doing this by hand because that's ridiculous
#emacs +1573 php-helper.php php-infrastructure/phphelperpatch.txt
cp php-helper.php ../php-helper.php-old
cp ../php-helper.php-new php-helper.php

php-infrastructure/configuration-rewriter.py configuration-default > configuration-instrument

$REPAIR configuration-instrument

cp php-infrastructure/retar-tests.py php/

cd php
./retar-tests.py list_of_tests list_of_indices
cd ..

#mv php-helper.php~ php-helper.php
#mv compile.pl~ compile.pl

cp ../php-helper.php-old php-helper.php
cp ../compiler.pl-old compile.pl

cp php-infrastructure/make-run-neg-tests.py .
./make-run-neg-tests.py

sed -i "/n[0-9]/s/run_test/run_neg_test/g" test.sh
# I need a human to write the run_neg_test function
emacs test.sh