/* Generated by re2c 0.13.5 on Mon Mar 21 17:35:32 2011 */
#line 1 "ext/date/lib/parse_date.re"
/*
   +----------------------------------------------------------------------+
   | PHP Version 5                                                        |
   +----------------------------------------------------------------------+
   | Copyright (c) 1997-2010 The PHP Group                                |
   +----------------------------------------------------------------------+
   | This source file is subject to version 3.01 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.php.net/license/3_01.txt                                  |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Authors: Derick Rethans <derick@derickrethans.nl>                    |
   +----------------------------------------------------------------------+
 */

/* $Id$ */

#include "timelib.h"

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <assert.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#if defined(_MSC_VER)
# define strtoll(s, f, b) _atoi64(s)
#elif !defined(HAVE_STRTOLL)
# if defined(HAVE_ATOLL)
#  define strtoll(s, f, b) atoll(s)
# else
#  define strtoll(s, f, b) strtol(s, f, b)
# endif
#endif

#define TIMELIB_UNSET   -99999

#define TIMELIB_SECOND  1
#define TIMELIB_MINUTE  2
#define TIMELIB_HOUR    3
#define TIMELIB_DAY     4
#define TIMELIB_MONTH   5
#define TIMELIB_YEAR    6
#define TIMELIB_WEEKDAY 7
#define TIMELIB_SPECIAL 8

#define EOI      257
#define TIME     258
#define DATE     259

#define TIMELIB_XMLRPC_SOAP    260
#define TIMELIB_TIME12         261
#define TIMELIB_TIME24         262
#define TIMELIB_GNU_NOCOLON    263
#define TIMELIB_GNU_NOCOLON_TZ 264
#define TIMELIB_ISO_NOCOLON    265

#define TIMELIB_AMERICAN       266
#define TIMELIB_ISO_DATE       267
#define TIMELIB_DATE_FULL      268
#define TIMELIB_DATE_TEXT      269
#define TIMELIB_DATE_NOCOLON   270
#define TIMELIB_PG_YEARDAY     271
#define TIMELIB_PG_TEXT        272
#define TIMELIB_PG_REVERSE     273
#define TIMELIB_CLF            274
#define TIMELIB_DATE_NO_DAY    275
#define TIMELIB_SHORTDATE_WITH_TIME 276
#define TIMELIB_DATE_FULL_POINTED 277
#define TIMELIB_TIME24_WITH_ZONE 278
#define TIMELIB_ISO_WEEK       279
#define TIMELIB_LF_DAY_OF_MONTH 280
#define TIMELIB_WEEK_DAY_OF_MONTH 281

#define TIMELIB_TIMEZONE       300
#define TIMELIB_AGO            301

#define TIMELIB_RELATIVE       310

#define TIMELIB_ERROR          999

/* Some compilers like AIX, defines uchar in sys/types.h */
#undef uchar
typedef unsigned char uchar;

#define   BSIZE	   8192

#define   YYCTYPE      uchar
#define   YYCURSOR     cursor
#define   YYLIMIT      s->lim
#define   YYMARKER     s->ptr
#define   YYFILL(n)    return EOI;

#define   RET(i)       {s->cur = cursor; return i;}

#define timelib_string_free free

#define TIMELIB_HAVE_TIME() { if (s->time->have_time) { add_error(s, "Double time specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_time = 1; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; } }
#define TIMELIB_UNHAVE_TIME() { s->time->have_time = 0; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; }
#define TIMELIB_HAVE_DATE() { if (s->time->have_date) { add_error(s, "Double date specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_date = 1; } }
#define TIMELIB_UNHAVE_DATE() { s->time->have_date = 0; s->time->d = 0; s->time->m = 0; s->time->y = 0; }
#define TIMELIB_HAVE_RELATIVE() { s->time->have_relative = 1; }
#define TIMELIB_HAVE_WEEKDAY_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_weekday_relative = 1; }
#define TIMELIB_HAVE_SPECIAL_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_special_relative = 1; }
#define TIMELIB_HAVE_TZ() { s->cur = cursor; if (s->time->have_zone) { s->time->have_zone > 1 ? add_error(s, "Double timezone specification") : add_warning(s, "Double timezone specification"); timelib_string_free(str); s->time->have_zone++; return TIMELIB_ERROR; } else { s->time->have_zone++; } }

#define TIMELIB_INIT  s->cur = cursor; str = timelib_string(s); ptr = str
#define TIMELIB_DEINIT timelib_string_free(str)
#define TIMELIB_ADJUST_RELATIVE_WEEKDAY() if (in->time.have_weekday_relative && (in.rel.d > 0)) { in.rel.d -= 7; }

#define TIMELIB_PROCESS_YEAR(x) { \
	if ((x) == TIMELIB_UNSET) {         \
	/*	(x) = 0; */          \
	} else if ((x) < 100) {  \
		if ((x) < 70) {      \
			(x) += 2000;     \
		} else {             \
			(x) += 1900;     \
		}                    \
	}                        \
}

#ifdef DEBUG_PARSER
#define DEBUG_OUTPUT(s) printf("%s\n", s);
#define YYDEBUG(s,c) { if (s != -1) { printf("state: %d ", s); printf("[%c]\n", c); } }
#else
#define DEBUG_OUTPUT(s)
#define YYDEBUG(s,c)
#endif

#include "timelib_structs.h"

typedef struct timelib_elems {
	unsigned int   c; /* Number of elements */
	char         **v; /* Values */
} timelib_elems;

typedef struct Scanner {
	int           fd;
	uchar        *lim, *str, *ptr, *cur, *tok, *pos;
	unsigned int  line, len;
	struct timelib_error_container *errors;

	struct timelib_time *time;
	const timelib_tzdb  *tzdb;
} Scanner;

typedef struct _timelib_lookup_table {
    const char *name;
    int         type;
    int         value;
} timelib_lookup_table;

typedef struct _timelib_relunit {
	const char *name;
	int         unit;
	int         multiplier;
} timelib_relunit;

#define HOUR(a) (int)(a * 60)

/* The timezone table. */
const static timelib_tz_lookup_table timelib_timezone_lookup[] = {
#include "timezonemap.h"
	{ NULL, 0, 0, NULL },
};

const static timelib_tz_lookup_table timelib_timezone_fallbackmap[] = {
#include "fallbackmap.h"
	{ NULL, 0, 0, NULL },
};

const static timelib_tz_lookup_table timelib_timezone_utc[] = {
	{ "utc", 0, 0, "UTC" },
};

static timelib_relunit const timelib_relunit_lookup[] = {
	{ "sec",         TIMELIB_SECOND,  1 },
	{ "secs",        TIMELIB_SECOND,  1 },
	{ "second",      TIMELIB_SECOND,  1 },
	{ "seconds",     TIMELIB_SECOND,  1 },
	{ "min",         TIMELIB_MINUTE,  1 },
	{ "mins",        TIMELIB_MINUTE,  1 },
	{ "minute",      TIMELIB_MINUTE,  1 },
	{ "minutes",     TIMELIB_MINUTE,  1 },
	{ "hour",        TIMELIB_HOUR,    1 },
	{ "hours",       TIMELIB_HOUR,    1 },
	{ "day",         TIMELIB_DAY,     1 },
	{ "days",        TIMELIB_DAY,     1 },
	{ "week",        TIMELIB_DAY,     7 },
	{ "weeks",       TIMELIB_DAY,     7 },
	{ "fortnight",   TIMELIB_DAY,    14 },
	{ "fortnights",  TIMELIB_DAY,    14 },
	{ "forthnight",  TIMELIB_DAY,    14 },
	{ "forthnights", TIMELIB_DAY,    14 },
	{ "month",       TIMELIB_MONTH,   1 },
	{ "months",      TIMELIB_MONTH,   1 },
	{ "year",        TIMELIB_YEAR,    1 },
	{ "years",       TIMELIB_YEAR,    1 },

	{ "monday",      TIMELIB_WEEKDAY, 1 },
	{ "mon",         TIMELIB_WEEKDAY, 1 },
	{ "tuesday",     TIMELIB_WEEKDAY, 2 },
	{ "tue",         TIMELIB_WEEKDAY, 2 },
	{ "wednesday",   TIMELIB_WEEKDAY, 3 },
	{ "wed",         TIMELIB_WEEKDAY, 3 },
	{ "thursday",    TIMELIB_WEEKDAY, 4 },
	{ "thu",         TIMELIB_WEEKDAY, 4 },
	{ "friday",      TIMELIB_WEEKDAY, 5 },
	{ "fri",         TIMELIB_WEEKDAY, 5 },
	{ "saturday",    TIMELIB_WEEKDAY, 6 },
	{ "sat",         TIMELIB_WEEKDAY, 6 },
	{ "sunday",      TIMELIB_WEEKDAY, 0 },
	{ "sun",         TIMELIB_WEEKDAY, 0 },

	{ "weekday",     TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ "weekdays",    TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ NULL,          0,          0 }
};

/* The relative text table. */
static timelib_lookup_table const timelib_reltext_lookup[] = {
	{ "first",    0,  1 },
	{ "next",     0,  1 },
	{ "second",   0,  2 },
	{ "third",    0,  3 },
	{ "fourth",   0,  4 },
	{ "fifth",    0,  5 },
	{ "sixth",    0,  6 },
	{ "seventh",  0,  7 },
	{ "eight",    0,  8 },
	{ "eighth",   0,  8 },
	{ "ninth",    0,  9 },
	{ "tenth",    0, 10 },
	{ "eleventh", 0, 11 },
	{ "twelfth",  0, 12 },
	{ "last",     0, -1 },
	{ "previous", 0, -1 },
	{ "this",     1,  0 },
	{ NULL,       1,  0 }
};

/* The month table. */
static timelib_lookup_table const timelib_month_lookup[] = {
	{ "jan",  0,  1 },
	{ "feb",  0,  2 },
	{ "mar",  0,  3 },
	{ "apr",  0,  4 },
	{ "may",  0,  5 },
	{ "jun",  0,  6 },
	{ "jul",  0,  7 },
	{ "aug",  0,  8 },
	{ "sep",  0,  9 },
	{ "sept", 0,  9 },
	{ "oct",  0, 10 },
	{ "nov",  0, 11 },
	{ "dec",  0, 12 },
	{ "i",    0,  1 },
	{ "ii",   0,  2 },
	{ "iii",  0,  3 },
	{ "iv",   0,  4 },
	{ "v",    0,  5 },
	{ "vi",   0,  6 },
	{ "vii",  0,  7 },
	{ "viii", 0,  8 },
	{ "ix",   0,  9 },
	{ "x",    0, 10 },
	{ "xi",   0, 11 },
	{ "xii",  0, 12 },

	{ "january",   0,  1 },
	{ "february",  0,  2 },
	{ "march",     0,  3 },
	{ "april",     0,  4 },
	{ "may",       0,  5 },
	{ "june",      0,  6 },
	{ "july",      0,  7 },
	{ "august",    0,  8 },
	{ "september", 0,  9 },
	{ "october",   0, 10 },
	{ "november",  0, 11 },
	{ "december",  0, 12 },
	{  NULL,       0,  0 }
};

#if 0
static char* timelib_ltrim(char *s)
{
	char *ptr = s;
	while (ptr[0] == ' ' || ptr[0] == '\t') {
		ptr++;
	}
	return ptr;
}
#endif

#if 0
uchar *fill(Scanner *s, uchar *cursor){
	if(!s->eof){
		unsigned int cnt = s->tok - s->bot;
		if(cnt){
			memcpy(s->bot, s->tok, s->lim - s->tok);
			s->tok = s->bot;
			s->ptr -= cnt;
			cursor -= cnt;
			s->pos -= cnt;
			s->lim -= cnt;
		}
		if((s->top - s->lim) < BSIZE){
			uchar *buf = (uchar*) malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
			memcpy(buf, s->tok, s->lim - s->tok);
			s->tok = buf;
			s->ptr = &buf[s->ptr - s->bot];
			cursor = &buf[cursor - s->bot];
			s->pos = &buf[s->pos - s->bot];
			s->lim = &buf[s->lim - s->bot];
			s->top = &s->lim[BSIZE];
			free(s->bot);
			s->bot = buf;
		}
		if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE){
			s->eof = &s->lim[cnt]; *(s->eof)++ = '\n';
		}
		s->lim += cnt;
	}
	return cursor;
}
#endif

static void add_warning(Scanner *s, char *error)
{
	s->errors->warning_count++;
	s->errors->warning_messages = realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].message = strdup(error);
}

static void add_error(Scanner *s, char *error)
{
	s->errors->error_count++;
	s->errors->error_messages = realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->error_messages[s->errors->error_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->error_messages[s->errors->error_count - 1].message = strdup(error);
}

static void add_pbf_warning(Scanner *s, char *error, char *sptr, char *cptr)
{
	s->errors->warning_count++;
	s->errors->warning_messages = realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].position = cptr - sptr;
	s->errors->warning_messages[s->errors->warning_count - 1].character = *cptr;
	s->errors->warning_messages[s->errors->warning_count - 1].message = strdup(error);
}

static void add_pbf_error(Scanner *s, char *error, char *sptr, char *cptr)
{
	s->errors->error_count++;
	s->errors->error_messages = realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].position = cptr - sptr;
	s->errors->error_messages[s->errors->error_count - 1].character = *cptr;
	s->errors->error_messages[s->errors->error_count - 1].message = strdup(error);
}

static timelib_sll timelib_meridian(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		*ptr += 3;
	} else {
		++*ptr;
	}
	return retval;
}

static timelib_sll timelib_meridian_with_check(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		++*ptr;
		if (**ptr != 'm' && **ptr != 'M') {
			return TIMELIB_UNSET;
		}
		++*ptr;
		if (**ptr != '.' ) {
			return TIMELIB_UNSET;
		}
		++*ptr;
	} else if (**ptr == 'm' || **ptr == 'M') {
		++*ptr;
	} else {
		return TIMELIB_UNSET;
	}
	return retval;
}

static char *timelib_string(Scanner *s)
{
	char *tmp = calloc(1, s->cur - s->tok + 1);
	memcpy(tmp, s->tok, s->cur - s->tok);

	return tmp;
}

static timelib_sll timelib_get_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	timelib_sll tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr < '0') || (**ptr > '9')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtoll(str, NULL, 10);
	free(str);
	return tmp_nr;
}

static void timelib_skip_day_suffix(char **ptr)
{
	if (isspace(**ptr)) {
		return;
	}
	if (!strncasecmp(*ptr, "nd", 2) || !strncasecmp(*ptr, "rd", 2) ||!strncasecmp(*ptr, "st", 2) || !strncasecmp(*ptr, "th", 2)) {
		*ptr += 2;
	}
}

static double timelib_get_frac_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	double tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr != '.') && (**ptr != ':') && ((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while (((**ptr == '.') || (**ptr == ':') || ((**ptr >= '0') && (**ptr <= '9'))) && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	if (str[0] == ':') {
		str[0] = '.';
	}
	tmp_nr = strtod(str, NULL);
	free(str);
	return tmp_nr;
}

static timelib_ull timelib_get_unsigned_nr(char **ptr, int max_length)
{
	timelib_ull dir = 1;

	while (((**ptr < '0') || (**ptr > '9')) && (**ptr != '+') && (**ptr != '-')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}

	while (**ptr == '+' || **ptr == '-')
	{
		if (**ptr == '-') {
			dir *= -1;
		}
		++*ptr;
	}
	return dir * timelib_get_nr(ptr, max_length);
}

static long timelib_parse_tz_cor(char **ptr)
{
	char *begin = *ptr, *end;
	long  tmp;

	while (isdigit(**ptr) || **ptr == ':') {
		++*ptr;
	}
	end = *ptr;
	switch (end - begin) {
		case 1:
		case 2:
			return HOUR(strtol(begin, NULL, 10));
			break;
		case 3:
		case 4:
			if (begin[1] == ':') {
				tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 2, NULL, 10);
				return tmp;
			} else if (begin[2] == ':') {
				tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 3, NULL, 10);
				return tmp;
			} else {
				tmp = strtol(begin, NULL, 10);
				return HOUR(tmp / 100) + tmp % 100;
			}
		case 5:
			tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 3, NULL, 10);
			return tmp;
	}
	return 0;
}

static timelib_sll timelib_lookup_relative_text(char **ptr, int *behavior)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_sll  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_reltext_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
			*behavior = tp->type;
		}
	}

	free(word);
	return value;
}

static timelib_sll timelib_get_relative_text(char **ptr, int *behavior)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_relative_text(ptr, behavior);
}

static long timelib_lookup_month(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_month_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
		}
	}

	free(word);
	return value;
}

static long timelib_get_month(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '.' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_month(ptr);
}

static void timelib_eat_spaces(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t') {
		++*ptr;
	}
}

static void timelib_eat_until_separator(char **ptr)
{
	++*ptr;
	while (strchr(" \t.,:;/-0123456789", **ptr) == NULL) {
		++*ptr;
	}
}

static const timelib_relunit* timelib_lookup_relunit(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	const timelib_relunit *tp, *value = NULL;

	while (**ptr != '\0' && **ptr != ' ' && **ptr != ',' && **ptr != '\t') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_relunit_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp;
			break;
		}
	}

	free(word);
	return value;
}

static void timelib_set_relative(char **ptr, timelib_sll amount, int behavior, Scanner *s)
{
	const timelib_relunit* relunit;

	if (!(relunit = timelib_lookup_relunit(ptr))) {
		return;
	}

	switch (relunit->unit) {
		case TIMELIB_SECOND: s->time->relative.s += amount * relunit->multiplier; break;
		case TIMELIB_MINUTE: s->time->relative.i += amount * relunit->multiplier; break;
		case TIMELIB_HOUR:   s->time->relative.h += amount * relunit->multiplier; break;
		case TIMELIB_DAY:    s->time->relative.d += amount * relunit->multiplier; break;
		case TIMELIB_MONTH:  s->time->relative.m += amount * relunit->multiplier; break;
		case TIMELIB_YEAR:   s->time->relative.y += amount * relunit->multiplier; break;

		case TIMELIB_WEEKDAY:
			TIMELIB_HAVE_WEEKDAY_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.d += (amount > 0 ? amount - 1 : amount) * 7;
			s->time->relative.weekday = relunit->multiplier;
			s->time->relative.weekday_behavior = behavior;
			break;

		case TIMELIB_SPECIAL:
			TIMELIB_HAVE_SPECIAL_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.special.type = relunit->multiplier;
			s->time->relative.special.amount = amount;
	}
}

const static timelib_tz_lookup_table* zone_search(const char *word, long gmtoffset, int isdst)
{
	int first_found = 0;
	const timelib_tz_lookup_table  *tp, *first_found_elem = NULL;
	const timelib_tz_lookup_table  *fmp;

	if (strcasecmp("utc", word) == 0 || strcasecmp("gmt", word) == 0) {
		return timelib_timezone_utc;
	}
	
	for (tp = timelib_timezone_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			if (!first_found) {
				first_found = 1;
				first_found_elem = tp;
				if (gmtoffset == -1) {
					return tp;
				}
			}
			if (tp->gmtoffset == gmtoffset) {
				return tp;
			}
		}
	}
	if (first_found) {
		return first_found_elem;
	}

	/* Still didn't find anything, let's find the zone solely based on
	 * offset/isdst then */
	for (fmp = timelib_timezone_fallbackmap; fmp->name; fmp++) {
		if ((fmp->gmtoffset * 3600) == gmtoffset && fmp->type == isdst) {
			return fmp;
		}
	}
	return NULL;
}

static long timelib_lookup_zone(char **ptr, int *dst, char **tz_abbr, int *found)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	const timelib_tz_lookup_table *tp;

	while (**ptr != '\0' && **ptr != ')' && **ptr != ' ') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	if ((tp = zone_search(word, -1, 0))) {
		value = -tp->gmtoffset / 60;
		*dst = tp->type;
		value += tp->type * 60;
		*found = 1;
	} else {
		*found = 0;
	}

	*tz_abbr = word;
	return value;
}

static long timelib_get_zone(char **ptr, int *dst, timelib_time *t, int *tz_not_found, const timelib_tzdb *tzdb)
{
	timelib_tzinfo *res;
	long            retval = 0;

	*tz_not_found = 0;

	while (**ptr == ' ' || **ptr == '\t' || **ptr == '(') {
		++*ptr;
	}
	if ((*ptr)[0] == 'G' && (*ptr)[1] == 'M' && (*ptr)[2] == 'T' && ((*ptr)[3] == '+' || (*ptr)[3] == '-')) {
		*ptr += 3;
	}
	if (**ptr == '+') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = -1 * timelib_parse_tz_cor(ptr);
	} else if (**ptr == '-') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = timelib_parse_tz_cor(ptr);
	} else {
		int found = 0;
		long offset;
		char *tz_abbr;

		t->is_localtime = 1;

		offset = timelib_lookup_zone(ptr, dst, &tz_abbr, &found);
		if (found) {
			t->zone_type = TIMELIB_ZONETYPE_ABBR;
		}
#if 0
		/* If we found a TimeZone identifier, use it */
		if (tz_name) {
			t->tz_info = timelib_parse_tzfile(tz_name);
			t->zone_type = TIMELIB_ZONETYPE_ID;
		}
#endif
		/* If we have a TimeZone identifier to start with, use it */
		if (strstr(tz_abbr, "/") || strcmp(tz_abbr, "UTC") == 0) {
			if ((res = timelib_parse_tzfile(tz_abbr, tzdb)) != NULL) {
				t->tz_info = res;
				t->zone_type = TIMELIB_ZONETYPE_ID;
				found++;
			}
		}
		if (found && t->zone_type != TIMELIB_ZONETYPE_ID) {
			timelib_time_tz_abbr_update(t, tz_abbr);
		}
		free(tz_abbr);
		*tz_not_found = (found == 0);
		retval = offset;
	}
	while (**ptr == ')') {
		++*ptr;
	}
	return retval;
}

#define timelib_split_free(arg) {       \
	int i;                         \
	for (i = 0; i < arg.c; i++) {  \
		free(arg.v[i]);            \
	}                              \
	if (arg.v) {                   \
		free(arg.v);               \
	}                              \
}

static int scan(Scanner *s)
{
	uchar *cursor = s->cur;
	char *str, *ptr = NULL;
		
std:
	s->tok = cursor;
	s->len = 0;
#line 970 "ext/date/lib/parse_date.re"



#line 852 "<stdout>"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;

	if ((YYLIMIT - YYCURSOR) < 31) YYFILL(31);
	yych = *YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\n':	goto yy52;
	case '\t':
	case ' ':	goto yy49;
	case '(':	goto yy46;
	case '+':
	case '-':	goto yy31;
	case ',':
	case '.':	goto yy51;
	case '0':	goto yy26;
	case '1':	goto yy27;
	case '2':	goto yy28;
	case '3':	goto yy29;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy30;
	case '@':	goto yy12;
	case 'A':	goto yy37;
	case 'B':	goto yy18;
	case 'C':
	case 'H':
	case 'K':
	case 'Q':
	case 'R':
	case 'U':
	case 'Z':	goto yy47;
	case 'D':	goto yy41;
	case 'E':	goto yy22;
	case 'F':	goto yy14;
	case 'G':	goto yy45;
	case 'I':	goto yy32;
	case 'J':	goto yy35;
	case 'L':	goto yy16;
	case 'M':	goto yy8;
	case 'N':	goto yy6;
	case 'O':	goto yy39;
	case 'P':	goto yy24;
	case 'S':	goto yy20;
	case 'T':	goto yy10;
	case 'V':	goto yy33;
	case 'W':	goto yy43;
	case 'X':	goto yy34;
	case 'Y':	goto yy3;
	case 'a':	goto yy38;
	case 'b':	goto yy19;
	case 'c':
	case 'g':
	case 'h':
	case 'i':
	case 'k':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy48;
	case 'd':	goto yy42;
	case 'e':	goto yy23;
	case 'f':	goto yy15;
	case 'j':	goto yy36;
	case 'l':	goto yy17;
	case 'm':	goto yy9;
	case 'n':	goto yy7;
	case 'o':	goto yy40;
	case 'p':	goto yy25;
	case 's':	goto yy21;
	case 't':	goto yy11;
	case 'w':	goto yy44;
	case 'y':	goto yy5;
	default:	goto yy54;
	}
yy2:
#line 1055 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("firstdayof | lastdayof");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		/* skip "last day of" or "first day of" */
		if (*ptr == 'l') {
			s->time->relative.first_last_day_of = 2;
		} else {
			s->time->relative.first_last_day_of = 1;
		}

		TIMELIB_DEINIT;
		return TIMELIB_LF_DAY_OF_MONTH;
	}
#line 951 "<stdout>"
yy3:
	++YYCURSOR;
	switch ((yych = *YYCURSOR)) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy141;
	case 'E':	goto yy1523;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy146;
	case 'e':	goto yy1532;
	default:	goto yy4;
	}
yy4:
#line 1637 "ext/date/lib/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("tzcorrection | tz");
		TIMELIB_INIT;
		TIMELIB_HAVE_TZ();
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
		if (tz_not_found) {
			add_error(s, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIMEZONE;
	}
#line 1024 "<stdout>"
yy5:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy141;
	case 'E':
	case 'e':	goto yy1523;
	default:	goto yy4;
	}
yy6:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy141;
	case 'E':	goto yy1494;
	case 'I':	goto yy1495;
	case 'O':	goto yy1493;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy146;
	case 'e':	goto yy1510;
	case 'i':	goto yy1511;
	case 'o':	goto yy1509;
	default:	goto yy4;
	}
yy7:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy141;
	case 'E':
	case 'e':	goto yy1494;
	case 'I':
	case 'i':	goto yy1495;
	case 'O':
	case 'o':	goto yy1493;
	default:	goto yy4;
	}
yy8:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':	goto yy1463;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy141;
	case 'I':	goto yy1464;
	case 'O':	goto yy1465;
	case 'a':	goto yy1478;
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy146;
	case 'i':	goto yy1479;
	case 'o':	goto yy1480;
	default:	goto yy4;
	}
yy9:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'a':	goto yy1463;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy141;
	case 'I':
	case 'i':	goto yy1464;
	case 'O':
	case 'o':	goto yy1465;
	default:	goto yy4;
	}
yy10:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '0':
	case '1':	goto yy1393;
	case '2':	goto yy1394;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1395;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':	goto yy141;
	case 'E':	goto yy1388;
	case 'H':	goto yy1389;
	case 'O':	goto yy1390;
	case 'U':	goto yy1391;
	case 'W':	goto yy1392;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy146;
	case 'e':	goto yy1431;
	case 'h':	goto yy1432;
	case 'o':	goto yy1433;
	case 'u':	goto yy1434;
	case 'w':	goto yy1435;
	default:	goto yy4;
	}
yy11:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '0':
	case '1':	goto yy1393;
	case '2':	goto yy1394;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1395;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy141;
	case 'E':
	case 'e':	goto yy1388;
	case 'H':
	case 'h':	goto yy1389;
	case 'O':
	case 'o':	goto yy1390;
	case 'U':
	case 'u':	goto yy1391;
	case 'W':
	case 'w':	goto yy1392;
	default:	goto yy4;
	}
yy12:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy1384;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1385;
	default:	goto yy13;
	}
yy13:
#line 1732 "ext/date/lib/parse_date.re"
	{
		add_error(s, "Unexpected character");
		goto std;
	}
#line 1476 "<stdout>"
yy14:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy141;
	case 'E':	goto yy1320;
	case 'I':	goto yy1321;
	case 'O':	goto yy1322;
	case 'R':	goto yy1323;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy146;
	case 'e':	goto yy1361;
	case 'i':	goto yy1362;
	case 'o':	goto yy1363;
	case 'r':	goto yy1364;
	default:	goto yy4;
	}
yy15:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy141;
	case 'E':
	case 'e':	goto yy1320;
	case 'I':
	case 'i':	goto yy1321;
	case 'O':
	case 'o':	goto yy1322;
	case 'R':
	case 'r':	goto yy1323;
	default:	goto yy4;
	}
yy16:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':	goto yy1307;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy141;
	case 'a':	goto yy1317;
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy146;
	default:	goto yy4;
	}
yy17:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'a':	goto yy1307;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy141;
	default:	goto yy4;
	}
yy18:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':	goto yy1287;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy141;
	case 'a':	goto yy1304;
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy146;
	default:	goto yy4;
	}
yy19:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'a':	goto yy1287;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy141;
	default:	goto yy4;
	}
yy20:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':	goto yy1230;
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy141;
	case 'E':	goto yy1229;
	case 'I':	goto yy1231;
	case 'U':	goto yy1232;
	case 'a':	goto yy1259;
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy146;
	case 'e':	goto yy1258;
	case 'i':	goto yy1260;
	case 'u':	goto yy1261;
	default:	goto yy4;
	}
yy21:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'a':	goto yy1230;
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy141;
	case 'E':
	case 'e':	goto yy1229;
	case 'I':
	case 'i':	goto yy1231;
	case 'U':
	case 'u':	goto yy1232;
	default:	goto yy4;
	}
yy22:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy141;
	case 'I':	goto yy1199;
	case 'L':	goto yy1200;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy146;
	case 'i':	goto yy1217;
	case 'l':	goto yy1218;
	default:	goto yy4;
	}
yy23:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy141;
	case 'I':
	case 'i':	goto yy1199;
	case 'L':
	case 'l':	goto yy1200;
	default:	goto yy4;
	}
yy24:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy141;
	case 'R':	goto yy1098;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy146;
	case 'r':	goto yy1192;
	default:	goto yy4;
	}
yy25:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy141;
	case 'R':
	case 'r':	goto yy1098;
	default:	goto yy4;
	}
yy26:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy1052;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'w':
	case 'y':	goto yy1054;
	case '-':	goto yy473;
	case '.':	goto yy1064;
	case '/':	goto yy472;
	case '0':	goto yy1097;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1096;
	case ':':	goto yy1065;
	case 'n':	goto yy470;
	case 'r':	goto yy471;
	case 's':	goto yy464;
	case 't':	goto yy468;
	default:	goto yy13;
	}
yy27:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy460;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy462;
	case '-':	goto yy473;
	case '.':	goto yy474;
	case '/':	goto yy472;
	case '0':
	case '1':
	case '2':	goto yy1096;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1063;
	case ':':	goto yy483;
	case 'n':	goto yy470;
	case 'r':	goto yy471;
	case 's':	goto yy464;
	case 't':	goto yy468;
	default:	goto yy13;
	}
yy28:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy460;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy462;
	case '-':	goto yy473;
	case '.':	goto yy474;
	case '/':	goto yy472;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':	goto yy1063;
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1050;
	case ':':	goto yy483;
	case 'n':	goto yy470;
	case 'r':	goto yy471;
	case 's':	goto yy464;
	case 't':	goto yy468;
	default:	goto yy13;
	}
yy29:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy460;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy462;
	case '-':	goto yy473;
	case '.':	goto yy474;
	case '/':	goto yy472;
	case '0':
	case '1':	goto yy1050;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy469;
	case ':':	goto yy483;
	case 'n':	goto yy470;
	case 'r':	goto yy471;
	case 's':	goto yy464;
	case 't':	goto yy468;
	default:	goto yy13;
	}
yy30:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy460;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy462;
	case '-':	goto yy473;
	case '.':	goto yy474;
	case '/':	goto yy472;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy469;
	case ':':	goto yy483;
	case 'n':	goto yy470;
	case 'r':	goto yy471;
	case 's':	goto yy464;
	case 't':	goto yy468;
	default:	goto yy13;
	}
yy31:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy58;
	case '+':
	case '-':	goto yy440;
	case '0':
	case '1':	goto yy437;
	case '2':	goto yy438;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy439;
	default:	goto yy13;
	}
yy32:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'W':
	case 'Y':
	case 'Z':	goto yy141;
	case 'I':	goto yy436;
	case 'V':
	case 'X':	goto yy435;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy146;
	default:	goto yy4;
	}
yy33:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy141;
	case 'I':	goto yy432;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy146;
	default:	goto yy4;
	}
yy34:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy141;
	case 'I':	goto yy430;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy146;
	default:	goto yy4;
	}
yy35:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':	goto yy413;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy141;
	case 'U':	goto yy412;
	case 'a':	goto yy422;
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy146;
	case 'u':	goto yy421;
	default:	goto yy4;
	}
yy36:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'a':	goto yy413;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy141;
	case 'U':
	case 'u':	goto yy412;
	default:	goto yy4;
	}
yy37:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy141;
	case 'G':	goto yy391;
	case 'P':	goto yy390;
	case 'U':	goto yy389;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy146;
	case 'g':	goto yy403;
	case 'p':	goto yy402;
	case 'u':	goto yy401;
	default:	goto yy4;
	}
yy38:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy141;
	case 'G':
	case 'g':	goto yy391;
	case 'P':
	case 'p':	goto yy390;
	case 'U':
	case 'u':	goto yy389;
	default:	goto yy4;
	}
yy39:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy141;
	case 'C':	goto yy379;
	case 'a':
	case 'b':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy146;
	case 'c':	goto yy384;
	default:	goto yy4;
	}
yy40:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy141;
	case 'C':
	case 'c':	goto yy379;
	default:	goto yy4;
	}
yy41:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy141;
	case 'E':	goto yy192;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy146;
	case 'e':	goto yy370;
	default:	goto yy4;
	}
yy42:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy141;
	case 'E':
	case 'e':	goto yy192;
	default:	goto yy4;
	}
yy43:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy141;
	case 'E':	goto yy165;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy146;
	case 'e':	goto yy179;
	default:	goto yy4;
	}
yy44:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy141;
	case 'E':
	case 'e':	goto yy165;
	default:	goto yy4;
	}
yy45:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy141;
	case 'M':	goto yy157;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy146;
	default:	goto yy4;
	}
yy46:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy156;
	default:	goto yy13;
	}
yy47:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy141;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy146;
	default:	goto yy4;
	}
yy48:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy141;
	default:	goto yy4;
	}
yy49:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy58;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy55;
	default:	goto yy50;
	}
yy50:
#line 1721 "ext/date/lib/parse_date.re"
	{
		goto std;
	}
#line 3504 "<stdout>"
yy51:
	yych = *++YYCURSOR;
	goto yy50;
yy52:
	++YYCURSOR;
#line 1726 "ext/date/lib/parse_date.re"
	{
		s->pos = cursor; s->line++;
		goto std;
	}
#line 3515 "<stdout>"
yy54:
	yych = *++YYCURSOR;
	goto yy13;
yy55:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
	switch (yych) {
	case '\t':
	case ' ':	goto yy60;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy55;
	case 'D':
	case 'd':	goto yy65;
	case 'F':
	case 'f':	goto yy66;
	case 'H':
	case 'h':	goto yy64;
	case 'M':
	case 'm':	goto yy63;
	case 'S':
	case 's':	goto yy62;
	case 'T':
	case 't':	goto yy69;
	case 'W':
	case 'w':	goto yy68;
	case 'Y':
	case 'y':	goto yy67;
	default:	goto yy57;
	}
yy57:
	YYCURSOR = YYMARKER;
	switch (yyaccept) {
	case 0: 	goto yy4;
	case 1: 	goto yy13;
	case 2: 	goto yy50;
	case 3: 	goto yy73;
	case 4: 	goto yy167;
	case 5: 	goto yy194;
	case 6: 	goto yy199;
	case 7: 	goto yy223;
	case 8: 	goto yy295;
	case 9: 	goto yy393;
	case 10: 	goto yy476;
	case 11: 	goto yy491;
	case 12: 	goto yy612;
	case 13: 	goto yy657;
	case 14: 	goto yy667;
	case 15: 	goto yy764;
	case 16: 	goto yy784;
	case 17: 	goto yy815;
	case 18: 	goto yy822;
	case 19: 	goto yy849;
	case 20: 	goto yy794;
	case 21: 	goto yy455;
	case 22: 	goto yy974;
	case 23: 	goto yy843;
	case 24: 	goto yy1068;
	case 25: 	goto yy1076;
	case 26: 	goto yy1118;
	case 27: 	goto yy1142;
	case 28: 	goto yy1295;
	case 29: 	goto yy1417;
	case 30: 	goto yy1420;
	case 31: 	goto yy1500;
	case 32: 	goto yy1508;
	case 33: 	goto yy1531;
	}
yy58:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case '\t':
	case ' ':	goto yy58;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy55;
	default:	goto yy57;
	}
yy60:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy61:
	switch (yych) {
	case '\t':
	case ' ':	goto yy60;
	case 'D':
	case 'd':	goto yy65;
	case 'F':
	case 'f':	goto yy66;
	case 'H':
	case 'h':	goto yy64;
	case 'M':
	case 'm':	goto yy63;
	case 'S':
	case 's':	goto yy62;
	case 'T':
	case 't':	goto yy69;
	case 'W':
	case 'w':	goto yy68;
	case 'Y':
	case 'y':	goto yy67;
	default:	goto yy57;
	}
yy62:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy127;
	case 'E':
	case 'e':	goto yy128;
	case 'U':
	case 'u':	goto yy126;
	default:	goto yy57;
	}
yy63:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'I':
	case 'i':	goto yy118;
	case 'O':
	case 'o':	goto yy117;
	default:	goto yy57;
	}
yy64:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'O':
	case 'o':	goto yy115;
	default:	goto yy57;
	}
yy65:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy114;
	default:	goto yy57;
	}
yy66:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'O':
	case 'o':	goto yy99;
	case 'R':
	case 'r':	goto yy98;
	default:	goto yy57;
	}
yy67:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy95;
	default:	goto yy57;
	}
yy68:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy83;
	default:	goto yy57;
	}
yy69:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':
	case 'h':	goto yy70;
	case 'U':
	case 'u':	goto yy71;
	default:	goto yy57;
	}
yy70:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'U':
	case 'u':	goto yy78;
	default:	goto yy57;
	}
yy71:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy72;
	default:	goto yy57;
	}
yy72:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'S':
	case 's':	goto yy74;
	default:	goto yy73;
	}
yy73:
#line 1705 "ext/date/lib/parse_date.re"
	{
		timelib_ull i;
		DEBUG_OUTPUT("relative");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_unsigned_nr((char **) &ptr, 24);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, 1, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 3741 "<stdout>"
yy74:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'D':
	case 'd':	goto yy75;
	default:	goto yy57;
	}
yy75:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy76;
	default:	goto yy57;
	}
yy76:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy77;
	default:	goto yy57;
	}
yy77:
	yych = *++YYCURSOR;
	goto yy73;
yy78:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'R':
	case 'r':	goto yy79;
	default:	goto yy73;
	}
yy79:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'S':
	case 's':	goto yy80;
	default:	goto yy57;
	}
yy80:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'D':
	case 'd':	goto yy81;
	default:	goto yy57;
	}
yy81:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy82;
	default:	goto yy57;
	}
yy82:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy77;
	default:	goto yy57;
	}
yy83:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'D':
	case 'd':	goto yy85;
	case 'E':
	case 'e':	goto yy84;
	default:	goto yy57;
	}
yy84:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'K':
	case 'k':	goto yy91;
	default:	goto yy57;
	}
yy85:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'N':
	case 'n':	goto yy86;
	default:	goto yy73;
	}
yy86:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy87;
	default:	goto yy57;
	}
yy87:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'S':
	case 's':	goto yy88;
	default:	goto yy57;
	}
yy88:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'D':
	case 'd':	goto yy89;
	default:	goto yy57;
	}
yy89:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy90;
	default:	goto yy57;
	}
yy90:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy77;
	default:	goto yy57;
	}
yy91:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'D':
	case 'd':	goto yy92;
	case 'S':
	case 's':	goto yy77;
	default:	goto yy73;
	}
yy92:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy93;
	default:	goto yy57;
	}
yy93:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy94;
	default:	goto yy57;
	}
yy94:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'S':
	case 's':	goto yy77;
	default:	goto yy73;
	}
yy95:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy96;
	default:	goto yy57;
	}
yy96:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy97;
	default:	goto yy57;
	}
yy97:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'S':
	case 's':	goto yy77;
	default:	goto yy73;
	}
yy98:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'I':
	case 'i':	goto yy111;
	default:	goto yy57;
	}
yy99:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy100;
	default:	goto yy57;
	}
yy100:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy101;
	default:	goto yy57;
	}
yy101:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':
	case 'h':	goto yy103;
	case 'N':
	case 'n':	goto yy102;
	default:	goto yy57;
	}
yy102:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'I':
	case 'i':	goto yy108;
	default:	goto yy57;
	}
yy103:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':
	case 'n':	goto yy104;
	default:	goto yy57;
	}
yy104:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'I':
	case 'i':	goto yy105;
	default:	goto yy57;
	}
yy105:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'G':
	case 'g':	goto yy106;
	default:	goto yy57;
	}
yy106:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':
	case 'h':	goto yy107;
	default:	goto yy57;
	}
yy107:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy97;
	default:	goto yy57;
	}
yy108:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'G':
	case 'g':	goto yy109;
	default:	goto yy57;
	}
yy109:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':
	case 'h':	goto yy110;
	default:	goto yy57;
	}
yy110:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy97;
	default:	goto yy57;
	}
yy111:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'D':
	case 'd':	goto yy112;
	default:	goto yy73;
	}
yy112:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy113;
	default:	goto yy57;
	}
yy113:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy77;
	default:	goto yy57;
	}
yy114:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy97;
	default:	goto yy57;
	}
yy115:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'U':
	case 'u':	goto yy116;
	default:	goto yy57;
	}
yy116:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy97;
	default:	goto yy57;
	}
yy117:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':
	case 'n':	goto yy122;
	default:	goto yy57;
	}
yy118:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':
	case 'n':	goto yy119;
	default:	goto yy57;
	}
yy119:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'S':
	case 's':	goto yy77;
	case 'U':
	case 'u':	goto yy120;
	default:	goto yy73;
	}
yy120:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy121;
	default:	goto yy57;
	}
yy121:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy97;
	default:	goto yy57;
	}
yy122:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'D':
	case 'd':	goto yy123;
	case 'T':
	case 't':	goto yy124;
	default:	goto yy73;
	}
yy123:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy125;
	default:	goto yy57;
	}
yy124:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':
	case 'h':	goto yy97;
	default:	goto yy57;
	}
yy125:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy77;
	default:	goto yy57;
	}
yy126:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':
	case 'n':	goto yy137;
	default:	goto yy57;
	}
yy127:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy132;
	default:	goto yy57;
	}
yy128:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':
	case 'c':	goto yy129;
	default:	goto yy57;
	}
yy129:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'O':
	case 'o':	goto yy130;
	case 'S':
	case 's':	goto yy77;
	default:	goto yy73;
	}
yy130:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':
	case 'n':	goto yy131;
	default:	goto yy57;
	}
yy131:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'D':
	case 'd':	goto yy97;
	default:	goto yy57;
	}
yy132:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'U':
	case 'u':	goto yy133;
	default:	goto yy73;
	}
yy133:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy134;
	default:	goto yy57;
	}
yy134:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'D':
	case 'd':	goto yy135;
	default:	goto yy57;
	}
yy135:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy136;
	default:	goto yy57;
	}
yy136:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy77;
	default:	goto yy57;
	}
yy137:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'D':
	case 'd':	goto yy138;
	default:	goto yy73;
	}
yy138:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy139;
	default:	goto yy57;
	}
yy139:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy77;
	default:	goto yy57;
	}
yy140:
	yych = *++YYCURSOR;
	goto yy4;
yy141:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	default:	goto yy4;
	}
yy142:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	default:	goto yy4;
	}
yy143:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	default:	goto yy4;
	}
yy144:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy145;
	default:	goto yy4;
	}
yy145:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	default:	goto yy4;
	}
yy146:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy142;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy4;
	}
yy147:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	default:	goto yy4;
	}
yy148:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy149;
	default:	goto yy57;
	}
yy149:
	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy149;
	default:	goto yy4;
	}
yy151:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	default:	goto yy4;
	}
yy152:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy145;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy153;
	default:	goto yy4;
	}
yy153:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy154;
	default:	goto yy4;
	}
yy154:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy155:
	switch (yych) {
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy154;
	default:	goto yy57;
	}
yy156:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy141;
	default:	goto yy4;
	}
yy157:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'T':	goto yy158;
	default:	goto yy4;
	}
yy158:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '+':
	case '-':	goto yy159;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	default:	goto yy4;
	}
yy159:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':	goto yy160;
	case '2':	goto yy161;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy162;
	default:	goto yy57;
	}
yy160:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy162;
	case ':':	goto yy163;
	default:	goto yy4;
	}
yy161:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':	goto yy162;
	case '5':	goto yy164;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy140;
	case ':':	goto yy163;
	default:	goto yy4;
	}
yy162:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy164;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy140;
	case ':':	goto yy163;
	default:	goto yy4;
	}
yy163:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy164;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy140;
	default:	goto yy4;
	}
yy164:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy140;
	default:	goto yy4;
	}
yy165:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'D':
	case 'd':	goto yy166;
	case 'E':
	case 'e':	goto yy168;
	default:	goto yy4;
	}
yy166:
	++YYCURSOR;
	switch ((yych = *YYCURSOR)) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'N':
	case 'n':	goto yy174;
	default:	goto yy167;
	}
yy167:
#line 1568 "ext/date/lib/parse_date.re"
	{
		const timelib_relunit* relunit;
		DEBUG_OUTPUT("daytext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_WEEKDAY_RELATIVE();
		TIMELIB_UNHAVE_TIME();
		relunit = timelib_lookup_relunit((char**) &ptr);
		s->time->relative.weekday = relunit->multiplier;
		if (s->time->relative.weekday_behavior != 2) {
			s->time->relative.weekday_behavior = 1;
		}
		
		TIMELIB_DEINIT;
		return TIMELIB_WEEKDAY;
	}
#line 5309 "<stdout>"
yy168:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'K':
	case 'k':	goto yy169;
	default:	goto yy4;
	}
yy169:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	case 'D':
	case 'd':	goto yy170;
	default:	goto yy4;
	}
yy170:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'a':	goto yy171;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy145;
	default:	goto yy4;
	}
yy171:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'Y':
	case 'y':	goto yy172;
	default:	goto yy4;
	}
yy172:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'S':
	case 's':	goto yy173;
	default:	goto yy167;
	}
yy173:
	yych = *++YYCURSOR;
	goto yy167;
yy174:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	case 'E':
	case 'e':	goto yy175;
	default:	goto yy4;
	}
yy175:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy145;
	case 'S':
	case 's':	goto yy176;
	default:	goto yy4;
	}
yy176:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case 'D':
	case 'd':	goto yy177;
	default:	goto yy4;
	}
yy177:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy178;
	default:	goto yy57;
	}
yy178:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy173;
	default:	goto yy57;
	}
yy179:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy142;
	case 'D':	goto yy166;
	case 'E':	goto yy168;
	case 'a':
	case 'b':
	case 'c':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case 'd':	goto yy180;
	case 'e':	goto yy181;
	default:	goto yy4;
	}
yy180:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'N':	goto yy174;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 'n':	goto yy187;
	default:	goto yy167;
	}
yy181:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'K':	goto yy169;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 'k':	goto yy182;
	default:	goto yy4;
	}
yy182:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'D':	goto yy170;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	case 'd':	goto yy183;
	default:	goto yy4;
	}
yy183:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':	goto yy171;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy145;
	case 'a':	goto yy184;
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy153;
	default:	goto yy4;
	}
yy184:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'Y':	goto yy172;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'z':	goto yy154;
	case 'y':	goto yy185;
	default:	goto yy4;
	}
yy185:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'S':	goto yy173;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy154;
	case 's':	goto yy186;
	default:	goto yy167;
	}
yy186:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy154;
	default:	goto yy167;
	}
yy187:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'E':	goto yy175;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	case 'e':	goto yy188;
	default:	goto yy4;
	}
yy188:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy145;
	case 'S':	goto yy176;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy153;
	case 's':	goto yy189;
	default:	goto yy4;
	}
yy189:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'D':	goto yy177;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy154;
	case 'd':	goto yy190;
	default:	goto yy4;
	}
yy190:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':	goto yy178;
	case 'a':	goto yy191;
	default:	goto yy155;
	}
yy191:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':	goto yy173;
	case 'y':	goto yy186;
	default:	goto yy155;
	}
yy192:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'C':
	case 'c':	goto yy193;
	default:	goto yy4;
	}
yy193:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case '-':	goto yy197;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'E':
	case 'e':	goto yy202;
	default:	goto yy194;
	}
yy194:
#line 1627 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("monthtext");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_lookup_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 6375 "<stdout>"
yy195:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 21) YYFILL(21);
	yych = *YYCURSOR;
yy196:
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy195;
	case '0':
	case '1':
	case '2':	goto yy198;
	case '3':	goto yy200;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy201;
	default:	goto yy57;
	}
yy197:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy357;
	case '1':
	case '2':	goto yy358;
	case '3':	goto yy359;
	default:	goto yy196;
	}
yy198:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':	goto yy298;
	case '1':	goto yy299;
	case '2':	goto yy355;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy356;
	case 'n':	goto yy212;
	case 'r':	goto yy213;
	case 's':	goto yy211;
	case 't':	goto yy214;
	default:	goto yy216;
	}
yy199:
#line 1377 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("datetextual | datenoyear");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 6440 "<stdout>"
yy200:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':	goto yy298;
	case '1':	goto yy299;
	case '2':	goto yy209;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy210;
	case 'n':	goto yy212;
	case 'r':	goto yy213;
	case 's':	goto yy211;
	case 't':	goto yy214;
	default:	goto yy216;
	}
yy201:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':	goto yy207;
	case '1':	goto yy208;
	case '2':	goto yy209;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy210;
	case 'n':	goto yy212;
	case 'r':	goto yy213;
	case 's':	goto yy211;
	case 't':	goto yy214;
	default:	goto yy216;
	}
yy202:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	case 'M':
	case 'm':	goto yy203;
	default:	goto yy4;
	}
yy203:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy145;
	case 'B':
	case 'b':	goto yy204;
	default:	goto yy4;
	}
yy204:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case 'E':
	case 'e':	goto yy205;
	default:	goto yy4;
	}
yy205:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy206;
	default:	goto yy57;
	}
yy206:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	default:	goto yy194;
	}
yy207:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':
	case ':':	goto yy221;
	case '0':	goto yy296;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy297;
	default:	goto yy57;
	}
yy208:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':
	case ':':	goto yy264;
	case '0':
	case '1':
	case '2':	goto yy297;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy296;
	default:	goto yy57;
	}
yy209:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':
	case ':':	goto yy264;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':	goto yy296;
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy293;
	default:	goto yy57;
	}
yy210:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':
	case ':':	goto yy264;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy293;
	default:	goto yy57;
	}
yy211:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy216;
yy212:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy216;
yy213:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy216;
yy214:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy216;
yy215:
	yyaccept = 6;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 18) YYFILL(18);
	yych = *YYCURSOR;
yy216:
	switch (yych) {
	case '\t':
	case ' ':
	case ',':
	case '.':
	case 'd':
	case 'h':
	case 'n':
	case 'r':
	case 's':
	case 't':	goto yy215;
	case '0':	goto yy259;
	case '1':	goto yy260;
	case '2':	goto yy261;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy262;
	case 'T':	goto yy217;
	default:	goto yy199;
	}
yy217:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':	goto yy218;
	case '2':	goto yy219;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy220;
	default:	goto yy57;
	}
yy218:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':
	case ':':	goto yy221;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy220;
	default:	goto yy57;
	}
yy219:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':
	case ':':	goto yy221;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':	goto yy220;
	default:	goto yy57;
	}
yy220:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':
	case ':':	goto yy221;
	default:	goto yy57;
	}
yy221:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy222;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy224;
	default:	goto yy57;
	}
yy222:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy225;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy224;
	default:	goto yy223;
	}
yy223:
#line 1675 "ext/date/lib/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("dateshortwithtimeshort | dateshortwithtimelong | dateshortwithtimelongtz");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
#line 6861 "<stdout>"
yy224:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy225;
	default:	goto yy223;
	}
yy225:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy226;
	case '6':	goto yy227;
	case '7':
	case '8':
	case '9':	goto yy228;
	default:	goto yy57;
	}
yy226:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy229;
	default:	goto yy223;
	}
yy227:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy229;
	default:	goto yy223;
	}
yy228:
	yych = *++YYCURSOR;
	goto yy223;
yy229:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '(':
	case '+':
	case '-':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy231;
	default:	goto yy223;
	}
yy230:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy231:
	switch (yych) {
	case '\t':
	case ' ':	goto yy230;
	case '(':	goto yy234;
	case '+':
	case '-':	goto yy233;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy235;
	case 'G':	goto yy232;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy236;
	default:	goto yy57;
	}
yy232:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy228;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy237;
	case 'M':	goto yy257;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy242;
	default:	goto yy223;
	}
yy233:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':	goto yy252;
	case '2':	goto yy253;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy254;
	default:	goto yy57;
	}
yy234:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy236;
	default:	goto yy57;
	}
yy235:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy228;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy237;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy242;
	default:	goto yy223;
	}
yy236:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy228;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy237;
	default:	goto yy223;
	}
yy237:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy228;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy238;
	default:	goto yy223;
	}
yy238:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy228;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy239;
	default:	goto yy223;
	}
yy239:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy228;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy240;
	default:	goto yy223;
	}
yy240:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy228;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy241;
	default:	goto yy223;
	}
yy241:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy228;
	default:	goto yy223;
	}
yy242:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy228;
	case '-':
	case '/':
	case '_':	goto yy244;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy238;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy243;
	default:	goto yy223;
	}
yy243:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy228;
	case '-':
	case '/':
	case '_':	goto yy244;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy239;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy247;
	default:	goto yy223;
	}
yy244:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy245;
	default:	goto yy57;
	}
yy245:
	yyaccept = 7;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case '-':
	case '/':
	case '_':	goto yy244;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy245;
	default:	goto yy223;
	}
yy247:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy228;
	case '-':
	case '/':
	case '_':	goto yy244;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy240;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy248;
	default:	goto yy223;
	}
yy248:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy228;
	case '-':
	case '/':
	case '_':	goto yy244;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy241;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy249;
	default:	goto yy223;
	}
yy249:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy228;
	case '-':
	case '/':
	case '_':	goto yy244;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy250;
	default:	goto yy223;
	}
yy250:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case '-':
	case '/':
	case '_':	goto yy244;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy250;
	default:	goto yy57;
	}
yy252:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy254;
	case ':':	goto yy255;
	default:	goto yy223;
	}
yy253:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':	goto yy254;
	case '5':	goto yy256;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy228;
	case ':':	goto yy255;
	default:	goto yy223;
	}
yy254:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy256;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy228;
	case ':':	goto yy255;
	default:	goto yy223;
	}
yy255:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy256;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy228;
	default:	goto yy223;
	}
yy256:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy228;
	default:	goto yy223;
	}
yy257:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy228;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy238;
	case 'T':	goto yy258;
	default:	goto yy223;
	}
yy258:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy228;
	case '+':
	case '-':	goto yy233;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy239;
	default:	goto yy223;
	}
yy259:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy221;
	case '0':	goto yy291;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy292;
	default:	goto yy199;
	}
yy260:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy264;
	case '0':
	case '1':
	case '2':	goto yy292;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy291;
	default:	goto yy199;
	}
yy261:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy264;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':	goto yy291;
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy263;
	default:	goto yy199;
	}
yy262:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy264;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy263;
	default:	goto yy199;
	}
yy263:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy289;
	default:	goto yy199;
	}
yy264:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy265;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy266;
	default:	goto yy57;
	}
yy265:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy267;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy282;
	default:	goto yy223;
	}
yy266:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy267;
	default:	goto yy223;
	}
yy267:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy268;
	case '6':	goto yy269;
	case '7':
	case '8':
	case '9':	goto yy228;
	default:	goto yy57;
	}
yy268:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy270;
	default:	goto yy223;
	}
yy269:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy270;
	default:	goto yy223;
	}
yy270:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '(':
	case '+':
	case '-':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy272;
	default:	goto yy223;
	}
yy271:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy272:
	switch (yych) {
	case '\t':
	case ' ':	goto yy271;
	case '(':	goto yy234;
	case '+':
	case '-':	goto yy233;
	case 'A':
	case 'P':	goto yy273;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy235;
	case 'G':	goto yy232;
	case 'a':
	case 'p':	goto yy274;
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy236;
	default:	goto yy57;
	}
yy273:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy228;
	case '.':	goto yy275;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy237;
	case 'M':	goto yy276;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy242;
	case 'm':	goto yy281;
	default:	goto yy223;
	}
yy274:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy228;
	case '.':	goto yy275;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy237;
	case 'M':
	case 'm':	goto yy276;
	default:	goto yy223;
	}
yy275:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'M':
	case 'm':	goto yy280;
	default:	goto yy57;
	}
yy276:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 0x00:
	case '\t':
	case ' ':	goto yy278;
	case ')':	goto yy228;
	case '.':	goto yy277;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy238;
	default:	goto yy223;
	}
yy277:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\t':
	case ' ':	goto yy278;
	default:	goto yy57;
	}
yy278:
	++YYCURSOR;
#line 1651 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("dateshortwithtimeshort12 | dateshortwithtimelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
#line 8675 "<stdout>"
yy280:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\t':
	case ' ':	goto yy278;
	case '.':	goto yy277;
	default:	goto yy57;
	}
yy281:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 0x00:
	case '\t':
	case ' ':	goto yy278;
	case ')':	goto yy228;
	case '-':
	case '/':
	case '_':	goto yy244;
	case '.':	goto yy277;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy238;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy243;
	default:	goto yy223;
	}
yy282:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy283;
	case '.':
	case ':':	goto yy267;
	case 'A':
	case 'P':
	case 'a':
	case 'p':	goto yy285;
	default:	goto yy223;
	}
yy283:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	switch (yych) {
	case '\t':
	case ' ':	goto yy283;
	case 'A':
	case 'P':
	case 'a':
	case 'p':	goto yy285;
	default:	goto yy57;
	}
yy285:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':	goto yy286;
	case 'M':
	case 'm':	goto yy287;
	default:	goto yy57;
	}
yy286:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'M':
	case 'm':	goto yy287;
	default:	goto yy57;
	}
yy287:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\t':
	case ' ':	goto yy278;
	case '.':	goto yy288;
	default:	goto yy57;
	}
yy288:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\t':
	case ' ':	goto yy278;
	default:	goto yy57;
	}
yy289:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy290;
	default:	goto yy199;
	}
yy290:
	yych = *++YYCURSOR;
	goto yy199;
yy291:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy221;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy289;
	default:	goto yy199;
	}
yy292:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy264;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy289;
	default:	goto yy199;
	}
yy293:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy294;
	default:	goto yy57;
	}
yy294:
	++YYCURSOR;
yy295:
#line 1351 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("datenoday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 8894 "<stdout>"
yy296:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':
	case ':':	goto yy221;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy294;
	default:	goto yy57;
	}
yy297:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':
	case ':':	goto yy264;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy294;
	default:	goto yy57;
	}
yy298:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy331;
	case '0':	goto yy332;
	case '1':	goto yy302;
	case '2':	goto yy303;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy297;
	case ':':	goto yy221;
	case 'n':	goto yy212;
	case 'r':	goto yy213;
	case 's':	goto yy211;
	case 't':	goto yy214;
	default:	goto yy216;
	}
yy299:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy300;
	case '0':	goto yy301;
	case '1':	goto yy302;
	case '2':	goto yy303;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy297;
	case ':':	goto yy264;
	case 'n':	goto yy212;
	case 'r':	goto yy213;
	case 's':	goto yy211;
	case 't':	goto yy214;
	default:	goto yy216;
	}
yy300:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':	goto yy306;
	case '1':	goto yy307;
	case '2':	goto yy308;
	case '3':
	case '4':
	case '5':	goto yy309;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy310;
	default:	goto yy216;
	}
yy301:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':
	case ':':	goto yy264;
	case '0':	goto yy304;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy305;
	default:	goto yy57;
	}
yy302:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':
	case ':':	goto yy264;
	case '0':
	case '1':
	case '2':	goto yy305;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy304;
	default:	goto yy57;
	}
yy303:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':
	case ':':	goto yy264;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':	goto yy304;
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy294;
	default:	goto yy57;
	}
yy304:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy221;
	default:	goto yy295;
	}
yy305:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy264;
	default:	goto yy295;
	}
yy306:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy326;
	case '0':	goto yy325;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy330;
	default:	goto yy199;
	}
yy307:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy311;
	case '0':
	case '1':
	case '2':	goto yy330;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy325;
	default:	goto yy199;
	}
yy308:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy311;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':	goto yy325;
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy324;
	default:	goto yy199;
	}
yy309:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy311;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy324;
	default:	goto yy199;
	}
yy310:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy311;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy263;
	default:	goto yy199;
	}
yy311:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy312;
	case '6':	goto yy313;
	case '7':
	case '8':
	case '9':	goto yy266;
	default:	goto yy57;
	}
yy312:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy267;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy314;
	default:	goto yy223;
	}
yy313:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy267;
	case '0':	goto yy270;
	default:	goto yy223;
	}
yy314:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '(':
	case '+':
	case '-':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy316;
	case '.':
	case ':':	goto yy267;
	default:	goto yy223;
	}
yy315:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy316:
	switch (yych) {
	case '\t':
	case ' ':	goto yy315;
	case '(':	goto yy234;
	case '+':
	case '-':	goto yy233;
	case 'A':
	case 'P':	goto yy317;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy235;
	case 'G':	goto yy232;
	case 'a':
	case 'p':	goto yy318;
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy236;
	default:	goto yy57;
	}
yy317:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy228;
	case '.':	goto yy320;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy237;
	case 'M':	goto yy319;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy242;
	case 'm':	goto yy323;
	default:	goto yy223;
	}
yy318:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy228;
	case '.':	goto yy320;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy237;
	case 'M':
	case 'm':	goto yy319;
	default:	goto yy223;
	}
yy319:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 0x00:
	case '\t':
	case ' ':	goto yy278;
	case ')':	goto yy228;
	case '.':	goto yy322;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy238;
	default:	goto yy223;
	}
yy320:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'M':
	case 'm':	goto yy321;
	default:	goto yy57;
	}
yy321:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\t':
	case ' ':	goto yy278;
	case '.':	goto yy322;
	default:	goto yy57;
	}
yy322:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\t':
	case ' ':	goto yy278;
	default:	goto yy57;
	}
yy323:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 0x00:
	case '\t':
	case ' ':	goto yy278;
	case ')':	goto yy228;
	case '-':
	case '/':
	case '_':	goto yy244;
	case '.':	goto yy322;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy238;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy243;
	default:	goto yy223;
	}
yy324:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy283;
	case '.':
	case ':':	goto yy267;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy289;
	case 'A':
	case 'P':
	case 'a':
	case 'p':	goto yy285;
	default:	goto yy199;
	}
yy325:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy283;
	case '.':
	case ':':	goto yy326;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy289;
	case 'A':
	case 'P':
	case 'a':
	case 'p':	goto yy285;
	default:	goto yy199;
	}
yy326:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy327;
	case '6':	goto yy328;
	case '7':
	case '8':
	case '9':	goto yy224;
	default:	goto yy57;
	}
yy327:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy225;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy329;
	default:	goto yy223;
	}
yy328:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy225;
	case '0':	goto yy270;
	default:	goto yy223;
	}
yy329:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '(':
	case '+':
	case '-':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy272;
	case '.':
	case ':':	goto yy225;
	default:	goto yy223;
	}
yy330:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy283;
	case '.':
	case ':':	goto yy311;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy289;
	case 'A':
	case 'P':
	case 'a':
	case 'p':	goto yy285;
	default:	goto yy199;
	}
yy331:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':	goto yy333;
	case '1':	goto yy334;
	case '2':	goto yy335;
	case '3':
	case '4':
	case '5':	goto yy336;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy337;
	default:	goto yy216;
	}
yy332:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':
	case ':':	goto yy221;
	case '0':	goto yy304;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy305;
	default:	goto yy57;
	}
yy333:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy350;
	case '0':	goto yy349;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy354;
	default:	goto yy199;
	}
yy334:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy338;
	case '0':
	case '1':
	case '2':	goto yy354;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy349;
	default:	goto yy199;
	}
yy335:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy338;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':	goto yy349;
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy348;
	default:	goto yy199;
	}
yy336:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy338;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy348;
	default:	goto yy199;
	}
yy337:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy338;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy263;
	default:	goto yy199;
	}
yy338:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy339;
	case '6':	goto yy340;
	case '7':
	case '8':
	case '9':	goto yy266;
	default:	goto yy57;
	}
yy339:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy267;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy341;
	default:	goto yy223;
	}
yy340:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy267;
	case '0':	goto yy229;
	default:	goto yy223;
	}
yy341:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '(':
	case '+':
	case '-':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy343;
	case '.':
	case ':':	goto yy267;
	default:	goto yy223;
	}
yy342:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy343:
	switch (yych) {
	case '\t':
	case ' ':	goto yy342;
	case '(':	goto yy234;
	case '+':
	case '-':	goto yy233;
	case 'A':
	case 'P':	goto yy344;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy235;
	case 'G':	goto yy232;
	case 'a':
	case 'p':	goto yy345;
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy236;
	default:	goto yy57;
	}
yy344:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy228;
	case '.':	goto yy286;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy237;
	case 'M':	goto yy346;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy242;
	case 'm':	goto yy347;
	default:	goto yy223;
	}
yy345:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy228;
	case '.':	goto yy286;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy237;
	case 'M':
	case 'm':	goto yy346;
	default:	goto yy223;
	}
yy346:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 0x00:
	case '\t':
	case ' ':	goto yy278;
	case ')':	goto yy228;
	case '.':	goto yy288;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy238;
	default:	goto yy223;
	}
yy347:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 0x00:
	case '\t':
	case ' ':	goto yy278;
	case ')':	goto yy228;
	case '-':
	case '/':
	case '_':	goto yy244;
	case '.':	goto yy288;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy238;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy243;
	default:	goto yy223;
	}
yy348:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy225;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy289;
	default:	goto yy199;
	}
yy349:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy350;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy289;
	default:	goto yy199;
	}
yy350:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy351;
	case '6':	goto yy352;
	case '7':
	case '8':
	case '9':	goto yy224;
	default:	goto yy57;
	}
yy351:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy225;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy353;
	default:	goto yy223;
	}
yy352:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy225;
	case '0':	goto yy229;
	default:	goto yy223;
	}
yy353:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '(':
	case '+':
	case '-':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy231;
	case '.':
	case ':':	goto yy225;
	default:	goto yy223;
	}
yy354:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy338;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy289;
	default:	goto yy199;
	}
yy355:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy300;
	case '0':	goto yy332;
	case '1':	goto yy302;
	case '2':	goto yy303;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy297;
	case ':':	goto yy264;
	case 'n':	goto yy212;
	case 'r':	goto yy213;
	case 's':	goto yy211;
	case 't':	goto yy214;
	default:	goto yy216;
	}
yy356:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy300;
	case '0':	goto yy332;
	case '1':	goto yy302;
	case '2':	goto yy303;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy297;
	case ':':	goto yy264;
	case 'n':	goto yy212;
	case 'r':	goto yy213;
	case 's':	goto yy211;
	case 't':	goto yy214;
	default:	goto yy216;
	}
yy357:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':	goto yy360;
	case '1':	goto yy361;
	case '2':	goto yy368;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy369;
	case 'n':	goto yy212;
	case 'r':	goto yy213;
	case 's':	goto yy211;
	case 't':	goto yy214;
	default:	goto yy216;
	}
yy358:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':	goto yy360;
	case '1':	goto yy361;
	case '2':	goto yy368;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy369;
	case 'n':	goto yy212;
	case 'r':	goto yy213;
	case 's':	goto yy211;
	case 't':	goto yy214;
	default:	goto yy216;
	}
yy359:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':	goto yy360;
	case '1':	goto yy361;
	case '2':	goto yy209;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy210;
	case 'n':	goto yy212;
	case 'r':	goto yy213;
	case 's':	goto yy211;
	case 't':	goto yy214;
	default:	goto yy216;
	}
yy360:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy362;
	case '.':	goto yy331;
	case '0':	goto yy332;
	case '1':	goto yy302;
	case '2':	goto yy303;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy297;
	case ':':	goto yy221;
	case 'n':	goto yy212;
	case 'r':	goto yy213;
	case 's':	goto yy211;
	case 't':	goto yy214;
	default:	goto yy216;
	}
yy361:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy362;
	case '.':	goto yy300;
	case '0':	goto yy301;
	case '1':	goto yy302;
	case '2':	goto yy303;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy297;
	case ':':	goto yy264;
	case 'n':	goto yy212;
	case 'r':	goto yy213;
	case 's':	goto yy211;
	case 't':	goto yy214;
	default:	goto yy216;
	}
yy362:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy363;
	default:	goto yy57;
	}
yy363:
	++YYCURSOR;
	switch ((yych = *YYCURSOR)) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy365;
	default:	goto yy364;
	}
yy364:
#line 1491 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("pgtextshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 10668 "<stdout>"
yy365:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy366;
	default:	goto yy364;
	}
yy366:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy367;
	default:	goto yy364;
	}
yy367:
	yych = *++YYCURSOR;
	goto yy364;
yy368:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy362;
	case '.':	goto yy300;
	case '0':	goto yy332;
	case '1':	goto yy302;
	case '2':	goto yy303;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy297;
	case ':':	goto yy264;
	case 'n':	goto yy212;
	case 'r':	goto yy213;
	case 's':	goto yy211;
	case 't':	goto yy214;
	default:	goto yy216;
	}
yy369:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy362;
	case '.':	goto yy300;
	case '0':	goto yy332;
	case '1':	goto yy302;
	case '2':	goto yy303;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy297;
	case ':':	goto yy264;
	case 'n':	goto yy212;
	case 'r':	goto yy213;
	case 's':	goto yy211;
	case 't':	goto yy214;
	default:	goto yy216;
	}
yy370:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy142;
	case 'C':	goto yy193;
	case 'a':
	case 'b':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case 'c':	goto yy371;
	default:	goto yy4;
	}
yy371:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case '-':	goto yy372;
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'E':	goto yy202;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 'e':	goto yy373;
	default:	goto yy194;
	}
yy372:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy357;
	case '1':
	case '2':	goto yy358;
	case '3':	goto yy359;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy149;
	default:	goto yy196;
	}
yy373:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'M':	goto yy203;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	case 'm':	goto yy374;
	default:	goto yy4;
	}
yy374:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy145;
	case 'B':	goto yy204;
	case 'a':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy153;
	case 'b':	goto yy375;
	default:	goto yy4;
	}
yy375:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'E':	goto yy205;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy154;
	case 'e':	goto yy376;
	default:	goto yy4;
	}
yy376:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':	goto yy206;
	case 'r':	goto yy377;
	default:	goto yy155;
	}
yy377:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case '-':	goto yy378;
	case '/':
	case '_':	goto yy148;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy154;
	default:	goto yy194;
	}
yy378:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy149;
	default:	goto yy196;
	}
yy379:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'T':
	case 't':	goto yy380;
	default:	goto yy4;
	}
yy380:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case '-':	goto yy197;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'O':
	case 'o':	goto yy381;
	default:	goto yy194;
	}
yy381:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	case 'B':
	case 'b':	goto yy382;
	default:	goto yy4;
	}
yy382:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy145;
	case 'E':
	case 'e':	goto yy383;
	default:	goto yy4;
	}
yy383:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'R':
	case 'r':	goto yy206;
	default:	goto yy4;
	}
yy384:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy142;
	case 'T':	goto yy380;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case 't':	goto yy385;
	default:	goto yy4;
	}
yy385:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case '-':	goto yy372;
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'O':	goto yy381;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 'o':	goto yy386;
	default:	goto yy194;
	}
yy386:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'B':	goto yy382;
	case 'a':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	case 'b':	goto yy387;
	default:	goto yy4;
	}
yy387:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy145;
	case 'E':	goto yy383;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy153;
	case 'e':	goto yy388;
	default:	goto yy4;
	}
yy388:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'R':	goto yy206;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy154;
	case 'r':	goto yy377;
	default:	goto yy4;
	}
yy389:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'G':
	case 'g':	goto yy397;
	default:	goto yy4;
	}
yy390:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'R':
	case 'r':	goto yy394;
	default:	goto yy4;
	}
yy391:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'O':
	case 'o':	goto yy392;
	default:	goto yy4;
	}
yy392:
	++YYCURSOR;
	switch ((yych = *YYCURSOR)) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	default:	goto yy393;
	}
yy393:
#line 1547 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("ago");
		TIMELIB_INIT;
		s->time->relative.y = 0 - s->time->relative.y;
		s->time->relative.m = 0 - s->time->relative.m;
		s->time->relative.d = 0 - s->time->relative.d;
		s->time->relative.h = 0 - s->time->relative.h;
		s->time->relative.i = 0 - s->time->relative.i;
		s->time->relative.s = 0 - s->time->relative.s;
		s->time->relative.weekday = 0 - s->time->relative.weekday;
		if (s->time->relative.weekday == 0) {
			s->time->relative.weekday = -7;
		}
		if (s->time->relative.have_special_relative && s->time->relative.special.type == TIMELIB_SPECIAL_WEEKDAY) {
			s->time->relative.special.amount = 0 - s->time->relative.special.amount;
		}
		TIMELIB_DEINIT;
		return TIMELIB_AGO;
	}
#line 12025 "<stdout>"
yy394:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case '-':	goto yy197;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'I':
	case 'i':	goto yy395;
	default:	goto yy194;
	}
yy395:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	case 'L':
	case 'l':	goto yy396;
	default:	goto yy4;
	}
yy396:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy145;
	default:	goto yy194;
	}
yy397:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case '-':	goto yy197;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'U':
	case 'u':	goto yy398;
	default:	goto yy194;
	}
yy398:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	case 'S':
	case 's':	goto yy399;
	default:	goto yy4;
	}
yy399:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy145;
	case 'T':
	case 't':	goto yy400;
	default:	goto yy4;
	}
yy400:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	default:	goto yy194;
	}
yy401:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy142;
	case 'G':	goto yy397;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case 'g':	goto yy408;
	default:	goto yy4;
	}
yy402:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy142;
	case 'R':	goto yy394;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case 'r':	goto yy405;
	default:	goto yy4;
	}
yy403:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy142;
	case 'O':	goto yy392;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case 'o':	goto yy404;
	default:	goto yy4;
	}
yy404:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	default:	goto yy393;
	}
yy405:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case '-':	goto yy372;
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'I':	goto yy395;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 'i':	goto yy406;
	default:	goto yy194;
	}
yy406:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'L':	goto yy396;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	case 'l':	goto yy407;
	default:	goto yy4;
	}
yy407:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case '-':	goto yy378;
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy145;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy153;
	default:	goto yy194;
	}
yy408:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case '-':	goto yy372;
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'U':	goto yy398;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 'u':	goto yy409;
	default:	goto yy194;
	}
yy409:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'S':	goto yy399;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	case 's':	goto yy410;
	default:	goto yy4;
	}
yy410:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy145;
	case 'T':	goto yy400;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy153;
	case 't':	goto yy411;
	default:	goto yy4;
	}
yy411:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case '-':	goto yy378;
	case '/':
	case '_':	goto yy148;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy154;
	default:	goto yy194;
	}
yy412:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'L':
	case 'l':	goto yy419;
	case 'N':
	case 'n':	goto yy418;
	default:	goto yy4;
	}
yy413:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'N':
	case 'n':	goto yy414;
	default:	goto yy4;
	}
yy414:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case '-':	goto yy197;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'U':
	case 'u':	goto yy415;
	default:	goto yy194;
	}
yy415:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'a':	goto yy416;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	default:	goto yy4;
	}
yy416:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy145;
	case 'R':
	case 'r':	goto yy417;
	default:	goto yy4;
	}
yy417:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'Y':
	case 'y':	goto yy206;
	default:	goto yy4;
	}
yy418:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case '-':	goto yy197;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'E':
	case 'e':	goto yy420;
	default:	goto yy194;
	}
yy419:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case '-':	goto yy197;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'z':	goto yy143;
	case 'Y':
	case 'y':	goto yy420;
	default:	goto yy194;
	}
yy420:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	default:	goto yy194;
	}
yy421:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy142;
	case 'L':	goto yy419;
	case 'N':	goto yy418;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case 'l':	goto yy428;
	case 'n':	goto yy427;
	default:	goto yy4;
	}
yy422:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy142;
	case 'N':	goto yy414;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case 'n':	goto yy423;
	default:	goto yy4;
	}
yy423:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case '-':	goto yy372;
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'U':	goto yy415;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 'u':	goto yy424;
	default:	goto yy194;
	}
yy424:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':	goto yy416;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'a':	goto yy425;
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	default:	goto yy4;
	}
yy425:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy145;
	case 'R':	goto yy417;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy153;
	case 'r':	goto yy426;
	default:	goto yy4;
	}
yy426:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'Y':	goto yy206;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'z':	goto yy154;
	case 'y':	goto yy377;
	default:	goto yy4;
	}
yy427:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case '-':	goto yy372;
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'E':	goto yy420;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 'e':	goto yy429;
	default:	goto yy194;
	}
yy428:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case '-':	goto yy372;
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Z':	goto yy143;
	case 'Y':	goto yy420;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'z':	goto yy151;
	case 'y':	goto yy429;
	default:	goto yy194;
	}
yy429:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case '-':	goto yy378;
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	default:	goto yy194;
	}
yy430:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'I':	goto yy431;
	default:	goto yy4;
	}
yy431:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	default:	goto yy4;
	}
yy432:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'I':	goto yy433;
	default:	goto yy4;
	}
yy433:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'I':	goto yy434;
	default:	goto yy4;
	}
yy434:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	default:	goto yy4;
	}
yy435:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	default:	goto yy4;
	}
yy436:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'I':	goto yy431;
	default:	goto yy4;
	}
yy437:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy61;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy457;
	case ':':	goto yy163;
	default:	goto yy4;
	}
yy438:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy61;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':	goto yy457;
	case '5':	goto yy442;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy443;
	case ':':	goto yy163;
	default:	goto yy4;
	}
yy439:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy61;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy442;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy443;
	case ':':	goto yy163;
	default:	goto yy4;
	}
yy440:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case '\t':
	case ' ':	goto yy58;
	case '+':
	case '-':	goto yy440;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy55;
	default:	goto yy57;
	}
yy442:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy61;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy456;
	default:	goto yy4;
	}
yy443:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy61;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy444;
	default:	goto yy4;
	}
yy444:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy445;
	default:	goto yy61;
	}
yy445:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy446;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy55;
	default:	goto yy61;
	}
yy446:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy447;
	case '1':	goto yy448;
	default:	goto yy57;
	}
yy447:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy449;
	default:	goto yy57;
	}
yy448:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy449;
	default:	goto yy57;
	}
yy449:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy450;
	default:	goto yy57;
	}
yy450:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy451;
	case '1':
	case '2':	goto yy452;
	case '3':	goto yy453;
	default:	goto yy57;
	}
yy451:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy454;
	default:	goto yy57;
	}
yy452:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy454;
	default:	goto yy57;
	}
yy453:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':	goto yy454;
	default:	goto yy57;
	}
yy454:
	++YYCURSOR;
yy455:
#line 1261 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("iso8601date4 | iso8601date2 | iso8601dateslash | dateslash");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_unsigned_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 15097 "<stdout>"
yy456:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy61;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy445;
	default:	goto yy4;
	}
yy457:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy61;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy458;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy456;
	case ':':	goto yy163;
	default:	goto yy4;
	}
yy458:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy61;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy459;
	default:	goto yy4;
	}
yy459:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy61;
	case '-':	goto yy446;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy55;
	default:	goto yy4;
	}
yy460:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy736;
	case '1':	goto yy737;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy738;
	default:	goto yy462;
	}
yy461:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy462:
	switch (yych) {
	case '\t':
	case ' ':	goto yy461;
	case '-':
	case '.':	goto yy577;
	case 'A':
	case 'a':	goto yy480;
	case 'D':
	case 'd':	goto yy466;
	case 'F':
	case 'f':	goto yy467;
	case 'H':
	case 'h':	goto yy64;
	case 'I':	goto yy475;
	case 'J':
	case 'j':	goto yy479;
	case 'M':
	case 'm':	goto yy465;
	case 'N':
	case 'n':	goto yy482;
	case 'O':
	case 'o':	goto yy481;
	case 'P':
	case 'p':	goto yy484;
	case 'S':
	case 's':	goto yy463;
	case 'T':
	case 't':	goto yy69;
	case 'V':	goto yy477;
	case 'W':
	case 'w':	goto yy68;
	case 'X':	goto yy478;
	case 'Y':
	case 'y':	goto yy67;
	default:	goto yy57;
	}
yy463:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy127;
	case 'E':
	case 'e':	goto yy1049;
	case 'U':
	case 'u':	goto yy126;
	default:	goto yy57;
	}
yy464:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy127;
	case 'E':
	case 'e':	goto yy1049;
	case 'U':
	case 'u':	goto yy126;
	case 't':	goto yy729;
	default:	goto yy57;
	}
yy465:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy592;
	case 'I':
	case 'i':	goto yy118;
	case 'O':
	case 'o':	goto yy117;
	default:	goto yy57;
	}
yy466:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy114;
	case 'E':
	case 'e':	goto yy579;
	default:	goto yy57;
	}
yy467:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy595;
	case 'O':
	case 'o':	goto yy99;
	case 'R':
	case 'r':	goto yy98;
	default:	goto yy57;
	}
yy468:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':	goto yy70;
	case 'U':
	case 'u':	goto yy71;
	case 'h':	goto yy1048;
	default:	goto yy57;
	}
yy469:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy742;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy741;
	default:	goto yy61;
	}
yy470:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'O':
	case 'o':	goto yy530;
	case 'd':	goto yy729;
	default:	goto yy57;
	}
yy471:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'd':	goto yy729;
	default:	goto yy57;
	}
yy472:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy666;
	case '3':	goto yy668;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy669;
	case 'A':
	case 'a':	goto yy673;
	case 'D':
	case 'd':	goto yy677;
	case 'F':
	case 'f':	goto yy671;
	case 'J':
	case 'j':	goto yy670;
	case 'M':
	case 'm':	goto yy672;
	case 'N':
	case 'n':	goto yy676;
	case 'O':
	case 'o':	goto yy675;
	case 'S':
	case 's':	goto yy674;
	default:	goto yy57;
	}
yy473:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy616;
	case '1':	goto yy617;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy618;
	case 'A':
	case 'a':	goto yy622;
	case 'D':
	case 'd':	goto yy626;
	case 'F':
	case 'f':	goto yy620;
	case 'J':
	case 'j':	goto yy619;
	case 'M':
	case 'm':	goto yy621;
	case 'N':
	case 'n':	goto yy625;
	case 'O':
	case 'o':	goto yy624;
	case 'S':
	case 's':	goto yy623;
	default:	goto yy578;
	}
yy474:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy568;
	case '1':	goto yy569;
	case '2':
	case '3':
	case '4':
	case '5':	goto yy570;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy571;
	default:	goto yy578;
	}
yy475:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy532;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	case 'I':	goto yy567;
	case 'V':
	case 'X':	goto yy540;
	default:	goto yy476;
	}
yy476:
#line 1390 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("datenoyearrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 15497 "<stdout>"
yy477:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy532;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	case 'I':	goto yy565;
	default:	goto yy476;
	}
yy478:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy532;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	case 'I':	goto yy564;
	default:	goto yy476;
	}
yy479:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy557;
	case 'U':
	case 'u':	goto yy556;
	default:	goto yy57;
	}
yy480:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':	goto yy485;
	case 'M':
	case 'm':	goto yy486;
	case 'P':
	case 'p':	goto yy550;
	case 'U':
	case 'u':	goto yy549;
	default:	goto yy57;
	}
yy481:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':
	case 'c':	goto yy544;
	default:	goto yy57;
	}
yy482:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'O':
	case 'o':	goto yy530;
	default:	goto yy57;
	}
yy483:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy490;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy492;
	default:	goto yy57;
	}
yy484:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':	goto yy485;
	case 'M':
	case 'm':	goto yy486;
	default:	goto yy57;
	}
yy485:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'M':
	case 'm':	goto yy486;
	default:	goto yy57;
	}
yy486:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\t':
	case ' ':	goto yy488;
	case '.':	goto yy487;
	default:	goto yy57;
	}
yy487:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\t':
	case ' ':	goto yy488;
	default:	goto yy57;
	}
yy488:
	++YYCURSOR;
#line 1117 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("timetiny12 | timeshort12 | timelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr((char **) &ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr((char **) &ptr, 2);
			}
		}
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME12;
	}
#line 15640 "<stdout>"
yy490:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy493;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy507;
	default:	goto yy491;
	}
yy491:
#line 1154 "ext/date/lib/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("timeshort24 | timelong24 | iso8601long");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
#line 15685 "<stdout>"
yy492:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy493;
	default:	goto yy491;
	}
yy493:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy494;
	case '6':	goto yy495;
	case '7':
	case '8':
	case '9':	goto yy496;
	default:	goto yy57;
	}
yy494:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy497;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy500;
	default:	goto yy491;
	}
yy495:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy497;
	case '0':	goto yy500;
	default:	goto yy491;
	}
yy496:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy497;
	default:	goto yy491;
	}
yy497:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy498;
	default:	goto yy57;
	}
yy498:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy498;
	default:	goto yy491;
	}
yy500:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy501;
	case '.':	goto yy497;
	case 'A':
	case 'P':
	case 'a':
	case 'p':	goto yy503;
	default:	goto yy491;
	}
yy501:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	switch (yych) {
	case '\t':
	case ' ':	goto yy501;
	case 'A':
	case 'P':
	case 'a':
	case 'p':	goto yy503;
	default:	goto yy57;
	}
yy503:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':	goto yy504;
	case 'M':
	case 'm':	goto yy505;
	default:	goto yy57;
	}
yy504:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'M':
	case 'm':	goto yy505;
	default:	goto yy57;
	}
yy505:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\t':
	case ' ':	goto yy488;
	case '.':	goto yy506;
	default:	goto yy57;
	}
yy506:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\t':
	case ' ':	goto yy488;
	default:	goto yy57;
	}
yy507:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy508;
	case '.':	goto yy493;
	case ':':	goto yy511;
	case 'A':
	case 'P':
	case 'a':
	case 'p':	goto yy510;
	default:	goto yy491;
	}
yy508:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	switch (yych) {
	case '\t':
	case ' ':	goto yy508;
	case 'A':
	case 'P':
	case 'a':
	case 'p':	goto yy510;
	default:	goto yy57;
	}
yy510:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':	goto yy527;
	case 'M':
	case 'm':	goto yy528;
	default:	goto yy57;
	}
yy511:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy512;
	case '6':	goto yy513;
	case '7':
	case '8':
	case '9':	goto yy496;
	default:	goto yy57;
	}
yy512:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy497;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy514;
	default:	goto yy491;
	}
yy513:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy497;
	case '0':	goto yy514;
	default:	goto yy491;
	}
yy514:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy501;
	case '.':	goto yy515;
	case ':':	goto yy516;
	case 'A':
	case 'P':
	case 'a':
	case 'p':	goto yy503;
	default:	goto yy491;
	}
yy515:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy525;
	default:	goto yy57;
	}
yy516:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy517;
	default:	goto yy57;
	}
yy517:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy517;
	case 'A':
	case 'P':
	case 'a':
	case 'p':	goto yy519;
	default:	goto yy57;
	}
yy519:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':	goto yy520;
	case 'M':
	case 'm':	goto yy521;
	default:	goto yy57;
	}
yy520:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'M':
	case 'm':	goto yy521;
	default:	goto yy57;
	}
yy521:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\t':
	case ' ':	goto yy523;
	case '.':	goto yy522;
	default:	goto yy57;
	}
yy522:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\t':
	case ' ':	goto yy523;
	default:	goto yy57;
	}
yy523:
	++YYCURSOR;
#line 1134 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("mssqltime");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == ':' || *ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}
		timelib_eat_spaces((char **) &ptr);
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
#line 16024 "<stdout>"
yy525:
	yyaccept = 11;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy525;
	case 'A':
	case 'P':
	case 'a':
	case 'p':	goto yy519;
	default:	goto yy491;
	}
yy527:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'M':
	case 'm':	goto yy528;
	default:	goto yy57;
	}
yy528:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\t':
	case ' ':	goto yy488;
	case '.':	goto yy529;
	default:	goto yy57;
	}
yy529:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\t':
	case ' ':	goto yy488;
	default:	goto yy57;
	}
yy530:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'V':
	case 'v':	goto yy531;
	default:	goto yy57;
	}
yy531:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy532;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	case 'E':
	case 'e':	goto yy536;
	default:	goto yy476;
	}
yy532:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
yy533:
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy532;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	default:	goto yy57;
	}
yy534:
	++YYCURSOR;
	switch ((yych = *YYCURSOR)) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy541;
	default:	goto yy535;
	}
yy535:
#line 1312 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("datefull");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL;
	}
#line 16151 "<stdout>"
yy536:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'M':
	case 'm':	goto yy537;
	default:	goto yy57;
	}
yy537:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'B':
	case 'b':	goto yy538;
	default:	goto yy57;
	}
yy538:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy539;
	default:	goto yy57;
	}
yy539:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy540;
	default:	goto yy57;
	}
yy540:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy532;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	default:	goto yy476;
	}
yy541:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy542;
	default:	goto yy535;
	}
yy542:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy543;
	default:	goto yy535;
	}
yy543:
	yych = *++YYCURSOR;
	goto yy535;
yy544:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy545;
	default:	goto yy57;
	}
yy545:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy532;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	case 'O':
	case 'o':	goto yy546;
	default:	goto yy476;
	}
yy546:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'B':
	case 'b':	goto yy547;
	default:	goto yy57;
	}
yy547:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy548;
	default:	goto yy57;
	}
yy548:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy540;
	default:	goto yy57;
	}
yy549:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'G':
	case 'g':	goto yy553;
	default:	goto yy57;
	}
yy550:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy551;
	default:	goto yy57;
	}
yy551:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy532;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	case 'I':
	case 'i':	goto yy552;
	default:	goto yy476;
	}
yy552:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'L':
	case 'l':	goto yy540;
	default:	goto yy57;
	}
yy553:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy532;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	case 'U':
	case 'u':	goto yy554;
	default:	goto yy476;
	}
yy554:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'S':
	case 's':	goto yy555;
	default:	goto yy57;
	}
yy555:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy540;
	default:	goto yy57;
	}
yy556:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'L':
	case 'l':	goto yy563;
	case 'N':
	case 'n':	goto yy562;
	default:	goto yy57;
	}
yy557:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':
	case 'n':	goto yy558;
	default:	goto yy57;
	}
yy558:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy532;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	case 'U':
	case 'u':	goto yy559;
	default:	goto yy476;
	}
yy559:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy560;
	default:	goto yy57;
	}
yy560:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy561;
	default:	goto yy57;
	}
yy561:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy540;
	default:	goto yy57;
	}
yy562:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy532;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	case 'E':
	case 'e':	goto yy540;
	default:	goto yy476;
	}
yy563:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy532;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	case 'Y':
	case 'y':	goto yy540;
	default:	goto yy476;
	}
yy564:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy532;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	case 'I':	goto yy540;
	default:	goto yy476;
	}
yy565:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy532;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	case 'I':	goto yy566;
	default:	goto yy476;
	}
yy566:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy532;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	case 'I':	goto yy540;
	default:	goto yy476;
	}
yy567:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy532;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	case 'I':	goto yy540;
	default:	goto yy476;
	}
yy568:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy602;
	case '.':	goto yy601;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy615;
	case ':':	goto yy493;
	default:	goto yy491;
	}
yy569:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy602;
	case '.':	goto yy601;
	case '0':
	case '1':
	case '2':	goto yy615;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy614;
	case ':':	goto yy493;
	default:	goto yy491;
	}
yy570:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy602;
	case '.':	goto yy601;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy614;
	case ':':	goto yy493;
	default:	goto yy491;
	}
yy571:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy602;
	case '.':	goto yy601;
	case ':':	goto yy493;
	default:	goto yy491;
	}
yy572:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy595;
	default:	goto yy57;
	}
yy573:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy592;
	default:	goto yy57;
	}
yy574:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'P':
	case 'p':	goto yy550;
	case 'U':
	case 'u':	goto yy549;
	default:	goto yy57;
	}
yy575:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy585;
	default:	goto yy57;
	}
yy576:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy579;
	default:	goto yy57;
	}
yy577:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy578:
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy577;
	case 'A':
	case 'a':	goto yy574;
	case 'D':
	case 'd':	goto yy576;
	case 'F':
	case 'f':	goto yy572;
	case 'I':	goto yy475;
	case 'J':
	case 'j':	goto yy479;
	case 'M':
	case 'm':	goto yy573;
	case 'N':
	case 'n':	goto yy482;
	case 'O':
	case 'o':	goto yy481;
	case 'S':
	case 's':	goto yy575;
	case 'V':	goto yy477;
	case 'X':	goto yy478;
	default:	goto yy57;
	}
yy579:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':
	case 'c':	goto yy580;
	default:	goto yy57;
	}
yy580:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy532;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	case 'E':
	case 'e':	goto yy581;
	default:	goto yy476;
	}
yy581:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'M':
	case 'm':	goto yy582;
	default:	goto yy57;
	}
yy582:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'B':
	case 'b':	goto yy583;
	default:	goto yy57;
	}
yy583:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy584;
	default:	goto yy57;
	}
yy584:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy540;
	default:	goto yy57;
	}
yy585:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'P':
	case 'p':	goto yy586;
	default:	goto yy57;
	}
yy586:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy532;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	case 'T':
	case 't':	goto yy587;
	default:	goto yy476;
	}
yy587:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy532;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	case 'E':
	case 'e':	goto yy588;
	default:	goto yy476;
	}
yy588:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'M':
	case 'm':	goto yy589;
	default:	goto yy57;
	}
yy589:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'B':
	case 'b':	goto yy590;
	default:	goto yy57;
	}
yy590:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy591;
	default:	goto yy57;
	}
yy591:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy540;
	default:	goto yy57;
	}
yy592:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy593;
	case 'Y':
	case 'y':	goto yy540;
	default:	goto yy57;
	}
yy593:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy532;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	case 'C':
	case 'c':	goto yy594;
	default:	goto yy476;
	}
yy594:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':
	case 'h':	goto yy540;
	default:	goto yy57;
	}
yy595:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'B':
	case 'b':	goto yy596;
	default:	goto yy57;
	}
yy596:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy532;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	case 'R':
	case 'r':	goto yy597;
	default:	goto yy476;
	}
yy597:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'U':
	case 'u':	goto yy598;
	default:	goto yy57;
	}
yy598:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy599;
	default:	goto yy57;
	}
yy599:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy600;
	default:	goto yy57;
	}
yy600:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy540;
	default:	goto yy57;
	}
yy601:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy608;
	case '6':	goto yy609;
	case '7':
	case '8':
	case '9':	goto yy610;
	default:	goto yy57;
	}
yy602:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy603;
	default:	goto yy57;
	}
yy603:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy604;
	default:	goto yy57;
	}
yy604:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy605;
	default:	goto yy57;
	}
yy605:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy606;
	default:	goto yy57;
	}
yy606:
	++YYCURSOR;
#line 1326 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("pointed date YYYY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
#line 17002 "<stdout>"
yy608:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy497;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy613;
	default:	goto yy491;
	}
yy609:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy497;
	case '0':	goto yy613;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy611;
	default:	goto yy491;
	}
yy610:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy497;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy611;
	default:	goto yy491;
	}
yy611:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy605;
	default:	goto yy612;
	}
yy612:
#line 1338 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("pointed date YY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
#line 17083 "<stdout>"
yy613:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy501;
	case '.':	goto yy497;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy605;
	case 'A':
	case 'P':
	case 'a':
	case 'p':	goto yy503;
	default:	goto yy491;
	}
yy614:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy508;
	case '.':
	case ':':	goto yy493;
	case 'A':
	case 'P':
	case 'a':
	case 'p':	goto yy510;
	default:	goto yy491;
	}
yy615:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy508;
	case '-':	goto yy602;
	case '.':	goto yy601;
	case ':':	goto yy493;
	case 'A':
	case 'P':
	case 'a':
	case 'p':	goto yy510;
	default:	goto yy491;
	}
yy616:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy655;
	case '.':	goto yy602;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy618;
	default:	goto yy57;
	}
yy617:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy655;
	case '.':	goto yy602;
	case '0':
	case '1':
	case '2':	goto yy618;
	default:	goto yy57;
	}
yy618:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy655;
	case '.':	goto yy602;
	default:	goto yy57;
	}
yy619:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy651;
	case 'U':
	case 'u':	goto yy650;
	default:	goto yy57;
	}
yy620:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy648;
	default:	goto yy57;
	}
yy621:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy645;
	default:	goto yy57;
	}
yy622:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'P':
	case 'p':	goto yy642;
	case 'U':
	case 'u':	goto yy641;
	default:	goto yy57;
	}
yy623:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy638;
	default:	goto yy57;
	}
yy624:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':
	case 'c':	goto yy636;
	default:	goto yy57;
	}
yy625:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'O':
	case 'o':	goto yy634;
	default:	goto yy57;
	}
yy626:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy627;
	default:	goto yy57;
	}
yy627:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':
	case 'c':	goto yy628;
	default:	goto yy57;
	}
yy628:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':	goto yy532;
	case '-':	goto yy629;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	case 'E':
	case 'e':	goto yy581;
	default:	goto yy476;
	}
yy629:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy630;
	case '1':
	case '2':	goto yy631;
	case '3':	goto yy632;
	default:	goto yy533;
	}
yy630:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy633;
	default:	goto yy535;
	}
yy631:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy633;
	default:	goto yy535;
	}
yy632:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':	goto yy633;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy541;
	default:	goto yy535;
	}
yy633:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy542;
	default:	goto yy535;
	}
yy634:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'V':
	case 'v':	goto yy635;
	default:	goto yy57;
	}
yy635:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':	goto yy532;
	case '-':	goto yy629;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	case 'E':
	case 'e':	goto yy536;
	default:	goto yy476;
	}
yy636:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy637;
	default:	goto yy57;
	}
yy637:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':	goto yy532;
	case '-':	goto yy629;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	case 'O':
	case 'o':	goto yy546;
	default:	goto yy476;
	}
yy638:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'P':
	case 'p':	goto yy639;
	default:	goto yy57;
	}
yy639:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':	goto yy532;
	case '-':	goto yy629;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	case 'T':
	case 't':	goto yy640;
	default:	goto yy476;
	}
yy640:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':	goto yy532;
	case '-':	goto yy629;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	case 'E':
	case 'e':	goto yy588;
	default:	goto yy476;
	}
yy641:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'G':
	case 'g':	goto yy644;
	default:	goto yy57;
	}
yy642:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy643;
	default:	goto yy57;
	}
yy643:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':	goto yy532;
	case '-':	goto yy629;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	case 'I':
	case 'i':	goto yy552;
	default:	goto yy476;
	}
yy644:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':	goto yy532;
	case '-':	goto yy629;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	case 'U':
	case 'u':	goto yy554;
	default:	goto yy476;
	}
yy645:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy646;
	case 'Y':
	case 'y':	goto yy647;
	default:	goto yy57;
	}
yy646:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':	goto yy532;
	case '-':	goto yy629;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	case 'C':
	case 'c':	goto yy594;
	default:	goto yy476;
	}
yy647:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':	goto yy532;
	case '-':	goto yy629;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	default:	goto yy476;
	}
yy648:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'B':
	case 'b':	goto yy649;
	default:	goto yy57;
	}
yy649:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':	goto yy532;
	case '-':	goto yy629;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	case 'R':
	case 'r':	goto yy597;
	default:	goto yy476;
	}
yy650:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'L':
	case 'l':	goto yy654;
	case 'N':
	case 'n':	goto yy653;
	default:	goto yy57;
	}
yy651:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':
	case 'n':	goto yy652;
	default:	goto yy57;
	}
yy652:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':	goto yy532;
	case '-':	goto yy629;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	case 'U':
	case 'u':	goto yy559;
	default:	goto yy476;
	}
yy653:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':	goto yy532;
	case '-':	goto yy629;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	case 'E':
	case 'e':	goto yy540;
	default:	goto yy476;
	}
yy654:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':	goto yy532;
	case '-':	goto yy629;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy534;
	case 'Y':
	case 'y':	goto yy540;
	default:	goto yy476;
	}
yy655:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy656;
	case '3':	goto yy658;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	default:	goto yy57;
	}
yy656:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy665;
	case 'n':	goto yy661;
	case 'r':	goto yy662;
	case 's':	goto yy660;
	case 't':	goto yy663;
	default:	goto yy657;
	}
yy657:
#line 1299 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("gnudateshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 17705 "<stdout>"
yy658:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':	goto yy665;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy604;
	case 'n':	goto yy661;
	case 'r':	goto yy662;
	case 's':	goto yy660;
	case 't':	goto yy663;
	default:	goto yy657;
	}
yy659:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy604;
	case 'n':	goto yy661;
	case 'r':	goto yy662;
	case 's':	goto yy660;
	case 't':	goto yy663;
	default:	goto yy657;
	}
yy660:
	yych = *++YYCURSOR;
	switch (yych) {
	case 't':	goto yy664;
	default:	goto yy57;
	}
yy661:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'd':	goto yy664;
	default:	goto yy57;
	}
yy662:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'd':	goto yy664;
	default:	goto yy57;
	}
yy663:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'h':	goto yy664;
	default:	goto yy57;
	}
yy664:
	yych = *++YYCURSOR;
	goto yy657;
yy665:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy605;
	case 'n':	goto yy661;
	case 'r':	goto yy662;
	case 's':	goto yy660;
	case 't':	goto yy663;
	default:	goto yy657;
	}
yy666:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '/':	goto yy723;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy669;
	case 'n':	goto yy720;
	case 'r':	goto yy721;
	case 's':	goto yy719;
	case 't':	goto yy722;
	default:	goto yy667;
	}
yy667:
#line 1246 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("americanshort | american");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '/') {
			s->time->y = timelib_get_nr((char **) &ptr, 4);
			TIMELIB_PROCESS_YEAR(s->time->y);
		}
		TIMELIB_DEINIT;
		return TIMELIB_AMERICAN;
	}
#line 17829 "<stdout>"
yy668:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '/':	goto yy723;
	case '0':
	case '1':	goto yy669;
	case 'n':	goto yy720;
	case 'r':	goto yy721;
	case 's':	goto yy719;
	case 't':	goto yy722;
	default:	goto yy667;
	}
yy669:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '/':	goto yy723;
	case 'n':	goto yy720;
	case 'r':	goto yy721;
	case 's':	goto yy719;
	case 't':	goto yy722;
	default:	goto yy667;
	}
yy670:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy718;
	case 'U':
	case 'u':	goto yy717;
	default:	goto yy57;
	}
yy671:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy716;
	default:	goto yy57;
	}
yy672:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy715;
	default:	goto yy57;
	}
yy673:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'P':
	case 'p':	goto yy714;
	case 'U':
	case 'u':	goto yy713;
	default:	goto yy57;
	}
yy674:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy711;
	default:	goto yy57;
	}
yy675:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':
	case 'c':	goto yy710;
	default:	goto yy57;
	}
yy676:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'O':
	case 'o':	goto yy709;
	default:	goto yy57;
	}
yy677:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy678;
	default:	goto yy57;
	}
yy678:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':
	case 'c':	goto yy679;
	default:	goto yy57;
	}
yy679:
	yych = *++YYCURSOR;
	switch (yych) {
	case '/':	goto yy680;
	default:	goto yy57;
	}
yy680:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy681;
	default:	goto yy57;
	}
yy681:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy682;
	default:	goto yy57;
	}
yy682:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy683;
	default:	goto yy57;
	}
yy683:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy684;
	default:	goto yy57;
	}
yy684:
	yych = *++YYCURSOR;
	switch (yych) {
	case ':':	goto yy685;
	default:	goto yy57;
	}
yy685:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':	goto yy686;
	case '2':	goto yy687;
	default:	goto yy57;
	}
yy686:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy688;
	default:	goto yy57;
	}
yy687:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':	goto yy688;
	default:	goto yy57;
	}
yy688:
	yych = *++YYCURSOR;
	switch (yych) {
	case ':':	goto yy689;
	default:	goto yy57;
	}
yy689:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy690;
	default:	goto yy57;
	}
yy690:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy691;
	default:	goto yy57;
	}
yy691:
	yych = *++YYCURSOR;
	switch (yych) {
	case ':':	goto yy692;
	default:	goto yy57;
	}
yy692:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy693;
	case '6':	goto yy694;
	default:	goto yy57;
	}
yy693:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy695;
	default:	goto yy57;
	}
yy694:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy695;
	default:	goto yy57;
	}
yy695:
	yych = *++YYCURSOR;
	switch (yych) {
	case '\t':
	case ' ':	goto yy696;
	default:	goto yy57;
	}
yy696:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
	switch (yych) {
	case '\t':
	case ' ':	goto yy696;
	case '+':
	case '-':	goto yy699;
	case 'G':	goto yy698;
	default:	goto yy57;
	}
yy698:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'M':	goto yy707;
	default:	goto yy57;
	}
yy699:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':	goto yy700;
	case '2':	goto yy702;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy703;
	default:	goto yy57;
	}
yy700:
	++YYCURSOR;
	switch ((yych = *YYCURSOR)) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy703;
	case ':':	goto yy704;
	default:	goto yy701;
	}
yy701:
#line 1517 "ext/date/lib/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("clf");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
		if (tz_not_found) {
			add_error(s, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 18174 "<stdout>"
yy702:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':	goto yy703;
	case '5':	goto yy705;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy706;
	case ':':	goto yy704;
	default:	goto yy701;
	}
yy703:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy705;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy706;
	case ':':	goto yy704;
	default:	goto yy701;
	}
yy704:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy705;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy706;
	default:	goto yy701;
	}
yy705:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy706;
	default:	goto yy701;
	}
yy706:
	yych = *++YYCURSOR;
	goto yy701;
yy707:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':	goto yy708;
	default:	goto yy57;
	}
yy708:
	yych = *++YYCURSOR;
	switch (yych) {
	case '+':
	case '-':	goto yy699;
	default:	goto yy57;
	}
yy709:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'V':
	case 'v':	goto yy679;
	default:	goto yy57;
	}
yy710:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy679;
	default:	goto yy57;
	}
yy711:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'P':
	case 'p':	goto yy712;
	default:	goto yy57;
	}
yy712:
	yych = *++YYCURSOR;
	switch (yych) {
	case '/':	goto yy680;
	case 'T':
	case 't':	goto yy679;
	default:	goto yy57;
	}
yy713:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'G':
	case 'g':	goto yy679;
	default:	goto yy57;
	}
yy714:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy679;
	default:	goto yy57;
	}
yy715:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'Y':
	case 'r':
	case 'y':	goto yy679;
	default:	goto yy57;
	}
yy716:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'B':
	case 'b':	goto yy679;
	default:	goto yy57;
	}
yy717:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'L':
	case 'N':
	case 'l':
	case 'n':	goto yy679;
	default:	goto yy57;
	}
yy718:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':
	case 'n':	goto yy679;
	default:	goto yy57;
	}
yy719:
	yych = *++YYCURSOR;
	switch (yych) {
	case 't':	goto yy728;
	default:	goto yy57;
	}
yy720:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'd':	goto yy728;
	default:	goto yy57;
	}
yy721:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'd':	goto yy728;
	default:	goto yy57;
	}
yy722:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'h':	goto yy728;
	default:	goto yy57;
	}
yy723:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy724;
	default:	goto yy57;
	}
yy724:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy725;
	default:	goto yy667;
	}
yy725:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy726;
	default:	goto yy667;
	}
yy726:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy727;
	default:	goto yy667;
	}
yy727:
	yych = *++YYCURSOR;
	goto yy667;
yy728:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '/':	goto yy723;
	default:	goto yy667;
	}
yy729:
	yych = *++YYCURSOR;
	switch (yych) {
	case '\t':
	case '.':	goto yy731;
	case '-':	goto yy732;
	case '/':	goto yy730;
	default:	goto yy578;
	}
yy730:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy673;
	case 'D':
	case 'd':	goto yy677;
	case 'F':
	case 'f':	goto yy671;
	case 'J':
	case 'j':	goto yy670;
	case 'M':
	case 'm':	goto yy672;
	case 'N':
	case 'n':	goto yy676;
	case 'O':
	case 'o':	goto yy675;
	case 'S':
	case 's':	goto yy674;
	default:	goto yy57;
	}
yy731:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy736;
	case '1':	goto yy737;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy738;
	default:	goto yy578;
	}
yy732:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy733;
	case '1':	goto yy734;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy735;
	default:	goto yy578;
	}
yy733:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':
	case '.':	goto yy602;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy735;
	default:	goto yy57;
	}
yy734:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':
	case '.':	goto yy602;
	case '0':
	case '1':
	case '2':	goto yy735;
	default:	goto yy57;
	}
yy735:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':
	case '.':	goto yy602;
	default:	goto yy57;
	}
yy736:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy602;
	case '.':	goto yy739;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy738;
	default:	goto yy57;
	}
yy737:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy602;
	case '.':	goto yy739;
	case '0':
	case '1':
	case '2':	goto yy738;
	default:	goto yy57;
	}
yy738:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy602;
	case '.':	goto yy739;
	default:	goto yy57;
	}
yy739:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy740;
	default:	goto yy57;
	}
yy740:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy611;
	default:	goto yy57;
	}
yy741:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy785;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy783;
	default:	goto yy61;
	}
yy742:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy751;
	case '1':	goto yy752;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy753;
	case 'A':
	case 'a':	goto yy746;
	case 'D':
	case 'd':	goto yy750;
	case 'F':
	case 'f':	goto yy744;
	case 'J':
	case 'j':	goto yy743;
	case 'M':
	case 'm':	goto yy745;
	case 'N':
	case 'n':	goto yy749;
	case 'O':
	case 'o':	goto yy748;
	case 'S':
	case 's':	goto yy747;
	default:	goto yy57;
	}
yy743:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy782;
	case 'U':
	case 'u':	goto yy781;
	default:	goto yy57;
	}
yy744:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy780;
	default:	goto yy57;
	}
yy745:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy779;
	default:	goto yy57;
	}
yy746:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'P':
	case 'p':	goto yy778;
	case 'U':
	case 'u':	goto yy777;
	default:	goto yy57;
	}
yy747:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy775;
	default:	goto yy57;
	}
yy748:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':
	case 'c':	goto yy774;
	default:	goto yy57;
	}
yy749:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'O':
	case 'o':	goto yy773;
	default:	goto yy57;
	}
yy750:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy765;
	default:	goto yy57;
	}
yy751:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy754;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy758;
	default:	goto yy57;
	}
yy752:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy754;
	case '0':
	case '1':
	case '2':	goto yy758;
	default:	goto yy57;
	}
yy753:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy754;
	default:	goto yy57;
	}
yy754:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy755;
	case '3':	goto yy756;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy757;
	default:	goto yy57;
	}
yy755:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy757;
	case 'n':	goto yy661;
	case 'r':	goto yy662;
	case 's':	goto yy660;
	case 't':	goto yy663;
	default:	goto yy657;
	}
yy756:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':	goto yy757;
	case 'n':	goto yy661;
	case 'r':	goto yy662;
	case 's':	goto yy660;
	case 't':	goto yy663;
	default:	goto yy657;
	}
yy757:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'n':	goto yy661;
	case 'r':	goto yy662;
	case 's':	goto yy660;
	case 't':	goto yy663;
	default:	goto yy657;
	}
yy758:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy759;
	default:	goto yy57;
	}
yy759:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy760;
	case '1':
	case '2':	goto yy761;
	case '3':	goto yy762;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy757;
	default:	goto yy57;
	}
yy760:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy763;
	case 'n':	goto yy661;
	case 'r':	goto yy662;
	case 's':	goto yy660;
	case 't':	goto yy663;
	default:	goto yy657;
	}
yy761:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy763;
	case 'n':	goto yy661;
	case 'r':	goto yy662;
	case 's':	goto yy660;
	case 't':	goto yy663;
	default:	goto yy657;
	}
yy762:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':	goto yy763;
	case 'n':	goto yy661;
	case 'r':	goto yy662;
	case 's':	goto yy660;
	case 't':	goto yy663;
	default:	goto yy657;
	}
yy763:
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'n':	goto yy661;
	case 'r':	goto yy662;
	case 's':	goto yy660;
	case 't':	goto yy663;
	default:	goto yy764;
	}
yy764:
#line 1273 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("iso8601date2");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 18871 "<stdout>"
yy765:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':
	case 'c':	goto yy766;
	default:	goto yy57;
	}
yy766:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy767;
	default:	goto yy57;
	}
yy767:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy768;
	case '1':
	case '2':	goto yy769;
	case '3':	goto yy770;
	default:	goto yy57;
	}
yy768:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy771;
	default:	goto yy57;
	}
yy769:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy771;
	default:	goto yy57;
	}
yy770:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':	goto yy771;
	default:	goto yy57;
	}
yy771:
	++YYCURSOR;
#line 1504 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("pgtextreverse");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 18945 "<stdout>"
yy773:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'V':
	case 'v':	goto yy766;
	default:	goto yy57;
	}
yy774:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy766;
	default:	goto yy57;
	}
yy775:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'P':
	case 'p':	goto yy776;
	default:	goto yy57;
	}
yy776:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy767;
	case 'T':
	case 't':	goto yy766;
	default:	goto yy57;
	}
yy777:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'G':
	case 'g':	goto yy766;
	default:	goto yy57;
	}
yy778:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy766;
	default:	goto yy57;
	}
yy779:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'Y':
	case 'r':
	case 'y':	goto yy766;
	default:	goto yy57;
	}
yy780:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'B':
	case 'b':	goto yy766;
	default:	goto yy57;
	}
yy781:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'L':
	case 'N':
	case 'l':
	case 'n':	goto yy766;
	default:	goto yy57;
	}
yy782:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':
	case 'n':	goto yy766;
	default:	goto yy57;
	}
yy783:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'n':
	case 'o':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy791;
	case '-':	goto yy788;
	case '.':	goto yy792;
	case '/':	goto yy789;
	case '0':	goto yy805;
	case '1':	goto yy806;
	case '2':	goto yy808;
	case '3':	goto yy809;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy55;
	case ':':	goto yy807;
	case 'W':	goto yy810;
	default:	goto yy784;
	}
yy784:
#line 1538 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("year4");
		TIMELIB_INIT;
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 19079 "<stdout>"
yy785:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy786;
	case '1':	goto yy787;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy753;
	case 'A':
	case 'a':	goto yy746;
	case 'D':
	case 'd':	goto yy750;
	case 'F':
	case 'f':	goto yy744;
	case 'J':
	case 'j':	goto yy743;
	case 'M':
	case 'm':	goto yy745;
	case 'N':
	case 'n':	goto yy749;
	case 'O':
	case 'o':	goto yy748;
	case 'S':
	case 's':	goto yy747;
	default:	goto yy57;
	}
yy786:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy754;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy753;
	default:	goto yy57;
	}
yy787:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy754;
	case '0':
	case '1':
	case '2':	goto yy753;
	default:	goto yy57;
	}
yy788:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy973;
	case '1':	goto yy975;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy976;
	case 'A':
	case 'a':	goto yy967;
	case 'D':
	case 'd':	goto yy971;
	case 'F':
	case 'f':	goto yy965;
	case 'J':
	case 'j':	goto yy964;
	case 'M':
	case 'm':	goto yy966;
	case 'N':
	case 'n':	goto yy970;
	case 'O':
	case 'o':	goto yy969;
	case 'S':
	case 's':	goto yy968;
	case 'W':	goto yy972;
	default:	goto yy939;
	}
yy789:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy947;
	case '1':	goto yy948;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy949;
	default:	goto yy57;
	}
yy790:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy791:
	switch (yych) {
	case '\t':
	case ' ':	goto yy790;
	case '-':
	case '.':	goto yy938;
	case 'A':
	case 'a':	goto yy800;
	case 'D':
	case 'd':	goto yy804;
	case 'F':
	case 'f':	goto yy798;
	case 'H':
	case 'h':	goto yy64;
	case 'I':	goto yy793;
	case 'J':
	case 'j':	goto yy797;
	case 'M':
	case 'm':	goto yy799;
	case 'N':
	case 'n':	goto yy803;
	case 'O':
	case 'o':	goto yy802;
	case 'S':
	case 's':	goto yy801;
	case 'T':
	case 't':	goto yy69;
	case 'V':	goto yy795;
	case 'W':
	case 'w':	goto yy68;
	case 'X':	goto yy796;
	case 'Y':
	case 'y':	goto yy67;
	default:	goto yy57;
	}
yy792:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy931;
	case '1':
	case '2':	goto yy932;
	case '3':	goto yy933;
	default:	goto yy939;
	}
yy793:
	++YYCURSOR;
	switch ((yych = *YYCURSOR)) {
	case 'I':	goto yy930;
	case 'V':
	case 'X':	goto yy884;
	default:	goto yy794;
	}
yy794:
#line 1364 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("datenodayrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 19252 "<stdout>"
yy795:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'I':	goto yy928;
	default:	goto yy794;
	}
yy796:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'I':	goto yy927;
	default:	goto yy794;
	}
yy797:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy920;
	case 'U':
	case 'u':	goto yy919;
	default:	goto yy57;
	}
yy798:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy913;
	case 'O':
	case 'o':	goto yy99;
	case 'R':
	case 'r':	goto yy98;
	default:	goto yy57;
	}
yy799:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy910;
	case 'I':
	case 'i':	goto yy118;
	case 'O':
	case 'o':	goto yy117;
	default:	goto yy57;
	}
yy800:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'P':
	case 'p':	goto yy904;
	case 'U':
	case 'u':	goto yy903;
	default:	goto yy57;
	}
yy801:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy127;
	case 'E':
	case 'e':	goto yy896;
	case 'U':
	case 'u':	goto yy126;
	default:	goto yy57;
	}
yy802:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':
	case 'c':	goto yy891;
	default:	goto yy57;
	}
yy803:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'O':
	case 'o':	goto yy885;
	default:	goto yy57;
	}
yy804:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy114;
	case 'E':
	case 'e':	goto yy878;
	default:	goto yy57;
	}
yy805:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy875;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy876;
	default:	goto yy61;
	}
yy806:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy844;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy823;
	default:	goto yy61;
	}
yy807:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy824;
	case '1':	goto yy825;
	default:	goto yy57;
	}
yy808:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy823;
	default:	goto yy61;
	}
yy809:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy819;
	case '6':	goto yy820;
	case '7':
	case '8':
	case '9':	goto yy55;
	default:	goto yy61;
	}
yy810:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy811;
	case '1':
	case '2':
	case '3':
	case '4':	goto yy812;
	case '5':	goto yy813;
	case 'E':
	case 'e':	goto yy83;
	default:	goto yy57;
	}
yy811:
	yych = *++YYCURSOR;
	switch (yych) {
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy814;
	default:	goto yy57;
	}
yy812:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy814;
	default:	goto yy57;
	}
yy813:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':	goto yy814;
	default:	goto yy57;
	}
yy814:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy816;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':	goto yy817;
	default:	goto yy815;
	}
yy815:
#line 1472 "ext/date/lib/parse_date.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = 1;
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 19491 "<stdout>"
yy816:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':	goto yy817;
	default:	goto yy57;
	}
yy817:
	++YYCURSOR;
#line 1453 "ext/date/lib/parse_date.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweekday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = timelib_get_nr((char **) &ptr, 1);
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 19525 "<stdout>"
yy819:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy821;
	default:	goto yy61;
	}
yy820:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':	goto yy821;
	case '7':
	case '8':
	case '9':	goto yy55;
	default:	goto yy61;
	}
yy821:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy61;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy55;
	default:	goto yy822;
	}
yy822:
#line 1440 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("pgydotd");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = timelib_get_nr((char **) &ptr, 3);
		s->time->m = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_YEARDAY;
	}
#line 19603 "<stdout>"
yy823:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy821;
	default:	goto yy61;
	}
yy824:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy826;
	default:	goto yy57;
	}
yy825:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy826;
	default:	goto yy57;
	}
yy826:
	yych = *++YYCURSOR;
	switch (yych) {
	case ':':	goto yy827;
	default:	goto yy57;
	}
yy827:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy828;
	case '1':
	case '2':	goto yy829;
	case '3':	goto yy830;
	default:	goto yy57;
	}
yy828:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy831;
	default:	goto yy57;
	}
yy829:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy831;
	default:	goto yy57;
	}
yy830:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':	goto yy831;
	default:	goto yy57;
	}
yy831:
	yych = *++YYCURSOR;
	switch (yych) {
	case ' ':	goto yy832;
	default:	goto yy57;
	}
yy832:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':	goto yy833;
	case '2':	goto yy834;
	default:	goto yy57;
	}
yy833:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy835;
	default:	goto yy57;
	}
yy834:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':	goto yy835;
	default:	goto yy57;
	}
yy835:
	yych = *++YYCURSOR;
	switch (yych) {
	case ':':	goto yy836;
	default:	goto yy57;
	}
yy836:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy837;
	default:	goto yy57;
	}
yy837:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy838;
	default:	goto yy57;
	}
yy838:
	yych = *++YYCURSOR;
	switch (yych) {
	case ':':	goto yy839;
	default:	goto yy57;
	}
yy839:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy840;
	case '6':	goto yy841;
	default:	goto yy57;
	}
yy840:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy842;
	default:	goto yy57;
	}
yy841:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy842;
	default:	goto yy57;
	}
yy842:
	++YYCURSOR;
yy843:
#line 1414 "ext/date/lib/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("xmlrpc | xmlrpcnocolon | soap | wddx | exif");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '.') {
			s->time->f = timelib_get_frac_nr((char **) &ptr, 9);
			if (*ptr) { /* timezone is optional */
				s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
				if (tz_not_found) {
					add_error(s, "The timezone could not be found in the database");
				}
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_XMLRPC_SOAP;
	}
#line 19832 "<stdout>"
yy844:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy845;
	case '1':
	case '2':	goto yy846;
	case '3':	goto yy847;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy821;
	default:	goto yy61;
	}
yy845:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy61;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy848;
	default:	goto yy822;
	}
yy846:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy61;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy848;
	default:	goto yy822;
	}
yy847:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy61;
	case '0':
	case '1':	goto yy848;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy55;
	default:	goto yy822;
	}
yy848:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy60;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy55;
	case 'D':
	case 'd':	goto yy65;
	case 'F':
	case 'f':	goto yy66;
	case 'H':
	case 'h':	goto yy64;
	case 'M':
	case 'm':	goto yy63;
	case 'S':
	case 's':	goto yy62;
	case 'T':	goto yy850;
	case 'W':
	case 'w':	goto yy68;
	case 'Y':
	case 'y':	goto yy67;
	case 't':	goto yy851;
	default:	goto yy849;
	}
yy849:
#line 1402 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("datenocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NOCOLON;
	}
#line 19996 "<stdout>"
yy850:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':	goto yy865;
	case '2':	goto yy866;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy867;
	case 'H':
	case 'h':	goto yy70;
	case 'U':
	case 'u':	goto yy71;
	default:	goto yy57;
	}
yy851:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':	goto yy852;
	case '2':	goto yy853;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy854;
	case 'H':
	case 'h':	goto yy70;
	case 'U':
	case 'u':	goto yy71;
	default:	goto yy57;
	}
yy852:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy859;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy854;
	default:	goto yy57;
	}
yy853:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':	goto yy859;
	case '5':	goto yy855;
	default:	goto yy57;
	}
yy854:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy855;
	default:	goto yy57;
	}
yy855:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy856;
	default:	goto yy57;
	}
yy856:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy857;
	case '6':	goto yy858;
	default:	goto yy57;
	}
yy857:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy842;
	default:	goto yy57;
	}
yy858:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy842;
	default:	goto yy57;
	}
yy859:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy860;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy856;
	default:	goto yy57;
	}
yy860:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy861;
	case '6':	goto yy862;
	case '7':
	case '8':
	case '9':	goto yy856;
	default:	goto yy57;
	}
yy861:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy863;
	case '6':	goto yy864;
	case '7':
	case '8':
	case '9':	goto yy842;
	default:	goto yy57;
	}
yy862:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy863;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy857;
	case '6':	goto yy858;
	default:	goto yy57;
	}
yy863:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy842;
	default:	goto yy843;
	}
yy864:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy842;
	default:	goto yy843;
	}
yy865:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy874;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy867;
	case ':':	goto yy868;
	default:	goto yy57;
	}
yy866:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':	goto yy874;
	case '5':	goto yy855;
	case ':':	goto yy868;
	default:	goto yy57;
	}
yy867:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy855;
	case ':':	goto yy868;
	default:	goto yy57;
	}
yy868:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy869;
	default:	goto yy57;
	}
yy869:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy870;
	default:	goto yy57;
	}
yy870:
	yych = *++YYCURSOR;
	switch (yych) {
	case ':':	goto yy871;
	default:	goto yy57;
	}
yy871:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy872;
	case '6':	goto yy873;
	default:	goto yy57;
	}
yy872:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy842;
	default:	goto yy57;
	}
yy873:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy842;
	default:	goto yy57;
	}
yy874:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy860;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy856;
	case ':':	goto yy868;
	default:	goto yy57;
	}
yy875:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy877;
	case '1':
	case '2':	goto yy846;
	case '3':	goto yy847;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy821;
	default:	goto yy61;
	}
yy876:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy845;
	case '1':
	case '2':	goto yy846;
	case '3':	goto yy847;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy821;
	default:	goto yy61;
	}
yy877:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy848;
	default:	goto yy61;
	}
yy878:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':
	case 'c':	goto yy879;
	default:	goto yy57;
	}
yy879:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'E':
	case 'e':	goto yy880;
	default:	goto yy794;
	}
yy880:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'M':
	case 'm':	goto yy881;
	default:	goto yy57;
	}
yy881:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'B':
	case 'b':	goto yy882;
	default:	goto yy57;
	}
yy882:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy883;
	default:	goto yy57;
	}
yy883:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy884;
	default:	goto yy57;
	}
yy884:
	yych = *++YYCURSOR;
	goto yy794;
yy885:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'V':
	case 'v':	goto yy886;
	default:	goto yy57;
	}
yy886:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'E':
	case 'e':	goto yy887;
	default:	goto yy794;
	}
yy887:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'M':
	case 'm':	goto yy888;
	default:	goto yy57;
	}
yy888:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'B':
	case 'b':	goto yy889;
	default:	goto yy57;
	}
yy889:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy890;
	default:	goto yy57;
	}
yy890:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy884;
	default:	goto yy57;
	}
yy891:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy892;
	default:	goto yy57;
	}
yy892:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'O':
	case 'o':	goto yy893;
	default:	goto yy794;
	}
yy893:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'B':
	case 'b':	goto yy894;
	default:	goto yy57;
	}
yy894:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy895;
	default:	goto yy57;
	}
yy895:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy884;
	default:	goto yy57;
	}
yy896:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':
	case 'c':	goto yy129;
	case 'P':
	case 'p':	goto yy897;
	default:	goto yy57;
	}
yy897:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy898;
	default:	goto yy794;
	}
yy898:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'E':
	case 'e':	goto yy899;
	default:	goto yy794;
	}
yy899:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'M':
	case 'm':	goto yy900;
	default:	goto yy57;
	}
yy900:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'B':
	case 'b':	goto yy901;
	default:	goto yy57;
	}
yy901:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy902;
	default:	goto yy57;
	}
yy902:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy884;
	default:	goto yy57;
	}
yy903:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'G':
	case 'g':	goto yy907;
	default:	goto yy57;
	}
yy904:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy905;
	default:	goto yy57;
	}
yy905:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'I':
	case 'i':	goto yy906;
	default:	goto yy794;
	}
yy906:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'L':
	case 'l':	goto yy884;
	default:	goto yy57;
	}
yy907:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'U':
	case 'u':	goto yy908;
	default:	goto yy794;
	}
yy908:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'S':
	case 's':	goto yy909;
	default:	goto yy57;
	}
yy909:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy884;
	default:	goto yy57;
	}
yy910:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy911;
	case 'Y':
	case 'y':	goto yy884;
	default:	goto yy57;
	}
yy911:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'C':
	case 'c':	goto yy912;
	default:	goto yy794;
	}
yy912:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':
	case 'h':	goto yy884;
	default:	goto yy57;
	}
yy913:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'B':
	case 'b':	goto yy914;
	default:	goto yy57;
	}
yy914:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'R':
	case 'r':	goto yy915;
	default:	goto yy794;
	}
yy915:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'U':
	case 'u':	goto yy916;
	default:	goto yy57;
	}
yy916:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy917;
	default:	goto yy57;
	}
yy917:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy918;
	default:	goto yy57;
	}
yy918:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy884;
	default:	goto yy57;
	}
yy919:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'L':
	case 'l':	goto yy926;
	case 'N':
	case 'n':	goto yy925;
	default:	goto yy57;
	}
yy920:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':
	case 'n':	goto yy921;
	default:	goto yy57;
	}
yy921:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'U':
	case 'u':	goto yy922;
	default:	goto yy794;
	}
yy922:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy923;
	default:	goto yy57;
	}
yy923:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy924;
	default:	goto yy57;
	}
yy924:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy884;
	default:	goto yy57;
	}
yy925:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy884;
	default:	goto yy794;
	}
yy926:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy884;
	default:	goto yy794;
	}
yy927:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'I':	goto yy884;
	default:	goto yy794;
	}
yy928:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'I':	goto yy929;
	default:	goto yy794;
	}
yy929:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'I':	goto yy884;
	default:	goto yy794;
	}
yy930:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'I':	goto yy884;
	default:	goto yy794;
	}
yy931:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy946;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy945;
	default:	goto yy57;
	}
yy932:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy944;
	default:	goto yy57;
	}
yy933:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy942;
	case '6':	goto yy941;
	default:	goto yy57;
	}
yy934:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy913;
	default:	goto yy57;
	}
yy935:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy910;
	default:	goto yy57;
	}
yy936:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy940;
	default:	goto yy57;
	}
yy937:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy878;
	default:	goto yy57;
	}
yy938:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy939:
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy938;
	case 'A':
	case 'a':	goto yy800;
	case 'D':
	case 'd':	goto yy937;
	case 'F':
	case 'f':	goto yy934;
	case 'I':	goto yy793;
	case 'J':
	case 'j':	goto yy797;
	case 'M':
	case 'm':	goto yy935;
	case 'N':
	case 'n':	goto yy803;
	case 'O':
	case 'o':	goto yy802;
	case 'S':
	case 's':	goto yy936;
	case 'V':	goto yy795;
	case 'X':	goto yy796;
	default:	goto yy57;
	}
yy940:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'P':
	case 'p':	goto yy897;
	default:	goto yy57;
	}
yy941:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':	goto yy943;
	default:	goto yy57;
	}
yy942:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy943;
	default:	goto yy57;
	}
yy943:
	yych = *++YYCURSOR;
	goto yy822;
yy944:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy943;
	default:	goto yy57;
	}
yy945:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy943;
	default:	goto yy57;
	}
yy946:
	yych = *++YYCURSOR;
	switch (yych) {
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy943;
	default:	goto yy57;
	}
yy947:
	yych = *++YYCURSOR;
	switch (yych) {
	case '/':	goto yy950;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy958;
	default:	goto yy57;
	}
yy948:
	yych = *++YYCURSOR;
	switch (yych) {
	case '/':	goto yy950;
	case '0':
	case '1':
	case '2':	goto yy958;
	default:	goto yy57;
	}
yy949:
	yych = *++YYCURSOR;
	switch (yych) {
	case '/':	goto yy950;
	default:	goto yy57;
	}
yy950:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy951;
	case '3':	goto yy952;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy953;
	default:	goto yy57;
	}
yy951:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy953;
	case 'n':	goto yy955;
	case 'r':	goto yy956;
	case 's':	goto yy954;
	case 't':	goto yy957;
	default:	goto yy455;
	}
yy952:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':	goto yy953;
	case 'n':	goto yy955;
	case 'r':	goto yy956;
	case 's':	goto yy954;
	case 't':	goto yy957;
	default:	goto yy455;
	}
yy953:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'n':	goto yy955;
	case 'r':	goto yy956;
	case 's':	goto yy954;
	case 't':	goto yy957;
	default:	goto yy455;
	}
yy954:
	yych = *++YYCURSOR;
	switch (yych) {
	case 't':	goto yy454;
	default:	goto yy57;
	}
yy955:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'd':	goto yy454;
	default:	goto yy57;
	}
yy956:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'd':	goto yy454;
	default:	goto yy57;
	}
yy957:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'h':	goto yy454;
	default:	goto yy57;
	}
yy958:
	yych = *++YYCURSOR;
	switch (yych) {
	case '/':	goto yy959;
	default:	goto yy57;
	}
yy959:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy960;
	case '1':
	case '2':	goto yy961;
	case '3':	goto yy962;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy953;
	default:	goto yy57;
	}
yy960:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy963;
	case 'n':	goto yy955;
	case 'r':	goto yy956;
	case 's':	goto yy954;
	case 't':	goto yy957;
	default:	goto yy455;
	}
yy961:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy963;
	case 'n':	goto yy955;
	case 'r':	goto yy956;
	case 's':	goto yy954;
	case 't':	goto yy957;
	default:	goto yy455;
	}
yy962:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':	goto yy963;
	case 'n':	goto yy955;
	case 'r':	goto yy956;
	case 's':	goto yy954;
	case 't':	goto yy957;
	default:	goto yy455;
	}
yy963:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '/':	goto yy454;
	case 'n':	goto yy955;
	case 'r':	goto yy956;
	case 's':	goto yy954;
	case 't':	goto yy957;
	default:	goto yy455;
	}
yy964:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy1044;
	case 'U':
	case 'u':	goto yy1043;
	default:	goto yy57;
	}
yy965:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy1041;
	default:	goto yy57;
	}
yy966:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy1038;
	default:	goto yy57;
	}
yy967:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'P':
	case 'p':	goto yy1035;
	case 'U':
	case 'u':	goto yy1034;
	default:	goto yy57;
	}
yy968:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy1031;
	default:	goto yy57;
	}
yy969:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':
	case 'c':	goto yy1029;
	default:	goto yy57;
	}
yy970:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'O':
	case 'o':	goto yy1027;
	default:	goto yy57;
	}
yy971:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy1025;
	default:	goto yy57;
	}
yy972:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy811;
	case '1':
	case '2':
	case '3':
	case '4':	goto yy812;
	case '5':	goto yy813;
	default:	goto yy57;
	}
yy973:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy977;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy996;
	default:	goto yy974;
	}
yy974:
#line 1286 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("gnudateshorter");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 21221 "<stdout>"
yy975:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy977;
	case '0':
	case '1':
	case '2':	goto yy996;
	default:	goto yy974;
	}
yy976:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy977;
	default:	goto yy974;
	}
yy977:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy978;
	case '3':	goto yy979;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy980;
	default:	goto yy57;
	}
yy978:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy980;
	case 'T':	goto yy985;
	case 'n':	goto yy982;
	case 'r':	goto yy983;
	case 's':	goto yy981;
	case 't':	goto yy984;
	default:	goto yy657;
	}
yy979:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':	goto yy980;
	case 'T':	goto yy985;
	case 'n':	goto yy982;
	case 'r':	goto yy983;
	case 's':	goto yy981;
	case 't':	goto yy984;
	default:	goto yy657;
	}
yy980:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'T':	goto yy985;
	case 'n':	goto yy982;
	case 'r':	goto yy983;
	case 's':	goto yy981;
	case 't':	goto yy984;
	default:	goto yy657;
	}
yy981:
	yych = *++YYCURSOR;
	switch (yych) {
	case 't':	goto yy995;
	default:	goto yy57;
	}
yy982:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'd':	goto yy995;
	default:	goto yy57;
	}
yy983:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'd':	goto yy995;
	default:	goto yy57;
	}
yy984:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'h':	goto yy995;
	default:	goto yy57;
	}
yy985:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':	goto yy986;
	case '2':	goto yy987;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy988;
	default:	goto yy57;
	}
yy986:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy988;
	case ':':	goto yy989;
	default:	goto yy57;
	}
yy987:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':	goto yy988;
	case ':':	goto yy989;
	default:	goto yy57;
	}
yy988:
	yych = *++YYCURSOR;
	switch (yych) {
	case ':':	goto yy989;
	default:	goto yy57;
	}
yy989:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy990;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy991;
	default:	goto yy57;
	}
yy990:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy991;
	case ':':	goto yy992;
	default:	goto yy57;
	}
yy991:
	yych = *++YYCURSOR;
	switch (yych) {
	case ':':	goto yy992;
	default:	goto yy57;
	}
yy992:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy993;
	case '6':	goto yy994;
	case '7':
	case '8':
	case '9':	goto yy842;
	default:	goto yy57;
	}
yy993:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy842;
	default:	goto yy843;
	}
yy994:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy842;
	default:	goto yy843;
	}
yy995:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'T':	goto yy985;
	default:	goto yy657;
	}
yy996:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy997;
	default:	goto yy974;
	}
yy997:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy998;
	case '1':
	case '2':	goto yy999;
	case '3':	goto yy1000;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy980;
	default:	goto yy57;
	}
yy998:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1001;
	case 'T':	goto yy985;
	case 'n':	goto yy982;
	case 'r':	goto yy983;
	case 's':	goto yy981;
	case 't':	goto yy984;
	default:	goto yy657;
	}
yy999:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1001;
	case 'T':	goto yy985;
	case 'n':	goto yy982;
	case 'r':	goto yy983;
	case 's':	goto yy981;
	case 't':	goto yy984;
	default:	goto yy657;
	}
yy1000:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':	goto yy1001;
	case 'T':	goto yy985;
	case 'n':	goto yy982;
	case 'r':	goto yy983;
	case 's':	goto yy981;
	case 't':	goto yy984;
	default:	goto yy657;
	}
yy1001:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'T':	goto yy1002;
	case 'n':	goto yy982;
	case 'r':	goto yy983;
	case 's':	goto yy981;
	case 't':	goto yy984;
	default:	goto yy455;
	}
yy1002:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':	goto yy1003;
	case '2':	goto yy1004;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy988;
	default:	goto yy57;
	}
yy1003:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1005;
	case ':':	goto yy989;
	default:	goto yy57;
	}
yy1004:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':	goto yy1005;
	case ':':	goto yy989;
	default:	goto yy57;
	}
yy1005:
	yych = *++YYCURSOR;
	switch (yych) {
	case ':':	goto yy1006;
	default:	goto yy57;
	}
yy1006:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1007;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy991;
	default:	goto yy57;
	}
yy1007:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1008;
	case ':':	goto yy992;
	default:	goto yy57;
	}
yy1008:
	yych = *++YYCURSOR;
	switch (yych) {
	case ':':	goto yy1009;
	default:	goto yy57;
	}
yy1009:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1010;
	case '6':	goto yy1011;
	case '7':
	case '8':
	case '9':	goto yy842;
	default:	goto yy57;
	}
yy1010:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1012;
	default:	goto yy843;
	}
yy1011:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy1012;
	default:	goto yy843;
	}
yy1012:
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy1013;
	default:	goto yy843;
	}
yy1013:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1014;
	default:	goto yy57;
	}
yy1014:
	yyaccept = 23;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
	switch (yych) {
	case '+':
	case '-':	goto yy1017;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1014;
	case 'G':	goto yy1016;
	default:	goto yy843;
	}
yy1016:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'M':	goto yy1023;
	default:	goto yy57;
	}
yy1017:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':	goto yy1018;
	case '2':	goto yy1019;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1020;
	default:	goto yy57;
	}
yy1018:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1020;
	case ':':	goto yy1021;
	default:	goto yy843;
	}
yy1019:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':	goto yy1020;
	case '5':	goto yy1022;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy842;
	case ':':	goto yy1021;
	default:	goto yy843;
	}
yy1020:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1022;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy842;
	case ':':	goto yy1021;
	default:	goto yy843;
	}
yy1021:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1022;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy842;
	default:	goto yy843;
	}
yy1022:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy842;
	default:	goto yy843;
	}
yy1023:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':	goto yy1024;
	default:	goto yy57;
	}
yy1024:
	yych = *++YYCURSOR;
	switch (yych) {
	case '+':
	case '-':	goto yy1017;
	default:	goto yy57;
	}
yy1025:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':
	case 'c':	goto yy1026;
	default:	goto yy57;
	}
yy1026:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy767;
	case 'E':
	case 'e':	goto yy880;
	default:	goto yy794;
	}
yy1027:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'V':
	case 'v':	goto yy1028;
	default:	goto yy57;
	}
yy1028:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy767;
	case 'E':
	case 'e':	goto yy887;
	default:	goto yy794;
	}
yy1029:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy1030;
	default:	goto yy57;
	}
yy1030:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy767;
	case 'O':
	case 'o':	goto yy893;
	default:	goto yy794;
	}
yy1031:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'P':
	case 'p':	goto yy1032;
	default:	goto yy57;
	}
yy1032:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy767;
	case 'T':
	case 't':	goto yy1033;
	default:	goto yy794;
	}
yy1033:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy767;
	case 'E':
	case 'e':	goto yy899;
	default:	goto yy794;
	}
yy1034:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'G':
	case 'g':	goto yy1037;
	default:	goto yy57;
	}
yy1035:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy1036;
	default:	goto yy57;
	}
yy1036:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy767;
	case 'I':
	case 'i':	goto yy906;
	default:	goto yy794;
	}
yy1037:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy767;
	case 'U':
	case 'u':	goto yy908;
	default:	goto yy794;
	}
yy1038:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy1039;
	case 'Y':
	case 'y':	goto yy1040;
	default:	goto yy57;
	}
yy1039:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy767;
	case 'C':
	case 'c':	goto yy912;
	default:	goto yy794;
	}
yy1040:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy767;
	default:	goto yy794;
	}
yy1041:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'B':
	case 'b':	goto yy1042;
	default:	goto yy57;
	}
yy1042:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy767;
	case 'R':
	case 'r':	goto yy915;
	default:	goto yy794;
	}
yy1043:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'L':
	case 'l':	goto yy1047;
	case 'N':
	case 'n':	goto yy1046;
	default:	goto yy57;
	}
yy1044:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':
	case 'n':	goto yy1045;
	default:	goto yy57;
	}
yy1045:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy767;
	case 'U':
	case 'u':	goto yy922;
	default:	goto yy794;
	}
yy1046:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy767;
	case 'E':
	case 'e':	goto yy884;
	default:	goto yy794;
	}
yy1047:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy767;
	case 'Y':
	case 'y':	goto yy884;
	default:	goto yy794;
	}
yy1048:
	yych = *++YYCURSOR;
	switch (yych) {
	case '\t':
	case '.':	goto yy731;
	case '-':	goto yy732;
	case '/':	goto yy730;
	case 'U':
	case 'u':	goto yy78;
	default:	goto yy578;
	}
yy1049:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':
	case 'c':	goto yy129;
	case 'P':
	case 'p':	goto yy586;
	default:	goto yy57;
	}
yy1050:
	yych = *++YYCURSOR;
	switch (yych) {
	case '\t':	goto yy1052;
	case '-':	goto yy1051;
	case '.':	goto yy731;
	case '/':	goto yy730;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy741;
	case 'n':	goto yy470;
	case 'r':	goto yy471;
	case 's':	goto yy464;
	case 't':	goto yy468;
	default:	goto yy1054;
	}
yy1051:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy1055;
	case '1':	goto yy1056;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy618;
	case 'A':
	case 'a':	goto yy622;
	case 'D':
	case 'd':	goto yy626;
	case 'F':
	case 'f':	goto yy620;
	case 'J':
	case 'j':	goto yy619;
	case 'M':
	case 'm':	goto yy621;
	case 'N':
	case 'n':	goto yy625;
	case 'O':
	case 'o':	goto yy624;
	case 'S':
	case 's':	goto yy623;
	default:	goto yy578;
	}
yy1052:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy736;
	case '1':	goto yy737;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy738;
	default:	goto yy1054;
	}
yy1053:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy1054:
	switch (yych) {
	case '\t':
	case ' ':	goto yy1053;
	case '-':
	case '.':	goto yy577;
	case 'A':
	case 'a':	goto yy574;
	case 'D':
	case 'd':	goto yy466;
	case 'F':
	case 'f':	goto yy467;
	case 'H':
	case 'h':	goto yy64;
	case 'I':	goto yy475;
	case 'J':
	case 'j':	goto yy479;
	case 'M':
	case 'm':	goto yy465;
	case 'N':
	case 'n':	goto yy482;
	case 'O':
	case 'o':	goto yy481;
	case 'S':
	case 's':	goto yy463;
	case 'T':
	case 't':	goto yy69;
	case 'V':	goto yy477;
	case 'W':
	case 'w':	goto yy68;
	case 'X':	goto yy478;
	case 'Y':
	case 'y':	goto yy67;
	default:	goto yy57;
	}
yy1055:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy655;
	case '.':	goto yy602;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1057;
	default:	goto yy57;
	}
yy1056:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy655;
	case '.':	goto yy602;
	case '0':
	case '1':
	case '2':	goto yy1057;
	default:	goto yy57;
	}
yy1057:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy1058;
	case '.':	goto yy602;
	default:	goto yy57;
	}
yy1058:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy1059;
	case '1':
	case '2':	goto yy1060;
	case '3':	goto yy1061;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy659;
	default:	goto yy57;
	}
yy1059:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1062;
	case 'n':	goto yy661;
	case 'r':	goto yy662;
	case 's':	goto yy660;
	case 't':	goto yy663;
	default:	goto yy657;
	}
yy1060:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1062;
	case 'n':	goto yy661;
	case 'r':	goto yy662;
	case 's':	goto yy660;
	case 't':	goto yy663;
	default:	goto yy657;
	}
yy1061:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':	goto yy1062;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy604;
	case 'n':	goto yy661;
	case 'r':	goto yy662;
	case 's':	goto yy660;
	case 't':	goto yy663;
	default:	goto yy657;
	}
yy1062:
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy605;
	case 'n':	goto yy661;
	case 'r':	goto yy662;
	case 's':	goto yy660;
	case 't':	goto yy663;
	default:	goto yy764;
	}
yy1063:
	yych = *++YYCURSOR;
	switch (yych) {
	case '\t':	goto yy1052;
	case '-':	goto yy1051;
	case '.':	goto yy1064;
	case '/':	goto yy730;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1066;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy741;
	case ':':	goto yy1065;
	case 'n':	goto yy470;
	case 'r':	goto yy471;
	case 's':	goto yy464;
	case 't':	goto yy468;
	default:	goto yy1054;
	}
yy1064:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy1088;
	case '1':	goto yy1089;
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1090;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1091;
	default:	goto yy578;
	}
yy1065:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1083;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1084;
	default:	goto yy57;
	}
yy1066:
	yych = *++YYCURSOR;
	switch (yych) {
	case '-':	goto yy785;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1067;
	default:	goto yy61;
	}
yy1067:
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'n':
	case 'o':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy791;
	case '-':	goto yy788;
	case '.':	goto yy792;
	case '/':	goto yy789;
	case '0':	goto yy1069;
	case '1':	goto yy1070;
	case '2':	goto yy1071;
	case '3':	goto yy1072;
	case '4':
	case '5':	goto yy1073;
	case '6':	goto yy1074;
	case '7':
	case '8':
	case '9':	goto yy55;
	case ':':	goto yy807;
	case 'W':	goto yy810;
	default:	goto yy1068;
	}
yy1068:
#line 1180 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("gnunocolon");
		TIMELIB_INIT;
		switch (s->time->have_time) {
			case 0:
				s->time->h = timelib_get_nr((char **) &ptr, 2);
				s->time->i = timelib_get_nr((char **) &ptr, 2);
				s->time->s = 0;
				break;
			case 1:
				s->time->y = timelib_get_nr((char **) &ptr, 4);
				break;
			default:
				TIMELIB_DEINIT;
				add_error(s, "Double time specification");
				return TIMELIB_ERROR;
		}
		s->time->have_time++;
		TIMELIB_DEINIT;
		return TIMELIB_GNU_NOCOLON;
	}
#line 22403 "<stdout>"
yy1069:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy1081;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1082;
	default:	goto yy61;
	}
yy1070:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy1080;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1079;
	default:	goto yy61;
	}
yy1071:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1079;
	default:	goto yy61;
	}
yy1072:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1077;
	case '6':	goto yy1078;
	case '7':
	case '8':
	case '9':	goto yy1075;
	default:	goto yy61;
	}
yy1073:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1075;
	default:	goto yy61;
	}
yy1074:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy1075;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy55;
	default:	goto yy61;
	}
yy1075:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy61;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy55;
	default:	goto yy1076;
	}
yy1076:
#line 1226 "ext/date/lib/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("iso8601nocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_ISO_NOCOLON;
	}
#line 22548 "<stdout>"
yy1077:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy61;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy821;
	default:	goto yy1076;
	}
yy1078:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy61;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':	goto yy821;
	case '7':
	case '8':
	case '9':	goto yy55;
	default:	goto yy1076;
	}
yy1079:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy61;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy821;
	default:	goto yy1076;
	}
yy1080:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy61;
	case '0':	goto yy845;
	case '1':
	case '2':	goto yy846;
	case '3':	goto yy847;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy821;
	default:	goto yy1076;
	}
yy1081:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy61;
	case '0':	goto yy877;
	case '1':
	case '2':	goto yy846;
	case '3':	goto yy847;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy821;
	default:	goto yy1076;
	}
yy1082:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy61;
	case '0':	goto yy845;
	case '1':
	case '2':	goto yy846;
	case '3':	goto yy847;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy821;
	default:	goto yy1076;
	}
yy1083:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy1085;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1084;
	default:	goto yy491;
	}
yy1084:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':
	case ':':	goto yy1085;
	default:	goto yy491;
	}
yy1085:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1086;
	case '6':	goto yy1087;
	case '7':
	case '8':
	case '9':	goto yy496;
	default:	goto yy57;
	}
yy1086:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy497;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy496;
	default:	goto yy491;
	}
yy1087:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy497;
	case '0':	goto yy496;
	default:	goto yy491;
	}
yy1088:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy602;
	case '.':	goto yy1092;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1091;
	case ':':	goto yy1085;
	default:	goto yy491;
	}
yy1089:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy602;
	case '.':	goto yy1092;
	case '0':
	case '1':
	case '2':	goto yy1091;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1084;
	case ':':	goto yy1085;
	default:	goto yy491;
	}
yy1090:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy602;
	case '.':	goto yy1092;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1084;
	case ':':	goto yy1085;
	default:	goto yy491;
	}
yy1091:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy602;
	case '.':	goto yy1092;
	case ':':	goto yy1085;
	default:	goto yy491;
	}
yy1092:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1093;
	case '6':	goto yy1094;
	case '7':
	case '8':
	case '9':	goto yy610;
	default:	goto yy57;
	}
yy1093:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy497;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1095;
	default:	goto yy491;
	}
yy1094:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy497;
	case '0':	goto yy1095;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy611;
	default:	goto yy491;
	}
yy1095:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy497;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy605;
	default:	goto yy491;
	}
yy1096:
	yych = *++YYCURSOR;
	switch (yych) {
	case '\t':	goto yy460;
	case '-':	goto yy1051;
	case '.':	goto yy474;
	case '/':	goto yy472;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1066;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy741;
	case ':':	goto yy483;
	case 'n':	goto yy470;
	case 'r':	goto yy471;
	case 's':	goto yy464;
	case 't':	goto yy468;
	default:	goto yy462;
	}
yy1097:
	yych = *++YYCURSOR;
	switch (yych) {
	case '\t':	goto yy1052;
	case '-':	goto yy1051;
	case '.':	goto yy1064;
	case '/':	goto yy472;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1066;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy741;
	case ':':	goto yy1065;
	case 'n':	goto yy470;
	case 'r':	goto yy471;
	case 's':	goto yy464;
	case 't':	goto yy468;
	default:	goto yy1054;
	}
yy1098:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'E':
	case 'e':	goto yy1099;
	default:	goto yy4;
	}
yy1099:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'V':
	case 'v':	goto yy1100;
	default:	goto yy4;
	}
yy1100:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	case 'I':
	case 'i':	goto yy1101;
	default:	goto yy4;
	}
yy1101:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy145;
	case 'O':
	case 'o':	goto yy1102;
	default:	goto yy4;
	}
yy1102:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case 'U':
	case 'u':	goto yy1103;
	default:	goto yy4;
	}
yy1103:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'S':
	case 's':	goto yy1104;
	default:	goto yy57;
	}
yy1104:
	yych = *++YYCURSOR;
	switch (yych) {
	case '\t':
	case ' ':	goto yy1105;
	default:	goto yy57;
	}
yy1105:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy1106:
	switch (yych) {
	case '\t':
	case ' ':	goto yy1105;
	case 'D':
	case 'd':	goto yy1110;
	case 'F':
	case 'f':	goto yy1111;
	case 'H':
	case 'h':	goto yy1109;
	case 'M':
	case 'm':	goto yy1108;
	case 'S':
	case 's':	goto yy1107;
	case 'T':
	case 't':	goto yy1114;
	case 'W':
	case 'w':	goto yy1113;
	case 'Y':
	case 'y':	goto yy1112;
	default:	goto yy57;
	}
yy1107:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy1179;
	case 'E':
	case 'e':	goto yy1180;
	case 'U':
	case 'u':	goto yy1178;
	default:	goto yy57;
	}
yy1108:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'I':
	case 'i':	goto yy1170;
	case 'O':
	case 'o':	goto yy1169;
	default:	goto yy57;
	}
yy1109:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'O':
	case 'o':	goto yy1167;
	default:	goto yy57;
	}
yy1110:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy1166;
	default:	goto yy57;
	}
yy1111:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'O':
	case 'o':	goto yy1151;
	case 'R':
	case 'r':	goto yy1150;
	default:	goto yy57;
	}
yy1112:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy1147;
	default:	goto yy57;
	}
yy1113:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy1133;
	default:	goto yy57;
	}
yy1114:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':
	case 'h':	goto yy1115;
	case 'U':
	case 'u':	goto yy1116;
	default:	goto yy57;
	}
yy1115:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'U':
	case 'u':	goto yy1128;
	default:	goto yy57;
	}
yy1116:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy1117;
	default:	goto yy57;
	}
yy1117:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy1119;
	case 'S':
	case 's':	goto yy1121;
	default:	goto yy1118;
	}
yy1118:
#line 1610 "ext/date/lib/parse_date.re"
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 23387 "<stdout>"
yy1119:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	switch (yych) {
	case '\t':
	case ' ':	goto yy1119;
	case 'O':
	case 'o':	goto yy1125;
	default:	goto yy57;
	}
yy1121:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'D':
	case 'd':	goto yy1122;
	default:	goto yy57;
	}
yy1122:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy1123;
	default:	goto yy57;
	}
yy1123:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy1124;
	default:	goto yy57;
	}
yy1124:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy1119;
	default:	goto yy1118;
	}
yy1125:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'F':
	case 'f':	goto yy1126;
	default:	goto yy57;
	}
yy1126:
	++YYCURSOR;
#line 1095 "ext/date/lib/parse_date.re"
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("weekdayof");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_SPECIAL_RELATIVE();

		i = timelib_get_relative_text((char **) &ptr, &behavior);
		timelib_eat_spaces((char **) &ptr);
		if (i > 0) { /* first, second... etc */
			s->time->relative.special.type = TIMELIB_SPECIAL_DAY_OF_WEEK_IN_MONTH;
			timelib_set_relative((char **) &ptr, i, 1, s);
		} else { /* last */
			s->time->relative.special.type = TIMELIB_SPECIAL_LAST_DAY_OF_WEEK_IN_MONTH;
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_WEEK_DAY_OF_MONTH;
	}
#line 23458 "<stdout>"
yy1128:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy1119;
	case 'R':
	case 'r':	goto yy1129;
	default:	goto yy1118;
	}
yy1129:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'S':
	case 's':	goto yy1130;
	default:	goto yy57;
	}
yy1130:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'D':
	case 'd':	goto yy1131;
	default:	goto yy57;
	}
yy1131:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy1132;
	default:	goto yy57;
	}
yy1132:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy1124;
	default:	goto yy57;
	}
yy1133:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'D':
	case 'd':	goto yy1135;
	case 'E':
	case 'e':	goto yy1134;
	default:	goto yy57;
	}
yy1134:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'K':
	case 'k':	goto yy1141;
	default:	goto yy57;
	}
yy1135:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy1119;
	case 'N':
	case 'n':	goto yy1136;
	default:	goto yy1118;
	}
yy1136:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy1137;
	default:	goto yy57;
	}
yy1137:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'S':
	case 's':	goto yy1138;
	default:	goto yy57;
	}
yy1138:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'D':
	case 'd':	goto yy1139;
	default:	goto yy57;
	}
yy1139:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy1140;
	default:	goto yy57;
	}
yy1140:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy1124;
	default:	goto yy57;
	}
yy1141:
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'D':
	case 'd':	goto yy1144;
	case 'S':
	case 's':	goto yy1143;
	default:	goto yy1142;
	}
yy1142:
#line 1586 "ext/date/lib/parse_date.re"
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetextweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
			s->time->relative.weekday_behavior = 2;

			/* to handle the format weekday + last/this/next week */
			if (s->time->relative.have_weekday_relative == 0) {
				TIMELIB_HAVE_WEEKDAY_RELATIVE();
				s->time->relative.weekday = 1;
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 23592 "<stdout>"
yy1143:
	yych = *++YYCURSOR;
	goto yy1118;
yy1144:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy1145;
	default:	goto yy57;
	}
yy1145:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy1146;
	default:	goto yy57;
	}
yy1146:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'S':
	case 's':	goto yy1143;
	default:	goto yy1118;
	}
yy1147:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy1148;
	default:	goto yy57;
	}
yy1148:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy1149;
	default:	goto yy57;
	}
yy1149:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'S':
	case 's':	goto yy1143;
	default:	goto yy1118;
	}
yy1150:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'I':
	case 'i':	goto yy1163;
	default:	goto yy57;
	}
yy1151:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy1152;
	default:	goto yy57;
	}
yy1152:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy1153;
	default:	goto yy57;
	}
yy1153:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':
	case 'h':	goto yy1155;
	case 'N':
	case 'n':	goto yy1154;
	default:	goto yy57;
	}
yy1154:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'I':
	case 'i':	goto yy1160;
	default:	goto yy57;
	}
yy1155:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':
	case 'n':	goto yy1156;
	default:	goto yy57;
	}
yy1156:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'I':
	case 'i':	goto yy1157;
	default:	goto yy57;
	}
yy1157:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'G':
	case 'g':	goto yy1158;
	default:	goto yy57;
	}
yy1158:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':
	case 'h':	goto yy1159;
	default:	goto yy57;
	}
yy1159:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy1149;
	default:	goto yy57;
	}
yy1160:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'G':
	case 'g':	goto yy1161;
	default:	goto yy57;
	}
yy1161:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':
	case 'h':	goto yy1162;
	default:	goto yy57;
	}
yy1162:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy1149;
	default:	goto yy57;
	}
yy1163:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy1119;
	case 'D':
	case 'd':	goto yy1164;
	default:	goto yy1118;
	}
yy1164:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy1165;
	default:	goto yy57;
	}
yy1165:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy1124;
	default:	goto yy57;
	}
yy1166:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy1149;
	default:	goto yy57;
	}
yy1167:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'U':
	case 'u':	goto yy1168;
	default:	goto yy57;
	}
yy1168:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy1149;
	default:	goto yy57;
	}
yy1169:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':
	case 'n':	goto yy1174;
	default:	goto yy57;
	}
yy1170:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':
	case 'n':	goto yy1171;
	default:	goto yy57;
	}
yy1171:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'S':
	case 's':	goto yy1143;
	case 'U':
	case 'u':	goto yy1172;
	default:	goto yy1118;
	}
yy1172:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy1173;
	default:	goto yy57;
	}
yy1173:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy1149;
	default:	goto yy57;
	}
yy1174:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy1119;
	case 'D':
	case 'd':	goto yy1175;
	case 'T':
	case 't':	goto yy1176;
	default:	goto yy1118;
	}
yy1175:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy1177;
	default:	goto yy57;
	}
yy1176:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':
	case 'h':	goto yy1149;
	default:	goto yy57;
	}
yy1177:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy1124;
	default:	goto yy57;
	}
yy1178:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':
	case 'n':	goto yy1189;
	default:	goto yy57;
	}
yy1179:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy1184;
	default:	goto yy57;
	}
yy1180:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':
	case 'c':	goto yy1181;
	default:	goto yy57;
	}
yy1181:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'O':
	case 'o':	goto yy1182;
	case 'S':
	case 's':	goto yy1143;
	default:	goto yy1118;
	}
yy1182:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'N':
	case 'n':	goto yy1183;
	default:	goto yy57;
	}
yy1183:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'D':
	case 'd':	goto yy1149;
	default:	goto yy57;
	}
yy1184:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy1119;
	case 'U':
	case 'u':	goto yy1185;
	default:	goto yy1118;
	}
yy1185:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy1186;
	default:	goto yy57;
	}
yy1186:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'D':
	case 'd':	goto yy1187;
	default:	goto yy57;
	}
yy1187:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy1188;
	default:	goto yy57;
	}
yy1188:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy1124;
	default:	goto yy57;
	}
yy1189:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy1119;
	case 'D':
	case 'd':	goto yy1190;
	default:	goto yy1118;
	}
yy1190:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy1191;
	default:	goto yy57;
	}
yy1191:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy1124;
	default:	goto yy57;
	}
yy1192:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy142;
	case 'E':	goto yy1099;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case 'e':	goto yy1193;
	default:	goto yy4;
	}
yy1193:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'V':	goto yy1100;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 'v':	goto yy1194;
	default:	goto yy4;
	}
yy1194:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'I':	goto yy1101;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	case 'i':	goto yy1195;
	default:	goto yy4;
	}
yy1195:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy145;
	case 'O':	goto yy1102;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy153;
	case 'o':	goto yy1196;
	default:	goto yy4;
	}
yy1196:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'U':	goto yy1103;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy154;
	case 'u':	goto yy1197;
	default:	goto yy4;
	}
yy1197:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'S':	goto yy1104;
	case 's':	goto yy1198;
	default:	goto yy155;
	}
yy1198:
	yych = *++YYCURSOR;
	switch (yych) {
	case '\t':
	case ' ':	goto yy1105;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy154;
	default:	goto yy57;
	}
yy1199:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'G':
	case 'g':	goto yy1213;
	default:	goto yy4;
	}
yy1200:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'E':
	case 'e':	goto yy1201;
	default:	goto yy4;
	}
yy1201:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'V':
	case 'v':	goto yy1202;
	default:	goto yy4;
	}
yy1202:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	case 'E':
	case 'e':	goto yy1203;
	default:	goto yy4;
	}
yy1203:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy145;
	case 'N':
	case 'n':	goto yy1204;
	default:	goto yy4;
	}
yy1204:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case 'T':
	case 't':	goto yy1205;
	default:	goto yy4;
	}
yy1205:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':
	case 'h':	goto yy1206;
	default:	goto yy57;
	}
yy1206:
	yych = *++YYCURSOR;
	switch (yych) {
	case '\t':
	case ' ':	goto yy1207;
	default:	goto yy57;
	}
yy1207:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy1208:
	switch (yych) {
	case '\t':
	case ' ':	goto yy1207;
	case 'D':
	case 'd':	goto yy1110;
	case 'F':
	case 'f':	goto yy1111;
	case 'H':
	case 'h':	goto yy1109;
	case 'M':
	case 'm':	goto yy1108;
	case 'S':
	case 's':	goto yy1107;
	case 'T':
	case 't':	goto yy1114;
	case 'W':
	case 'w':	goto yy1209;
	case 'Y':
	case 'y':	goto yy1112;
	default:	goto yy57;
	}
yy1209:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy1210;
	default:	goto yy57;
	}
yy1210:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'D':
	case 'd':	goto yy1135;
	case 'E':
	case 'e':	goto yy1211;
	default:	goto yy57;
	}
yy1211:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'K':
	case 'k':	goto yy1212;
	default:	goto yy57;
	}
yy1212:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'D':
	case 'd':	goto yy1144;
	case 'S':
	case 's':	goto yy1143;
	default:	goto yy57;
	}
yy1213:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'H':
	case 'h':	goto yy1214;
	default:	goto yy4;
	}
yy1214:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	case 'T':
	case 't':	goto yy1215;
	default:	goto yy4;
	}
yy1215:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy1207;
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy145;
	case 'H':
	case 'h':	goto yy1216;
	default:	goto yy4;
	}
yy1216:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy1207;
	case ')':	goto yy140;
	default:	goto yy4;
	}
yy1217:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy142;
	case 'G':	goto yy1213;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case 'g':	goto yy1225;
	default:	goto yy4;
	}
yy1218:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy142;
	case 'E':	goto yy1201;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case 'e':	goto yy1219;
	default:	goto yy4;
	}
yy1219:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'V':	goto yy1202;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 'v':	goto yy1220;
	default:	goto yy4;
	}
yy1220:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'E':	goto yy1203;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	case 'e':	goto yy1221;
	default:	goto yy4;
	}
yy1221:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy145;
	case 'N':	goto yy1204;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy153;
	case 'n':	goto yy1222;
	default:	goto yy4;
	}
yy1222:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'T':	goto yy1205;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy154;
	case 't':	goto yy1223;
	default:	goto yy4;
	}
yy1223:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'H':	goto yy1206;
	case 'h':	goto yy1224;
	default:	goto yy155;
	}
yy1224:
	yych = *++YYCURSOR;
	switch (yych) {
	case '\t':
	case ' ':	goto yy1207;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy154;
	default:	goto yy57;
	}
yy1225:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'H':	goto yy1214;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 'h':	goto yy1226;
	default:	goto yy4;
	}
yy1226:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'T':	goto yy1215;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	case 't':	goto yy1227;
	default:	goto yy4;
	}
yy1227:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy1207;
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy145;
	case 'H':	goto yy1216;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy153;
	case 'h':	goto yy1228;
	default:	goto yy4;
	}
yy1228:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy1207;
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy154;
	default:	goto yy4;
	}
yy1229:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'C':
	case 'c':	goto yy1245;
	case 'P':
	case 'p':	goto yy1247;
	case 'V':
	case 'v':	goto yy1246;
	default:	goto yy4;
	}
yy1230:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'T':
	case 't':	goto yy1240;
	default:	goto yy4;
	}
yy1231:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'y':
	case 'z':	goto yy142;
	case 'X':
	case 'x':	goto yy1237;
	default:	goto yy4;
	}
yy1232:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'N':
	case 'n':	goto yy1233;
	default:	goto yy4;
	}
yy1233:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'D':
	case 'd':	goto yy1234;
	default:	goto yy167;
	}
yy1234:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'a':	goto yy1235;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	default:	goto yy4;
	}
yy1235:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'z':	goto yy145;
	case 'Y':
	case 'y':	goto yy1236;
	default:	goto yy4;
	}
yy1236:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	default:	goto yy167;
	}
yy1237:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'T':
	case 't':	goto yy1238;
	default:	goto yy4;
	}
yy1238:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	case 'H':
	case 'h':	goto yy1239;
	default:	goto yy4;
	}
yy1239:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy1207;
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy145;
	default:	goto yy4;
	}
yy1240:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'U':
	case 'u':	goto yy1241;
	default:	goto yy167;
	}
yy1241:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	case 'R':
	case 'r':	goto yy1242;
	default:	goto yy4;
	}
yy1242:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy145;
	case 'D':
	case 'd':	goto yy1243;
	default:	goto yy4;
	}
yy1243:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'a':	goto yy1244;
	default:	goto yy4;
	}
yy1244:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy173;
	default:	goto yy57;
	}
yy1245:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'O':
	case 'o':	goto yy1256;
	default:	goto yy4;
	}
yy1246:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'E':
	case 'e':	goto yy1253;
	default:	goto yy4;
	}
yy1247:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case '-':	goto yy197;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'T':
	case 't':	goto yy1248;
	default:	goto yy194;
	}
yy1248:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case '-':	goto yy197;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	case 'E':
	case 'e':	goto yy1249;
	default:	goto yy194;
	}
yy1249:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy145;
	case 'M':
	case 'm':	goto yy1250;
	default:	goto yy4;
	}
yy1250:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case 'B':
	case 'b':	goto yy1251;
	default:	goto yy4;
	}
yy1251:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':
	case 'e':	goto yy1252;
	default:	goto yy57;
	}
yy1252:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy206;
	default:	goto yy57;
	}
yy1253:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	case 'N':
	case 'n':	goto yy1254;
	default:	goto yy4;
	}
yy1254:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy145;
	case 'T':
	case 't':	goto yy1255;
	default:	goto yy4;
	}
yy1255:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case 'H':
	case 'h':	goto yy1206;
	default:	goto yy4;
	}
yy1256:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	case 'N':
	case 'n':	goto yy1257;
	default:	goto yy4;
	}
yy1257:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy145;
	case 'D':
	case 'd':	goto yy1216;
	default:	goto yy4;
	}
yy1258:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy142;
	case 'C':	goto yy1245;
	case 'P':	goto yy1247;
	case 'V':	goto yy1246;
	case 'a':
	case 'b':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case 'c':	goto yy1274;
	case 'p':	goto yy1276;
	case 'v':	goto yy1275;
	default:	goto yy4;
	}
yy1259:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy142;
	case 'T':	goto yy1240;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case 't':	goto yy1269;
	default:	goto yy4;
	}
yy1260:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'Y':
	case 'Z':	goto yy142;
	case 'X':	goto yy1237;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'y':
	case 'z':	goto yy147;
	case 'x':	goto yy1266;
	default:	goto yy4;
	}
yy1261:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy142;
	case 'N':	goto yy1233;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case 'n':	goto yy1262;
	default:	goto yy4;
	}
yy1262:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'D':	goto yy1234;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 'd':	goto yy1263;
	default:	goto yy167;
	}
yy1263:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':	goto yy1235;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'a':	goto yy1264;
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	default:	goto yy4;
	}
yy1264:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Z':	goto yy145;
	case 'Y':	goto yy1236;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'z':	goto yy153;
	case 'y':	goto yy1265;
	default:	goto yy4;
	}
yy1265:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy154;
	default:	goto yy167;
	}
yy1266:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'T':	goto yy1238;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 't':	goto yy1267;
	default:	goto yy4;
	}
yy1267:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'H':	goto yy1239;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	case 'h':	goto yy1268;
	default:	goto yy4;
	}
yy1268:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy1207;
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy145;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy153;
	default:	goto yy4;
	}
yy1269:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'U':	goto yy1241;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 'u':	goto yy1270;
	default:	goto yy167;
	}
yy1270:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'R':	goto yy1242;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	case 'r':	goto yy1271;
	default:	goto yy4;
	}
yy1271:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy145;
	case 'D':	goto yy1243;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy153;
	case 'd':	goto yy1272;
	default:	goto yy4;
	}
yy1272:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':	goto yy1244;
	case 'a':	goto yy1273;
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy154;
	default:	goto yy4;
	}
yy1273:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':	goto yy173;
	case 'y':	goto yy186;
	default:	goto yy155;
	}
yy1274:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'O':	goto yy1256;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 'o':	goto yy1285;
	default:	goto yy4;
	}
yy1275:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'E':	goto yy1253;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 'e':	goto yy1282;
	default:	goto yy4;
	}
yy1276:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case '-':	goto yy372;
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'T':	goto yy1248;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 't':	goto yy1277;
	default:	goto yy194;
	}
yy1277:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case '-':	goto yy372;
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'E':	goto yy1249;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	case 'e':	goto yy1278;
	default:	goto yy194;
	}
yy1278:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy145;
	case 'M':	goto yy1250;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy153;
	case 'm':	goto yy1279;
	default:	goto yy4;
	}
yy1279:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'B':	goto yy1251;
	case 'a':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy154;
	case 'b':	goto yy1280;
	default:	goto yy4;
	}
yy1280:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'E':	goto yy1252;
	case 'e':	goto yy1281;
	default:	goto yy155;
	}
yy1281:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':	goto yy206;
	case 'r':	goto yy377;
	default:	goto yy155;
	}
yy1282:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'N':	goto yy1254;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	case 'n':	goto yy1283;
	default:	goto yy4;
	}
yy1283:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy145;
	case 'T':	goto yy1255;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy153;
	case 't':	goto yy1284;
	default:	goto yy4;
	}
yy1284:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'H':	goto yy1206;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy154;
	case 'h':	goto yy1224;
	default:	goto yy4;
	}
yy1285:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'N':	goto yy1257;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	case 'n':	goto yy1286;
	default:	goto yy4;
	}
yy1286:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy145;
	case 'D':	goto yy1216;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy153;
	case 'd':	goto yy1228;
	default:	goto yy4;
	}
yy1287:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'C':
	case 'c':	goto yy1288;
	default:	goto yy4;
	}
yy1288:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'K':
	case 'k':	goto yy1289;
	default:	goto yy4;
	}
yy1289:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':	goto yy1290;
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	default:	goto yy4;
	}
yy1290:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'O':
	case 'o':	goto yy1291;
	default:	goto yy57;
	}
yy1291:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'F':
	case 'f':	goto yy1292;
	default:	goto yy57;
	}
yy1292:
	yych = *++YYCURSOR;
	switch (yych) {
	case ' ':	goto yy1293;
	default:	goto yy57;
	}
yy1293:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':	goto yy1294;
	case '2':	goto yy1296;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1297;
	default:	goto yy57;
	}
yy1294:
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1297;
	default:	goto yy1298;
	}
yy1295:
#line 1072 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("backof | frontof");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();

		if (*ptr == 'b') {
			s->time->h = timelib_get_nr((char **) &ptr, 2);
			s->time->i = 15;
		} else {
			s->time->h = timelib_get_nr((char **) &ptr, 2) - 1;
			s->time->i = 45;
		}
		if (*ptr != '\0' ) {
			timelib_eat_spaces((char **) &ptr);
			s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		}

		TIMELIB_DEINIT;
		return TIMELIB_LF_DAY_OF_MONTH;
	}
#line 28628 "<stdout>"
yy1296:
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':	goto yy1297;
	default:	goto yy1298;
	}
yy1297:
	yyaccept = 28;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
yy1298:
	switch (yych) {
	case '\t':
	case ' ':	goto yy1297;
	case 'A':
	case 'P':
	case 'a':
	case 'p':	goto yy1299;
	default:	goto yy1295;
	}
yy1299:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':	goto yy1300;
	case 'M':
	case 'm':	goto yy1301;
	default:	goto yy57;
	}
yy1300:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'M':
	case 'm':	goto yy1301;
	default:	goto yy57;
	}
yy1301:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\t':
	case ' ':	goto yy1303;
	case '.':	goto yy1302;
	default:	goto yy57;
	}
yy1302:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\t':
	case ' ':	goto yy1303;
	default:	goto yy57;
	}
yy1303:
	yych = *++YYCURSOR;
	goto yy1295;
yy1304:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy142;
	case 'C':	goto yy1288;
	case 'a':
	case 'b':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case 'c':	goto yy1305;
	default:	goto yy4;
	}
yy1305:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'K':	goto yy1289;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 'k':	goto yy1306;
	default:	goto yy4;
	}
yy1306:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':	goto yy1290;
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	default:	goto yy4;
	}
yy1307:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'S':
	case 's':	goto yy1308;
	default:	goto yy4;
	}
yy1308:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'T':
	case 't':	goto yy1309;
	default:	goto yy4;
	}
yy1309:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy1105;
	case ' ':	goto yy1310;
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	default:	goto yy4;
	}
yy1310:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'D':
	case 'd':	goto yy1311;
	default:	goto yy1106;
	}
yy1311:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy1312;
	default:	goto yy57;
	}
yy1312:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy1313;
	default:	goto yy57;
	}
yy1313:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':	goto yy1314;
	case 'S':
	case 's':	goto yy1143;
	default:	goto yy1118;
	}
yy1314:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'O':
	case 'o':	goto yy1315;
	default:	goto yy57;
	}
yy1315:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'F':
	case 'f':	goto yy1316;
	default:	goto yy57;
	}
yy1316:
	yych = *++YYCURSOR;
	goto yy2;
yy1317:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy142;
	case 'S':	goto yy1308;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case 's':	goto yy1318;
	default:	goto yy4;
	}
yy1318:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'T':	goto yy1309;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 't':	goto yy1319;
	default:	goto yy4;
	}
yy1319:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy1105;
	case ' ':	goto yy1310;
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	default:	goto yy4;
	}
yy1320:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'B':
	case 'b':	goto yy1356;
	default:	goto yy4;
	}
yy1321:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'F':
	case 'f':	goto yy1346;
	case 'R':
	case 'r':	goto yy1345;
	default:	goto yy4;
	}
yy1322:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'U':
	case 'u':	goto yy1342;
	default:	goto yy4;
	}
yy1323:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'I':
	case 'i':	goto yy1325;
	case 'O':
	case 'o':	goto yy1324;
	default:	goto yy4;
	}
yy1324:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'N':
	case 'n':	goto yy1328;
	default:	goto yy4;
	}
yy1325:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'D':
	case 'd':	goto yy1326;
	default:	goto yy167;
	}
yy1326:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'a':	goto yy1327;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	default:	goto yy4;
	}
yy1327:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'z':	goto yy145;
	case 'Y':
	case 'y':	goto yy1236;
	default:	goto yy4;
	}
yy1328:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	case 'T':
	case 't':	goto yy1329;
	default:	goto yy4;
	}
yy1329:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':	goto yy1330;
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy145;
	default:	goto yy4;
	}
yy1330:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'O':
	case 'o':	goto yy1331;
	default:	goto yy57;
	}
yy1331:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'F':
	case 'f':	goto yy1332;
	default:	goto yy57;
	}
yy1332:
	yych = *++YYCURSOR;
	switch (yych) {
	case ' ':	goto yy1333;
	default:	goto yy57;
	}
yy1333:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':	goto yy1334;
	case '2':	goto yy1335;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1336;
	default:	goto yy57;
	}
yy1334:
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1336;
	default:	goto yy1337;
	}
yy1335:
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':	goto yy1336;
	default:	goto yy1337;
	}
yy1336:
	yyaccept = 28;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
yy1337:
	switch (yych) {
	case '\t':
	case ' ':	goto yy1336;
	case 'A':
	case 'P':
	case 'a':
	case 'p':	goto yy1338;
	default:	goto yy1295;
	}
yy1338:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':	goto yy1339;
	case 'M':
	case 'm':	goto yy1340;
	default:	goto yy57;
	}
yy1339:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'M':
	case 'm':	goto yy1340;
	default:	goto yy57;
	}
yy1340:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\t':
	case ' ':	goto yy1303;
	case '.':	goto yy1341;
	default:	goto yy57;
	}
yy1341:
	yych = *++YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\t':
	case ' ':	goto yy1303;
	default:	goto yy57;
	}
yy1342:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'R':
	case 'r':	goto yy1343;
	default:	goto yy4;
	}
yy1343:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	case 'T':
	case 't':	goto yy1344;
	default:	goto yy4;
	}
yy1344:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy145;
	case 'H':
	case 'h':	goto yy1216;
	default:	goto yy4;
	}
yy1345:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'S':
	case 's':	goto yy1348;
	default:	goto yy4;
	}
yy1346:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'T':
	case 't':	goto yy1347;
	default:	goto yy4;
	}
yy1347:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	case 'H':
	case 'h':	goto yy1239;
	default:	goto yy4;
	}
yy1348:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	case 'T':
	case 't':	goto yy1349;
	default:	goto yy4;
	}
yy1349:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy1207;
	case ' ':	goto yy1350;
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy145;
	default:	goto yy4;
	}
yy1350:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'D':
	case 'd':	goto yy1351;
	default:	goto yy1208;
	}
yy1351:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy1352;
	default:	goto yy57;
	}
yy1352:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy1353;
	default:	goto yy57;
	}
yy1353:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':	goto yy1354;
	case 'S':
	case 's':	goto yy1143;
	default:	goto yy1118;
	}
yy1354:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'O':
	case 'o':	goto yy1355;
	default:	goto yy57;
	}
yy1355:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'F':
	case 'f':	goto yy1316;
	default:	goto yy57;
	}
yy1356:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case '-':	goto yy197;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'R':
	case 'r':	goto yy1357;
	default:	goto yy194;
	}
yy1357:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	case 'U':
	case 'u':	goto yy1358;
	default:	goto yy4;
	}
yy1358:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'a':	goto yy1359;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy145;
	default:	goto yy4;
	}
yy1359:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case 'R':
	case 'r':	goto yy1360;
	default:	goto yy4;
	}
yy1360:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy206;
	default:	goto yy57;
	}
yy1361:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy142;
	case 'B':	goto yy1356;
	case 'a':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case 'b':	goto yy1379;
	default:	goto yy4;
	}
yy1362:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy142;
	case 'F':	goto yy1346;
	case 'R':	goto yy1345;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case 'f':	goto yy1375;
	case 'r':	goto yy1374;
	default:	goto yy4;
	}
yy1363:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy142;
	case 'U':	goto yy1342;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case 'u':	goto yy1371;
	default:	goto yy4;
	}
yy1364:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy142;
	case 'I':	goto yy1325;
	case 'O':	goto yy1324;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case 'i':	goto yy1366;
	case 'o':	goto yy1365;
	default:	goto yy4;
	}
yy1365:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'N':	goto yy1328;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 'n':	goto yy1369;
	default:	goto yy4;
	}
yy1366:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'D':	goto yy1326;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 'd':	goto yy1367;
	default:	goto yy167;
	}
yy1367:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':	goto yy1327;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'a':	goto yy1368;
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	default:	goto yy4;
	}
yy1368:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Z':	goto yy145;
	case 'Y':	goto yy1236;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'z':	goto yy153;
	case 'y':	goto yy1265;
	default:	goto yy4;
	}
yy1369:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'T':	goto yy1329;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	case 't':	goto yy1370;
	default:	goto yy4;
	}
yy1370:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':	goto yy1330;
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy145;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy153;
	default:	goto yy4;
	}
yy1371:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'R':	goto yy1343;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 'r':	goto yy1372;
	default:	goto yy4;
	}
yy1372:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'T':	goto yy1344;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	case 't':	goto yy1373;
	default:	goto yy4;
	}
yy1373:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy145;
	case 'H':	goto yy1216;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy153;
	case 'h':	goto yy1228;
	default:	goto yy4;
	}
yy1374:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'S':	goto yy1348;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 's':	goto yy1377;
	default:	goto yy4;
	}
yy1375:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'T':	goto yy1347;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 't':	goto yy1376;
	default:	goto yy4;
	}
yy1376:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'H':	goto yy1239;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	case 'h':	goto yy1268;
	default:	goto yy4;
	}
yy1377:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'T':	goto yy1349;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	case 't':	goto yy1378;
	default:	goto yy4;
	}
yy1378:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy1207;
	case ' ':	goto yy1350;
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy145;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy153;
	default:	goto yy4;
	}
yy1379:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case '-':	goto yy372;
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'R':	goto yy1357;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 'r':	goto yy1380;
	default:	goto yy194;
	}
yy1380:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'U':	goto yy1358;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	case 'u':	goto yy1381;
	default:	goto yy4;
	}
yy1381:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':	goto yy1359;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy145;
	case 'a':	goto yy1382;
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy153;
	default:	goto yy4;
	}
yy1382:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'R':	goto yy1360;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy154;
	case 'r':	goto yy1383;
	default:	goto yy4;
	}
yy1383:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':	goto yy206;
	case 'y':	goto yy377;
	default:	goto yy155;
	}
yy1384:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1385;
	default:	goto yy57;
	}
yy1385:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1385;
	default:	goto yy1387;
	}
yy1387:
#line 1030 "ext/date/lib/parse_date.re"
	{
		timelib_ull i;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TZ();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->f = 0.0;
		s->time->relative.s += i;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 32115 "<stdout>"
yy1388:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'N':
	case 'n':	goto yy1429;
	default:	goto yy4;
	}
yy1389:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'I':
	case 'i':	goto yy1421;
	case 'U':
	case 'u':	goto yy1422;
	default:	goto yy4;
	}
yy1390:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'D':
	case 'd':	goto yy1410;
	case 'M':
	case 'm':	goto yy1411;
	default:	goto yy4;
	}
yy1391:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'E':
	case 'e':	goto yy1406;
	default:	goto yy4;
	}
yy1392:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'E':
	case 'e':	goto yy1402;
	default:	goto yy4;
	}
yy1393:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':
	case ':':	goto yy1065;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1396;
	default:	goto yy57;
	}
yy1394:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':
	case ':':	goto yy1065;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':	goto yy1396;
	default:	goto yy57;
	}
yy1395:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':
	case ':':	goto yy1065;
	default:	goto yy57;
	}
yy1396:
	yych = *++YYCURSOR;
	switch (yych) {
	case '.':
	case ':':	goto yy1065;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1397;
	default:	goto yy57;
	}
yy1397:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1398;
	default:	goto yy57;
	}
yy1398:
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy1399;
	case '6':	goto yy1400;
	default:	goto yy1068;
	}
yy1399:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1401;
	default:	goto yy57;
	}
yy1400:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy1401;
	default:	goto yy57;
	}
yy1401:
	yych = *++YYCURSOR;
	goto yy1076;
yy1402:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'L':
	case 'l':	goto yy1403;
	default:	goto yy4;
	}
yy1403:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	case 'F':
	case 'f':	goto yy1404;
	default:	goto yy4;
	}
yy1404:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy145;
	case 'T':
	case 't':	goto yy1405;
	default:	goto yy4;
	}
yy1405:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case 'H':
	case 'h':	goto yy1206;
	default:	goto yy4;
	}
yy1406:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'S':
	case 's':	goto yy1407;
	default:	goto yy167;
	}
yy1407:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	case 'D':
	case 'd':	goto yy1408;
	default:	goto yy4;
	}
yy1408:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'a':	goto yy1409;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy145;
	default:	goto yy4;
	}
yy1409:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'Y':
	case 'y':	goto yy173;
	default:	goto yy4;
	}
yy1410:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'a':	goto yy1418;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	default:	goto yy4;
	}
yy1411:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'O':
	case 'o':	goto yy1412;
	default:	goto yy4;
	}
yy1412:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	case 'R':
	case 'r':	goto yy1413;
	default:	goto yy4;
	}
yy1413:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy145;
	case 'R':
	case 'r':	goto yy1414;
	default:	goto yy4;
	}
yy1414:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case 'O':
	case 'o':	goto yy1415;
	default:	goto yy4;
	}
yy1415:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'W':
	case 'w':	goto yy1416;
	default:	goto yy57;
	}
yy1416:
	++YYCURSOR;
yy1417:
#line 1018 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("tomorrow");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = 1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 33134 "<stdout>"
yy1418:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'z':	goto yy144;
	case 'Y':
	case 'y':	goto yy1419;
	default:	goto yy4;
	}
yy1419:
	++YYCURSOR;
	switch ((yych = *YYCURSOR)) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy145;
	default:	goto yy1420;
	}
yy1420:
#line 1008 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("midnight | today");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 33261 "<stdout>"
yy1421:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'R':
	case 'r':	goto yy1427;
	case 'S':
	case 's':	goto yy1428;
	default:	goto yy4;
	}
yy1422:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'R':
	case 'r':	goto yy1423;
	default:	goto yy167;
	}
yy1423:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	case 'S':
	case 's':	goto yy1424;
	default:	goto yy4;
	}
yy1424:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy145;
	case 'D':
	case 'd':	goto yy1425;
	default:	goto yy4;
	}
yy1425:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'a':	goto yy1426;
	default:	goto yy4;
	}
yy1426:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy173;
	default:	goto yy57;
	}
yy1427:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	case 'D':
	case 'd':	goto yy1239;
	default:	goto yy4;
	}
yy1428:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy1105;
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	default:	goto yy4;
	}
yy1429:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'T':
	case 't':	goto yy1430;
	default:	goto yy4;
	}
yy1430:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	case 'H':
	case 'h':	goto yy1239;
	default:	goto yy4;
	}
yy1431:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy142;
	case 'N':	goto yy1429;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case 'n':	goto yy1461;
	default:	goto yy4;
	}
yy1432:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy142;
	case 'I':	goto yy1421;
	case 'U':	goto yy1422;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case 'i':	goto yy1453;
	case 'u':	goto yy1454;
	default:	goto yy4;
	}
yy1433:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy142;
	case 'D':	goto yy1410;
	case 'M':	goto yy1411;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case 'd':	goto yy1444;
	case 'm':	goto yy1445;
	default:	goto yy4;
	}
yy1434:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy142;
	case 'E':	goto yy1406;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case 'e':	goto yy1440;
	default:	goto yy4;
	}
yy1435:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy142;
	case 'E':	goto yy1402;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case 'e':	goto yy1436;
	default:	goto yy4;
	}
yy1436:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'L':	goto yy1403;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 'l':	goto yy1437;
	default:	goto yy4;
	}
yy1437:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'F':	goto yy1404;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	case 'f':	goto yy1438;
	default:	goto yy4;
	}
yy1438:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy145;
	case 'T':	goto yy1405;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy153;
	case 't':	goto yy1439;
	default:	goto yy4;
	}
yy1439:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'H':	goto yy1206;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy154;
	case 'h':	goto yy1224;
	default:	goto yy4;
	}
yy1440:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'S':	goto yy1407;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 's':	goto yy1441;
	default:	goto yy167;
	}
yy1441:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'D':	goto yy1408;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	case 'd':	goto yy1442;
	default:	goto yy4;
	}
yy1442:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':	goto yy1409;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy145;
	case 'a':	goto yy1443;
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy153;
	default:	goto yy4;
	}
yy1443:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'Y':	goto yy173;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'z':	goto yy154;
	case 'y':	goto yy186;
	default:	goto yy4;
	}
yy1444:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':	goto yy1418;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'a':	goto yy1451;
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	default:	goto yy4;
	}
yy1445:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'O':	goto yy1412;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 'o':	goto yy1446;
	default:	goto yy4;
	}
yy1446:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'R':	goto yy1413;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	case 'r':	goto yy1447;
	default:	goto yy4;
	}
yy1447:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy145;
	case 'R':	goto yy1414;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy153;
	case 'r':	goto yy1448;
	default:	goto yy4;
	}
yy1448:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'O':	goto yy1415;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy154;
	case 'o':	goto yy1449;
	default:	goto yy4;
	}
yy1449:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'W':	goto yy1416;
	case 'w':	goto yy1450;
	default:	goto yy155;
	}
yy1450:
	yyaccept = 29;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy154;
	default:	goto yy1417;
	}
yy1451:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Z':	goto yy144;
	case 'Y':	goto yy1419;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'z':	goto yy152;
	case 'y':	goto yy1452;
	default:	goto yy4;
	}
yy1452:
	yyaccept = 30;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy145;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy153;
	default:	goto yy1420;
	}
yy1453:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'R':	goto yy1427;
	case 'S':	goto yy1428;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 'r':	goto yy1459;
	case 's':	goto yy1460;
	default:	goto yy4;
	}
yy1454:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'R':	goto yy1423;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 'r':	goto yy1455;
	default:	goto yy167;
	}
yy1455:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'S':	goto yy1424;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	case 's':	goto yy1456;
	default:	goto yy4;
	}
yy1456:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy145;
	case 'D':	goto yy1425;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy153;
	case 'd':	goto yy1457;
	default:	goto yy4;
	}
yy1457:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':	goto yy1426;
	case 'a':	goto yy1458;
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy154;
	default:	goto yy4;
	}
yy1458:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':	goto yy173;
	case 'y':	goto yy186;
	default:	goto yy155;
	}
yy1459:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'D':	goto yy1239;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	case 'd':	goto yy1268;
	default:	goto yy4;
	}
yy1460:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy1105;
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	default:	goto yy4;
	}
yy1461:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'T':	goto yy1430;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 't':	goto yy1462;
	default:	goto yy4;
	}
yy1462:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'H':	goto yy1239;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	case 'h':	goto yy1268;
	default:	goto yy4;
	}
yy1463:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'z':	goto yy142;
	case 'R':
	case 'r':	goto yy1475;
	case 'Y':
	case 'y':	goto yy1476;
	default:	goto yy4;
	}
yy1464:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'D':
	case 'd':	goto yy1469;
	default:	goto yy4;
	}
yy1465:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'N':
	case 'n':	goto yy1466;
	default:	goto yy4;
	}
yy1466:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'D':
	case 'd':	goto yy1467;
	default:	goto yy167;
	}
yy1467:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'a':	goto yy1468;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	default:	goto yy4;
	}
yy1468:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'z':	goto yy145;
	case 'Y':
	case 'y':	goto yy1236;
	default:	goto yy4;
	}
yy1469:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'N':
	case 'n':	goto yy1470;
	default:	goto yy4;
	}
yy1470:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	case 'I':
	case 'i':	goto yy1471;
	default:	goto yy4;
	}
yy1471:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy145;
	case 'G':
	case 'g':	goto yy1472;
	default:	goto yy4;
	}
yy1472:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case 'H':
	case 'h':	goto yy1473;
	default:	goto yy4;
	}
yy1473:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':
	case 't':	goto yy1474;
	default:	goto yy57;
	}
yy1474:
	yych = *++YYCURSOR;
	goto yy1420;
yy1475:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case '-':	goto yy197;
	case 'A':
	case 'B':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'C':
	case 'c':	goto yy1477;
	default:	goto yy194;
	}
yy1476:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case '-':	goto yy197;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	default:	goto yy194;
	}
yy1477:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	case 'H':
	case 'h':	goto yy396;
	default:	goto yy4;
	}
yy1478:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Z':	goto yy142;
	case 'R':	goto yy1475;
	case 'Y':	goto yy1476;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'z':	goto yy147;
	case 'r':	goto yy1490;
	case 'y':	goto yy1491;
	default:	goto yy4;
	}
yy1479:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy142;
	case 'D':	goto yy1469;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case 'd':	goto yy1484;
	default:	goto yy4;
	}
yy1480:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy142;
	case 'N':	goto yy1466;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case 'n':	goto yy1481;
	default:	goto yy4;
	}
yy1481:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'D':	goto yy1467;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 'd':	goto yy1482;
	default:	goto yy167;
	}
yy1482:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':	goto yy1468;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'a':	goto yy1483;
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	default:	goto yy4;
	}
yy1483:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Z':	goto yy145;
	case 'Y':	goto yy1236;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'z':	goto yy153;
	case 'y':	goto yy1265;
	default:	goto yy4;
	}
yy1484:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'N':	goto yy1470;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 'n':	goto yy1485;
	default:	goto yy4;
	}
yy1485:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'I':	goto yy1471;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	case 'i':	goto yy1486;
	default:	goto yy4;
	}
yy1486:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy145;
	case 'G':	goto yy1472;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy153;
	case 'g':	goto yy1487;
	default:	goto yy4;
	}
yy1487:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'H':	goto yy1473;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy154;
	case 'h':	goto yy1488;
	default:	goto yy4;
	}
yy1488:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'T':	goto yy1474;
	case 't':	goto yy1489;
	default:	goto yy155;
	}
yy1489:
	yyaccept = 30;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy154;
	default:	goto yy1420;
	}
yy1490:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case '-':	goto yy372;
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'C':	goto yy1477;
	case 'a':
	case 'b':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 'c':	goto yy1492;
	default:	goto yy194;
	}
yy1491:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case '-':	goto yy372;
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	default:	goto yy194;
	}
yy1492:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'H':	goto yy396;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	case 'h':	goto yy407;
	default:	goto yy4;
	}
yy1493:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'O':
	case 'o':	goto yy1501;
	case 'V':
	case 'v':	goto yy1502;
	case 'W':
	case 'w':	goto yy1499;
	default:	goto yy4;
	}
yy1494:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'y':
	case 'z':	goto yy142;
	case 'X':
	case 'x':	goto yy1498;
	default:	goto yy4;
	}
yy1495:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'N':
	case 'n':	goto yy1496;
	default:	goto yy4;
	}
yy1496:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'T':
	case 't':	goto yy1497;
	default:	goto yy4;
	}
yy1497:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	case 'H':
	case 'h':	goto yy1239;
	default:	goto yy4;
	}
yy1498:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'T':
	case 't':	goto yy1428;
	default:	goto yy4;
	}
yy1499:
	++YYCURSOR;
	switch ((yych = *YYCURSOR)) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	default:	goto yy1500;
	}
yy1500:
#line 987 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("now");
		TIMELIB_INIT;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 37503 "<stdout>"
yy1501:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'N':
	case 'n':	goto yy1507;
	default:	goto yy4;
	}
yy1502:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case '-':	goto yy197;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'E':
	case 'e':	goto yy1503;
	default:	goto yy194;
	}
yy1503:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	case 'M':
	case 'm':	goto yy1504;
	default:	goto yy4;
	}
yy1504:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy145;
	case 'B':
	case 'b':	goto yy1505;
	default:	goto yy4;
	}
yy1505:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case 'E':
	case 'e':	goto yy1506;
	default:	goto yy4;
	}
yy1506:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':
	case 'r':	goto yy206;
	default:	goto yy57;
	}
yy1507:
	++YYCURSOR;
	switch ((yych = *YYCURSOR)) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	default:	goto yy1508;
	}
yy1508:
#line 996 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("noon");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();
		s->time->h = 12;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 37837 "<stdout>"
yy1509:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'X':
	case 'Y':
	case 'Z':	goto yy142;
	case 'O':	goto yy1501;
	case 'V':	goto yy1502;
	case 'W':	goto yy1499;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case 'o':	goto yy1516;
	case 'v':	goto yy1517;
	case 'w':	goto yy1515;
	default:	goto yy4;
	}
yy1510:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'Y':
	case 'Z':	goto yy142;
	case 'X':	goto yy1498;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'y':
	case 'z':	goto yy147;
	case 'x':	goto yy1514;
	default:	goto yy4;
	}
yy1511:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy142;
	case 'N':	goto yy1496;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case 'n':	goto yy1512;
	default:	goto yy4;
	}
yy1512:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'T':	goto yy1497;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 't':	goto yy1513;
	default:	goto yy4;
	}
yy1513:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'H':	goto yy1239;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	case 'h':	goto yy1268;
	default:	goto yy4;
	}
yy1514:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'T':	goto yy1428;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 't':	goto yy1460;
	default:	goto yy4;
	}
yy1515:
	yyaccept = 31;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	default:	goto yy1500;
	}
yy1516:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'N':	goto yy1507;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 'n':	goto yy1522;
	default:	goto yy4;
	}
yy1517:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '.':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy196;
	case ')':	goto yy140;
	case '-':	goto yy372;
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'E':	goto yy1503;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 'e':	goto yy1518;
	default:	goto yy194;
	}
yy1518:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'M':	goto yy1504;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	case 'm':	goto yy1519;
	default:	goto yy4;
	}
yy1519:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy145;
	case 'B':	goto yy1505;
	case 'a':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy153;
	case 'b':	goto yy1520;
	default:	goto yy4;
	}
yy1520:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'E':	goto yy1506;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy154;
	case 'e':	goto yy1521;
	default:	goto yy4;
	}
yy1521:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'R':	goto yy206;
	case 'r':	goto yy377;
	default:	goto yy155;
	}
yy1522:
	yyaccept = 32;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	default:	goto yy1508;
	}
yy1523:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'S':
	case 's':	goto yy1524;
	default:	goto yy4;
	}
yy1524:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy143;
	case 'T':
	case 't':	goto yy1525;
	default:	goto yy4;
	}
yy1525:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy144;
	case 'E':
	case 'e':	goto yy1526;
	default:	goto yy4;
	}
yy1526:
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy145;
	case 'R':
	case 'r':	goto yy1527;
	default:	goto yy4;
	}
yy1527:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case 'D':
	case 'd':	goto yy1528;
	default:	goto yy4;
	}
yy1528:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy1529;
	default:	goto yy57;
	}
yy1529:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':
	case 'y':	goto yy1530;
	default:	goto yy57;
	}
yy1530:
	++YYCURSOR;
yy1531:
#line 975 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("yesterday");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = -1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 38908 "<stdout>"
yy1532:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy142;
	case 'S':	goto yy1524;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case 's':	goto yy1533;
	default:	goto yy4;
	}
yy1533:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy143;
	case 'T':	goto yy1525;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy151;
	case 't':	goto yy1534;
	default:	goto yy4;
	}
yy1534:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy144;
	case 'E':	goto yy1526;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy152;
	case 'e':	goto yy1535;
	default:	goto yy4;
	}
yy1535:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':	goto yy145;
	case 'R':	goto yy1527;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy153;
	case 'r':	goto yy1536;
	default:	goto yy4;
	}
yy1536:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy140;
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'D':	goto yy1528;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy154;
	case 'd':	goto yy1537;
	default:	goto yy4;
	}
yy1537:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':	goto yy1529;
	case 'a':	goto yy1538;
	default:	goto yy155;
	}
yy1538:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'Y':	goto yy1530;
	case 'y':	goto yy1539;
	default:	goto yy155;
	}
yy1539:
	yyaccept = 33;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':
	case '/':
	case '_':	goto yy148;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy154;
	default:	goto yy1531;
	}
}
#line 1736 "ext/date/lib/parse_date.re"

}

#define YYMAXFILL 31

timelib_time* timelib_strtotime(char *s, int len, struct timelib_error_container **errors, const timelib_tzdb *tzdb)
{
	Scanner in;
	int t;
	char *e = s + len - 1;

	memset(&in, 0, sizeof(in));
	in.errors = malloc(sizeof(struct timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	if (len > 0) {
		while (isspace(*s) && s < e) {
			s++;
		}
		while (isspace(*e) && e > s) {
			e--;
		}
	}
	if (e - s < 0) {
		in.time = timelib_time_ctor();
		add_error(&in, "Empty string");
		if (errors) {
			*errors = in.errors;
		} else {
			timelib_error_container_dtor(in.errors);
		}
		in.time->y = in.time->d = in.time->m = in.time->h = in.time->i = in.time->s = in.time->f = in.time->dst = in.time->z = TIMELIB_UNSET;
		in.time->is_localtime = in.time->zone_type = 0;
		return in.time;
	}
	e++;

	in.str = malloc((e - s) + YYMAXFILL);
	memset(in.str, 0, (e - s) + YYMAXFILL);
	memcpy(in.str, s, (e - s));
	in.lim = in.str + (e - s) + YYMAXFILL;
	in.cur = in.str;
	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->f = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	do {
		t = scan(&in);
#ifdef DEBUG_PARSER
		printf("%d\n", t);
#endif
	} while(t != EOI);

	/* do funky checking whether the parsed time was valid time */
	if (in.time->have_time && !timelib_valid_time( in.time->h, in.time->i, in.time->s)) {
		add_warning(&in, "The parsed time was invalid");
	}
	/* do funky checking whether the parsed date was valid date */
	if (in.time->have_date && !timelib_valid_date( in.time->y, in.time->m, in.time->d)) {
		add_warning(&in, "The parsed date was invalid");
	}

	free(in.str);
	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

#define TIMELIB_CHECK_NUMBER                                           \
		if (strchr("0123456789", *ptr) == NULL)                        \
		{                                                              \
			add_pbf_error(s, "Unexpected data found.", string, begin); \
		}

void timelib_time_reset_fields(timelib_time *time)
{
	assert(time != NULL);

	time->y = 1970;
	time->m = 1;
	time->d = 1;
	time->h = time->i = time->s = 0;
	time->f = 0.0;
	time->tz_info = NULL;
}

void timelib_time_reset_unset_fields(timelib_time *time)
{
	assert(time != NULL);

	if (time->y == TIMELIB_UNSET ) time->y = 1970;
	if (time->m == TIMELIB_UNSET ) time->m = 1;
	if (time->d == TIMELIB_UNSET ) time->d = 1;
	if (time->h == TIMELIB_UNSET ) time->h = 0;
	if (time->i == TIMELIB_UNSET ) time->i = 0;
	if (time->s == TIMELIB_UNSET ) time->s = 0;
	if (time->f == TIMELIB_UNSET ) time->f = 0.0;
}

timelib_time *timelib_parse_from_format(char *format, char *string, int len, timelib_error_container **errors, const timelib_tzdb *tzdb)
{
	char       *fptr = format;
	char       *ptr = string;
	char       *begin;
	timelib_sll tmp;
	Scanner in;
	Scanner *s = &in;
	int allow_extra = 0;

	memset(&in, 0, sizeof(in));
	in.errors = malloc(sizeof(struct timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->f = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	/* Loop over the format string */
	while (*fptr && *ptr) {
		begin = ptr;
		switch (*fptr) {
			case 'D': /* three letter day */
			case 'l': /* full day */
				if (!timelib_lookup_relunit((char **) &ptr)) {
					add_pbf_error(s, "A textual day could not be found", string, begin);
				}
				break;
			case 'd': /* two digit day, with leading zero */
			case 'j': /* two digit day, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->d = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit day could not be found", string, begin);
				}
				break;
			case 'S': /* day suffix, ignored, nor checked */
				timelib_skip_day_suffix((char **) &ptr);
				break;
			case 'z': /* day of year - resets month (0 based) */
				TIMELIB_CHECK_NUMBER;
				if ((tmp = timelib_get_nr((char **) &ptr, 3)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A three digit day-of-year could not be found", string, begin);
				} else {
					s->time->m = 1;
					s->time->d = tmp + 1;
				}
				break;

			case 'm': /* two digit month, with leading zero */
			case 'n': /* two digit month, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->m = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit month could not be found", string, begin);
				}
				break;
			case 'M': /* three letter month */
			case 'F': /* full month */
				tmp = timelib_lookup_month((char **) &ptr);
				if (!tmp) {
					add_pbf_error(s, "A textual month could not be found", string, begin);
				} else {
					s->time->m = tmp;
				}
				break;
			case 'y': /* two digit year */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->y = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit year could not be found", string, begin);
				}
				TIMELIB_PROCESS_YEAR(s->time->y);
				break;
			case 'Y': /* four digit year */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->y = timelib_get_nr((char **) &ptr, 4)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A four digit year could not be found", string, begin);
				}
				break;
			case 'g': /* two digit hour, with leading zero */
			case 'h': /* two digit hour, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit hour could not be found", string, begin);
				}
				if (s->time->h > 12) {
					add_pbf_error(s, "Hour can not be higher than 12", string, begin);
				}
				break;
			case 'G': /* two digit hour, with leading zero */
			case 'H': /* two digit hour, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit hour could not be found", string, begin);
				}
				break;
			case 'a': /* am/pm/a.m./p.m. */
			case 'A': /* AM/PM/A.M./P.M. */
				if (s->time->h == TIMELIB_UNSET) {
					add_pbf_error(s, "Meridian can only come after an hour has been found", string, begin);
				} else if ((tmp = timelib_meridian_with_check((char **) &ptr, s->time->h)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A meridian could not be found", string, begin);
				} else {
					s->time->h += tmp;
				}
				break;
			case 'i': /* two digit minute, with leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->i = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit minute could not be found", string, begin);
				}
				break;
			case 's': /* two digit second, with leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->s = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit second could not be found", string, begin);
				}
				break;
			case 'u': /* up to six digit millisecond */
				{
					double f;
					char *tptr;

					TIMELIB_CHECK_NUMBER;
					tptr = ptr;
					if ((f = timelib_get_nr((char **) &ptr, 6)) == TIMELIB_UNSET || (ptr - tptr < 1)) {
						add_pbf_error(s, "A six digit millisecond could not be found", string, begin);
					} else {
						s->time->f = (f / pow(10, (ptr - tptr)));
					}
				}
				break;
			case ' ': /* any sort of whitespace (' ' and \t) */
				timelib_eat_spaces((char **) &ptr);
				break;
			case 'U': /* epoch seconds */
				TIMELIB_CHECK_NUMBER;
				TIMELIB_HAVE_RELATIVE();
				tmp = timelib_get_unsigned_nr((char **) &ptr, 24);
				s->time->y = 1970;
				s->time->m = 1;
				s->time->d = 1;
				s->time->h = s->time->i = s->time->s = 0;
				s->time->f = 0.0;
				s->time->relative.s += tmp;
				s->time->is_localtime = 1;
				s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
				s->time->z = 0;
				break;

			case 'e': /* timezone */
			case 'P': /* timezone */
			case 'T': /* timezone */
			case 'O': /* timezone */
				{
					int tz_not_found;
					s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
					if (tz_not_found) {
						add_pbf_error(s, "The timezone could not be found in the database", string, begin);
					}
				}
				break;

			case '#': /* separation symbol */
				if (*ptr == ';' || *ptr == ':' || *ptr == '/' || *ptr == '.' || *ptr == ',' || *ptr == '-' || *ptr == '(' || *ptr == ')') {
					++ptr;
				} else {
					add_pbf_error(s, "The separation symbol ([;:/.,-]) could not be found", string, begin);
				}
				break;

			case ';':
			case ':':
			case '/':
			case '.':
			case ',':
			case '-':
			case '(':
			case ')':
				if (*ptr == *fptr) {
					++ptr;
				} else {
					add_pbf_error(s, "The separation symbol could not be found", string, begin);
				}
				break;

			case '!': /* reset all fields to default */
				timelib_time_reset_fields(s->time);
				break; /* break intentionally not missing */

			case '|': /* reset all fields to default when not set */
				timelib_time_reset_unset_fields(s->time);
				break; /* break intentionally not missing */

			case '?': /* random char */
				++ptr;
				break;

			case '\\': /* escaped char */
				*fptr++;
				if (*ptr == *fptr) {
					++ptr;
				} else {
					add_pbf_error(s, "The escaped character could not be found", string, begin);
				}
				break;

			case '*': /* random chars until a separator or number ([ \t.,:;/-0123456789]) */
				timelib_eat_until_separator((char **) &ptr);
				break;

			case '+': /* allow extra chars in the format */
				allow_extra = 1;
				break;

			default:
				if (*fptr != *ptr) {
					add_pbf_error(s, "The format separator does not match", string, begin);
				}
				ptr++;
		}
		fptr++;
	}
	if (*ptr) {
		if (allow_extra) {
			add_pbf_warning(s, "Trailing data", string, ptr);
		} else {
			add_pbf_error(s, "Trailing data", string, ptr);
		}
	}
	/* ignore trailing +'s */
	while (*fptr == '+') {
		fptr++;
	}
	if (*fptr) {
		/* Trailing | and ! specifiers are valid. */
		while (*fptr) {
			switch (*fptr++) {
				case '!': /* reset all fields to default */
					timelib_time_reset_fields(s->time);
					break;

				case '|': /* reset all fields to default when not set */
					timelib_time_reset_unset_fields(s->time);
					break;

				default:
					add_pbf_error(s, "Data missing", string, ptr);
			}
		}
	}

	/* clean up a bit */
	if (s->time->h != TIMELIB_UNSET || s->time->i != TIMELIB_UNSET || s->time->s != TIMELIB_UNSET) {
		if (s->time->h == TIMELIB_UNSET ) {
			s->time->h = 0;
		}
		if (s->time->i == TIMELIB_UNSET ) {
			s->time->i = 0;
		}
		if (s->time->s == TIMELIB_UNSET ) {
			s->time->s = 0;
		}
	}

	/* do funky checking whether the parsed time was valid time */
	if (s->time->h != TIMELIB_UNSET && s->time->i != TIMELIB_UNSET &&
		s->time->s != TIMELIB_UNSET && 
		!timelib_valid_time( s->time->h, s->time->i, s->time->s)) {
		add_pbf_warning(s, "The parsed time was invalid", string, ptr);
	}
	/* do funky checking whether the parsed date was valid date */
	if (s->time->y != TIMELIB_UNSET && s->time->m != TIMELIB_UNSET &&
		s->time->d != TIMELIB_UNSET && 
		!timelib_valid_date( s->time->y, s->time->m, s->time->d)) {
		add_pbf_warning(s, "The parsed date was invalid", string, ptr);
	}

	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

void timelib_fill_holes(timelib_time *parsed, timelib_time *now, int options)
{
	if (!(options & TIMELIB_OVERRIDE_TIME) && parsed->have_date && !parsed->have_time) {
		parsed->h = 0;
		parsed->i = 0;
		parsed->s = 0;
		parsed->f = 0;
	}
	if (parsed->y == TIMELIB_UNSET) parsed->y = now->y != TIMELIB_UNSET ? now->y : 0;
	if (parsed->d == TIMELIB_UNSET) parsed->d = now->d != TIMELIB_UNSET ? now->d : 0;
	if (parsed->m == TIMELIB_UNSET) parsed->m = now->m != TIMELIB_UNSET ? now->m : 0;
	if (parsed->h == TIMELIB_UNSET) parsed->h = now->h != TIMELIB_UNSET ? now->h : 0;
	if (parsed->i == TIMELIB_UNSET) parsed->i = now->i != TIMELIB_UNSET ? now->i : 0;
	if (parsed->s == TIMELIB_UNSET) parsed->s = now->s != TIMELIB_UNSET ? now->s : 0;
	if (parsed->f == TIMELIB_UNSET) parsed->f = now->f != TIMELIB_UNSET ? now->f : 0;
	if (parsed->z == TIMELIB_UNSET) parsed->z = now->z != TIMELIB_UNSET ? now->z : 0;
	if (parsed->dst == TIMELIB_UNSET) parsed->dst = now->dst != TIMELIB_UNSET ? now->dst : 0;

	if (!parsed->tz_abbr) {
		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
	}
	if (!parsed->tz_info) {
		parsed->tz_info = now->tz_info ? (!(options & TIMELIB_NO_CLONE) ? timelib_tzinfo_clone(now->tz_info) : now->tz_info) : NULL;
	}
	if (parsed->zone_type == 0 && now->zone_type != 0) {
		parsed->zone_type = now->zone_type;
/*		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
*/		parsed->is_localtime = 1;
	}
/*	timelib_dump_date(parsed, 2);
	timelib_dump_date(now, 2);
*/
}

char *timelib_timezone_id_from_abbr(const char *abbr, long gmtoffset, int isdst)
{
	const timelib_tz_lookup_table *tp;

	tp = zone_search(abbr, gmtoffset, isdst);
	if (tp) {
		return (tp->full_tz_name);
	} else {
		return NULL;
	}
}

const timelib_tz_lookup_table *timelib_timezone_abbreviations_list(void)
{
	return timelib_timezone_lookup;
}

#ifdef DEBUG_PARSER_STUB
int main(void)
{
	timelib_time time = timelib_strtotime("May 12");

	printf ("%04d-%02d-%02d %02d:%02d:%02d.%-5d %+04d %1d",
		time.y, time.m, time.d, time.h, time.i, time.s, time.f, time.z, time.dst);
	if (time.have_relative) {
		printf ("%3dY %3dM %3dD / %3dH %3dM %3dS", 
			time.relative.y, time.relative.m, time.relative.d, time.relative.h, time.relative.i, time.relative.s);
	}
	if (time.have_weekday_relative) {
		printf (" / %d", time.relative.weekday);
	}
	if (time.have_weeknr_day) {
		printf(" / %dW%d", time.relative.weeknr_day.weeknr, time.relative.weeknr_day.dayofweek);
	}
	return 0;				
}
#endif

/*
 * vim: syntax=c
 */
