--TEST--
Bug #54089 (token_get_all() does not stop after __halt_compiler)
--SKIPIF--
<?php if (!extension_loaded("tokenizer")) print "skip"; ?>
--FILE--
<?php
$code = "<?php __halt_compiler();\x01?>\x02";
$tokens = token_get_all($code);

var_dump($tokens);

$code = '';
foreach ($tokens as $t)
{
	$code .= isset($t[1]) ? $t[1] : $t;
}
var_dump($code);
?>
--EXPECTF--
--TEST--
Bug #54089 (token_get_all() does not stop after __halt_compiler)
--SKIPIF--
<?php if (!extension_loaded("tokenizer")) print "skip"; ?>
--FILE--
<?php
$code = "<?php __halt_compiler();\x01?>\x02";
$tokens = token_get_all($code);

var_dump($tokens);

$code = '';
foreach ($tokens as $t)
{
	$code .= isset($t[1]) ? $t[1] : $t;
}
var_dump($code);
?>
--EXPECTF--
Warning: Unexpected character in input:  '' (ASCII=1) state=0 in /root/genprog-many-bugs/php-bug-2011-02-27-e65d361fde-1d984a7ffd/php/ext/tokenizer/tests/bug54089.php on line 3
array(7) {
  [0]=>
  array(3) {
    [0]=>
    int(380)
    [1]=>
    string(6) "<?php "
    [2]=>
    int(1)
  }
  [1]=>
  array(3) {
    [0]=>
    int(355)
    [1]=>
    string(15) "__halt_compiler"
    [2]=>
    int(1)
  }
  [2]=>
  string(1) "("
  [3]=>
  string(1) ")"
  [4]=>
  string(1) ";"
  [5]=>
  array(3) {
    [0]=>
    int(382)
    [1]=>
    string(2) "?>"
    [2]=>
    int(1)
  }
  [6]=>
  array(3) {
    [0]=>
    int(313)
    [1]=>
    string(1) ""
    [2]=>
    int(1)
  }
}
string(27) "<?php __halt_compiler();?>"