--TEST--
SPL: RegexIterator::getRegex() basic tests
--CREDITS--
Joshua Thijssen <jthijssen@noxlogic.nl>
--FILE--
<?php

$array = array('cat', 'hat', 'sat');
$iterator = new ArrayIterator($array);

# Simple regex
$regexIterator = new RegexIterator($iterator, '/.at/');
var_dump($regexIterator->getRegex());

# Empty regular expression
$regexIterator = new RegexIterator($iterator, '//');
var_dump($regexIterator->getRegex());

# "Complex" email regular expression
$regexIterator = new RegexIterator($iterator, '|\b[A-Z0-9._%-]+@[A-Z0-9.-]+\.[A-Z]{2,4}\b|');
var_dump($regexIterator->getRegex());



?>
--EXPECT--
Fatal error: Call to undefined method ArrayIterator::getRegex() in /root/mountpoint-genprog/genprog-many-bugs/php-bug-2011-01-06-e7a1d5004e-3571c955b5/php/ext/spl/tests/regexiterator_getregex-detect.php on line 8