--TEST--
Indirect method call with chaining
--FILE--
<?php

class foo {
	public $x = 'testing';

	public function bar() {
		return "foo";
	}
	public function baz() {
		return new self;
	}
	static function xyz() {
	}
}

var_dump((new foo())->bar());               // string(3) "foo"
var_dump((new foo())->baz()->x);            // string(7) "testing"
var_dump((new foo())->baz()->baz()->bar()); // string(3) "foo"
var_dump((new foo())->xyz());               // NULL
(new foo())->www();

?>
--EXPECTF--
--TEST--
Indirect method call with chaining
--FILE--
<?php

class foo {
	public $x = 'testing';

	public function bar() {
		return "foo";
	}
	public function baz() {
		return new self;
	}
	static function xyz() {
	}
}

var_dump((new foo())->bar());               // string(3) "foo"
var_dump((new foo())->baz()->x);            // string(7) "testing"
var_dump((new foo())->baz()->baz()->bar()); // string(3) "foo"
var_dump((new foo())->xyz());               // NULL
(new foo())->www();

?>
--EXPECTF--
Parse error: syntax error, unexpected '->' (T_OBJECT_OPERATOR) in /root/genprog-many-bugs/php-bug-2011-11-05-7888715e73-ff48763f4b/php/Zend/tests/indirect_method_call_002.php on line 16