--TEST--
Bug #34771 (strtotime() fails with 1-12am/pm)
--FILE--
<?php
date_default_timezone_set("UTC");

$tests = array(
	'12am', '1am', '1pm',
	'12a.m.', '1a.m.', '1p.m.',
	'12:00am', '1:00am', '1:00pm',
	'12:00a.m.', '1:00a.m.', '1:00p.m.'
);

foreach ($tests as $test) {
	$t = strtotime("2005-12-22 ". $test);
	printf("%-10s => %s\n", $test, date(DATE_ISO8601, $t));
}

?>
--EXPECT--
12am       => 2005-12-22T00:00:00+0000
1am        => 2005-12-22T01:00:00+0000
1pm        => 2005-12-22T13:00:00+0000
12a.m.     => 2005-12-22T00:00:00+0000
1a.m.      => 2005-12-22T01:00:00+0000
1p.m.      => 2005-12-22T13:00:00+0000
12:00am    => 2005-12-22T00:00:00+0000
1:00am     => 2005-12-22T01:00:00+0000
1:00pm     => 2005-12-22T13:00:00+0000
12:00a.m.  => 2005-12-22T00:00:00+0000
1:00a.m.   => 2005-12-22T01:00:00+0000
1:00p.m.   => 2005-12-22T13:00:00+0000
