<?php

class MyArrayIterator extends ArrayIterator
{
	function rewind()
	{
		echo __METHOD__ . "\n";
		parent::rewind();
	}
}

$it = new MyArrayIterator(array(1,2));

foreach($it as $k=>$v)
{
	echo "$k=>$v\n";
}

class MyAppendIterator2 extends AppendIterator
{
	function __construct()
	{
		echo __METHOD__ . "\n";
	}
}

class MyAppendIterator extends AppendIterator
{
	function __construct()
	{
		parent::__construct();
		echo __METHOD__ . "\n";
	}

	function rewind()
	{
		echo __METHOD__ . "\n";
		parent::rewind();
	}

	function valid()
	{
		echo __METHOD__ . "\n";
		return parent::valid();
	}
	
	function append(Iterator $what)
	{
		echo __METHOD__ . "\n";
		parent::append($what);
	}
	
	function parent__construct()
	{
		parent::__construct();
	}
}

try
{
	$aperr = new MyAppendIterator2;

}
catch(Exception $e)
{
	echo $e->getMessage() . "\n";
}

$ap = new MyAppendIterator;

try
{
	$ap->parent__construct($it);
}
catch(Exception $e)
{
	echo $e->getMessage() . "\n";
}

$ap->append($it);
$ap->append($it);
$ap->append($it);

foreach($ap as $k=>$v)
{
	echo "$k=>$v\n";
}

?>
===DONE===
