/*
 * "streamable kanji code filter and converter"
 * Copyright (c) 1998-2002 HappySize, Inc. All rights reserved.
 *
 * LICENSE NOTICES
 *
 * This file is part of "streamable kanji code filter and converter",
 * which is distributed under the terms of GNU Lesser General Public 
 * License (version 2) as published by the Free Software Foundation.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with "streamable kanji code filter and converter";
 * if not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 *
 * The author of this file: Rui Hirokawa <hirokawa@php.net>
 *
 */

#ifndef UNICODE_TABLE_UHC_H
#define UNICODE_TABLE_UHC_H

/*
 * Unicode table
 */

static const unsigned short uhc1_ucs_table[] = {
0xac02,0xac03,0xac05,0xac06,0xac0b,0xac0c,0xac0d,0xac0e,
0xac0f,0xac18,0xac1e,0xac1f,0xac21,0xac22,0xac23,0xac25,
0xac26,0xac27,0xac28,0xac29,0xac2a,0xac2b,0xac2e,0xac32,
0xac33,0xac34,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xac35,0xac36,0xac37,0xac3a,0xac3b,0xac3d,0xac3e,0xac3f,
0xac41,0xac42,0xac43,0xac44,0xac45,0xac46,0xac47,0xac48,
0xac49,0xac4a,0xac4c,0xac4e,0xac4f,0xac50,0xac51,0xac52,
0xac53,0xac55,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xac56,0xac57,0xac59,0xac5a,0xac5b,0xac5d,0xac5e,0xac5f,
0xac60,0xac61,0xac62,0xac63,0xac64,0xac65,0xac66,0xac67,
0xac68,0xac69,0xac6a,0xac6b,0xac6c,0xac6d,0xac6e,0xac6f,
0xac72,0xac73,0xac75,0xac76,0xac79,0xac7b,0xac7c,0xac7d,
0xac7e,0xac7f,0xac82,0xac87,0xac88,0xac8d,0xac8e,0xac8f,
0xac91,0xac92,0xac93,0xac95,0xac96,0xac97,0xac98,0xac99,
0xac9a,0xac9b,0xac9e,0xaca2,0xaca3,0xaca4,0xaca5,0xaca6,
0xaca7,0xacab,0xacad,0xacae,0xacb1,0xacb2,0xacb3,0xacb4,
0xacb5,0xacb6,0xacb7,0xacba,0xacbe,0xacbf,0xacc0,0xacc2,
0xacc3,0xacc5,0xacc6,0xacc7,0xacc9,0xacca,0xaccb,0xaccd,
0xacce,0xaccf,0xacd0,0xacd1,0xacd2,0xacd3,0xacd4,0xacd6,
0xacd8,0xacd9,0xacda,0xacdb,0xacdc,0xacdd,0xacde,0xacdf,
0xace2,0xace3,0xace5,0xace6,0xace9,0xaceb,0xaced,0xacee,
0xacf2,0xacf4,0xacf7,0xacf8,0xacf9,0xacfa,0xacfb,0xacfe,
0xacff,0xad01,0xad02,0xad03,0xad05,0xad07,0xad08,0xad09,
0xad0a,0xad0b,0xad0e,0xad10,0xad12,0xad13,0xad14,0xad15,
0xad16,0xad17,0xad19,0xad1a,0xad1b,0xad1d,0xad1e,0xad1f,
0xad21,0xad22,0xad23,0xad24,0xad25,0xad26,0xad27,0xad28,
0xad2a,0xad2b,0xad2e,0xad2f,0xad30,0xad31,0xad32,0xad33,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xad36,0xad37,
0xad39,0xad3a,0xad3b,0xad3d,0xad3e,0xad3f,0xad40,0xad41,
0xad42,0xad43,0xad46,0xad48,0xad4a,0xad4b,0xad4c,0xad4d,
0xad4e,0xad4f,0xad51,0xad52,0xad53,0xad55,0xad56,0xad57,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xad59,0xad5a,
0xad5b,0xad5c,0xad5d,0xad5e,0xad5f,0xad60,0xad62,0xad64,
0xad65,0xad66,0xad67,0xad68,0xad69,0xad6a,0xad6b,0xad6e,
0xad6f,0xad71,0xad72,0xad77,0xad78,0xad79,0xad7a,0xad7e,
0xad80,0xad83,0xad84,0xad85,0xad86,0xad87,0xad8a,0xad8b,
0xad8d,0xad8e,0xad8f,0xad91,0xad92,0xad93,0xad94,0xad95,
0xad96,0xad97,0xad98,0xad99,0xad9a,0xad9b,0xad9e,0xad9f,
0xada0,0xada1,0xada2,0xada3,0xada5,0xada6,0xada7,0xada8,
0xada9,0xadaa,0xadab,0xadac,0xadad,0xadae,0xadaf,0xadb0,
0xadb1,0xadb2,0xadb3,0xadb4,0xadb5,0xadb6,0xadb8,0xadb9,
0xadba,0xadbb,0xadbc,0xadbd,0xadbe,0xadbf,0xadc2,0xadc3,
0xadc5,0xadc6,0xadc7,0xadc9,0xadca,0xadcb,0xadcc,0xadcd,
0xadce,0xadcf,0xadd2,0xadd4,0xadd5,0xadd6,0xadd7,0xadd8,
0xadd9,0xadda,0xaddb,0xaddd,0xadde,0xaddf,0xade1,0xade2,
0xade3,0xade5,0xade6,0xade7,0xade8,0xade9,0xadea,0xadeb,
0xadec,0xaded,0xadee,0xadef,0xadf0,0xadf1,0xadf2,0xadf3,
0xadf4,0xadf5,0xadf6,0xadf7,0xadfa,0xadfb,0xadfd,0xadfe,
0xae02,0xae03,0xae04,0xae05,0xae06,0xae07,0xae0a,0xae0c,
0xae0e,0xae0f,0xae10,0xae11,0xae12,0xae13,0xae15,0xae16,
0xae17,0xae18,0xae19,0xae1a,0xae1b,0xae1c,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xae1d,0xae1e,0xae1f,0xae20,
0xae21,0xae22,0xae23,0xae24,0xae25,0xae26,0xae27,0xae28,
0xae29,0xae2a,0xae2b,0xae2c,0xae2d,0xae2e,0xae2f,0xae32,
0xae33,0xae35,0xae36,0xae39,0xae3b,0xae3c,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xae3d,0xae3e,0xae3f,0xae42,
0xae44,0xae47,0xae48,0xae49,0xae4b,0xae4f,0xae51,0xae52,
0xae53,0xae55,0xae57,0xae58,0xae59,0xae5a,0xae5b,0xae5e,
0xae62,0xae63,0xae64,0xae66,0xae67,0xae6a,0xae6b,0xae6d,
0xae6e,0xae6f,0xae71,0xae72,0xae73,0xae74,0xae75,0xae76,
0xae77,0xae7a,0xae7e,0xae7f,0xae80,0xae81,0xae82,0xae83,
0xae86,0xae87,0xae88,0xae89,0xae8a,0xae8b,0xae8d,0xae8e,
0xae8f,0xae90,0xae91,0xae92,0xae93,0xae94,0xae95,0xae96,
0xae97,0xae98,0xae99,0xae9a,0xae9b,0xae9c,0xae9d,0xae9e,
0xae9f,0xaea0,0xaea1,0xaea2,0xaea3,0xaea4,0xaea5,0xaea6,
0xaea7,0xaea8,0xaea9,0xaeaa,0xaeab,0xaeac,0xaead,0xaeae,
0xaeaf,0xaeb0,0xaeb1,0xaeb2,0xaeb3,0xaeb4,0xaeb5,0xaeb6,
0xaeb7,0xaeb8,0xaeb9,0xaeba,0xaebb,0xaebf,0xaec1,0xaec2,
0xaec3,0xaec5,0xaec6,0xaec7,0xaec8,0xaec9,0xaeca,0xaecb,
0xaece,0xaed2,0xaed3,0xaed4,0xaed5,0xaed6,0xaed7,0xaeda,
0xaedb,0xaedd,0xaede,0xaedf,0xaee0,0xaee1,0xaee2,0xaee3,
0xaee4,0xaee5,0xaee6,0xaee7,0xaee9,0xaeea,0xaeec,0xaeee,
0xaeef,0xaef0,0xaef1,0xaef2,0xaef3,0xaef5,0xaef6,0xaef7,
0xaef9,0xaefa,0xaefb,0xaefd,0xaefe,0xaeff,0xaf00,0xaf01,
0xaf02,0xaf03,0xaf04,0xaf05,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xaf06,0xaf09,0xaf0a,0xaf0b,0xaf0c,0xaf0e,
0xaf0f,0xaf11,0xaf12,0xaf13,0xaf14,0xaf15,0xaf16,0xaf17,
0xaf18,0xaf19,0xaf1a,0xaf1b,0xaf1c,0xaf1d,0xaf1e,0xaf1f,
0xaf20,0xaf21,0xaf22,0xaf23,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xaf24,0xaf25,0xaf26,0xaf27,0xaf28,0xaf29,
0xaf2a,0xaf2b,0xaf2e,0xaf2f,0xaf31,0xaf33,0xaf35,0xaf36,
0xaf37,0xaf38,0xaf39,0xaf3a,0xaf3b,0xaf3e,0xaf40,0xaf44,
0xaf45,0xaf46,0xaf47,0xaf4a,0xaf4b,0xaf4c,0xaf4d,0xaf4e,
0xaf4f,0xaf51,0xaf52,0xaf53,0xaf54,0xaf55,0xaf56,0xaf57,
0xaf58,0xaf59,0xaf5a,0xaf5b,0xaf5e,0xaf5f,0xaf60,0xaf61,
0xaf62,0xaf63,0xaf66,0xaf67,0xaf68,0xaf69,0xaf6a,0xaf6b,
0xaf6c,0xaf6d,0xaf6e,0xaf6f,0xaf70,0xaf71,0xaf72,0xaf73,
0xaf74,0xaf75,0xaf76,0xaf77,0xaf78,0xaf7a,0xaf7b,0xaf7c,
0xaf7d,0xaf7e,0xaf7f,0xaf81,0xaf82,0xaf83,0xaf85,0xaf86,
0xaf87,0xaf89,0xaf8a,0xaf8b,0xaf8c,0xaf8d,0xaf8e,0xaf8f,
0xaf92,0xaf93,0xaf94,0xaf96,0xaf97,0xaf98,0xaf99,0xaf9a,
0xaf9b,0xaf9d,0xaf9e,0xaf9f,0xafa0,0xafa1,0xafa2,0xafa3,
0xafa4,0xafa5,0xafa6,0xafa7,0xafa8,0xafa9,0xafaa,0xafab,
0xafac,0xafad,0xafae,0xafaf,0xafb0,0xafb1,0xafb2,0xafb3,
0xafb4,0xafb5,0xafb6,0xafb7,0xafba,0xafbb,0xafbd,0xafbe,
0xafbf,0xafc1,0xafc2,0xafc3,0xafc4,0xafc5,0xafc6,0xafca,
0xafcc,0xafcf,0xafd0,0xafd1,0xafd2,0xafd3,0xafd5,0xafd6,
0xafd7,0xafd8,0xafd9,0xafda,0xafdb,0xafdd,0xafde,0xafdf,
0xafe0,0xafe1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xafe2,0xafe3,0xafe4,0xafe5,0xafe6,0xafe7,0xafea,0xafeb,
0xafec,0xafed,0xafee,0xafef,0xaff2,0xaff3,0xaff5,0xaff6,
0xaff7,0xaff9,0xaffa,0xaffb,0xaffc,0xaffd,0xaffe,0xafff,
0xb002,0xb003,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xb005,0xb006,0xb007,0xb008,0xb009,0xb00a,0xb00b,0xb00d,
0xb00e,0xb00f,0xb011,0xb012,0xb013,0xb015,0xb016,0xb017,
0xb018,0xb019,0xb01a,0xb01b,0xb01e,0xb01f,0xb020,0xb021,
0xb022,0xb023,0xb024,0xb025,0xb026,0xb027,0xb029,0xb02a,
0xb02b,0xb02c,0xb02d,0xb02e,0xb02f,0xb030,0xb031,0xb032,
0xb033,0xb034,0xb035,0xb036,0xb037,0xb038,0xb039,0xb03a,
0xb03b,0xb03c,0xb03d,0xb03e,0xb03f,0xb040,0xb041,0xb042,
0xb043,0xb046,0xb047,0xb049,0xb04b,0xb04d,0xb04f,0xb050,
0xb051,0xb052,0xb056,0xb058,0xb05a,0xb05b,0xb05c,0xb05e,
0xb05f,0xb060,0xb061,0xb062,0xb063,0xb064,0xb065,0xb066,
0xb067,0xb068,0xb069,0xb06a,0xb06b,0xb06c,0xb06d,0xb06e,
0xb06f,0xb070,0xb071,0xb072,0xb073,0xb074,0xb075,0xb076,
0xb077,0xb078,0xb079,0xb07a,0xb07b,0xb07e,0xb07f,0xb081,
0xb082,0xb083,0xb085,0xb086,0xb087,0xb088,0xb089,0xb08a,
0xb08b,0xb08e,0xb090,0xb092,0xb093,0xb094,0xb095,0xb096,
0xb097,0xb09b,0xb09d,0xb09e,0xb0a3,0xb0a4,0xb0a5,0xb0a6,
0xb0a7,0xb0aa,0xb0b0,0xb0b2,0xb0b6,0xb0b7,0xb0b9,0xb0ba,
0xb0bb,0xb0bd,0xb0be,0xb0bf,0xb0c0,0xb0c1,0xb0c2,0xb0c3,
0xb0c6,0xb0ca,0xb0cb,0xb0cc,0xb0cd,0xb0ce,0xb0cf,0xb0d2,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xb0d3,0xb0d5,
0xb0d6,0xb0d7,0xb0d9,0xb0da,0xb0db,0xb0dc,0xb0dd,0xb0de,
0xb0df,0xb0e1,0xb0e2,0xb0e3,0xb0e4,0xb0e6,0xb0e7,0xb0e8,
0xb0e9,0xb0ea,0xb0eb,0xb0ec,0xb0ed,0xb0ee,0xb0ef,0xb0f0,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xb0f1,0xb0f2,
0xb0f3,0xb0f4,0xb0f5,0xb0f6,0xb0f7,0xb0f8,0xb0f9,0xb0fa,
0xb0fb,0xb0fc,0xb0fd,0xb0fe,0xb0ff,0xb100,0xb101,0xb102,
0xb103,0xb104,0xb105,0xb106,0xb107,0xb10a,0xb10d,0xb10e,
0xb10f,0xb111,0xb114,0xb115,0xb116,0xb117,0xb11a,0xb11e,
0xb11f,0xb120,0xb121,0xb122,0xb126,0xb127,0xb129,0xb12a,
0xb12b,0xb12d,0xb12e,0xb12f,0xb130,0xb131,0xb132,0xb133,
0xb136,0xb13a,0xb13b,0xb13c,0xb13d,0xb13e,0xb13f,0xb142,
0xb143,0xb145,0xb146,0xb147,0xb149,0xb14a,0xb14b,0xb14c,
0xb14d,0xb14e,0xb14f,0xb152,0xb153,0xb156,0xb157,0xb159,
0xb15a,0xb15b,0xb15d,0xb15e,0xb15f,0xb161,0xb162,0xb163,
0xb164,0xb165,0xb166,0xb167,0xb168,0xb169,0xb16a,0xb16b,
0xb16c,0xb16d,0xb16e,0xb16f,0xb170,0xb171,0xb172,0xb173,
0xb174,0xb175,0xb176,0xb177,0xb17a,0xb17b,0xb17d,0xb17e,
0xb17f,0xb181,0xb183,0xb184,0xb185,0xb186,0xb187,0xb18a,
0xb18c,0xb18e,0xb18f,0xb190,0xb191,0xb195,0xb196,0xb197,
0xb199,0xb19a,0xb19b,0xb19d,0xb19e,0xb19f,0xb1a0,0xb1a1,
0xb1a2,0xb1a3,0xb1a4,0xb1a5,0xb1a6,0xb1a7,0xb1a9,0xb1aa,
0xb1ab,0xb1ac,0xb1ad,0xb1ae,0xb1af,0xb1b0,0xb1b1,0xb1b2,
0xb1b3,0xb1b4,0xb1b5,0xb1b6,0xb1b7,0xb1b8,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xb1b9,0xb1ba,0xb1bb,0xb1bc,
0xb1bd,0xb1be,0xb1bf,0xb1c0,0xb1c1,0xb1c2,0xb1c3,0xb1c4,
0xb1c5,0xb1c6,0xb1c7,0xb1c8,0xb1c9,0xb1ca,0xb1cb,0xb1cd,
0xb1ce,0xb1cf,0xb1d1,0xb1d2,0xb1d3,0xb1d5,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xb1d6,0xb1d7,0xb1d8,0xb1d9,
0xb1da,0xb1db,0xb1de,0xb1e0,0xb1e1,0xb1e2,0xb1e3,0xb1e4,
0xb1e5,0xb1e6,0xb1e7,0xb1ea,0xb1eb,0xb1ed,0xb1ee,0xb1ef,
0xb1f1,0xb1f2,0xb1f3,0xb1f4,0xb1f5,0xb1f6,0xb1f7,0xb1f8,
0xb1fa,0xb1fc,0xb1fe,0xb1ff,0xb200,0xb201,0xb202,0xb203,
0xb206,0xb207,0xb209,0xb20a,0xb20d,0xb20e,0xb20f,0xb210,
0xb211,0xb212,0xb213,0xb216,0xb218,0xb21a,0xb21b,0xb21c,
0xb21d,0xb21e,0xb21f,0xb221,0xb222,0xb223,0xb224,0xb225,
0xb226,0xb227,0xb228,0xb229,0xb22a,0xb22b,0xb22c,0xb22d,
0xb22e,0xb22f,0xb230,0xb231,0xb232,0xb233,0xb235,0xb236,
0xb237,0xb238,0xb239,0xb23a,0xb23b,0xb23d,0xb23e,0xb23f,
0xb240,0xb241,0xb242,0xb243,0xb244,0xb245,0xb246,0xb247,
0xb248,0xb249,0xb24a,0xb24b,0xb24c,0xb24d,0xb24e,0xb24f,
0xb250,0xb251,0xb252,0xb253,0xb254,0xb255,0xb256,0xb257,
0xb259,0xb25a,0xb25b,0xb25d,0xb25e,0xb25f,0xb261,0xb262,
0xb263,0xb264,0xb265,0xb266,0xb267,0xb26a,0xb26b,0xb26c,
0xb26d,0xb26e,0xb26f,0xb270,0xb271,0xb272,0xb273,0xb276,
0xb277,0xb278,0xb279,0xb27a,0xb27b,0xb27d,0xb27e,0xb27f,
0xb280,0xb281,0xb282,0xb283,0xb286,0xb287,0xb288,0xb28a,
0xb28b,0xb28c,0xb28d,0xb28e,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xb28f,0xb292,0xb293,0xb295,0xb296,0xb297,
0xb29b,0xb29c,0xb29d,0xb29e,0xb29f,0xb2a2,0xb2a4,0xb2a7,
0xb2a8,0xb2a9,0xb2ab,0xb2ad,0xb2ae,0xb2af,0xb2b1,0xb2b2,
0xb2b3,0xb2b5,0xb2b6,0xb2b7,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xb2b8,0xb2b9,0xb2ba,0xb2bb,0xb2bc,0xb2bd,
0xb2be,0xb2bf,0xb2c0,0xb2c1,0xb2c2,0xb2c3,0xb2c4,0xb2c5,
0xb2c6,0xb2c7,0xb2ca,0xb2cb,0xb2cd,0xb2ce,0xb2cf,0xb2d1,
0xb2d3,0xb2d4,0xb2d5,0xb2d6,0xb2d7,0xb2da,0xb2dc,0xb2de,
0xb2df,0xb2e0,0xb2e1,0xb2e3,0xb2e7,0xb2e9,0xb2ea,0xb2f0,
0xb2f1,0xb2f2,0xb2f6,0xb2fc,0xb2fd,0xb2fe,0xb302,0xb303,
0xb305,0xb306,0xb307,0xb309,0xb30a,0xb30b,0xb30c,0xb30d,
0xb30e,0xb30f,0xb312,0xb316,0xb317,0xb318,0xb319,0xb31a,
0xb31b,0xb31d,0xb31e,0xb31f,0xb320,0xb321,0xb322,0xb323,
0xb324,0xb325,0xb326,0xb327,0xb328,0xb329,0xb32a,0xb32b,
0xb32c,0xb32d,0xb32e,0xb32f,0xb330,0xb331,0xb332,0xb333,
0xb334,0xb335,0xb336,0xb337,0xb338,0xb339,0xb33a,0xb33b,
0xb33c,0xb33d,0xb33e,0xb33f,0xb340,0xb341,0xb342,0xb343,
0xb344,0xb345,0xb346,0xb347,0xb348,0xb349,0xb34a,0xb34b,
0xb34c,0xb34d,0xb34e,0xb34f,0xb350,0xb351,0xb352,0xb353,
0xb357,0xb359,0xb35a,0xb35d,0xb360,0xb361,0xb362,0xb363,
0xb366,0xb368,0xb36a,0xb36c,0xb36d,0xb36f,0xb372,0xb373,
0xb375,0xb376,0xb377,0xb379,0xb37a,0xb37b,0xb37c,0xb37d,
0xb37e,0xb37f,0xb382,0xb386,0xb387,0xb388,0xb389,0xb38a,
0xb38b,0xb38d,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xb38e,0xb38f,0xb391,0xb392,0xb393,0xb395,0xb396,0xb397,
0xb398,0xb399,0xb39a,0xb39b,0xb39c,0xb39d,0xb39e,0xb39f,
0xb3a2,0xb3a3,0xb3a4,0xb3a5,0xb3a6,0xb3a7,0xb3a9,0xb3aa,
0xb3ab,0xb3ad,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xb3ae,0xb3af,0xb3b0,0xb3b1,0xb3b2,0xb3b3,0xb3b4,0xb3b5,
0xb3b6,0xb3b7,0xb3b8,0xb3b9,0xb3ba,0xb3bb,0xb3bc,0xb3bd,
0xb3be,0xb3bf,0xb3c0,0xb3c1,0xb3c2,0xb3c3,0xb3c6,0xb3c7,
0xb3c9,0xb3ca,0xb3cd,0xb3cf,0xb3d1,0xb3d2,0xb3d3,0xb3d6,
0xb3d8,0xb3da,0xb3dc,0xb3de,0xb3df,0xb3e1,0xb3e2,0xb3e3,
0xb3e5,0xb3e6,0xb3e7,0xb3e9,0xb3ea,0xb3eb,0xb3ec,0xb3ed,
0xb3ee,0xb3ef,0xb3f0,0xb3f1,0xb3f2,0xb3f3,0xb3f4,0xb3f5,
0xb3f6,0xb3f7,0xb3f8,0xb3f9,0xb3fa,0xb3fb,0xb3fd,0xb3fe,
0xb3ff,0xb400,0xb401,0xb402,0xb403,0xb404,0xb405,0xb406,
0xb407,0xb408,0xb409,0xb40a,0xb40b,0xb40c,0xb40d,0xb40e,
0xb40f,0xb411,0xb412,0xb413,0xb414,0xb415,0xb416,0xb417,
0xb419,0xb41a,0xb41b,0xb41d,0xb41e,0xb41f,0xb421,0xb422,
0xb423,0xb424,0xb425,0xb426,0xb427,0xb42a,0xb42c,0xb42d,
0xb42e,0xb42f,0xb430,0xb431,0xb432,0xb433,0xb435,0xb436,
0xb437,0xb438,0xb439,0xb43a,0xb43b,0xb43c,0xb43d,0xb43e,
0xb43f,0xb440,0xb441,0xb442,0xb443,0xb444,0xb445,0xb446,
0xb447,0xb448,0xb449,0xb44a,0xb44b,0xb44c,0xb44d,0xb44e,
0xb44f,0xb452,0xb453,0xb455,0xb456,0xb457,0xb459,0xb45a,
0xb45b,0xb45c,0xb45d,0xb45e,0xb45f,0xb462,0xb464,0xb466,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xb467,0xb468,
0xb469,0xb46a,0xb46b,0xb46d,0xb46e,0xb46f,0xb470,0xb471,
0xb472,0xb473,0xb474,0xb475,0xb476,0xb477,0xb478,0xb479,
0xb47a,0xb47b,0xb47c,0xb47d,0xb47e,0xb47f,0xb481,0xb482,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xb483,0xb484,
0xb485,0xb486,0xb487,0xb489,0xb48a,0xb48b,0xb48c,0xb48d,
0xb48e,0xb48f,0xb490,0xb491,0xb492,0xb493,0xb494,0xb495,
0xb496,0xb497,0xb498,0xb499,0xb49a,0xb49b,0xb49c,0xb49e,
0xb49f,0xb4a0,0xb4a1,0xb4a2,0xb4a3,0xb4a5,0xb4a6,0xb4a7,
0xb4a9,0xb4aa,0xb4ab,0xb4ad,0xb4ae,0xb4af,0xb4b0,0xb4b1,
0xb4b2,0xb4b3,0xb4b4,0xb4b6,0xb4b8,0xb4ba,0xb4bb,0xb4bc,
0xb4bd,0xb4be,0xb4bf,0xb4c1,0xb4c2,0xb4c3,0xb4c5,0xb4c6,
0xb4c7,0xb4c9,0xb4ca,0xb4cb,0xb4cc,0xb4cd,0xb4ce,0xb4cf,
0xb4d1,0xb4d2,0xb4d3,0xb4d4,0xb4d6,0xb4d7,0xb4d8,0xb4d9,
0xb4da,0xb4db,0xb4de,0xb4df,0xb4e1,0xb4e2,0xb4e5,0xb4e7,
0xb4e8,0xb4e9,0xb4ea,0xb4eb,0xb4ee,0xb4f0,0xb4f2,0xb4f3,
0xb4f4,0xb4f5,0xb4f6,0xb4f7,0xb4f9,0xb4fa,0xb4fb,0xb4fc,
0xb4fd,0xb4fe,0xb4ff,0xb500,0xb501,0xb502,0xb503,0xb504,
0xb505,0xb506,0xb507,0xb508,0xb509,0xb50a,0xb50b,0xb50c,
0xb50d,0xb50e,0xb50f,0xb510,0xb511,0xb512,0xb513,0xb516,
0xb517,0xb519,0xb51a,0xb51d,0xb51e,0xb51f,0xb520,0xb521,
0xb522,0xb523,0xb526,0xb52b,0xb52c,0xb52d,0xb52e,0xb52f,
0xb532,0xb533,0xb535,0xb536,0xb537,0xb539,0xb53a,0xb53b,
0xb53c,0xb53d,0xb53e,0xb53f,0xb542,0xb546,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xb547,0xb548,0xb549,0xb54a,
0xb54e,0xb54f,0xb551,0xb552,0xb553,0xb555,0xb556,0xb557,
0xb558,0xb559,0xb55a,0xb55b,0xb55e,0xb562,0xb563,0xb564,
0xb565,0xb566,0xb567,0xb568,0xb569,0xb56a,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xb56b,0xb56c,0xb56d,0xb56e,
0xb56f,0xb570,0xb571,0xb572,0xb573,0xb574,0xb575,0xb576,
0xb577,0xb578,0xb579,0xb57a,0xb57b,0xb57c,0xb57d,0xb57e,
0xb57f,0xb580,0xb581,0xb582,0xb583,0xb584,0xb585,0xb586,
0xb587,0xb588,0xb589,0xb58a,0xb58b,0xb58c,0xb58d,0xb58e,
0xb58f,0xb590,0xb591,0xb592,0xb593,0xb594,0xb595,0xb596,
0xb597,0xb598,0xb599,0xb59a,0xb59b,0xb59c,0xb59d,0xb59e,
0xb59f,0xb5a2,0xb5a3,0xb5a5,0xb5a6,0xb5a7,0xb5a9,0xb5ac,
0xb5ad,0xb5ae,0xb5af,0xb5b2,0xb5b6,0xb5b7,0xb5b8,0xb5b9,
0xb5ba,0xb5be,0xb5bf,0xb5c1,0xb5c2,0xb5c3,0xb5c5,0xb5c6,
0xb5c7,0xb5c8,0xb5c9,0xb5ca,0xb5cb,0xb5ce,0xb5d2,0xb5d3,
0xb5d4,0xb5d5,0xb5d6,0xb5d7,0xb5d9,0xb5da,0xb5db,0xb5dc,
0xb5dd,0xb5de,0xb5df,0xb5e0,0xb5e1,0xb5e2,0xb5e3,0xb5e4,
0xb5e5,0xb5e6,0xb5e7,0xb5e8,0xb5e9,0xb5ea,0xb5eb,0xb5ed,
0xb5ee,0xb5ef,0xb5f0,0xb5f1,0xb5f2,0xb5f3,0xb5f4,0xb5f5,
0xb5f6,0xb5f7,0xb5f8,0xb5f9,0xb5fa,0xb5fb,0xb5fc,0xb5fd,
0xb5fe,0xb5ff,0xb600,0xb601,0xb602,0xb603,0xb604,0xb605,
0xb606,0xb607,0xb608,0xb609,0xb60a,0xb60b,0xb60c,0xb60d,
0xb60e,0xb60f,0xb612,0xb613,0xb615,0xb616,0xb617,0xb619,
0xb61a,0xb61b,0xb61c,0xb61d,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xb61e,0xb61f,0xb620,0xb621,0xb622,0xb623,
0xb624,0xb626,0xb627,0xb628,0xb629,0xb62a,0xb62b,0xb62d,
0xb62e,0xb62f,0xb630,0xb631,0xb632,0xb633,0xb635,0xb636,
0xb637,0xb638,0xb639,0xb63a,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xb63b,0xb63c,0xb63d,0xb63e,0xb63f,0xb640,
0xb641,0xb642,0xb643,0xb644,0xb645,0xb646,0xb647,0xb649,
0xb64a,0xb64b,0xb64c,0xb64d,0xb64e,0xb64f,0xb650,0xb651,
0xb652,0xb653,0xb654,0xb655,0xb656,0xb657,0xb658,0xb659,
0xb65a,0xb65b,0xb65c,0xb65d,0xb65e,0xb65f,0xb660,0xb661,
0xb662,0xb663,0xb665,0xb666,0xb667,0xb669,0xb66a,0xb66b,
0xb66c,0xb66d,0xb66e,0xb66f,0xb670,0xb671,0xb672,0xb673,
0xb674,0xb675,0xb676,0xb677,0xb678,0xb679,0xb67a,0xb67b,
0xb67c,0xb67d,0xb67e,0xb67f,0xb680,0xb681,0xb682,0xb683,
0xb684,0xb685,0xb686,0xb687,0xb688,0xb689,0xb68a,0xb68b,
0xb68c,0xb68d,0xb68e,0xb68f,0xb690,0xb691,0xb692,0xb693,
0xb694,0xb695,0xb696,0xb697,0xb698,0xb699,0xb69a,0xb69b,
0xb69e,0xb69f,0xb6a1,0xb6a2,0xb6a3,0xb6a5,0xb6a6,0xb6a7,
0xb6a8,0xb6a9,0xb6aa,0xb6ad,0xb6ae,0xb6af,0xb6b0,0xb6b2,
0xb6b3,0xb6b4,0xb6b5,0xb6b6,0xb6b7,0xb6b8,0xb6b9,0xb6ba,
0xb6bb,0xb6bc,0xb6bd,0xb6be,0xb6bf,0xb6c0,0xb6c1,0xb6c2,
0xb6c3,0xb6c4,0xb6c5,0xb6c6,0xb6c7,0xb6c8,0xb6c9,0xb6ca,
0xb6cb,0xb6cc,0xb6cd,0xb6ce,0xb6cf,0xb6d0,0xb6d1,0xb6d2,
0xb6d3,0xb6d5,0xb6d6,0xb6d7,0xb6d8,0xb6d9,0xb6da,0xb6db,
0xb6dc,0xb6dd,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xb6de,0xb6df,0xb6e0,0xb6e1,0xb6e2,0xb6e3,0xb6e4,0xb6e5,
0xb6e6,0xb6e7,0xb6e8,0xb6e9,0xb6ea,0xb6eb,0xb6ec,0xb6ed,
0xb6ee,0xb6ef,0xb6f1,0xb6f2,0xb6f3,0xb6f5,0xb6f6,0xb6f7,
0xb6f9,0xb6fa,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xb6fb,0xb6fc,0xb6fd,0xb6fe,0xb6ff,0xb702,0xb703,0xb704,
0xb706,0xb707,0xb708,0xb709,0xb70a,0xb70b,0xb70c,0xb70d,
0xb70e,0xb70f,0xb710,0xb711,0xb712,0xb713,0xb714,0xb715,
0xb716,0xb717,0xb718,0xb719,0xb71a,0xb71b,0xb71c,0xb71d,
0xb71e,0xb71f,0xb720,0xb721,0xb722,0xb723,0xb724,0xb725,
0xb726,0xb727,0xb72a,0xb72b,0xb72d,0xb72e,0xb731,0xb732,
0xb733,0xb734,0xb735,0xb736,0xb737,0xb73a,0xb73c,0xb73d,
0xb73e,0xb73f,0xb740,0xb741,0xb742,0xb743,0xb745,0xb746,
0xb747,0xb749,0xb74a,0xb74b,0xb74d,0xb74e,0xb74f,0xb750,
0xb751,0xb752,0xb753,0xb756,0xb757,0xb758,0xb759,0xb75a,
0xb75b,0xb75c,0xb75d,0xb75e,0xb75f,0xb761,0xb762,0xb763,
0xb765,0xb766,0xb767,0xb769,0xb76a,0xb76b,0xb76c,0xb76d,
0xb76e,0xb76f,0xb772,0xb774,0xb776,0xb777,0xb778,0xb779,
0xb77a,0xb77b,0xb77e,0xb77f,0xb781,0xb782,0xb783,0xb785,
0xb786,0xb787,0xb788,0xb789,0xb78a,0xb78b,0xb78e,0xb793,
0xb794,0xb795,0xb79a,0xb79b,0xb79d,0xb79e,0xb79f,0xb7a1,
0xb7a2,0xb7a3,0xb7a4,0xb7a5,0xb7a6,0xb7a7,0xb7aa,0xb7ae,
0xb7af,0xb7b0,0xb7b1,0xb7b2,0xb7b3,0xb7b6,0xb7b7,0xb7b9,
0xb7ba,0xb7bb,0xb7bc,0xb7bd,0xb7be,0xb7bf,0xb7c0,0xb7c1,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xb7c2,0xb7c3,
0xb7c4,0xb7c5,0xb7c6,0xb7c8,0xb7ca,0xb7cb,0xb7cc,0xb7cd,
0xb7ce,0xb7cf,0xb7d0,0xb7d1,0xb7d2,0xb7d3,0xb7d4,0xb7d5,
0xb7d6,0xb7d7,0xb7d8,0xb7d9,0xb7da,0xb7db,0xb7dc,0xb7dd,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xb7de,0xb7df,
0xb7e0,0xb7e1,0xb7e2,0xb7e3,0xb7e4,0xb7e5,0xb7e6,0xb7e7,
0xb7e8,0xb7e9,0xb7ea,0xb7eb,0xb7ee,0xb7ef,0xb7f1,0xb7f2,
0xb7f3,0xb7f5,0xb7f6,0xb7f7,0xb7f8,0xb7f9,0xb7fa,0xb7fb,
0xb7fe,0xb802,0xb803,0xb804,0xb805,0xb806,0xb80a,0xb80b,
0xb80d,0xb80e,0xb80f,0xb811,0xb812,0xb813,0xb814,0xb815,
0xb816,0xb817,0xb81a,0xb81c,0xb81e,0xb81f,0xb820,0xb821,
0xb822,0xb823,0xb826,0xb827,0xb829,0xb82a,0xb82b,0xb82d,
0xb82e,0xb82f,0xb830,0xb831,0xb832,0xb833,0xb836,0xb83a,
0xb83b,0xb83c,0xb83d,0xb83e,0xb83f,0xb841,0xb842,0xb843,
0xb845,0xb846,0xb847,0xb848,0xb849,0xb84a,0xb84b,0xb84c,
0xb84d,0xb84e,0xb84f,0xb850,0xb852,0xb854,0xb855,0xb856,
0xb857,0xb858,0xb859,0xb85a,0xb85b,0xb85e,0xb85f,0xb861,
0xb862,0xb863,0xb865,0xb866,0xb867,0xb868,0xb869,0xb86a,
0xb86b,0xb86e,0xb870,0xb872,0xb873,0xb874,0xb875,0xb876,
0xb877,0xb879,0xb87a,0xb87b,0xb87d,0xb87e,0xb87f,0xb880,
0xb881,0xb882,0xb883,0xb884,0xb885,0xb886,0xb887,0xb888,
0xb889,0xb88a,0xb88b,0xb88c,0xb88e,0xb88f,0xb890,0xb891,
0xb892,0xb893,0xb894,0xb895,0xb896,0xb897,0xb898,0xb899,
0xb89a,0xb89b,0xb89c,0xb89d,0xb89e,0xb89f,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xb8a0,0xb8a1,0xb8a2,0xb8a3,
0xb8a4,0xb8a5,0xb8a6,0xb8a7,0xb8a9,0xb8aa,0xb8ab,0xb8ac,
0xb8ad,0xb8ae,0xb8af,0xb8b1,0xb8b2,0xb8b3,0xb8b5,0xb8b6,
0xb8b7,0xb8b9,0xb8ba,0xb8bb,0xb8bc,0xb8bd,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xb8be,0xb8bf,0xb8c2,0xb8c4,
0xb8c6,0xb8c7,0xb8c8,0xb8c9,0xb8ca,0xb8cb,0xb8cd,0xb8ce,
0xb8cf,0xb8d1,0xb8d2,0xb8d3,0xb8d5,0xb8d6,0xb8d7,0xb8d8,
0xb8d9,0xb8da,0xb8db,0xb8dc,0xb8de,0xb8e0,0xb8e2,0xb8e3,
0xb8e4,0xb8e5,0xb8e6,0xb8e7,0xb8ea,0xb8eb,0xb8ed,0xb8ee,
0xb8ef,0xb8f1,0xb8f2,0xb8f3,0xb8f4,0xb8f5,0xb8f6,0xb8f7,
0xb8fa,0xb8fc,0xb8fe,0xb8ff,0xb900,0xb901,0xb902,0xb903,
0xb905,0xb906,0xb907,0xb908,0xb909,0xb90a,0xb90b,0xb90c,
0xb90d,0xb90e,0xb90f,0xb910,0xb911,0xb912,0xb913,0xb914,
0xb915,0xb916,0xb917,0xb919,0xb91a,0xb91b,0xb91c,0xb91d,
0xb91e,0xb91f,0xb921,0xb922,0xb923,0xb924,0xb925,0xb926,
0xb927,0xb928,0xb929,0xb92a,0xb92b,0xb92c,0xb92d,0xb92e,
0xb92f,0xb930,0xb931,0xb932,0xb933,0xb934,0xb935,0xb936,
0xb937,0xb938,0xb939,0xb93a,0xb93b,0xb93e,0xb93f,0xb941,
0xb942,0xb943,0xb945,0xb946,0xb947,0xb948,0xb949,0xb94a,
0xb94b,0xb94d,0xb94e,0xb950,0xb952,0xb953,0xb954,0xb955,
0xb956,0xb957,0xb95a,0xb95b,0xb95d,0xb95e,0xb95f,0xb961,
0xb962,0xb963,0xb964,0xb965,0xb966,0xb967,0xb96a,0xb96c,
0xb96e,0xb96f,0xb970,0xb971,0xb972,0xb973,0xb976,0xb977,
0xb979,0xb97a,0xb97b,0xb97d,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xb97e,0xb97f,0xb980,0xb981,0xb982,0xb983,
0xb986,0xb988,0xb98b,0xb98c,0xb98f,0xb990,0xb991,0xb992,
0xb993,0xb994,0xb995,0xb996,0xb997,0xb998,0xb999,0xb99a,
0xb99b,0xb99c,0xb99d,0xb99e,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xb99f,0xb9a0,0xb9a1,0xb9a2,0xb9a3,0xb9a4,
0xb9a5,0xb9a6,0xb9a7,0xb9a8,0xb9a9,0xb9aa,0xb9ab,0xb9ae,
0xb9af,0xb9b1,0xb9b2,0xb9b3,0xb9b5,0xb9b6,0xb9b7,0xb9b8,
0xb9b9,0xb9ba,0xb9bb,0xb9be,0xb9c0,0xb9c2,0xb9c3,0xb9c4,
0xb9c5,0xb9c6,0xb9c7,0xb9ca,0xb9cb,0xb9cd,0xb9d3,0xb9d4,
0xb9d5,0xb9d6,0xb9d7,0xb9da,0xb9dc,0xb9df,0xb9e0,0xb9e2,
0xb9e6,0xb9e7,0xb9e9,0xb9ea,0xb9eb,0xb9ed,0xb9ee,0xb9ef,
0xb9f0,0xb9f1,0xb9f2,0xb9f3,0xb9f6,0xb9fb,0xb9fc,0xb9fd,
0xb9fe,0xb9ff,0xba02,0xba03,0xba04,0xba05,0xba06,0xba07,
0xba09,0xba0a,0xba0b,0xba0c,0xba0d,0xba0e,0xba0f,0xba10,
0xba11,0xba12,0xba13,0xba14,0xba16,0xba17,0xba18,0xba19,
0xba1a,0xba1b,0xba1c,0xba1d,0xba1e,0xba1f,0xba20,0xba21,
0xba22,0xba23,0xba24,0xba25,0xba26,0xba27,0xba28,0xba29,
0xba2a,0xba2b,0xba2c,0xba2d,0xba2e,0xba2f,0xba30,0xba31,
0xba32,0xba33,0xba34,0xba35,0xba36,0xba37,0xba3a,0xba3b,
0xba3d,0xba3e,0xba3f,0xba41,0xba43,0xba44,0xba45,0xba46,
0xba47,0xba4a,0xba4c,0xba4f,0xba50,0xba51,0xba52,0xba56,
0xba57,0xba59,0xba5a,0xba5b,0xba5d,0xba5e,0xba5f,0xba60,
0xba61,0xba62,0xba63,0xba66,0xba6a,0xba6b,0xba6c,0xba6d,
0xba6e,0xba6f,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xba72,0xba73,0xba75,0xba76,0xba77,0xba79,0xba7a,0xba7b,
0xba7c,0xba7d,0xba7e,0xba7f,0xba80,0xba81,0xba82,0xba86,
0xba88,0xba89,0xba8a,0xba8b,0xba8d,0xba8e,0xba8f,0xba90,
0xba91,0xba92,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xba93,0xba94,0xba95,0xba96,0xba97,0xba98,0xba99,0xba9a,
0xba9b,0xba9c,0xba9d,0xba9e,0xba9f,0xbaa0,0xbaa1,0xbaa2,
0xbaa3,0xbaa4,0xbaa5,0xbaa6,0xbaa7,0xbaaa,0xbaad,0xbaae,
0xbaaf,0xbab1,0xbab3,0xbab4,0xbab5,0xbab6,0xbab7,0xbaba,
0xbabc,0xbabe,0xbabf,0xbac0,0xbac1,0xbac2,0xbac3,0xbac5,
0xbac6,0xbac7,0xbac9,0xbaca,0xbacb,0xbacc,0xbacd,0xbace,
0xbacf,0xbad0,0xbad1,0xbad2,0xbad3,0xbad4,0xbad5,0xbad6,
0xbad7,0xbada,0xbadb,0xbadc,0xbadd,0xbade,0xbadf,0xbae0,
0xbae1,0xbae2,0xbae3,0xbae4,0xbae5,0xbae6,0xbae7,0xbae8,
0xbae9,0xbaea,0xbaeb,0xbaec,0xbaed,0xbaee,0xbaef,0xbaf0,
0xbaf1,0xbaf2,0xbaf3,0xbaf4,0xbaf5,0xbaf6,0xbaf7,0xbaf8,
0xbaf9,0xbafa,0xbafb,0xbafd,0xbafe,0xbaff,0xbb01,0xbb02,
0xbb03,0xbb05,0xbb06,0xbb07,0xbb08,0xbb09,0xbb0a,0xbb0b,
0xbb0c,0xbb0e,0xbb10,0xbb12,0xbb13,0xbb14,0xbb15,0xbb16,
0xbb17,0xbb19,0xbb1a,0xbb1b,0xbb1d,0xbb1e,0xbb1f,0xbb21,
0xbb22,0xbb23,0xbb24,0xbb25,0xbb26,0xbb27,0xbb28,0xbb2a,
0xbb2c,0xbb2d,0xbb2e,0xbb2f,0xbb30,0xbb31,0xbb32,0xbb33,
0xbb37,0xbb39,0xbb3a,0xbb3f,0xbb40,0xbb41,0xbb42,0xbb43,
0xbb46,0xbb48,0xbb4a,0xbb4b,0xbb4c,0xbb4e,0xbb51,0xbb52,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xbb53,0xbb55,
0xbb56,0xbb57,0xbb59,0xbb5a,0xbb5b,0xbb5c,0xbb5d,0xbb5e,
0xbb5f,0xbb60,0xbb62,0xbb64,0xbb65,0xbb66,0xbb67,0xbb68,
0xbb69,0xbb6a,0xbb6b,0xbb6d,0xbb6e,0xbb6f,0xbb70,0xbb71,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xbb72,0xbb73,
0xbb74,0xbb75,0xbb76,0xbb77,0xbb78,0xbb79,0xbb7a,0xbb7b,
0xbb7c,0xbb7d,0xbb7e,0xbb7f,0xbb80,0xbb81,0xbb82,0xbb83,
0xbb84,0xbb85,0xbb86,0xbb87,0xbb89,0xbb8a,0xbb8b,0xbb8d,
0xbb8e,0xbb8f,0xbb91,0xbb92,0xbb93,0xbb94,0xbb95,0xbb96,
0xbb97,0xbb98,0xbb99,0xbb9a,0xbb9b,0xbb9c,0xbb9d,0xbb9e,
0xbb9f,0xbba0,0xbba1,0xbba2,0xbba3,0xbba5,0xbba6,0xbba7,
0xbba9,0xbbaa,0xbbab,0xbbad,0xbbae,0xbbaf,0xbbb0,0xbbb1,
0xbbb2,0xbbb3,0xbbb5,0xbbb6,0xbbb8,0xbbb9,0xbbba,0xbbbb,
0xbbbc,0xbbbd,0xbbbe,0xbbbf,0xbbc1,0xbbc2,0xbbc3,0xbbc5,
0xbbc6,0xbbc7,0xbbc9,0xbbca,0xbbcb,0xbbcc,0xbbcd,0xbbce,
0xbbcf,0xbbd1,0xbbd2,0xbbd4,0xbbd5,0xbbd6,0xbbd7,0xbbd8,
0xbbd9,0xbbda,0xbbdb,0xbbdc,0xbbdd,0xbbde,0xbbdf,0xbbe0,
0xbbe1,0xbbe2,0xbbe3,0xbbe4,0xbbe5,0xbbe6,0xbbe7,0xbbe8,
0xbbe9,0xbbea,0xbbeb,0xbbec,0xbbed,0xbbee,0xbbef,0xbbf0,
0xbbf1,0xbbf2,0xbbf3,0xbbf4,0xbbf5,0xbbf6,0xbbf7,0xbbfa,
0xbbfb,0xbbfd,0xbbfe,0xbc01,0xbc03,0xbc04,0xbc05,0xbc06,
0xbc07,0xbc0a,0xbc0e,0xbc10,0xbc12,0xbc13,0xbc19,0xbc1a,
0xbc20,0xbc21,0xbc22,0xbc23,0xbc26,0xbc28,0xbc2a,0xbc2b,
0xbc2c,0xbc2e,0xbc2f,0xbc32,0xbc33,0xbc35,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xbc36,0xbc37,0xbc39,0xbc3a,
0xbc3b,0xbc3c,0xbc3d,0xbc3e,0xbc3f,0xbc42,0xbc46,0xbc47,
0xbc48,0xbc4a,0xbc4b,0xbc4e,0xbc4f,0xbc51,0xbc52,0xbc53,
0xbc54,0xbc55,0xbc56,0xbc57,0xbc58,0xbc59,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xbc5a,0xbc5b,0xbc5c,0xbc5e,
0xbc5f,0xbc60,0xbc61,0xbc62,0xbc63,0xbc64,0xbc65,0xbc66,
0xbc67,0xbc68,0xbc69,0xbc6a,0xbc6b,0xbc6c,0xbc6d,0xbc6e,
0xbc6f,0xbc70,0xbc71,0xbc72,0xbc73,0xbc74,0xbc75,0xbc76,
0xbc77,0xbc78,0xbc79,0xbc7a,0xbc7b,0xbc7c,0xbc7d,0xbc7e,
0xbc7f,0xbc80,0xbc81,0xbc82,0xbc83,0xbc86,0xbc87,0xbc89,
0xbc8a,0xbc8d,0xbc8f,0xbc90,0xbc91,0xbc92,0xbc93,0xbc96,
0xbc98,0xbc9b,0xbc9c,0xbc9d,0xbc9e,0xbc9f,0xbca2,0xbca3,
0xbca5,0xbca6,0xbca9,0xbcaa,0xbcab,0xbcac,0xbcad,0xbcae,
0xbcaf,0xbcb2,0xbcb6,0xbcb7,0xbcb8,0xbcb9,0xbcba,0xbcbb,
0xbcbe,0xbcbf,0xbcc1,0xbcc2,0xbcc3,0xbcc5,0xbcc6,0xbcc7,
0xbcc8,0xbcc9,0xbcca,0xbccb,0xbccc,0xbcce,0xbcd2,0xbcd3,
0xbcd4,0xbcd6,0xbcd7,0xbcd9,0xbcda,0xbcdb,0xbcdd,0xbcde,
0xbcdf,0xbce0,0xbce1,0xbce2,0xbce3,0xbce4,0xbce5,0xbce6,
0xbce7,0xbce8,0xbce9,0xbcea,0xbceb,0xbcec,0xbced,0xbcee,
0xbcef,0xbcf0,0xbcf1,0xbcf2,0xbcf3,0xbcf7,0xbcf9,0xbcfa,
0xbcfb,0xbcfd,0xbcfe,0xbcff,0xbd00,0xbd01,0xbd02,0xbd03,
0xbd06,0xbd08,0xbd0a,0xbd0b,0xbd0c,0xbd0d,0xbd0e,0xbd0f,
0xbd11,0xbd12,0xbd13,0xbd15,0xbd16,0xbd17,0xbd18,0xbd19,
0xbd1a,0xbd1b,0xbd1c,0xbd1d,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xbd1e,0xbd1f,0xbd20,0xbd21,0xbd22,0xbd23,
0xbd25,0xbd26,0xbd27,0xbd28,0xbd29,0xbd2a,0xbd2b,0xbd2d,
0xbd2e,0xbd2f,0xbd30,0xbd31,0xbd32,0xbd33,0xbd34,0xbd35,
0xbd36,0xbd37,0xbd38,0xbd39,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xbd3a,0xbd3b,0xbd3c,0xbd3d,0xbd3e,0xbd3f,
0xbd41,0xbd42,0xbd43,0xbd44,0xbd45,0xbd46,0xbd47,0xbd4a,
0xbd4b,0xbd4d,0xbd4e,0xbd4f,0xbd51,0xbd52,0xbd53,0xbd54,
0xbd55,0xbd56,0xbd57,0xbd5a,0xbd5b,0xbd5c,0xbd5d,0xbd5e,
0xbd5f,0xbd60,0xbd61,0xbd62,0xbd63,0xbd65,0xbd66,0xbd67,
0xbd69,0xbd6a,0xbd6b,0xbd6c,0xbd6d,0xbd6e,0xbd6f,0xbd70,
0xbd71,0xbd72,0xbd73,0xbd74,0xbd75,0xbd76,0xbd77,0xbd78,
0xbd79,0xbd7a,0xbd7b,0xbd7c,0xbd7d,0xbd7e,0xbd7f,0xbd82,
0xbd83,0xbd85,0xbd86,0xbd8b,0xbd8c,0xbd8d,0xbd8e,0xbd8f,
0xbd92,0xbd94,0xbd96,0xbd97,0xbd98,0xbd9b,0xbd9d,0xbd9e,
0xbd9f,0xbda0,0xbda1,0xbda2,0xbda3,0xbda5,0xbda6,0xbda7,
0xbda8,0xbda9,0xbdaa,0xbdab,0xbdac,0xbdad,0xbdae,0xbdaf,
0xbdb1,0xbdb2,0xbdb3,0xbdb4,0xbdb5,0xbdb6,0xbdb7,0xbdb9,
0xbdba,0xbdbb,0xbdbc,0xbdbd,0xbdbe,0xbdbf,0xbdc0,0xbdc1,
0xbdc2,0xbdc3,0xbdc4,0xbdc5,0xbdc6,0xbdc7,0xbdc8,0xbdc9,
0xbdca,0xbdcb,0xbdcc,0xbdcd,0xbdce,0xbdcf,0xbdd0,0xbdd1,
0xbdd2,0xbdd3,0xbdd6,0xbdd7,0xbdd9,0xbdda,0xbddb,0xbddd,
0xbdde,0xbddf,0xbde0,0xbde1,0xbde2,0xbde3,0xbde4,0xbde5,
0xbde6,0xbde7,0xbde8,0xbdea,0xbdeb,0xbdec,0xbded,0xbdee,
0xbdef,0xbdf1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xbdf2,0xbdf3,0xbdf5,0xbdf6,0xbdf7,0xbdf9,0xbdfa,0xbdfb,
0xbdfc,0xbdfd,0xbdfe,0xbdff,0xbe01,0xbe02,0xbe04,0xbe06,
0xbe07,0xbe08,0xbe09,0xbe0a,0xbe0b,0xbe0e,0xbe0f,0xbe11,
0xbe12,0xbe13,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xbe15,0xbe16,0xbe17,0xbe18,0xbe19,0xbe1a,0xbe1b,0xbe1e,
0xbe20,0xbe21,0xbe22,0xbe23,0xbe24,0xbe25,0xbe26,0xbe27,
0xbe28,0xbe29,0xbe2a,0xbe2b,0xbe2c,0xbe2d,0xbe2e,0xbe2f,
0xbe30,0xbe31,0xbe32,0xbe33,0xbe34,0xbe35,0xbe36,0xbe37,
0xbe38,0xbe39,0xbe3a,0xbe3b,0xbe3c,0xbe3d,0xbe3e,0xbe3f,
0xbe40,0xbe41,0xbe42,0xbe43,0xbe46,0xbe47,0xbe49,0xbe4a,
0xbe4b,0xbe4d,0xbe4f,0xbe50,0xbe51,0xbe52,0xbe53,0xbe56,
0xbe58,0xbe5c,0xbe5d,0xbe5e,0xbe5f,0xbe62,0xbe63,0xbe65,
0xbe66,0xbe67,0xbe69,0xbe6b,0xbe6c,0xbe6d,0xbe6e,0xbe6f,
0xbe72,0xbe76,0xbe77,0xbe78,0xbe79,0xbe7a,0xbe7e,0xbe7f,
0xbe81,0xbe82,0xbe83,0xbe85,0xbe86,0xbe87,0xbe88,0xbe89,
0xbe8a,0xbe8b,0xbe8e,0xbe92,0xbe93,0xbe94,0xbe95,0xbe96,
0xbe97,0xbe9a,0xbe9b,0xbe9c,0xbe9d,0xbe9e,0xbe9f,0xbea0,
0xbea1,0xbea2,0xbea3,0xbea4,0xbea5,0xbea6,0xbea7,0xbea9,
0xbeaa,0xbeab,0xbeac,0xbead,0xbeae,0xbeaf,0xbeb0,0xbeb1,
0xbeb2,0xbeb3,0xbeb4,0xbeb5,0xbeb6,0xbeb7,0xbeb8,0xbeb9,
0xbeba,0xbebb,0xbebc,0xbebd,0xbebe,0xbebf,0xbec0,0xbec1,
0xbec2,0xbec3,0xbec4,0xbec5,0xbec6,0xbec7,0xbec8,0xbec9,
0xbeca,0xbecb,0xbecc,0xbecd,0xbece,0xbecf,0xbed2,0xbed3,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xbed5,0xbed6,
0xbed9,0xbeda,0xbedb,0xbedc,0xbedd,0xbede,0xbedf,0xbee1,
0xbee2,0xbee6,0xbee7,0xbee8,0xbee9,0xbeea,0xbeeb,0xbeed,
0xbeee,0xbeef,0xbef0,0xbef1,0xbef2,0xbef3,0xbef4,0xbef5,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xbef6,0xbef7,
0xbef8,0xbef9,0xbefa,0xbefb,0xbefc,0xbefd,0xbefe,0xbeff,
0xbf00,0xbf02,0xbf03,0xbf04,0xbf05,0xbf06,0xbf07,0xbf0a,
0xbf0b,0xbf0c,0xbf0d,0xbf0e,0xbf0f,0xbf10,0xbf11,0xbf12,
0xbf13,0xbf14,0xbf15,0xbf16,0xbf17,0xbf1a,0xbf1e,0xbf1f,
0xbf20,0xbf21,0xbf22,0xbf23,0xbf24,0xbf25,0xbf26,0xbf27,
0xbf28,0xbf29,0xbf2a,0xbf2b,0xbf2c,0xbf2d,0xbf2e,0xbf2f,
0xbf30,0xbf31,0xbf32,0xbf33,0xbf34,0xbf35,0xbf36,0xbf37,
0xbf38,0xbf39,0xbf3a,0xbf3b,0xbf3c,0xbf3d,0xbf3e,0xbf3f,
0xbf42,0xbf43,0xbf45,0xbf46,0xbf47,0xbf49,0xbf4a,0xbf4b,
0xbf4c,0xbf4d,0xbf4e,0xbf4f,0xbf52,0xbf53,0xbf54,0xbf56,
0xbf57,0xbf58,0xbf59,0xbf5a,0xbf5b,0xbf5c,0xbf5d,0xbf5e,
0xbf5f,0xbf60,0xbf61,0xbf62,0xbf63,0xbf64,0xbf65,0xbf66,
0xbf67,0xbf68,0xbf69,0xbf6a,0xbf6b,0xbf6c,0xbf6d,0xbf6e,
0xbf6f,0xbf70,0xbf71,0xbf72,0xbf73,0xbf74,0xbf75,0xbf76,
0xbf77,0xbf78,0xbf79,0xbf7a,0xbf7b,0xbf7c,0xbf7d,0xbf7e,
0xbf7f,0xbf80,0xbf81,0xbf82,0xbf83,0xbf84,0xbf85,0xbf86,
0xbf87,0xbf88,0xbf89,0xbf8a,0xbf8b,0xbf8c,0xbf8d,0xbf8e,
0xbf8f,0xbf90,0xbf91,0xbf92,0xbf93,0xbf95,0xbf96,0xbf97,
0xbf98,0xbf99,0xbf9a,0xbf9b,0xbf9c,0xbf9d,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xbf9e,0xbf9f,0xbfa0,0xbfa1,
0xbfa2,0xbfa3,0xbfa4,0xbfa5,0xbfa6,0xbfa7,0xbfa8,0xbfa9,
0xbfaa,0xbfab,0xbfac,0xbfad,0xbfae,0xbfaf,0xbfb1,0xbfb2,
0xbfb3,0xbfb4,0xbfb5,0xbfb6,0xbfb7,0xbfb8,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xbfb9,0xbfba,0xbfbb,0xbfbc,
0xbfbd,0xbfbe,0xbfbf,0xbfc0,0xbfc1,0xbfc2,0xbfc3,0xbfc4,
0xbfc6,0xbfc7,0xbfc8,0xbfc9,0xbfca,0xbfcb,0xbfce,0xbfcf,
0xbfd1,0xbfd2,0xbfd3,0xbfd5,0xbfd6,0xbfd7,0xbfd8,0xbfd9,
0xbfda,0xbfdb,0xbfdd,0xbfde,0xbfe0,0xbfe2,0xbfe3,0xbfe4,
0xbfe5,0xbfe6,0xbfe7,0xbfe8,0xbfe9,0xbfea,0xbfeb,0xbfec,
0xbfed,0xbfee,0xbfef,0xbff0,0xbff1,0xbff2,0xbff3,0xbff4,
0xbff5,0xbff6,0xbff7,0xbff8,0xbff9,0xbffa,0xbffb,0xbffc,
0xbffd,0xbffe,0xbfff,0xc000,0xc001,0xc002,0xc003,0xc004,
0xc005,0xc006,0xc007,0xc008,0xc009,0xc00a,0xc00b,0xc00c,
0xc00d,0xc00e,0xc00f,0xc010,0xc011,0xc012,0xc013,0xc014,
0xc015,0xc016,0xc017,0xc018,0xc019,0xc01a,0xc01b,0xc01c,
0xc01d,0xc01e,0xc01f,0xc020,0xc021,0xc022,0xc023,0xc024,
0xc025,0xc026,0xc027,0xc028,0xc029,0xc02a,0xc02b,0xc02c,
0xc02d,0xc02e,0xc02f,0xc030,0xc031,0xc032,0xc033,0xc034,
0xc035,0xc036,0xc037,0xc038,0xc039,0xc03a,0xc03b,0xc03d,
0xc03e,0xc03f,0xc040,0xc041,0xc042,0xc043,0xc044,0xc045,
0xc046,0xc047,0xc048,0xc049,0xc04a,0xc04b,0xc04c,0xc04d,
0xc04e,0xc04f,0xc050,0xc052,0xc053,0xc054,0xc055,0xc056,
0xc057,0xc059,0xc05a,0xc05b,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xc05d,0xc05e,0xc05f,0xc061,0xc062,0xc063,
0xc064,0xc065,0xc066,0xc067,0xc06a,0xc06b,0xc06c,0xc06d,
0xc06e,0xc06f,0xc070,0xc071,0xc072,0xc073,0xc074,0xc075,
0xc076,0xc077,0xc078,0xc079,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xc07a,0xc07b,0xc07c,0xc07d,0xc07e,0xc07f,
0xc080,0xc081,0xc082,0xc083,0xc084,0xc085,0xc086,0xc087,
0xc088,0xc089,0xc08a,0xc08b,0xc08c,0xc08d,0xc08e,0xc08f,
0xc092,0xc093,0xc095,0xc096,0xc097,0xc099,0xc09a,0xc09b,
0xc09c,0xc09d,0xc09e,0xc09f,0xc0a2,0xc0a4,0xc0a6,0xc0a7,
0xc0a8,0xc0a9,0xc0aa,0xc0ab,0xc0ae,0xc0b1,0xc0b2,0xc0b7,
0xc0b8,0xc0b9,0xc0ba,0xc0bb,0xc0be,0xc0c2,0xc0c3,0xc0c4,
0xc0c6,0xc0c7,0xc0ca,0xc0cb,0xc0cd,0xc0ce,0xc0cf,0xc0d1,
0xc0d2,0xc0d3,0xc0d4,0xc0d5,0xc0d6,0xc0d7,0xc0da,0xc0de,
0xc0df,0xc0e0,0xc0e1,0xc0e2,0xc0e3,0xc0e6,0xc0e7,0xc0e9,
0xc0ea,0xc0eb,0xc0ed,0xc0ee,0xc0ef,0xc0f0,0xc0f1,0xc0f2,
0xc0f3,0xc0f6,0xc0f8,0xc0fa,0xc0fb,0xc0fc,0xc0fd,0xc0fe,
0xc0ff,0xc101,0xc102,0xc103,0xc105,0xc106,0xc107,0xc109,
0xc10a,0xc10b,0xc10c,0xc10d,0xc10e,0xc10f,0xc111,0xc112,
0xc113,0xc114,0xc116,0xc117,0xc118,0xc119,0xc11a,0xc11b,
0xc121,0xc122,0xc125,0xc128,0xc129,0xc12a,0xc12b,0xc12e,
0xc132,0xc133,0xc134,0xc135,0xc137,0xc13a,0xc13b,0xc13d,
0xc13e,0xc13f,0xc141,0xc142,0xc143,0xc144,0xc145,0xc146,
0xc147,0xc14a,0xc14e,0xc14f,0xc150,0xc151,0xc152,0xc153,
0xc156,0xc157,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xc159,0xc15a,0xc15b,0xc15d,0xc15e,0xc15f,0xc160,0xc161,
0xc162,0xc163,0xc166,0xc16a,0xc16b,0xc16c,0xc16d,0xc16e,
0xc16f,0xc171,0xc172,0xc173,0xc175,0xc176,0xc177,0xc179,
0xc17a,0xc17b,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xc17c,0xc17d,0xc17e,0xc17f,0xc180,0xc181,0xc182,0xc183,
0xc184,0xc186,0xc187,0xc188,0xc189,0xc18a,0xc18b,0xc18f,
0xc191,0xc192,0xc193,0xc195,0xc197,0xc198,0xc199,0xc19a,
0xc19b,0xc19e,0xc1a0,0xc1a2,0xc1a3,0xc1a4,0xc1a6,0xc1a7,
0xc1aa,0xc1ab,0xc1ad,0xc1ae,0xc1af,0xc1b1,0xc1b2,0xc1b3,
0xc1b4,0xc1b5,0xc1b6,0xc1b7,0xc1b8,0xc1b9,0xc1ba,0xc1bb,
0xc1bc,0xc1be,0xc1bf,0xc1c0,0xc1c1,0xc1c2,0xc1c3,0xc1c5,
0xc1c6,0xc1c7,0xc1c9,0xc1ca,0xc1cb,0xc1cd,0xc1ce,0xc1cf,
0xc1d0,0xc1d1,0xc1d2,0xc1d3,0xc1d5,0xc1d6,0xc1d9,0xc1da,
0xc1db,0xc1dc,0xc1dd,0xc1de,0xc1df,0xc1e1,0xc1e2,0xc1e3,
0xc1e5,0xc1e6,0xc1e7,0xc1e9,0xc1ea,0xc1eb,0xc1ec,0xc1ed,
0xc1ee,0xc1ef,0xc1f2,0xc1f4,0xc1f5,0xc1f6,0xc1f7,0xc1f8,
0xc1f9,0xc1fa,0xc1fb,0xc1fe,0xc1ff,0xc201,0xc202,0xc203,
0xc205,0xc206,0xc207,0xc208,0xc209,0xc20a,0xc20b,0xc20e,
0xc210,0xc212,0xc213,0xc214,0xc215,0xc216,0xc217,0xc21a,
0xc21b,0xc21d,0xc21e,0xc221,0xc222,0xc223,0xc224,0xc225,
0xc226,0xc227,0xc22a,0xc22c,0xc22e,0xc230,0xc233,0xc235,
0xc236,0xc237,0xc238,0xc239,0xc23a,0xc23b,0xc23c,0xc23d,
0xc23e,0xc23f,0xc240,0xc241,0xc242,0xc243,0xc244,0xc245,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xc246,0xc247,
0xc249,0xc24a,0xc24b,0xc24c,0xc24d,0xc24e,0xc24f,0xc252,
0xc253,0xc255,0xc256,0xc257,0xc259,0xc25a,0xc25b,0xc25c,
0xc25d,0xc25e,0xc25f,0xc261,0xc262,0xc263,0xc264,0xc266,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xc267,0xc268,
0xc269,0xc26a,0xc26b,0xc26e,0xc26f,0xc271,0xc272,0xc273,
0xc275,0xc276,0xc277,0xc278,0xc279,0xc27a,0xc27b,0xc27e,
0xc280,0xc282,0xc283,0xc284,0xc285,0xc286,0xc287,0xc28a,
0xc28b,0xc28c,0xc28d,0xc28e,0xc28f,0xc291,0xc292,0xc293,
0xc294,0xc295,0xc296,0xc297,0xc299,0xc29a,0xc29c,0xc29e,
0xc29f,0xc2a0,0xc2a1,0xc2a2,0xc2a3,0xc2a6,0xc2a7,0xc2a9,
0xc2aa,0xc2ab,0xc2ae,0xc2af,0xc2b0,0xc2b1,0xc2b2,0xc2b3,
0xc2b6,0xc2b8,0xc2ba,0xc2bb,0xc2bc,0xc2bd,0xc2be,0xc2bf,
0xc2c0,0xc2c1,0xc2c2,0xc2c3,0xc2c4,0xc2c5,0xc2c6,0xc2c7,
0xc2c8,0xc2c9,0xc2ca,0xc2cb,0xc2cc,0xc2cd,0xc2ce,0xc2cf,
0xc2d0,0xc2d1,0xc2d2,0xc2d3,0xc2d4,0xc2d5,0xc2d6,0xc2d7,
0xc2d8,0xc2d9,0xc2da,0xc2db,0xc2de,0xc2df,0xc2e1,0xc2e2,
0xc2e5,0xc2e6,0xc2e7,0xc2e8,0xc2e9,0xc2ea,0xc2ee,0xc2f0,
0xc2f2,0xc2f3,0xc2f4,0xc2f5,0xc2f7,0xc2fa,0xc2fd,0xc2fe,
0xc2ff,0xc301,0xc302,0xc303,0xc304,0xc305,0xc306,0xc307,
0xc30a,0xc30b,0xc30e,0xc30f,0xc310,0xc311,0xc312,0xc316,
0xc317,0xc319,0xc31a,0xc31b,0xc31d,0xc31e,0xc31f,0xc320,
0xc321,0xc322,0xc323,0xc326,0xc327,0xc32a,0xc32b,0xc32c,
0xc32d,0xc32e,0xc32f,0xc330,0xc331,0xc332,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xc333,0xc334,0xc335,0xc336,
0xc337,0xc338,0xc339,0xc33a,0xc33b,0xc33c,0xc33d,0xc33e,
0xc33f,0xc340,0xc341,0xc342,0xc343,0xc344,0xc346,0xc347,
0xc348,0xc349,0xc34a,0xc34b,0xc34c,0xc34d,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xc34e,0xc34f,0xc350,0xc351,
0xc352,0xc353,0xc354,0xc355,0xc356,0xc357,0xc358,0xc359,
0xc35a,0xc35b,0xc35c,0xc35d,0xc35e,0xc35f,0xc360,0xc361,
0xc362,0xc363,0xc364,0xc365,0xc366,0xc367,0xc36a,0xc36b,
0xc36d,0xc36e,0xc36f,0xc371,0xc373,0xc374,0xc375,0xc376,
0xc377,0xc37a,0xc37b,0xc37e,0xc37f,0xc380,0xc381,0xc382,
0xc383,0xc385,0xc386,0xc387,0xc389,0xc38a,0xc38b,0xc38d,
0xc38e,0xc38f,0xc390,0xc391,0xc392,0xc393,0xc394,0xc395,
0xc396,0xc397,0xc398,0xc399,0xc39a,0xc39b,0xc39c,0xc39d,
0xc39e,0xc39f,0xc3a0,0xc3a1,0xc3a2,0xc3a3,0xc3a4,0xc3a5,
0xc3a6,0xc3a7,0xc3a8,0xc3a9,0xc3aa,0xc3ab,0xc3ac,0xc3ad,
0xc3ae,0xc3af,0xc3b0,0xc3b1,0xc3b2,0xc3b3,0xc3b4,0xc3b5,
0xc3b6,0xc3b7,0xc3b8,0xc3b9,0xc3ba,0xc3bb,0xc3bc,0xc3bd,
0xc3be,0xc3bf,0xc3c1,0xc3c2,0xc3c3,0xc3c4,0xc3c5,0xc3c6,
0xc3c7,0xc3c8,0xc3c9,0xc3ca,0xc3cb,0xc3cc,0xc3cd,0xc3ce,
0xc3cf,0xc3d0,0xc3d1,0xc3d2,0xc3d3,0xc3d4,0xc3d5,0xc3d6,
0xc3d7,0xc3da,0xc3db,0xc3dd,0xc3de,0xc3e1,0xc3e3,0xc3e4,
0xc3e5,0xc3e6,0xc3e7,0xc3ea,0xc3eb,0xc3ec,0xc3ee,0xc3ef,
0xc3f0,0xc3f1,0xc3f2,0xc3f3,0xc3f6,0xc3f7,0xc3f9,0xc3fa,
0xc3fb,0xc3fc,0xc3fd,0xc3fe,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xc3ff,0xc400,0xc401,0xc402,0xc403,0xc404,
0xc405,0xc406,0xc407,0xc409,0xc40a,0xc40b,0xc40c,0xc40d,
0xc40e,0xc40f,0xc411,0xc412,0xc413,0xc414,0xc415,0xc416,
0xc417,0xc418,0xc419,0xc41a,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xc41b,0xc41c,0xc41d,0xc41e,0xc41f,0xc420,
0xc421,0xc422,0xc423,0xc425,0xc426,0xc427,0xc428,0xc429,
0xc42a,0xc42b,0xc42d,0xc42e,0xc42f,0xc431,0xc432,0xc433,
0xc435,0xc436,0xc437,0xc438,0xc439,0xc43a,0xc43b,0xc43e,
0xc43f,0xc440,0xc441,0xc442,0xc443,0xc444,0xc445,0xc446,
0xc447,0xc449,0xc44a,0xc44b,0xc44c,0xc44d,0xc44e,0xc44f,
0xc450,0xc451,0xc452,0xc453,0xc454,0xc455,0xc456,0xc457,
0xc458,0xc459,0xc45a,0xc45b,0xc45c,0xc45d,0xc45e,0xc45f,
0xc460,0xc461,0xc462,0xc463,0xc466,0xc467,0xc469,0xc46a,
0xc46b,0xc46d,0xc46e,0xc46f,0xc470,0xc471,0xc472,0xc473,
0xc476,0xc477,0xc478,0xc47a,0xc47b,0xc47c,0xc47d,0xc47e,
0xc47f,0xc481,0xc482,0xc483,0xc484,0xc485,0xc486,0xc487,
0xc488,0xc489,0xc48a,0xc48b,0xc48c,0xc48d,0xc48e,0xc48f,
0xc490,0xc491,0xc492,0xc493,0xc495,0xc496,0xc497,0xc498,
0xc499,0xc49a,0xc49b,0xc49d,0xc49e,0xc49f,0xc4a0,0xc4a1,
0xc4a2,0xc4a3,0xc4a4,0xc4a5,0xc4a6,0xc4a7,0xc4a8,0xc4a9,
0xc4aa,0xc4ab,0xc4ac,0xc4ad,0xc4ae,0xc4af,0xc4b0,0xc4b1,
0xc4b2,0xc4b3,0xc4b4,0xc4b5,0xc4b6,0xc4b7,0xc4b9,0xc4ba,
0xc4bb,0xc4bd,0xc4be,0xc4bf,0xc4c0,0xc4c1,0xc4c2,0xc4c3,
0xc4c4,0xc4c5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xc4c6,0xc4c7,0xc4c8,0xc4c9,0xc4ca,0xc4cb,0xc4cc,0xc4cd,
0xc4ce,0xc4cf,0xc4d0,0xc4d1,0xc4d2,0xc4d3,0xc4d4,0xc4d5,
0xc4d6,0xc4d7,0xc4d8,0xc4d9,0xc4da,0xc4db,0xc4dc,0xc4dd,
0xc4de,0xc4df,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xc4e0,0xc4e1,0xc4e2,0xc4e3,0xc4e4,0xc4e5,0xc4e6,0xc4e7,
0xc4e8,0xc4ea,0xc4eb,0xc4ec,0xc4ed,0xc4ee,0xc4ef,0xc4f2,
0xc4f3,0xc4f5,0xc4f6,0xc4f7,0xc4f9,0xc4fb,0xc4fc,0xc4fd,
0xc4fe,0xc502,0xc503,0xc504,0xc505,0xc506,0xc507,0xc508,
0xc509,0xc50a,0xc50b,0xc50d,0xc50e,0xc50f,0xc511,0xc512,
0xc513,0xc515,0xc516,0xc517,0xc518,0xc519,0xc51a,0xc51b,
0xc51d,0xc51e,0xc51f,0xc520,0xc521,0xc522,0xc523,0xc524,
0xc525,0xc526,0xc527,0xc52a,0xc52b,0xc52d,0xc52e,0xc52f,
0xc531,0xc532,0xc533,0xc534,0xc535,0xc536,0xc537,0xc53a,
0xc53c,0xc53e,0xc53f,0xc540,0xc541,0xc542,0xc543,0xc546,
0xc547,0xc54b,0xc54f,0xc550,0xc551,0xc552,0xc556,0xc55a,
0xc55b,0xc55c,0xc55f,0xc562,0xc563,0xc565,0xc566,0xc567,
0xc569,0xc56a,0xc56b,0xc56c,0xc56d,0xc56e,0xc56f,0xc572,
0xc576,0xc577,0xc578,0xc579,0xc57a,0xc57b,0xc57e,0xc57f,
0xc581,0xc582,0xc583,0xc585,0xc586,0xc588,0xc589,0xc58a,
0xc58b,0xc58e,0xc590,0xc592,0xc593,0xc594,0xc596,0xc599,
0xc59a,0xc59b,0xc59d,0xc59e,0xc59f,0xc5a1,0xc5a2,0xc5a3,
0xc5a4,0xc5a5,0xc5a6,0xc5a7,0xc5a8,0xc5aa,0xc5ab,0xc5ac,
0xc5ad,0xc5ae,0xc5af,0xc5b0,0xc5b1,0xc5b2,0xc5b3,0xc5b6,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xc5b7,0xc5ba,
0xc5bf,0xc5c0,0xc5c1,0xc5c2,0xc5c3,0xc5cb,0xc5cd,0xc5cf,
0xc5d2,0xc5d3,0xc5d5,0xc5d6,0xc5d7,0xc5d9,0xc5da,0xc5db,
0xc5dc,0xc5dd,0xc5de,0xc5df,0xc5e2,0xc5e4,0xc5e6,0xc5e7,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xc5e8,0xc5e9,
0xc5ea,0xc5eb,0xc5ef,0xc5f1,0xc5f2,0xc5f3,0xc5f5,0xc5f8,
0xc5f9,0xc5fa,0xc5fb,0xc602,0xc603,0xc604,0xc609,0xc60a,
0xc60b,0xc60d,0xc60e,0xc60f,0xc611,0xc612,0xc613,0xc614,
0xc615,0xc616,0xc617,0xc61a,0xc61d,0xc61e,0xc61f,0xc620,
0xc621,0xc622,0xc623,0xc626,0xc627,0xc629,0xc62a,0xc62b,
0xc62f,0xc631,0xc632,0xc636,0xc638,0xc63a,0xc63c,0xc63d,
0xc63e,0xc63f,0xc642,0xc643,0xc645,0xc646,0xc647,0xc649,
0xc64a,0xc64b,0xc64c,0xc64d,0xc64e,0xc64f,0xc652,0xc656,
0xc657,0xc658,0xc659,0xc65a,0xc65b,0xc65e,0xc65f,0xc661,
0xc662,0xc663,0xc664,0xc665,0xc666,0xc667,0xc668,0xc669,
0xc66a,0xc66b,0xc66d,0xc66e,0xc670,0xc672,0xc673,0xc674,
0xc675,0xc676,0xc677,0xc67a,0xc67b,0xc67d,0xc67e,0xc67f,
0xc681,0xc682,0xc683,0xc684,0xc685,0xc686,0xc687,0xc68a,
0xc68c,0xc68e,0xc68f,0xc690,0xc691,0xc692,0xc693,0xc696,
0xc697,0xc699,0xc69a,0xc69b,0xc69d,0xc69e,0xc69f,0xc6a0,
0xc6a1,0xc6a2,0xc6a3,0xc6a6,0xc6a8,0xc6aa,0xc6ab,0xc6ac,
0xc6ad,0xc6ae,0xc6af,0xc6b2,0xc6b3,0xc6b5,0xc6b6,0xc6b7,
0xc6bb,0xc6bc,0xc6bd,0xc6be,0xc6bf,0xc6c2,0xc6c4,0xc6c6,
0xc6c7,0xc6c8,0xc6c9,0xc6ca,0xc6cb,0xc6ce,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xc6cf,0xc6d1,0xc6d2,0xc6d3,
0xc6d5,0xc6d6,0xc6d7,0xc6d8,0xc6d9,0xc6da,0xc6db,0xc6de,
0xc6df,0xc6e2,0xc6e3,0xc6e4,0xc6e5,0xc6e6,0xc6e7,0xc6ea,
0xc6eb,0xc6ed,0xc6ee,0xc6ef,0xc6f1,0xc6f2,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xc6f3,0xc6f4,0xc6f5,0xc6f6,
0xc6f7,0xc6fa,0xc6fb,0xc6fc,0xc6fe,0xc6ff,0xc700,0xc701,
0xc702,0xc703,0xc706,0xc707,0xc709,0xc70a,0xc70b,0xc70d,
0xc70e,0xc70f,0xc710,0xc711,0xc712,0xc713,0xc716,0xc718,
0xc71a,0xc71b,0xc71c,0xc71d,0xc71e,0xc71f,0xc722,0xc723,
0xc725,0xc726,0xc727,0xc729,0xc72a,0xc72b,0xc72c,0xc72d,
0xc72e,0xc72f,0xc732,0xc734,0xc736,0xc738,0xc739,0xc73a,
0xc73b,0xc73e,0xc73f,0xc741,0xc742,0xc743,0xc745,0xc746,
0xc747,0xc748,0xc749,0xc74b,0xc74e,0xc750,0xc759,0xc75a,
0xc75b,0xc75d,0xc75e,0xc75f,0xc761,0xc762,0xc763,0xc764,
0xc765,0xc766,0xc767,0xc769,0xc76a,0xc76c,0xc76d,0xc76e,
0xc76f,0xc770,0xc771,0xc772,0xc773,0xc776,0xc777,0xc779,
0xc77a,0xc77b,0xc77f,0xc780,0xc781,0xc782,0xc786,0xc78b,
0xc78c,0xc78d,0xc78f,0xc792,0xc793,0xc795,0xc799,0xc79b,
0xc79c,0xc79d,0xc79e,0xc79f,0xc7a2,0xc7a7,0xc7a8,0xc7a9,
0xc7aa,0xc7ab,0xc7ae,0xc7af,0xc7b1,0xc7b2,0xc7b3,0xc7b5,
0xc7b6,0xc7b7,0xc7b8,0xc7b9,0xc7ba,0xc7bb,0xc7be,0xc7c2,
0xc7c3,0xc7c4,0xc7c5,0xc7c6,0xc7c7,0xc7ca,0xc7cb,0xc7cd,
0xc7cf,0xc7d1,0xc7d2,0xc7d3,0xc7d4,0xc7d5,0xc7d6,0xc7d7,
0xc7d9,0xc7da,0xc7db,0xc7dc,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xc7de,0xc7df,0xc7e0,0xc7e1,0xc7e2,0xc7e3,
0xc7e5,0xc7e6,0xc7e7,0xc7e9,0xc7ea,0xc7eb,0xc7ed,0xc7ee,
0xc7ef,0xc7f0,0xc7f1,0xc7f2,0xc7f3,0xc7f4,0xc7f5,0xc7f6,
0xc7f7,0xc7f8,0xc7f9,0xc7fa,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xc7fb,0xc7fc,0xc7fd,0xc7fe,0xc7ff,0xc802,
0xc803,0xc805,0xc806,0xc807,0xc809,0xc80b,0xc80c,0xc80d,
0xc80e,0xc80f,0xc812,0xc814,0xc817,0xc818,0xc819,0xc81a,
0xc81b,0xc81e,0xc81f,0xc821,0xc822,0xc823,0xc825,0xc826,
0xc827,0xc828,0xc829,0xc82a,0xc82b,0xc82e,0xc830,0xc832,
0xc833,0xc834,0xc835,0xc836,0xc837,0xc839,0xc83a,0xc83b,
0xc83d,0xc83e,0xc83f,0xc841,0xc842,0xc843,0xc844,0xc845,
0xc846,0xc847,0xc84a,0xc84b,0xc84e,0xc84f,0xc850,0xc851,
0xc852,0xc853,0xc855,0xc856,0xc857,0xc858,0xc859,0xc85a,
0xc85b,0xc85c,0xc85d,0xc85e,0xc85f,0xc860,0xc861,0xc862,
0xc863,0xc864,0xc865,0xc866,0xc867,0xc868,0xc869,0xc86a,
0xc86b,0xc86c,0xc86d,0xc86e,0xc86f,0xc872,0xc873,0xc875,
0xc876,0xc877,0xc879,0xc87b,0xc87c,0xc87d,0xc87e,0xc87f,
0xc882,0xc884,0xc888,0xc889,0xc88a,0xc88e,0xc88f,0xc890,
0xc891,0xc892,0xc893,0xc895,0xc896,0xc897,0xc898,0xc899,
0xc89a,0xc89b,0xc89c,0xc89e,0xc8a0,0xc8a2,0xc8a3,0xc8a4
};

static const int uhc1_ucs_table_size = (sizeof(uhc1_ucs_table)/sizeof(unsigned short));

static const unsigned short uhc2_ucs_table[] = {
0xc8a5,0xc8a6,0xc8a7,0xc8a9,0xc8aa,0xc8ab,0xc8ac,0xc8ad,
0xc8ae,0xc8af,0xc8b0,0xc8b1,0xc8b2,0xc8b3,0xc8b4,0xc8b5,
0xc8b6,0xc8b7,0xc8b8,0xc8b9,0xc8ba,0xc8bb,0xc8be,0xc8bf,
0xc8c0,0xc8c1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xc8c2,0xc8c3,0xc8c5,0xc8c6,0xc8c7,0xc8c9,0xc8ca,0xc8cb,
0xc8cd,0xc8ce,0xc8cf,0xc8d0,0xc8d1,0xc8d2,0xc8d3,0xc8d6,
0xc8d8,0xc8da,0xc8db,0xc8dc,0xc8dd,0xc8de,0xc8df,0xc8e2,
0xc8e3,0xc8e5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xc8e6,0xc8e7,0xc8e8,0xc8e9,0xc8ea,0xc8eb,0xc8ec,0xc8ed,
0xc8ee,0xc8ef,0xc8f0,0xc8f1,0xc8f2,0xc8f3,0xc8f4,0xc8f6,
0xc8f7,0xc8f8,0xc8f9,0xc8fa,0xc8fb,0xc8fe,0xc8ff,0xc901,
0xc902,0xc903,0xc907,0xc908,0xc909,0xc90a,0xc90b,0xc90e,
0x3000,0x3001,0x3002,0x00b7,0x2025,0x2026,0x00a8,0x3003,
0x00ad,0x2015,0x2225,0xff3c,0x223c,0x2018,0x2019,0x201c,
0x201d,0x3014,0x3015,0x3008,0x3009,0x300a,0x300b,0x300c,
0x300d,0x300e,0x300f,0x3010,0x3011,0x00b1,0x00d7,0x00f7,
0x2260,0x2264,0x2265,0x221e,0x2234,0x00b0,0x2032,0x2033,
0x2103,0x212b,0xffe0,0xffe1,0xffe5,0x2642,0x2640,0x2220,
0x22a5,0x2312,0x2202,0x2207,0x2261,0x2252,0x00a7,0x203b,
0x2606,0x2605,0x25cb,0x25cf,0x25ce,0x25c7,0x25c6,0x25a1,
0x25a0,0x25b3,0x25b2,0x25bd,0x25bc,0x2192,0x2190,0x2191,
0x2193,0x2194,0x3013,0x226a,0x226b,0x221a,0x223d,0x221d,
0x2235,0x222b,0x222c,0x2208,0x220b,0x2286,0x2287,0x2282,
0x2283,0x222a,0x2229,0x2227,0x2228,0xffe2,0xc910,0xc912,
0xc913,0xc914,0xc915,0xc916,0xc917,0xc919,0xc91a,0xc91b,
0xc91c,0xc91d,0xc91e,0xc91f,0xc920,0xc921,0xc922,0xc923,
0xc924,0xc925,0xc926,0xc927,0xc928,0xc929,0xc92a,0xc92b,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xc92d,0xc92e,
0xc92f,0xc930,0xc931,0xc932,0xc933,0xc935,0xc936,0xc937,
0xc938,0xc939,0xc93a,0xc93b,0xc93c,0xc93d,0xc93e,0xc93f,
0xc940,0xc941,0xc942,0xc943,0xc944,0xc945,0xc946,0xc947,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xc948,0xc949,
0xc94a,0xc94b,0xc94c,0xc94d,0xc94e,0xc94f,0xc952,0xc953,
0xc955,0xc956,0xc957,0xc959,0xc95a,0xc95b,0xc95c,0xc95d,
0xc95e,0xc95f,0xc962,0xc964,0xc965,0xc966,0xc967,0xc968,
0xc969,0xc96a,0xc96b,0xc96d,0xc96e,0xc96f,0x21d2,0x21d4,
0x2200,0x2203,0x00b4,0xff5e,0x02c7,0x02d8,0x02dd,0x02da,
0x02d9,0x00b8,0x02db,0x00a1,0x00bf,0x02d0,0x222e,0x2211,
0x220f,0x00a4,0x2109,0x2030,0x25c1,0x25c0,0x25b7,0x25b6,
0x2664,0x2660,0x2661,0x2665,0x2667,0x2663,0x2299,0x25c8,
0x25a3,0x25d0,0x25d1,0x2592,0x25a4,0x25a5,0x25a8,0x25a7,
0x25a6,0x25a9,0x2668,0x260f,0x260e,0x261c,0x261e,0x00b6,
0x2020,0x2021,0x2195,0x2197,0x2199,0x2196,0x2198,0x266d,
0x2669,0x266a,0x266c,0x327f,0x321c,0x2116,0x33c7,0x2122,
0x33c2,0x33d8,0x2121,0x20ac,0x00ae,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xc971,0xc972,0xc973,0xc975,
0xc976,0xc977,0xc978,0xc979,0xc97a,0xc97b,0xc97d,0xc97e,
0xc97f,0xc980,0xc981,0xc982,0xc983,0xc984,0xc985,0xc986,
0xc987,0xc98a,0xc98b,0xc98d,0xc98e,0xc98f,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xc991,0xc992,0xc993,0xc994,
0xc995,0xc996,0xc997,0xc99a,0xc99c,0xc99e,0xc99f,0xc9a0,
0xc9a1,0xc9a2,0xc9a3,0xc9a4,0xc9a5,0xc9a6,0xc9a7,0xc9a8,
0xc9a9,0xc9aa,0xc9ab,0xc9ac,0xc9ad,0xc9ae,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xc9af,0xc9b0,0xc9b1,0xc9b2,
0xc9b3,0xc9b4,0xc9b5,0xc9b6,0xc9b7,0xc9b8,0xc9b9,0xc9ba,
0xc9bb,0xc9bc,0xc9bd,0xc9be,0xc9bf,0xc9c2,0xc9c3,0xc9c5,
0xc9c6,0xc9c9,0xc9cb,0xc9cc,0xc9cd,0xc9ce,0xc9cf,0xc9d2,
0xc9d4,0xc9d7,0xc9d8,0xc9db,0xff01,0xff02,0xff03,0xff04,
0xff05,0xff06,0xff07,0xff08,0xff09,0xff0a,0xff0b,0xff0c,
0xff0d,0xff0e,0xff0f,0xff10,0xff11,0xff12,0xff13,0xff14,
0xff15,0xff16,0xff17,0xff18,0xff19,0xff1a,0xff1b,0xff1c,
0xff1d,0xff1e,0xff1f,0xff20,0xff21,0xff22,0xff23,0xff24,
0xff25,0xff26,0xff27,0xff28,0xff29,0xff2a,0xff2b,0xff2c,
0xff2d,0xff2e,0xff2f,0xff30,0xff31,0xff32,0xff33,0xff34,
0xff35,0xff36,0xff37,0xff38,0xff39,0xff3a,0xff3b,0xffe6,
0xff3d,0xff3e,0xff3f,0xff40,0xff41,0xff42,0xff43,0xff44,
0xff45,0xff46,0xff47,0xff48,0xff49,0xff4a,0xff4b,0xff4c,
0xff4d,0xff4e,0xff4f,0xff50,0xff51,0xff52,0xff53,0xff54,
0xff55,0xff56,0xff57,0xff58,0xff59,0xff5a,0xff5b,0xff5c,
0xff5d,0xffe3,0xc9de,0xc9df,0xc9e1,0xc9e3,0xc9e5,0xc9e6,
0xc9e8,0xc9e9,0xc9ea,0xc9eb,0xc9ee,0xc9f2,0xc9f3,0xc9f4,
0xc9f5,0xc9f6,0xc9f7,0xc9fa,0xc9fb,0xc9fd,0xc9fe,0xc9ff,
0xca01,0xca02,0xca03,0xca04,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xca05,0xca06,0xca07,0xca0a,0xca0e,0xca0f,
0xca10,0xca11,0xca12,0xca13,0xca15,0xca16,0xca17,0xca19,
0xca1a,0xca1b,0xca1c,0xca1d,0xca1e,0xca1f,0xca20,0xca21,
0xca22,0xca23,0xca24,0xca25,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xca26,0xca27,0xca28,0xca2a,0xca2b,0xca2c,
0xca2d,0xca2e,0xca2f,0xca30,0xca31,0xca32,0xca33,0xca34,
0xca35,0xca36,0xca37,0xca38,0xca39,0xca3a,0xca3b,0xca3c,
0xca3d,0xca3e,0xca3f,0xca40,0xca41,0xca42,0xca43,0xca44,
0xca45,0xca46,0x3131,0x3132,0x3133,0x3134,0x3135,0x3136,
0x3137,0x3138,0x3139,0x313a,0x313b,0x313c,0x313d,0x313e,
0x313f,0x3140,0x3141,0x3142,0x3143,0x3144,0x3145,0x3146,
0x3147,0x3148,0x3149,0x314a,0x314b,0x314c,0x314d,0x314e,
0x314f,0x3150,0x3151,0x3152,0x3153,0x3154,0x3155,0x3156,
0x3157,0x3158,0x3159,0x315a,0x315b,0x315c,0x315d,0x315e,
0x315f,0x3160,0x3161,0x3162,0x3163,0x3164,0x3165,0x3166,
0x3167,0x3168,0x3169,0x316a,0x316b,0x316c,0x316d,0x316e,
0x316f,0x3170,0x3171,0x3172,0x3173,0x3174,0x3175,0x3176,
0x3177,0x3178,0x3179,0x317a,0x317b,0x317c,0x317d,0x317e,
0x317f,0x3180,0x3181,0x3182,0x3183,0x3184,0x3185,0x3186,
0x3187,0x3188,0x3189,0x318a,0x318b,0x318c,0x318d,0x318e,
0xca47,0xca48,0xca49,0xca4a,0xca4b,0xca4e,0xca4f,0xca51,
0xca52,0xca53,0xca55,0xca56,0xca57,0xca58,0xca59,0xca5a,
0xca5b,0xca5e,0xca62,0xca63,0xca64,0xca65,0xca66,0xca67,
0xca69,0xca6a,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xca6b,0xca6c,0xca6d,0xca6e,0xca6f,0xca70,0xca71,0xca72,
0xca73,0xca74,0xca75,0xca76,0xca77,0xca78,0xca79,0xca7a,
0xca7b,0xca7c,0xca7e,0xca7f,0xca80,0xca81,0xca82,0xca83,
0xca85,0xca86,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xca87,0xca88,0xca89,0xca8a,0xca8b,0xca8c,0xca8d,0xca8e,
0xca8f,0xca90,0xca91,0xca92,0xca93,0xca94,0xca95,0xca96,
0xca97,0xca99,0xca9a,0xca9b,0xca9c,0xca9d,0xca9e,0xca9f,
0xcaa0,0xcaa1,0xcaa2,0xcaa3,0xcaa4,0xcaa5,0xcaa6,0xcaa7,
0x2170,0x2171,0x2172,0x2173,0x2174,0x2175,0x2176,0x2177,
0x2178,0x2179,0x0000,0x0000,0x0000,0x0000,0x0000,0x2160,
0x2161,0x2162,0x2163,0x2164,0x2165,0x2166,0x2167,0x2168,
0x2169,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0391,0x0392,0x0393,0x0394,0x0395,0x0396,0x0397,0x0398,
0x0399,0x039a,0x039b,0x039c,0x039d,0x039e,0x039f,0x03a0,
0x03a1,0x03a3,0x03a4,0x03a5,0x03a6,0x03a7,0x03a8,0x03a9,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x03b1,0x03b2,0x03b3,0x03b4,0x03b5,0x03b6,0x03b7,0x03b8,
0x03b9,0x03ba,0x03bb,0x03bc,0x03bd,0x03be,0x03bf,0x03c0,
0x03c1,0x03c3,0x03c4,0x03c5,0x03c6,0x03c7,0x03c8,0x03c9,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcaa8,0xcaa9,
0xcaaa,0xcaab,0xcaac,0xcaad,0xcaae,0xcaaf,0xcab0,0xcab1,
0xcab2,0xcab3,0xcab4,0xcab5,0xcab6,0xcab7,0xcab8,0xcab9,
0xcaba,0xcabb,0xcabe,0xcabf,0xcac1,0xcac2,0xcac3,0xcac5,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcac6,0xcac7,
0xcac8,0xcac9,0xcaca,0xcacb,0xcace,0xcad0,0xcad2,0xcad4,
0xcad5,0xcad6,0xcad7,0xcada,0xcadb,0xcadc,0xcadd,0xcade,
0xcadf,0xcae1,0xcae2,0xcae3,0xcae4,0xcae5,0xcae6,0xcae7,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcae8,0xcae9,
0xcaea,0xcaeb,0xcaed,0xcaee,0xcaef,0xcaf0,0xcaf1,0xcaf2,
0xcaf3,0xcaf5,0xcaf6,0xcaf7,0xcaf8,0xcaf9,0xcafa,0xcafb,
0xcafc,0xcafd,0xcafe,0xcaff,0xcb00,0xcb01,0xcb02,0xcb03,
0xcb04,0xcb05,0xcb06,0xcb07,0xcb09,0xcb0a,0x2500,0x2502,
0x250c,0x2510,0x2518,0x2514,0x251c,0x252c,0x2524,0x2534,
0x253c,0x2501,0x2503,0x250f,0x2513,0x251b,0x2517,0x2523,
0x2533,0x252b,0x253b,0x254b,0x2520,0x252f,0x2528,0x2537,
0x253f,0x251d,0x2530,0x2525,0x2538,0x2542,0x2512,0x2511,
0x251a,0x2519,0x2516,0x2515,0x250e,0x250d,0x251e,0x251f,
0x2521,0x2522,0x2526,0x2527,0x2529,0x252a,0x252d,0x252e,
0x2531,0x2532,0x2535,0x2536,0x2539,0x253a,0x253d,0x253e,
0x2540,0x2541,0x2543,0x2544,0x2545,0x2546,0x2547,0x2548,
0x2549,0x254a,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xcb0b,0xcb0c,0xcb0d,0xcb0e,
0xcb0f,0xcb11,0xcb12,0xcb13,0xcb15,0xcb16,0xcb17,0xcb19,
0xcb1a,0xcb1b,0xcb1c,0xcb1d,0xcb1e,0xcb1f,0xcb22,0xcb23,
0xcb24,0xcb25,0xcb26,0xcb27,0xcb28,0xcb29,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xcb2a,0xcb2b,0xcb2c,0xcb2d,
0xcb2e,0xcb2f,0xcb30,0xcb31,0xcb32,0xcb33,0xcb34,0xcb35,
0xcb36,0xcb37,0xcb38,0xcb39,0xcb3a,0xcb3b,0xcb3c,0xcb3d,
0xcb3e,0xcb3f,0xcb40,0xcb42,0xcb43,0xcb44,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xcb45,0xcb46,0xcb47,0xcb4a,
0xcb4b,0xcb4d,0xcb4e,0xcb4f,0xcb51,0xcb52,0xcb53,0xcb54,
0xcb55,0xcb56,0xcb57,0xcb5a,0xcb5b,0xcb5c,0xcb5e,0xcb5f,
0xcb60,0xcb61,0xcb62,0xcb63,0xcb65,0xcb66,0xcb67,0xcb68,
0xcb69,0xcb6a,0xcb6b,0xcb6c,0x3395,0x3396,0x3397,0x2113,
0x3398,0x33c4,0x33a3,0x33a4,0x33a5,0x33a6,0x3399,0x339a,
0x339b,0x339c,0x339d,0x339e,0x339f,0x33a0,0x33a1,0x33a2,
0x33ca,0x338d,0x338e,0x338f,0x33cf,0x3388,0x3389,0x33c8,
0x33a7,0x33a8,0x33b0,0x33b1,0x33b2,0x33b3,0x33b4,0x33b5,
0x33b6,0x33b7,0x33b8,0x33b9,0x3380,0x3381,0x3382,0x3383,
0x3384,0x33ba,0x33bb,0x33bc,0x33bd,0x33be,0x33bf,0x3390,
0x3391,0x3392,0x3393,0x3394,0x2126,0x33c0,0x33c1,0x338a,
0x338b,0x338c,0x33d6,0x33c5,0x33ad,0x33ae,0x33af,0x33db,
0x33a9,0x33aa,0x33ab,0x33ac,0x33dd,0x33d0,0x33d3,0x33c3,
0x33c9,0x33dc,0x33c6,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xcb6d,0xcb6e,0xcb6f,0xcb70,0xcb71,0xcb72,
0xcb73,0xcb74,0xcb75,0xcb76,0xcb77,0xcb7a,0xcb7b,0xcb7c,
0xcb7d,0xcb7e,0xcb7f,0xcb80,0xcb81,0xcb82,0xcb83,0xcb84,
0xcb85,0xcb86,0xcb87,0xcb88,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xcb89,0xcb8a,0xcb8b,0xcb8c,0xcb8d,0xcb8e,
0xcb8f,0xcb90,0xcb91,0xcb92,0xcb93,0xcb94,0xcb95,0xcb96,
0xcb97,0xcb98,0xcb99,0xcb9a,0xcb9b,0xcb9d,0xcb9e,0xcb9f,
0xcba0,0xcba1,0xcba2,0xcba3,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xcba4,0xcba5,0xcba6,0xcba7,0xcba8,0xcba9,
0xcbaa,0xcbab,0xcbac,0xcbad,0xcbae,0xcbaf,0xcbb0,0xcbb1,
0xcbb2,0xcbb3,0xcbb4,0xcbb5,0xcbb6,0xcbb7,0xcbb9,0xcbba,
0xcbbb,0xcbbc,0xcbbd,0xcbbe,0xcbbf,0xcbc0,0xcbc1,0xcbc2,
0xcbc3,0xcbc4,0x00c6,0x00d0,0x00aa,0x0126,0x0000,0x0132,
0x0000,0x013f,0x0141,0x00d8,0x0152,0x00ba,0x00de,0x0166,
0x014a,0x0000,0x3260,0x3261,0x3262,0x3263,0x3264,0x3265,
0x3266,0x3267,0x3268,0x3269,0x326a,0x326b,0x326c,0x326d,
0x326e,0x326f,0x3270,0x3271,0x3272,0x3273,0x3274,0x3275,
0x3276,0x3277,0x3278,0x3279,0x327a,0x327b,0x24d0,0x24d1,
0x24d2,0x24d3,0x24d4,0x24d5,0x24d6,0x24d7,0x24d8,0x24d9,
0x24da,0x24db,0x24dc,0x24dd,0x24de,0x24df,0x24e0,0x24e1,
0x24e2,0x24e3,0x24e4,0x24e5,0x24e6,0x24e7,0x24e8,0x24e9,
0x2460,0x2461,0x2462,0x2463,0x2464,0x2465,0x2466,0x2467,
0x2468,0x2469,0x246a,0x246b,0x246c,0x246d,0x246e,0x00bd,
0x2153,0x2154,0x00bc,0x00be,0x215b,0x215c,0x215d,0x215e,
0xcbc5,0xcbc6,0xcbc7,0xcbc8,0xcbc9,0xcbca,0xcbcb,0xcbcc,
0xcbcd,0xcbce,0xcbcf,0xcbd0,0xcbd1,0xcbd2,0xcbd3,0xcbd5,
0xcbd6,0xcbd7,0xcbd8,0xcbd9,0xcbda,0xcbdb,0xcbdc,0xcbdd,
0xcbde,0xcbdf,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xcbe0,0xcbe1,0xcbe2,0xcbe3,0xcbe5,0xcbe6,0xcbe8,0xcbea,
0xcbeb,0xcbec,0xcbed,0xcbee,0xcbef,0xcbf0,0xcbf1,0xcbf2,
0xcbf3,0xcbf4,0xcbf5,0xcbf6,0xcbf7,0xcbf8,0xcbf9,0xcbfa,
0xcbfb,0xcbfc,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xcbfd,0xcbfe,0xcbff,0xcc00,0xcc01,0xcc02,0xcc03,0xcc04,
0xcc05,0xcc06,0xcc07,0xcc08,0xcc09,0xcc0a,0xcc0b,0xcc0e,
0xcc0f,0xcc11,0xcc12,0xcc13,0xcc15,0xcc16,0xcc17,0xcc18,
0xcc19,0xcc1a,0xcc1b,0xcc1e,0xcc1f,0xcc20,0xcc23,0xcc24,
0x00e6,0x0111,0x00f0,0x0127,0x0131,0x0133,0x0138,0x0140,
0x0142,0x00f8,0x0153,0x00df,0x00fe,0x0167,0x014b,0x0149,
0x3200,0x3201,0x3202,0x3203,0x3204,0x3205,0x3206,0x3207,
0x3208,0x3209,0x320a,0x320b,0x320c,0x320d,0x320e,0x320f,
0x3210,0x3211,0x3212,0x3213,0x3214,0x3215,0x3216,0x3217,
0x3218,0x3219,0x321a,0x321b,0x249c,0x249d,0x249e,0x249f,
0x24a0,0x24a1,0x24a2,0x24a3,0x24a4,0x24a5,0x24a6,0x24a7,
0x24a8,0x24a9,0x24aa,0x24ab,0x24ac,0x24ad,0x24ae,0x24af,
0x24b0,0x24b1,0x24b2,0x24b3,0x24b4,0x24b5,0x2474,0x2475,
0x2476,0x2477,0x2478,0x2479,0x247a,0x247b,0x247c,0x247d,
0x247e,0x247f,0x2480,0x2481,0x2482,0x00b9,0x00b2,0x00b3,
0x2074,0x207f,0x2081,0x2082,0x2083,0x2084,0xcc25,0xcc26,
0xcc2a,0xcc2b,0xcc2d,0xcc2f,0xcc31,0xcc32,0xcc33,0xcc34,
0xcc35,0xcc36,0xcc37,0xcc3a,0xcc3f,0xcc40,0xcc41,0xcc42,
0xcc43,0xcc46,0xcc47,0xcc49,0xcc4a,0xcc4b,0xcc4d,0xcc4e,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcc4f,0xcc50,
0xcc51,0xcc52,0xcc53,0xcc56,0xcc5a,0xcc5b,0xcc5c,0xcc5d,
0xcc5e,0xcc5f,0xcc61,0xcc62,0xcc63,0xcc65,0xcc67,0xcc69,
0xcc6a,0xcc6b,0xcc6c,0xcc6d,0xcc6e,0xcc6f,0xcc71,0xcc72,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcc73,0xcc74,
0xcc76,0xcc77,0xcc78,0xcc79,0xcc7a,0xcc7b,0xcc7c,0xcc7d,
0xcc7e,0xcc7f,0xcc80,0xcc81,0xcc82,0xcc83,0xcc84,0xcc85,
0xcc86,0xcc87,0xcc88,0xcc89,0xcc8a,0xcc8b,0xcc8c,0xcc8d,
0xcc8e,0xcc8f,0xcc90,0xcc91,0xcc92,0xcc93,0x3041,0x3042,
0x3043,0x3044,0x3045,0x3046,0x3047,0x3048,0x3049,0x304a,
0x304b,0x304c,0x304d,0x304e,0x304f,0x3050,0x3051,0x3052,
0x3053,0x3054,0x3055,0x3056,0x3057,0x3058,0x3059,0x305a,
0x305b,0x305c,0x305d,0x305e,0x305f,0x3060,0x3061,0x3062,
0x3063,0x3064,0x3065,0x3066,0x3067,0x3068,0x3069,0x306a,
0x306b,0x306c,0x306d,0x306e,0x306f,0x3070,0x3071,0x3072,
0x3073,0x3074,0x3075,0x3076,0x3077,0x3078,0x3079,0x307a,
0x307b,0x307c,0x307d,0x307e,0x307f,0x3080,0x3081,0x3082,
0x3083,0x3084,0x3085,0x3086,0x3087,0x3088,0x3089,0x308a,
0x308b,0x308c,0x308d,0x308e,0x308f,0x3090,0x3091,0x3092,
0x3093,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xcc94,0xcc95,0xcc96,0xcc97,
0xcc9a,0xcc9b,0xcc9d,0xcc9e,0xcc9f,0xcca1,0xcca2,0xcca3,
0xcca4,0xcca5,0xcca6,0xcca7,0xccaa,0xccae,0xccaf,0xccb0,
0xccb1,0xccb2,0xccb3,0xccb6,0xccb7,0xccb9,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xccba,0xccbb,0xccbd,0xccbe,
0xccbf,0xccc0,0xccc1,0xccc2,0xccc3,0xccc6,0xccc8,0xccca,
0xcccb,0xcccc,0xcccd,0xccce,0xcccf,0xccd1,0xccd2,0xccd3,
0xccd5,0xccd6,0xccd7,0xccd8,0xccd9,0xccda,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xccdb,0xccdc,0xccdd,0xccde,
0xccdf,0xcce0,0xcce1,0xcce2,0xcce3,0xcce5,0xcce6,0xcce7,
0xcce8,0xcce9,0xccea,0xcceb,0xcced,0xccee,0xccef,0xccf1,
0xccf2,0xccf3,0xccf4,0xccf5,0xccf6,0xccf7,0xccf8,0xccf9,
0xccfa,0xccfb,0xccfc,0xccfd,0x30a1,0x30a2,0x30a3,0x30a4,
0x30a5,0x30a6,0x30a7,0x30a8,0x30a9,0x30aa,0x30ab,0x30ac,
0x30ad,0x30ae,0x30af,0x30b0,0x30b1,0x30b2,0x30b3,0x30b4,
0x30b5,0x30b6,0x30b7,0x30b8,0x30b9,0x30ba,0x30bb,0x30bc,
0x30bd,0x30be,0x30bf,0x30c0,0x30c1,0x30c2,0x30c3,0x30c4,
0x30c5,0x30c6,0x30c7,0x30c8,0x30c9,0x30ca,0x30cb,0x30cc,
0x30cd,0x30ce,0x30cf,0x30d0,0x30d1,0x30d2,0x30d3,0x30d4,
0x30d5,0x30d6,0x30d7,0x30d8,0x30d9,0x30da,0x30db,0x30dc,
0x30dd,0x30de,0x30df,0x30e0,0x30e1,0x30e2,0x30e3,0x30e4,
0x30e5,0x30e6,0x30e7,0x30e8,0x30e9,0x30ea,0x30eb,0x30ec,
0x30ed,0x30ee,0x30ef,0x30f0,0x30f1,0x30f2,0x30f3,0x30f4,
0x30f5,0x30f6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xccfe,0xccff,0xcd00,0xcd02,0xcd03,0xcd04,
0xcd05,0xcd06,0xcd07,0xcd0a,0xcd0b,0xcd0d,0xcd0e,0xcd0f,
0xcd11,0xcd12,0xcd13,0xcd14,0xcd15,0xcd16,0xcd17,0xcd1a,
0xcd1c,0xcd1e,0xcd1f,0xcd20,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xcd21,0xcd22,0xcd23,0xcd25,0xcd26,0xcd27,
0xcd29,0xcd2a,0xcd2b,0xcd2d,0xcd2e,0xcd2f,0xcd30,0xcd31,
0xcd32,0xcd33,0xcd34,0xcd35,0xcd36,0xcd37,0xcd38,0xcd3a,
0xcd3b,0xcd3c,0xcd3d,0xcd3e,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xcd3f,0xcd40,0xcd41,0xcd42,0xcd43,0xcd44,
0xcd45,0xcd46,0xcd47,0xcd48,0xcd49,0xcd4a,0xcd4b,0xcd4c,
0xcd4d,0xcd4e,0xcd4f,0xcd50,0xcd51,0xcd52,0xcd53,0xcd54,
0xcd55,0xcd56,0xcd57,0xcd58,0xcd59,0xcd5a,0xcd5b,0xcd5d,
0xcd5e,0xcd5f,0x0410,0x0411,0x0412,0x0413,0x0414,0x0415,
0x0401,0x0416,0x0417,0x0418,0x0419,0x041a,0x041b,0x041c,
0x041d,0x041e,0x041f,0x0420,0x0421,0x0422,0x0423,0x0424,
0x0425,0x0426,0x0427,0x0428,0x0429,0x042a,0x042b,0x042c,
0x042d,0x042e,0x042f,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0430,0x0431,0x0432,0x0433,0x0434,0x0435,
0x0451,0x0436,0x0437,0x0438,0x0439,0x043a,0x043b,0x043c,
0x043d,0x043e,0x043f,0x0440,0x0441,0x0442,0x0443,0x0444,
0x0445,0x0446,0x0447,0x0448,0x0449,0x044a,0x044b,0x044c,
0x044d,0x044e,0x044f,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xcd61,0xcd62,0xcd63,0xcd65,0xcd66,0xcd67,0xcd68,0xcd69,
0xcd6a,0xcd6b,0xcd6e,0xcd70,0xcd72,0xcd73,0xcd74,0xcd75,
0xcd76,0xcd77,0xcd79,0xcd7a,0xcd7b,0xcd7c,0xcd7d,0xcd7e,
0xcd7f,0xcd80,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xcd81,0xcd82,0xcd83,0xcd84,0xcd85,0xcd86,0xcd87,0xcd89,
0xcd8a,0xcd8b,0xcd8c,0xcd8d,0xcd8e,0xcd8f,0xcd90,0xcd91,
0xcd92,0xcd93,0xcd96,0xcd97,0xcd99,0xcd9a,0xcd9b,0xcd9d,
0xcd9e,0xcd9f,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xcda0,0xcda1,0xcda2,0xcda3,0xcda6,0xcda8,0xcdaa,0xcdab,
0xcdac,0xcdad,0xcdae,0xcdaf,0xcdb1,0xcdb2,0xcdb3,0xcdb4,
0xcdb5,0xcdb6,0xcdb7,0xcdb8,0xcdb9,0xcdba,0xcdbb,0xcdbc,
0xcdbd,0xcdbe,0xcdbf,0xcdc0,0xcdc1,0xcdc2,0xcdc3,0xcdc5,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcdc6,0xcdc7,
0xcdc8,0xcdc9,0xcdca,0xcdcb,0xcdcd,0xcdce,0xcdcf,0xcdd1,
0xcdd2,0xcdd3,0xcdd4,0xcdd5,0xcdd6,0xcdd7,0xcdd8,0xcdd9,
0xcdda,0xcddb,0xcddc,0xcddd,0xcdde,0xcddf,0xcde0,0xcde1,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcde2,0xcde3,
0xcde4,0xcde5,0xcde6,0xcde7,0xcde9,0xcdea,0xcdeb,0xcded,
0xcdee,0xcdef,0xcdf1,0xcdf2,0xcdf3,0xcdf4,0xcdf5,0xcdf6,
0xcdf7,0xcdfa,0xcdfc,0xcdfe,0xcdff,0xce00,0xce01,0xce02,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xce03,0xce05,
0xce06,0xce07,0xce09,0xce0a,0xce0b,0xce0d,0xce0e,0xce0f,
0xce10,0xce11,0xce12,0xce13,0xce15,0xce16,0xce17,0xce18,
0xce1a,0xce1b,0xce1c,0xce1d,0xce1e,0xce1f,0xce22,0xce23,
0xce25,0xce26,0xce27,0xce29,0xce2a,0xce2b,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xce2c,0xce2d,0xce2e,0xce2f,
0xce32,0xce34,0xce36,0xce37,0xce38,0xce39,0xce3a,0xce3b,
0xce3c,0xce3d,0xce3e,0xce3f,0xce40,0xce41,0xce42,0xce43,
0xce44,0xce45,0xce46,0xce47,0xce48,0xce49,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xce4a,0xce4b,0xce4c,0xce4d,
0xce4e,0xce4f,0xce50,0xce51,0xce52,0xce53,0xce54,0xce55,
0xce56,0xce57,0xce5a,0xce5b,0xce5d,0xce5e,0xce62,0xce63,
0xce64,0xce65,0xce66,0xce67,0xce6a,0xce6c,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xce6e,0xce6f,0xce70,0xce71,
0xce72,0xce73,0xce76,0xce77,0xce79,0xce7a,0xce7b,0xce7d,
0xce7e,0xce7f,0xce80,0xce81,0xce82,0xce83,0xce86,0xce88,
0xce8a,0xce8b,0xce8c,0xce8d,0xce8e,0xce8f,0xce92,0xce93,
0xce95,0xce96,0xce97,0xce99,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xce9a,0xce9b,0xce9c,0xce9d,0xce9e,0xce9f,
0xcea2,0xcea6,0xcea7,0xcea8,0xcea9,0xceaa,0xceab,0xceae,
0xceaf,0xceb0,0xceb1,0xceb2,0xceb3,0xceb4,0xceb5,0xceb6,
0xceb7,0xceb8,0xceb9,0xceba,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xcebb,0xcebc,0xcebd,0xcebe,0xcebf,0xcec0,
0xcec2,0xcec3,0xcec4,0xcec5,0xcec6,0xcec7,0xcec8,0xcec9,
0xceca,0xcecb,0xcecc,0xcecd,0xcece,0xcecf,0xced0,0xced1,
0xced2,0xced3,0xced4,0xced5,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xced6,0xced7,0xced8,0xced9,0xceda,0xcedb,
0xcedc,0xcedd,0xcede,0xcedf,0xcee0,0xcee1,0xcee2,0xcee3,
0xcee6,0xcee7,0xcee9,0xceea,0xceed,0xceee,0xceef,0xcef0,
0xcef1,0xcef2,0xcef3,0xcef6,0xcefa,0xcefb,0xcefc,0xcefd,
0xcefe,0xceff,0xac00,0xac01,0xac04,0xac07,0xac08,0xac09,
0xac0a,0xac10,0xac11,0xac12,0xac13,0xac14,0xac15,0xac16,
0xac17,0xac19,0xac1a,0xac1b,0xac1c,0xac1d,0xac20,0xac24,
0xac2c,0xac2d,0xac2f,0xac30,0xac31,0xac38,0xac39,0xac3c,
0xac40,0xac4b,0xac4d,0xac54,0xac58,0xac5c,0xac70,0xac71,
0xac74,0xac77,0xac78,0xac7a,0xac80,0xac81,0xac83,0xac84,
0xac85,0xac86,0xac89,0xac8a,0xac8b,0xac8c,0xac90,0xac94,
0xac9c,0xac9d,0xac9f,0xaca0,0xaca1,0xaca8,0xaca9,0xacaa,
0xacac,0xacaf,0xacb0,0xacb8,0xacb9,0xacbb,0xacbc,0xacbd,
0xacc1,0xacc4,0xacc8,0xaccc,0xacd5,0xacd7,0xace0,0xace1,
0xace4,0xace7,0xace8,0xacea,0xacec,0xacef,0xacf0,0xacf1,
0xacf3,0xacf5,0xacf6,0xacfc,0xacfd,0xad00,0xad04,0xad06,
0xcf02,0xcf03,0xcf05,0xcf06,0xcf07,0xcf09,0xcf0a,0xcf0b,
0xcf0c,0xcf0d,0xcf0e,0xcf0f,0xcf12,0xcf14,0xcf16,0xcf17,
0xcf18,0xcf19,0xcf1a,0xcf1b,0xcf1d,0xcf1e,0xcf1f,0xcf21,
0xcf22,0xcf23,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xcf25,0xcf26,0xcf27,0xcf28,0xcf29,0xcf2a,0xcf2b,0xcf2e,
0xcf32,0xcf33,0xcf34,0xcf35,0xcf36,0xcf37,0xcf39,0xcf3a,
0xcf3b,0xcf3c,0xcf3d,0xcf3e,0xcf3f,0xcf40,0xcf41,0xcf42,
0xcf43,0xcf44,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xcf45,0xcf46,0xcf47,0xcf48,0xcf49,0xcf4a,0xcf4b,0xcf4c,
0xcf4d,0xcf4e,0xcf4f,0xcf50,0xcf51,0xcf52,0xcf53,0xcf56,
0xcf57,0xcf59,0xcf5a,0xcf5b,0xcf5d,0xcf5e,0xcf5f,0xcf60,
0xcf61,0xcf62,0xcf63,0xcf66,0xcf68,0xcf6a,0xcf6b,0xcf6c,
0xad0c,0xad0d,0xad0f,0xad11,0xad18,0xad1c,0xad20,0xad29,
0xad2c,0xad2d,0xad34,0xad35,0xad38,0xad3c,0xad44,0xad45,
0xad47,0xad49,0xad50,0xad54,0xad58,0xad61,0xad63,0xad6c,
0xad6d,0xad70,0xad73,0xad74,0xad75,0xad76,0xad7b,0xad7c,
0xad7d,0xad7f,0xad81,0xad82,0xad88,0xad89,0xad8c,0xad90,
0xad9c,0xad9d,0xada4,0xadb7,0xadc0,0xadc1,0xadc4,0xadc8,
0xadd0,0xadd1,0xadd3,0xaddc,0xade0,0xade4,0xadf8,0xadf9,
0xadfc,0xadff,0xae00,0xae01,0xae08,0xae09,0xae0b,0xae0d,
0xae14,0xae30,0xae31,0xae34,0xae37,0xae38,0xae3a,0xae40,
0xae41,0xae43,0xae45,0xae46,0xae4a,0xae4c,0xae4d,0xae4e,
0xae50,0xae54,0xae56,0xae5c,0xae5d,0xae5f,0xae60,0xae61,
0xae65,0xae68,0xae69,0xae6c,0xae70,0xae78,0xcf6d,0xcf6e,
0xcf6f,0xcf72,0xcf73,0xcf75,0xcf76,0xcf77,0xcf79,0xcf7a,
0xcf7b,0xcf7c,0xcf7d,0xcf7e,0xcf7f,0xcf81,0xcf82,0xcf83,
0xcf84,0xcf86,0xcf87,0xcf88,0xcf89,0xcf8a,0xcf8b,0xcf8d,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcf8e,0xcf8f,
0xcf90,0xcf91,0xcf92,0xcf93,0xcf94,0xcf95,0xcf96,0xcf97,
0xcf98,0xcf99,0xcf9a,0xcf9b,0xcf9c,0xcf9d,0xcf9e,0xcf9f,
0xcfa0,0xcfa2,0xcfa3,0xcfa4,0xcfa5,0xcfa6,0xcfa7,0xcfa9,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcfaa,0xcfab,
0xcfac,0xcfad,0xcfae,0xcfaf,0xcfb1,0xcfb2,0xcfb3,0xcfb4,
0xcfb5,0xcfb6,0xcfb7,0xcfb8,0xcfb9,0xcfba,0xcfbb,0xcfbc,
0xcfbd,0xcfbe,0xcfbf,0xcfc0,0xcfc1,0xcfc2,0xcfc3,0xcfc5,
0xcfc6,0xcfc7,0xcfc8,0xcfc9,0xcfca,0xcfcb,0xae79,0xae7b,
0xae7c,0xae7d,0xae84,0xae85,0xae8c,0xaebc,0xaebd,0xaebe,
0xaec0,0xaec4,0xaecc,0xaecd,0xaecf,0xaed0,0xaed1,0xaed8,
0xaed9,0xaedc,0xaee8,0xaeeb,0xaeed,0xaef4,0xaef8,0xaefc,
0xaf07,0xaf08,0xaf0d,0xaf10,0xaf2c,0xaf2d,0xaf30,0xaf32,
0xaf34,0xaf3c,0xaf3d,0xaf3f,0xaf41,0xaf42,0xaf43,0xaf48,
0xaf49,0xaf50,0xaf5c,0xaf5d,0xaf64,0xaf65,0xaf79,0xaf80,
0xaf84,0xaf88,0xaf90,0xaf91,0xaf95,0xaf9c,0xafb8,0xafb9,
0xafbc,0xafc0,0xafc7,0xafc8,0xafc9,0xafcb,0xafcd,0xafce,
0xafd4,0xafdc,0xafe8,0xafe9,0xaff0,0xaff1,0xaff4,0xaff8,
0xb000,0xb001,0xb004,0xb00c,0xb010,0xb014,0xb01c,0xb01d,
0xb028,0xb044,0xb045,0xb048,0xb04a,0xb04c,0xb04e,0xb053,
0xb054,0xb055,0xb057,0xb059,0xcfcc,0xcfcd,0xcfce,0xcfcf,
0xcfd0,0xcfd1,0xcfd2,0xcfd3,0xcfd4,0xcfd5,0xcfd6,0xcfd7,
0xcfd8,0xcfd9,0xcfda,0xcfdb,0xcfdc,0xcfdd,0xcfde,0xcfdf,
0xcfe2,0xcfe3,0xcfe5,0xcfe6,0xcfe7,0xcfe9,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xcfea,0xcfeb,0xcfec,0xcfed,
0xcfee,0xcfef,0xcff2,0xcff4,0xcff6,0xcff7,0xcff8,0xcff9,
0xcffa,0xcffb,0xcffd,0xcffe,0xcfff,0xd001,0xd002,0xd003,
0xd005,0xd006,0xd007,0xd008,0xd009,0xd00a,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xd00b,0xd00c,0xd00d,0xd00e,
0xd00f,0xd010,0xd012,0xd013,0xd014,0xd015,0xd016,0xd017,
0xd019,0xd01a,0xd01b,0xd01c,0xd01d,0xd01e,0xd01f,0xd020,
0xd021,0xd022,0xd023,0xd024,0xd025,0xd026,0xd027,0xd028,
0xd029,0xd02a,0xd02b,0xd02c,0xb05d,0xb07c,0xb07d,0xb080,
0xb084,0xb08c,0xb08d,0xb08f,0xb091,0xb098,0xb099,0xb09a,
0xb09c,0xb09f,0xb0a0,0xb0a1,0xb0a2,0xb0a8,0xb0a9,0xb0ab,
0xb0ac,0xb0ad,0xb0ae,0xb0af,0xb0b1,0xb0b3,0xb0b4,0xb0b5,
0xb0b8,0xb0bc,0xb0c4,0xb0c5,0xb0c7,0xb0c8,0xb0c9,0xb0d0,
0xb0d1,0xb0d4,0xb0d8,0xb0e0,0xb0e5,0xb108,0xb109,0xb10b,
0xb10c,0xb110,0xb112,0xb113,0xb118,0xb119,0xb11b,0xb11c,
0xb11d,0xb123,0xb124,0xb125,0xb128,0xb12c,0xb134,0xb135,
0xb137,0xb138,0xb139,0xb140,0xb141,0xb144,0xb148,0xb150,
0xb151,0xb154,0xb155,0xb158,0xb15c,0xb160,0xb178,0xb179,
0xb17c,0xb180,0xb182,0xb188,0xb189,0xb18b,0xb18d,0xb192,
0xb193,0xb194,0xb198,0xb19c,0xb1a8,0xb1cc,0xb1d0,0xb1d4,
0xb1dc,0xb1dd,0xd02e,0xd02f,0xd030,0xd031,0xd032,0xd033,
0xd036,0xd037,0xd039,0xd03a,0xd03b,0xd03d,0xd03e,0xd03f,
0xd040,0xd041,0xd042,0xd043,0xd046,0xd048,0xd04a,0xd04b,
0xd04c,0xd04d,0xd04e,0xd04f,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd051,0xd052,0xd053,0xd055,0xd056,0xd057,
0xd059,0xd05a,0xd05b,0xd05c,0xd05d,0xd05e,0xd05f,0xd061,
0xd062,0xd063,0xd064,0xd065,0xd066,0xd067,0xd068,0xd069,
0xd06a,0xd06b,0xd06e,0xd06f,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd071,0xd072,0xd073,0xd075,0xd076,0xd077,
0xd078,0xd079,0xd07a,0xd07b,0xd07e,0xd07f,0xd080,0xd082,
0xd083,0xd084,0xd085,0xd086,0xd087,0xd088,0xd089,0xd08a,
0xd08b,0xd08c,0xd08d,0xd08e,0xd08f,0xd090,0xd091,0xd092,
0xd093,0xd094,0xb1df,0xb1e8,0xb1e9,0xb1ec,0xb1f0,0xb1f9,
0xb1fb,0xb1fd,0xb204,0xb205,0xb208,0xb20b,0xb20c,0xb214,
0xb215,0xb217,0xb219,0xb220,0xb234,0xb23c,0xb258,0xb25c,
0xb260,0xb268,0xb269,0xb274,0xb275,0xb27c,0xb284,0xb285,
0xb289,0xb290,0xb291,0xb294,0xb298,0xb299,0xb29a,0xb2a0,
0xb2a1,0xb2a3,0xb2a5,0xb2a6,0xb2aa,0xb2ac,0xb2b0,0xb2b4,
0xb2c8,0xb2c9,0xb2cc,0xb2d0,0xb2d2,0xb2d8,0xb2d9,0xb2db,
0xb2dd,0xb2e2,0xb2e4,0xb2e5,0xb2e6,0xb2e8,0xb2eb,0xb2ec,
0xb2ed,0xb2ee,0xb2ef,0xb2f3,0xb2f4,0xb2f5,0xb2f7,0xb2f8,
0xb2f9,0xb2fa,0xb2fb,0xb2ff,0xb300,0xb301,0xb304,0xb308,
0xb310,0xb311,0xb313,0xb314,0xb315,0xb31c,0xb354,0xb355,
0xb356,0xb358,0xb35b,0xb35c,0xb35e,0xb35f,0xb364,0xb365,
0xd095,0xd096,0xd097,0xd098,0xd099,0xd09a,0xd09b,0xd09c,
0xd09d,0xd09e,0xd09f,0xd0a0,0xd0a1,0xd0a2,0xd0a3,0xd0a6,
0xd0a7,0xd0a9,0xd0aa,0xd0ab,0xd0ad,0xd0ae,0xd0af,0xd0b0,
0xd0b1,0xd0b2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd0b3,0xd0b6,0xd0b8,0xd0ba,0xd0bb,0xd0bc,0xd0bd,0xd0be,
0xd0bf,0xd0c2,0xd0c3,0xd0c5,0xd0c6,0xd0c7,0xd0ca,0xd0cb,
0xd0cc,0xd0cd,0xd0ce,0xd0cf,0xd0d2,0xd0d6,0xd0d7,0xd0d8,
0xd0d9,0xd0da,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd0db,0xd0de,0xd0df,0xd0e1,0xd0e2,0xd0e3,0xd0e5,0xd0e6,
0xd0e7,0xd0e8,0xd0e9,0xd0ea,0xd0eb,0xd0ee,0xd0f2,0xd0f3,
0xd0f4,0xd0f5,0xd0f6,0xd0f7,0xd0f9,0xd0fa,0xd0fb,0xd0fc,
0xd0fd,0xd0fe,0xd0ff,0xd100,0xd101,0xd102,0xd103,0xd104,
0xb367,0xb369,0xb36b,0xb36e,0xb370,0xb371,0xb374,0xb378,
0xb380,0xb381,0xb383,0xb384,0xb385,0xb38c,0xb390,0xb394,
0xb3a0,0xb3a1,0xb3a8,0xb3ac,0xb3c4,0xb3c5,0xb3c8,0xb3cb,
0xb3cc,0xb3ce,0xb3d0,0xb3d4,0xb3d5,0xb3d7,0xb3d9,0xb3db,
0xb3dd,0xb3e0,0xb3e4,0xb3e8,0xb3fc,0xb410,0xb418,0xb41c,
0xb420,0xb428,0xb429,0xb42b,0xb434,0xb450,0xb451,0xb454,
0xb458,0xb460,0xb461,0xb463,0xb465,0xb46c,0xb480,0xb488,
0xb49d,0xb4a4,0xb4a8,0xb4ac,0xb4b5,0xb4b7,0xb4b9,0xb4c0,
0xb4c4,0xb4c8,0xb4d0,0xb4d5,0xb4dc,0xb4dd,0xb4e0,0xb4e3,
0xb4e4,0xb4e6,0xb4ec,0xb4ed,0xb4ef,0xb4f1,0xb4f8,0xb514,
0xb515,0xb518,0xb51b,0xb51c,0xb524,0xb525,0xb527,0xb528,
0xb529,0xb52a,0xb530,0xb531,0xb534,0xb538,0xd105,0xd106,
0xd107,0xd108,0xd109,0xd10a,0xd10b,0xd10c,0xd10e,0xd10f,
0xd110,0xd111,0xd112,0xd113,0xd114,0xd115,0xd116,0xd117,
0xd118,0xd119,0xd11a,0xd11b,0xd11c,0xd11d,0xd11e,0xd11f,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd120,0xd121,
0xd122,0xd123,0xd124,0xd125,0xd126,0xd127,0xd128,0xd129,
0xd12a,0xd12b,0xd12c,0xd12d,0xd12e,0xd12f,0xd132,0xd133,
0xd135,0xd136,0xd137,0xd139,0xd13b,0xd13c,0xd13d,0xd13e,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd13f,0xd142,
0xd146,0xd147,0xd148,0xd149,0xd14a,0xd14b,0xd14e,0xd14f,
0xd151,0xd152,0xd153,0xd155,0xd156,0xd157,0xd158,0xd159,
0xd15a,0xd15b,0xd15e,0xd160,0xd162,0xd163,0xd164,0xd165,
0xd166,0xd167,0xd169,0xd16a,0xd16b,0xd16d,0xb540,0xb541,
0xb543,0xb544,0xb545,0xb54b,0xb54c,0xb54d,0xb550,0xb554,
0xb55c,0xb55d,0xb55f,0xb560,0xb561,0xb5a0,0xb5a1,0xb5a4,
0xb5a8,0xb5aa,0xb5ab,0xb5b0,0xb5b1,0xb5b3,0xb5b4,0xb5b5,
0xb5bb,0xb5bc,0xb5bd,0xb5c0,0xb5c4,0xb5cc,0xb5cd,0xb5cf,
0xb5d0,0xb5d1,0xb5d8,0xb5ec,0xb610,0xb611,0xb614,0xb618,
0xb625,0xb62c,0xb634,0xb648,0xb664,0xb668,0xb69c,0xb69d,
0xb6a0,0xb6a4,0xb6ab,0xb6ac,0xb6b1,0xb6d4,0xb6f0,0xb6f4,
0xb6f8,0xb700,0xb701,0xb705,0xb728,0xb729,0xb72c,0xb72f,
0xb730,0xb738,0xb739,0xb73b,0xb744,0xb748,0xb74c,0xb754,
0xb755,0xb760,0xb764,0xb768,0xb770,0xb771,0xb773,0xb775,
0xb77c,0xb77d,0xb780,0xb784,0xb78c,0xb78d,0xb78f,0xb790,
0xb791,0xb792,0xb796,0xb797,0xd16e,0xd16f,0xd170,0xd171,
0xd172,0xd173,0xd174,0xd175,0xd176,0xd177,0xd178,0xd179,
0xd17a,0xd17b,0xd17d,0xd17e,0xd17f,0xd180,0xd181,0xd182,
0xd183,0xd185,0xd186,0xd187,0xd189,0xd18a,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xd18b,0xd18c,0xd18d,0xd18e,
0xd18f,0xd190,0xd191,0xd192,0xd193,0xd194,0xd195,0xd196,
0xd197,0xd198,0xd199,0xd19a,0xd19b,0xd19c,0xd19d,0xd19e,
0xd19f,0xd1a2,0xd1a3,0xd1a5,0xd1a6,0xd1a7,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xd1a9,0xd1aa,0xd1ab,0xd1ac,
0xd1ad,0xd1ae,0xd1af,0xd1b2,0xd1b4,0xd1b6,0xd1b7,0xd1b8,
0xd1b9,0xd1bb,0xd1bd,0xd1be,0xd1bf,0xd1c1,0xd1c2,0xd1c3,
0xd1c4,0xd1c5,0xd1c6,0xd1c7,0xd1c8,0xd1c9,0xd1ca,0xd1cb,
0xd1cc,0xd1cd,0xd1ce,0xd1cf,0xb798,0xb799,0xb79c,0xb7a0,
0xb7a8,0xb7a9,0xb7ab,0xb7ac,0xb7ad,0xb7b4,0xb7b5,0xb7b8,
0xb7c7,0xb7c9,0xb7ec,0xb7ed,0xb7f0,0xb7f4,0xb7fc,0xb7fd,
0xb7ff,0xb800,0xb801,0xb807,0xb808,0xb809,0xb80c,0xb810,
0xb818,0xb819,0xb81b,0xb81d,0xb824,0xb825,0xb828,0xb82c,
0xb834,0xb835,0xb837,0xb838,0xb839,0xb840,0xb844,0xb851,
0xb853,0xb85c,0xb85d,0xb860,0xb864,0xb86c,0xb86d,0xb86f,
0xb871,0xb878,0xb87c,0xb88d,0xb8a8,0xb8b0,0xb8b4,0xb8b8,
0xb8c0,0xb8c1,0xb8c3,0xb8c5,0xb8cc,0xb8d0,0xb8d4,0xb8dd,
0xb8df,0xb8e1,0xb8e8,0xb8e9,0xb8ec,0xb8f0,0xb8f8,0xb8f9,
0xb8fb,0xb8fd,0xb904,0xb918,0xb920,0xb93c,0xb93d,0xb940,
0xb944,0xb94c,0xb94f,0xb951,0xb958,0xb959,0xb95c,0xb960,
0xb968,0xb969,0xd1d0,0xd1d1,0xd1d2,0xd1d3,0xd1d4,0xd1d5,
0xd1d6,0xd1d7,0xd1d9,0xd1da,0xd1db,0xd1dc,0xd1dd,0xd1de,
0xd1df,0xd1e0,0xd1e1,0xd1e2,0xd1e3,0xd1e4,0xd1e5,0xd1e6,
0xd1e7,0xd1e8,0xd1e9,0xd1ea,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd1eb,0xd1ec,0xd1ed,0xd1ee,0xd1ef,0xd1f0,
0xd1f1,0xd1f2,0xd1f3,0xd1f5,0xd1f6,0xd1f7,0xd1f9,0xd1fa,
0xd1fb,0xd1fc,0xd1fd,0xd1fe,0xd1ff,0xd200,0xd201,0xd202,
0xd203,0xd204,0xd205,0xd206,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd208,0xd20a,0xd20b,0xd20c,0xd20d,0xd20e,
0xd20f,0xd211,0xd212,0xd213,0xd214,0xd215,0xd216,0xd217,
0xd218,0xd219,0xd21a,0xd21b,0xd21c,0xd21d,0xd21e,0xd21f,
0xd220,0xd221,0xd222,0xd223,0xd224,0xd225,0xd226,0xd227,
0xd228,0xd229,0xb96b,0xb96d,0xb974,0xb975,0xb978,0xb97c,
0xb984,0xb985,0xb987,0xb989,0xb98a,0xb98d,0xb98e,0xb9ac,
0xb9ad,0xb9b0,0xb9b4,0xb9bc,0xb9bd,0xb9bf,0xb9c1,0xb9c8,
0xb9c9,0xb9cc,0xb9ce,0xb9cf,0xb9d0,0xb9d1,0xb9d2,0xb9d8,
0xb9d9,0xb9db,0xb9dd,0xb9de,0xb9e1,0xb9e3,0xb9e4,0xb9e5,
0xb9e8,0xb9ec,0xb9f4,0xb9f5,0xb9f7,0xb9f8,0xb9f9,0xb9fa,
0xba00,0xba01,0xba08,0xba15,0xba38,0xba39,0xba3c,0xba40,
0xba42,0xba48,0xba49,0xba4b,0xba4d,0xba4e,0xba53,0xba54,
0xba55,0xba58,0xba5c,0xba64,0xba65,0xba67,0xba68,0xba69,
0xba70,0xba71,0xba74,0xba78,0xba83,0xba84,0xba85,0xba87,
0xba8c,0xbaa8,0xbaa9,0xbaab,0xbaac,0xbab0,0xbab2,0xbab8,
0xbab9,0xbabb,0xbabd,0xbac4,0xbac8,0xbad8,0xbad9,0xbafc,
0xd22a,0xd22b,0xd22e,0xd22f,0xd231,0xd232,0xd233,0xd235,
0xd236,0xd237,0xd238,0xd239,0xd23a,0xd23b,0xd23e,0xd240,
0xd242,0xd243,0xd244,0xd245,0xd246,0xd247,0xd249,0xd24a,
0xd24b,0xd24c,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd24d,0xd24e,0xd24f,0xd250,0xd251,0xd252,0xd253,0xd254,
0xd255,0xd256,0xd257,0xd258,0xd259,0xd25a,0xd25b,0xd25d,
0xd25e,0xd25f,0xd260,0xd261,0xd262,0xd263,0xd265,0xd266,
0xd267,0xd268,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd269,0xd26a,0xd26b,0xd26c,0xd26d,0xd26e,0xd26f,0xd270,
0xd271,0xd272,0xd273,0xd274,0xd275,0xd276,0xd277,0xd278,
0xd279,0xd27a,0xd27b,0xd27c,0xd27d,0xd27e,0xd27f,0xd282,
0xd283,0xd285,0xd286,0xd287,0xd289,0xd28a,0xd28b,0xd28c,
0xbb00,0xbb04,0xbb0d,0xbb0f,0xbb11,0xbb18,0xbb1c,0xbb20,
0xbb29,0xbb2b,0xbb34,0xbb35,0xbb36,0xbb38,0xbb3b,0xbb3c,
0xbb3d,0xbb3e,0xbb44,0xbb45,0xbb47,0xbb49,0xbb4d,0xbb4f,
0xbb50,0xbb54,0xbb58,0xbb61,0xbb63,0xbb6c,0xbb88,0xbb8c,
0xbb90,0xbba4,0xbba8,0xbbac,0xbbb4,0xbbb7,0xbbc0,0xbbc4,
0xbbc8,0xbbd0,0xbbd3,0xbbf8,0xbbf9,0xbbfc,0xbbff,0xbc00,
0xbc02,0xbc08,0xbc09,0xbc0b,0xbc0c,0xbc0d,0xbc0f,0xbc11,
0xbc14,0xbc15,0xbc16,0xbc17,0xbc18,0xbc1b,0xbc1c,0xbc1d,
0xbc1e,0xbc1f,0xbc24,0xbc25,0xbc27,0xbc29,0xbc2d,0xbc30,
0xbc31,0xbc34,0xbc38,0xbc40,0xbc41,0xbc43,0xbc44,0xbc45,
0xbc49,0xbc4c,0xbc4d,0xbc50,0xbc5d,0xbc84,0xbc85,0xbc88,
0xbc8b,0xbc8c,0xbc8e,0xbc94,0xbc95,0xbc97,0xd28d,0xd28e,
0xd28f,0xd292,0xd293,0xd294,0xd296,0xd297,0xd298,0xd299,
0xd29a,0xd29b,0xd29d,0xd29e,0xd29f,0xd2a1,0xd2a2,0xd2a3,
0xd2a5,0xd2a6,0xd2a7,0xd2a8,0xd2a9,0xd2aa,0xd2ab,0xd2ad,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd2ae,0xd2af,
0xd2b0,0xd2b2,0xd2b3,0xd2b4,0xd2b5,0xd2b6,0xd2b7,0xd2ba,
0xd2bb,0xd2bd,0xd2be,0xd2c1,0xd2c3,0xd2c4,0xd2c5,0xd2c6,
0xd2c7,0xd2ca,0xd2cc,0xd2cd,0xd2ce,0xd2cf,0xd2d0,0xd2d1,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd2d2,0xd2d3,
0xd2d5,0xd2d6,0xd2d7,0xd2d9,0xd2da,0xd2db,0xd2dd,0xd2de,
0xd2df,0xd2e0,0xd2e1,0xd2e2,0xd2e3,0xd2e6,0xd2e7,0xd2e8,
0xd2e9,0xd2ea,0xd2eb,0xd2ec,0xd2ed,0xd2ee,0xd2ef,0xd2f2,
0xd2f3,0xd2f5,0xd2f6,0xd2f7,0xd2f9,0xd2fa,0xbc99,0xbc9a,
0xbca0,0xbca1,0xbca4,0xbca7,0xbca8,0xbcb0,0xbcb1,0xbcb3,
0xbcb4,0xbcb5,0xbcbc,0xbcbd,0xbcc0,0xbcc4,0xbccd,0xbccf,
0xbcd0,0xbcd1,0xbcd5,0xbcd8,0xbcdc,0xbcf4,0xbcf5,0xbcf6,
0xbcf8,0xbcfc,0xbd04,0xbd05,0xbd07,0xbd09,0xbd10,0xbd14,
0xbd24,0xbd2c,0xbd40,0xbd48,0xbd49,0xbd4c,0xbd50,0xbd58,
0xbd59,0xbd64,0xbd68,0xbd80,0xbd81,0xbd84,0xbd87,0xbd88,
0xbd89,0xbd8a,0xbd90,0xbd91,0xbd93,0xbd95,0xbd99,0xbd9a,
0xbd9c,0xbda4,0xbdb0,0xbdb8,0xbdd4,0xbdd5,0xbdd8,0xbddc,
0xbde9,0xbdf0,0xbdf4,0xbdf8,0xbe00,0xbe03,0xbe05,0xbe0c,
0xbe0d,0xbe10,0xbe14,0xbe1c,0xbe1d,0xbe1f,0xbe44,0xbe45,
0xbe48,0xbe4c,0xbe4e,0xbe54,0xbe55,0xbe57,0xbe59,0xbe5a,
0xbe5b,0xbe60,0xbe61,0xbe64,0xd2fb,0xd2fc,0xd2fd,0xd2fe,
0xd2ff,0xd302,0xd304,0xd306,0xd307,0xd308,0xd309,0xd30a,
0xd30b,0xd30f,0xd311,0xd312,0xd313,0xd315,0xd317,0xd318,
0xd319,0xd31a,0xd31b,0xd31e,0xd322,0xd323,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xd324,0xd326,0xd327,0xd32a,
0xd32b,0xd32d,0xd32e,0xd32f,0xd331,0xd332,0xd333,0xd334,
0xd335,0xd336,0xd337,0xd33a,0xd33e,0xd33f,0xd340,0xd341,
0xd342,0xd343,0xd346,0xd347,0xd348,0xd349,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xd34a,0xd34b,0xd34c,0xd34d,
0xd34e,0xd34f,0xd350,0xd351,0xd352,0xd353,0xd354,0xd355,
0xd356,0xd357,0xd358,0xd359,0xd35a,0xd35b,0xd35c,0xd35d,
0xd35e,0xd35f,0xd360,0xd361,0xd362,0xd363,0xd364,0xd365,
0xd366,0xd367,0xd368,0xd369,0xbe68,0xbe6a,0xbe70,0xbe71,
0xbe73,0xbe74,0xbe75,0xbe7b,0xbe7c,0xbe7d,0xbe80,0xbe84,
0xbe8c,0xbe8d,0xbe8f,0xbe90,0xbe91,0xbe98,0xbe99,0xbea8,
0xbed0,0xbed1,0xbed4,0xbed7,0xbed8,0xbee0,0xbee3,0xbee4,
0xbee5,0xbeec,0xbf01,0xbf08,0xbf09,0xbf18,0xbf19,0xbf1b,
0xbf1c,0xbf1d,0xbf40,0xbf41,0xbf44,0xbf48,0xbf50,0xbf51,
0xbf55,0xbf94,0xbfb0,0xbfc5,0xbfcc,0xbfcd,0xbfd0,0xbfd4,
0xbfdc,0xbfdf,0xbfe1,0xc03c,0xc051,0xc058,0xc05c,0xc060,
0xc068,0xc069,0xc090,0xc091,0xc094,0xc098,0xc0a0,0xc0a1,
0xc0a3,0xc0a5,0xc0ac,0xc0ad,0xc0af,0xc0b0,0xc0b3,0xc0b4,
0xc0b5,0xc0b6,0xc0bc,0xc0bd,0xc0bf,0xc0c0,0xc0c1,0xc0c5,
0xc0c8,0xc0c9,0xc0cc,0xc0d0,0xc0d8,0xc0d9,0xc0db,0xc0dc,
0xc0dd,0xc0e4,0xd36a,0xd36b,0xd36c,0xd36d,0xd36e,0xd36f,
0xd370,0xd371,0xd372,0xd373,0xd374,0xd375,0xd376,0xd377,
0xd378,0xd379,0xd37a,0xd37b,0xd37e,0xd37f,0xd381,0xd382,
0xd383,0xd385,0xd386,0xd387,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd388,0xd389,0xd38a,0xd38b,0xd38e,0xd392,
0xd393,0xd394,0xd395,0xd396,0xd397,0xd39a,0xd39b,0xd39d,
0xd39e,0xd39f,0xd3a1,0xd3a2,0xd3a3,0xd3a4,0xd3a5,0xd3a6,
0xd3a7,0xd3aa,0xd3ac,0xd3ae,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd3af,0xd3b0,0xd3b1,0xd3b2,0xd3b3,0xd3b5,
0xd3b6,0xd3b7,0xd3b9,0xd3ba,0xd3bb,0xd3bd,0xd3be,0xd3bf,
0xd3c0,0xd3c1,0xd3c2,0xd3c3,0xd3c6,0xd3c7,0xd3ca,0xd3cb,
0xd3cc,0xd3cd,0xd3ce,0xd3cf,0xd3d1,0xd3d2,0xd3d3,0xd3d4,
0xd3d5,0xd3d6,0xc0e5,0xc0e8,0xc0ec,0xc0f4,0xc0f5,0xc0f7,
0xc0f9,0xc100,0xc104,0xc108,0xc110,0xc115,0xc11c,0xc11d,
0xc11e,0xc11f,0xc120,0xc123,0xc124,0xc126,0xc127,0xc12c,
0xc12d,0xc12f,0xc130,0xc131,0xc136,0xc138,0xc139,0xc13c,
0xc140,0xc148,0xc149,0xc14b,0xc14c,0xc14d,0xc154,0xc155,
0xc158,0xc15c,0xc164,0xc165,0xc167,0xc168,0xc169,0xc170,
0xc174,0xc178,0xc185,0xc18c,0xc18d,0xc18e,0xc190,0xc194,
0xc196,0xc19c,0xc19d,0xc19f,0xc1a1,0xc1a5,0xc1a8,0xc1a9,
0xc1ac,0xc1b0,0xc1bd,0xc1c4,0xc1c8,0xc1cc,0xc1d4,0xc1d7,
0xc1d8,0xc1e0,0xc1e4,0xc1e8,0xc1f0,0xc1f1,0xc1f3,0xc1fc,
0xc1fd,0xc200,0xc204,0xc20c,0xc20d,0xc20f,0xc211,0xc218,
0xc219,0xc21c,0xc21f,0xc220,0xc228,0xc229,0xc22b,0xc22d,
0xd3d7,0xd3d9,0xd3da,0xd3db,0xd3dc,0xd3dd,0xd3de,0xd3df,
0xd3e0,0xd3e2,0xd3e4,0xd3e5,0xd3e6,0xd3e7,0xd3e8,0xd3e9,
0xd3ea,0xd3eb,0xd3ee,0xd3ef,0xd3f1,0xd3f2,0xd3f3,0xd3f5,
0xd3f6,0xd3f7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd3f8,0xd3f9,0xd3fa,0xd3fb,0xd3fe,0xd400,0xd402,0xd403,
0xd404,0xd405,0xd406,0xd407,0xd409,0xd40a,0xd40b,0xd40c,
0xd40d,0xd40e,0xd40f,0xd410,0xd411,0xd412,0xd413,0xd414,
0xd415,0xd416,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd417,0xd418,0xd419,0xd41a,0xd41b,0xd41c,0xd41e,0xd41f,
0xd420,0xd421,0xd422,0xd423,0xd424,0xd425,0xd426,0xd427,
0xd428,0xd429,0xd42a,0xd42b,0xd42c,0xd42d,0xd42e,0xd42f,
0xd430,0xd431,0xd432,0xd433,0xd434,0xd435,0xd436,0xd437,
0xc22f,0xc231,0xc232,0xc234,0xc248,0xc250,0xc251,0xc254,
0xc258,0xc260,0xc265,0xc26c,0xc26d,0xc270,0xc274,0xc27c,
0xc27d,0xc27f,0xc281,0xc288,0xc289,0xc290,0xc298,0xc29b,
0xc29d,0xc2a4,0xc2a5,0xc2a8,0xc2ac,0xc2ad,0xc2b4,0xc2b5,
0xc2b7,0xc2b9,0xc2dc,0xc2dd,0xc2e0,0xc2e3,0xc2e4,0xc2eb,
0xc2ec,0xc2ed,0xc2ef,0xc2f1,0xc2f6,0xc2f8,0xc2f9,0xc2fb,
0xc2fc,0xc300,0xc308,0xc309,0xc30c,0xc30d,0xc313,0xc314,
0xc315,0xc318,0xc31c,0xc324,0xc325,0xc328,0xc329,0xc345,
0xc368,0xc369,0xc36c,0xc370,0xc372,0xc378,0xc379,0xc37c,
0xc37d,0xc384,0xc388,0xc38c,0xc3c0,0xc3d8,0xc3d9,0xc3dc,
0xc3df,0xc3e0,0xc3e2,0xc3e8,0xc3e9,0xc3ed,0xc3f4,0xc3f5,
0xc3f8,0xc408,0xc410,0xc424,0xc42c,0xc430,0xd438,0xd439,
0xd43a,0xd43b,0xd43c,0xd43d,0xd43e,0xd43f,0xd441,0xd442,
0xd443,0xd445,0xd446,0xd447,0xd448,0xd449,0xd44a,0xd44b,
0xd44c,0xd44d,0xd44e,0xd44f,0xd450,0xd451,0xd452,0xd453,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd454,0xd455,
0xd456,0xd457,0xd458,0xd459,0xd45a,0xd45b,0xd45d,0xd45e,
0xd45f,0xd461,0xd462,0xd463,0xd465,0xd466,0xd467,0xd468,
0xd469,0xd46a,0xd46b,0xd46c,0xd46e,0xd470,0xd471,0xd472,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd473,0xd474,
0xd475,0xd476,0xd477,0xd47a,0xd47b,0xd47d,0xd47e,0xd481,
0xd483,0xd484,0xd485,0xd486,0xd487,0xd48a,0xd48c,0xd48e,
0xd48f,0xd490,0xd491,0xd492,0xd493,0xd495,0xd496,0xd497,
0xd498,0xd499,0xd49a,0xd49b,0xd49c,0xd49d,0xc434,0xc43c,
0xc43d,0xc448,0xc464,0xc465,0xc468,0xc46c,0xc474,0xc475,
0xc479,0xc480,0xc494,0xc49c,0xc4b8,0xc4bc,0xc4e9,0xc4f0,
0xc4f1,0xc4f4,0xc4f8,0xc4fa,0xc4ff,0xc500,0xc501,0xc50c,
0xc510,0xc514,0xc51c,0xc528,0xc529,0xc52c,0xc530,0xc538,
0xc539,0xc53b,0xc53d,0xc544,0xc545,0xc548,0xc549,0xc54a,
0xc54c,0xc54d,0xc54e,0xc553,0xc554,0xc555,0xc557,0xc558,
0xc559,0xc55d,0xc55e,0xc560,0xc561,0xc564,0xc568,0xc570,
0xc571,0xc573,0xc574,0xc575,0xc57c,0xc57d,0xc580,0xc584,
0xc587,0xc58c,0xc58d,0xc58f,0xc591,0xc595,0xc597,0xc598,
0xc59c,0xc5a0,0xc5a9,0xc5b4,0xc5b5,0xc5b8,0xc5b9,0xc5bb,
0xc5bc,0xc5bd,0xc5be,0xc5c4,0xc5c5,0xc5c6,0xc5c7,0xc5c8,
0xc5c9,0xc5ca,0xc5cc,0xc5ce,0xd49e,0xd49f,0xd4a0,0xd4a1,
0xd4a2,0xd4a3,0xd4a4,0xd4a5,0xd4a6,0xd4a7,0xd4a8,0xd4aa,
0xd4ab,0xd4ac,0xd4ad,0xd4ae,0xd4af,0xd4b0,0xd4b1,0xd4b2,
0xd4b3,0xd4b4,0xd4b5,0xd4b6,0xd4b7,0xd4b8,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xd4b9,0xd4ba,0xd4bb,0xd4bc,
0xd4bd,0xd4be,0xd4bf,0xd4c0,0xd4c1,0xd4c2,0xd4c3,0xd4c4,
0xd4c5,0xd4c6,0xd4c7,0xd4c8,0xd4c9,0xd4ca,0xd4cb,0xd4cd,
0xd4ce,0xd4cf,0xd4d1,0xd4d2,0xd4d3,0xd4d5,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xd4d6,0xd4d7,0xd4d8,0xd4d9,
0xd4da,0xd4db,0xd4dd,0xd4de,0xd4e0,0xd4e1,0xd4e2,0xd4e3,
0xd4e4,0xd4e5,0xd4e6,0xd4e7,0xd4e9,0xd4ea,0xd4eb,0xd4ed,
0xd4ee,0xd4ef,0xd4f1,0xd4f2,0xd4f3,0xd4f4,0xd4f5,0xd4f6,
0xd4f7,0xd4f9,0xd4fa,0xd4fc,0xc5d0,0xc5d1,0xc5d4,0xc5d8,
0xc5e0,0xc5e1,0xc5e3,0xc5e5,0xc5ec,0xc5ed,0xc5ee,0xc5f0,
0xc5f4,0xc5f6,0xc5f7,0xc5fc,0xc5fd,0xc5fe,0xc5ff,0xc600,
0xc601,0xc605,0xc606,0xc607,0xc608,0xc60c,0xc610,0xc618,
0xc619,0xc61b,0xc61c,0xc624,0xc625,0xc628,0xc62c,0xc62d,
0xc62e,0xc630,0xc633,0xc634,0xc635,0xc637,0xc639,0xc63b,
0xc640,0xc641,0xc644,0xc648,0xc650,0xc651,0xc653,0xc654,
0xc655,0xc65c,0xc65d,0xc660,0xc66c,0xc66f,0xc671,0xc678,
0xc679,0xc67c,0xc680,0xc688,0xc689,0xc68b,0xc68d,0xc694,
0xc695,0xc698,0xc69c,0xc6a4,0xc6a5,0xc6a7,0xc6a9,0xc6b0,
0xc6b1,0xc6b4,0xc6b8,0xc6b9,0xc6ba,0xc6c0,0xc6c1,0xc6c3,
0xc6c5,0xc6cc,0xc6cd,0xc6d0,0xc6d4,0xc6dc,0xc6dd,0xc6e0,
0xc6e1,0xc6e8,0xd4fe,0xd4ff,0xd500,0xd501,0xd502,0xd503,
0xd505,0xd506,0xd507,0xd509,0xd50a,0xd50b,0xd50d,0xd50e,
0xd50f,0xd510,0xd511,0xd512,0xd513,0xd516,0xd518,0xd519,
0xd51a,0xd51b,0xd51c,0xd51d,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd51e,0xd51f,0xd520,0xd521,0xd522,0xd523,
0xd524,0xd525,0xd526,0xd527,0xd528,0xd529,0xd52a,0xd52b,
0xd52c,0xd52d,0xd52e,0xd52f,0xd530,0xd531,0xd532,0xd533,
0xd534,0xd535,0xd536,0xd537,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd538,0xd539,0xd53a,0xd53b,0xd53e,0xd53f,
0xd541,0xd542,0xd543,0xd545,0xd546,0xd547,0xd548,0xd549,
0xd54a,0xd54b,0xd54e,0xd550,0xd552,0xd553,0xd554,0xd555,
0xd556,0xd557,0xd55a,0xd55b,0xd55d,0xd55e,0xd55f,0xd561,
0xd562,0xd563,0xc6e9,0xc6ec,0xc6f0,0xc6f8,0xc6f9,0xc6fd,
0xc704,0xc705,0xc708,0xc70c,0xc714,0xc715,0xc717,0xc719,
0xc720,0xc721,0xc724,0xc728,0xc730,0xc731,0xc733,0xc735,
0xc737,0xc73c,0xc73d,0xc740,0xc744,0xc74a,0xc74c,0xc74d,
0xc74f,0xc751,0xc752,0xc753,0xc754,0xc755,0xc756,0xc757,
0xc758,0xc75c,0xc760,0xc768,0xc76b,0xc774,0xc775,0xc778,
0xc77c,0xc77d,0xc77e,0xc783,0xc784,0xc785,0xc787,0xc788,
0xc789,0xc78a,0xc78e,0xc790,0xc791,0xc794,0xc796,0xc797,
0xc798,0xc79a,0xc7a0,0xc7a1,0xc7a3,0xc7a4,0xc7a5,0xc7a6,
0xc7ac,0xc7ad,0xc7b0,0xc7b4,0xc7bc,0xc7bd,0xc7bf,0xc7c0,
0xc7c1,0xc7c8,0xc7c9,0xc7cc,0xc7ce,0xc7d0,0xc7d8,0xc7dd,
0xc7e4,0xc7e8,0xc7ec,0xc800,0xc801,0xc804,0xc808,0xc80a,
0xd564,0xd566,0xd567,0xd56a,0xd56c,0xd56e,0xd56f,0xd570,
0xd571,0xd572,0xd573,0xd576,0xd577,0xd579,0xd57a,0xd57b,
0xd57d,0xd57e,0xd57f,0xd580,0xd581,0xd582,0xd583,0xd586,
0xd58a,0xd58b,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd58c,0xd58d,0xd58e,0xd58f,0xd591,0xd592,0xd593,0xd594,
0xd595,0xd596,0xd597,0xd598,0xd599,0xd59a,0xd59b,0xd59c,
0xd59d,0xd59e,0xd59f,0xd5a0,0xd5a1,0xd5a2,0xd5a3,0xd5a4,
0xd5a6,0xd5a7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd5a8,0xd5a9,0xd5aa,0xd5ab,0xd5ac,0xd5ad,0xd5ae,0xd5af,
0xd5b0,0xd5b1,0xd5b2,0xd5b3,0xd5b4,0xd5b5,0xd5b6,0xd5b7,
0xd5b8,0xd5b9,0xd5ba,0xd5bb,0xd5bc,0xd5bd,0xd5be,0xd5bf,
0xd5c0,0xd5c1,0xd5c2,0xd5c3,0xd5c4,0xd5c5,0xd5c6,0xd5c7,
0xc810,0xc811,0xc813,0xc815,0xc816,0xc81c,0xc81d,0xc820,
0xc824,0xc82c,0xc82d,0xc82f,0xc831,0xc838,0xc83c,0xc840,
0xc848,0xc849,0xc84c,0xc84d,0xc854,0xc870,0xc871,0xc874,
0xc878,0xc87a,0xc880,0xc881,0xc883,0xc885,0xc886,0xc887,
0xc88b,0xc88c,0xc88d,0xc894,0xc89d,0xc89f,0xc8a1,0xc8a8,
0xc8bc,0xc8bd,0xc8c4,0xc8c8,0xc8cc,0xc8d4,0xc8d5,0xc8d7,
0xc8d9,0xc8e0,0xc8e1,0xc8e4,0xc8f5,0xc8fc,0xc8fd,0xc900,
0xc904,0xc905,0xc906,0xc90c,0xc90d,0xc90f,0xc911,0xc918,
0xc92c,0xc934,0xc950,0xc951,0xc954,0xc958,0xc960,0xc961,
0xc963,0xc96c,0xc970,0xc974,0xc97c,0xc988,0xc989,0xc98c,
0xc990,0xc998,0xc999,0xc99b,0xc99d,0xc9c0,0xc9c1,0xc9c4,
0xc9c7,0xc9c8,0xc9ca,0xc9d0,0xc9d1,0xc9d3,0xd5ca,0xd5cb,
0xd5cd,0xd5ce,0xd5cf,0xd5d1,0xd5d3,0xd5d4,0xd5d5,0xd5d6,
0xd5d7,0xd5da,0xd5dc,0xd5de,0xd5df,0xd5e0,0xd5e1,0xd5e2,
0xd5e3,0xd5e6,0xd5e7,0xd5e9,0xd5ea,0xd5eb,0xd5ed,0xd5ee,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd5ef,0xd5f0,
0xd5f1,0xd5f2,0xd5f3,0xd5f6,0xd5f8,0xd5fa,0xd5fb,0xd5fc,
0xd5fd,0xd5fe,0xd5ff,0xd602,0xd603,0xd605,0xd606,0xd607,
0xd609,0xd60a,0xd60b,0xd60c,0xd60d,0xd60e,0xd60f,0xd612,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd616,0xd617,
0xd618,0xd619,0xd61a,0xd61b,0xd61d,0xd61e,0xd61f,0xd621,
0xd622,0xd623,0xd625,0xd626,0xd627,0xd628,0xd629,0xd62a,
0xd62b,0xd62c,0xd62e,0xd62f,0xd630,0xd631,0xd632,0xd633,
0xd634,0xd635,0xd636,0xd637,0xd63a,0xd63b,0xc9d5,0xc9d6,
0xc9d9,0xc9da,0xc9dc,0xc9dd,0xc9e0,0xc9e2,0xc9e4,0xc9e7,
0xc9ec,0xc9ed,0xc9ef,0xc9f0,0xc9f1,0xc9f8,0xc9f9,0xc9fc,
0xca00,0xca08,0xca09,0xca0b,0xca0c,0xca0d,0xca14,0xca18,
0xca29,0xca4c,0xca4d,0xca50,0xca54,0xca5c,0xca5d,0xca5f,
0xca60,0xca61,0xca68,0xca7d,0xca84,0xca98,0xcabc,0xcabd,
0xcac0,0xcac4,0xcacc,0xcacd,0xcacf,0xcad1,0xcad3,0xcad8,
0xcad9,0xcae0,0xcaec,0xcaf4,0xcb08,0xcb10,0xcb14,0xcb18,
0xcb20,0xcb21,0xcb41,0xcb48,0xcb49,0xcb4c,0xcb50,0xcb58,
0xcb59,0xcb5d,0xcb64,0xcb78,0xcb79,0xcb9c,0xcbb8,0xcbd4,
0xcbe4,0xcbe7,0xcbe9,0xcc0c,0xcc0d,0xcc10,0xcc14,0xcc1c,
0xcc1d,0xcc21,0xcc22,0xcc27,0xcc28,0xcc29,0xcc2c,0xcc2e,
0xcc30,0xcc38,0xcc39,0xcc3b,0xd63d,0xd63e,0xd63f,0xd641,
0xd642,0xd643,0xd644,0xd646,0xd647,0xd64a,0xd64c,0xd64e,
0xd64f,0xd650,0xd652,0xd653,0xd656,0xd657,0xd659,0xd65a,
0xd65b,0xd65d,0xd65e,0xd65f,0xd660,0xd661,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xd662,0xd663,0xd664,0xd665,
0xd666,0xd668,0xd66a,0xd66b,0xd66c,0xd66d,0xd66e,0xd66f,
0xd672,0xd673,0xd675,0xd676,0xd677,0xd678,0xd679,0xd67a,
0xd67b,0xd67c,0xd67d,0xd67e,0xd67f,0xd680,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xd681,0xd682,0xd684,0xd686,
0xd687,0xd688,0xd689,0xd68a,0xd68b,0xd68e,0xd68f,0xd691,
0xd692,0xd693,0xd695,0xd696,0xd697,0xd698,0xd699,0xd69a,
0xd69b,0xd69c,0xd69e,0xd6a0,0xd6a2,0xd6a3,0xd6a4,0xd6a5,
0xd6a6,0xd6a7,0xd6a9,0xd6aa,0xcc3c,0xcc3d,0xcc3e,0xcc44,
0xcc45,0xcc48,0xcc4c,0xcc54,0xcc55,0xcc57,0xcc58,0xcc59,
0xcc60,0xcc64,0xcc66,0xcc68,0xcc70,0xcc75,0xcc98,0xcc99,
0xcc9c,0xcca0,0xcca8,0xcca9,0xccab,0xccac,0xccad,0xccb4,
0xccb5,0xccb8,0xccbc,0xccc4,0xccc5,0xccc7,0xccc9,0xccd0,
0xccd4,0xcce4,0xccec,0xccf0,0xcd01,0xcd08,0xcd09,0xcd0c,
0xcd10,0xcd18,0xcd19,0xcd1b,0xcd1d,0xcd24,0xcd28,0xcd2c,
0xcd39,0xcd5c,0xcd60,0xcd64,0xcd6c,0xcd6d,0xcd6f,0xcd71,
0xcd78,0xcd88,0xcd94,0xcd95,0xcd98,0xcd9c,0xcda4,0xcda5,
0xcda7,0xcda9,0xcdb0,0xcdc4,0xcdcc,0xcdd0,0xcde8,0xcdec,
0xcdf0,0xcdf8,0xcdf9,0xcdfb,0xcdfd,0xce04,0xce08,0xce0c,
0xce14,0xce19,0xce20,0xce21,0xce24,0xce28,0xce30,0xce31,
0xce33,0xce35,0xd6ab,0xd6ad,0xd6ae,0xd6af,0xd6b1,0xd6b2,
0xd6b3,0xd6b4,0xd6b5,0xd6b6,0xd6b7,0xd6b8,0xd6ba,0xd6bc,
0xd6bd,0xd6be,0xd6bf,0xd6c0,0xd6c1,0xd6c2,0xd6c3,0xd6c6,
0xd6c7,0xd6c9,0xd6ca,0xd6cb,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd6cd,0xd6ce,0xd6cf,0xd6d0,0xd6d2,0xd6d3,
0xd6d5,0xd6d6,0xd6d8,0xd6da,0xd6db,0xd6dc,0xd6dd,0xd6de,
0xd6df,0xd6e1,0xd6e2,0xd6e3,0xd6e5,0xd6e6,0xd6e7,0xd6e9,
0xd6ea,0xd6eb,0xd6ec,0xd6ed,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd6ee,0xd6ef,0xd6f1,0xd6f2,0xd6f3,0xd6f4,
0xd6f6,0xd6f7,0xd6f8,0xd6f9,0xd6fa,0xd6fb,0xd6fe,0xd6ff,
0xd701,0xd702,0xd703,0xd705,0xd706,0xd707,0xd708,0xd709,
0xd70a,0xd70b,0xd70c,0xd70d,0xd70e,0xd70f,0xd710,0xd712,
0xd713,0xd714,0xce58,0xce59,0xce5c,0xce5f,0xce60,0xce61,
0xce68,0xce69,0xce6b,0xce6d,0xce74,0xce75,0xce78,0xce7c,
0xce84,0xce85,0xce87,0xce89,0xce90,0xce91,0xce94,0xce98,
0xcea0,0xcea1,0xcea3,0xcea4,0xcea5,0xceac,0xcead,0xcec1,
0xcee4,0xcee5,0xcee8,0xceeb,0xceec,0xcef4,0xcef5,0xcef7,
0xcef8,0xcef9,0xcf00,0xcf01,0xcf04,0xcf08,0xcf10,0xcf11,
0xcf13,0xcf15,0xcf1c,0xcf20,0xcf24,0xcf2c,0xcf2d,0xcf2f,
0xcf30,0xcf31,0xcf38,0xcf54,0xcf55,0xcf58,0xcf5c,0xcf64,
0xcf65,0xcf67,0xcf69,0xcf70,0xcf71,0xcf74,0xcf78,0xcf80,
0xcf85,0xcf8c,0xcfa1,0xcfa8,0xcfb0,0xcfc4,0xcfe0,0xcfe1,
0xcfe4,0xcfe8,0xcff0,0xcff1,0xcff3,0xcff5,0xcffc,0xd000,
0xd004,0xd011,0xd018,0xd02d,0xd034,0xd035,0xd038,0xd03c,
0xd715,0xd716,0xd717,0xd71a,0xd71b,0xd71d,0xd71e,0xd71f,
0xd721,0xd722,0xd723,0xd724,0xd725,0xd726,0xd727,0xd72a,
0xd72c,0xd72e,0xd72f,0xd730,0xd731,0xd732,0xd733,0xd736,
0xd737,0xd739,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd73a,0xd73b,0xd73d,0xd73e,0xd73f,0xd740,0xd741,0xd742,
0xd743,0xd745,0xd746,0xd748,0xd74a,0xd74b,0xd74c,0xd74d,
0xd74e,0xd74f,0xd752,0xd753,0xd755,0xd75a,0xd75b,0xd75c,
0xd75d,0xd75e,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd75f,0xd762,0xd764,0xd766,0xd767,0xd768,0xd76a,0xd76b,
0xd76d,0xd76e,0xd76f,0xd771,0xd772,0xd773,0xd775,0xd776,
0xd777,0xd778,0xd779,0xd77a,0xd77b,0xd77e,0xd77f,0xd780,
0xd782,0xd783,0xd784,0xd785,0xd786,0xd787,0xd78a,0xd78b,
0xd044,0xd045,0xd047,0xd049,0xd050,0xd054,0xd058,0xd060,
0xd06c,0xd06d,0xd070,0xd074,0xd07c,0xd07d,0xd081,0xd0a4,
0xd0a5,0xd0a8,0xd0ac,0xd0b4,0xd0b5,0xd0b7,0xd0b9,0xd0c0,
0xd0c1,0xd0c4,0xd0c8,0xd0c9,0xd0d0,0xd0d1,0xd0d3,0xd0d4,
0xd0d5,0xd0dc,0xd0dd,0xd0e0,0xd0e4,0xd0ec,0xd0ed,0xd0ef,
0xd0f0,0xd0f1,0xd0f8,0xd10d,0xd130,0xd131,0xd134,0xd138,
0xd13a,0xd140,0xd141,0xd143,0xd144,0xd145,0xd14c,0xd14d,
0xd150,0xd154,0xd15c,0xd15d,0xd15f,0xd161,0xd168,0xd16c,
0xd17c,0xd184,0xd188,0xd1a0,0xd1a1,0xd1a4,0xd1a8,0xd1b0,
0xd1b1,0xd1b3,0xd1b5,0xd1ba,0xd1bc,0xd1c0,0xd1d8,0xd1f4,
0xd1f8,0xd207,0xd209,0xd210,0xd22c,0xd22d,0xd230,0xd234,
0xd23c,0xd23d,0xd23f,0xd241,0xd248,0xd25c,0xd78d,0xd78e,
0xd78f,0xd791,0xd792,0xd793,0xd794,0xd795,0xd796,0xd797,
0xd79a,0xd79c,0xd79e,0xd79f,0xd7a0,0xd7a1,0xd7a2,0xd7a3,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd264,0xd280,
0xd281,0xd284,0xd288,0xd290,0xd291,0xd295,0xd29c,0xd2a0,
0xd2a4,0xd2ac,0xd2b1,0xd2b8,0xd2b9,0xd2bc,0xd2bf,0xd2c0,
0xd2c2,0xd2c8,0xd2c9,0xd2cb,0xd2d4,0xd2d8,0xd2dc,0xd2e4,
0xd2e5,0xd2f0,0xd2f1,0xd2f4,0xd2f8,0xd300,0xd301,0xd303,
0xd305,0xd30c,0xd30d,0xd30e,0xd310,0xd314,0xd316,0xd31c,
0xd31d,0xd31f,0xd320,0xd321,0xd325,0xd328,0xd329,0xd32c,
0xd330,0xd338,0xd339,0xd33b,0xd33c,0xd33d,0xd344,0xd345,
0xd37c,0xd37d,0xd380,0xd384,0xd38c,0xd38d,0xd38f,0xd390,
0xd391,0xd398,0xd399,0xd39c,0xd3a0,0xd3a8,0xd3a9,0xd3ab,
0xd3ad,0xd3b4,0xd3b8,0xd3bc,0xd3c4,0xd3c5,0xd3c8,0xd3c9,
0xd3d0,0xd3d8,0xd3e1,0xd3e3,0xd3ec,0xd3ed,0xd3f0,0xd3f4,
0xd3fc,0xd3fd,0xd3ff,0xd401};

static const int uhc2_ucs_table_size = (sizeof(uhc2_ucs_table)/sizeof(unsigned short));

static const unsigned short uhc3_ucs_table[] = {
0xd408,0xd41d,0xd440,0xd444,0xd45c,0xd460,0xd464,0xd46d,
0xd46f,0xd478,0xd479,0xd47c,0xd47f,0xd480,0xd482,0xd488,
0xd489,0xd48b,0xd48d,0xd494,0xd4a9,0xd4cc,0xd4d0,0xd4d4,
0xd4dc,0xd4df,0xd4e8,0xd4ec,0xd4f0,0xd4f8,0xd4fb,0xd4fd,
0xd504,0xd508,0xd50c,0xd514,0xd515,0xd517,0xd53c,0xd53d,
0xd540,0xd544,0xd54c,0xd54d,0xd54f,0xd551,0xd558,0xd559,
0xd55c,0xd560,0xd565,0xd568,0xd569,0xd56b,0xd56d,0xd574,
0xd575,0xd578,0xd57c,0xd584,0xd585,0xd587,0xd588,0xd589,
0xd590,0xd5a5,0xd5c8,0xd5c9,0xd5cc,0xd5d0,0xd5d2,0xd5d8,
0xd5d9,0xd5db,0xd5dd,0xd5e4,0xd5e5,0xd5e8,0xd5ec,0xd5f4,
0xd5f5,0xd5f7,0xd5f9,0xd600,0xd601,0xd604,0xd608,0xd610,
0xd611,0xd613,0xd614,0xd615,0xd61c,0xd620,0xd624,0xd62d,
0xd638,0xd639,0xd63c,0xd640,0xd645,0xd648,0xd649,0xd64b,
0xd64d,0xd651,0xd654,0xd655,0xd658,0xd65c,0xd667,0xd669,
0xd670,0xd671,0xd674,0xd683,0xd685,0xd68c,0xd68d,0xd690,
0xd694,0xd69d,0xd69f,0xd6a1,0xd6a8,0xd6ac,0xd6b0,0xd6b9,
0xd6bb,0xd6c4,0xd6c5,0xd6c8,0xd6cc,0xd6d1,0xd6d4,0xd6d7,
0xd6d9,0xd6e0,0xd6e4,0xd6e8,0xd6f0,0xd6f5,0xd6fc,0xd6fd,
0xd700,0xd704,0xd711,0xd718,0xd719,0xd71c,0xd720,0xd728,
0xd729,0xd72b,0xd72d,0xd734,0xd735,0xd738,0xd73c,0xd744,
0xd747,0xd749,0xd750,0xd751,0xd754,0xd756,0xd757,0xd758,
0xd759,0xd760,0xd761,0xd763,0xd765,0xd769,0xd76c,0xd770,
0xd774,0xd77c,0xd77d,0xd781,0xd788,0xd789,0xd78c,0xd790,
0xd798,0xd799,0xd79b,0xd79d,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x4f3d,0x4f73,0x5047,0x50f9,0x52a0,0x53ef,
0x5475,0x54e5,0x5609,0x5ac1,0x5bb6,0x6687,0x67b6,0x67b7,
0x67ef,0x6b4c,0x73c2,0x75c2,0x7a3c,0x82db,0x8304,0x8857,
0x8888,0x8a36,0x8cc8,0x8dcf,0x8efb,0x8fe6,0x99d5,0x523b,
0x5374,0x5404,0x606a,0x6164,0x6bbc,0x73cf,0x811a,0x89ba,
0x89d2,0x95a3,0x4f83,0x520a,0x58be,0x5978,0x59e6,0x5e72,
0x5e79,0x61c7,0x63c0,0x6746,0x67ec,0x687f,0x6f97,0x764e,
0x770b,0x78f5,0x7a08,0x7aff,0x7c21,0x809d,0x826e,0x8271,
0x8aeb,0x9593,0x4e6b,0x559d,0x66f7,0x6e34,0x78a3,0x7aed,
0x845b,0x8910,0x874e,0x97a8,0x52d8,0x574e,0x582a,0x5d4c,
0x611f,0x61be,0x6221,0x6562,0x67d1,0x6a44,0x6e1b,0x7518,
0x75b3,0x76e3,0x77b0,0x7d3a,0x90af,0x9451,0x9452,0x9f95,
0x5323,0x5cac,0x7532,0x80db,0x9240,0x9598,0x525b,0x5808,
0x59dc,0x5ca1,0x5d17,0x5eb7,0x5f3a,0x5f4a,0x6177,0x6c5f,
0x757a,0x7586,0x7ce0,0x7d73,0x7db1,0x7f8c,0x8154,0x8221,
0x8591,0x8941,0x8b1b,0x92fc,0x964d,0x9c47,0x4ecb,0x4ef7,
0x500b,0x51f1,0x584f,0x6137,0x613e,0x6168,0x6539,0x69ea,
0x6f11,0x75a5,0x7686,0x76d6,0x7b87,0x82a5,0x84cb,0xf900,
0x93a7,0x958b,0x5580,0x5ba2,0x5751,0xf901,0x7cb3,0x7fb9,
0x91b5,0x5028,0x53bb,0x5c45,0x5de8,0x62d2,0x636e,0x64da,
0x64e7,0x6e20,0x70ac,0x795b,0x8ddd,0x8e1e,0xf902,0x907d,
0x9245,0x92f8,0x4e7e,0x4ef6,0x5065,0x5dfe,0x5efa,0x6106,
0x6957,0x8171,0x8654,0x8e47,0x9375,0x9a2b,0x4e5e,0x5091,
0x6770,0x6840,0x5109,0x528d,0x5292,0x6aa2,0x77bc,0x9210,
0x9ed4,0x52ab,0x602f,0x8ff2,0x5048,0x61a9,0x63ed,0x64ca,
0x683c,0x6a84,0x6fc0,0x8188,0x89a1,0x9694,0x5805,0x727d,
0x72ac,0x7504,0x7d79,0x7e6d,0x80a9,0x898b,0x8b74,0x9063,
0x9d51,0x6289,0x6c7a,0x6f54,0x7d50,0x7f3a,0x8a23,0x517c,
0x614a,0x7b9d,0x8b19,0x9257,0x938c,0x4eac,0x4fd3,0x501e,
0x50be,0x5106,0x52c1,0x52cd,0x537f,0x5770,0x5883,0x5e9a,
0x5f91,0x6176,0x61ac,0x64ce,0x656c,0x666f,0x66bb,0x66f4,
0x6897,0x6d87,0x7085,0x70f1,0x749f,0x74a5,0x74ca,0x75d9,
0x786c,0x78ec,0x7adf,0x7af6,0x7d45,0x7d93,0x8015,0x803f,
0x811b,0x8396,0x8b66,0x8f15,0x9015,0x93e1,0x9803,0x9838,
0x9a5a,0x9be8,0x4fc2,0x5553,0x583a,0x5951,0x5b63,0x5c46,
0x60b8,0x6212,0x6842,0x68b0,0x68e8,0x6eaa,0x754c,0x7678,
0x78ce,0x7a3d,0x7cfb,0x7e6b,0x7e7c,0x8a08,0x8aa1,0x8c3f,
0x968e,0x9dc4,0x53e4,0x53e9,0x544a,0x5471,0x56fa,0x59d1,
0x5b64,0x5c3b,0x5eab,0x62f7,0x6537,0x6545,0x6572,0x66a0,
0x67af,0x69c1,0x6cbd,0x75fc,0x7690,0x777e,0x7a3f,0x7f94,
0x8003,0x80a1,0x818f,0x82e6,0x82fd,0x83f0,0x85c1,0x8831,
0x88b4,0x8aa5,0xf903,0x8f9c,0x932e,0x96c7,0x9867,0x9ad8,
0x9f13,0x54ed,0x659b,0x66f2,0x688f,0x7a40,0x8c37,0x9d60,
0x56f0,0x5764,0x5d11,0x6606,0x68b1,0x68cd,0x6efe,0x7428,
0x889e,0x9be4,0x6c68,0xf904,0x9aa8,0x4f9b,0x516c,0x5171,
0x529f,0x5b54,0x5de5,0x6050,0x606d,0x62f1,0x63a7,0x653b,
0x73d9,0x7a7a,0x86a3,0x8ca2,0x978f,0x4e32,0x5be1,0x6208,
0x679c,0x74dc,0x79d1,0x83d3,0x8a87,0x8ab2,0x8de8,0x904e,
0x934b,0x9846,0x5ed3,0x69e8,0x85ff,0x90ed,0xf905,0x51a0,
0x5b98,0x5bec,0x6163,0x68fa,0x6b3e,0x704c,0x742f,0x74d8,
0x7ba1,0x7f50,0x83c5,0x89c0,0x8cab,0x95dc,0x9928,0x522e,
0x605d,0x62ec,0x9002,0x4f8a,0x5149,0x5321,0x58d9,0x5ee3,
0x66e0,0x6d38,0x709a,0x72c2,0x73d6,0x7b50,0x80f1,0x945b,
0x5366,0x639b,0x7f6b,0x4e56,0x5080,0x584a,0x58de,0x602a,
0x6127,0x62d0,0x69d0,0x9b41,0x5b8f,0x7d18,0x80b1,0x8f5f,
0x4ea4,0x50d1,0x54ac,0x55ac,0x5b0c,0x5da0,0x5de7,0x652a,
0x654e,0x6821,0x6a4b,0x72e1,0x768e,0x77ef,0x7d5e,0x7ff9,
0x81a0,0x854e,0x86df,0x8f03,0x8f4e,0x90ca,0x9903,0x9a55,
0x9bab,0x4e18,0x4e45,0x4e5d,0x4ec7,0x4ff1,0x5177,0x52fe,
0x5340,0x53e3,0x53e5,0x548e,0x5614,0x5775,0x57a2,0x5bc7,
0x5d87,0x5ed0,0x61fc,0x62d8,0x6551,0x67b8,0x67e9,0x69cb,
0x6b50,0x6bc6,0x6bec,0x6c42,0x6e9d,0x7078,0x72d7,0x7396,
0x7403,0x77bf,0x77e9,0x7a76,0x7d7f,0x8009,0x81fc,0x8205,
0x820a,0x82df,0x8862,0x8b33,0x8cfc,0x8ec0,0x9011,0x90b1,
0x9264,0x92b6,0x99d2,0x9a45,0x9ce9,0x9dd7,0x9f9c,0x570b,
0x5c40,0x83ca,0x97a0,0x97ab,0x9eb4,0x541b,0x7a98,0x7fa4,
0x88d9,0x8ecd,0x90e1,0x5800,0x5c48,0x6398,0x7a9f,0x5bae,
0x5f13,0x7a79,0x7aae,0x828e,0x8eac,0x5026,0x5238,0x52f8,
0x5377,0x5708,0x62f3,0x6372,0x6b0a,0x6dc3,0x7737,0x53a5,
0x7357,0x8568,0x8e76,0x95d5,0x673a,0x6ac3,0x6f70,0x8a6d,
0x8ecc,0x994b,0xf906,0x6677,0x6b78,0x8cb4,0x9b3c,0xf907,
0x53eb,0x572d,0x594e,0x63c6,0x69fb,0x73ea,0x7845,0x7aba,
0x7ac5,0x7cfe,0x8475,0x898f,0x8d73,0x9035,0x95a8,0x52fb,
0x5747,0x7547,0x7b60,0x83cc,0x921e,0xf908,0x6a58,0x514b,
0x524b,0x5287,0x621f,0x68d8,0x6975,0x9699,0x50c5,0x52a4,
0x52e4,0x61c3,0x65a4,0x6839,0x69ff,0x747e,0x7b4b,0x82b9,
0x83eb,0x89b2,0x8b39,0x8fd1,0x9949,0xf909,0x4eca,0x5997,
0x64d2,0x6611,0x6a8e,0x7434,0x7981,0x79bd,0x82a9,0x887e,
0x887f,0x895f,0xf90a,0x9326,0x4f0b,0x53ca,0x6025,0x6271,
0x6c72,0x7d1a,0x7d66,0x4e98,0x5162,0x77dc,0x80af,0x4f01,
0x4f0e,0x5176,0x5180,0x55dc,0x5668,0x573b,0x57fa,0x57fc,
0x5914,0x5947,0x5993,0x5bc4,0x5c90,0x5d0e,0x5df1,0x5e7e,
0x5fcc,0x6280,0x65d7,0x65e3,0x671e,0x671f,0x675e,0x68cb,
0x68c4,0x6a5f,0x6b3a,0x6c23,0x6c7d,0x6c82,0x6dc7,0x7398,
0x7426,0x742a,0x7482,0x74a3,0x7578,0x757f,0x7881,0x78ef,
0x7941,0x7947,0x7948,0x797a,0x7b95,0x7d00,0x7dba,0x7f88,
0x8006,0x802d,0x808c,0x8a18,0x8b4f,0x8c48,0x8d77,0x9321,
0x9324,0x98e2,0x9951,0x9a0e,0x9a0f,0x9a65,0x9e92,0x7dca,
0x4f76,0x5409,0x62ee,0x6854,0x91d1,0x55ab,0x513a,0xf90b,
0xf90c,0x5a1c,0x61e6,0xf90d,0x62cf,0x62ff,0xf90e,0xf90f,
0xf910,0xf911,0xf912,0xf913,0x90a3,0xf914,0xf915,0xf916,
0xf917,0xf918,0x8afe,0xf919,0xf91a,0xf91b,0xf91c,0x6696,
0xf91d,0x7156,0xf91e,0xf91f,0x96e3,0xf920,0x634f,0x637a,
0x5357,0xf921,0x678f,0x6960,0x6e73,0xf922,0x7537,0xf923,
0xf924,0xf925,0x7d0d,0xf926,0xf927,0x8872,0x56ca,0x5a18,
0xf928,0xf929,0xf92a,0xf92b,0xf92c,0x4e43,0xf92d,0x5167,
0x5948,0x67f0,0x8010,0xf92e,0x5973,0x5e74,0x649a,0x79ca,
0x5ff5,0x606c,0x62c8,0x637b,0x5be7,0x5bd7,0x52aa,0xf92f,
0x5974,0x5f29,0x6012,0xf930,0xf931,0xf932,0x7459,0xf933,
0xf934,0xf935,0xf936,0xf937,0xf938,0x99d1,0xf939,0xf93a,
0xf93b,0xf93c,0xf93d,0xf93e,0xf93f,0xf940,0xf941,0xf942,
0xf943,0x6fc3,0xf944,0xf945,0x81bf,0x8fb2,0x60f1,0xf946,
0xf947,0x8166,0xf948,0xf949,0x5c3f,0xf94a,0xf94b,0xf94c,
0xf94d,0xf94e,0xf94f,0xf950,0xf951,0x5ae9,0x8a25,0x677b,
0x7d10,0xf952,0xf953,0xf954,0xf955,0xf956,0xf957,0x80fd,
0xf958,0xf959,0x5c3c,0x6ce5,0x533f,0x6eba,0x591a,0x8336,
0x4e39,0x4eb6,0x4f46,0x55ae,0x5718,0x58c7,0x5f56,0x65b7,
0x65e6,0x6a80,0x6bb5,0x6e4d,0x77ed,0x7aef,0x7c1e,0x7dde,
0x86cb,0x8892,0x9132,0x935b,0x64bb,0x6fbe,0x737a,0x75b8,
0x9054,0x5556,0x574d,0x61ba,0x64d4,0x66c7,0x6de1,0x6e5b,
0x6f6d,0x6fb9,0x75f0,0x8043,0x81bd,0x8541,0x8983,0x8ac7,
0x8b5a,0x931f,0x6c93,0x7553,0x7b54,0x8e0f,0x905d,0x5510,
0x5802,0x5858,0x5e62,0x6207,0x649e,0x68e0,0x7576,0x7cd6,
0x87b3,0x9ee8,0x4ee3,0x5788,0x576e,0x5927,0x5c0d,0x5cb1,
0x5e36,0x5f85,0x6234,0x64e1,0x73b3,0x81fa,0x888b,0x8cb8,
0x968a,0x9edb,0x5b85,0x5fb7,0x60b3,0x5012,0x5200,0x5230,
0x5716,0x5835,0x5857,0x5c0e,0x5c60,0x5cf6,0x5d8b,0x5ea6,
0x5f92,0x60bc,0x6311,0x6389,0x6417,0x6843,0x68f9,0x6ac2,
0x6dd8,0x6e21,0x6ed4,0x6fe4,0x71fe,0x76dc,0x7779,0x79b1,
0x7a3b,0x8404,0x89a9,0x8ced,0x8df3,0x8e48,0x9003,0x9014,
0x9053,0x90fd,0x934d,0x9676,0x97dc,0x6bd2,0x7006,0x7258,
0x72a2,0x7368,0x7763,0x79bf,0x7be4,0x7e9b,0x8b80,0x58a9,
0x60c7,0x6566,0x65fd,0x66be,0x6c8c,0x711e,0x71c9,0x8c5a,
0x9813,0x4e6d,0x7a81,0x4edd,0x51ac,0x51cd,0x52d5,0x540c,
0x61a7,0x6771,0x6850,0x68df,0x6d1e,0x6f7c,0x75bc,0x77b3,
0x7ae5,0x80f4,0x8463,0x9285,0x515c,0x6597,0x675c,0x6793,
0x75d8,0x7ac7,0x8373,0xf95a,0x8c46,0x9017,0x982d,0x5c6f,
0x81c0,0x829a,0x9041,0x906f,0x920d,0x5f97,0x5d9d,0x6a59,
0x71c8,0x767b,0x7b49,0x85e4,0x8b04,0x9127,0x9a30,0x5587,
0x61f6,0xf95b,0x7669,0x7f85,0x863f,0x87ba,0x88f8,0x908f,
0xf95c,0x6d1b,0x70d9,0x73de,0x7d61,0x843d,0xf95d,0x916a,
0x99f1,0xf95e,0x4e82,0x5375,0x6b04,0x6b12,0x703e,0x721b,
0x862d,0x9e1e,0x524c,0x8fa3,0x5d50,0x64e5,0x652c,0x6b16,
0x6feb,0x7c43,0x7e9c,0x85cd,0x8964,0x89bd,0x62c9,0x81d8,
0x881f,0x5eca,0x6717,0x6d6a,0x72fc,0x7405,0x746f,0x8782,
0x90de,0x4f86,0x5d0d,0x5fa0,0x840a,0x51b7,0x63a0,0x7565,
0x4eae,0x5006,0x5169,0x51c9,0x6881,0x6a11,0x7cae,0x7cb1,
0x7ce7,0x826f,0x8ad2,0x8f1b,0x91cf,0x4fb6,0x5137,0x52f5,
0x5442,0x5eec,0x616e,0x623e,0x65c5,0x6ada,0x6ffe,0x792a,
0x85dc,0x8823,0x95ad,0x9a62,0x9a6a,0x9e97,0x9ece,0x529b,
0x66c6,0x6b77,0x701d,0x792b,0x8f62,0x9742,0x6190,0x6200,
0x6523,0x6f23,0x7149,0x7489,0x7df4,0x806f,0x84ee,0x8f26,
0x9023,0x934a,0x51bd,0x5217,0x52a3,0x6d0c,0x70c8,0x88c2,
0x5ec9,0x6582,0x6bae,0x6fc2,0x7c3e,0x7375,0x4ee4,0x4f36,
0x56f9,0xf95f,0x5cba,0x5dba,0x601c,0x73b2,0x7b2d,0x7f9a,
0x7fce,0x8046,0x901e,0x9234,0x96f6,0x9748,0x9818,0x9f61,
0x4f8b,0x6fa7,0x79ae,0x91b4,0x96b7,0x52de,0xf960,0x6488,
0x64c4,0x6ad3,0x6f5e,0x7018,0x7210,0x76e7,0x8001,0x8606,
0x865c,0x8def,0x8f05,0x9732,0x9b6f,0x9dfa,0x9e75,0x788c,
0x797f,0x7da0,0x83c9,0x9304,0x9e7f,0x9e93,0x8ad6,0x58df,
0x5f04,0x6727,0x7027,0x74cf,0x7c60,0x807e,0x5121,0x7028,
0x7262,0x78ca,0x8cc2,0x8cda,0x8cf4,0x96f7,0x4e86,0x50da,
0x5bee,0x5ed6,0x6599,0x71ce,0x7642,0x77ad,0x804a,0x84fc,
0x907c,0x9b27,0x9f8d,0x58d8,0x5a41,0x5c62,0x6a13,0x6dda,
0x6f0f,0x763b,0x7d2f,0x7e37,0x851e,0x8938,0x93e4,0x964b,
0x5289,0x65d2,0x67f3,0x69b4,0x6d41,0x6e9c,0x700f,0x7409,
0x7460,0x7559,0x7624,0x786b,0x8b2c,0x985e,0x516d,0x622e,
0x9678,0x4f96,0x502b,0x5d19,0x6dea,0x7db8,0x8f2a,0x5f8b,
0x6144,0x6817,0xf961,0x9686,0x52d2,0x808b,0x51dc,0x51cc,
0x695e,0x7a1c,0x7dbe,0x83f1,0x9675,0x4fda,0x5229,0x5398,
0x540f,0x550e,0x5c65,0x60a7,0x674e,0x68a8,0x6d6c,0x7281,
0x72f8,0x7406,0x7483,0xf962,0x75e2,0x7c6c,0x7f79,0x7fb8,
0x8389,0x88cf,0x88e1,0x91cc,0x91d0,0x96e2,0x9bc9,0x541d,
0x6f7e,0x71d0,0x7498,0x85fa,0x8eaa,0x96a3,0x9c57,0x9e9f,
0x6797,0x6dcb,0x7433,0x81e8,0x9716,0x782c,0x7acb,0x7b20,
0x7c92,0x6469,0x746a,0x75f2,0x78bc,0x78e8,0x99ac,0x9b54,
0x9ebb,0x5bde,0x5e55,0x6f20,0x819c,0x83ab,0x9088,0x4e07,
0x534d,0x5a29,0x5dd2,0x5f4e,0x6162,0x633d,0x6669,0x66fc,
0x6eff,0x6f2b,0x7063,0x779e,0x842c,0x8513,0x883b,0x8f13,
0x9945,0x9c3b,0x551c,0x62b9,0x672b,0x6cab,0x8309,0x896a,
0x977a,0x4ea1,0x5984,0x5fd8,0x5fd9,0x671b,0x7db2,0x7f54,
0x8292,0x832b,0x83bd,0x8f1e,0x9099,0x57cb,0x59b9,0x5a92,
0x5bd0,0x6627,0x679a,0x6885,0x6bcf,0x7164,0x7f75,0x8cb7,
0x8ce3,0x9081,0x9b45,0x8108,0x8c8a,0x964c,0x9a40,0x9ea5,
0x5b5f,0x6c13,0x731b,0x76f2,0x76df,0x840c,0x51aa,0x8993,
0x514d,0x5195,0x52c9,0x68c9,0x6c94,0x7704,0x7720,0x7dbf,
0x7dec,0x9762,0x9eb5,0x6ec5,0x8511,0x51a5,0x540d,0x547d,
0x660e,0x669d,0x6927,0x6e9f,0x76bf,0x7791,0x8317,0x84c2,
0x879f,0x9169,0x9298,0x9cf4,0x8882,0x4fae,0x5192,0x52df,
0x59c6,0x5e3d,0x6155,0x6478,0x6479,0x66ae,0x67d0,0x6a21,
0x6bcd,0x6bdb,0x725f,0x7261,0x7441,0x7738,0x77db,0x8017,
0x82bc,0x8305,0x8b00,0x8b28,0x8c8c,0x6728,0x6c90,0x7267,
0x76ee,0x7766,0x7a46,0x9da9,0x6b7f,0x6c92,0x5922,0x6726,
0x8499,0x536f,0x5893,0x5999,0x5edf,0x63cf,0x6634,0x6773,
0x6e3a,0x732b,0x7ad7,0x82d7,0x9328,0x52d9,0x5deb,0x61ae,
0x61cb,0x620a,0x62c7,0x64ab,0x65e0,0x6959,0x6b66,0x6bcb,
0x7121,0x73f7,0x755d,0x7e46,0x821e,0x8302,0x856a,0x8aa3,
0x8cbf,0x9727,0x9d61,0x58a8,0x9ed8,0x5011,0x520e,0x543b,
0x554f,0x6587,0x6c76,0x7d0a,0x7d0b,0x805e,0x868a,0x9580,
0x96ef,0x52ff,0x6c95,0x7269,0x5473,0x5a9a,0x5c3e,0x5d4b,
0x5f4c,0x5fae,0x672a,0x68b6,0x6963,0x6e3c,0x6e44,0x7709,
0x7c73,0x7f8e,0x8587,0x8b0e,0x8ff7,0x9761,0x9ef4,0x5cb7,
0x60b6,0x610d,0x61ab,0x654f,0x65fb,0x65fc,0x6c11,0x6cef,
0x739f,0x73c9,0x7de1,0x9594,0x5bc6,0x871c,0x8b10,0x525d,
0x535a,0x62cd,0x640f,0x64b2,0x6734,0x6a38,0x6cca,0x73c0,
0x749e,0x7b94,0x7c95,0x7e1b,0x818a,0x8236,0x8584,0x8feb,
0x96f9,0x99c1,0x4f34,0x534a,0x53cd,0x53db,0x62cc,0x642c,
0x6500,0x6591,0x69c3,0x6cee,0x6f58,0x73ed,0x7554,0x7622,
0x76e4,0x76fc,0x78d0,0x78fb,0x792c,0x7d46,0x822c,0x87e0,
0x8fd4,0x9812,0x98ef,0x52c3,0x62d4,0x64a5,0x6e24,0x6f51,
0x767c,0x8dcb,0x91b1,0x9262,0x9aee,0x9b43,0x5023,0x508d,
0x574a,0x59a8,0x5c28,0x5e47,0x5f77,0x623f,0x653e,0x65b9,
0x65c1,0x6609,0x678b,0x699c,0x6ec2,0x78c5,0x7d21,0x80aa,
0x8180,0x822b,0x82b3,0x84a1,0x868c,0x8a2a,0x8b17,0x90a6,
0x9632,0x9f90,0x500d,0x4ff3,0xf963,0x57f9,0x5f98,0x62dc,
0x6392,0x676f,0x6e43,0x7119,0x76c3,0x80cc,0x80da,0x88f4,
0x88f5,0x8919,0x8ce0,0x8f29,0x914d,0x966a,0x4f2f,0x4f70,
0x5e1b,0x67cf,0x6822,0x767d,0x767e,0x9b44,0x5e61,0x6a0a,
0x7169,0x71d4,0x756a,0xf964,0x7e41,0x8543,0x85e9,0x98dc,
0x4f10,0x7b4f,0x7f70,0x95a5,0x51e1,0x5e06,0x68b5,0x6c3e,
0x6c4e,0x6cdb,0x72af,0x7bc4,0x8303,0x6cd5,0x743a,0x50fb,
0x5288,0x58c1,0x64d8,0x6a97,0x74a7,0x7656,0x78a7,0x8617,
0x95e2,0x9739,0xf965,0x535e,0x5f01,0x8b8a,0x8fa8,0x8faf,
0x908a,0x5225,0x77a5,0x9c49,0x9f08,0x4e19,0x5002,0x5175,
0x5c5b,0x5e77,0x661e,0x663a,0x67c4,0x68c5,0x70b3,0x7501,
0x75c5,0x79c9,0x7add,0x8f27,0x9920,0x9a08,0x4fdd,0x5821,
0x5831,0x5bf6,0x666e,0x6b65,0x6d11,0x6e7a,0x6f7d,0x73e4,
0x752b,0x83e9,0x88dc,0x8913,0x8b5c,0x8f14,0x4f0f,0x50d5,
0x5310,0x535c,0x5b93,0x5fa9,0x670d,0x798f,0x8179,0x832f,
0x8514,0x8907,0x8986,0x8f39,0x8f3b,0x99a5,0x9c12,0x672c,
0x4e76,0x4ff8,0x5949,0x5c01,0x5cef,0x5cf0,0x6367,0x68d2,
0x70fd,0x71a2,0x742b,0x7e2b,0x84ec,0x8702,0x9022,0x92d2,
0x9cf3,0x4e0d,0x4ed8,0x4fef,0x5085,0x5256,0x526f,0x5426,
0x5490,0x57e0,0x592b,0x5a66,0x5b5a,0x5b75,0x5bcc,0x5e9c,
0xf966,0x6276,0x6577,0x65a7,0x6d6e,0x6ea5,0x7236,0x7b26,
0x7c3f,0x7f36,0x8150,0x8151,0x819a,0x8240,0x8299,0x83a9,
0x8a03,0x8ca0,0x8ce6,0x8cfb,0x8d74,0x8dba,0x90e8,0x91dc,
0x961c,0x9644,0x99d9,0x9ce7,0x5317,0x5206,0x5429,0x5674,
0x58b3,0x5954,0x596e,0x5fff,0x61a4,0x626e,0x6610,0x6c7e,
0x711a,0x76c6,0x7c89,0x7cde,0x7d1b,0x82ac,0x8cc1,0x96f0,
0xf967,0x4f5b,0x5f17,0x5f7f,0x62c2,0x5d29,0x670b,0x68da,
0x787c,0x7e43,0x9d6c,0x4e15,0x5099,0x5315,0x532a,0x5351,
0x5983,0x5a62,0x5e87,0x60b2,0x618a,0x6249,0x6279,0x6590,
0x6787,0x69a7,0x6bd4,0x6bd6,0x6bd7,0x6bd8,0x6cb8,0xf968,
0x7435,0x75fa,0x7812,0x7891,0x79d5,0x79d8,0x7c83,0x7dcb,
0x7fe1,0x80a5,0x813e,0x81c2,0x83f2,0x871a,0x88e8,0x8ab9,
0x8b6c,0x8cbb,0x9119,0x975e,0x98db,0x9f3b,0x56ac,0x5b2a,
0x5f6c,0x658c,0x6ab3,0x6baf,0x6d5c,0x6ff1,0x7015,0x725d,
0x73ad,0x8ca7,0x8cd3,0x983b,0x6191,0x6c37,0x8058,0x9a01,
0x4e4d,0x4e8b,0x4e9b,0x4ed5,0x4f3a,0x4f3c,0x4f7f,0x4fdf,
0x50ff,0x53f2,0x53f8,0x5506,0x55e3,0x56db,0x58eb,0x5962,
0x5a11,0x5beb,0x5bfa,0x5c04,0x5df3,0x5e2b,0x5f99,0x601d,
0x6368,0x659c,0x65af,0x67f6,0x67fb,0x68ad,0x6b7b,0x6c99,
0x6cd7,0x6e23,0x7009,0x7345,0x7802,0x793e,0x7940,0x7960,
0x79c1,0x7be9,0x7d17,0x7d72,0x8086,0x820d,0x838e,0x84d1,
0x86c7,0x88df,0x8a50,0x8a5e,0x8b1d,0x8cdc,0x8d66,0x8fad,
0x90aa,0x98fc,0x99df,0x9e9d,0x524a,0xf969,0x6714,0xf96a,
0x5098,0x522a,0x5c71,0x6563,0x6c55,0x73ca,0x7523,0x759d,
0x7b97,0x849c,0x9178,0x9730,0x4e77,0x6492,0x6bba,0x715e,
0x85a9,0x4e09,0xf96b,0x6749,0x68ee,0x6e17,0x829f,0x8518,
0x886b,0x63f7,0x6f81,0x9212,0x98af,0x4e0a,0x50b7,0x50cf,
0x511f,0x5546,0x55aa,0x5617,0x5b40,0x5c19,0x5ce0,0x5e38,
0x5e8a,0x5ea0,0x5ec2,0x60f3,0x6851,0x6a61,0x6e58,0x723d,
0x7240,0x72c0,0x76f8,0x7965,0x7bb1,0x7fd4,0x88f3,0x89f4,
0x8a73,0x8c61,0x8cde,0x971c,0x585e,0x74bd,0x8cfd,0x55c7,
0xf96c,0x7a61,0x7d22,0x8272,0x7272,0x751f,0x7525,0xf96d,
0x7b19,0x5885,0x58fb,0x5dbc,0x5e8f,0x5eb6,0x5f90,0x6055,
0x6292,0x637f,0x654d,0x6691,0x66d9,0x66f8,0x6816,0x68f2,
0x7280,0x745e,0x7b6e,0x7d6e,0x7dd6,0x7f72,0x80e5,0x8212,
0x85af,0x897f,0x8a93,0x901d,0x92e4,0x9ecd,0x9f20,0x5915,
0x596d,0x5e2d,0x60dc,0x6614,0x6673,0x6790,0x6c50,0x6dc5,
0x6f5f,0x77f3,0x78a9,0x84c6,0x91cb,0x932b,0x4ed9,0x50ca,
0x5148,0x5584,0x5b0b,0x5ba3,0x6247,0x657e,0x65cb,0x6e32,
0x717d,0x7401,0x7444,0x7487,0x74bf,0x766c,0x79aa,0x7dda,
0x7e55,0x7fa8,0x817a,0x81b3,0x8239,0x861a,0x87ec,0x8a75,
0x8de3,0x9078,0x9291,0x9425,0x994d,0x9bae,0x5368,0x5c51,
0x6954,0x6cc4,0x6d29,0x6e2b,0x820c,0x859b,0x893b,0x8a2d,
0x8aaa,0x96ea,0x9f67,0x5261,0x66b9,0x6bb2,0x7e96,0x87fe,
0x8d0d,0x9583,0x965d,0x651d,0x6d89,0x71ee,0xf96e,0x57ce,
0x59d3,0x5bac,0x6027,0x60fa,0x6210,0x661f,0x665f,0x7329,
0x73f9,0x76db,0x7701,0x7b6c,0x8056,0x8072,0x8165,0x8aa0,
0x9192,0x4e16,0x52e2,0x6b72,0x6d17,0x7a05,0x7b39,0x7d30,
0xf96f,0x8cb0,0x53ec,0x562f,0x5851,0x5bb5,0x5c0f,0x5c11,
0x5de2,0x6240,0x6383,0x6414,0x662d,0x68b3,0x6cbc,0x6d88,
0x6eaf,0x701f,0x70a4,0x71d2,0x7526,0x758f,0x758e,0x7619,
0x7b11,0x7be0,0x7c2b,0x7d20,0x7d39,0x852c,0x856d,0x8607,
0x8a34,0x900d,0x9061,0x90b5,0x92b7,0x97f6,0x9a37,0x4fd7,
0x5c6c,0x675f,0x6d91,0x7c9f,0x7e8c,0x8b16,0x8d16,0x901f,
0x5b6b,0x5dfd,0x640d,0x84c0,0x905c,0x98e1,0x7387,0x5b8b,
0x609a,0x677e,0x6dde,0x8a1f,0x8aa6,0x9001,0x980c,0x5237,
0xf970,0x7051,0x788e,0x9396,0x8870,0x91d7,0x4fee,0x53d7,
0x55fd,0x56da,0x5782,0x58fd,0x5ac2,0x5b88,0x5cab,0x5cc0,
0x5e25,0x6101,0x620d,0x624b,0x6388,0x641c,0x6536,0x6578,
0x6a39,0x6b8a,0x6c34,0x6d19,0x6f31,0x71e7,0x72e9,0x7378,
0x7407,0x74b2,0x7626,0x7761,0x79c0,0x7a57,0x7aea,0x7cb9,
0x7d8f,0x7dac,0x7e61,0x7f9e,0x8129,0x8331,0x8490,0x84da,
0x85ea,0x8896,0x8ab0,0x8b90,0x8f38,0x9042,0x9083,0x916c,
0x9296,0x92b9,0x968b,0x96a7,0x96a8,0x96d6,0x9700,0x9808,
0x9996,0x9ad3,0x9b1a,0x53d4,0x587e,0x5919,0x5b70,0x5bbf,
0x6dd1,0x6f5a,0x719f,0x7421,0x74b9,0x8085,0x83fd,0x5de1,
0x5f87,0x5faa,0x6042,0x65ec,0x6812,0x696f,0x6a53,0x6b89,
0x6d35,0x6df3,0x73e3,0x76fe,0x77ac,0x7b4d,0x7d14,0x8123,
0x821c,0x8340,0x84f4,0x8563,0x8a62,0x8ac4,0x9187,0x931e,
0x9806,0x99b4,0x620c,0x8853,0x8ff0,0x9265,0x5d07,0x5d27,
0x5d69,0x745f,0x819d,0x8768,0x6fd5,0x62fe,0x7fd2,0x8936,
0x8972,0x4e1e,0x4e58,0x50e7,0x52dd,0x5347,0x627f,0x6607,
0x7e69,0x8805,0x965e,0x4f8d,0x5319,0x5636,0x59cb,0x5aa4,
0x5c38,0x5c4e,0x5c4d,0x5e02,0x5f11,0x6043,0x65bd,0x662f,
0x6642,0x67be,0x67f4,0x731c,0x77e2,0x793a,0x7fc5,0x8494,
0x84cd,0x8996,0x8a66,0x8a69,0x8ae1,0x8c55,0x8c7a,0x57f4,
0x5bd4,0x5f0f,0x606f,0x62ed,0x690d,0x6b96,0x6e5c,0x7184,
0x7bd2,0x8755,0x8b58,0x8efe,0x98df,0x98fe,0x4f38,0x4f81,
0x4fe1,0x547b,0x5a20,0x5bb8,0x613c,0x65b0,0x6668,0x71fc,
0x7533,0x795e,0x7d33,0x814e,0x81e3,0x8398,0x85aa,0x85ce,
0x8703,0x8a0a,0x8eab,0x8f9b,0xf971,0x8fc5,0x5931,0x5ba4,
0x5be6,0x6089,0x5be9,0x5c0b,0x5fc3,0x6c81,0xf972,0x6df1,
0x700b,0x751a,0x82af,0x8af6,0x4ec0,0x5341,0xf973,0x96d9,
0x6c0f,0x4e9e,0x4fc4,0x5152,0x555e,0x5a25,0x5ce8,0x6211,
0x7259,0x82bd,0x83aa,0x86fe,0x8859,0x8a1d,0x963f,0x96c5,
0x9913,0x9d09,0x9d5d,0x580a,0x5cb3,0x5dbd,0x5e44,0x60e1,
0x6115,0x63e1,0x6a02,0x6e25,0x9102,0x9354,0x984e,0x9c10,
0x9f77,0x5b89,0x5cb8,0x6309,0x664f,0x6848,0x773c,0x96c1,
0x978d,0x9854,0x9b9f,0x65a1,0x8b01,0x8ecb,0x95bc,0x5535,
0x5ca9,0x5dd6,0x5eb5,0x6697,0x764c,0x83f4,0x95c7,0x58d3,
0x62bc,0x72ce,0x9d28,0x4ef0,0x592e,0x600f,0x663b,0x6b83,
0x79e7,0x9d26,0x5393,0x54c0,0x57c3,0x5d16,0x611b,0x66d6,
0x6daf,0x788d,0x827e,0x9698,0x9744,0x5384,0x627c,0x6396,
0x6db2,0x7e0a,0x814b,0x984d,0x6afb,0x7f4c,0x9daf,0x9e1a,
0x4e5f,0x503b,0x51b6,0x591c,0x60f9,0x63f6,0x6930,0x723a,
0x8036,0xf974,0x91ce,0x5f31,0xf975,0xf976,0x7d04,0x82e5,
0x846f,0x84bb,0x85e5,0x8e8d,0xf977,0x4f6f,0xf978,0xf979,
0x58e4,0x5b43,0x6059,0x63da,0x6518,0x656d,0x6698,0xf97a,
0x694a,0x6a23,0x6d0b,0x7001,0x716c,0x75d2,0x760d,0x79b3,
0x7a70,0xf97b,0x7f8a,0xf97c,0x8944,0xf97d,0x8b93,0x91c0,
0x967d,0xf97e,0x990a,0x5704,0x5fa1,0x65bc,0x6f01,0x7600,
0x79a6,0x8a9e,0x99ad,0x9b5a,0x9f6c,0x5104,0x61b6,0x6291,
0x6a8d,0x81c6,0x5043,0x5830,0x5f66,0x7109,0x8a00,0x8afa,
0x5b7c,0x8616,0x4ffa,0x513c,0x56b4,0x5944,0x63a9,0x6df9,
0x5daa,0x696d,0x5186,0x4e88,0x4f59,0xf97f,0xf980,0xf981,
0x5982,0xf982,0xf983,0x6b5f,0x6c5d,0xf984,0x74b5,0x7916,
0xf985,0x8207,0x8245,0x8339,0x8f3f,0x8f5d,0xf986,0x9918,
0xf987,0xf988,0xf989,0x4ea6,0xf98a,0x57df,0x5f79,0x6613,
0xf98b,0xf98c,0x75ab,0x7e79,0x8b6f,0xf98d,0x9006,0x9a5b,
0x56a5,0x5827,0x59f8,0x5a1f,0x5bb4,0xf98e,0x5ef6,0xf98f,
0xf990,0x6350,0x633b,0xf991,0x693d,0x6c87,0x6cbf,0x6d8e,
0x6d93,0x6df5,0x6f14,0xf992,0x70df,0x7136,0x7159,0xf993,
0x71c3,0x71d5,0xf994,0x784f,0x786f,0xf995,0x7b75,0x7de3,
0xf996,0x7e2f,0xf997,0x884d,0x8edf,0xf998,0xf999,0xf99a,
0x925b,0xf99b,0x9cf6,0xf99c,0xf99d,0xf99e,0x6085,0x6d85,
0xf99f,0x71b1,0xf9a0,0xf9a1,0x95b1,0x53ad,0xf9a2,0xf9a3,
0xf9a4,0x67d3,0xf9a5,0x708e,0x7130,0x7430,0x8276,0x82d2,
0xf9a6,0x95bb,0x9ae5,0x9e7d,0x66c4,0xf9a7,0x71c1,0x8449,
0xf9a8,0xf9a9,0x584b,0xf9aa,0xf9ab,0x5db8,0x5f71,0xf9ac,
0x6620,0x668e,0x6979,0x69ae,0x6c38,0x6cf3,0x6e36,0x6f41,
0x6fda,0x701b,0x702f,0x7150,0x71df,0x7370,0xf9ad,0x745b,
0xf9ae,0x74d4,0x76c8,0x7a4e,0x7e93,0xf9af,0xf9b0,0x82f1,
0x8a60,0x8fce,0xf9b1,0x9348,0xf9b2,0x9719,0xf9b3,0xf9b4,
0x4e42,0x502a,0xf9b5,0x5208,0x53e1,0x66f3,0x6c6d,0x6fca,
0x730a,0x777f,0x7a62,0x82ae,0x85dd,0x8602,0xf9b6,0x88d4,
0x8a63,0x8b7d,0x8c6b,0xf9b7,0x92b3,0xf9b8,0x9713,0x9810,
0x4e94,0x4f0d,0x4fc9,0x50b2,0x5348,0x543e,0x5433,0x55da,
0x5862,0x58ba,0x5967,0x5a1b,0x5be4,0x609f,0xf9b9,0x61ca,
0x6556,0x65ff,0x6664,0x68a7,0x6c5a,0x6fb3,0x70cf,0x71ac,
0x7352,0x7b7d,0x8708,0x8aa4,0x9c32,0x9f07,0x5c4b,0x6c83,
0x7344,0x7389,0x923a,0x6eab,0x7465,0x761f,0x7a69,0x7e15,
0x860a,0x5140,0x58c5,0x64c1,0x74ee,0x7515,0x7670,0x7fc1,
0x9095,0x96cd,0x9954,0x6e26,0x74e6,0x7aa9,0x7aaa,0x81e5,
0x86d9,0x8778,0x8a1b,0x5a49,0x5b8c,0x5b9b,0x68a1,0x6900,
0x6d63,0x73a9,0x7413,0x742c,0x7897,0x7de9,0x7feb,0x8118,
0x8155,0x839e,0x8c4c,0x962e,0x9811,0x66f0,0x5f80,0x65fa,
0x6789,0x6c6a,0x738b,0x502d,0x5a03,0x6b6a,0x77ee,0x5916,
0x5d6c,0x5dcd,0x7325,0x754f,0xf9ba,0xf9bb,0x50e5,0x51f9,
0x582f,0x592d,0x5996,0x59da,0x5be5,0xf9bc,0xf9bd,0x5da2,
0x62d7,0x6416,0x6493,0x64fe,0xf9be,0x66dc,0xf9bf,0x6a48,
0xf9c0,0x71ff,0x7464,0xf9c1,0x7a88,0x7aaf,0x7e47,0x7e5e,
0x8000,0x8170,0xf9c2,0x87ef,0x8981,0x8b20,0x9059,0xf9c3,
0x9080,0x9952,0x617e,0x6b32,0x6d74,0x7e1f,0x8925,0x8fb1,
0x4fd1,0x50ad,0x5197,0x52c7,0x57c7,0x5889,0x5bb9,0x5eb8,
0x6142,0x6995,0x6d8c,0x6e67,0x6eb6,0x7194,0x7462,0x7528,
0x752c,0x8073,0x8338,0x84c9,0x8e0a,0x9394,0x93de,0xf9c4,
0x4e8e,0x4f51,0x5076,0x512a,0x53c8,0x53cb,0x53f3,0x5b87,
0x5bd3,0x5c24,0x611a,0x6182,0x65f4,0x725b,0x7397,0x7440,
0x76c2,0x7950,0x7991,0x79b9,0x7d06,0x7fbd,0x828b,0x85d5,
0x865e,0x8fc2,0x9047,0x90f5,0x91ea,0x9685,0x96e8,0x96e9,
0x52d6,0x5f67,0x65ed,0x6631,0x682f,0x715c,0x7a36,0x90c1,
0x980a,0x4e91,0xf9c5,0x6a52,0x6b9e,0x6f90,0x7189,0x8018,
0x82b8,0x8553,0x904b,0x9695,0x96f2,0x97fb,0x851a,0x9b31,
0x4e90,0x718a,0x96c4,0x5143,0x539f,0x54e1,0x5713,0x5712,
0x57a3,0x5a9b,0x5ac4,0x5bc3,0x6028,0x613f,0x63f4,0x6c85,
0x6d39,0x6e72,0x6e90,0x7230,0x733f,0x7457,0x82d1,0x8881,
0x8f45,0x9060,0xf9c6,0x9662,0x9858,0x9d1b,0x6708,0x8d8a,
0x925e,0x4f4d,0x5049,0x50de,0x5371,0x570d,0x59d4,0x5a01,
0x5c09,0x6170,0x6690,0x6e2d,0x7232,0x744b,0x7def,0x80c3,
0x840e,0x8466,0x853f,0x875f,0x885b,0x8918,0x8b02,0x9055,
0x97cb,0x9b4f,0x4e73,0x4f91,0x5112,0x516a,0xf9c7,0x552f,
0x55a9,0x5b7a,0x5ba5,0x5e7c,0x5e7d,0x5ebe,0x60a0,0x60df,
0x6108,0x6109,0x63c4,0x6538,0x6709,0xf9c8,0x67d4,0x67da,
0xf9c9,0x6961,0x6962,0x6cb9,0x6d27,0xf9ca,0x6e38,0xf9cb,
0x6fe1,0x7336,0x7337,0xf9cc,0x745c,0x7531,0xf9cd,0x7652,
0xf9ce,0xf9cf,0x7dad,0x81fe,0x8438,0x88d5,0x8a98,0x8adb,
0x8aed,0x8e30,0x8e42,0x904a,0x903e,0x907a,0x9149,0x91c9,
0x936e,0xf9d0,0xf9d1,0x5809,0xf9d2,0x6bd3,0x8089,0x80b2,
0xf9d3,0xf9d4,0x5141,0x596b,0x5c39,0xf9d5,0xf9d6,0x6f64,
0x73a7,0x80e4,0x8d07,0xf9d7,0x9217,0x958f,0xf9d8,0xf9d9,
0xf9da,0xf9db,0x807f,0x620e,0x701c,0x7d68,0x878d,0xf9dc,
0x57a0,0x6069,0x6147,0x6bb7,0x8abe,0x9280,0x96b1,0x4e59,
0x541f,0x6deb,0x852d,0x9670,0x97f3,0x98ee,0x63d6,0x6ce3,
0x9091,0x51dd,0x61c9,0x81ba,0x9df9,0x4f9d,0x501a,0x5100,
0x5b9c,0x610f,0x61ff,0x64ec,0x6905,0x6bc5,0x7591,0x77e3,
0x7fa9,0x8264,0x858f,0x87fb,0x8863,0x8abc,0x8b70,0x91ab,
0x4e8c,0x4ee5,0x4f0a,0xf9dd,0xf9de,0x5937,0x59e8,0xf9df,
0x5df2,0x5f1b,0x5f5b,0x6021,0xf9e0,0xf9e1,0xf9e2,0xf9e3,
0x723e,0x73e5,0xf9e4,0x7570,0x75cd,0xf9e5,0x79fb,0xf9e6,
0x800c,0x8033,0x8084,0x82e1,0x8351,0xf9e7,0xf9e8,0x8cbd,
0x8cb3,0x9087,0xf9e9,0xf9ea,0x98f4,0x990c,0xf9eb,0xf9ec,
0x7037,0x76ca,0x7fca,0x7fcc,0x7ffc,0x8b1a,0x4eba,0x4ec1,
0x5203,0x5370,0xf9ed,0x54bd,0x56e0,0x59fb,0x5bc5,0x5f15,
0x5fcd,0x6e6e,0xf9ee,0xf9ef,0x7d6a,0x8335,0xf9f0,0x8693,
0x8a8d,0xf9f1,0x976d,0x9777,0xf9f2,0xf9f3,0x4e00,0x4f5a,
0x4f7e,0x58f9,0x65e5,0x6ea2,0x9038,0x93b0,0x99b9,0x4efb,
0x58ec,0x598a,0x59d9,0x6041,0xf9f4,0xf9f5,0x7a14,0xf9f6,
0x834f,0x8cc3,0x5165,0x5344,0xf9f7,0xf9f8,0xf9f9,0x4ecd,
0x5269,0x5b55,0x82bf,0x4ed4,0x523a,0x54a8,0x59c9,0x59ff,
0x5b50,0x5b57,0x5b5c,0x6063,0x6148,0x6ecb,0x7099,0x716e,
0x7386,0x74f7,0x75b5,0x78c1,0x7d2b,0x8005,0x81ea,0x8328,
0x8517,0x85c9,0x8aee,0x8cc7,0x96cc,0x4f5c,0x52fa,0x56bc,
0x65ab,0x6628,0x707c,0x70b8,0x7235,0x7dbd,0x828d,0x914c,
0x96c0,0x9d72,0x5b71,0x68e7,0x6b98,0x6f7a,0x76de,0x5c91,
0x66ab,0x6f5b,0x7bb4,0x7c2a,0x8836,0x96dc,0x4e08,0x4ed7,
0x5320,0x5834,0x58bb,0x58ef,0x596c,0x5c07,0x5e33,0x5e84,
0x5f35,0x638c,0x66b2,0x6756,0x6a1f,0x6aa3,0x6b0c,0x6f3f,
0x7246,0xf9fa,0x7350,0x748b,0x7ae0,0x7ca7,0x8178,0x81df,
0x81e7,0x838a,0x846c,0x8523,0x8594,0x85cf,0x88dd,0x8d13,
0x91ac,0x9577,0x969c,0x518d,0x54c9,0x5728,0x5bb0,0x624d,
0x6750,0x683d,0x6893,0x6e3d,0x6ed3,0x707d,0x7e21,0x88c1,
0x8ca1,0x8f09,0x9f4b,0x9f4e,0x722d,0x7b8f,0x8acd,0x931a,
0x4f47,0x4f4e,0x5132,0x5480,0x59d0,0x5e95,0x62b5,0x6775,
0x696e,0x6a17,0x6cae,0x6e1a,0x72d9,0x732a,0x75bd,0x7bb8,
0x7d35,0x82e7,0x83f9,0x8457,0x85f7,0x8a5b,0x8caf,0x8e87,
0x9019,0x90b8,0x96ce,0x9f5f,0x52e3,0x540a,0x5ae1,0x5bc2,
0x6458,0x6575,0x6ef4,0x72c4,0xf9fb,0x7684,0x7a4d,0x7b1b,
0x7c4d,0x7e3e,0x7fdf,0x837b,0x8b2b,0x8cca,0x8d64,0x8de1,
0x8e5f,0x8fea,0x8ff9,0x9069,0x93d1,0x4f43,0x4f7a,0x50b3,
0x5168,0x5178,0x524d,0x526a,0x5861,0x587c,0x5960,0x5c08,
0x5c55,0x5edb,0x609b,0x6230,0x6813,0x6bbf,0x6c08,0x6fb1,
0x714e,0x7420,0x7530,0x7538,0x7551,0x7672,0x7b4c,0x7b8b,
0x7bad,0x7bc6,0x7e8f,0x8a6e,0x8f3e,0x8f49,0x923f,0x9293,
0x9322,0x942b,0x96fb,0x985a,0x986b,0x991e,0x5207,0x622a,
0x6298,0x6d59,0x7664,0x7aca,0x7bc0,0x7d76,0x5360,0x5cbe,
0x5e97,0x6f38,0x70b9,0x7c98,0x9711,0x9b8e,0x9ede,0x63a5,
0x647a,0x8776,0x4e01,0x4e95,0x4ead,0x505c,0x5075,0x5448,
0x59c3,0x5b9a,0x5e40,0x5ead,0x5ef7,0x5f81,0x60c5,0x633a,
0x653f,0x6574,0x65cc,0x6676,0x6678,0x67fe,0x6968,0x6a89,
0x6b63,0x6c40,0x6dc0,0x6de8,0x6e1f,0x6e5e,0x701e,0x70a1,
0x738e,0x73fd,0x753a,0x775b,0x7887,0x798e,0x7a0b,0x7a7d,
0x7cbe,0x7d8e,0x8247,0x8a02,0x8aea,0x8c9e,0x912d,0x914a,
0x91d8,0x9266,0x92cc,0x9320,0x9706,0x9756,0x975c,0x9802,
0x9f0e,0x5236,0x5291,0x557c,0x5824,0x5e1d,0x5f1f,0x608c,
0x63d0,0x68af,0x6fdf,0x796d,0x7b2c,0x81cd,0x85ba,0x88fd,
0x8af8,0x8e44,0x918d,0x9664,0x969b,0x973d,0x984c,0x9f4a,
0x4fce,0x5146,0x51cb,0x52a9,0x5632,0x5f14,0x5f6b,0x63aa,
0x64cd,0x65e9,0x6641,0x66fa,0x66f9,0x671d,0x689d,0x68d7,
0x69fd,0x6f15,0x6f6e,0x7167,0x71e5,0x722a,0x74aa,0x773a,
0x7956,0x795a,0x79df,0x7a20,0x7a95,0x7c97,0x7cdf,0x7d44,
0x7e70,0x8087,0x85fb,0x86a4,0x8a54,0x8abf,0x8d99,0x8e81,
0x9020,0x906d,0x91e3,0x963b,0x96d5,0x9ce5,0x65cf,0x7c07,
0x8db3,0x93c3,0x5b58,0x5c0a,0x5352,0x62d9,0x731d,0x5027,
0x5b97,0x5f9e,0x60b0,0x616b,0x68d5,0x6dd9,0x742e,0x7a2e,
0x7d42,0x7d9c,0x7e31,0x816b,0x8e2a,0x8e35,0x937e,0x9418,
0x4f50,0x5750,0x5de6,0x5ea7,0x632b,0x7f6a,0x4e3b,0x4f4f,
0x4f8f,0x505a,0x59dd,0x80c4,0x546a,0x5468,0x55fe,0x594f,
0x5b99,0x5dde,0x5eda,0x665d,0x6731,0x67f1,0x682a,0x6ce8,
0x6d32,0x6e4a,0x6f8d,0x70b7,0x73e0,0x7587,0x7c4c,0x7d02,
0x7d2c,0x7da2,0x821f,0x86db,0x8a3b,0x8a85,0x8d70,0x8e8a,
0x8f33,0x9031,0x914e,0x9152,0x9444,0x99d0,0x7af9,0x7ca5,
0x4fca,0x5101,0x51c6,0x57c8,0x5bef,0x5cfb,0x6659,0x6a3d,
0x6d5a,0x6e96,0x6fec,0x710c,0x756f,0x7ae3,0x8822,0x9021,
0x9075,0x96cb,0x99ff,0x8301,0x4e2d,0x4ef2,0x8846,0x91cd,
0x537d,0x6adb,0x696b,0x6c41,0x847a,0x589e,0x618e,0x66fe,
0x62ef,0x70dd,0x7511,0x75c7,0x7e52,0x84b8,0x8b49,0x8d08,
0x4e4b,0x53ea,0x54ab,0x5730,0x5740,0x5fd7,0x6301,0x6307,
0x646f,0x652f,0x65e8,0x667a,0x679d,0x67b3,0x6b62,0x6c60,
0x6c9a,0x6f2c,0x77e5,0x7825,0x7949,0x7957,0x7d19,0x80a2,
0x8102,0x81f3,0x829d,0x82b7,0x8718,0x8a8c,0xf9fc,0x8d04,
0x8dbe,0x9072,0x76f4,0x7a19,0x7a37,0x7e54,0x8077,0x5507,
0x55d4,0x5875,0x632f,0x6422,0x6649,0x664b,0x686d,0x699b,
0x6b84,0x6d25,0x6eb1,0x73cd,0x7468,0x74a1,0x755b,0x75b9,
0x76e1,0x771e,0x778b,0x79e6,0x7e09,0x7e1d,0x81fb,0x852f,
0x8897,0x8a3a,0x8cd1,0x8eeb,0x8fb0,0x9032,0x93ad,0x9663,
0x9673,0x9707,0x4f84,0x53f1,0x59ea,0x5ac9,0x5e19,0x684e,
0x74c6,0x75be,0x79e9,0x7a92,0x81a3,0x86ed,0x8cea,0x8dcc,
0x8fed,0x659f,0x6715,0xf9fd,0x57f7,0x6f57,0x7ddd,0x8f2f,
0x93f6,0x96c6,0x5fb5,0x61f2,0x6f84,0x4e14,0x4f98,0x501f,
0x53c9,0x55df,0x5d6f,0x5dee,0x6b21,0x6b64,0x78cb,0x7b9a,
0xf9fe,0x8e49,0x8eca,0x906e,0x6349,0x643e,0x7740,0x7a84,
0x932f,0x947f,0x9f6a,0x64b0,0x6faf,0x71e6,0x74a8,0x74da,
0x7ac4,0x7c12,0x7e82,0x7cb2,0x7e98,0x8b9a,0x8d0a,0x947d,
0x9910,0x994c,0x5239,0x5bdf,0x64e6,0x672d,0x7d2e,0x50ed,
0x53c3,0x5879,0x6158,0x6159,0x61fa,0x65ac,0x7ad9,0x8b92,
0x8b96,0x5009,0x5021,0x5275,0x5531,0x5a3c,0x5ee0,0x5f70,
0x6134,0x655e,0x660c,0x6636,0x66a2,0x69cd,0x6ec4,0x6f32,
0x7316,0x7621,0x7a93,0x8139,0x8259,0x83d6,0x84bc,0x50b5,
0x57f0,0x5bc0,0x5be8,0x5f69,0x63a1,0x7826,0x7db5,0x83dc,
0x8521,0x91c7,0x91f5,0x518a,0x67f5,0x7b56,0x8cac,0x51c4,
0x59bb,0x60bd,0x8655,0x501c,0xf9ff,0x5254,0x5c3a,0x617d,
0x621a,0x62d3,0x64f2,0x65a5,0x6ecc,0x7620,0x810a,0x8e60,
0x965f,0x96bb,0x4edf,0x5343,0x5598,0x5929,0x5ddd,0x64c5,
0x6cc9,0x6dfa,0x7394,0x7a7f,0x821b,0x85a6,0x8ce4,0x8e10,
0x9077,0x91e7,0x95e1,0x9621,0x97c6,0x51f8,0x54f2,0x5586,
0x5fb9,0x64a4,0x6f88,0x7db4,0x8f1f,0x8f4d,0x9435,0x50c9,
0x5c16,0x6cbe,0x6dfb,0x751b,0x77bb,0x7c3d,0x7c64,0x8a79,
0x8ac2,0x581e,0x59be,0x5e16,0x6377,0x7252,0x758a,0x776b,
0x8adc,0x8cbc,0x8f12,0x5ef3,0x6674,0x6df8,0x807d,0x83c1,
0x8acb,0x9751,0x9bd6,0xfa00,0x5243,0x66ff,0x6d95,0x6eef,
0x7de0,0x8ae6,0x902e,0x905e,0x9ad4,0x521d,0x527f,0x54e8,
0x6194,0x6284,0x62db,0x68a2,0x6912,0x695a,0x6a35,0x7092,
0x7126,0x785d,0x7901,0x790e,0x79d2,0x7a0d,0x8096,0x8278,
0x82d5,0x8349,0x8549,0x8c82,0x8d85,0x9162,0x918b,0x91ae,
0x4fc3,0x56d1,0x71ed,0x77d7,0x8700,0x89f8,0x5bf8,0x5fd6,
0x6751,0x90a8,0x53e2,0x585a,0x5bf5,0x60a4,0x6181,0x6460,
0x7e3d,0x8070,0x8525,0x9283,0x64ae,0x50ac,0x5d14,0x6700,
0x589c,0x62bd,0x63a8,0x690e,0x6978,0x6a1e,0x6e6b,0x76ba,
0x79cb,0x82bb,0x8429,0x8acf,0x8da8,0x8ffd,0x9112,0x914b,
0x919c,0x9310,0x9318,0x939a,0x96db,0x9a36,0x9c0d,0x4e11,
0x755c,0x795d,0x7afa,0x7b51,0x7bc9,0x7e2e,0x84c4,0x8e59,
0x8e74,0x8ef8,0x9010,0x6625,0x693f,0x7443,0x51fa,0x672e,
0x9edc,0x5145,0x5fe0,0x6c96,0x87f2,0x885d,0x8877,0x60b4,
0x81b5,0x8403,0x8d05,0x53d6,0x5439,0x5634,0x5a36,0x5c31,
0x708a,0x7fe0,0x805a,0x8106,0x81ed,0x8da3,0x9189,0x9a5f,
0x9df2,0x5074,0x4ec4,0x53a0,0x60fb,0x6e2c,0x5c64,0x4f88,
0x5024,0x55e4,0x5cd9,0x5e5f,0x6065,0x6894,0x6cbb,0x6dc4,
0x71be,0x75d4,0x75f4,0x7661,0x7a1a,0x7a49,0x7dc7,0x7dfb,
0x7f6e,0x81f4,0x86a9,0x8f1c,0x96c9,0x99b3,0x9f52,0x5247,
0x52c5,0x98ed,0x89aa,0x4e03,0x67d2,0x6f06,0x4fb5,0x5be2,
0x6795,0x6c88,0x6d78,0x741b,0x7827,0x91dd,0x937c,0x87c4,
0x79e4,0x7a31,0x5feb,0x4ed6,0x54a4,0x553e,0x58ae,0x59a5,
0x60f0,0x6253,0x62d6,0x6736,0x6955,0x8235,0x9640,0x99b1,
0x99dd,0x502c,0x5353,0x5544,0x577c,0xfa01,0x6258,0xfa02,
0x64e2,0x666b,0x67dd,0x6fc1,0x6fef,0x7422,0x7438,0x8a17,
0x9438,0x5451,0x5606,0x5766,0x5f48,0x619a,0x6b4e,0x7058,
0x70ad,0x7dbb,0x8a95,0x596a,0x812b,0x63a2,0x7708,0x803d,
0x8caa,0x5854,0x642d,0x69bb,0x5b95,0x5e11,0x6e6f,0xfa03,
0x8569,0x514c,0x53f0,0x592a,0x6020,0x614b,0x6b86,0x6c70,
0x6cf0,0x7b1e,0x80ce,0x82d4,0x8dc6,0x90b0,0x98b1,0xfa04,
0x64c7,0x6fa4,0x6491,0x6504,0x514e,0x5410,0x571f,0x8a0e,
0x615f,0x6876,0xfa05,0x75db,0x7b52,0x7d71,0x901a,0x5806,
0x69cc,0x817f,0x892a,0x9000,0x9839,0x5078,0x5957,0x59ac,
0x6295,0x900f,0x9b2a,0x615d,0x7279,0x95d6,0x5761,0x5a46,
0x5df4,0x628a,0x64ad,0x64fa,0x6777,0x6ce2,0x6d3e,0x722c,
0x7436,0x7834,0x7f77,0x82ad,0x8ddb,0x9817,0x5224,0x5742,
0x677f,0x7248,0x74e3,0x8ca9,0x8fa6,0x9211,0x962a,0x516b,
0x53ed,0x634c,0x4f69,0x5504,0x6096,0x6557,0x6c9b,0x6d7f,
0x724c,0x72fd,0x7a17,0x8987,0x8c9d,0x5f6d,0x6f8e,0x70f9,
0x81a8,0x610e,0x4fbf,0x504f,0x6241,0x7247,0x7bc7,0x7de8,
0x7fe9,0x904d,0x97ad,0x9a19,0x8cb6,0x576a,0x5e73,0x67b0,
0x840d,0x8a55,0x5420,0x5b16,0x5e63,0x5ee2,0x5f0a,0x6583,
0x80ba,0x853d,0x9589,0x965b,0x4f48,0x5305,0x530d,0x530f,
0x5486,0x54fa,0x5703,0x5e03,0x6016,0x629b,0x62b1,0x6355,
0xfa06,0x6ce1,0x6d66,0x75b1,0x7832,0x80de,0x812f,0x82de,
0x8461,0x84b2,0x888d,0x8912,0x900b,0x92ea,0x98fd,0x9b91,
0x5e45,0x66b4,0x66dd,0x7011,0x7206,0xfa07,0x4ff5,0x527d,
0x5f6a,0x6153,0x6753,0x6a19,0x6f02,0x74e2,0x7968,0x8868,
0x8c79,0x98c7,0x98c4,0x9a43,0x54c1,0x7a1f,0x6953,0x8af7,
0x8c4a,0x98a8,0x99ae,0x5f7c,0x62ab,0x75b2,0x76ae,0x88ab,
0x907f,0x9642,0x5339,0x5f3c,0x5fc5,0x6ccc,0x73cc,0x7562,
0x758b,0x7b46,0x82fe,0x999d,0x4e4f,0x903c,0x4e0b,0x4f55,
0x53a6,0x590f,0x5ec8,0x6630,0x6cb3,0x7455,0x8377,0x8766,
0x8cc0,0x9050,0x971e,0x9c15,0x58d1,0x5b78,0x8650,0x8b14,
0x9db4,0x5bd2,0x6068,0x608d,0x65f1,0x6c57,0x6f22,0x6fa3,
0x701a,0x7f55,0x7ff0,0x9591,0x9592,0x9650,0x97d3,0x5272,
0x8f44,0x51fd,0x542b,0x54b8,0x5563,0x558a,0x6abb,0x6db5,
0x7dd8,0x8266,0x929c,0x9677,0x9e79,0x5408,0x54c8,0x76d2,
0x86e4,0x95a4,0x95d4,0x965c,0x4ea2,0x4f09,0x59ee,0x5ae6,
0x5df7,0x6052,0x6297,0x676d,0x6841,0x6c86,0x6e2f,0x7f38,
0x809b,0x822a,0xfa08,0xfa09,0x9805,0x4ea5,0x5055,0x54b3,
0x5793,0x595a,0x5b69,0x5bb3,0x61c8,0x6977,0x6d77,0x7023,
0x87f9,0x89e3,0x8a72,0x8ae7,0x9082,0x99ed,0x9ab8,0x52be,
0x6838,0x5016,0x5e78,0x674f,0x8347,0x884c,0x4eab,0x5411,
0x56ae,0x73e6,0x9115,0x97ff,0x9909,0x9957,0x9999,0x5653,
0x589f,0x865b,0x8a31,0x61b2,0x6af6,0x737b,0x8ed2,0x6b47,
0x96aa,0x9a57,0x5955,0x7200,0x8d6b,0x9769,0x4fd4,0x5cf4,
0x5f26,0x61f8,0x665b,0x6ceb,0x70ab,0x7384,0x73b9,0x73fe,
0x7729,0x774d,0x7d43,0x7d62,0x7e23,0x8237,0x8852,0xfa0a,
0x8ce2,0x9249,0x986f,0x5b51,0x7a74,0x8840,0x9801,0x5acc,
0x4fe0,0x5354,0x593e,0x5cfd,0x633e,0x6d79,0x72f9,0x8105,
0x8107,0x83a2,0x92cf,0x9830,0x4ea8,0x5144,0x5211,0x578b,
0x5f62,0x6cc2,0x6ece,0x7005,0x7050,0x70af,0x7192,0x73e9,
0x7469,0x834a,0x87a2,0x8861,0x9008,0x90a2,0x93a3,0x99a8,
0x516e,0x5f57,0x60e0,0x6167,0x66b3,0x8559,0x8e4a,0x91af,
0x978b,0x4e4e,0x4e92,0x547c,0x58d5,0x58fa,0x597d,0x5cb5,
0x5f27,0x6236,0x6248,0x660a,0x6667,0x6beb,0x6d69,0x6dcf,
0x6e56,0x6ef8,0x6f94,0x6fe0,0x6fe9,0x705d,0x72d0,0x7425,
0x745a,0x74e0,0x7693,0x795c,0x7cca,0x7e1e,0x80e1,0x82a6,
0x846b,0x84bf,0x864e,0x865f,0x8774,0x8b77,0x8c6a,0x93ac,
0x9800,0x9865,0x60d1,0x6216,0x9177,0x5a5a,0x660f,0x6df7,
0x6e3e,0x743f,0x9b42,0x5ffd,0x60da,0x7b0f,0x54c4,0x5f18,
0x6c5e,0x6cd3,0x6d2a,0x70d8,0x7d05,0x8679,0x8a0c,0x9d3b,
0x5316,0x548c,0x5b05,0x6a3a,0x706b,0x7575,0x798d,0x79be,
0x82b1,0x83ef,0x8a71,0x8b41,0x8ca8,0x9774,0xfa0b,0x64f4,
0x652b,0x78ba,0x78bb,0x7a6b,0x4e38,0x559a,0x5950,0x5ba6,
0x5e7b,0x60a3,0x63db,0x6b61,0x6665,0x6853,0x6e19,0x7165,
0x74b0,0x7d08,0x9084,0x9a69,0x9c25,0x6d3b,0x6ed1,0x733e,
0x8c41,0x95ca,0x51f0,0x5e4c,0x5fa8,0x604d,0x60f6,0x6130,
0x614c,0x6643,0x6644,0x69a5,0x6cc1,0x6e5f,0x6ec9,0x6f62,
0x714c,0x749c,0x7687,0x7bc1,0x7c27,0x8352,0x8757,0x9051,
0x968d,0x9ec3,0x532f,0x56de,0x5efb,0x5f8a,0x6062,0x6094,
0x61f7,0x6666,0x6703,0x6a9c,0x6dee,0x6fae,0x7070,0x736a,
0x7e6a,0x81be,0x8334,0x86d4,0x8aa8,0x8cc4,0x5283,0x7372,
0x5b96,0x6a6b,0x9404,0x54ee,0x5686,0x5b5d,0x6548,0x6585,
0x66c9,0x689f,0x6d8d,0x6dc6,0x723b,0x80b4,0x9175,0x9a4d,
0x4faf,0x5019,0x539a,0x540e,0x543c,0x5589,0x55c5,0x5e3f,
0x5f8c,0x673d,0x7166,0x73dd,0x9005,0x52db,0x52f3,0x5864,
0x58ce,0x7104,0x718f,0x71fb,0x85b0,0x8a13,0x6688,0x85a8,
0x55a7,0x6684,0x714a,0x8431,0x5349,0x5599,0x6bc1,0x5f59,
0x5fbd,0x63ee,0x6689,0x7147,0x8af1,0x8f1d,0x9ebe,0x4f11,
0x643a,0x70cb,0x7566,0x8667,0x6064,0x8b4e,0x9df8,0x5147,
0x51f6,0x5308,0x6d36,0x80f8,0x9ed1,0x6615,0x6b23,0x7098,
0x75d5,0x5403,0x5c79,0x7d07,0x8a16,0x6b20,0x6b3d,0x6b46,
0x5438,0x6070,0x6d3d,0x7fd5,0x8208,0x50d6,0x51de,0x559c,
0x566b,0x56cd,0x59ec,0x5b09,0x5e0c,0x6199,0x6198,0x6231,
0x665e,0x66e6,0x7199,0x71b9,0x71ba,0x72a7,0x79a7,0x7a00,
0x7fb2,0x8a70};

static const int uhc3_ucs_table_size = (sizeof(uhc3_ucs_table)/sizeof(unsigned short));

/* UCS -> UHC */
static const unsigned short ucs_a1_uhc_table[] = { 
0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,
0x0008,0x0009,0x000a,0x000b,0x000c,0x000d,0x000e,0x000f,
0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017,
0x0018,0x0019,0x001a,0x001b,0x001c,0x001d,0x001e,0x001f,
0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027,
0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f,
0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,
0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f,
0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,
0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f,
0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,
0x0058,0x0059,0x005a,0x005b,0x005c,0x005d,0x005e,0x005f,
0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,
0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f,
0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,
0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,0x007e,0x007f,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xa2ae,0x0000,0x0000,0xa2b4,0x0000,0x0000,0xa1d7,
0xa1a7,0x0000,0xa8a3,0x0000,0x0000,0xa1a9,0xa2e7,0x0000,
0xa1c6,0xa1be,0xa9f7,0xa9f8,0xa2a5,0x0000,0xa2d2,0xa1a4,
0xa2ac,0xa9f6,0xa8ac,0x0000,0xa8f9,0xa8f6,0xa8fa,0xa2af,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xa8a1,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xa8a2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xa1bf,
0xa8aa,0x0000,0x0000,0x0000,0x0000,0x0000,0xa8ad,0xa9ac,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xa9a1,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xa9a3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xa1c0,
0xa9aa,0x0000,0x0000,0x0000,0x0000,0x0000,0xa9ad,0x0000,
/* 0x0100 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xa9a2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xa8a4,0xa9a4,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xa9a5,0xa8a6,0xa9a6,0x0000,0x0000,0x0000,0x0000,
0xa9a7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xa8a8,
0xa9a8,0xa8a9,0xa9a9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xa9b0,0xa8af,0xa9af,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xa8ab,0xa9ab,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xa8ae,0xa9ae,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
/* 0x0200 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xa2a7,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xa2b0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xa2a8,0xa2ab,0xa2aa,0xa2ad,0x0000,0xa2a9,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
/* 0x0300 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xa5c1,0xa5c2,0xa5c3,0xa5c4,0xa5c5,0xa5c6,0xa5c7,
0xa5c8,0xa5c9,0xa5ca,0xa5cb,0xa5cc,0xa5cd,0xa5ce,0xa5cf,
0xa5d0,0xa5d1,0x0000,0xa5d2,0xa5d3,0xa5d4,0xa5d5,0xa5d6,
0xa5d7,0xa5d8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xa5e1,0xa5e2,0xa5e3,0xa5e4,0xa5e5,0xa5e6,0xa5e7,
0xa5e8,0xa5e9,0xa5ea,0xa5eb,0xa5ec,0xa5ed,0xa5ee,0xa5ef,
0xa5f0,0xa5f1,0x0000,0xa5f2,0xa5f3,0xa5f4,0xa5f5,0xa5f6,
0xa5f7,0xa5f8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
/* 0x0400 */
0x0000,0xaca7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xaca1,0xaca2,0xaca3,0xaca4,0xaca5,0xaca6,0xaca8,0xaca9,
0xacaa,0xacab,0xacac,0xacad,0xacae,0xacaf,0xacb0,0xacb1,
0xacb2,0xacb3,0xacb4,0xacb5,0xacb6,0xacb7,0xacb8,0xacb9,
0xacba,0xacbb,0xacbc,0xacbd,0xacbe,0xacbf,0xacc0,0xacc1,
0xacd1,0xacd2,0xacd3,0xacd4,0xacd5,0xacd6,0xacd8,0xacd9,
0xacda,0xacdb,0xacdc,0xacdd,0xacde,0xacdf,0xace0,0xace1,
0xace2,0xace3,0xace4,0xace5,0xace6,0xace7,0xace8,0xace9,
0xacea,0xaceb,0xacec,0xaced,0xacee,0xacef,0xacf0,0xacf1,
0x0000,0xacd7};

static const int ucs_a1_uhc_table_min = 0x0000;
static const int ucs_a1_uhc_table_max = 0x0000 + (sizeof(ucs_a1_uhc_table)/sizeof(unsigned short));

static const unsigned short ucs_a2_uhc_table[] = {
/* 0x2000 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xa1aa,0x0000,0x0000,
0xa1ae,0xa1af,0x0000,0x0000,0xa1b0,0xa1b1,0x0000,0x0000,
0xa2d3,0xa2d4,0x0000,0x0000,0x0000,0xa1a5,0xa1a6,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xa2b6,0x0000,0xa1c7,0xa1c8,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xa1d8,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xa9f9,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xa9fa,
0x0000,0xa9fb,0xa9fc,0xa9fd,0xa9fe,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xa2e6,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
/* 0x2100 */
0x0000,0x0000,0x0000,0xa1c9,0x0000,0x0000,0x0000,0x0000,
0x0000,0xa2b5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xa7a4,0x0000,0x0000,0xa2e0,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xa2e5,0xa2e2,0x0000,0x0000,0x0000,0xa7d9,0x0000,
0x0000,0x0000,0x0000,0xa1ca,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xa8f7,0xa8f8,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xa8fb,0xa8fc,0xa8fd,0xa8fe,0x0000,
0xa5b0,0xa5b1,0xa5b2,0xa5b3,0xa5b4,0xa5b5,0xa5b6,0xa5b7,
0xa5b8,0xa5b9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xa5a1,0xa5a2,0xa5a3,0xa5a4,0xa5a5,0xa5a6,0xa5a7,0xa5a8,
0xa5a9,0xa5aa,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xa1e7,0xa1e8,0xa1e6,0xa1e9,0xa1ea,0xa2d5,0xa2d8,0xa2d6,
0xa2d9,0xa2d7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xa2a1,0x0000,0xa2a2,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xa2a3,0x0000,0xa1d3,0xa2a4,0x0000,0x0000,0x0000,0xa1d4,
0xa1f4,0x0000,0x0000,0xa1f5,0x0000,0x0000,0x0000,0xa2b3,
0x0000,0xa2b2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xa1ee,0x0000,0x0000,0xa1f0,0xa1c4,0x0000,
0xa1d0,0x0000,0x0000,0x0000,0x0000,0xa1ab,0x0000,0xa1fc,
0xa1fd,0xa1fb,0xa1fa,0xa1f2,0xa1f3,0x0000,0xa2b1,0x0000,
0x0000,0x0000,0x0000,0x0000,0xa1c5,0xa1f1,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xa1ad,0xa1ef,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xa1d6,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xa1c1,0xa1d5,0x0000,0x0000,0xa1c2,0xa1c3,0x0000,0x0000,
0x0000,0x0000,0xa1ec,0xa1ed,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xa1f8,0xa1f9,0x0000,0x0000,0xa1f6,0xa1f7,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xa2c1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xa1d1,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
/* 0x2300 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xa1d2,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
/* 0x2400 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xa8e7,0xa8e8,0xa8e9,0xa8ea,0xa8eb,0xa8ec,0xa8ed,0xa8ee,
0xa8ef,0xa8f0,0xa8f1,0xa8f2,0xa8f3,0xa8f4,0xa8f5,0x0000,
0x0000,0x0000,0x0000,0x0000,0xa9e7,0xa9e8,0xa9e9,0xa9ea,
0xa9eb,0xa9ec,0xa9ed,0xa9ee,0xa9ef,0xa9f0,0xa9f1,0xa9f2,
0xa9f3,0xa9f4,0xa9f5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xa9cd,0xa9ce,0xa9cf,0xa9d0,
0xa9d1,0xa9d2,0xa9d3,0xa9d4,0xa9d5,0xa9d6,0xa9d7,0xa9d8,
0xa9d9,0xa9da,0xa9db,0xa9dc,0xa9dd,0xa9de,0xa9df,0xa9e0,
0xa9e1,0xa9e2,0xa9e3,0xa9e4,0xa9e5,0xa9e6,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xa8cd,0xa8ce,0xa8cf,0xa8d0,0xa8d1,0xa8d2,0xa8d3,0xa8d4,
0xa8d5,0xa8d6,0xa8d7,0xa8d8,0xa8d9,0xa8da,0xa8db,0xa8dc,
0xa8dd,0xa8de,0xa8df,0xa8e0,0xa8e1,0xa8e2,0xa8e3,0xa8e4,
0xa8e5,0xa8e6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xa6a1,0xa6ac,0xa6a2,0xa6ad,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xa6a3,0xa6c8,0xa6c7,0xa6ae,
0xa6a4,0xa6c2,0xa6c1,0xa6af,0xa6a6,0xa6c6,0xa6c5,0xa6b1,
0xa6a5,0xa6c4,0xa6c3,0xa6b0,0xa6a7,0xa6bc,0xa6c9,0xa6ca,
0xa6b7,0xa6cb,0xa6cc,0xa6b2,0xa6a9,0xa6be,0xa6cd,0xa6ce,
0xa6b9,0xa6cf,0xa6d0,0xa6b4,0xa6a8,0xa6d1,0xa6d2,0xa6b8,
0xa6bd,0xa6d3,0xa6d4,0xa6b3,0xa6aa,0xa6d5,0xa6d6,0xa6ba,
0xa6bf,0xa6d7,0xa6d8,0xa6b5,0xa6ab,0xa6d9,0xa6da,0xa6bb,
0xa6db,0xa6dc,0xa6c0,0xa6dd,0xa6de,0xa6df,0xa6e0,0xa6e1,
0xa6e2,0xa6e3,0xa6e4,0xa6b6,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xa2c6,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xa1e1,0xa1e0,0x0000,0xa2c3,0xa2c7,0xa2c8,0xa2cb,0xa2ca,
0xa2c9,0xa2cc,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xa1e3,0xa1e2,0x0000,0x0000,0xa2ba,0xa2b9,
0x0000,0x0000,0x0000,0x0000,0xa1e5,0xa1e4,0x0000,0x0000,
0xa2b8,0xa2b7,0x0000,0x0000,0x0000,0x0000,0xa1df,0xa1de,
0xa2c2,0x0000,0x0000,0xa1db,0x0000,0x0000,0xa1dd,0xa1dc,
0xa2c4,0xa2c5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
/* 0x2600 */
0x0000,0x0000,0x0000,0x0000,0x0000,0xa1da,0xa1d9,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xa2cf,0xa2ce,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xa2d0,0x0000,0xa2d1,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xa1cf,0x0000,0xa1ce,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xa2bc,0xa2bd,0x0000,0xa2c0,0xa2bb,0xa2be,0x0000,0xa2bf,
0xa2cd,0xa2db,0xa2dc,0x0000,0xa2dd,0xa2da};

static const int ucs_a2_uhc_table_min = 0x2000;
static const int ucs_a2_uhc_table_max = 0x2000 + (sizeof(ucs_a2_uhc_table)/sizeof(unsigned short));

static const unsigned short ucs_a3_uhc_table[] = {
/* 0x2f00 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xa1a1,0xa1a2,0xa1a3,0xa1a8,0x0000,0x0000,0x0000,0x0000,
0xa1b4,0xa1b5,0xa1b6,0xa1b7,0xa1b8,0xa1b9,0xa1ba,0xa1bb,
0xa1bc,0xa1bd,0x0000,0xa1eb,0xa1b2,0xa1b3,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xaaa1,0xaaa2,0xaaa3,0xaaa4,0xaaa5,0xaaa6,0xaaa7,
0xaaa8,0xaaa9,0xaaaa,0xaaab,0xaaac,0xaaad,0xaaae,0xaaaf,
0xaab0,0xaab1,0xaab2,0xaab3,0xaab4,0xaab5,0xaab6,0xaab7,
0xaab8,0xaab9,0xaaba,0xaabb,0xaabc,0xaabd,0xaabe,0xaabf,
0xaac0,0xaac1,0xaac2,0xaac3,0xaac4,0xaac5,0xaac6,0xaac7,
0xaac8,0xaac9,0xaaca,0xaacb,0xaacc,0xaacd,0xaace,0xaacf,
0xaad0,0xaad1,0xaad2,0xaad3,0xaad4,0xaad5,0xaad6,0xaad7,
0xaad8,0xaad9,0xaada,0xaadb,0xaadc,0xaadd,0xaade,0xaadf,
0xaae0,0xaae1,0xaae2,0xaae3,0xaae4,0xaae5,0xaae6,0xaae7,
0xaae8,0xaae9,0xaaea,0xaaeb,0xaaec,0xaaed,0xaaee,0xaaef,
0xaaf0,0xaaf1,0xaaf2,0xaaf3,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xaba1,0xaba2,0xaba3,0xaba4,0xaba5,0xaba6,0xaba7,
0xaba8,0xaba9,0xabaa,0xabab,0xabac,0xabad,0xabae,0xabaf,
0xabb0,0xabb1,0xabb2,0xabb3,0xabb4,0xabb5,0xabb6,0xabb7,
0xabb8,0xabb9,0xabba,0xabbb,0xabbc,0xabbd,0xabbe,0xabbf,
0xabc0,0xabc1,0xabc2,0xabc3,0xabc4,0xabc5,0xabc6,0xabc7,
0xabc8,0xabc9,0xabca,0xabcb,0xabcc,0xabcd,0xabce,0xabcf,
0xabd0,0xabd1,0xabd2,0xabd3,0xabd4,0xabd5,0xabd6,0xabd7,
0xabd8,0xabd9,0xabda,0xabdb,0xabdc,0xabdd,0xabde,0xabdf,
0xabe0,0xabe1,0xabe2,0xabe3,0xabe4,0xabe5,0xabe6,0xabe7,
0xabe8,0xabe9,0xabea,0xabeb,0xabec,0xabed,0xabee,0xabef,
0xabf0,0xabf1,0xabf2,0xabf3,0xabf4,0xabf5,0xabf6,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
/* 0x3100 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xa4a1,0xa4a2,0xa4a3,0xa4a4,0xa4a5,0xa4a6,0xa4a7,
0xa4a8,0xa4a9,0xa4aa,0xa4ab,0xa4ac,0xa4ad,0xa4ae,0xa4af,
0xa4b0,0xa4b1,0xa4b2,0xa4b3,0xa4b4,0xa4b5,0xa4b6,0xa4b7,
0xa4b8,0xa4b9,0xa4ba,0xa4bb,0xa4bc,0xa4bd,0xa4be,0xa4bf,
0xa4c0,0xa4c1,0xa4c2,0xa4c3,0xa4c4,0xa4c5,0xa4c6,0xa4c7,
0xa4c8,0xa4c9,0xa4ca,0xa4cb,0xa4cc,0xa4cd,0xa4ce,0xa4cf,
0xa4d0,0xa4d1,0xa4d2,0xa4d3,0xa4d4,0xa4d5,0xa4d6,0xa4d7,
0xa4d8,0xa4d9,0xa4da,0xa4db,0xa4dc,0xa4dd,0xa4de,0xa4df,
0xa4e0,0xa4e1,0xa4e2,0xa4e3,0xa4e4,0xa4e5,0xa4e6,0xa4e7,
0xa4e8,0xa4e9,0xa4ea,0xa4eb,0xa4ec,0xa4ed,0xa4ee,0xa4ef,
0xa4f0,0xa4f1,0xa4f2,0xa4f3,0xa4f4,0xa4f5,0xa4f6,0xa4f7,
0xa4f8,0xa4f9,0xa4fa,0xa4fb,0xa4fc,0xa4fd,0xa4fe,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xa9b1,0xa9b2,0xa9b3,0xa9b4,0xa9b5,0xa9b6,0xa9b7,0xa9b8,
0xa9b9,0xa9ba,0xa9bb,0xa9bc,0xa9bd,0xa9be,0xa9bf,0xa9c0,
0xa9c1,0xa9c2,0xa9c3,0xa9c4,0xa9c5,0xa9c6,0xa9c7,0xa9c8,
0xa9c9,0xa9ca,0xa9cb,0xa9cc,0xa2df,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xa8b1,0xa8b2,0xa8b3,0xa8b4,0xa8b5,0xa8b6,0xa8b7,0xa8b8,
0xa8b9,0xa8ba,0xa8bb,0xa8bc,0xa8bd,0xa8be,0xa8bf,0xa8c0,
0xa8c1,0xa8c2,0xa8c3,0xa8c4,0xa8c5,0xa8c6,0xa8c7,0xa8c8,
0xa8c9,0xa8ca,0xa8cb,0xa8cc,0x0000,0x0000,0x0000,0xa2de,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
/* 0x3300 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xa7c9,0xa7ca,0xa7cb,0xa7cc,0xa7cd,0x0000,0x0000,0x0000,
0xa7ba,0xa7bb,0xa7dc,0xa7dd,0xa7de,0xa7b6,0xa7b7,0xa7b8,
0xa7d4,0xa7d5,0xa7d6,0xa7d7,0xa7d8,0xa7a1,0xa7a2,0xa7a3,
0xa7a5,0xa7ab,0xa7ac,0xa7ad,0xa7ae,0xa7af,0xa7b0,0xa7b1,
0xa7b2,0xa7b3,0xa7b4,0xa7a7,0xa7a8,0xa7a9,0xa7aa,0xa7bd,
0xa7be,0xa7e5,0xa7e6,0xa7e7,0xa7e8,0xa7e1,0xa7e2,0xa7e3,
0xa7bf,0xa7c0,0xa7c1,0xa7c2,0xa7c3,0xa7c4,0xa7c5,0xa7c6,
0xa7c7,0xa7c8,0xa7ce,0xa7cf,0xa7d0,0xa7d1,0xa7d2,0xa7d3,
0xa7da,0xa7db,0xa2e3,0xa7ec,0xa7a6,0xa7e0,0xa7ef,0xa2e1,
0xa7bc,0xa7ed,0xa7b5,0x0000,0x0000,0x0000,0x0000,0xa7b9,
0xa7ea,0x0000,0x0000,0xa7eb,0x0000,0x0000,0xa7df,0x0000,
0xa2e4,0x0000,0x0000,0xa7e4,0xa7ee,0xa7e9};

static const int ucs_a3_uhc_table_min = 0x2f00;
static const int ucs_a3_uhc_table_max = 0x2f00 + (sizeof(ucs_a3_uhc_table)/sizeof(unsigned short));

static const unsigned short ucs_i_uhc_table[] = {
/* 0x4d00 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xece9,0xefcb,0x0000,0xf6d2,0x0000,0x0000,0x0000,0xd8b2,
0xeddb,0xdfb2,0xdfbe,0xf9bb,0x0000,0xdcf4,0x0000,0x0000,
0x0000,0xf5e4,0x0000,0x0000,0xf3a6,0xdde0,0xe1a6,0x0000,
0xcef8,0xdcb0,0x0000,0x0000,0x0000,0x0000,0xe3aa,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf1e9,0x0000,0x0000,
0x0000,0x0000,0xcdfa,0x0000,0x0000,0x0000,0x0000,0x0000,
0xfcaf,0xd3a1,0x0000,0xf1ab,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xe7d1,0xd2ac,0x0000,0xcef9,0x0000,0x0000,
0x0000,0x0000,0x0000,0xf1fd,0x0000,0xdebf,0xfbba,0xf9b9,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xced2,0x0000,
0xe3ab,0xebe0,0x0000,0x0000,0x0000,0xcefa,0xcbf7,0xe5a5,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xcae1,0x0000,0xd4cc,0x0000,0x0000,
0x0000,0x0000,0x0000,0xeae1,0x0000,0x0000,0xdce3,0xdfad,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcbeb,0x0000,
0x0000,0x0000,0xd5af,0x0000,0x0000,0x0000,0xd6f5,0x0000,
0xe5f8,0x0000,0x0000,0xdec0,0xeca3,0x0000,0xe9cd,0x0000,
0xeaa7,0xe9f6,0xfbbb,0x0000,0xe7e9,0xefcc,0x0000,0x0000,
0xd0e6,0x0000,0x0000,0xdec1,0x0000,0x0000,0xe4ac,0x0000,
0x0000,0xd8cc,0xf9f1,0x0000,0xcedf,0xfaa4,0xe6b2,0x0000,
0xfafb,0x0000,0x0000,0xfabd,0xccc8,0xefcd,0xd5d5,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd3a2,0x0000,
0x0000,0x0000,0xecd1,0x0000,0x0000,0x0000,0x0000,0x0000,
0xe4a7,0xecd2,0x0000,0x0000,0xf6b1,0x0000,0x0000,0xcefb,
0x0000,0x0000,0xd0d1,0xcbbf,0x0000,0xeda4,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xeda8,0xdec2,0xf6e2,0xeddc,
0xdcf5,0xe0b9,0x0000,0x0000,0x0000,0xd4ce,0x0000,0xf4b5,
0x0000,0x0000,0x0000,0xd3db,0xd6b5,0xeca4,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xe4e6,0x0000,0xf1ea,0x0000,0x0000,0x0000,0xcbec,0xcbc0,
0x0000,0x0000,0x0000,0xecf2,0x0000,0x0000,0x0000,0x0000,
/* 0x4f00 */
0x0000,0xd0ea,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf9f2,0xeca5,0xd0df,0x0000,0xe7ea,0xd0eb,0xdcd1,
0xdbe9,0xfdcc,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xdbd7,
0x0000,0x0000,0x0000,0x0000,0xdae1,0x0000,0xd6b6,0x0000,
0xe3df,0x0000,0xdec3,0x0000,0xdec4,0xcaa1,0x0000,0x0000,
0x0000,0x0000,0x0000,0xeeec,0x0000,0x0000,0xd3a3,0xeeb7,
0xf8cf,0x0000,0x0000,0x0000,0x0000,0xeac8,0xeeb8,0xf1ac,
0xf1a5,0xe9ce,0x0000,0x0000,0x0000,0xf9bc,0x0000,0x0000,
0x0000,0xe5f9,0xecea,0xddd6,0xedc2,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf8a5,0x0000,0x0000,0x0000,0x0000,0x0000,0xe5ba,
0xdbd8,0x0000,0x0000,0xcaa2,0x0000,0x0000,0xd1cd,0x0000,
0x0000,0x0000,0xeeed,0x0000,0x0000,0x0000,0xeceb,0xdec5,
0x0000,0xe3e0,0x0000,0xcac9,0xf2e9,0x0000,0xd5ce,0x0000,
0xf6b6,0x0000,0xcec2,0xd6c7,0x0000,0xe3b4,0x0000,0xf1ad,
0x0000,0xeae2,0x0000,0x0000,0x0000,0x0000,0xd7c2,0x0000,
0xf3a7,0x0000,0x0000,0xcdea,0x0000,0xebee,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd9b2,0xfda5,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf6d5,0xd5e2,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf8b5,
0x0000,0x0000,0xccf5,0xf5b5,0xe4ad,0x0000,0x0000,0x0000,
0x0000,0xe7eb,0xf1d5,0x0000,0x0000,0x0000,0xf0bb,0x0000,
0x0000,0xe9b5,0x0000,0xccc9,0xfad5,0x0000,0x0000,0xe1d4,
0x0000,0x0000,0xd7d6,0x0000,0x0000,0xdcc1,0x0000,0xdec6,
0xfaef,0xe3e1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe1f3,0xdcf6,
0x0000,0xcefc,0x0000,0xdbc4,0x0000,0xf8f1,0x0000,0x0000,
0xdce4,0x0000,0xe5ef,0x0000,0x0000,0x0000,0x0000,0x0000,
/* 0x5000 */
0x0000,0x0000,0xdcb1,0x0000,0x0000,0x0000,0xd5d6,0x0000,
0x0000,0xf3da,0x0000,0xcbc1,0x0000,0xdbc3,0x0000,0x0000,
0x0000,0xd9fa,0xd3ee,0x0000,0x0000,0x0000,0xfab8,0x0000,
0x0000,0xfda6,0xebef,0x0000,0xf4a6,0x0000,0xccca,0xf3a8,
0x0000,0xf3db,0x0000,0xdba7,0xf6b7,0x0000,0xcfe6,0xf0f2,
0xcbda,0x0000,0xe7d2,0xd7c3,0xf6f0,0xe8de,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xe5a6,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xe5e7,0x0000,0x0000,0x0000,0xcaa3,
0xcca7,0xeac9,0x0000,0x0000,0x0000,0x0000,0x0000,0xf8b6,
0x0000,0x0000,0x0000,0x0000,0x0000,0xfaa5,0x0000,0x0000,
0x0000,0x0000,0xf1ae,0x0000,0xefce,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xcbed,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xf6b0,0xefcf,0xe9cf,0x0000,
0xf7de,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xced3,0x0000,0x0000,0x0000,0x0000,0xdcf7,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xdba8,0x0000,0x0000,
0x0000,0xcbf8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xdfa1,0xdde1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xf5ca,0xe9b6,0x0000,0x0000,
0x0000,0x0000,0xe7ec,0xeeee,0x0000,0xf3f0,0x0000,0xdfbf,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcccb,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xd0c1,0x0000,0x0000,
0x0000,0xf4d2,0xe0ba,0x0000,0x0000,0x0000,0x0000,0xdfc0,
0x0000,0xcee0,0x0000,0x0000,0x0000,0xdcd2,0xfdea,0x0000,
0x0000,0x0000,0xd6f6,0x0000,0x0000,0x0000,0xeaca,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe8e9,0x0000,0xe3ac,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf3d0,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xcaa4,0x0000,0xdbf8,0x0000,0x0000,0x0000,0xdec7,
0xebf0,0xf1d6,0x0000,0x0000,0xe5e2,0x0000,0xcccc,0x0000,
0x0000,0xcbfb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xeae3,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xdfc1,
0x0000,0xd6ed,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xe9d0,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xeeb9,0x0000,0x0000,0x0000,0x0000,0xd5e3,
0x0000,0x0000,0xd1d3,0x0000,0xe5f0,0x0000,0x0000,0x0000,
0xe8b4,0xebc3,0x0000,0xeaaa,0xfafc,0xf5f6,0xf0bc,0xfdd4,
0xe0bb,0xcec3,0x0000,0xd0ba,0xf7ba,0xd8f3,0xf7cd,0x0000,
0x0000,0x0000,0xe4ae,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xd4df,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd0e7,0x0000,0x0000,0xecfd,0x0000,0xd2ae,
0xeeef,0xd5d7,0xeae4,0xf8a2,0xcdeb,0xd7bf,0xfbb1,0x0000,
0x0000,0xcdec,0x0000,0x0000,0x0000,0xdcb2,0xd0ec,0xcefd,
0xeef0,0x0000,0x0000,0x0000,0xccc2,0x0000,0x0000,0x0000,
0xd0ed,0x0000,0x0000,0x0000,0x0000,0x0000,0xe5f7,0x0000,
0x0000,0x0000,0xf3fc,0x0000,0x0000,0xeea2,0x0000,0x0000,
0x0000,0x0000,0xd9b3,0x0000,0x0000,0xd8f4,0x0000,0xe9b7,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xceae,0x0000,0x0000,0x0000,0x0000,0xd9a2,0x0000,0x0000,
0x0000,0x0000,0xd8f1,0x0000,0xd4cf,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe5a7,0xd5d2,
0x0000,0x0000,0x0000,0x0000,0x0000,0xd6a9,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xf4a2,0x0000,0xf1d7,0x0000,
0x0000,0xd5d8,0x0000,0xf0bd,0xd7d0,0xd4d0,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xd7cf,0xebea,0xfdeb,0x0000,
0x0000,0xdbed,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xfcc5,0xcbc2,0x0000,0x0000,0x0000,0x0000,0xfdd5,0x0000,
0xf4c8,0xe8ea,0xf5f3,0x0000,0x0000,0xf9de,0x0000,0x0000,
0xd3ef,0x0000,0x0000,0xecd3,0x0000,0x0000,0xddc2,0xefb7,
0xe7d4,0x0000,0xcaca,0x0000,0x0000,0x0000,0xd9fb,0x0000,
0x0000,0xfafd,0x0000,0x0000,0x0000,0x0000,0x0000,0xd6aa,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf4f8,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xf7f7,0xdcac,0x0000,0x0000,
0x0000,0xd7d7,0xdfa2,0x0000,0x0000,0x0000,0xcebe,0x0000,
0xd3f0,0x0000,0x0000,0x0000,0x0000,0x0000,0xf0a4,0xe1ec,
0xcfe7,0xf3cb,0xeda9,0xcabe,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xf4ef,0x0000,0x0000,0x0000,0xf6ce,
0x0000,0x0000,0xdefb,0xd0bb,0xd5b7,0xeef1,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xf4a8,0x0000,0xdcf8,0x0000,
0x0000,0x0000,0x0000,0xcba7,0x0000,0xdace,0x0000,0x0000,
0x0000,0xe0e6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xeda5,0xeef2,0x0000,0x0000,0x0000,0x0000,0xdcf9,
0x0000,0x0000,0xf9dc,0x0000,0x0000,0xf3dc,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf8f2,0x0000,0xf4f9,
0x0000,0x0000,0x0000,0xfcf1,0x0000,0x0000,0x0000,0xd0bc,
0xdbf9,0xd7b1,0x0000,0x0000,0x0000,0xcbfc,0x0000,0x0000,
0x0000,0xf0a5,0xcbfd,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xd5f4,0x0000,0x0000,0x0000,0xcded,
0xcaa5,0x0000,0x0000,0xd6ab,0xd0c2,0x0000,0x0000,0x0000,
0x0000,0xf0be,0xd2bd,0xcca4,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfab6,0x0000,
0x0000,0xcccd,0x0000,0xdafa,0x0000,0xf6cf,0x0000,0xe9b8,
0x0000,0xd8f5,0x0000,0x0000,0x0000,0xccce,0x0000,0x0000,
0x0000,0x0000,0xd7cd,0x0000,0x0000,0xd4d1,0xe9ed,0x0000,
0xcaeb,0xd9e2,0x0000,0xfdb2,0x0000,0xe3ad,0xd6cc,0xd9b4,
0x0000,0x0000,0xe1a7,0xeed3,0xd0c3,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xfdb3,0x0000,0xd5e4,0x0000,0x0000,
0xcfe8,0x0000,0xedc3,0xd0b2,0x0000,0x0000,0xcefe,0xdaa8,
/* 0x5300 */
0x0000,0x0000,0x0000,0x0000,0x0000,0xf8d0,0x0000,0x0000,
0xfdd6,0x0000,0x0000,0x0000,0x0000,0xf8d1,0x0000,0xf8d2,
0xdcd3,0x0000,0x0000,0x0000,0x0000,0xdde2,0xfbf9,0xddc1,
0x0000,0xe3b5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xeddd,0xcec4,0x0000,0xcba1,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xdde3,0x0000,0x0000,0x0000,0x0000,0xfcdd,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf9af,0x0000,0x0000,0x0000,0x0000,0x0000,0xd2fb,
0xcfa1,0xe4a8,0x0000,0xf4b6,0xecfe,0x0000,0x0000,0xe3ae,
0xe7ed,0xfdc1,0xdae2,0x0000,0x0000,0xd8b3,0x0000,0x0000,
0x0000,0xdde4,0xf0ef,0xf6f1,0xfaf0,0x0000,0x0000,0xd1f5,
0x0000,0x0000,0xdacf,0x0000,0xdcd4,0x0000,0xdca6,0x0000,
0xefbf,0x0000,0x0000,0x0000,0x0000,0x0000,0xcecf,0x0000,
0xe0d9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd9d6,
0xecd4,0xeacb,0x0000,0x0000,0xcabf,0xd5b0,0x0000,0xcfe9,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf1ed,0x0000,0xcccf,
0x0000,0x0000,0x0000,0x0000,0xe4f8,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xe4ed,0x0000,0x0000,0x0000,0x0000,
0xd7d8,0x0000,0xfda7,0x0000,0x0000,0x0000,0x0000,0xeaab,
0xf6b2,0x0000,0x0000,0x0000,0x0000,0xcff0,0xf9bd,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe6f4,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xcbdb,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xf3d1,0x0000,0x0000,0x0000,0x0000,
0xe9d1,0xf3a9,0xd0e0,0xe9d2,0x0000,0xdae3,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xe2d2,0x0000,0xf6a2,0xe1f4,
0x0000,0x0000,0x0000,0xdae4,0x0000,0x0000,0x0000,0x0000,
0x0000,0xe7d5,0xf5bf,0xcfa2,0xcdaf,0xcfa3,0x0000,0x0000,
0x0000,0xcdb0,0xf1fe,0xd0a3,0xe1af,0xf8a3,0x0000,0xcaa6,
0xf7bb,0xf2ea,0xdec8,0xe9d3,0x0000,0x0000,0x0000,0x0000,
0xdec9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
/* 0x5400 */
0x0000,0x0000,0x0000,0xfdde,0xcac0,0x0000,0x0000,0x0000,
0xf9ea,0xd1ce,0xeed4,0x0000,0xd4d2,0xd9a3,0xfda8,0xd7d9,
0xf7ce,0xfabe,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xcfd6,0x0000,0xd7f0,0x0000,0xebe1,
0xf8c5,0x0000,0x0000,0x0000,0x0000,0x0000,0xdcfa,0x0000,
0x0000,0xddc3,0x0000,0xf9df,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xe7ef,0x0000,0x0000,0x0000,0x0000,
0xfde5,0xf6a3,0x0000,0xd9fc,0xfda9,0x0000,0xe7ee,0x0000,
0x0000,0x0000,0xd5e5,0x0000,0x0000,0x0000,0x0000,0x0000,
0xefd0,0x0000,0xcdb1,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf7a2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xf1b2,0x0000,0xf1b1,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xcdb2,0x0000,0xdaab,0x0000,0xcaa7,0x0000,0x0000,
0x0000,0x0000,0x0000,0xe3e2,0xfbbc,0xd9a4,0x0000,0x0000,
0xeeba,0x0000,0x0000,0x0000,0x0000,0x0000,0xf8d3,0x0000,
0x0000,0x0000,0x0000,0x0000,0xfbfa,0x0000,0xcfa4,0x0000,
0xdcfb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xf6e3,0x0000,0x0000,0x0000,
0xedaa,0x0000,0x0000,0xf2a1,0xcee1,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xfaa6,0x0000,0x0000,0x0000,0x0000,
0xf9e0,0x0000,0x0000,0x0000,0x0000,0xecd6,0x0000,0x0000,
0xe4ee,0xf9a1,0x0000,0x0000,0xfbef,0x0000,0x0000,0x0000,
0xf9eb,0xeea3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xeaac,0x0000,0x0000,0x0000,0xcaa8,0x0000,0x0000,
0xf4fa,0x0000,0x0000,0x0000,0x0000,0xcdd6,0xfcf6,0x0000,
0x0000,0x0000,0xf4c9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf8d4,0x0000,0x0000,0x0000,0x0000,0x0000,
/* 0x5500 */
0x0000,0x0000,0x0000,0x0000,0xf8a6,0x0000,0xdeca,0xf2c6,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd7da,0x0000,
0xd3d0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xd8c5,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xeae6,
0x0000,0xf3dd,0x0000,0x0000,0x0000,0xe4da,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf6e4,0x0000,
0x0000,0x0000,0x0000,0x0000,0xf6f2,0x0000,0xdfc2,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd9fd,
0x0000,0x0000,0x0000,0xccf6,0x0000,0x0000,0xd3ba,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe4af,0x0000,
0x0000,0x0000,0x0000,0xf9e1,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xf0a6,0x0000,0x0000,0x0000,
0xcbd3,0x0000,0x0000,0x0000,0xe0bc,0x0000,0xf4ca,0xd4fa,
0x0000,0xfdaa,0xf9e2,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xf4b7,0xfdc2,0xfcb0,0x0000,0xfdec,0xcae2,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfdbd,
0x0000,0xeae7,0xdfc3,0xd1d2,0xcee2,0x0000,0xd3a4,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xfdab,0x0000,0xdfe0,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xf2c7,0x0000,0x0000,0x0000,
0x0000,0x0000,0xe7f0,0x0000,0xd0ee,0x0000,0x0000,0xf3aa,
0x0000,0x0000,0x0000,0xdecb,0xf6b8,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe1f5,0xf1b3,0x0000,
/* 0x5600 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf7a3,0x0000,
0x0000,0xcaa9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xcfa5,0x0000,0x0000,0xdfc4,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe1b0,
0x0000,0x0000,0xf0bf,0x0000,0xf6a4,0x0000,0xe3b6,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xfac6,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd0ef,0x0000,0x0000,0xfded,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xddc4,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfcf7,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe6bf,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xdead,0x0000,0xfabf,0x0000,
0x0000,0x0000,0x0000,0x0000,0xe5f1,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xedc4,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd2a5,0x0000,0x0000,0xfdee,0x0000,0x0000,
0x0000,0xf5b6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xe1f6,0xdecc,0x0000,0x0000,0xfcde,0x0000,
0xecd7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xcddd,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xd6b7,0xcdb3,0x0000,0x0000,0x0000,0x0000,0x0000,
/* 0x5700 */
0x0000,0x0000,0x0000,0xf8d5,0xe5d8,0x0000,0x0000,0x0000,
0xcfea,0x0000,0x0000,0xcfd0,0x0000,0xeacc,0x0000,0x0000,
0x0000,0x0000,0xeaae,0xeaad,0x0000,0x0000,0xd3f1,0x0000,
0xd3a5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf7cf,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xeea4,0x0000,0x0000,0x0000,0x0000,0xd0a4,0x0000,0x0000,
0xf2a2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xd0f0,0x0000,0x0000,0x0000,0x0000,
0xf2a3,0x0000,0xf7f8,0x0000,0x0000,0x0000,0x0000,0xd0b3,
0x0000,0x0000,0xdba9,0x0000,0x0000,0xd3bb,0xcaec,0x0000,
0xf1a6,0xcbd5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf7e7,0x0000,0x0000,0xcdde,0x0000,0xf7a4,0x0000,
0x0000,0x0000,0xf8c0,0x0000,0x0000,0x0000,0xd3dd,0x0000,
0xccd0,0x0000,0x0000,0x0000,0x0000,0xcfa6,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xf6f3,0x0000,0x0000,0x0000,
0x0000,0x0000,0xe1f7,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd3dc,0x0000,0x0000,0xfafe,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xfaa7,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xebd9,0x0000,0xcfa7,0xeaaf,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xe4ef,0x0000,0x0000,0x0000,0xe9b9,
0xf1d8,0x0000,0x0000,0xd8d8,0x0000,0x0000,0xe0f2,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe6b4,
0xdcfc,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xf3f1,0x0000,0x0000,0x0000,0xe3d0,0x0000,0x0000,0xf2fb,
0x0000,0xdbc6,0xd0f1,0x0000,0xd0f2,0x0000,0x0000,0x0000,
0xcfdc,0x0000,0xd3d1,0x0000,0x0000,0xccb1,0xf7d8,0x0000,
0xcba8,0xebbc,0xe4be,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf4dc,0x0000,
0x0000,0xdcc2,0x0000,0x0000,0xf0a7,0x0000,0x0000,0xe6c0,
0x0000,0x0000,0xcaed,0x0000,0x0000,0x0000,0x0000,0xe8eb,
0xe5e8,0xdcc3,0x0000,0x0000,0xedde,0xd3f2,0x0000,0x0000,
0x0000,0x0000,0xccf7,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xced4,0xe7ab,0x0000,0x0000,0x0000,0xcbc3,
0x0000,0xe1b1,0x0000,0x0000,0xf7b2,0x0000,0x0000,0xd3f3,
0xd3d2,0x0000,0xf5c0,0x0000,0x0000,0x0000,0xdfdd,0x0000,
0x0000,0xeef3,0xe7f1,0x0000,0xfdb4,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf2c8,0x0000,0x0000,
0x0000,0xf3d2,0x0000,0x0000,0xeef4,0x0000,0xe2d3,0x0000,
0x0000,0x0000,0x0000,0xccd1,0x0000,0xdfea,0x0000,0x0000,
0x0000,0xe9ba,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xd9d7,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xf5cd,0x0000,0xf1f2,0xfac7,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd9f8,0xd4c2,0x0000,0x0000,0x0000,0x0000,0xf6e5,0x0000,
0x0000,0x0000,0x0000,0xddc5,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xe7f2,0xeddf,0x0000,0x0000,0xcacb,0x0000,
0x0000,0xdbfa,0x0000,0x0000,0x0000,0xe8b5,0x0000,0xd3a6,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfdb5,0x0000,
0x0000,0xf9c9,0x0000,0xe4e2,0x0000,0xfbbd,0x0000,0x0000,
0xd7a4,0xcec5,0x0000,0x0000,0x0000,0x0000,0xced5,0xd6e6,
0x0000,0x0000,0x0000,0x0000,0xe5bd,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xdecd,0xecf3,0x0000,0x0000,0xede0,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xecec,0xfbbe,0xdfeb,0x0000,0xe1f8,0x0000,0x0000,
/* 0x5900 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf9be,
0x0000,0x0000,0x0000,0x0000,0xd0f3,0xe0aa,0xe8e2,0x0000,
0x0000,0xe2d4,0xd2fd,0x0000,0xe5a8,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd9d3,0x0000,0x0000,0x0000,0x0000,0xd3de,
0x0000,0xf4b8,0xf7bc,0xdcfd,0x0000,0xe8ec,0xe4e7,0x0000,
0x0000,0xe3f7,0x0000,0x0000,0x0000,0x0000,0x0000,0xeca8,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfaf1,0x0000,
0x0000,0x0000,0x0000,0x0000,0xe5f2,0x0000,0x0000,0xd0f4,
0xd2af,0xdce5,0x0000,0x0000,0x0000,0x0000,0xd0a5,0xf1b4,
0xfcb1,0xccf8,0x0000,0x0000,0xddc6,0xfad1,0x0000,0xf7df,
0x0000,0x0000,0xfaa8,0x0000,0x0000,0x0000,0x0000,0x0000,
0xeef5,0x0000,0xdece,0x0000,0x0000,0x0000,0x0000,0xe7f3,
0x0000,0x0000,0xf7ac,0xebc4,0xede1,0xe0ab,0xddc7,0x0000,
0x0000,0x0000,0x0000,0xd2b3,0xd2bf,0x0000,0x0000,0x0000,
0xcacc,0x0000,0x0000,0x0000,0x0000,0xfbbf,0x0000,0x0000,
0x0000,0x0000,0xe5fd,0xdde5,0xd8cd,0x0000,0x0000,0x0000,
0x0000,0x0000,0xecf4,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xd0f5,0x0000,0x0000,0xe8ed,0xd0d2,
0x0000,0xd9d8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf6e6,0x0000,0x0000,
0xdbaa,0x0000,0x0000,0x0000,0xf7e0,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xd8d9,0x0000,0xf4a3,0x0000,0x0000,0xf4dd,0x0000,
0x0000,0x0000,0x0000,0xefd1,0x0000,0x0000,0xd9b5,0x0000,
0x0000,0xedab,0x0000,0xe3b7,0x0000,0x0000,0x0000,0x0000,
0xeebb,0xcdb4,0x0000,0xe0f3,0xeacd,0x0000,0x0000,0x0000,
0x0000,0xecf5,0xe8ee,0x0000,0xcba9,0xf1af,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcacd,0x0000,
0xeca9,0x0000,0xf2eb,0x0000,0xfdef,0x0000,0xf9f3,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xe6c1,0x0000,0x0000,0xecd8,0x0000,0x0000,0x0000,0xedac,
/* 0x5a00 */
0x0000,0xeace,0x0000,0xe8df,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xdecf,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd2a6,0x0000,0x0000,0xe7f4,0xd1d6,0x0000,0x0000,0xe6c2,
0xe3e3,0x0000,0x0000,0x0000,0x0000,0xe4b0,0x0000,0x0000,
0x0000,0xd8b4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf6a5,0x0000,
0x0000,0x0000,0x0000,0x0000,0xf3de,0x0000,0x0000,0x0000,
0x0000,0xd7a5,0x0000,0x0000,0x0000,0x0000,0xf7e8,0x0000,
0x0000,0xe8c6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xfbe6,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xdde6,0x0000,0x0000,0x0000,0xdcfe,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd8da,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xdaac,0xeab0,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xe3b8,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xcaaa,0xe1f9,0x0000,0xeab1,0x0000,0x0000,0x0000,
0x0000,0xf2ec,0x0000,0x0000,0xfaee,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xeed5,0x0000,0x0000,0x0000,0x0000,0xf9f4,0x0000,
0x0000,0xd2ec,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
/* 0x5b00 */
0x0000,0x0000,0x0000,0x0000,0x0000,0xfbfb,0x0000,0x0000,
0x0000,0xfdf0,0x0000,0xe0bd,0xcee3,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf8c6,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xdeae,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xdfc5,0x0000,0x0000,0xe5be,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xedad,0xfaea,0x0000,0x0000,0xcdee,0xeda6,0x0000,0xedae,
0xf0ed,0x0000,0xdda1,0x0000,0xedaf,0xfcf8,0x0000,0xd8eb,
0x0000,0x0000,0x0000,0xccf9,0xcdb5,0x0000,0x0000,0x0000,
0x0000,0xfaa9,0x0000,0xe1dd,0x0000,0x0000,0x0000,0x0000,
0xe2d5,0xedcf,0x0000,0x0000,0x0000,0xdda2,0x0000,0x0000,
0xf9ca,0x0000,0xeae8,0x0000,0xe5ed,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xd3eb,0x0000,0xe9d4,
0xe1fa,0xe4cc,0x0000,0xe1e4,0xe8c7,0x0000,0x0000,0xcedb,
0x0000,0x0000,0x0000,0xdcd5,0x0000,0xf7b5,0xfcf3,0xf0f3,
0xceaf,0xf1b5,0xefd2,0xe8c8,0xebf1,0x0000,0x0000,0x0000,
0x0000,0x0000,0xcbd4,0xe0be,0xe3f8,0xeae9,0xfcb2,0x0000,
0x0000,0x0000,0x0000,0x0000,0xe0f4,0x0000,0xcfe0,0x0000,
0xeea5,0x0000,0x0000,0xfaaa,0xe6c3,0xe1b2,0xcaab,0x0000,
0xe3e4,0xe9bb,0x0000,0x0000,0x0000,0x0000,0x0000,0xe2d6,
0xf3f2,0x0000,0xeed6,0xeab2,0xd0f6,0xecd9,0xdacb,0xcfa8,
0x0000,0x0000,0x0000,0x0000,0xdda3,0x0000,0x0000,0x0000,
0xd8db,0x0000,0xf9ce,0xe9d5,0xe3d1,0x0000,0x0000,0xd2bc,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd8ac,0xf3cc,
0x0000,0xcdfb,0xf6d6,0x0000,0xe7f5,0xe8ef,0xe3f9,0xd2bb,
0xf3f3,0xe3fb,0x0000,0xded0,0xceb0,0x0000,0xd6f7,0xf1d9,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf5c1,0xdcc4,0x0000,
0xf5bb,0x0000,0xded1,0x0000,0x0000,0x0000,0x0000,0x0000,
/* 0x5c00 */
0x0000,0xdce6,0x0000,0x0000,0xded2,0x0000,0x0000,0xede2,
0xeef6,0xeacf,0xf0ee,0xe3fc,0x0000,0xd3df,0xd3f4,0xe1b3,
0x0000,0xe1b4,0x0000,0x0000,0x0000,0x0000,0xf4d3,0x0000,
0x0000,0xdfc6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xe9d6,0x0000,0x0000,0x0000,
0xdbab,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf6a6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xe3b9,0xebc5,0xf4a9,0xcdb6,0xd2f9,0x0000,0xdaad,0xd2e3,
0xcfd1,0x0000,0x0000,0x0000,0x0000,0xcbdc,0xccfa,0x0000,
0xcfdd,0x0000,0x0000,0xe8a9,0x0000,0xe3bb,0xe3ba,0x0000,
0x0000,0xe0da,0x0000,0x0000,0x0000,0xeef7,0x0000,0x0000,
0x0000,0x0000,0x0000,0xdcb3,0x0000,0x0000,0x0000,0x0000,
0xd3f5,0x0000,0xd7a6,0x0000,0xf6b5,0xd7db,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xe1d5,0x0000,0x0000,0xd4ea,
0x0000,0xdfa3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xfddf,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd0f7,0xedd4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xcbaa,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xe4db,0x0000,0xe1fb,0xcba2,0x0000,0x0000,0x0000,
0x0000,0xd3e0,0x0000,0xe4bf,0x0000,0xfbc0,0x0000,0xdabe,
0xe4cd,0x0000,0xd6b9,0x0000,0x0000,0x0000,0xefc0,0x0000,
0xe1fc,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf6b9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xdfc7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xe4b1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xdce7,
0xdce8,0x0000,0x0000,0x0000,0xfad6,0x0000,0xd3f6,0x0000,
0x0000,0x0000,0x0000,0xf1da,0x0000,0xfaf2,0x0000,0x0000,
/* 0x5d00 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe2fd,
0x0000,0x0000,0x0000,0x0000,0x0000,0xd5cf,0xd0f8,0x0000,
0x0000,0xcddf,0x0000,0x0000,0xf5cb,0x0000,0xe4f0,0xcbab,
0x0000,0xd7c4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe2fe,
0x0000,0xddda,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xdaae,0xcaee,0x0000,0x0000,0x0000,
0xd5b9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xe3a1,0x0000,0x0000,0xe8e3,0x0000,0x0000,0xf3ab,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcfa9,
0x0000,0x0000,0x0000,0xd3f7,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xd4f1,0x0000,0x0000,
0xcee4,0x0000,0xe8f2,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xe5f5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xe7ae,0x0000,0xd6ba,0x0000,0xdfec,0xe4c0,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe8e4,0x0000,0x0000,
0x0000,0x0000,0xd8b5,0x0000,0x0000,0x0000,0xe4dc,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf4b9,0xf1b6,0x0000,
0x0000,0xe2de,0xe1b5,0x0000,0x0000,0xcdef,0xf1a7,0xcee5,
0xcbdd,0x0000,0x0000,0xd9e3,0x0000,0x0000,0xf3ac,0x0000,
0x0000,0xd0f9,0xecab,0xded3,0xf7e9,0x0000,0x0000,0xf9f5,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe1de,0xcbee,0x0000,
/* 0x5e00 */
0x0000,0x0000,0xe3bc,0xf8d6,0x0000,0x0000,0xdbee,0x0000,
0x0000,0x0000,0x0000,0x0000,0xfdf1,0x0000,0x0000,0x0000,
0x0000,0xf7b6,0x0000,0x0000,0x0000,0x0000,0xf4de,0x0000,
0x0000,0xf2ed,0x0000,0xdbd9,0x0000,0xf0a8,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe1fd,0x0000,0x0000,
0x0000,0x0000,0x0000,0xded4,0x0000,0xe0ac,0x0000,0x0000,
0x0000,0x0000,0x0000,0xede3,0x0000,0x0000,0xd3e1,0x0000,
0xdfc8,0x0000,0x0000,0x0000,0x0000,0xd9b6,0x0000,0xfdac,
0xefd3,0x0000,0x0000,0x0000,0xe4c1,0xf8eb,0x0000,0xdbac,
0x0000,0x0000,0x0000,0x0000,0xfcc6,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xd8ad,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf6ba,
0x0000,0xdbdf,0xd3d3,0xf8c7,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xcace,0xf8c1,0xd2b4,0x0000,0x0000,0xdcb4,
0xfab9,0xcacf,0x0000,0xfcb3,0xeaea,0xeaeb,0xd0fa,0x0000,
0x0000,0x0000,0x0000,0x0000,0xede4,0x0000,0x0000,0xdde7,
0x0000,0x0000,0xdfc9,0x0000,0x0000,0x0000,0x0000,0xdfed,
0x0000,0x0000,0x0000,0x0000,0x0000,0xeebc,0x0000,0xefc1,
0x0000,0x0000,0xccd2,0x0000,0xdda4,0x0000,0x0000,0x0000,
0xdfca,0x0000,0x0000,0x0000,0x0000,0x0000,0xd3f8,0xf1a8,
0x0000,0x0000,0x0000,0xcdb7,0x0000,0xefd4,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe4dd,0xdfee,0xcbac,
0xe9bc,0x0000,0x0000,0x0000,0x0000,0x0000,0xeaec,0x0000,
0x0000,0x0000,0xdfcb,0x0000,0x0000,0x0000,0x0000,0x0000,
0xf9bf,0xd6af,0xd5c6,0x0000,0x0000,0x0000,0x0000,0x0000,
0xcfaa,0x0000,0x0000,0xcea9,0x0000,0x0000,0xd6f8,0x0000,
0x0000,0x0000,0xf1b7,0xeef8,0x0000,0x0000,0x0000,0xd9d9,
0xf3df,0x0000,0xf8c8,0xcec6,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xd5e6,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xf4e6,0x0000,0x0000,0xe6c5,0xefd5,
0x0000,0x0000,0xcbef,0xfcdf,0x0000,0x0000,0x0000,0x0000,
/* 0x5f00 */
0x0000,0xdca7,0x0000,0x0000,0xd6e7,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf8c9,0x0000,0x0000,0x0000,0x0000,0xe3d2,
0x0000,0xe3bd,0x0000,0xcfe1,0xf0c0,0xecda,0x0000,0xddd7,
0xfbf0,0x0000,0x0000,0xecac,0x0000,0x0000,0x0000,0xf0a9,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfad7,0xfbc1,
0x0000,0xd2c0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xe5b0,0x0000,0x0000,0x0000,0xede5,0x0000,0x0000,
0x0000,0x0000,0xcbad,0x0000,0xf9b0,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xf7a5,0x0000,0xcbae,0x0000,0xdaaf,0x0000,0xd8b6,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd3a7,0xfbb2,
0x0000,0xfdc4,0x0000,0xecad,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xfba1,0x0000,0x0000,0x0000,0xe5e9,0xe9ee,
0x0000,0xf3f4,0xf8f3,0xf0c1,0xdeaf,0xf8b0,0x0000,0x0000,
0xf3e0,0xe7af,0x0000,0x0000,0x0000,0x0000,0x0000,0xdbad,
0x0000,0xe6b5,0x0000,0x0000,0xf9a8,0x0000,0x0000,0xddd8,
0xe8d9,0xefd6,0x0000,0x0000,0x0000,0xd3e2,0x0000,0xe2df,
0x0000,0x0000,0xfce0,0xd7c8,0xfdad,0x0000,0x0000,0x0000,
0xdfef,0xccd3,0xd3f9,0x0000,0x0000,0x0000,0x0000,0xd4f0,
0xdbc7,0xded5,0x0000,0x0000,0x0000,0x0000,0xf0f4,0x0000,
0xd5d0,0xe5d9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xfcc7,0xdcd6,0xe2e0,0x0000,0x0000,0x0000,0xdab0,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf3a3,0x0000,0xd3ec,
0x0000,0xf4cb,0x0000,0x0000,0x0000,0xfdc5,0x0000,0x0000,
0x0000,0x0000,0x0000,0xe3fd,0x0000,0xf9b1,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xd0fb,0xecdb,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf5bc,0xf2a4,
0xd8ce,0xd8cf,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xf5f7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xf6e1,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xd2b7,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xfbec,0x0000,0xddc8,
/* 0x6000 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe4e8,
0x0000,0x0000,0xd2c1,0x0000,0x0000,0x0000,0xf8d7,0x0000,
0x0000,0x0000,0x0000,0x0000,0xd6bb,0xded6,0x0000,0x0000,
0xf7bd,0xecae,0x0000,0x0000,0x0000,0xd0e1,0x0000,0xe0f5,
0xeab3,0x0000,0xced6,0x0000,0x0000,0x0000,0x0000,0xcca5,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xecf6,0xe2e1,0xe3be,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xfcc8,0x0000,0x0000,
0xcdf0,0x0000,0xf9f6,0x0000,0x0000,0xdff0,0x0000,0x0000,
0x0000,0xe5bf,0x0000,0x0000,0x0000,0xcebf,0x0000,0x0000,
0x0000,0x0000,0xfce1,0xedb0,0xfdd1,0xf6bb,0x0000,0x0000,
0xf9cf,0xebda,0xcac1,0x0000,0xd2b8,0xcdf1,0x0000,0xe3d3,
0xfde6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe6ed,0x0000,0x0000,
0x0000,0xe3fa,0x0000,0x0000,0xf0aa,0xf9d0,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xfce2,0x0000,0xf8a7,0x0000,
0x0000,0x0000,0xe1e5,0xeef9,0x0000,0x0000,0x0000,0xe7f6,
0xeaed,0x0000,0x0000,0xfcb4,0xf5c2,0x0000,0x0000,0xd7dc,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xf0f5,0x0000,0xdde8,0xd3ed,0xf5fc,0x0000,0xdabf,0x0000,
0xccfb,0x0000,0x0000,0x0000,0xd3fa,0xf4a4,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xefd7,0x0000,0xd4c3,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xfbe3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xfbed,0x0000,0xe0ad,0x0000,0x0000,0xeaee,
0xfbb3,0xe4c2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xf6e7,0xd2dd,0x0000,0xdfcc,0x0000,0x0000,0xfcc9,0x0000,
0x0000,0xe5a9,0xe0f6,0xf6b3,0x0000,0x0000,0x0000,0x0000,
/* 0x6100 */
0x0000,0xe1fe,0x0000,0x0000,0x0000,0x0000,0xcbf0,0x0000,
0xeaef,0xeaf0,0x0000,0x0000,0x0000,0xdac0,0xf8b4,0xebf2,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe4c3,0x0000,0x0000,
0x0000,0x0000,0xe9d7,0xe4f1,0x0000,0x0000,0x0000,0xcaef,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xced7,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xfcca,0x0000,0x0000,0x0000,0xf3e1,0x0000,0x0000,0xcbc4,
0x0000,0x0000,0x0000,0x0000,0xe3e5,0x0000,0xcbc5,0xeab4,
0x0000,0x0000,0xe9bd,0x0000,0xd7c9,0x0000,0x0000,0xebdb,
0xedb1,0x0000,0xccc3,0xf7be,0xfccb,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xf8f4,0x0000,0xd9b7,0x0000,0x0000,
0xf3d3,0xf3d4,0x0000,0x0000,0x0000,0xf7e4,0x0000,0xf7d1,
0x0000,0x0000,0xd8b7,0xceb1,0xcac2,0x0000,0x0000,0xfbb4,
0xcbc6,0x0000,0x0000,0xf0f6,0x0000,0x0000,0xd5e7,0x0000,
0xead0,0x0000,0x0000,0x0000,0x0000,0x0000,0xccd4,0xcbaf,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf4aa,0xe9af,0x0000,
0x0000,0xf5c3,0xe9d8,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xdde9,0x0000,0x0000,0x0000,0xf1f3,0x0000,
0xd5fb,0xdebb,0x0000,0x0000,0xf4fb,0x0000,0x0000,0x0000,
0xfdf3,0xfdf2,0xf7a6,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xddc9,0x0000,0x0000,0xd4d3,
0x0000,0xcca8,0x0000,0xdac1,0xccd5,0x0000,0xd9e4,0x0000,
0x0000,0x0000,0xfaca,0x0000,0x0000,0x0000,0xe5e3,0x0000,
0x0000,0x0000,0xd3bc,0x0000,0x0000,0x0000,0xcaf0,0x0000,
0x0000,0x0000,0x0000,0xd0c4,0x0000,0x0000,0x0000,0xcad0,
0xfaab,0xebeb,0xe7f8,0xd9e5,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd1d7,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf3a4,0x0000,0x0000,0x0000,0xd4fb,0xfce3,
0xfad8,0x0000,0xf3d5,0x0000,0xcfab,0x0000,0x0000,0xebf3,
0xd5fc,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd3d4,
0xcdfc,0x0000,0xd9e6,0x0000,0xe2f9,0xe2a1,0xebd4,0x0000,
0xe0f7,0xe4b2,0xccfc,0x0000,0x0000,0x0000,0xfbe4,0x0000,
0x0000,0x0000,0xf4ab,0x0000,0x0000,0x0000,0x0000,0xd0bd,
0x0000,0xcaf1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xefb8,0x0000,0x0000,0x0000,0xd7c0,0x0000,
0xeefa,0xfdf4,0x0000,0x0000,0xd3e3,0x0000,0xfbc2,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd5e8,0xdbae,
0xe1b6,0xf8b7,0x0000,0x0000,0x0000,0x0000,0x0000,0xe0bf,
0xfbc3,0xddea,0x0000,0xe2a2,0x0000,0xeea6,0x0000,0x0000,
0x0000,0x0000,0x0000,0xf6e8,0x0000,0x0000,0x0000,0x0000,
0xf6f5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xddca,0x0000,
0x0000,0xd0e2,0x0000,0x0000,0x0000,0x0000,0xdda6,0x0000,
0x0000,0xddeb,0x0000,0x0000,0xe4f9,0x0000,0x0000,0xe3af,
0xd0fc,0x0000,0x0000,0x0000,0xf4fc,0x0000,0x0000,0x0000,
0x0000,0xccbc,0xf7ea,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xe5e4,0xdff1,0x0000,0x0000,0xf7e1,0x0000,0xf9f7,
0xefb9,0x0000,0x0000,0xf8d8,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xf9a9,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf8d9,0x0000,0x0000,0x0000,0xeebd,0x0000,0x0000,
0x0000,0xd8c6,0x0000,0x0000,0xe4e3,0xf5ce,0x0000,0x0000,
0x0000,0x0000,0xddd9,0x0000,0x0000,0x0000,0x0000,0xd9e7,
0xd2b9,0xd5c3,0x0000,0x0000,0xdae5,0xdad0,0x0000,0xd1d9,
0xced8,0x0000,0xcbde,0xf4ac,0xdafb,0x0000,0xf6e9,0xe8f3,
0xcfac,0xf0f0,0x0000,0xf4fd,0xdbc8,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xcec0,0xe3d4,0xd1cf,0xf1f5,
0x0000,0xcdf2,0x0000,0xcfeb,0x0000,0x0000,0x0000,0xcdb8,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe3a6,0xd1da,
/* 0x6300 */
0x0000,0xf2a5,0x0000,0x0000,0x0000,0x0000,0x0000,0xf2a6,
0x0000,0xe4ce,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xd3fb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xf1a9,0x0000,0x0000,0x0000,0xf2c9,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xefd8,0xe6c9,0x0000,0xd8b8,0xfaf3,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf3b5,0x0000,0x0000,0xf8a4,0x0000,0x0000,0xd1f3,
0xe6c8,0x0000,0x0000,0x0000,0x0000,0xf8da,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xdce9,
0xded7,0x0000,0x0000,0x0000,0x0000,0x0000,0xcbdf,0x0000,
0x0000,0x0000,0xcfec,0x0000,0x0000,0x0000,0x0000,0xf4df,
0x0000,0x0000,0xd1f4,0xd2ba,0x0000,0x0000,0x0000,0xdff2,
0x0000,0x0000,0x0000,0xe1b7,0x0000,0x0000,0x0000,0x0000,
0xe2a3,0xd3fc,0x0000,0x0000,0xede6,0x0000,0x0000,0x0000,
0x0000,0x0000,0xdbc9,0x0000,0x0000,0x0000,0xe4fa,0x0000,
0xcfde,0x0000,0x0000,0xced0,0x0000,0x0000,0x0000,0x0000,
0xd5d3,0xf3f5,0xf7ae,0x0000,0x0000,0xefc8,0x0000,0xcdf3,
0xf5cf,0xe5f3,0xf0c2,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xcad1,0x0000,0x0000,0x0000,0xeaf1,0x0000,0xd0a6,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd9da,
0xf0ab,0x0000,0x0000,0x0000,0x0000,0x0000,0xebe7,0x0000,
0x0000,0x0000,0xe5c0,0xfcb5,0x0000,0x0000,0x0000,0x0000,
0x0000,0xe4c4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xcca9,0xfdc6,0x0000,
0x0000,0x0000,0x0000,0x0000,0xeab5,0x0000,0xe5aa,0xdfba,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
/* 0x6400 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe1df,0x0000,0xdad1,
0x0000,0x0000,0x0000,0x0000,0xe1b8,0x0000,0xe8f4,0xd3fd,
0x0000,0x0000,0x0000,0x0000,0xe2a4,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf2ca,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xdae6,0xf7b3,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xfdcd,0x0000,0x0000,0x0000,0xf3b6,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xeed7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xf5c4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xd8a4,0x0000,0x0000,0x0000,0x0000,0x0000,0xf2a7,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd9b8,0xd9b9,0xefc9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd6ce,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf7cb,0xdfae,0xe8f5,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd2b5,0x0000,0x0000,0x0000,0xd3d5,0x0000,
0x0000,0x0000,0x0000,0x0000,0xf4cc,0xdafc,0x0000,0x0000,
0x0000,0x0000,0x0000,0xd9e8,0x0000,0xf7eb,0xf5c9,0x0000,
0xf3bc,0x0000,0xdad2,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xd3b5,0x0000,0x0000,0x0000,0x0000,
0x0000,0xe8b6,0x0000,0x0000,0xd6cf,0xf4ba,0x0000,0xf7c9,
0x0000,0x0000,0xccaa,0x0000,0x0000,0xf0c3,0xccd6,0x0000,
0x0000,0x0000,0xd0d3,0x0000,0xd3bd,0x0000,0x0000,0x0000,
0xdbfb,0x0000,0xcbe0,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xd3e4,0xf6f7,0x0000,0x0000,0xd5ba,0xf3cd,0xcbe1,
0x0000,0x0000,0x0000,0x0000,0xebf4,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf4ad,0x0000,0xfcaa,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf7ec,0x0000,0x0000,0x0000,0xe8f6,0x0000,
0xdae7,0x0000,0x0000,0x0000,0xf7cc,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xe5c1,0x0000,0x0000,0x0000,0x0000,0xe0ee,0x0000,0x0000,
0x0000,0x0000,0x0000,0xd5fd,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xcee6,0xfcab,0xd5bb,0x0000,0x0000,0xf2a8,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe2a5,0xcdb9,
0xeaf2,0xcbc7,0x0000,0xcdf4,0x0000,0x0000,0xdbaf,0xefd9,
0x0000,0x0000,0x0000,0x0000,0x0000,0xcdba,0x0000,0x0000,
0xfcf9,0x0000,0x0000,0x0000,0x0000,0xdff3,0xcee7,0xdac2,
0x0000,0xcfad,0x0000,0x0000,0x0000,0x0000,0xe7f9,0xf8a8,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf3e2,0x0000,
0x0000,0x0000,0xcaf2,0xdfa4,0x0000,0x0000,0xd4c4,0x0000,
0x0000,0x0000,0x0000,0x0000,0xccd7,0xe5c2,0x0000,0x0000,
0x0000,0x0000,0xcdbb,0x0000,0xefda,0xeed8,0x0000,0xdda7,
0xe2a6,0x0000,0x0000,0x0000,0x0000,0x0000,0xe0c0,0x0000,
0x0000,0x0000,0xd6b0,0xf8ca,0x0000,0xfcfa,0x0000,0xd9fe,
0x0000,0x0000,0x0000,0x0000,0xdeb0,0x0000,0x0000,0x0000,
0xddec,0xdae8,0x0000,0x0000,0x0000,0x0000,0x0000,0xd4e0,
0x0000,0xd6f9,0x0000,0xcdd7,0xded8,0x0000,0x0000,0xf2f8,
0x0000,0xe4d6,0x0000,0x0000,0xd0c5,0xf4ae,0x0000,0xdda8,
0x0000,0x0000,0x0000,0xedc5,0xf3d6,0x0000,0x0000,0xded9,
0xe3e6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd3a8,
0x0000,0xdbb0,0x0000,0x0000,0xe5da,0xe3bf,0x0000,0x0000,
0x0000,0xdbb1,0x0000,0x0000,0x0000,0xd5e9,0x0000,0x0000,
0x0000,0x0000,0x0000,0xe0c1,0xefdb,0x0000,0x0000,0xf0e9,
0x0000,0x0000,0xd7b2,0x0000,0x0000,0x0000,0x0000,0xd0fd,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd9e9,0x0000,0x0000,0xd0fe,0x0000,0xeced,0xd3a9,0x0000,
0xf2a9,0xf0c4,0x0000,0x0000,0xe2e2,0xe9ef,0x0000,0x0000,
0x0000,0xf9d1,0x0000,0x0000,0xe9d9,0x0000,0x0000,0x0000,
0x0000,0x0000,0xe8da,0xdac3,0xdac4,0xd4c5,0x0000,0xe7fa,
/* 0x6600 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcde0,0xe3b0,
0x0000,0xdbb2,0xfbc4,0x0000,0xf3e3,0x0000,0xd9a5,0xfbe7,
0xddcb,0xd0d4,0x0000,0xe6b6,0xe0ae,0xfdda,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xdcb5,0xe0f8,
0xe7b1,0x0000,0x0000,0x0000,0x0000,0xf5f0,0x0000,0xd8dc,
0xedc6,0x0000,0x0000,0x0000,0x0000,0xe1b9,0x0000,0xe3c0,
0xf9c0,0xe9f0,0x0000,0x0000,0xd9db,0x0000,0xf3e4,0x0000,
0x0000,0x0000,0xdcb6,0xe4e9,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf0c5,0xe3c1,0xfccc,0xfccd,0x0000,0x0000,0x0000,
0x0000,0xf2cb,0x0000,0xf2cc,0x0000,0x0000,0x0000,0xe4cf,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf1db,0x0000,0xfad9,0x0000,0xf1b8,0xfdf5,0xe0f9,
0x0000,0x0000,0x0000,0x0000,0xe7fb,0xfcb7,0xfce4,0xfbc5,
0xe3e7,0xd8b9,0x0000,0xf6f8,0x0000,0x0000,0xdcc5,0xccd8,
0x0000,0x0000,0x0000,0xe0af,0xf4e7,0x0000,0xefdc,0xcffc,
0xefdd,0x0000,0xf2aa,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xfdbe,0x0000,0x0000,0xcaac,
0xfdbb,0xfdc7,0x0000,0x0000,0x0000,0x0000,0xe7b2,0x0000,
0xead1,0xdff4,0x0000,0x0000,0x0000,0x0000,0xd1ec,0xe4de,
0xe5c3,0x0000,0x0000,0x0000,0x0000,0xd9a6,0x0000,0x0000,
0xcdbc,0x0000,0xf3e5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xedd5,0x0000,0x0000,0xd9ba,0x0000,
0x0000,0x0000,0xede7,0xfbb5,0xf8ec,0x0000,0x0000,0x0000,
0x0000,0xe0e7,0x0000,0xccd9,0x0000,0x0000,0xd4c6,0x0000,
0x0000,0x0000,0x0000,0x0000,0xe7a5,0x0000,0xd5f5,0xd3be,
0x0000,0xfcfb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe4f2,0x0000,
0x0000,0xdff5,0x0000,0x0000,0xe8f8,0xf8ed,0x0000,0x0000,
0xcec7,0x0000,0x0000,0x0000,0x0000,0x0000,0xfdf6,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xe8d8,0x0000,0xcdd8,0xe7d6,0xccda,0x0000,0x0000,0xcae3,
0xdff6,0xf0c7,0xf0c6,0x0000,0xd8ba,0x0000,0xf1f4,0xf4f0,
0xf5cc,0x0000,0x0000,0xfce5,0x0000,0x0000,0x0000,0x0000,
0xeac5,0xeaf3,0x0000,0xdddb,0x0000,0xdcd7,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xdefd,0xf2f9,0x0000,0xd5c7,
0x0000,0x0000,0x0000,0xd8d0,0x0000,0xf0c8,0xd1a1,0xd1a2,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd9d4,0xd6e8,
0xd9ca,0x0000,0xdab1,0xd8c7,0xdce2,0xf3ce,0xf5f4,0x0000,
0x0000,0xf1b9,0x0000,0x0000,0xdad3,0x0000,0xf6ea,0x0000,
0x0000,0x0000,0xcff5,0x0000,0x0000,0xfdae,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcad2,0x0000,
0x0000,0xdfb4,0x0000,0x0000,0x0000,0x0000,0xd7dd,0xfaba,
0xeea7,0xf5bd,0x0000,0xf8f5,0x0000,0x0000,0xede8,0x0000,
0x0000,0x0000,0x0000,0x0000,0xd4e1,0x0000,0xd1a3,0xe1d6,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf9f8,0x0000,0xdbca,
0xcbf9,0xd4d4,0x0000,0xd9dc,0x0000,0xeebe,0x0000,0xf7ed,
0x0000,0x0000,0x0000,0xd2ee,0x0000,0x0000,0xe1e6,0xf7f9,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xdded,
0x0000,0xe8db,0x0000,0xdbb3,0x0000,0x0000,0x0000,0xd1f7,
0xe0b0,0x0000,0x0000,0xd4e2,0x0000,0xf6d7,0x0000,0xd7f9,
0x0000,0x0000,0xd8dd,0x0000,0xcdfd,0xf2ab,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcdbd,
0xf8c2,0x0000,0x0000,0xf2ac,0x0000,0x0000,0xcaad,0xcaae,
0xcfae,0x0000,0x0000,0x0000,0x0000,0x0000,0xe3c2,0x0000,
0x0000,0x0000,0x0000,0x0000,0xdcb7,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xdbda,
0xd9bb,0xcaf3,0xf6d3,0xe6f8,0xeaf5,0x0000,0x0000,0x0000,
0x0000,0x0000,0xeaf6,0x0000,0x0000,0xf6f9,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xcfaf,0x0000,0x0000,0xcad3,0x0000,0x0000,0xcaaf,
0xd2b0,0xf1ba,0x0000,0xd7b3,0xe3c3,0xf3fd,0xdeda,0x0000,
0x0000,0x0000,0x0000,0xdedb,0x0000,0x0000,0xefde,0x0000,
/* 0x6800 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xe2e3,0xeefb,0x0000,0x0000,0xdff7,0xd7ca,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xcee8,0xdbdb,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf1bb,0x0000,0x0000,0x0000,0x0000,0xe9f1,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xfab7,0xd0c6,0x0000,0x0000,0xccab,0xeea8,0x0000,0x0000,
0xcbfa,0xf9f9,0xccfd,0xd3fe,0x0000,0x0000,0x0000,0x0000,
0xe4d0,0x0000,0x0000,0x0000,0x0000,0x0000,0xf2ee,0x0000,
0xd4d5,0xdfcd,0x0000,0xfcb8,0xd1d0,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf2cd,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf7d2,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcad4,
0x0000,0xd5d9,0x0000,0x0000,0x0000,0xd8de,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcdd9,
0x0000,0x0000,0x0000,0xeea9,0xf6bc,0x0000,0x0000,0xccdb,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf0c9,0x0000,0xfcfc,
0x0000,0xe8c9,0xf4fe,0x0000,0x0000,0x0000,0x0000,0xe7fc,
0xd7de,0x0000,0x0000,0x0000,0x0000,0xdedc,0x0000,0xf0ac,
0xccfe,0xcde1,0x0000,0xe1ba,0x0000,0xdbef,0xdab2,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xd1a5,0xdcb8,0x0000,0x0000,
0x0000,0xd8f6,0x0000,0xd1a4,0x0000,0xcde2,0x0000,0x0000,
0x0000,0x0000,0xdcea,0x0000,0x0000,0xf0f7,0x0000,0xf0ca,
0xd0be,0x0000,0xdddc,0x0000,0x0000,0x0000,0x0000,0xd4d6,
0xd3d6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xedd0,
0xcda1,0x0000,0x0000,0x0000,0x0000,0x0000,0xdfb5,0x0000,
0x0000,0x0000,0xdff8,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xd4a1,0xceb2,0x0000,0x0000,0x0000,0x0000,0x0000,
0xe8ca,0x0000,0x0000,0x0000,0x0000,0xebf5,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe3d5,0xf5d0,0x0000,
0x0000,0x0000,0xf5a1,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd9a7,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xe5ab,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe6cb,0x0000,0xf5f1,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xe5c5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xf9a3,0xe0db,0xf6eb,0x0000,0xcbf1,
0x0000,0xd9ea,0xf5a2,0x0000,0x0000,0x0000,0xd7d1,0x0000,
0xd1f8,0xeaf8,0xeaf9,0xdab3,0x0000,0x0000,0x0000,0x0000,
0xefdf,0x0000,0x0000,0xf1ef,0x0000,0xe5f6,0xeebf,0xe2e4,
0x0000,0x0000,0x0000,0x0000,0x0000,0xd0bf,0x0000,0xfaac,
0xf5d1,0xe7b3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe9be,0x0000,0x0000,
0x0000,0x0000,0x0000,0xf2ce,0xdbb4,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xfcce,0x0000,0xddee,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe7b4,0x0000,
0x0000,0x0000,0x0000,0x0000,0xd7b4,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xf7b4,0x0000,0x0000,0x0000,0x0000,
0x0000,0xcdbe,0x0000,0xdae9,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xcfb0,0xf7d9,0xf3e6,0x0000,0x0000,
0xced9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xceaa,0x0000,0xcbc8,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xd0a7,0x0000,0xf0cb,0x0000,0xd0c7,
/* 0x6a00 */
0x0000,0x0000,0xe4c5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xdbe0,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xd5da,0x0000,0xd7a7,0x0000,0x0000,0x0000,0xeec0,
0x0000,0xf8f6,0x0000,0x0000,0x0000,0x0000,0xf5d2,0xede9,
0x0000,0xd9bc,0x0000,0xe5c6,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf5a3,0x0000,0x0000,
0xdad4,0xe2a7,0xfbfc,0x0000,0x0000,0xf1dc,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xcaf4,0x0000,0x0000,0x0000,
0xe8fa,0x0000,0x0000,0xcee9,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xe9f8,0xe2e5,0x0000,0x0000,0x0000,0x0000,
0xd0b9,0xd4f2,0x0000,0x0000,0x0000,0x0000,0x0000,0xd1a6,
0x0000,0xdfce,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xfcf4,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd3aa,0x0000,0x0000,0x0000,0xccac,0x0000,0x0000,0x0000,
0x0000,0xefe0,0x0000,0x0000,0x0000,0xe5e5,0xd0d5,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xdbfc,
0x0000,0x0000,0x0000,0x0000,0xfce6,0x0000,0x0000,0x0000,
0x0000,0x0000,0xcbfe,0xedea,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xdeb1,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xf9e3,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd4a2,0xcff6,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xd6d0,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd5ea,0xf1ee,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfacb,0x0000,
0x0000,0x0000,0x0000,0xe5a1,0x0000,0x0000,0x0000,0x0000,
/* 0x6b00 */
0x0000,0x0000,0x0000,0x0000,0xd5b1,0x0000,0x0000,0x0000,
0x0000,0x0000,0xcfed,0x0000,0xedeb,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd5b2,0x0000,0x0000,0x0000,0xd5bc,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xfde2,0xf3ad,0x0000,0xfddb,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xe9b0,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd1a7,0x0000,0x0000,0xfde3,0xceb3,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfde4,0xface,
0x0000,0x0000,0x0000,0x0000,0xcab0,0x0000,0xf7a7,0x0000,
0xcfb1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe6a2,
0x0000,0xfcb6,0xf2ad,0xefe1,0xf3ae,0xdcc6,0xd9eb,0x0000,
0x0000,0x0000,0xe8e0,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xe1a8,0x0000,0x0000,0x0000,0x0000,0xd5f6,
0xcffd,0x0000,0x0000,0xdedd,0x0000,0x0000,0x0000,0xd9d1,
0x0000,0x0000,0x0000,0xe4ea,0xf2cf,0x0000,0xf7bf,0x0000,
0x0000,0xe2e6,0xe2a8,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe3d6,0x0000,
0xedd1,0x0000,0x0000,0x0000,0x0000,0x0000,0xe9f9,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd6b1,0xdeb2,
0x0000,0x0000,0xe0e8,0x0000,0x0000,0xd3ab,0x0000,0xebdc,
0x0000,0x0000,0xdfaf,0x0000,0xcac3,0x0000,0x0000,0xeefc,
0x0000,0xfdc3,0x0000,0x0000,0x0000,0xebf6,0xcfb2,0x0000,
0x0000,0x0000,0x0000,0xd9ec,0x0000,0xd9bd,0x0000,0xd8df,
0x0000,0x0000,0xd4b8,0xebbe,0xddef,0x0000,0xddf0,0xddf1,
0xddf2,0x0000,0x0000,0xd9be,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xfbc6,0xcfb3,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
/* 0x6c00 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xeefd,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe4ab,
0x0000,0xdac5,0x0000,0xd8ec,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xd1a8,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xe2a9,0x0000,0x0000,0xdebc,
0xe7b5,0x0000,0x0000,0x0000,0x0000,0x0000,0xdbf0,0x0000,
0xefe2,0xf1f0,0xcfb4,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xdbf1,0x0000,
0xe0b1,0x0000,0x0000,0x0000,0x0000,0xdfa5,0x0000,0xf9d2,
0x0000,0x0000,0xe7fd,0x0000,0x0000,0xe6a3,0xfbf1,0xcbb0,
0xf2ae,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xcde7,0x0000,0xe8dc,0x0000,0x0000,0xe7d7,0x0000,0x0000,
0xf7c0,0x0000,0xd0e3,0x0000,0x0000,0x0000,0xdaa1,0x0000,
0x0000,0x0000,0xccbd,0x0000,0x0000,0xd1a9,0xddcc,0x0000,
0x0000,0xe3fe,0xd1aa,0xe8aa,0x0000,0xeab6,0xf9fa,0xe6cc,
0xf6d8,0x0000,0x0000,0x0000,0xd4c7,0x0000,0x0000,0x0000,
0xd9cb,0x0000,0xd9d2,0xd3cb,0xd8f7,0xdaa9,0xf5f8,0x0000,
0x0000,0xdede,0xf2af,0xf8a9,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xd8c8,0x0000,0x0000,0xeec1,0x0000,
0x0000,0x0000,0x0000,0xf9c1,0x0000,0x0000,0x0000,0x0000,
0xddf3,0xeafa,0x0000,0xf6bd,0xe1bb,0xcdbf,0xf4d4,0xe6cd,
0x0000,0xfccf,0xfba2,0x0000,0xe0dc,0x0000,0x0000,0x0000,
0x0000,0xf4bb,0xdad5,0x0000,0xf9b2,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xfbf2,0x0000,0xdbf6,0x0000,0xdedf,
0x0000,0x0000,0x0000,0xdbf2,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf8dc,0xf7ee,0xebe8,0x0000,0xd2fa,0x0000,0x0000,
0xf1bc,0x0000,0x0000,0xfada,0x0000,0x0000,0xdaea,0xdac6,
0xf7c1,0x0000,0x0000,0xe7b6,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
/* 0x6d00 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xe5c7,0xd6ac,0x0000,0x0000,0x0000,
0x0000,0xdcc7,0x0000,0x0000,0x0000,0x0000,0x0000,0xe1a9,
0x0000,0xe2aa,0x0000,0xd5a6,0x0000,0x0000,0xd4d7,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf2d0,0x0000,0xeafb,
0x0000,0xe0dd,0xfbf3,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf1bd,0x0000,0x0000,0xe2e7,0xfdd7,0x0000,
0xcec8,0xeab7,0x0000,0xfcc0,0x0000,0xfde7,0xf7ef,0x0000,
0x0000,0xd7b5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xefba,0xf1dd,0x0000,0xdeb3,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xe8cb,0x0000,0x0000,0xf8dd,0x0000,
0x0000,0xfbc7,0xd5c8,0x0000,0xd7df,0x0000,0xdda9,0x0000,
0x0000,0x0000,0x0000,0x0000,0xe9b1,0x0000,0x0000,0xfaad,
0xf6d9,0xfaf4,0x0000,0x0000,0x0000,0x0000,0x0000,0xf8aa,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe6ee,0x0000,0xccdc,
0xe1bc,0xe0ef,0x0000,0x0000,0xe9bf,0xfcfd,0xe6ce,0x0000,
0x0000,0xe1d7,0x0000,0xe6cf,0x0000,0xf4f1,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe4f3,
0x0000,0x0000,0xe4fb,0x0000,0x0000,0xf9e4,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xefe3,0x0000,0x0000,0xcfee,0xf6be,0xe0b2,0xfcfe,0xd1ab,
0x0000,0x0000,0x0000,0xd7fa,0x0000,0x0000,0x0000,0xfbc8,
0x0000,0xe2d7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd4a3,0xf0f8,0xd7a8,0x0000,0x0000,0x0000,0xe1e7,0x0000,
0x0000,0xd3bf,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xefe4,0x0000,0xd7c5,0xebe2,0x0000,0x0000,0xfce7,0x0000,
0x0000,0xe4a2,0x0000,0xe2e8,0x0000,0xe6d0,0x0000,0xfbe8,
0xf4e8,0xe5f4,0xf4bc,0xf4d5,0x0000,0x0000,0x0000,0x0000,
/* 0x6e00 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xdfb6,
0x0000,0xfcb9,0xeec2,0xcaf5,0x0000,0x0000,0x0000,0xefe5,
0xcbe2,0xd4a4,0x0000,0xdee0,0xdafd,0xe4c6,0xe8be,0x0000,
0x0000,0x0000,0x0000,0xe0de,0xf6b4,0xead2,0x0000,0xf9fb,
0x0000,0x0000,0xe0c2,0x0000,0xcae4,0x0000,0xe7b7,0x0000,
0xeafd,0x0000,0xd9dd,0x0000,0xdab4,0xeeaa,0xfbe9,0x0000,
0x0000,0x0000,0x0000,0xdbcb,0xdab5,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf1be,0x0000,0x0000,0xd3ac,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfbc9,0x0000,
0xdfcf,0x0000,0x0000,0xd3c0,0xe3d7,0x0000,0xefe6,0xfcd0,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe9c0,
0x0000,0x0000,0x0000,0xf5d3,0x0000,0x0000,0xecdc,0xf7b7,
0x0000,0x0000,0xeab8,0xd1f9,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xdcc8,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xeab9,0x0000,0x0000,0x0000,0x0000,0x0000,0xf1de,0x0000,
0x0000,0x0000,0x0000,0x0000,0xd7b6,0xcfb5,0x0000,0xd9a8,
0x0000,0x0000,0xecee,0x0000,0x0000,0xddaa,0x0000,0x0000,
0x0000,0x0000,0xcda2,0xe8ae,0x0000,0x0000,0x0000,0xe1bd,
0x0000,0xf2d1,0x0000,0x0000,0x0000,0x0000,0xe9c1,0x0000,
0x0000,0x0000,0xd2fc,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xdbb5,0x0000,0xf3e7,0xd8fe,0x0000,0x0000,
0x0000,0xfcd1,0x0000,0xedb2,0xf4af,0x0000,0xfba3,0x0000,
0x0000,0xfcc1,0x0000,0xeeab,0xd4a5,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf4f2,
0x0000,0x0000,0x0000,0x0000,0xeed9,0x0000,0x0000,0x0000,
0xfbca,0x0000,0x0000,0x0000,0x0000,0x0000,0xcde3,0xd8bb,
/* 0x6f00 */
0x0000,0xe5db,0xf8f7,0x0000,0x0000,0x0000,0xf6d4,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd7a9,
0x0000,0xcbc9,0x0000,0x0000,0xe6d1,0xf0cc,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd8ae,0x0000,0xf9d3,0xd5fe,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xd8bc,0xf2b0,0x0000,0x0000,0x0000,
0x0000,0xe2ab,0xf3e8,0x0000,0x0000,0x0000,0x0000,0x0000,
0xefc2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xedec,
0x0000,0xe7b8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xdafe,0x0000,0x0000,0xccbe,0x0000,0x0000,0xf2fc,
0xdaeb,0x0000,0xe2d8,0xedd6,0x0000,0x0000,0xd6d1,0xe0b3,
0x0000,0x0000,0xfcd2,0x0000,0xebc8,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xd3c1,0xf0cd,0x0000,
0xcff7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xedd2,0x0000,0xd4d8,0xdcc9,0xd7f1,0x0000,
0x0000,0xdfbb,0x0000,0x0000,0xf3a5,0x0000,0x0000,0x0000,
0xf4cd,0x0000,0x0000,0x0000,0x0000,0xf1bf,0xf8b1,0x0000,
0xe9fa,0x0000,0x0000,0x0000,0xfbcb,0x0000,0x0000,0xcad5,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xf9d4,0xf7ca,0x0000,0x0000,0xd6c8,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfce8,0xf3bd,
0x0000,0xeefe,0x0000,0xe7fe,0x0000,0x0000,0x0000,0x0000,
0x0000,0xd3c2,0x0000,0x0000,0x0000,0x0000,0xd3b6,0x0000,
0xccad,0xf6fa,0xd6b2,0xd2d8,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xe7d8,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe3a5,0x0000,0x0000,
0x0000,0x0000,0xe7b9,0x0000,0x0000,0x0000,0x0000,0xf0ad,
0xfbcc,0xeba1,0x0000,0x0000,0xd4a6,0x0000,0x0000,0x0000,
0x0000,0xfbcd,0x0000,0xd5bd,0xf1df,0x0000,0x0000,0xf6fb,
0x0000,0xdeb4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd5eb,0x0000,
/* 0x7000 */
0x0000,0xe5c8,0x0000,0x0000,0x0000,0xfba4,0xd4b9,0x0000,
0x0000,0xdee1,0x0000,0xe4a3,0x0000,0x0000,0x0000,0xd7b7,
0x0000,0xf8ee,0x0000,0x0000,0x0000,0xdeb5,0x0000,0x0000,
0xd6d2,0x0000,0xf9d5,0xe7ba,0xebd5,0xd5f7,0xefe7,0xe1be,
0x0000,0x0000,0x0000,0xfaae,0x0000,0x0000,0x0000,0xd6e9,
0xd6ee,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe7bb,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xeccb,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd5b3,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xceb4,0x0000,0x0000,0x0000,
0xfba5,0xe1ee,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xf7a8,0x0000,0x0000,0x0000,0x0000,0xfbce,0x0000,0x0000,
0x0000,0x0000,0x0000,0xd8bd,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xfbfd,0x0000,0x0000,0x0000,0x0000,
0xfce9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xcfb6,0x0000,0x0000,0x0000,0xedc7,0xeeac,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xccdd,0x0000,0x0000,
0x0000,0x0000,0xf6a7,0x0000,0x0000,0x0000,0xe6fa,0x0000,
0x0000,0x0000,0xf5a4,0x0000,0x0000,0x0000,0x0000,0x0000,
0xfddc,0xedb3,0xcec9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xefe8,0x0000,0x0000,0xe1bf,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xfadb,0xcbe3,0xf7a9,0x0000,0xfba6,
0x0000,0x0000,0x0000,0xdcb9,0x0000,0x0000,0x0000,0xf1c0,
0xedc8,0xefc3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd6ad,0x0000,0x0000,0xfdce,0x0000,0x0000,0x0000,0xe8a1,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xfbf4,0xd5a7,0x0000,0x0000,0x0000,0xf1f6,0x0000,0xe6d3,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xccde,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf8b2,0x0000,0x0000,0x0000,0xdceb,0x0000,0x0000,
/* 0x7100 */
0x0000,0x0000,0x0000,0x0000,0xfdb6,0x0000,0x0000,0x0000,
0x0000,0xe5ea,0x0000,0x0000,0xf1e0,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xdbcc,0xddcd,0x0000,0x0000,0x0000,0xd4c8,0x0000,
0x0000,0xd9ed,0x0000,0x0000,0x0000,0x0000,0xf5a5,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xe6fb,0x0000,0x0000,0x0000,0x0000,0x0000,0xe6d4,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfdc8,
0x0000,0xd6a1,0xfdbf,0x0000,0xfcd3,0x0000,0xefa1,0x0000,
0xe7bc,0x0000,0x0000,0x0000,0x0000,0x0000,0xd1ee,0x0000,
0x0000,0xe6d5,0x0000,0x0000,0xe9f2,0x0000,0xdfb0,0x0000,
0x0000,0x0000,0x0000,0x0000,0xd8e0,0xfcba,0xfdaf,0xf0ce,
0x0000,0xdbe1,0x0000,0x0000,0xe5c9,0x0000,0xedb4,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe0c3,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xe3d8,0x0000,0x0000,0x0000,
0x0000,0xe9fb,0xeaa8,0x0000,0x0000,0x0000,0x0000,0xfdb7,
0x0000,0x0000,0xfba7,0x0000,0xe9c2,0x0000,0x0000,0x0000,
0x0000,0xfdf7,0x0000,0x0000,0x0000,0x0000,0x0000,0xe2d9,
0x0000,0x0000,0xdcec,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xe8a2,0x0000,0x0000,0x0000,
0x0000,0xe6f0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xfdf8,0xfdf9,0x0000,0x0000,0x0000,0xf6bf,0x0000,
0x0000,0xe7a7,0x0000,0xe6d7,0x0000,0x0000,0x0000,0x0000,
0xd4f3,0xd4c9,0x0000,0x0000,0x0000,0x0000,0xd6fa,0x0000,
0xd7f2,0x0000,0xe1c0,0x0000,0xdbe2,0xe6d8,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe7bd,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf0cf,0xf3be,0xe2ac,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf5b7,0xe0f0,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xfdb8,0xe3e8,0x0000,0xd4a7,0xe8fc,
0xfad2,0x0000,0x0000,0x0000,0x0000,0x0000,0xf8ef,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd6d3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xd5b4,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf0d0,0x0000,0xf7f0,0xeeb3,0x0000,0x0000,
0xeaba,0x0000,0xead3,0x0000,0x0000,0xedc9,0xddab,0x0000,
0x0000,0x0000,0xe5ac,0xfda1,0x0000,0xdfd0,0xecb3,0x0000,
0xdfd1,0x0000,0x0000,0x0000,0x0000,0x0000,0xeded,0xf8b8,
0xf7fa,0x0000,0x0000,0x0000,0xf8ab,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf4e0,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd4ba,0xe4b3,0x0000,0xe9da,0x0000,0xdeb6,0x0000,0xd9bf,
0x0000,0xd9c0,0xd6ef,0x0000,0x0000,0x0000,0x0000,0xd9cc,
0x0000,0xdaaa,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xdfe5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf7e5,0x0000,0x0000,0x0000,0xccb2,0x0000,0x0000,
0xdff9,0xd7e0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd4bb,0x0000,0x0000,0x0000,0x0000,0xfdfa,
0x0000,0x0000,0x0000,0x0000,0xccb3,0x0000,0x0000,0xdbf3,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xdfd2,0x0000,0xceca,0x0000,0xeeda,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe4e4,0x0000,
0xfbcf,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcfb7,
0x0000,0xeec3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xceea,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xe2ad,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd7e1,0xfaf5,0x0000,0x0000,0xd5c9,0xf8ac,0x0000,0x0000,
/* 0x7300 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xe7d9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf3e9,0x0000,
0x0000,0x0000,0x0000,0xd8ed,0xe3c4,0xf0f1,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe8e5,0x0000,0x0000,
0x0000,0xe0fa,0xeec4,0xd9de,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xeba2,0xeba3,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfcc2,0xeabb,
0x0000,0x0000,0x0000,0x0000,0xe8ab,0xdee2,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xedef,0x0000,0xe8a3,0x0000,0x0000,0x0000,0x0000,0xcff1,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd4bc,0x0000,0xfcea,0x0000,0x0000,0x0000,0x0000,0x0000,
0xe7be,0x0000,0xfcf2,0x0000,0x0000,0xd6b4,0x0000,0x0000,
0xe2ae,0x0000,0xd3b7,0xfacc,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xfadc,0x0000,0xedb5,0xe1e3,
0x0000,0xe8ac,0x0000,0xe8dd,0x0000,0x0000,0xefe9,0x0000,
0x0000,0x0000,0x0000,0x0000,0xf4bd,0x0000,0xcfb8,0xe9db,
0xd1ac,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xdac7,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xebc9,
0x0000,0xe8cc,0x0000,0x0000,0x0000,0xdeb7,0x0000,0x0000,
0x0000,0x0000,0xd6bc,0xd3e5,0x0000,0x0000,0x0000,0x0000,
0x0000,0xfadd,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xdad6,0x0000,0xcab1,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xdac8,0xdfa6,0x0000,0xf9b3,0xf2d2,0x0000,0xcac4,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcecb,0x0000,
0x0000,0xcdf5,0x0000,0x0000,0x0000,0xfdb0,0xd5a8,0x0000,
0xf1c1,0x0000,0x0000,0xe2e9,0xdcca,0xecb4,0xfac0,0x0000,
0x0000,0xfba8,0xd0a8,0x0000,0x0000,0xdaec,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd9ee,
0x0000,0xe0fb,0x0000,0x0000,0x0000,0xefea,0xfade,0x0000,
/* 0x7400 */
0x0000,0xe0c4,0x0000,0xcfb9,0x0000,0xd5ca,0xd7e2,0xe2af,
0x0000,0xd7b8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xe8cd,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xf6da,0x0000,0x0000,0x0000,0x0000,
0xefa2,0xe2da,0xf6fc,0x0000,0x0000,0xfbd0,0xd1ad,0x0000,
0xcde4,0x0000,0xd1ae,0xdced,0xe8ce,0x0000,0xf0f9,0xceb5,
0xe6fc,0x0000,0x0000,0xd7fb,0xd0d6,0xddf5,0xf7f1,0x0000,
0xf6fd,0x0000,0xdbf7,0x0000,0x0000,0x0000,0x0000,0xfbea,
0xe9dc,0xd9c1,0x0000,0xf5f2,0xe0c5,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xead4,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf9c2,0x0000,0xeabc,
0x0000,0xd2c5,0xfbd1,0xe7c0,0xeba5,0x0000,0xdffa,0xe3a2,
0xd7b9,0x0000,0xe9c3,0x0000,0xe8fd,0xe8af,0x0000,0x0000,
0xf2d3,0xfba9,0xd8a5,0x0000,0x0000,0x0000,0x0000,0xd5cb,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd0c8,0x0000,
0x0000,0x0000,0xd1af,0xd7e3,0x0000,0x0000,0x0000,0xe0c6,
0x0000,0xd6a2,0x0000,0xedf0,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd7f3,0x0000,0x0000,0x0000,0xfcd4,0x0000,0xdad7,0xccdf,
0x0000,0xf2d4,0x0000,0xd1b0,0x0000,0xcce0,0x0000,0xdbfd,
0xf3bf,0x0000,0xf0d1,0x0000,0x0000,0x0000,0x0000,0x0000,
0xfcbb,0x0000,0xe2b0,0x0000,0x0000,0xe6a5,0x0000,0x0000,
0x0000,0xe2db,0x0000,0x0000,0x0000,0xdfde,0x0000,0xe0c7,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf2ef,0x0000,
0x0000,0x0000,0xcce1,0x0000,0x0000,0x0000,0x0000,0xd6ea,
0x0000,0x0000,0x0000,0x0000,0xe7c2,0x0000,0x0000,0x0000,
0xceb6,0x0000,0xf3c0,0x0000,0xcdfe,0x0000,0x0000,0x0000,
0xfbd2,0x0000,0xf8f8,0xf7fb,0x0000,0x0000,0xe8bf,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe8b7,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xedb6,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
/* 0x7500 */
0x0000,0xdcba,0x0000,0x0000,0xccb4,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf1f7,0x0000,0x0000,0x0000,0xe8b8,0x0000,0x0000,
0xcaf6,0x0000,0xe4a4,0xf4d6,0x0000,0x0000,0x0000,0xdfe6,
0x0000,0x0000,0x0000,0xdfa7,0x0000,0xdfe7,0xe1c1,0x0000,
0xe9c4,0x0000,0x0000,0xdccb,0xe9c5,0x0000,0x0000,0x0000,
0xefa3,0xeba6,0xcba3,0xe3e9,0x0000,0x0000,0x0000,0xd1fb,
0xefa4,0x0000,0xefeb,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd0b4,
0x0000,0x0000,0x0000,0x0000,0xcda3,0x0000,0x0000,0xe8e6,
0x0000,0xefa5,0x0000,0xd3cc,0xdaed,0x0000,0x0000,0x0000,
0x0000,0xd7ba,0x0000,0xf2d5,0xf5e5,0xd9ef,0x0000,0x0000,
0x0000,0x0000,0xf9b4,0x0000,0x0000,0xd5d4,0xfdcf,0x0000,
0x0000,0x0000,0xdbe3,0x0000,0x0000,0x0000,0x0000,0xf1e1,
0xecb6,0x0000,0x0000,0x0000,0x0000,0xfbfe,0xd3d7,0x0000,
0xd1b1,0x0000,0xcbb1,0x0000,0x0000,0x0000,0x0000,0xd1b2,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcbb2,0xf1c2,
0x0000,0x0000,0xf4e1,0xf9b5,0x0000,0x0000,0xe1c3,0xe1c2,
0x0000,0xebf7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xdfa8,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xcbca,0x0000,0x0000,
0x0000,0x0000,0x0000,0xe6b9,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf8de,0xf9aa,0xcaf7,0x0000,0xedb7,0x0000,0x0000,
0xd3b8,0xf2d6,0x0000,0x0000,0xd4d9,0xeec5,0xf2f0,0x0000,
0x0000,0x0000,0xcab2,0x0000,0x0000,0xdcbb,0x0000,0xf1f8,
0x0000,0x0000,0x0000,0x0000,0x0000,0xecb7,0x0000,0x0000,
0x0000,0x0000,0xe5ca,0x0000,0xf6c0,0xfddd,0x0000,0x0000,
0xd4e3,0xcce2,0x0000,0xf7d4,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd7e5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd3c3,0x0000,0xd8a6,0x0000,0xf6c1,0x0000,0x0000,0x0000,
0x0000,0x0000,0xddf6,0x0000,0xcdc0,0x0000,0x0000,0x0000,
0xe5dc,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe5cb,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xe1c4,0x0000,0x0000,0x0000,0x0000,0x0000,0xe8b0,
0xf4b0,0xf3ea,0xdaee,0x0000,0xd7bb,0x0000,0xe2b1,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xd7aa,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd6fb,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xe4df,0x0000,0xcad6,0x0000,
0x0000,0x0000,0xeba8,0x0000,0x0000,0x0000,0xdbfe,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf6c2,0x0000,0x0000,0xefbb,0x0000,0x0000,0x0000,
0x0000,0xd4fd,0x0000,0x0000,0xe0c8,0x0000,0x0000,0x0000,
0xe8b9,0x0000,0xefa6,0x0000,0x0000,0x0000,0x0000,0x0000,
0xcda4,0x0000,0x0000,0xd4f4,0xdba1,0xdbdc,0xdbdd,0x0000,
0x0000,0x0000,0x0000,0x0000,0xeedc,0x0000,0xcbcb,0xfcd5,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xceeb,0x0000,
0xcdc1,0x0000,0x0000,0xfbd3,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf9ab,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf5d4,0x0000,0x0000,0x0000,0x0000,0xd9a9,
0x0000,0x0000,0xe9dd,0xdbcd,0x0000,0x0000,0xddce,0x0000,
0xe7c3,0x0000,0xeccc,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf9ec,0x0000,0x0000,0x0000,0xcbcc,0x0000,
0x0000,0x0000,0x0000,0xe0fc,0xd4a8,0x0000,0xedd3,0xd8ef,
0x0000,0xf2d7,0x0000,0xcaf8,0xdaef,0x0000,0x0000,0xd6d4,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd9cd,0x0000,
0x0000,0x0000,0xd8ee,0x0000,0xf2c1,0x0000,0x0000,0x0000,
0xdfd3,0x0000,0x0000,0x0000,0xdaf0,0x0000,0xe2ea,0x0000,
/* 0x7700 */
0x0000,0xe0fd,0x0000,0x0000,0xd8f8,0x0000,0x0000,0x0000,
0xf7af,0xdab6,0x0000,0xcad7,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf2d8,0x0000,
0xd8f9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xfadf,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcfef,
0xd9c2,0x0000,0xf0d2,0x0000,0xe4d1,0x0000,0x0000,0x0000,
0xf3b7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xfae0,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xefec,0x0000,0x0000,0x0000,0x0000,
0x0000,0xe2b2,0x0000,0xd4bd,0x0000,0x0000,0xd9ce,0x0000,
0x0000,0x0000,0x0000,0xf4e2,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xd4a9,0x0000,0x0000,0x0000,0x0000,0xcdc2,0xe7da,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xf2d9,0x0000,0x0000,0x0000,0x0000,
0x0000,0xd9aa,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd8be,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xdcad,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xe2eb,0xd6fc,0x0000,0x0000,
0xcaf9,0x0000,0x0000,0xd4da,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xf4d7,0xcca1,0x0000,0x0000,0xcfba,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf5b8,
0x0000,0x0000,0x0000,0xd9c3,0xd0e8,0x0000,0x0000,0x0000,
0x0000,0x0000,0xe3c5,0xebf8,0x0000,0xf2b1,0x0000,0x0000,
0x0000,0xcfbb,0x0000,0x0000,0x0000,0xd3ad,0xe8e1,0xceec,
0x0000,0x0000,0x0000,0xe0b4,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
/* 0x7800 */
0x0000,0x0000,0xdee3,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xddf7,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf2b2,0xf3f6,0xf6db,
0x0000,0x0000,0x0000,0x0000,0xd7fe,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf8df,0x0000,0xf7f2,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xd0a9,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe6da,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf5a6,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xd7bc,0xcce3,0x0000,0x0000,0xe6db,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xdddd,0x0000,0x0000,0x0000,
0x0000,0xd1b3,0x0000,0x0000,0x0000,0x0000,0x0000,0xefed,
0x0000,0x0000,0x0000,0x0000,0xd6de,0xe4f4,0xe1ef,0x0000,
0x0000,0xddf8,0x0000,0x0000,0x0000,0x0000,0x0000,0xe8cf,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xcae5,0x0000,0x0000,0x0000,0xdca1,
0x0000,0xe0b5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xfcac,0xfcad,0xd8a7,0x0000,0x0000,0x0000,
0x0000,0xedb8,0x0000,0x0000,0x0000,0xdbb6,0x0000,0x0000,
0x0000,0x0000,0xd6f0,0xf3af,0x0000,0x0000,0xcda5,0x0000,
0xdaf1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd8a8,0x0000,0x0000,0x0000,0xcce4,0x0000,0x0000,0xd1b4,
0x0000,0x0000,0x0000,0x0000,0x0000,0xcad8,0x0000,0x0000,
0x0000,0x0000,0x0000,0xdaf2,0x0000,0x0000,0x0000,0x0000,
/* 0x7900 */
0x0000,0xf5a7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf5a8,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe6a6,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd5ec,0xd5f8,0xdaf3,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xe3c6,0x0000,0x0000,0x0000,0xdee4,0x0000,
0xdee5,0xd1b5,0x0000,0x0000,0x0000,0x0000,0x0000,0xd1b6,
0xd1b7,0xf2b3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xe9de,0x0000,0x0000,0x0000,0x0000,0x0000,0xf0d3,0xf2b4,
0x0000,0x0000,0xf0d4,0xcbe4,0xfbd4,0xf5e6,0xe3ea,0x0000,
0xdee6,0x0000,0x0000,0x0000,0x0000,0xdfd4,0x0000,0x0000,
0xf8f9,0x0000,0x0000,0x0000,0x0000,0xf0ae,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd1b8,0x0000,0x0000,0x0000,0x0000,0xd6df,
0x0000,0xd0d7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xfca1,0xefee,0xdcd8,
0x0000,0xe9df,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe5dd,0xfdfb,
0x0000,0x0000,0xe0c9,0x0000,0x0000,0x0000,0xd6c9,0x0000,
0x0000,0xd4aa,0x0000,0xe5cc,0x0000,0x0000,0x0000,0x0000,
0x0000,0xe9e0,0x0000,0x0000,0x0000,0xd0d8,0xfca2,0xd4be,
0xe2b3,0xdee7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xdcbc,0xd2b6,0xf5d5,0x0000,0x0000,0x0000,0x0000,
0x0000,0xcea1,0xf5a9,0x0000,0x0000,0xddf9,0x0000,0x0000,
0xddfa,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf0d5,
0x0000,0x0000,0x0000,0x0000,0xf6df,0x0000,0xf2da,0xe4eb,
0x0000,0xf2f1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xecb9,0x0000,0x0000,0x0000,0x0000,
0xfdfc,0x0000,0x0000,0x0000,0x0000,0xe1aa,0x0000,0x0000,
0xcad9,0x0000,0x0000,0xefef,0x0000,0xf5aa,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xecf9,0x0000,0x0000,0xf8ad,
0x0000,0xf2c2,0xf6c3,0x0000,0xd7d2,0x0000,0x0000,0xf9a2,
0xf0d6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf0fa,0x0000,
0x0000,0xf6e0,0x0000,0x0000,0x0000,0x0000,0xe9f3,0xf2c3,
0x0000,0x0000,0x0000,0xd4ab,0xcab3,0xcda6,0x0000,0xcdc3,
0xcdda,0x0000,0x0000,0x0000,0x0000,0x0000,0xd9cf,0x0000,
0x0000,0xf6c4,0x0000,0x0000,0x0000,0xeedd,0xe7c4,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe2b4,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xdfe2,0xe7db,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xe8b1,0x0000,0xfcae,0x0000,0x0000,0x0000,0x0000,
0xe5cd,0x0000,0x0000,0x0000,0xfaeb,0x0000,0xcfbc,0x0000,
0x0000,0xcfe2,0xcdf6,0x0000,0x0000,0xeff0,0x0000,0xf4be,
0x0000,0xd4cd,0x0000,0x0000,0xf3b8,0x0000,0x0000,0x0000,
0xe9a1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf2f2,0xf3eb,0x0000,0xf0d7,0x0000,0x0000,
0xcfd7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcfdf,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xe8c0,0xe8c1,0x0000,0x0000,0x0000,0xcfe3,0xe9a2,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd0aa,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xf3c1,0xd0ab,0x0000,0xd4e4,
0x0000,0x0000,0xefbc,0xd8a1,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd9df,
0x0000,0xf3d7,0x0000,0x0000,0x0000,0xdcbd,0x0000,0xcce5,
0xedf1,0x0000,0x0000,0xf1e2,0x0000,0xd4db,0x0000,0x0000,
0x0000,0x0000,0xe2b5,0x0000,0x0000,0xcae6,0x0000,0xd3ae,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcce6,0x0000,
0x0000,0xf1d3,0xf5e7,0x0000,0x0000,0x0000,0x0000,0xcada,
/* 0x7b00 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfbee,
0x0000,0xe1c5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xdfe9,0x0000,0xeede,0x0000,0x0000,0xf7c2,0x0000,
0xd8a2,0x0000,0x0000,0x0000,0x0000,0x0000,0xddac,0x0000,
0x0000,0x0000,0x0000,0x0000,0xf0af,0xd6bd,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xe1ab,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf9b6,0x0000,
0x0000,0xd4f5,0x0000,0xd0c9,0xefa7,0xe2ec,0x0000,0xdbea,
0xcecc,0xf5e8,0xf7d5,0x0000,0xd3cd,0x0000,0xf3fe,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd0b5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xe0fe,0x0000,0xdffb,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe6dd,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe8a4,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcbcd,
0x0000,0x0000,0x0000,0xefa8,0x0000,0x0000,0x0000,0xeeb4,
0x0000,0x0000,0x0000,0x0000,0xdad8,0xd1b9,0x0000,0xdfa9,
0x0000,0x0000,0xf3b0,0x0000,0x0000,0xccc4,0x0000,0x0000,
0x0000,0xceb7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xefa9,0x0000,0x0000,
0x0000,0xdfd5,0x0000,0x0000,0xedd7,0x0000,0x0000,0x0000,
0xeec6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xefbd,0xfcd6,0x0000,0x0000,0xdbf4,0x0000,0xefaa,0xf8b9,
0x0000,0xf5e9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xe3d9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xe1c6,0x0000,0x0000,0x0000,0xd4bf,0x0000,0x0000,0x0000,
0x0000,0xdee8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
/* 0x7c00 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf0ea,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf3c2,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd3af,0x0000,
0x0000,0xcadb,0x0000,0x0000,0x0000,0x0000,0x0000,0xfcd7,
0x0000,0x0000,0xedd8,0xe1c7,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf4d8,0xd6b3,0xddad,
0x0000,0x0000,0x0000,0xd5be,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xf1c3,0xeedf,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd6eb,0x0000,0x0000,0x0000,0xf4d9,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xd7e6,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xdab7,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xddfb,0x0000,0x0000,0x0000,0x0000,
0x0000,0xddcf,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd8a3,0x0000,0x0000,0xdad9,0x0000,0xf0d8,
0xefc4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe1d8,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf1d4,0x0000,0xedf2,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd5db,0x0000,
0x0000,0xd5dc,0xf3c4,0xcbd7,0x0000,0x0000,0x0000,0x0000,
0x0000,0xe2b6,0x0000,0x0000,0x0000,0x0000,0xeff1,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xfbd5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd3d8,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xddd0,0xf0d9,
0xcbb3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd5dd,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xcda7,0x0000,0x0000,0xd0ac,0x0000,
0xd1ba,0x0000,0xf1c4,0x0000,0xe5b3,0xfbf5,0xe9e1,0xfde0,
0xfcbc,0x0000,0xdaa2,0xdaa3,0x0000,0xd2a1,0x0000,0x0000,
0xd2ef,0x0000,0x0000,0x0000,0xe2ed,0x0000,0x0000,0xdee9,
0xcedc,0xf2b5,0xd0e4,0xddd1,0x0000,0x0000,0x0000,0x0000,
0xe1c8,0xdbb7,0xdfe3,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xedb9,0xf1c5,0x0000,0xf3cf,0xd7ab,
0xe1ac,0x0000,0x0000,0xe3eb,0x0000,0xeec7,0x0000,0x0000,
0x0000,0xe1c9,0xcafa,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf0fb,0xfae1,0xf0da,0xcce7,0xdaf4,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xccbf,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xceed,0x0000,
0x0000,0xd5a9,0xfae2,0x0000,0x0000,0x0000,0xd0e5,0x0000,
0xebd6,0x0000,0xecdf,0x0000,0x0000,0x0000,0xdffc,0x0000,
0x0000,0xf7d6,0xdeea,0xcbb4,0x0000,0x0000,0xefbe,0x0000,
0x0000,0xccb5,0x0000,0x0000,0x0000,0x0000,0x0000,0xcfbd,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xeff2,0xe2b7,
0x0000,0x0000,0x0000,0xcce8,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xf0fc,0x0000,0x0000,0x0000,
0xd6e0,0x0000,0xf1c6,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xe2b8,0xebab,0x0000,0x0000,
0x0000,0xcbb5,0xd8d1,0x0000,0xf4ce,0xf3f7,0x0000,0x0000,
0xd7c6,0x0000,0xd1bb,0xf7aa,0x0000,0xedca,0xd7d3,0xd8fa,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf6c5,
0x0000,0x0000,0xd1cc,0xddfc,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xdffd,0x0000,
0xf9e5,0x0000,0xe0ca,0x0000,0x0000,0xf2fd,0xd3b0,0x0000,
0xf4f3,0xdac9,0x0000,0xe6de,0x0000,0x0000,0x0000,0x0000,
0xf8ba,0xe8d0,0x0000,0x0000,0xd8fb,0x0000,0x0000,0xead5,
0x0000,0x0000,0x0000,0x0000,0xd6a3,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xf6c6,0x0000,0x0000,0x0000,0x0000,
/* 0x7e00 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf2db,0xe4fc,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe8b2,0x0000,0x0000,
0x0000,0x0000,0x0000,0xdada,0x0000,0xf2dc,0xfbd6,0xe9b2,
0x0000,0xeead,0x0000,0xfae3,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xdcee,0x0000,0x0000,0xf5ea,0xe6e0,
0x0000,0xf0fd,0x0000,0x0000,0x0000,0x0000,0x0000,0xd7ac,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf5c5,0xeee0,0x0000,
0x0000,0xdbe5,0x0000,0xddde,0x0000,0x0000,0xd9f0,0xe9a3,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf1f9,0x0000,0xf2c4,0xe0cb,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe9a4,0x0000,
0x0000,0xe2b9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xe3b1,0xfceb,0xcda8,0x0000,0xccb6,0x0000,0x0000,
0xf0db,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xe6ba,0x0000,0x0000,0xcda9,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf3c3,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xe1d9,0x0000,0x0000,0xefab,
0x0000,0x0000,0x0000,0xe7c5,0x0000,0x0000,0xe0e9,0x0000,
0xf3c5,0x0000,0x0000,0xd4c0,0xd5bf,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
/* 0x7f00 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xddae,0x0000,
0xf9fc,0x0000,0xccc0,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xe5a2,0x0000,0x0000,0x0000,
0xceb8,0x0000,0x0000,0x0000,0xd8d2,0xf9d6,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf1aa,0xced1,0x0000,0x0000,0xf6c7,0x0000,
0xdbeb,0x0000,0xdffe,0x0000,0x0000,0xd8e1,0x0000,0xf7f3,
0x0000,0xd7e7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xd4fe,0x0000,0x0000,
0xd1bc,0x0000,0xe5cf,0x0000,0xcbb6,0x0000,0xdab8,0x0000,
0x0000,0x0000,0x0000,0x0000,0xcdc4,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd6be,0x0000,0x0000,0x0000,0xe2ba,0x0000,
0x0000,0x0000,0x0000,0x0000,0xcfd8,0x0000,0x0000,0x0000,
0xe0cc,0xebf9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xfdfd,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd7e8,0xcbd8,0x0000,0x0000,0x0000,0xe9e2,0x0000,0x0000,
0x0000,0xe8ba,0x0000,0x0000,0x0000,0xe3c7,0x0000,0x0000,
0x0000,0x0000,0xeccd,0x0000,0xecce,0x0000,0xd6bf,0x0000,
0x0000,0x0000,0xe3a7,0x0000,0xdfd6,0xfde8,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xeee1,
0xf6a8,0xddfd,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf8bb,0x0000,0xe8d1,0x0000,0x0000,0x0000,0x0000,
0xf9d7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xceee,0x0000,0x0000,0xeccf,0x0000,0x0000,0x0000,
0xe9a5,0xd6d5,0x0000,0xcdc5,0x0000,0xedba,0xd1bd,0x0000,
0x0000,0xcfbe,0x0000,0x0000,0xecbb,0x0000,0x0000,0x0000,
0xd2b1,0x0000,0x0000,0x0000,0x0000,0xcce9,0x0000,0xd9c4,
0xe9fc,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xd1be,0x0000,0x0000,
0x0000,0x0000,0x0000,0xecbc,0x0000,0x0000,0xe5ad,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf7b0,0x0000,0xccea,
0x0000,0x0000,0x0000,0xd3c4,0x0000,0x0000,0xd6c0,0x0000,
0x0000,0x0000,0xd6fd,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe1a1,0x0000,
0xdebd,0x0000,0xf6a9,0x0000,0x0000,0x0000,0xdaa4,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd6a4,
0xf5c6,0x0000,0xe1a2,0xe9c6,0x0000,0x0000,0x0000,0xf2c5,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf4e9,0xd6ec,0xebd3,
0x0000,0x0000,0x0000,0x0000,0xecbd,0xe2dc,0xdeeb,0xf0dc,
0x0000,0xebbf,0x0000,0xd7ce,0xd1bf,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf5ab,0x0000,
0x0000,0x0000,0x0000,0xf9fd,0x0000,0xcadc,0x0000,0x0000,
0x0000,0xcdc6,0xf2b6,0x0000,0x0000,0xddfe,0x0000,0x0000,
0x0000,0xccb7,0xdbb8,0x0000,0x0000,0x0000,0x0000,0xd0e9,
0x0000,0xcedd,0xebc0,0x0000,0xfda2,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf8cb,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xead6,0xf1b0,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xdbce,0x0000,0xf7c3,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xdbcf,0xcba4,0x0000,0x0000,0xf8e0,0x0000,
0x0000,0xfbd7,0x0000,0x0000,0xebca,0xe0a1,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xcecd,0x0000,0x0000,0xd4dc,0x0000,0x0000,0x0000,
0xfdd8,0x0000,0x0000,0x0000,0x0000,0xd2f6,0x0000,0x0000,
/* 0x8100 */
0x0000,0x0000,0xf2b7,0x0000,0x0000,0xfaf6,0xf6aa,0xfaf7,
0xd8e6,0x0000,0xf4b1,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xe8d2,0x0000,0xcac5,0xcceb,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xe2ee,0x0000,0x0000,0x0000,0x0000,
0x0000,0xe2bb,0x0000,0xf7ad,0x0000,0x0000,0x0000,0xf8e1,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf3ec,0x0000,0x0000,0x0000,0x0000,0xdea1,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xe4fd,0x0000,0x0000,0xe3ec,0x0000,
0xddaf,0xddb0,0x0000,0x0000,0xcbb7,0xe8d3,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe1a3,0xd2e0,0x0000,
0x0000,0x0000,0x0000,0xf0fe,0x0000,0x0000,0x0000,0x0000,
0xe9a6,0xcbf2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xedf3,0xdcd9,0xe0cd,0x0000,0x0000,0x0000,0x0000,0xf7da,
0xdbb9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xccae,0x0000,0xdadb,0x0000,0x0000,0x0000,0x0000,0xcdc7,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xddb1,0x0000,0xd8af,0xe3a3,0x0000,0x0000,
0xceef,0x0000,0x0000,0xf2f3,0x0000,0x0000,0x0000,0x0000,
0xf8b3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xe0ce,0x0000,0xf5fd,0x0000,0x0000,
0x0000,0x0000,0xebec,0x0000,0x0000,0xd3c5,0xfcec,0xd2db,
0xd4eb,0x0000,0xdea2,0x0000,0x0000,0x0000,0xe5e6,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf0b0,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd5c4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xedf4,
0x0000,0x0000,0x0000,0xe3ed,0x0000,0xe8c2,0x0000,0xedf5,
0xd7fc,0x0000,0xedbb,0x0000,0x0000,0xf6ab,0x0000,0x0000,
0x0000,0x0000,0x0000,0xf2b8,0xf6c8,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd3e6,0xf2dd,0xcfbf,0x0000,0xebac,0x0000,
/* 0x8200 */
0x0000,0x0000,0x0000,0x0000,0x0000,0xcfc0,0x0000,0xe6a8,
0xfde9,0x0000,0xcfc1,0x0000,0xe0df,0xdeec,0x0000,0x0000,
0x0000,0x0000,0xe0a2,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xf4bf,0xe2ef,0x0000,0xd9f1,0xf1c7,
0x0000,0xcbb8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf9fe,0xdbba,0xdaf5,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf6ec,0xdadc,0xfae4,
0x0000,0xe0cf,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xddb2,0x0000,0x0000,0x0000,0x0000,0xe6a9,0x0000,0xeff3,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf3ed,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xebfa,0x0000,0xf9e6,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcadd,0xd5de,
0x0000,0xcade,0xdfe4,0x0000,0x0000,0x0000,0xe6fd,0x0000,
0xf5ac,0x0000,0x0000,0x0000,0x0000,0x0000,0xe4f5,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xe9e3,0x0000,0xedcb,0xcfe4,0x0000,
0x0000,0x0000,0xd8d3,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xddb3,0xd4ec,0x0000,0x0000,0xf2b9,0x0000,0xdfb7,
0x0000,0x0000,0x0000,0x0000,0x0000,0xcbce,0xfbd8,0x0000,
0x0000,0xd0d9,0x0000,0x0000,0xddd2,0xf7f4,0xe7dc,0xe4a5,
0x0000,0xfca3,0x0000,0xdbbb,0x0000,0x0000,0x0000,0xf2ba,
0xe9fd,0xd0ca,0x0000,0xf5d6,0xd9c5,0xe4b4,0x0000,0xeda7,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xeabd,0xe6fe,0x0000,0xf7c4,0xf5ad,0x0000,0xd9e0,
0x0000,0x0000,0x0000,0xcab4,0x0000,0x0000,0xf8e2,0xcfc2,
0x0000,0xecbe,0x0000,0x0000,0x0000,0xe5b4,0xcdc8,0xeec8,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xe7c8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xcdc9,0xf9b7,0x0000,
/* 0x8300 */
0x0000,0xf1e8,0xd9f2,0xdbf5,0xcab5,0xd9c6,0x0000,0x0000,
0x0000,0xd8c9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd9ab,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xedbc,0x0000,0x0000,0xd8d4,0x0000,0x0000,0x0000,0xdcda,
0x0000,0xe2bc,0x0000,0x0000,0xfced,0xece0,0xd2fe,0x0000,
0xe9c7,0xe6aa,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xe2f0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfabb,
0x0000,0xf5ae,0xfbaa,0x0000,0x0000,0x0000,0x0000,0xecfb,
0x0000,0xecbf,0xfcd8,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xd4e5,0x0000,0x0000,0x0000,0xf9c3,
0x0000,0x0000,0x0000,0xeee2,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xd7e9,0xedf6,0x0000,0x0000,0x0000,0xdeed,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xccec,0x0000,
0xe3ee,0x0000,0x0000,0x0000,0x0000,0x0000,0xe8d4,0x0000,
0x0000,0x0000,0xfaf8,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xddb4,0xe4b5,0xd8b0,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xd8d5,0x0000,0x0000,
0x0000,0xf4ea,0x0000,0x0000,0x0000,0xceb9,0x0000,0x0000,
0x0000,0xd6e1,0xcfd2,0x0000,0xd0b6,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xcea2,0x0000,0x0000,0xf3ee,0x0000,
0x0000,0x0000,0x0000,0x0000,0xf3f8,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xdccc,0x0000,0xd0cb,0x0000,0x0000,0x0000,0xfca4,
0xcdca,0xd7d4,0xdea3,0x0000,0xe4e0,0x0000,0x0000,0x0000,
0x0000,0xeec9,0x0000,0x0000,0x0000,0xe2dd,0x0000,0x0000,
/* 0x8400 */
0x0000,0x0000,0x0000,0xf5fe,0xd4ac,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd5d1,0x0000,0xd8f0,0xf8c3,0xead7,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf5d7,0x0000,0x0000,0xd8bf,0x0000,0x0000,0x0000,
0x0000,0xfdc0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xebad,0x0000,0x0000,0x0000,0x0000,0xd5aa,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xe7a8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xeeca,
0x0000,0x0000,0x0000,0xcae7,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf8e3,0x0000,0xd4dd,0x0000,0x0000,0xead8,0x0000,
0x0000,0x0000,0x0000,0xfbd9,0xedf7,0x0000,0x0000,0xe5b5,
0x0000,0x0000,0x0000,0x0000,0x0000,0xd0ad,0x0000,0x0000,
0x0000,0x0000,0xf1f1,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xe2bd,0x0000,0x0000,0x0000,0xe3c8,0x0000,0x0000,0x0000,
0x0000,0xd9d5,0x0000,0x0000,0xdfaa,0x0000,0x0000,0x0000,
0x0000,0xdbbc,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf8e4,0x0000,0x0000,0x0000,0x0000,0x0000,
0xf1fa,0x0000,0x0000,0xe5b6,0xf3ef,0x0000,0x0000,0xfbda,
0xe1e0,0x0000,0xd9ac,0x0000,0xf5eb,0x0000,0xe0b6,0x0000,
0x0000,0xe9c8,0x0000,0xcbcf,0x0000,0xe3c9,0x0000,0x0000,
0x0000,0xdeee,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xe2be,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xdcef,0x0000,0xd6a5,0x0000,
0x0000,0x0000,0x0000,0x0000,0xe2f1,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xd6fe,0x0000,0x0000,0x0000,
/* 0x8500 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xd9a1,0x0000,0xd8c0,0xdcdb,0x0000,0x0000,0xedbd,
0xdfb8,0x0000,0xeaa5,0x0000,0x0000,0x0000,0xd7ad,0x0000,
0x0000,0xf3f9,0x0000,0xedf8,0x0000,0xf5c7,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xe1ca,0xebe3,0x0000,0xf2de,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf8cc,0x0000,0xead9,
0x0000,0xd3c6,0x0000,0xdbe6,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf5af,0x0000,0x0000,0x0000,0x0000,0xcef0,0x0000,
0x0000,0x0000,0x0000,0xe9fe,0x0000,0x0000,0x0000,0x0000,
0x0000,0xfbb6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xe2f2,0x0000,0x0000,0x0000,0x0000,
0xcff2,0xf7b9,0xd9f3,0x0000,0x0000,0xe1cb,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xdadd,0x0000,0x0000,0xdab9,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xebfb,
0x0000,0xcbb9,0x0000,0x0000,0xedf9,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xe0e0,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf4c0,0x0000,
0xfdbc,0xdfb1,0xe3ef,0x0000,0x0000,0x0000,0x0000,0xe0a3,
0xfdb9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf0b1,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xcdcb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xedbe,0x0000,0x0000,0x0000,0xd5c0,0xe3f0,0xedfa,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe9e4,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xd5ed,0xe7dd,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xd4f6,0xe5b7,0x0000,0x0000,
0x0000,0xdbe7,0xe2bf,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xeecb,
0x0000,0x0000,0xd7f4,0xf0dd,0x0000,0x0000,0x0000,0xceab,
/* 0x8600 */
0x0000,0x0000,0xe7de,0x0000,0x0000,0x0000,0xd6d6,0xe1cc,
0x0000,0x0000,0xe8b3,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe5ee,0xdca2,
0x0000,0x0000,0xe0d0,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xd5b5,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd5a1,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfbdb,0x0000,
0xf9cb,0x0000,0x0000,0x0000,0xcbf3,0xf4a5,0x0000,0x0000,
0x0000,0x0000,0x0000,0xfac8,0xd6d7,0x0000,0xe9e5,0xfbdc,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfdd0,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xfbf6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xdaa5,0x0000,0xdbbd,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xece2,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xcdf7,0xf0de,0x0000,0x0000,0x0000,
0x0000,0xf6c9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xdeef,
0x0000,0x0000,0x0000,0xd3b1,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xfcee,0x0000,0x0000,0x0000,
0x0000,0xe8c3,0x0000,0xf1c8,0x0000,0x0000,0x0000,0xcef1,
0x0000,0x0000,0x0000,0x0000,0xf9ed,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf2f4,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe4b6,0x0000,
0xf5b9,0x0000,0xdcf0,0xe3f1,0x0000,0x0000,0x0000,0x0000,
0xe8a5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xf2bb,0x0000,0xdea4,0x0000,0xdacc,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcae9,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe3da,0x0000,0xfcd9,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xeada,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf9c4,0x0000,
0xe3a4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xfbdd,0x0000,0xefca,0x0000,
0xe8c4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd5cc,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xebd7,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd9ad,
0x0000,0x0000,0xfbab,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xd3d9,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd5a2,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xf6de,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xdaf6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xe0d1,0x0000,0x0000,0xe9a8,
0x0000,0x0000,0xf5f9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xfaaf,0x0000,0xebfc,0x0000,0x0000,0xe0ea,0x0000,
/* 0x8800 */
0x0000,0x0000,0x0000,0x0000,0x0000,0xe3b2,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd5c5,
0x0000,0x0000,0xf1e3,0xd5ee,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xcdcc,0x0000,0x0000,0x0000,0x0000,0xedd9,0x0000,
0x0000,0x0000,0x0000,0xd8c1,0x0000,0x0000,0x0000,0x0000,
0xfaec,0x0000,0x0000,0x0000,0x0000,0x0000,0xf1eb,0x0000,
0x0000,0x0000,0x0000,0x0000,0xfabc,0xe6e2,0x0000,0x0000,
0x0000,0x0000,0xfae5,0xe2fa,0x0000,0x0000,0x0000,0xcab6,
0x0000,0xe4b7,0x0000,0xeadb,0x0000,0xf5fa,0x0000,0x0000,
0x0000,0xfbac,0xcfc3,0xebfd,0x0000,0x0000,0x0000,0x0000,
0xf8fa,0x0000,0x0000,0xdfb9,0x0000,0x0000,0x0000,0x0000,
0xe1f1,0x0000,0xd2a4,0x0000,0x0000,0x0000,0x0000,0xf5fb,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd0da,0xd0db,
0x0000,0xeabe,0xd9b1,0x0000,0x0000,0x0000,0x0000,0x0000,
0xcab7,0x0000,0x0000,0xd3e7,0x0000,0xf8e5,0x0000,0x0000,
0x0000,0x0000,0xd3b2,0x0000,0x0000,0x0000,0xe2c0,0xf2df,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcde5,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xf9ac,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xcdcd,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xeeae,0xd6ae,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd7ea,
0x0000,0x0000,0x0000,0x0000,0xe7e0,0xebae,0x0000,0x0000,
0x0000,0xcfd9,0x0000,0x0000,0xdccd,0xedfb,0x0000,0xdef0,
0x0000,0xd7eb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xdea5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xdfd7,0xdbd0,0xdbd1,0x0000,0x0000,
0xd5a3,0x0000,0x0000,0x0000,0x0000,0xf0b2,0x0000,0x0000,
/* 0x8900 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xdcdc,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xcae8,0x0000,0xf8e6,0xdcce,0x0000,0x0000,0x0000,0x0000,
0xeadc,0xdbd2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe9b3,0x0000,0x0000,
0x0000,0x0000,0xf7db,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe3a8,0x0000,
0xd7ae,0x0000,0x0000,0xe0e1,0x0000,0x0000,0x0000,0x0000,
0x0000,0xcbba,0x0000,0x0000,0xe5d1,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd0dc,
0x0000,0x0000,0x0000,0x0000,0xd5c1,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd8ca,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xe3a9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe0a4,
0x0000,0xe9a9,0x0000,0xd3c7,0x0000,0x0000,0xdcdd,0xf8ae,
0x0000,0x0000,0x0000,0xccb8,0x0000,0x0000,0x0000,0xd0ae,
0x0000,0x0000,0x0000,0xd8f2,0x0000,0x0000,0xe3ca,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xccaf,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xd4ad,0xf6d1,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd0cc,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xcac6,0x0000,0x0000,0xd5c2,0x0000,0x0000,
0xceba,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xcac7,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xfab0,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xdfd8,0x0000,0x0000,0x0000,
0xf5ba,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xe5eb,0x0000,0xeff4,0xddb5,0x0000,0x0000,0x0000,0x0000,
0xcdaa,0x0000,0xe3f2,0x0000,0xfbf7,0x0000,0xf7d0,0x0000,
0x0000,0x0000,0x0000,0xfdba,0x0000,0x0000,0xfde1,0xf6fe,
0xd1c0,0x0000,0x0000,0xe8c5,0x0000,0xe4b8,0x0000,0xe1e8,
0x0000,0x0000,0x0000,0xccc1,0x0000,0xd2ed,0x0000,0x0000,
0x0000,0x0000,0xdbbe,0x0000,0x0000,0xe0e2,0x0000,0x0000,
0x0000,0xfac9,0x0000,0x0000,0xe1cd,0x0000,0xcab8,0x0000,
0x0000,0x0000,0xf2e0,0xf1c9,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xdef1,0x0000,0x0000,0x0000,0xf0df,0xf8c4,0x0000,0x0000,
0x0000,0x0000,0x0000,0xeecc,0x0000,0x0000,0xdef2,0x0000,
0xe7c9,0x0000,0xe2f3,0xe7e1,0x0000,0x0000,0xe3cb,0x0000,
0x0000,0xe3cc,0x0000,0x0000,0x0000,0xcff8,0xefac,0x0000,
0xfdfe,0xfca5,0xfab1,0xdfd9,0x0000,0xe0d2,0x0000,0x0000,
0x0000,0xf4da,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf1ca,0x0000,0xcea3,
0x0000,0x0000,0x0000,0x0000,0xf2bc,0xece3,0x0000,0x0000,
0x0000,0x0000,0x0000,0xe0a5,0x0000,0xf7ab,0x0000,0x0000,
0xebaf,0x0000,0x0000,0x0000,0x0000,0x0000,0xe5de,0x0000,
0xe1a4,0xcdab,0x0000,0xd9f4,0xe8a6,0xcdce,0xe1e9,0x0000,
0xfcef,0x0000,0xe0e3,0x0000,0x0000,0x0000,0x0000,0x0000,
0xe2c1,0x0000,0xcea4,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xdea6,0x0000,0x0000,0xebfe,0x0000,0xebdd,0xf0e0,
0x0000,0x0000,0xf4db,0x0000,0xe2f4,0x0000,0x0000,0xd3c8,
0x0000,0x0000,0x0000,0xf4eb,0x0000,0xeeb5,0x0000,0xf5d8,
0x0000,0x0000,0xd5df,0x0000,0x0000,0x0000,0xd6e5,0x0000,
0x0000,0x0000,0x0000,0xebb0,0xf4e3,0x0000,0x0000,0x0000,
0x0000,0xe3cd,0x0000,0x0000,0x0000,0x0000,0xf4f4,0xfab2,
0x0000,0x0000,0xeff5,0xcadf,0x0000,0xebb1,0xedbf,0x0000,
0x0000,0xfdc9,0x0000,0x0000,0x0000,0x0000,0xe4a6,0xf9a4,
0xf0b3,0x0000,0xe5ec,0x0000,0x0000,0x0000,0xd1e7,0x0000,
0xd9c7,0xe4d7,0xeadd,0x0000,0xd4f7,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xdaba,0x0000,
0xdacd,0x0000,0x0000,0x0000,0xf9cc,0x0000,0xe1da,0xdbbf,
0x0000,0xccc5,0xecd0,0xcbbb,0x0000,0xdef3,0x0000,0x0000,
0xe9aa,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd9c8,0x0000,0x0000,0xeee3,0xd7bd,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xcfc4,0x0000,0x0000,0x0000,0x0000,
0x0000,0xd0cd,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xfca6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf1fb,0x0000,0x0000,0x0000,0x0000,0xfdd2,0xd1c1,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xe3db,0x0000,0xd3c9,0x0000,0xdccf,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcced,0x0000,
0x0000,0x0000,0x0000,0x0000,0xdea7,0x0000,0x0000,0xe6bb,
0xeca1,0x0000,0x0000,0x0000,0xccb9,0x0000,0x0000,0xfbde,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe7e2,0x0000,0x0000,
0xd4c1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xdca8,0x0000,0x0000,0x0000,0x0000,0x0000,
0xe2c2,0x0000,0xf3d8,0xe5d3,0x0000,0x0000,0xf3d9,0x0000,
0x0000,0x0000,0xf3c6,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
/* 0x8c00 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcddb,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcdac,
0x0000,0xfcc3,0x0000,0x0000,0x0000,0x0000,0xd4e7,0x0000,
0xd1c2,0x0000,0xf9a5,0x0000,0xe8d5,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe3ce,0x0000,0x0000,
0x0000,0x0000,0xd4ca,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xdfda,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xfbdf,0xe7e3,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf8fb,0xe3cf,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf5b0,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd8e7,0x0000,0xd9c9,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf8af,0xeff6,0x0000,
0xddb6,0xeeaf,0xcdf8,0x0000,0x0000,0x0000,0x0000,0xdeb8,
0xfca7,0xf7fc,0xf7b1,0xcebb,0xf4a1,0x0000,0x0000,0xeecd,
0xe1ae,0x0000,0x0000,0xecc3,0xcffe,0x0000,0xf8bf,0xd8e2,
0xd3e8,0x0000,0x0000,0xdea8,0xf4e4,0xecc2,0x0000,0xd9f5,
0xf9c5,0xddd3,0xd6f1,0xecfc,0xfcf0,0x0000,0x0000,0xedc0,
0xcab9,0x0000,0xeee4,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf2e1,0x0000,0xdeb9,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd6f2,0x0000,0xdef4,0x0000,0xdfdb,0x0000,
0xdbd3,0x0000,0xfae7,0xd8e3,0xf4c1,0x0000,0xddb7,0x0000,
0x0000,0x0000,0xf2f5,0x0000,0x0000,0xd4ae,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xd6f3,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xddb8,0xcfc5,0xdfdf,0x0000,0x0000,
/* 0x8d00 */
0x0000,0x0000,0x0000,0x0000,0xf2be,0xf6a1,0x0000,0xebcb,
0xf1fc,0x0000,0xf3c7,0x0000,0x0000,0xe0eb,0x0000,0x0000,
0x0000,0x0000,0x0000,0xedfc,0x0000,0x0000,0xe1db,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xeee5,0x0000,0xdef5,0x0000,
0x0000,0x0000,0x0000,0xfad3,0x0000,0x0000,0x0000,0x0000,
0xf1cb,0x0000,0x0000,0xd0af,0xddb9,0x0000,0x0000,0xd1c3,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf5b1,0x0000,0x0000,
0x0000,0x0000,0xeac6,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf0e1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xf6ac,0x0000,0x0000,0x0000,0x0000,
0xf5d9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xf0eb,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xddba,0x0000,0x0000,0x0000,0xf2bf,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf7c5,0x0000,
0x0000,0x0000,0x0000,0xdba2,0xf2f6,0x0000,0x0000,0xcaba,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xf7f5,0x0000,0xcbe5,0x0000,0x0000,
0x0000,0xeee6,0x0000,0xe0d3,0x0000,0x0000,0x0000,0x0000,
0xcea5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd6d8,
0x0000,0x0000,0x0000,0xd4af,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
/* 0x8e00 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xe9c9,0x0000,0x0000,0x0000,0x0000,0xd3ce,
0xf4c2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcbe6,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf1a1,0x0000,0x0000,0x0000,0x0000,0x0000,
0xebb2,0x0000,0x0000,0x0000,0x0000,0xf1a2,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xebb3,0x0000,0xf0b4,0x0000,0x0000,0xcbf4,
0xd4b0,0xf3b2,0xfbb7,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf5ec,0x0000,0x0000,0x0000,0x0000,0x0000,0xeee7,
0xf4b2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xf5ed,0x0000,0xcff3,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf0e2,0x0000,0x0000,0x0000,0x0000,0x0000,0xeece,
0x0000,0x0000,0xf1cc,0x0000,0x0000,0xe5b8,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd7f5,0xe3f3,0xcfe5,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xcfc6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf3b3,0xe4d8,0xcff9,0xcfda,0x0000,0x0000,
0x0000,0x0000,0xfacd,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe6e3,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xf2e2,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xf5ee,0x0000,0x0000,0xcabb,0x0000,0x0000,0xe3dc,0x0000,
/* 0x8f00 */
0x0000,0x0000,0x0000,0xcef2,0x0000,0xd6d9,0x0000,0x0000,
0x0000,0xeeb0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf4e5,0xd8c2,0xdcd0,0xccee,0x0000,0x0000,
0x0000,0x0000,0x0000,0xd5e0,0xf6ca,0xfdca,0xd8d6,0xf4cf,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd6a6,0xdcbe,
0x0000,0xdbd4,0xd7c7,0x0000,0x0000,0x0000,0x0000,0xf2fe,
0x0000,0x0000,0x0000,0xf1cd,0x0000,0x0000,0x0000,0x0000,
0xe2c3,0xdcde,0x0000,0xdcdf,0x0000,0x0000,0xefad,0xe6ab,
0x0000,0x0000,0x0000,0x0000,0xf9dd,0xeabf,0x0000,0x0000,
0x0000,0xefae,0x0000,0x0000,0x0000,0xf4d0,0xcef3,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe6ac,0x0000,0xcede,
0x0000,0x0000,0xd5f9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xe3f4,0xcdd0,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xd5b8,0x0000,0x0000,0xf7fd,0x0000,
0xdca9,0x0000,0x0000,0x0000,0x0000,0xdef6,0x0000,0xdcaa,
0xf2e3,0xe9b4,0xd2dc,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xe9e6,0x0000,0x0000,0xe3f6,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe7ca,0x0000,
0x0000,0xd0ce,0x0000,0x0000,0xdaf7,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcabc,0x0000,
0x0000,0x0000,0xeee8,0xdade,0x0000,0xf2f7,0x0000,0x0000,
0xe2fb,0x0000,0xcca6,0x0000,0x0000,0x0000,0x0000,0xdabb,
0x0000,0xeee9,0x0000,0x0000,0x0000,0xf5da,0x0000,0x0000,
0xf7dc,0xe1ea,0xcec1,0xd4b1,0x0000,0xfdb1,0xe6bd,0x0000,
0xfbad,0x0000,0x0000,0xf8e7,0x0000,0xe1ce,0x0000,0xf7e2,
0xf5ef,0xcfc7,0x0000,0x0000,0xd4b2,0xccef,0x0000,0xd4e8,
0x0000,0xeecf,0xf7d7,0x0000,0x0000,0xe0a6,0xd6c1,0xe1dc,
0xf0e3,0xf1e4,0xdcf1,0xd6a7,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf4f5,0x0000,
0x0000,0xf1ce,0xf2e4,0x0000,0x0000,0xd0b0,0x0000,0x0000,
0xecef,0x0000,0x0000,0x0000,0xf9ba,0x0000,0xebb5,0x0000,
0x0000,0xd4ed,0xe2c4,0x0000,0x0000,0x0000,0x0000,0xe9e7,
0x0000,0x0000,0xebb4,0xeaa1,0x0000,0xf8bc,0xcea6,0x0000,
0xf9c6,0xfcda,0x0000,0xd4b3,0xd3b9,0xeade,0x0000,0x0000,
0x0000,0xe9ab,0x0000,0x0000,0xe1e1,0xd3cf,0xf4f6,0x0000,
0xeac0,0xe1cf,0x0000,0xccba,0x0000,0x0000,0x0000,0x0000,
0x0000,0xeeea,0x0000,0x0000,0x0000,0xf0e4,0xf3b4,0xd4ee,
0x0000,0x0000,0xf2c0,0x0000,0x0000,0xf1e5,0x0000,0xf4c3,
0xe0d4,0x0000,0xebb6,0x0000,0xd7a1,0xcbe8,0x0000,0xf9ad,
0xe9ad,0xd8e4,0xfab3,0xe2c5,0xfcbd,0x0000,0x0000,0xecc4,
0xd8b1,0x0000,0xdcab,0x0000,0x0000,0x0000,0x0000,0xd5a4,
0x0000,0xebe9,0x0000,0x0000,0x0000,0xe8bb,0x0000,0x0000,
0x0000,0xd8d7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xfbae,0xd1e1,0x0000,0x0000,0xdbc0,0x0000,
0xf5be,0x0000,0xdef7,0x0000,0x0000,0x0000,0x0000,0xcafb,
0xf7c6,0xcfc8,0x0000,0x0000,0x0000,0xe1d0,0x0000,0x0000,
0xeed0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xe9f4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xcef4,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd5cd,0x0000,
0x0000,0xcfdb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xddbb,0x0000,0x0000,0x0000,0x0000,0xceac,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe9e8,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xd4b4,0x0000,0x0000,
/* 0x9100 */
0x0000,0x0000,0xe4c7,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf5db,0x0000,0x0000,0xfac1,0x0000,0x0000,
0x0000,0xdea9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd4f8,
0x0000,0x0000,0x0000,0x0000,0x0000,0xeff7,0x0000,0x0000,
0x0000,0x0000,0xd3b3,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xebb7,0xeff8,0xf5dc,0xedcc,0xdbd5,0xf1cf,0x0000,
0x0000,0x0000,0xf1d0,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf5b2,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xd9ae,0xd5ac,0x0000,0xe2c6,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xfda3,0x0000,0xfbe5,
0xdfab,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe2f5,
0x0000,0xf6ad,0x0000,0xf5b3,0x0000,0xf0b5,0x0000,0x0000,
0x0000,0x0000,0xe1a5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xf5dd,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xeca2,0xedfd,0x0000,0xf5b4,0xfbb8,
0x0000,0xdba3,0x0000,0x0000,0xd6ca,0xcbd9,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xe5d4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf3fa,
0x0000,0xebb8,0x0000,0xe0b7,0xd7ec,0xf1ec,0xe5af,0xd5e1,
0xd7ed,0xd1d1,0x0000,0x0000,0x0000,0x0000,0x0000,0xe1f2,
0xeff9,0x0000,0x0000,0x0000,0xddbc,0xf6dc,0x0000,0x0000,
0x0000,0x0000,0x0000,0xf0e5,0x0000,0x0000,0x0000,0xf4c4,
0x0000,0x0000,0xe9e9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf3fb,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
/* 0x9200 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xd4ef,0x0000,0x0000,
0xcca2,0xf7fe,0xdfbc,0x0000,0x0000,0x0000,0x0000,0xebcd,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd0b7,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xd6c2,0x0000,0x0000,0x0000,
0x0000,0x0000,0xe8ad,0x0000,0x0000,0x0000,0x0000,0xefaf,
0xcba5,0x0000,0x0000,0x0000,0x0000,0xcbe9,0x0000,0x0000,
0x0000,0xfae8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xccc6,
0x0000,0x0000,0x0000,0xe6e7,0x0000,0x0000,0xeac7,0x0000,
0x0000,0x0000,0xdba4,0x0000,0xcfc9,0xe2fc,0xeffa,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xebde,0x0000,0x0000,0xf5c8,0x0000,0xd4de,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xe0d5,0x0000,0xefb0,0x0000,0x0000,0xe2c7,0x0000,
0xd9af,0x0000,0x0000,0x0000,0xf9e7,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xe7e5,0x0000,0x0000,0xcfca,0xe1d1,
0x0000,0xe2c8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xeffb,0x0000,0x0000,0xfaf9,
0x0000,0x0000,0xdcf2,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xe0a7,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf8e8,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xcbea,0x0000,0x0000,0x0000,0xcbbc,0x0000,0x0000,0x0000,
/* 0x9300 */
0x0000,0x0000,0x0000,0x0000,0xd6e2,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xf5de,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xf5df,0x0000,0xeeb6,0x0000,0x0000,0x0000,0xe2f6,0xd3ca,
0xeffc,0xd1c4,0xefb1,0x0000,0xd1c5,0x0000,0xd0de,0x0000,
0xd9e1,0x0000,0x0000,0xe0b8,0x0000,0x0000,0xcdd1,0xf3b9,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xe7cc,0x0000,0xd6a8,0xcea7,0x0000,0xd4b5,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xe4c8,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xd3b4,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xebb9,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xcbf5,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xf6dd,0x0000,0xf1a3,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xccc7,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xe9ca,0x0000,0xe1f0,0x0000,
0x0000,0x0000,0xf5e0,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xfbaf,0x0000,0x0000,0x0000,0xcbd1,
0x0000,0x0000,0x0000,0x0000,0xfbe0,0xf2e5,0x0000,0x0000,
0xecf0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xf0ec,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xeeeb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe9cb,0x0000,
0x0000,0xccf0,0x0000,0x0000,0xd7af,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf3a1,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
/* 0x9400 */
0x0000,0x0000,0x0000,0x0000,0xfcf5,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xf1a4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe0d6,0x0000,0x0000,
0x0000,0x0000,0x0000,0xefb2,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf4d1,0x0000,0x0000,
0xf7a1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xf1d1,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xcafc,0xcafd,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xcece,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf3c8,0x0000,0xf3ba,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
/* 0x9500 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xedfe,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xdaa6,0x0000,0x0000,0xe0ec,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf8cd,0x0000,0xcbd2,0x0000,0x0000,0x0000,0xebce,
0x0000,0xf9d8,0xf9d9,0xcae0,0xdaca,0x0000,0x0000,0x0000,
0xcba6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xcac8,0xf9ee,0xdbec,0x0000,0x0000,
0xd0b1,0x0000,0x0000,0x0000,0x0000,0xd5ef,0x0000,0x0000,
0x0000,0xe6f3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xe7a2,0xe4d9,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe4e1,
0x0000,0x0000,0xfcc4,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xf9ef,0xcff4,0xf7e6,0x0000,
0x0000,0x0000,0x0000,0x0000,0xcebc,0x0000,0x0000,0x0000,
0x0000,0xf4c5,0xdca3,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
/* 0x9600 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xddbd,0x0000,0x0000,0x0000,
0x0000,0xf4c6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf8a1,0x0000,0x0000,0x0000,0xe8d6,0x0000,
0x0000,0x0000,0xdbc1,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xf0e6,0x0000,0x0000,0x0000,0xe4b9,
0xf6ed,0x0000,0xf9ae,0x0000,0xddbe,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xd7b0,0xd8e8,0xcbbd,0x0000,0x0000,
0xf9da,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xf8ce,0xf9f0,0xe0ed,0xe3b3,0xf4b3,
0x0000,0x0000,0xeac2,0xf2e6,0xf0b6,0x0000,0x0000,0x0000,
0x0000,0x0000,0xdbd6,0x0000,0x0000,0x0000,0x0000,0x0000,
0xebe4,0x0000,0x0000,0xf2e7,0x0000,0xd7d5,0xd4b6,0xf9e8,
0xd7c1,0x0000,0x0000,0x0000,0x0000,0xe5d5,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe9ea,0xd7cc,0x0000,
0x0000,0x0000,0xd3e9,0xe2c9,0x0000,0xfcdb,0xcdad,0x0000,
0x0000,0x0000,0x0000,0x0000,0xccb0,0xeaa2,0x0000,0x0000,
0xe4f6,0xd0c0,0x0000,0xf0b7,0xeea1,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xd7f6,0x0000,0x0000,0x0000,0xe2ca,
0xe2cb,0x0000,0xfacf,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xebdf,0x0000,0x0000,0x0000,0x0000,0x0000,0xd6cb,
0x0000,0x0000,0x0000,0xf4b4,0x0000,0x0000,0x0000,0x0000,
0xedcd,0xe4d2,0x0000,0x0000,0xeaa9,0xe4ba,0xf3a2,0xcdd2,
0x0000,0xf6cb,0x0000,0xf1e6,0xedc1,0xe8bc,0xeed1,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf0e7,0xe2cc,0x0000,
0x0000,0xe4aa,0x0000,0xf5e1,0xedda,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd7ee,0xd1f1,0x0000,0x0000,0x0000,0x0000,
0xe9eb,0xe9ec,0xe0e4,0x0000,0x0000,0x0000,0x0000,0xdaa7,
0xddd4,0x0000,0xeaa3,0x0000,0x0000,0x0000,0xd6c3,0xd6f4,
0x0000,0xdadf,0x0000,0xefb3,0x0000,0x0000,0x0000,0x0000,
0xe2cd,0x0000,0x0000,0x0000,0x0000,0x0000,0xeffd,0xf2e8,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xefc5,0x0000,0xe7e7,0x0000,0x0000,0xd7fd,0x0000,
0x0000,0xe7ce,0x0000,0x0000,0xdfdc,0x0000,0xf9c7,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd9f6,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xdfac,0x0000,0xd6da,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xdca4,0x0000,0x0000,0x0000,0xf0b8,0x0000,0x0000,
0x0000,0x0000,0xd5fa,0x0000,0xe4f7,0x0000,0x0000,0x0000,
0xd6c4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf4ec,0x0000,0x0000,0x0000,0x0000,0xeffe,0x0000,
0x0000,0x0000,0x0000,0x0000,0xf0a1,0x0000,0xdeaa,0x0000,
0x0000,0xdabc,0xd8fc,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xfad4,0x0000,0x0000,0x0000,0xece5,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xfca8,0x0000,0x0000,0xece6,
0x0000,0x0000,0xd8cb,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xfbb9,0x0000,0xe4d3,0x0000,0xcdf9,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xcfd3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xcaea,0x0000,0x0000,0xcfd4,0x0000,0xf8bd,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf4c7,0x0000,
0x0000,0x0000,0x0000,0xeadf,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xf9db,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xd4b7,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xebe5,0x0000,0x0000,0xe1d2,0x0000,
0x0000,0x0000,0x0000,0xeaa4,0x0000,0x0000,0x0000,0xfac2,
0xfbe1,0xfaed,0xf0a2,0xccf1,0x0000,0xfaa3,0xe2f7,0x0000,
0xe2ce,0x0000,0xe9f5,0x0000,0xe1eb,0x0000,0x0000,0x0000,
0xe7e8,0xe8d7,0xdaf8,0xd4cb,0x0000,0x0000,0x0000,0xf7f6,
0xd6c5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xd4e9,0x0000,0x0000,
0xfafa,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xccf2,0xf7dd,0x0000,0xdeba,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcea8,0x0000,
0x0000,0x0000,0x0000,0x0000,0xf0b9,0xe4fe,0xe4c9,0x0000,
0x0000,0x0000,0x0000,0x0000,0xe4d4,0x0000,0x0000,0x0000,
0xeac3,0x0000,0xefb4,0x0000,0x0000,0x0000,0xd7be,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xfbe2,0x0000,0xcdd3,
0x0000,0x0000,0x0000,0xefb5,0x0000,0x0000,0x0000,0xfae9,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xf9a6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xdfbd,
0x0000,0xf7c7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xf8fd,0x0000,0x0000,0xf8fc,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xdeab,0xdbe8,0x0000,0x0000,0xe3dd,
0x0000,0xe1e2,0xd1c6,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf6d0,0xebe6,0xdaf9,
0x0000,0x0000,0x0000,0x0000,0xecc7,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xdef8,0xf8e9,0xe3de,0x0000,
/* 0x9900 */
0x0000,0x0000,0x0000,0xcef5,0x0000,0x0000,0x0000,0x0000,
0x0000,0xfac3,0xe5d7,0x0000,0xecc8,0x0000,0x0000,0x0000,
0xf3c9,0x0000,0x0000,0xe4bb,0x0000,0x0000,0x0000,0x0000,
0xe6ae,0x0000,0x0000,0x0000,0x0000,0x0000,0xefb6,0x0000,
0xdcbf,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xcebd,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xd8c3,0x0000,0x0000,
0x0000,0xd0cf,0x0000,0xcffa,0xf3ca,0xe0d7,0x0000,0x0000,
0x0000,0xd1c7,0xe9ae,0x0000,0xe8bd,0x0000,0x0000,0xfac4,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe2cf,0x0000,
0x0000,0xfac5,0x0000,0x0000,0x0000,0xf9b8,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xdce0,0x0000,0x0000,
0xfbb0,0x0000,0x0000,0x0000,0xd8a9,0xe5df,0xf9a7,0x0000,
0x0000,0xf6ee,0x0000,0xf6cc,0xe2f8,0x0000,0x0000,0x0000,
0x0000,0xecf1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xdae0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xf1d2,0xd2cc,0xcfcb,0x0000,0x0000,0xcabd,0x0000,0x0000,
0x0000,0xddbf,0x0000,0x0000,0x0000,0xf6ef,0x0000,0xdef9,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xfab4,0x0000,0x0000,
0x0000,0xd5ad,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf1e7,
/* 0x9a00 */
0x0000,0xdebe,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xdcc0,0x0000,0x0000,0x0000,0x0000,0x0000,0xd1c8,0xd1c9,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xf8be,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xcbf6,0x0000,0x0000,0x0000,0x0000,
0xd4f9,0x0000,0x0000,0x0000,0x0000,0x0000,0xf5e2,0xe1d3,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd8e9,0x0000,0x0000,0xf8fe,0x0000,0xcfcc,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xfda4,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xcef6,0x0000,0xfad0,
0x0000,0x0000,0xccf3,0xe6be,0x0000,0x0000,0x0000,0xf6ae,
0x0000,0x0000,0xd5f0,0x0000,0x0000,0xd1ca,0x0000,0x0000,
0x0000,0xfcbe,0xd5f1,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xcde9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xfab5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xe2d0,0xf4f7,0x0000,0x0000,0x0000,
0xcdd4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe7a3,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xdba5,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
/* 0x9b00 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xe2d1,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd7a2,
0x0000,0x0000,0xf7e3,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xeaa6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xd0a1,0x0000,0x0000,0x0000,
0x0000,0xceda,0xfbeb,0xdba6,0xdbde,0xd8e5,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xeae0,
0x0000,0x0000,0x0000,0x0000,0xd8aa,0x0000,0x0000,0x0000,
0x0000,0x0000,0xe5e0,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd6db,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xefc6,0x0000,
0x0000,0xf8ea,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe4d5,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xcef7,0x0000,0x0000,0xe0d8,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xd7ef,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf4ed,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xcde6,0x0000,0x0000,0x0000,
0xccf4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
/* 0x9c00 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf5e3,0x0000,0x0000,
0xe4ca,0x0000,0xdce1,0x0000,0x0000,0xf9c8,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xfcbf,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xe8a7,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xd8c4,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcbbe,
0x0000,0xdcae,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd7f7,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xf0e8,0x0000,0xddc0,
0x0000,0xcfcd,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xdcf3,0xd9b0,0x0000,0xe6e9,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
/* 0x9d00 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xe4bc,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xeac4,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe4ec,0x0000,
0xe4e5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xfbf8,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xccbb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe4bd,0x0000,0x0000,
0xcddc,0xd9f7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xdddf,0x0000,0x0000,0x0000,
0x0000,0x0000,0xedce,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0xd9d0,0x0000,0x0000,0x0000,0x0000,0x0000,0xe5a3,
0x0000,0x0000,0x0000,0x0000,0xf9cd,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xcdae,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xcfce,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf6af,0x0000,0x0000,0x0000,0x0000,0x0000,
0xfdd3,0xebed,0xd6dc,0x0000,0x0000,0x0000,0x0000,0x0000,
/* 0x9e00 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xe5a4,0x0000,0x0000,0x0000,0xd5b6,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xd6dd,0x0000,0x0000,
0x0000,0xf9e9,0x0000,0x0000,0x0000,0xe7a4,0x0000,0xd6e3,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xd1cb,0xd6e4,0x0000,0x0000,0x0000,0xd5f2,
0x0000,0x0000,0x0000,0x0000,0x0000,0xdefa,0x0000,0xd7f8,
0x0000,0x0000,0x0000,0x0000,0x0000,0xd8ea,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xcfd5,0xd8fd,0x0000,0x0000,
0x0000,0x0000,0x0000,0xd8ab,0x0000,0x0000,0xfdcb,0x0000,
0x0000,0x0000,0x0000,0xfcdc,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xe0a8,0xd5f3,0x0000,
0x0000,0xfdd9,0x0000,0x0000,0xcca3,0x0000,0x0000,0x0000,
0xd9f9,0x0000,0x0000,0xd3ea,0xf5f5,0x0000,0xefc7,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xd3da,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xdabd,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
/* 0x9f00 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe8a8,
0xdcaf,0x0000,0x0000,0x0000,0x0000,0x0000,0xf0a3,0x0000,
0x0000,0x0000,0x0000,0xcdd5,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xe0a9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0xdeac,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xf0ba,0xeeb1,0x0000,0x0000,0xeeb2,0x0000,
0x0000,0x0000,0xf6cd,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xeed2,
0x0000,0xd6c6,0x0000,0x0000,0x0000,0x0000,0x0000,0xe0e5,
0x0000,0x0000,0xf3bb,0x0000,0xe5e1,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe4cb,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0xd7a3,0x0000,0x0000,
0xdbc2,0x0000,0x0000,0x0000,0x0000,0xcafe,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0xcfcf};

static const int ucs_i_uhc_table_min = 0x4d00;
static const int ucs_i_uhc_table_max = 0x4d00 + (sizeof(ucs_i_uhc_table)/sizeof(unsigned short));

static const unsigned short ucs_s_uhc_table[] = {
/* 0xab00 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xb0a1,0xb0a2,0x8141,0x8142,0xb0a3,0x8143,0x8144,0xb0a4,
0xb0a5,0xb0a6,0xb0a7,0x8145,0x8146,0x8147,0x8148,0x8149,
0xb0a8,0xb0a9,0xb0aa,0xb0ab,0xb0ac,0xb0ad,0xb0ae,0xb0af,
0x814a,0xb0b0,0xb0b1,0xb0b2,0xb0b3,0xb0b4,0x814b,0x814c,
0xb0b5,0x814d,0x814e,0x814f,0xb0b6,0x8150,0x8151,0x8152,
0x8153,0x8154,0x8155,0x8156,0xb0b7,0xb0b8,0x8157,0xb0b9,
0xb0ba,0xb0bb,0x8158,0x8159,0x815a,0x8161,0x8162,0x8163,
0xb0bc,0xb0bd,0x8164,0x8165,0xb0be,0x8166,0x8167,0x8168,
0xb0bf,0x8169,0x816a,0x816b,0x816c,0x816d,0x816e,0x816f,
0x8170,0x8171,0x8172,0xb0c0,0x8173,0xb0c1,0x8174,0x8175,
0x8176,0x8177,0x8178,0x8179,0xb0c2,0x817a,0x8181,0x8182,
0xb0c3,0x8183,0x8184,0x8185,0xb0c4,0x8186,0x8187,0x8188,
0x8189,0x818a,0x818b,0x818c,0x818d,0x818e,0x818f,0x8190,
0x8191,0x8192,0x8193,0x8194,0x8195,0x8196,0x8197,0x8198,
0xb0c5,0xb0c6,0x8199,0x819a,0xb0c7,0x819b,0x819c,0xb0c8,
0xb0c9,0x819d,0xb0ca,0x819e,0x819f,0x81a0,0x81a1,0x81a2,
0xb0cb,0xb0cc,0x81a3,0xb0cd,0xb0ce,0xb0cf,0xb0d0,0x81a4,
0x81a5,0xb0d1,0xb0d2,0xb0d3,0xb0d4,0x81a6,0x81a7,0x81a8,
0xb0d5,0x81a9,0x81aa,0x81ab,0xb0d6,0x81ac,0x81ad,0x81ae,
0x81af,0x81b0,0x81b1,0x81b2,0xb0d7,0xb0d8,0x81b3,0xb0d9,
0xb0da,0xb0db,0x81b4,0x81b5,0x81b6,0x81b7,0x81b8,0x81b9,
0xb0dc,0xb0dd,0xb0de,0x81ba,0xb0df,0x81bb,0x81bc,0xb0e0,
0xb0e1,0x81bd,0x81be,0x81bf,0x81c0,0x81c1,0x81c2,0x81c3,
0xb0e2,0xb0e3,0x81c4,0xb0e4,0xb0e5,0xb0e6,0x81c5,0x81c6,
0x81c7,0xb0e7,0x81c8,0x81c9,0xb0e8,0x81ca,0x81cb,0x81cc,
0xb0e9,0x81cd,0x81ce,0x81cf,0xb0ea,0x81d0,0x81d1,0x81d2,
0x81d3,0x81d4,0x81d5,0x81d6,0x81d7,0xb0eb,0x81d8,0xb0ec,
0x81d9,0x81da,0x81db,0x81dc,0x81dd,0x81de,0x81df,0x81e0,
0xb0ed,0xb0ee,0x81e1,0x81e2,0xb0ef,0x81e3,0x81e4,0xb0f0,
0xb0f1,0x81e5,0xb0f2,0x81e6,0xb0f3,0x81e7,0x81e8,0xb0f4,
0xb0f5,0xb0f6,0x81e9,0xb0f7,0x81ea,0xb0f8,0xb0f9,0x81eb,
0x81ec,0x81ed,0x81ee,0x81ef,0xb0fa,0xb0fb,0x81f0,0x81f1,
/* 0xad00 */
0xb0fc,0x81f2,0x81f3,0x81f4,0xb0fd,0x81f5,0xb0fe,0x81f6,
0x81f7,0x81f8,0x81f9,0x81fa,0xb1a1,0xb1a2,0x81fb,0xb1a3,
0x81fc,0xb1a4,0x81fd,0x81fe,0x8241,0x8242,0x8243,0x8244,
0xb1a5,0x8245,0x8246,0x8247,0xb1a6,0x8248,0x8249,0x824a,
0xb1a7,0x824b,0x824c,0x824d,0x824e,0x824f,0x8250,0x8251,
0x8252,0xb1a8,0x8253,0x8254,0xb1a9,0xb1aa,0x8255,0x8256,
0x8257,0x8258,0x8259,0x825a,0xb1ab,0xb1ac,0x8261,0x8262,
0xb1ad,0x8263,0x8264,0x8265,0xb1ae,0x8266,0x8267,0x8268,
0x8269,0x826a,0x826b,0x826c,0xb1af,0xb1b0,0x826d,0xb1b1,
0x826e,0xb1b2,0x826f,0x8270,0x8271,0x8272,0x8273,0x8274,
0xb1b3,0x8275,0x8276,0x8277,0xb1b4,0x8278,0x8279,0x827a,
0xb1b5,0x8281,0x8282,0x8283,0x8284,0x8285,0x8286,0x8287,
0x8288,0xb1b6,0x8289,0xb1b7,0x828a,0x828b,0x828c,0x828d,
0x828e,0x828f,0x8290,0x8291,0xb1b8,0xb1b9,0x8292,0x8293,
0xb1ba,0x8294,0x8295,0xb1bb,0xb1bc,0xb1bd,0xb1be,0x8296,
0x8297,0x8298,0x8299,0xb1bf,0xb1c0,0xb1c1,0x829a,0xb1c2,
0x829b,0xb1c3,0xb1c4,0x829c,0x829d,0x829e,0x829f,0x82a0,
0xb1c5,0xb1c6,0x82a1,0x82a2,0xb1c7,0x82a3,0x82a4,0x82a5,
0xb1c8,0x82a6,0x82a7,0x82a8,0x82a9,0x82aa,0x82ab,0x82ac,
0x82ad,0x82ae,0x82af,0x82b0,0xb1c9,0xb1ca,0x82b1,0x82b2,
0x82b3,0x82b4,0x82b5,0x82b6,0xb1cb,0x82b7,0x82b8,0x82b9,
0x82ba,0x82bb,0x82bc,0x82bd,0x82be,0x82bf,0x82c0,0x82c1,
0x82c2,0x82c3,0x82c4,0x82c5,0x82c6,0x82c7,0x82c8,0xb1cc,
0x82c9,0x82ca,0x82cb,0x82cc,0x82cd,0x82ce,0x82cf,0x82d0,
0xb1cd,0xb1ce,0x82d1,0x82d2,0xb1cf,0x82d3,0x82d4,0x82d5,
0xb1d0,0x82d6,0x82d7,0x82d8,0x82d9,0x82da,0x82db,0x82dc,
0xb1d1,0xb1d2,0x82dd,0xb1d3,0x82de,0x82df,0x82e0,0x82e1,
0x82e2,0x82e3,0x82e4,0x82e5,0xb1d4,0x82e6,0x82e7,0x82e8,
0xb1d5,0x82e9,0x82ea,0x82eb,0xb1d6,0x82ec,0x82ed,0x82ee,
0x82ef,0x82f0,0x82f1,0x82f2,0x82f3,0x82f4,0x82f5,0x82f6,
0x82f7,0x82f8,0x82f9,0x82fa,0x82fb,0x82fc,0x82fd,0x82fe,
0xb1d7,0xb1d8,0x8341,0x8342,0xb1d9,0x8343,0x8344,0xb1da,
/* 0xae00 */
0xb1db,0xb1dc,0x8345,0x8346,0x8347,0x8348,0x8349,0x834a,
0xb1dd,0xb1de,0x834b,0xb1df,0x834c,0xb1e0,0x834d,0x834e,
0x834f,0x8350,0x8351,0x8352,0xb1e1,0x8353,0x8354,0x8355,
0x8356,0x8357,0x8358,0x8359,0x835a,0x8361,0x8362,0x8363,
0x8364,0x8365,0x8366,0x8367,0x8368,0x8369,0x836a,0x836b,
0x836c,0x836d,0x836e,0x836f,0x8370,0x8371,0x8372,0x8373,
0xb1e2,0xb1e3,0x8374,0x8375,0xb1e4,0x8376,0x8377,0xb1e5,
0xb1e6,0x8378,0xb1e7,0x8379,0x837a,0x8381,0x8382,0x8383,
0xb1e8,0xb1e9,0x8384,0xb1ea,0x8385,0xb1eb,0xb1ec,0x8386,
0x8387,0x8388,0xb1ed,0x8389,0xb1ee,0xb1ef,0xb1f0,0x838a,
0xb1f1,0x838b,0x838c,0x838d,0xb1f2,0x838e,0xb1f3,0x838f,
0x8390,0x8391,0x8392,0x8393,0xb1f4,0xb1f5,0x8394,0xb1f6,
0xb1f7,0xb1f8,0x8395,0x8396,0x8397,0xb1f9,0x8398,0x8399,
0xb1fa,0xb1fb,0x839a,0x839b,0xb1fc,0x839c,0x839d,0x839e,
0xb1fd,0x839f,0x83a0,0x83a1,0x83a2,0x83a3,0x83a4,0x83a5,
0xb1fe,0xb2a1,0x83a6,0xb2a2,0xb2a3,0xb2a4,0x83a7,0x83a8,
0x83a9,0x83aa,0x83ab,0x83ac,0xb2a5,0xb2a6,0x83ad,0x83ae,
0x83af,0x83b0,0x83b1,0x83b2,0xb2a7,0x83b3,0x83b4,0x83b5,
0x83b6,0x83b7,0x83b8,0x83b9,0x83ba,0x83bb,0x83bc,0x83bd,
0x83be,0x83bf,0x83c0,0x83c1,0x83c2,0x83c3,0x83c4,0x83c5,
0x83c6,0x83c7,0x83c8,0x83c9,0x83ca,0x83cb,0x83cc,0x83cd,
0x83ce,0x83cf,0x83d0,0x83d1,0x83d2,0x83d3,0x83d4,0x83d5,
0x83d6,0x83d7,0x83d8,0x83d9,0x83da,0x83db,0x83dc,0x83dd,
0x83de,0x83df,0x83e0,0x83e1,0xb2a8,0xb2a9,0xb2aa,0x83e2,
0xb2ab,0x83e3,0x83e4,0x83e5,0xb2ac,0x83e6,0x83e7,0x83e8,
0x83e9,0x83ea,0x83eb,0x83ec,0xb2ad,0xb2ae,0x83ed,0xb2af,
0xb2b0,0xb2b1,0x83ee,0x83ef,0x83f0,0x83f1,0x83f2,0x83f3,
0xb2b2,0xb2b3,0x83f4,0x83f5,0xb2b4,0x83f6,0x83f7,0x83f8,
0x83f9,0x83fa,0x83fb,0x83fc,0x83fd,0x83fe,0x8441,0x8442,
0xb2b5,0x8443,0x8444,0xb2b6,0x8445,0xb2b7,0x8446,0x8447,
0x8448,0x8449,0x844a,0x844b,0xb2b8,0x844c,0x844d,0x844e,
0xb2b9,0x844f,0x8450,0x8451,0xb2ba,0x8452,0x8453,0x8454,
/* 0xaf00 */
0x8455,0x8456,0x8457,0x8458,0x8459,0x845a,0x8461,0xb2bb,
0xb2bc,0x8462,0x8463,0x8464,0x8465,0xb2bd,0x8466,0x8467,
0xb2be,0x8468,0x8469,0x846a,0x846b,0x846c,0x846d,0x846e,
0x846f,0x8470,0x8471,0x8472,0x8473,0x8474,0x8475,0x8476,
0x8477,0x8478,0x8479,0x847a,0x8481,0x8482,0x8483,0x8484,
0x8485,0x8486,0x8487,0x8488,0xb2bf,0xb2c0,0x8489,0x848a,
0xb2c1,0x848b,0xb2c2,0x848c,0xb2c3,0x848d,0x848e,0x848f,
0x8490,0x8491,0x8492,0x8493,0xb2c4,0xb2c5,0x8494,0xb2c6,
0x8495,0xb2c7,0xb2c8,0xb2c9,0x8496,0x8497,0x8498,0x8499,
0xb2ca,0xb2cb,0x849a,0x849b,0x849c,0x849d,0x849e,0x849f,
0xb2cc,0x84a0,0x84a1,0x84a2,0x84a3,0x84a4,0x84a5,0x84a6,
0x84a7,0x84a8,0x84a9,0x84aa,0xb2cd,0xb2ce,0x84ab,0x84ac,
0x84ad,0x84ae,0x84af,0x84b0,0xb2cf,0xb2d0,0x84b1,0x84b2,
0x84b3,0x84b4,0x84b5,0x84b6,0x84b7,0x84b8,0x84b9,0x84ba,
0x84bb,0x84bc,0x84bd,0x84be,0x84bf,0x84c0,0x84c1,0x84c2,
0x84c3,0xb2d1,0x84c4,0x84c5,0x84c6,0x84c7,0x84c8,0x84c9,
0xb2d2,0x84ca,0x84cb,0x84cc,0xb2d3,0x84cd,0x84ce,0x84cf,
0xb2d4,0x84d0,0x84d1,0x84d2,0x84d3,0x84d4,0x84d5,0x84d6,
0xb2d5,0xb2d6,0x84d7,0x84d8,0x84d9,0xb2d7,0x84da,0x84db,
0x84dc,0x84dd,0x84de,0x84df,0xb2d8,0x84e0,0x84e1,0x84e2,
0x84e3,0x84e4,0x84e5,0x84e6,0x84e7,0x84e8,0x84e9,0x84ea,
0x84eb,0x84ec,0x84ed,0x84ee,0x84ef,0x84f0,0x84f1,0x84f2,
0x84f3,0x84f4,0x84f5,0x84f6,0x84f7,0x84f8,0x84f9,0x84fa,
0xb2d9,0xb2da,0x84fb,0x84fc,0xb2db,0x84fd,0x84fe,0x8541,
0xb2dc,0x8542,0x8543,0x8544,0x8545,0x8546,0x8547,0xb2dd,
0xb2de,0xb2df,0x8548,0xb2e0,0x8549,0xb2e1,0xb2e2,0x854a,
0x854b,0x854c,0x854d,0x854e,0xb2e3,0x854f,0x8550,0x8551,
0x8552,0x8553,0x8554,0x8555,0xb2e4,0x8556,0x8557,0x8558,
0x8559,0x855a,0x8561,0x8562,0x8563,0x8564,0x8565,0x8566,
0xb2e5,0xb2e6,0x8567,0x8568,0x8569,0x856a,0x856b,0x856c,
0xb2e7,0xb2e8,0x856d,0x856e,0xb2e9,0x856f,0x8570,0x8571,
0xb2ea,0x8572,0x8573,0x8574,0x8575,0x8576,0x8577,0x8578,
/* 0xb000 */
0xb2eb,0xb2ec,0x8579,0x857a,0xb2ed,0x8581,0x8582,0x8583,
0x8584,0x8585,0x8586,0x8587,0xb2ee,0x8588,0x8589,0x858a,
0xb2ef,0x858b,0x858c,0x858d,0xb2f0,0x858e,0x858f,0x8590,
0x8591,0x8592,0x8593,0x8594,0xb2f1,0xb2f2,0x8595,0x8596,
0x8597,0x8598,0x8599,0x859a,0x859b,0x859c,0x859d,0x859e,
0xb2f3,0x859f,0x85a0,0x85a1,0x85a2,0x85a3,0x85a4,0x85a5,
0x85a6,0x85a7,0x85a8,0x85a9,0x85aa,0x85ab,0x85ac,0x85ad,
0x85ae,0x85af,0x85b0,0x85b1,0x85b2,0x85b3,0x85b4,0x85b5,
0x85b6,0x85b7,0x85b8,0x85b9,0xb2f4,0xb2f5,0x85ba,0x85bb,
0xb2f6,0x85bc,0xb2f7,0x85bd,0xb2f8,0x85be,0xb2f9,0x85bf,
0x85c0,0x85c1,0x85c2,0xb2fa,0xb2fb,0xb2fc,0x85c3,0xb2fd,
0x85c4,0xb2fe,0x85c5,0x85c6,0x85c7,0xb3a1,0x85c8,0x85c9,
0x85ca,0x85cb,0x85cc,0x85cd,0x85ce,0x85cf,0x85d0,0x85d1,
0x85d2,0x85d3,0x85d4,0x85d5,0x85d6,0x85d7,0x85d8,0x85d9,
0x85da,0x85db,0x85dc,0x85dd,0x85de,0x85df,0x85e0,0x85e1,
0x85e2,0x85e3,0x85e4,0x85e5,0xb3a2,0xb3a3,0x85e6,0x85e7,
0xb3a4,0x85e8,0x85e9,0x85ea,0xb3a5,0x85eb,0x85ec,0x85ed,
0x85ee,0x85ef,0x85f0,0x85f1,0xb3a6,0xb3a7,0x85f2,0xb3a8,
0x85f3,0xb3a9,0x85f4,0x85f5,0x85f6,0x85f7,0x85f8,0x85f9,
0xb3aa,0xb3ab,0xb3ac,0x85fa,0xb3ad,0x85fb,0x85fc,0xb3ae,
0xb3af,0xb3b0,0xb3b1,0x85fd,0x85fe,0x8641,0x8642,0x8643,
0xb3b2,0xb3b3,0x8644,0xb3b4,0xb3b5,0xb3b6,0xb3b7,0xb3b8,
0x8645,0xb3b9,0x8646,0xb3ba,0xb3bb,0xb3bc,0x8647,0x8648,
0xb3bd,0x8649,0x864a,0x864b,0xb3be,0x864c,0x864d,0x864e,
0x864f,0x8650,0x8651,0x8652,0xb3bf,0xb3c0,0x8653,0xb3c1,
0xb3c2,0xb3c3,0x8654,0x8655,0x8656,0x8657,0x8658,0x8659,
0xb3c4,0xb3c5,0x865a,0x8661,0xb3c6,0x8662,0x8663,0x8664,
0xb3c7,0x8665,0x8666,0x8667,0x8668,0x8669,0x866a,0x866b,
0xb3c8,0x866c,0x866d,0x866e,0x866f,0xb3c9,0x8670,0x8671,
0x8672,0x8673,0x8674,0x8675,0x8676,0x8677,0x8678,0x8679,
0x867a,0x8681,0x8682,0x8683,0x8684,0x8685,0x8686,0x8687,
0x8688,0x8689,0x868a,0x868b,0x868c,0x868d,0x868e,0x868f,
/* 0xb100 */
0x8690,0x8691,0x8692,0x8693,0x8694,0x8695,0x8696,0x8697,
0xb3ca,0xb3cb,0x8698,0xb3cc,0xb3cd,0x8699,0x869a,0x869b,
0xb3ce,0x869c,0xb3cf,0xb3d0,0x869d,0x869e,0x869f,0x86a0,
0xb3d1,0xb3d2,0x86a1,0xb3d3,0xb3d4,0xb3d5,0x86a2,0x86a3,
0x86a4,0x86a5,0x86a6,0xb3d6,0xb3d7,0xb3d8,0x86a7,0x86a8,
0xb3d9,0x86a9,0x86aa,0x86ab,0xb3da,0x86ac,0x86ad,0x86ae,
0x86af,0x86b0,0x86b1,0x86b2,0xb3db,0xb3dc,0x86b3,0xb3dd,
0xb3de,0xb3df,0x86b4,0x86b5,0x86b6,0x86b7,0x86b8,0x86b9,
0xb3e0,0xb3e1,0x86ba,0x86bb,0xb3e2,0x86bc,0x86bd,0x86be,
0xb3e3,0x86bf,0x86c0,0x86c1,0x86c2,0x86c3,0x86c4,0x86c5,
0xb3e4,0xb3e5,0x86c6,0x86c7,0xb3e6,0xb3e7,0x86c8,0x86c9,
0xb3e8,0x86ca,0x86cb,0x86cc,0xb3e9,0x86cd,0x86ce,0x86cf,
0xb3ea,0x86d0,0x86d1,0x86d2,0x86d3,0x86d4,0x86d5,0x86d6,
0x86d7,0x86d8,0x86d9,0x86da,0x86db,0x86dc,0x86dd,0x86de,
0x86df,0x86e0,0x86e1,0x86e2,0x86e3,0x86e4,0x86e5,0x86e6,
0xb3eb,0xb3ec,0x86e7,0x86e8,0xb3ed,0x86e9,0x86ea,0x86eb,
0xb3ee,0x86ec,0xb3ef,0x86ed,0x86ee,0x86ef,0x86f0,0x86f1,
0xb3f0,0xb3f1,0x86f2,0xb3f2,0x86f3,0xb3f3,0x86f4,0x86f5,
0x86f6,0x86f7,0xb3f4,0xb3f5,0xb3f6,0x86f8,0x86f9,0x86fa,
0xb3f7,0x86fb,0x86fc,0x86fd,0xb3f8,0x86fe,0x8741,0x8742,
0x8743,0x8744,0x8745,0x8746,0x8747,0x8748,0x8749,0x874a,
0xb3f9,0x874b,0x874c,0x874d,0x874e,0x874f,0x8750,0x8751,
0x8752,0x8753,0x8754,0x8755,0x8756,0x8757,0x8758,0x8759,
0x875a,0x8761,0x8762,0x8763,0x8764,0x8765,0x8766,0x8767,
0x8768,0x8769,0x876a,0x876b,0x876c,0x876d,0x876e,0x876f,
0x8770,0x8771,0x8772,0x8773,0xb3fa,0x8774,0x8775,0x8776,
0xb3fb,0x8777,0x8778,0x8779,0xb3fc,0x877a,0x8781,0x8782,
0x8783,0x8784,0x8785,0x8786,0xb3fd,0xb3fe,0x8787,0xb4a1,
0x8788,0x8789,0x878a,0x878b,0x878c,0x878d,0x878e,0x878f,
0xb4a2,0xb4a3,0x8790,0x8791,0xb4a4,0x8792,0x8793,0x8794,
0xb4a5,0x8795,0x8796,0x8797,0x8798,0x8799,0x879a,0x879b,
0x879c,0xb4a6,0x879d,0xb4a7,0x879e,0xb4a8,0x879f,0x87a0,
/* 0xb200 */
0x87a1,0x87a2,0x87a3,0x87a4,0xb4a9,0xb4aa,0x87a5,0x87a6,
0xb4ab,0x87a7,0x87a8,0xb4ac,0xb4ad,0x87a9,0x87aa,0x87ab,
0x87ac,0x87ad,0x87ae,0x87af,0xb4ae,0xb4af,0x87b0,0xb4b0,
0x87b1,0xb4b1,0x87b2,0x87b3,0x87b4,0x87b5,0x87b6,0x87b7,
0xb4b2,0x87b8,0x87b9,0x87ba,0x87bb,0x87bc,0x87bd,0x87be,
0x87bf,0x87c0,0x87c1,0x87c2,0x87c3,0x87c4,0x87c5,0x87c6,
0x87c7,0x87c8,0x87c9,0x87ca,0xb4b3,0x87cb,0x87cc,0x87cd,
0x87ce,0x87cf,0x87d0,0x87d1,0xb4b4,0x87d2,0x87d3,0x87d4,
0x87d5,0x87d6,0x87d7,0x87d8,0x87d9,0x87da,0x87db,0x87dc,
0x87dd,0x87de,0x87df,0x87e0,0x87e1,0x87e2,0x87e3,0x87e4,
0x87e5,0x87e6,0x87e7,0x87e8,0x87e9,0x87ea,0x87eb,0x87ec,
0xb4b5,0x87ed,0x87ee,0x87ef,0xb4b6,0x87f0,0x87f1,0x87f2,
0xb4b7,0x87f3,0x87f4,0x87f5,0x87f6,0x87f7,0x87f8,0x87f9,
0xb4b8,0xb4b9,0x87fa,0x87fb,0x87fc,0x87fd,0x87fe,0x8841,
0x8842,0x8843,0x8844,0x8845,0xb4ba,0xb4bb,0x8846,0x8847,
0x8848,0x8849,0x884a,0x884b,0xb4bc,0x884c,0x884d,0x884e,
0x884f,0x8850,0x8851,0x8852,0xb4bd,0xb4be,0x8853,0x8854,
0x8855,0xb4bf,0x8856,0x8857,0x8858,0x8859,0x885a,0x8861,
0xb4c0,0xb4c1,0x8862,0x8863,0xb4c2,0x8864,0x8865,0x8866,
0xb4c3,0xb4c4,0xb4c5,0x8867,0x8868,0x8869,0x886a,0x886b,
0xb4c6,0xb4c7,0x886c,0xb4c8,0x886d,0xb4c9,0xb4ca,0x886e,
0x886f,0x8870,0xb4cb,0x8871,0xb4cc,0x8872,0x8873,0x8874,
0xb4cd,0x8875,0x8876,0x8877,0xb4ce,0x8878,0x8879,0x887a,
0x8881,0x8882,0x8883,0x8884,0x8885,0x8886,0x8887,0x8888,
0x8889,0x888a,0x888b,0x888c,0x888d,0x888e,0x888f,0x8890,
0xb4cf,0xb4d0,0x8891,0x8892,0xb4d1,0x8893,0x8894,0x8895,
0xb4d2,0x8896,0xb4d3,0x8897,0x8898,0x8899,0x889a,0x889b,
0xb4d4,0xb4d5,0x889c,0xb4d6,0x889d,0xb4d7,0x889e,0x889f,
0x88a0,0x88a1,0xb4d8,0x88a2,0xb4d9,0xb4da,0xb4db,0x88a3,
0xb4dc,0x88a4,0x88a5,0xb4dd,0xb4de,0xb4df,0xb4e0,0xb4e1,
0x88a6,0x88a7,0x88a8,0xb4e2,0xb4e3,0xb4e4,0x88a9,0xb4e5,
0xb4e6,0xb4e7,0xb4e8,0xb4e9,0x88aa,0x88ab,0x88ac,0xb4ea,
/* 0xb300 */
0xb4eb,0xb4ec,0x88ad,0x88ae,0xb4ed,0x88af,0x88b0,0x88b1,
0xb4ee,0x88b2,0x88b3,0x88b4,0x88b5,0x88b6,0x88b7,0x88b8,
0xb4ef,0xb4f0,0x88b9,0xb4f1,0xb4f2,0xb4f3,0x88ba,0x88bb,
0x88bc,0x88bd,0x88be,0x88bf,0xb4f4,0x88c0,0x88c1,0x88c2,
0x88c3,0x88c4,0x88c5,0x88c6,0x88c7,0x88c8,0x88c9,0x88ca,
0x88cb,0x88cc,0x88cd,0x88ce,0x88cf,0x88d0,0x88d1,0x88d2,
0x88d3,0x88d4,0x88d5,0x88d6,0x88d7,0x88d8,0x88d9,0x88da,
0x88db,0x88dc,0x88dd,0x88de,0x88df,0x88e0,0x88e1,0x88e2,
0x88e3,0x88e4,0x88e5,0x88e6,0x88e7,0x88e8,0x88e9,0x88ea,
0x88eb,0x88ec,0x88ed,0x88ee,0x88ef,0x88f0,0x88f1,0x88f2,
0x88f3,0x88f4,0x88f5,0x88f6,0xb4f5,0xb4f6,0xb4f7,0x88f7,
0xb4f8,0x88f8,0x88f9,0xb4f9,0xb4fa,0x88fa,0xb4fb,0xb4fc,
0x88fb,0x88fc,0x88fd,0x88fe,0xb4fd,0xb4fe,0x8941,0xb5a1,
0x8942,0xb5a2,0x8943,0xb5a3,0x8944,0x8945,0xb5a4,0x8946,
0xb5a5,0xb5a6,0x8947,0x8948,0xb5a7,0x8949,0x894a,0x894b,
0xb5a8,0x894c,0x894d,0x894e,0x894f,0x8950,0x8951,0x8952,
0xb5a9,0xb5aa,0x8953,0xb5ab,0xb5ac,0xb5ad,0x8954,0x8955,
0x8956,0x8957,0x8958,0x8959,0xb5ae,0x895a,0x8961,0x8962,
0xb5af,0x8963,0x8964,0x8965,0xb5b0,0x8966,0x8967,0x8968,
0x8969,0x896a,0x896b,0x896c,0x896d,0x896e,0x896f,0x8970,
0xb5b1,0xb5b2,0x8971,0x8972,0x8973,0x8974,0x8975,0x8976,
0xb5b3,0x8977,0x8978,0x8979,0xb5b4,0x897a,0x8981,0x8982,
0x8983,0x8984,0x8985,0x8986,0x8987,0x8988,0x8989,0x898a,
0x898b,0x898c,0x898d,0x898e,0x898f,0x8990,0x8991,0x8992,
0x8993,0x8994,0x8995,0x8996,0xb5b5,0xb5b6,0x8997,0x8998,
0xb5b7,0x8999,0x899a,0xb5b8,0xb5b9,0x899b,0xb5ba,0x899c,
0xb5bb,0x899d,0x899e,0x899f,0xb5bc,0xb5bd,0x89a0,0xb5be,
0x89a1,0xb5bf,0x89a2,0xb5c0,0x89a3,0xb5c1,0x89a4,0x89a5,
0xb5c2,0x89a6,0x89a7,0x89a8,0xb5c3,0x89a9,0x89aa,0x89ab,
0xb5c4,0x89ac,0x89ad,0x89ae,0x89af,0x89b0,0x89b1,0x89b2,
0x89b3,0x89b4,0x89b5,0x89b6,0x89b7,0x89b8,0x89b9,0x89ba,
0x89bb,0x89bc,0x89bd,0x89be,0xb5c5,0x89bf,0x89c0,0x89c1,
/* 0xb400 */
0x89c2,0x89c3,0x89c4,0x89c5,0x89c6,0x89c7,0x89c8,0x89c9,
0x89ca,0x89cb,0x89cc,0x89cd,0x89ce,0x89cf,0x89d0,0x89d1,
0xb5c6,0x89d2,0x89d3,0x89d4,0x89d5,0x89d6,0x89d7,0x89d8,
0xb5c7,0x89d9,0x89da,0x89db,0xb5c8,0x89dc,0x89dd,0x89de,
0xb5c9,0x89df,0x89e0,0x89e1,0x89e2,0x89e3,0x89e4,0x89e5,
0xb5ca,0xb5cb,0x89e6,0xb5cc,0x89e7,0x89e8,0x89e9,0x89ea,
0x89eb,0x89ec,0x89ed,0x89ee,0xb5cd,0x89ef,0x89f0,0x89f1,
0x89f2,0x89f3,0x89f4,0x89f5,0x89f6,0x89f7,0x89f8,0x89f9,
0x89fa,0x89fb,0x89fc,0x89fd,0x89fe,0x8a41,0x8a42,0x8a43,
0x8a44,0x8a45,0x8a46,0x8a47,0x8a48,0x8a49,0x8a4a,0x8a4b,
0xb5ce,0xb5cf,0x8a4c,0x8a4d,0xb5d0,0x8a4e,0x8a4f,0x8a50,
0xb5d1,0x8a51,0x8a52,0x8a53,0x8a54,0x8a55,0x8a56,0x8a57,
0xb5d2,0xb5d3,0x8a58,0xb5d4,0x8a59,0xb5d5,0x8a5a,0x8a61,
0x8a62,0x8a63,0x8a64,0x8a65,0xb5d6,0x8a66,0x8a67,0x8a68,
0x8a69,0x8a6a,0x8a6b,0x8a6c,0x8a6d,0x8a6e,0x8a6f,0x8a70,
0x8a71,0x8a72,0x8a73,0x8a74,0x8a75,0x8a76,0x8a77,0x8a78,
0xb5d7,0x8a79,0x8a7a,0x8a81,0x8a82,0x8a83,0x8a84,0x8a85,
0xb5d8,0x8a86,0x8a87,0x8a88,0x8a89,0x8a8a,0x8a8b,0x8a8c,
0x8a8d,0x8a8e,0x8a8f,0x8a90,0x8a91,0x8a92,0x8a93,0x8a94,
0x8a95,0x8a96,0x8a97,0x8a98,0x8a99,0xb5d9,0x8a9a,0x8a9b,
0x8a9c,0x8a9d,0x8a9e,0x8a9f,0xb5da,0x8aa0,0x8aa1,0x8aa2,
0xb5db,0x8aa3,0x8aa4,0x8aa5,0xb5dc,0x8aa6,0x8aa7,0x8aa8,
0x8aa9,0x8aaa,0x8aab,0x8aac,0x8aad,0xb5dd,0x8aae,0xb5de,
0x8aaf,0xb5df,0x8ab0,0x8ab1,0x8ab2,0x8ab3,0x8ab4,0x8ab5,
0xb5e0,0x8ab6,0x8ab7,0x8ab8,0xb5e1,0x8ab9,0x8aba,0x8abb,
0xb5e2,0x8abc,0x8abd,0x8abe,0x8abf,0x8ac0,0x8ac1,0x8ac2,
0xb5e3,0x8ac3,0x8ac4,0x8ac5,0x8ac6,0xb5e4,0x8ac7,0x8ac8,
0x8ac9,0x8aca,0x8acb,0x8acc,0xb5e5,0xb5e6,0x8acd,0x8ace,
0xb5e7,0x8acf,0x8ad0,0xb5e8,0xb5e9,0x8ad1,0xb5ea,0x8ad2,
0x8ad3,0x8ad4,0x8ad5,0x8ad6,0xb5eb,0xb5ec,0x8ad7,0xb5ed,
0x8ad8,0xb5ee,0x8ad9,0x8ada,0x8adb,0x8adc,0x8add,0x8ade,
0xb5ef,0x8adf,0x8ae0,0x8ae1,0x8ae2,0x8ae3,0x8ae4,0x8ae5,
/* 0xb500 */
0x8ae6,0x8ae7,0x8ae8,0x8ae9,0x8aea,0x8aeb,0x8aec,0x8aed,
0x8aee,0x8aef,0x8af0,0x8af1,0x8af2,0x8af3,0x8af4,0x8af5,
0x8af6,0x8af7,0x8af8,0x8af9,0xb5f0,0xb5f1,0x8afa,0x8afb,
0xb5f2,0x8afc,0x8afd,0xb5f3,0xb5f4,0x8afe,0x8b41,0x8b42,
0x8b43,0x8b44,0x8b45,0x8b46,0xb5f5,0xb5f6,0x8b47,0xb5f7,
0xb5f8,0xb5f9,0xb5fa,0x8b48,0x8b49,0x8b4a,0x8b4b,0x8b4c,
0xb5fb,0xb5fc,0x8b4d,0x8b4e,0xb5fd,0x8b4f,0x8b50,0x8b51,
0xb5fe,0x8b52,0x8b53,0x8b54,0x8b55,0x8b56,0x8b57,0x8b58,
0xb6a1,0xb6a2,0x8b59,0xb6a3,0xb6a4,0xb6a5,0x8b5a,0x8b61,
0x8b62,0x8b63,0x8b64,0xb6a6,0xb6a7,0xb6a8,0x8b65,0x8b66,
0xb6a9,0x8b67,0x8b68,0x8b69,0xb6aa,0x8b6a,0x8b6b,0x8b6c,
0x8b6d,0x8b6e,0x8b6f,0x8b70,0xb6ab,0xb6ac,0x8b71,0xb6ad,
0xb6ae,0xb6af,0x8b72,0x8b73,0x8b74,0x8b75,0x8b76,0x8b77,
0x8b78,0x8b79,0x8b7a,0x8b81,0x8b82,0x8b83,0x8b84,0x8b85,
0x8b86,0x8b87,0x8b88,0x8b89,0x8b8a,0x8b8b,0x8b8c,0x8b8d,
0x8b8e,0x8b8f,0x8b90,0x8b91,0x8b92,0x8b93,0x8b94,0x8b95,
0x8b96,0x8b97,0x8b98,0x8b99,0x8b9a,0x8b9b,0x8b9c,0x8b9d,
0x8b9e,0x8b9f,0x8ba0,0x8ba1,0x8ba2,0x8ba3,0x8ba4,0x8ba5,
0x8ba6,0x8ba7,0x8ba8,0x8ba9,0x8baa,0x8bab,0x8bac,0x8bad,
0x8bae,0x8baf,0x8bb0,0x8bb1,0x8bb2,0x8bb3,0x8bb4,0x8bb5,
0xb6b0,0xb6b1,0x8bb6,0x8bb7,0xb6b2,0x8bb8,0x8bb9,0x8bba,
0xb6b3,0x8bbb,0xb6b4,0xb6b5,0x8bbc,0x8bbd,0x8bbe,0x8bbf,
0xb6b6,0xb6b7,0x8bc0,0xb6b8,0xb6b9,0xb6ba,0x8bc1,0x8bc2,
0x8bc3,0x8bc4,0x8bc5,0xb6bb,0xb6bc,0xb6bd,0x8bc6,0x8bc7,
0xb6be,0x8bc8,0x8bc9,0x8bca,0xb6bf,0x8bcb,0x8bcc,0x8bcd,
0x8bce,0x8bcf,0x8bd0,0x8bd1,0xb6c0,0xb6c1,0x8bd2,0xb6c2,
0xb6c3,0xb6c4,0x8bd3,0x8bd4,0x8bd5,0x8bd6,0x8bd7,0x8bd8,
0xb6c5,0x8bd9,0x8bda,0x8bdb,0x8bdc,0x8bdd,0x8bde,0x8bdf,
0x8be0,0x8be1,0x8be2,0x8be3,0x8be4,0x8be5,0x8be6,0x8be7,
0x8be8,0x8be9,0x8bea,0x8beb,0xb6c6,0x8bec,0x8bed,0x8bee,
0x8bef,0x8bf0,0x8bf1,0x8bf2,0x8bf3,0x8bf4,0x8bf5,0x8bf6,
0x8bf7,0x8bf8,0x8bf9,0x8bfa,0x8bfb,0x8bfc,0x8bfd,0x8bfe,
/* 0xb600 */
0x8c41,0x8c42,0x8c43,0x8c44,0x8c45,0x8c46,0x8c47,0x8c48,
0x8c49,0x8c4a,0x8c4b,0x8c4c,0x8c4d,0x8c4e,0x8c4f,0x8c50,
0xb6c7,0xb6c8,0x8c51,0x8c52,0xb6c9,0x8c53,0x8c54,0x8c55,
0xb6ca,0x8c56,0x8c57,0x8c58,0x8c59,0x8c5a,0x8c61,0x8c62,
0x8c63,0x8c64,0x8c65,0x8c66,0x8c67,0xb6cb,0x8c68,0x8c69,
0x8c6a,0x8c6b,0x8c6c,0x8c6d,0xb6cc,0x8c6e,0x8c6f,0x8c70,
0x8c71,0x8c72,0x8c73,0x8c74,0xb6cd,0x8c75,0x8c76,0x8c77,
0x8c78,0x8c79,0x8c7a,0x8c81,0x8c82,0x8c83,0x8c84,0x8c85,
0x8c86,0x8c87,0x8c88,0x8c89,0x8c8a,0x8c8b,0x8c8c,0x8c8d,
0xb6ce,0x8c8e,0x8c8f,0x8c90,0x8c91,0x8c92,0x8c93,0x8c94,
0x8c95,0x8c96,0x8c97,0x8c98,0x8c99,0x8c9a,0x8c9b,0x8c9c,
0x8c9d,0x8c9e,0x8c9f,0x8ca0,0x8ca1,0x8ca2,0x8ca3,0x8ca4,
0x8ca5,0x8ca6,0x8ca7,0x8ca8,0xb6cf,0x8ca9,0x8caa,0x8cab,
0xb6d0,0x8cac,0x8cad,0x8cae,0x8caf,0x8cb0,0x8cb1,0x8cb2,
0x8cb3,0x8cb4,0x8cb5,0x8cb6,0x8cb7,0x8cb8,0x8cb9,0x8cba,
0x8cbb,0x8cbc,0x8cbd,0x8cbe,0x8cbf,0x8cc0,0x8cc1,0x8cc2,
0x8cc3,0x8cc4,0x8cc5,0x8cc6,0x8cc7,0x8cc8,0x8cc9,0x8cca,
0x8ccb,0x8ccc,0x8ccd,0x8cce,0x8ccf,0x8cd0,0x8cd1,0x8cd2,
0x8cd3,0x8cd4,0x8cd5,0x8cd6,0x8cd7,0x8cd8,0x8cd9,0x8cda,
0x8cdb,0x8cdc,0x8cdd,0x8cde,0xb6d1,0xb6d2,0x8cdf,0x8ce0,
0xb6d3,0x8ce1,0x8ce2,0x8ce3,0xb6d4,0x8ce4,0x8ce5,0x8ce6,
0x8ce7,0x8ce8,0x8ce9,0xb6d5,0xb6d6,0x8cea,0x8ceb,0x8cec,
0x8ced,0xb6d7,0x8cee,0x8cef,0x8cf0,0x8cf1,0x8cf2,0x8cf3,
0x8cf4,0x8cf5,0x8cf6,0x8cf7,0x8cf8,0x8cf9,0x8cfa,0x8cfb,
0x8cfc,0x8cfd,0x8cfe,0x8d41,0x8d42,0x8d43,0x8d44,0x8d45,
0x8d46,0x8d47,0x8d48,0x8d49,0x8d4a,0x8d4b,0x8d4c,0x8d4d,
0x8d4e,0x8d4f,0x8d50,0x8d51,0xb6d8,0x8d52,0x8d53,0x8d54,
0x8d55,0x8d56,0x8d57,0x8d58,0x8d59,0x8d5a,0x8d61,0x8d62,
0x8d63,0x8d64,0x8d65,0x8d66,0x8d67,0x8d68,0x8d69,0x8d6a,
0x8d6b,0x8d6c,0x8d6d,0x8d6e,0x8d6f,0x8d70,0x8d71,0x8d72,
0xb6d9,0x8d73,0x8d74,0x8d75,0xb6da,0x8d76,0x8d77,0x8d78,
0xb6db,0x8d79,0x8d7a,0x8d81,0x8d82,0x8d83,0x8d84,0x8d85,
/* 0xb700 */
0xb6dc,0xb6dd,0x8d86,0x8d87,0x8d88,0xb6de,0x8d89,0x8d8a,
0x8d8b,0x8d8c,0x8d8d,0x8d8e,0x8d8f,0x8d90,0x8d91,0x8d92,
0x8d93,0x8d94,0x8d95,0x8d96,0x8d97,0x8d98,0x8d99,0x8d9a,
0x8d9b,0x8d9c,0x8d9d,0x8d9e,0x8d9f,0x8da0,0x8da1,0x8da2,
0x8da3,0x8da4,0x8da5,0x8da6,0x8da7,0x8da8,0x8da9,0x8daa,
0xb6df,0xb6e0,0x8dab,0x8dac,0xb6e1,0x8dad,0x8dae,0xb6e2,
0xb6e3,0x8daf,0x8db0,0x8db1,0x8db2,0x8db3,0x8db4,0x8db5,
0xb6e4,0xb6e5,0x8db6,0xb6e6,0x8db7,0x8db8,0x8db9,0x8dba,
0x8dbb,0x8dbc,0x8dbd,0x8dbe,0xb6e7,0x8dbf,0x8dc0,0x8dc1,
0xb6e8,0x8dc2,0x8dc3,0x8dc4,0xb6e9,0x8dc5,0x8dc6,0x8dc7,
0x8dc8,0x8dc9,0x8dca,0x8dcb,0xb6ea,0xb6eb,0x8dcc,0x8dcd,
0x8dce,0x8dcf,0x8dd0,0x8dd1,0x8dd2,0x8dd3,0x8dd4,0x8dd5,
0xb6ec,0x8dd6,0x8dd7,0x8dd8,0xb6ed,0x8dd9,0x8dda,0x8ddb,
0xb6ee,0x8ddc,0x8ddd,0x8dde,0x8ddf,0x8de0,0x8de1,0x8de2,
0xb6ef,0xb6f0,0x8de3,0xb6f1,0x8de4,0xb6f2,0x8de5,0x8de6,
0x8de7,0x8de8,0x8de9,0x8dea,0xb6f3,0xb6f4,0x8deb,0x8dec,
0xb6f5,0x8ded,0x8dee,0x8def,0xb6f6,0x8df0,0x8df1,0x8df2,
0x8df3,0x8df4,0x8df5,0x8df6,0xb6f7,0xb6f8,0x8df7,0xb6f9,
0xb6fa,0xb6fb,0xb6fc,0x8df8,0x8df9,0x8dfa,0xb6fd,0xb6fe,
0xb7a1,0xb7a2,0x8dfb,0x8dfc,0xb7a3,0x8dfd,0x8dfe,0x8e41,
0xb7a4,0x8e42,0x8e43,0x8e44,0x8e45,0x8e46,0x8e47,0x8e48,
0xb7a5,0xb7a6,0x8e49,0xb7a7,0xb7a8,0xb7a9,0x8e4a,0x8e4b,
0x8e4c,0x8e4d,0x8e4e,0x8e4f,0xb7aa,0xb7ab,0x8e50,0x8e51,
0xb7ac,0x8e52,0x8e53,0x8e54,0x8e55,0x8e56,0x8e57,0x8e58,
0x8e59,0x8e5a,0x8e61,0x8e62,0x8e63,0x8e64,0x8e65,0xb7ad,
0x8e66,0xb7ae,0x8e67,0x8e68,0x8e69,0x8e6a,0x8e6b,0x8e6c,
0x8e6d,0x8e6e,0x8e6f,0x8e70,0x8e71,0x8e72,0x8e73,0x8e74,
0x8e75,0x8e76,0x8e77,0x8e78,0x8e79,0x8e7a,0x8e81,0x8e82,
0x8e83,0x8e84,0x8e85,0x8e86,0x8e87,0x8e88,0x8e89,0x8e8a,
0x8e8b,0x8e8c,0x8e8d,0x8e8e,0xb7af,0xb7b0,0x8e8f,0x8e90,
0xb7b1,0x8e91,0x8e92,0x8e93,0xb7b2,0x8e94,0x8e95,0x8e96,
0x8e97,0x8e98,0x8e99,0x8e9a,0xb7b3,0xb7b4,0x8e9b,0xb7b5,
/* 0xb800 */
0xb7b6,0xb7b7,0x8e9c,0x8e9d,0x8e9e,0x8e9f,0x8ea0,0xb7b8,
0xb7b9,0xb7ba,0x8ea1,0x8ea2,0xb7bb,0x8ea3,0x8ea4,0x8ea5,
0xb7bc,0x8ea6,0x8ea7,0x8ea8,0x8ea9,0x8eaa,0x8eab,0x8eac,
0xb7bd,0xb7be,0x8ead,0xb7bf,0x8eae,0xb7c0,0x8eaf,0x8eb0,
0x8eb1,0x8eb2,0x8eb3,0x8eb4,0xb7c1,0xb7c2,0x8eb5,0x8eb6,
0xb7c3,0x8eb7,0x8eb8,0x8eb9,0xb7c4,0x8eba,0x8ebb,0x8ebc,
0x8ebd,0x8ebe,0x8ebf,0x8ec0,0xb7c5,0xb7c6,0x8ec1,0xb7c7,
0xb7c8,0xb7c9,0x8ec2,0x8ec3,0x8ec4,0x8ec5,0x8ec6,0x8ec7,
0xb7ca,0x8ec8,0x8ec9,0x8eca,0xb7cb,0x8ecb,0x8ecc,0x8ecd,
0x8ece,0x8ecf,0x8ed0,0x8ed1,0x8ed2,0x8ed3,0x8ed4,0x8ed5,
0x8ed6,0xb7cc,0x8ed7,0xb7cd,0x8ed8,0x8ed9,0x8eda,0x8edb,
0x8edc,0x8edd,0x8ede,0x8edf,0xb7ce,0xb7cf,0x8ee0,0x8ee1,
0xb7d0,0x8ee2,0x8ee3,0x8ee4,0xb7d1,0x8ee5,0x8ee6,0x8ee7,
0x8ee8,0x8ee9,0x8eea,0x8eeb,0xb7d2,0xb7d3,0x8eec,0xb7d4,
0x8eed,0xb7d5,0x8eee,0x8eef,0x8ef0,0x8ef1,0x8ef2,0x8ef3,
0xb7d6,0x8ef4,0x8ef5,0x8ef6,0xb7d7,0x8ef7,0x8ef8,0x8ef9,
0x8efa,0x8efb,0x8efc,0x8efd,0x8efe,0x8f41,0x8f42,0x8f43,
0x8f44,0x8f45,0x8f46,0x8f47,0x8f48,0xb7d8,0x8f49,0x8f4a,
0x8f4b,0x8f4c,0x8f4d,0x8f4e,0x8f4f,0x8f50,0x8f51,0x8f52,
0x8f53,0x8f54,0x8f55,0x8f56,0x8f57,0x8f58,0x8f59,0x8f5a,
0x8f61,0x8f62,0x8f63,0x8f64,0x8f65,0x8f66,0x8f67,0x8f68,
0xb7d9,0x8f69,0x8f6a,0x8f6b,0x8f6c,0x8f6d,0x8f6e,0x8f6f,
0xb7da,0x8f70,0x8f71,0x8f72,0xb7db,0x8f73,0x8f74,0x8f75,
0xb7dc,0x8f76,0x8f77,0x8f78,0x8f79,0x8f7a,0x8f81,0x8f82,
0xb7dd,0xb7de,0x8f83,0xb7df,0x8f84,0xb7e0,0x8f85,0x8f86,
0x8f87,0x8f88,0x8f89,0x8f8a,0xb7e1,0x8f8b,0x8f8c,0x8f8d,
0xb7e2,0x8f8e,0x8f8f,0x8f90,0xb7e3,0x8f91,0x8f92,0x8f93,
0x8f94,0x8f95,0x8f96,0x8f97,0x8f98,0xb7e4,0x8f99,0xb7e5,
0x8f9a,0xb7e6,0x8f9b,0x8f9c,0x8f9d,0x8f9e,0x8f9f,0x8fa0,
0xb7e7,0xb7e8,0x8fa1,0x8fa2,0xb7e9,0x8fa3,0x8fa4,0x8fa5,
0xb7ea,0x8fa6,0x8fa7,0x8fa8,0x8fa9,0x8faa,0x8fab,0x8fac,
0xb7eb,0xb7ec,0x8fad,0xb7ed,0x8fae,0xb7ee,0x8faf,0x8fb0,
/* 0xb900 */
0x8fb1,0x8fb2,0x8fb3,0x8fb4,0xb7ef,0x8fb5,0x8fb6,0x8fb7,
0x8fb8,0x8fb9,0x8fba,0x8fbb,0x8fbc,0x8fbd,0x8fbe,0x8fbf,
0x8fc0,0x8fc1,0x8fc2,0x8fc3,0x8fc4,0x8fc5,0x8fc6,0x8fc7,
0xb7f0,0x8fc8,0x8fc9,0x8fca,0x8fcb,0x8fcc,0x8fcd,0x8fce,
0xb7f1,0x8fcf,0x8fd0,0x8fd1,0x8fd2,0x8fd3,0x8fd4,0x8fd5,
0x8fd6,0x8fd7,0x8fd8,0x8fd9,0x8fda,0x8fdb,0x8fdc,0x8fdd,
0x8fde,0x8fdf,0x8fe0,0x8fe1,0x8fe2,0x8fe3,0x8fe4,0x8fe5,
0x8fe6,0x8fe7,0x8fe8,0x8fe9,0xb7f2,0xb7f3,0x8fea,0x8feb,
0xb7f4,0x8fec,0x8fed,0x8fee,0xb7f5,0x8fef,0x8ff0,0x8ff1,
0x8ff2,0x8ff3,0x8ff4,0x8ff5,0xb7f6,0x8ff6,0x8ff7,0xb7f7,
0x8ff8,0xb7f8,0x8ff9,0x8ffa,0x8ffb,0x8ffc,0x8ffd,0x8ffe,
0xb7f9,0xb7fa,0x9041,0x9042,0xb7fb,0x9043,0x9044,0x9045,
0xb7fc,0x9046,0x9047,0x9048,0x9049,0x904a,0x904b,0x904c,
0xb7fd,0xb7fe,0x904d,0xb8a1,0x904e,0xb8a2,0x904f,0x9050,
0x9051,0x9052,0x9053,0x9054,0xb8a3,0xb8a4,0x9055,0x9056,
0xb8a5,0x9057,0x9058,0x9059,0xb8a6,0x905a,0x9061,0x9062,
0x9063,0x9064,0x9065,0x9066,0xb8a7,0xb8a8,0x9067,0xb8a9,
0x9068,0xb8aa,0xb8ab,0x9069,0x906a,0xb8ac,0xb8ad,0x906b,
0x906c,0x906d,0x906e,0x906f,0x9070,0x9071,0x9072,0x9073,
0x9074,0x9075,0x9076,0x9077,0x9078,0x9079,0x907a,0x9081,
0x9082,0x9083,0x9084,0x9085,0x9086,0x9087,0x9088,0x9089,
0x908a,0x908b,0x908c,0x908d,0xb8ae,0xb8af,0x908e,0x908f,
0xb8b0,0x9090,0x9091,0x9092,0xb8b1,0x9093,0x9094,0x9095,
0x9096,0x9097,0x9098,0x9099,0xb8b2,0xb8b3,0x909a,0xb8b4,
0x909b,0xb8b5,0x909c,0x909d,0x909e,0x909f,0x90a0,0x90a1,
0xb8b6,0xb8b7,0x90a2,0x90a3,0xb8b8,0x90a4,0xb8b9,0xb8ba,
0xb8bb,0xb8bc,0xb8bd,0x90a5,0x90a6,0x90a7,0x90a8,0x90a9,
0xb8be,0xb8bf,0x90aa,0xb8c0,0x90ab,0xb8c1,0xb8c2,0x90ac,
0x90ad,0xb8c3,0x90ae,0xb8c4,0xb8c5,0xb8c6,0x90af,0x90b0,
0xb8c7,0x90b1,0x90b2,0x90b3,0xb8c8,0x90b4,0x90b5,0x90b6,
0x90b7,0x90b8,0x90b9,0x90ba,0xb8c9,0xb8ca,0x90bb,0xb8cb,
0xb8cc,0xb8cd,0xb8ce,0x90bc,0x90bd,0x90be,0x90bf,0x90c0,
/* 0xba00 */
0xb8cf,0xb8d0,0x90c1,0x90c2,0x90c3,0x90c4,0x90c5,0x90c6,
0xb8d1,0x90c7,0x90c8,0x90c9,0x90ca,0x90cb,0x90cc,0x90cd,
0x90ce,0x90cf,0x90d0,0x90d1,0x90d2,0xb8d2,0x90d3,0x90d4,
0x90d5,0x90d6,0x90d7,0x90d8,0x90d9,0x90da,0x90db,0x90dc,
0x90dd,0x90de,0x90df,0x90e0,0x90e1,0x90e2,0x90e3,0x90e4,
0x90e5,0x90e6,0x90e7,0x90e8,0x90e9,0x90ea,0x90eb,0x90ec,
0x90ed,0x90ee,0x90ef,0x90f0,0x90f1,0x90f2,0x90f3,0x90f4,
0xb8d3,0xb8d4,0x90f5,0x90f6,0xb8d5,0x90f7,0x90f8,0x90f9,
0xb8d6,0x90fa,0xb8d7,0x90fb,0x90fc,0x90fd,0x90fe,0x9141,
0xb8d8,0xb8d9,0x9142,0xb8da,0x9143,0xb8db,0xb8dc,0x9144,
0x9145,0x9146,0x9147,0xb8dd,0xb8de,0xb8df,0x9148,0x9149,
0xb8e0,0x914a,0x914b,0x914c,0xb8e1,0x914d,0x914e,0x914f,
0x9150,0x9151,0x9152,0x9153,0xb8e2,0xb8e3,0x9154,0xb8e4,
0xb8e5,0xb8e6,0x9155,0x9156,0x9157,0x9158,0x9159,0x915a,
0xb8e7,0xb8e8,0x9161,0x9162,0xb8e9,0x9163,0x9164,0x9165,
0xb8ea,0x9166,0x9167,0x9168,0x9169,0x916a,0x916b,0x916c,
0x916d,0x916e,0x916f,0xb8eb,0xb8ec,0xb8ed,0x9170,0xb8ee,
0x9171,0x9172,0x9173,0x9174,0xb8ef,0x9175,0x9176,0x9177,
0x9178,0x9179,0x917a,0x9181,0x9182,0x9183,0x9184,0x9185,
0x9186,0x9187,0x9188,0x9189,0x918a,0x918b,0x918c,0x918d,
0x918e,0x918f,0x9190,0x9191,0x9192,0x9193,0x9194,0x9195,
0xb8f0,0xb8f1,0x9196,0xb8f2,0xb8f3,0x9197,0x9198,0x9199,
0xb8f4,0x919a,0xb8f5,0x919b,0x919c,0x919d,0x919e,0x919f,
0xb8f6,0xb8f7,0x91a0,0xb8f8,0x91a1,0xb8f9,0x91a2,0x91a3,
0x91a4,0x91a5,0x91a6,0x91a7,0xb8fa,0x91a8,0x91a9,0x91aa,
0xb8fb,0x91ab,0x91ac,0x91ad,0x91ae,0x91af,0x91b0,0x91b1,
0x91b2,0x91b3,0x91b4,0x91b5,0x91b6,0x91b7,0x91b8,0x91b9,
0xb8fc,0xb8fd,0x91ba,0x91bb,0x91bc,0x91bd,0x91be,0x91bf,
0x91c0,0x91c1,0x91c2,0x91c3,0x91c4,0x91c5,0x91c6,0x91c7,
0x91c8,0x91c9,0x91ca,0x91cb,0x91cc,0x91cd,0x91ce,0x91cf,
0x91d0,0x91d1,0x91d2,0x91d3,0x91d4,0x91d5,0x91d6,0x91d7,
0x91d8,0x91d9,0x91da,0x91db,0xb8fe,0x91dc,0x91dd,0x91de,
/* 0xbb00 */
0xb9a1,0x91df,0x91e0,0x91e1,0xb9a2,0x91e2,0x91e3,0x91e4,
0x91e5,0x91e6,0x91e7,0x91e8,0x91e9,0xb9a3,0x91ea,0xb9a4,
0x91eb,0xb9a5,0x91ec,0x91ed,0x91ee,0x91ef,0x91f0,0x91f1,
0xb9a6,0x91f2,0x91f3,0x91f4,0xb9a7,0x91f5,0x91f6,0x91f7,
0xb9a8,0x91f8,0x91f9,0x91fa,0x91fb,0x91fc,0x91fd,0x91fe,
0x9241,0xb9a9,0x9242,0xb9aa,0x9243,0x9244,0x9245,0x9246,
0x9247,0x9248,0x9249,0x924a,0xb9ab,0xb9ac,0xb9ad,0x924b,
0xb9ae,0x924c,0x924d,0xb9af,0xb9b0,0xb9b1,0xb9b2,0x924e,
0x924f,0x9250,0x9251,0x9252,0xb9b3,0xb9b4,0x9253,0xb9b5,
0x9254,0xb9b6,0x9255,0x9256,0x9257,0xb9b7,0x9258,0xb9b8,
0xb9b9,0x9259,0x925a,0x9261,0xb9ba,0x9262,0x9263,0x9264,
0xb9bb,0x9265,0x9266,0x9267,0x9268,0x9269,0x926a,0x926b,
0x926c,0xb9bc,0x926d,0xb9bd,0x926e,0x926f,0x9270,0x9271,
0x9272,0x9273,0x9274,0x9275,0xb9be,0x9276,0x9277,0x9278,
0x9279,0x927a,0x9281,0x9282,0x9283,0x9284,0x9285,0x9286,
0x9287,0x9288,0x9289,0x928a,0x928b,0x928c,0x928d,0x928e,
0x928f,0x9290,0x9291,0x9292,0x9293,0x9294,0x9295,0x9296,
0xb9bf,0x9297,0x9298,0x9299,0xb9c0,0x929a,0x929b,0x929c,
0xb9c1,0x929d,0x929e,0x929f,0x92a0,0x92a1,0x92a2,0x92a3,
0x92a4,0x92a5,0x92a6,0x92a7,0x92a8,0x92a9,0x92aa,0x92ab,
0x92ac,0x92ad,0x92ae,0x92af,0xb9c2,0x92b0,0x92b1,0x92b2,
0xb9c3,0x92b3,0x92b4,0x92b5,0xb9c4,0x92b6,0x92b7,0x92b8,
0x92b9,0x92ba,0x92bb,0x92bc,0xb9c5,0x92bd,0x92be,0xb9c6,
0x92bf,0x92c0,0x92c1,0x92c2,0x92c3,0x92c4,0x92c5,0x92c6,
0xb9c7,0x92c7,0x92c8,0x92c9,0xb9c8,0x92ca,0x92cb,0x92cc,
0xb9c9,0x92cd,0x92ce,0x92cf,0x92d0,0x92d1,0x92d2,0x92d3,
0xb9ca,0x92d4,0x92d5,0xb9cb,0x92d6,0x92d7,0x92d8,0x92d9,
0x92da,0x92db,0x92dc,0x92dd,0x92de,0x92df,0x92e0,0x92e1,
0x92e2,0x92e3,0x92e4,0x92e5,0x92e6,0x92e7,0x92e8,0x92e9,
0x92ea,0x92eb,0x92ec,0x92ed,0x92ee,0x92ef,0x92f0,0x92f1,
0x92f2,0x92f3,0x92f4,0x92f5,0x92f6,0x92f7,0x92f8,0x92f9,
0xb9cc,0xb9cd,0x92fa,0x92fb,0xb9ce,0x92fc,0x92fd,0xb9cf,
/* 0xbc00 */
0xb9d0,0x92fe,0xb9d1,0x9341,0x9342,0x9343,0x9344,0x9345,
0xb9d2,0xb9d3,0x9346,0xb9d4,0xb9d5,0xb9d6,0x9347,0xb9d7,
0x9348,0xb9d8,0x9349,0x934a,0xb9d9,0xb9da,0xb9db,0xb9dc,
0xb9dd,0x934b,0x934c,0xb9de,0xb9df,0xb9e0,0xb9e1,0xb9e2,
0x934d,0x934e,0x934f,0x9350,0xb9e3,0xb9e4,0x9351,0xb9e5,
0x9352,0xb9e6,0x9353,0x9354,0x9355,0xb9e7,0x9356,0x9357,
0xb9e8,0xb9e9,0x9358,0x9359,0xb9ea,0x935a,0x9361,0x9362,
0xb9eb,0x9363,0x9364,0x9365,0x9366,0x9367,0x9368,0x9369,
0xb9ec,0xb9ed,0x936a,0xb9ee,0xb9ef,0xb9f0,0x936b,0x936c,
0x936d,0xb9f1,0x936e,0x936f,0xb9f2,0xb9f3,0x9370,0x9371,
0xb9f4,0x9372,0x9373,0x9374,0x9375,0x9376,0x9377,0x9378,
0x9379,0x937a,0x9381,0x9382,0x9383,0xb9f5,0x9384,0x9385,
0x9386,0x9387,0x9388,0x9389,0x938a,0x938b,0x938c,0x938d,
0x938e,0x938f,0x9390,0x9391,0x9392,0x9393,0x9394,0x9395,
0x9396,0x9397,0x9398,0x9399,0x939a,0x939b,0x939c,0x939d,
0x939e,0x939f,0x93a0,0x93a1,0x93a2,0x93a3,0x93a4,0x93a5,
0x93a6,0x93a7,0x93a8,0x93a9,0xb9f6,0xb9f7,0x93aa,0x93ab,
0xb9f8,0x93ac,0x93ad,0xb9f9,0xb9fa,0x93ae,0xb9fb,0x93af,
0x93b0,0x93b1,0x93b2,0x93b3,0xb9fc,0xb9fd,0x93b4,0xb9fe,
0x93b5,0xbaa1,0xbaa2,0x93b6,0x93b7,0x93b8,0x93b9,0x93ba,
0xbaa3,0xbaa4,0x93bb,0x93bc,0xbaa5,0x93bd,0x93be,0xbaa6,
0xbaa7,0x93bf,0x93c0,0x93c1,0x93c2,0x93c3,0x93c4,0x93c5,
0xbaa8,0xbaa9,0x93c6,0xbaaa,0xbaab,0xbaac,0x93c7,0x93c8,
0x93c9,0x93ca,0x93cb,0x93cc,0xbaad,0xbaae,0x93cd,0x93ce,
0xbaaf,0x93cf,0x93d0,0x93d1,0xbab0,0x93d2,0x93d3,0x93d4,
0x93d5,0x93d6,0x93d7,0x93d8,0x93d9,0xbab1,0x93da,0xbab2,
0xbab3,0xbab4,0x93db,0x93dc,0x93dd,0xbab5,0x93de,0x93df,
0xbab6,0x93e0,0x93e1,0x93e2,0xbab7,0x93e3,0x93e4,0x93e5,
0x93e6,0x93e7,0x93e8,0x93e9,0x93ea,0x93eb,0x93ec,0x93ed,
0x93ee,0x93ef,0x93f0,0x93f1,0x93f2,0x93f3,0x93f4,0x93f5,
0x93f6,0x93f7,0x93f8,0x93f9,0xbab8,0xbab9,0xbaba,0x93fa,
0xbabb,0x93fb,0x93fc,0x93fd,0xbabc,0x93fe,0x9441,0x9442,
/* 0xbd00 */
0x9443,0x9444,0x9445,0x9446,0xbabd,0xbabe,0x9447,0xbabf,
0x9448,0xbac0,0x9449,0x944a,0x944b,0x944c,0x944d,0x944e,
0xbac1,0x944f,0x9450,0x9451,0xbac2,0x9452,0x9453,0x9454,
0x9455,0x9456,0x9457,0x9458,0x9459,0x945a,0x9461,0x9462,
0x9463,0x9464,0x9465,0x9466,0xbac3,0x9467,0x9468,0x9469,
0x946a,0x946b,0x946c,0x946d,0xbac4,0x946e,0x946f,0x9470,
0x9471,0x9472,0x9473,0x9474,0x9475,0x9476,0x9477,0x9478,
0x9479,0x947a,0x9481,0x9482,0x9483,0x9484,0x9485,0x9486,
0xbac5,0x9487,0x9488,0x9489,0x948a,0x948b,0x948c,0x948d,
0xbac6,0xbac7,0x948e,0x948f,0xbac8,0x9490,0x9491,0x9492,
0xbac9,0x9493,0x9494,0x9495,0x9496,0x9497,0x9498,0x9499,
0xbaca,0xbacb,0x949a,0x949b,0x949c,0x949d,0x949e,0x949f,
0x94a0,0x94a1,0x94a2,0x94a3,0xbacc,0x94a4,0x94a5,0x94a6,
0xbacd,0x94a7,0x94a8,0x94a9,0x94aa,0x94ab,0x94ac,0x94ad,
0x94ae,0x94af,0x94b0,0x94b1,0x94b2,0x94b3,0x94b4,0x94b5,
0x94b6,0x94b7,0x94b8,0x94b9,0x94ba,0x94bb,0x94bc,0x94bd,
0xbace,0xbacf,0x94be,0x94bf,0xbad0,0x94c0,0x94c1,0xbad1,
0xbad2,0xbad3,0xbad4,0x94c2,0x94c3,0x94c4,0x94c5,0x94c6,
0xbad5,0xbad6,0x94c7,0xbad7,0x94c8,0xbad8,0x94c9,0x94ca,
0x94cb,0xbad9,0xbada,0x94cc,0xbadb,0x94cd,0x94ce,0x94cf,
0x94d0,0x94d1,0x94d2,0x94d3,0xbadc,0x94d4,0x94d5,0x94d6,
0x94d7,0x94d8,0x94d9,0x94da,0x94db,0x94dc,0x94dd,0x94de,
0xbadd,0x94df,0x94e0,0x94e1,0x94e2,0x94e3,0x94e4,0x94e5,
0xbade,0x94e6,0x94e7,0x94e8,0x94e9,0x94ea,0x94eb,0x94ec,
0x94ed,0x94ee,0x94ef,0x94f0,0x94f1,0x94f2,0x94f3,0x94f4,
0x94f5,0x94f6,0x94f7,0x94f8,0x94f9,0x94fa,0x94fb,0x94fc,
0x94fd,0x94fe,0x9541,0x9542,0xbadf,0xbae0,0x9543,0x9544,
0xbae1,0x9545,0x9546,0x9547,0xbae2,0x9548,0x9549,0x954a,
0x954b,0x954c,0x954d,0x954e,0x954f,0x9550,0x9551,0x9552,
0x9553,0xbae3,0x9554,0x9555,0x9556,0x9557,0x9558,0x9559,
0xbae4,0x955a,0x9561,0x9562,0xbae5,0x9563,0x9564,0x9565,
0xbae6,0x9566,0x9567,0x9568,0x9569,0x956a,0x956b,0x956c,
/* 0xbe00 */
0xbae7,0x956d,0x956e,0xbae8,0x956f,0xbae9,0x9570,0x9571,
0x9572,0x9573,0x9574,0x9575,0xbaea,0xbaeb,0x9576,0x9577,
0xbaec,0x9578,0x9579,0x957a,0xbaed,0x9581,0x9582,0x9583,
0x9584,0x9585,0x9586,0x9587,0xbaee,0xbaef,0x9588,0xbaf0,
0x9589,0x958a,0x958b,0x958c,0x958d,0x958e,0x958f,0x9590,
0x9591,0x9592,0x9593,0x9594,0x9595,0x9596,0x9597,0x9598,
0x9599,0x959a,0x959b,0x959c,0x959d,0x959e,0x959f,0x95a0,
0x95a1,0x95a2,0x95a3,0x95a4,0x95a5,0x95a6,0x95a7,0x95a8,
0x95a9,0x95aa,0x95ab,0x95ac,0xbaf1,0xbaf2,0x95ad,0x95ae,
0xbaf3,0x95af,0x95b0,0x95b1,0xbaf4,0x95b2,0xbaf5,0x95b3,
0x95b4,0x95b5,0x95b6,0x95b7,0xbaf6,0xbaf7,0x95b8,0xbaf8,
0x95b9,0xbaf9,0xbafa,0xbafb,0x95ba,0x95bb,0x95bc,0x95bd,
0xbafc,0xbafd,0x95be,0x95bf,0xbafe,0x95c0,0x95c1,0x95c2,
0xbba1,0x95c3,0xbba2,0x95c4,0x95c5,0x95c6,0x95c7,0x95c8,
0xbba3,0xbba4,0x95c9,0xbba5,0xbba6,0xbba7,0x95ca,0x95cb,
0x95cc,0x95cd,0x95ce,0xbba8,0xbba9,0xbbaa,0x95cf,0x95d0,
0xbbab,0x95d1,0x95d2,0x95d3,0xbbac,0x95d4,0x95d5,0x95d6,
0x95d7,0x95d8,0x95d9,0x95da,0xbbad,0xbbae,0x95db,0xbbaf,
0xbbb0,0xbbb1,0x95dc,0x95dd,0x95de,0x95df,0x95e0,0x95e1,
0xbbb2,0xbbb3,0x95e2,0x95e3,0x95e4,0x95e5,0x95e6,0x95e7,
0x95e8,0x95e9,0x95ea,0x95eb,0x95ec,0x95ed,0x95ee,0x95ef,
0xbbb4,0x95f0,0x95f1,0x95f2,0x95f3,0x95f4,0x95f5,0x95f6,
0x95f7,0x95f8,0x95f9,0x95fa,0x95fb,0x95fc,0x95fd,0x95fe,
0x9641,0x9642,0x9643,0x9644,0x9645,0x9646,0x9647,0x9648,
0x9649,0x964a,0x964b,0x964c,0x964d,0x964e,0x964f,0x9650,
0x9651,0x9652,0x9653,0x9654,0x9655,0x9656,0x9657,0x9658,
0xbbb5,0xbbb6,0x9659,0x965a,0xbbb7,0x9661,0x9662,0xbbb8,
0xbbb9,0x9663,0x9664,0x9665,0x9666,0x9667,0x9668,0x9669,
0xbbba,0x966a,0x966b,0xbbbb,0xbbbc,0xbbbd,0x966c,0x966d,
0x966e,0x966f,0x9670,0x9671,0xbbbe,0x9672,0x9673,0x9674,
0x9675,0x9676,0x9677,0x9678,0x9679,0x967a,0x9681,0x9682,
0x9683,0x9684,0x9685,0x9686,0x9687,0x9688,0x9689,0x968a,
/* 0xbf00 */
0x968b,0xbbbf,0x968c,0x968d,0x968e,0x968f,0x9690,0x9691,
0xbbc0,0xbbc1,0x9692,0x9693,0x9694,0x9695,0x9696,0x9697,
0x9698,0x9699,0x969a,0x969b,0x969c,0x969d,0x969e,0x969f,
0xbbc2,0xbbc3,0x96a0,0xbbc4,0xbbc5,0xbbc6,0x96a1,0x96a2,
0x96a3,0x96a4,0x96a5,0x96a6,0x96a7,0x96a8,0x96a9,0x96aa,
0x96ab,0x96ac,0x96ad,0x96ae,0x96af,0x96b0,0x96b1,0x96b2,
0x96b3,0x96b4,0x96b5,0x96b6,0x96b7,0x96b8,0x96b9,0x96ba,
0x96bb,0x96bc,0x96bd,0x96be,0x96bf,0x96c0,0x96c1,0x96c2,
0xbbc7,0xbbc8,0x96c3,0x96c4,0xbbc9,0x96c5,0x96c6,0x96c7,
0xbbca,0x96c8,0x96c9,0x96ca,0x96cb,0x96cc,0x96cd,0x96ce,
0xbbcb,0xbbcc,0x96cf,0x96d0,0x96d1,0xbbcd,0x96d2,0x96d3,
0x96d4,0x96d5,0x96d6,0x96d7,0x96d8,0x96d9,0x96da,0x96db,
0x96dc,0x96dd,0x96de,0x96df,0x96e0,0x96e1,0x96e2,0x96e3,
0x96e4,0x96e5,0x96e6,0x96e7,0x96e8,0x96e9,0x96ea,0x96eb,
0x96ec,0x96ed,0x96ee,0x96ef,0x96f0,0x96f1,0x96f2,0x96f3,
0x96f4,0x96f5,0x96f6,0x96f7,0x96f8,0x96f9,0x96fa,0x96fb,
0x96fc,0x96fd,0x96fe,0x9741,0x9742,0x9743,0x9744,0x9745,
0x9746,0x9747,0x9748,0x9749,0x974a,0x974b,0x974c,0x974d,
0x974e,0x974f,0x9750,0x9751,0xbbce,0x9752,0x9753,0x9754,
0x9755,0x9756,0x9757,0x9758,0x9759,0x975a,0x9761,0x9762,
0x9763,0x9764,0x9765,0x9766,0x9767,0x9768,0x9769,0x976a,
0x976b,0x976c,0x976d,0x976e,0x976f,0x9770,0x9771,0x9772,
0xbbcf,0x9773,0x9774,0x9775,0x9776,0x9777,0x9778,0x9779,
0x977a,0x9781,0x9782,0x9783,0x9784,0x9785,0x9786,0x9787,
0x9788,0x9789,0x978a,0x978b,0x978c,0xbbd0,0x978d,0x978e,
0x978f,0x9790,0x9791,0x9792,0xbbd1,0xbbd2,0x9793,0x9794,
0xbbd3,0x9795,0x9796,0x9797,0xbbd4,0x9798,0x9799,0x979a,
0x979b,0x979c,0x979d,0x979e,0xbbd5,0x979f,0x97a0,0xbbd6,
0x97a1,0xbbd7,0x97a2,0x97a3,0x97a4,0x97a5,0x97a6,0x97a7,
0x97a8,0x97a9,0x97aa,0x97ab,0x97ac,0x97ad,0x97ae,0x97af,
0x97b0,0x97b1,0x97b2,0x97b3,0x97b4,0x97b5,0x97b6,0x97b7,
0x97b8,0x97b9,0x97ba,0x97bb,0x97bc,0x97bd,0x97be,0x97bf,
/* 0xc000 */
0x97c0,0x97c1,0x97c2,0x97c3,0x97c4,0x97c5,0x97c6,0x97c7,
0x97c8,0x97c9,0x97ca,0x97cb,0x97cc,0x97cd,0x97ce,0x97cf,
0x97d0,0x97d1,0x97d2,0x97d3,0x97d4,0x97d5,0x97d6,0x97d7,
0x97d8,0x97d9,0x97da,0x97db,0x97dc,0x97dd,0x97de,0x97df,
0x97e0,0x97e1,0x97e2,0x97e3,0x97e4,0x97e5,0x97e6,0x97e7,
0x97e8,0x97e9,0x97ea,0x97eb,0x97ec,0x97ed,0x97ee,0x97ef,
0x97f0,0x97f1,0x97f2,0x97f3,0x97f4,0x97f5,0x97f6,0x97f7,
0x97f8,0x97f9,0x97fa,0x97fb,0xbbd8,0x97fc,0x97fd,0x97fe,
0x9841,0x9842,0x9843,0x9844,0x9845,0x9846,0x9847,0x9848,
0x9849,0x984a,0x984b,0x984c,0x984d,0x984e,0x984f,0x9850,
0x9851,0xbbd9,0x9852,0x9853,0x9854,0x9855,0x9856,0x9857,
0xbbda,0x9858,0x9859,0x985a,0xbbdb,0x9861,0x9862,0x9863,
0xbbdc,0x9864,0x9865,0x9866,0x9867,0x9868,0x9869,0x986a,
0xbbdd,0xbbde,0x986b,0x986c,0x986d,0x986e,0x986f,0x9870,
0x9871,0x9872,0x9873,0x9874,0x9875,0x9876,0x9877,0x9878,
0x9879,0x987a,0x9881,0x9882,0x9883,0x9884,0x9885,0x9886,
0x9887,0x9888,0x9889,0x988a,0x988b,0x988c,0x988d,0x988e,
0x988f,0x9890,0x9891,0x9892,0x9893,0x9894,0x9895,0x9896,
0xbbdf,0xbbe0,0x9897,0x9898,0xbbe1,0x9899,0x989a,0x989b,
0xbbe2,0x989c,0x989d,0x989e,0x989f,0x98a0,0x98a1,0x98a2,
0xbbe3,0xbbe4,0x98a3,0xbbe5,0x98a4,0xbbe6,0x98a5,0x98a6,
0x98a7,0x98a8,0x98a9,0x98aa,0xbbe7,0xbbe8,0x98ab,0xbbe9,
0xbbea,0x98ac,0x98ad,0xbbeb,0xbbec,0xbbed,0xbbee,0x98ae,
0x98af,0x98b0,0x98b1,0x98b2,0xbbef,0xbbf0,0x98b3,0xbbf1,
0xbbf2,0xbbf3,0x98b4,0x98b5,0x98b6,0xbbf4,0x98b7,0x98b8,
0xbbf5,0xbbf6,0x98b9,0x98ba,0xbbf7,0x98bb,0x98bc,0x98bd,
0xbbf8,0x98be,0x98bf,0x98c0,0x98c1,0x98c2,0x98c3,0x98c4,
0xbbf9,0xbbfa,0x98c5,0xbbfb,0xbbfc,0xbbfd,0x98c6,0x98c7,
0x98c8,0x98c9,0x98ca,0x98cb,0xbbfe,0xbca1,0x98cc,0x98cd,
0xbca2,0x98ce,0x98cf,0x98d0,0xbca3,0x98d1,0x98d2,0x98d3,
0x98d4,0x98d5,0x98d6,0x98d7,0xbca4,0xbca5,0x98d8,0xbca6,
0x98d9,0xbca7,0x98da,0x98db,0x98dc,0x98dd,0x98de,0x98df,
/* 0xc100 */
0xbca8,0x98e0,0x98e1,0x98e2,0xbca9,0x98e3,0x98e4,0x98e5,
0xbcaa,0x98e6,0x98e7,0x98e8,0x98e9,0x98ea,0x98eb,0x98ec,
0xbcab,0x98ed,0x98ee,0x98ef,0x98f0,0xbcac,0x98f1,0x98f2,
0x98f3,0x98f4,0x98f5,0x98f6,0xbcad,0xbcae,0xbcaf,0xbcb0,
0xbcb1,0x98f7,0x98f8,0xbcb2,0xbcb3,0x98f9,0xbcb4,0xbcb5,
0x98fa,0x98fb,0x98fc,0x98fd,0xbcb6,0xbcb7,0x98fe,0xbcb8,
0xbcb9,0xbcba,0x9941,0x9942,0x9943,0x9944,0xbcbb,0x9945,
0xbcbc,0xbcbd,0x9946,0x9947,0xbcbe,0x9948,0x9949,0x994a,
0xbcbf,0x994b,0x994c,0x994d,0x994e,0x994f,0x9950,0x9951,
0xbcc0,0xbcc1,0x9952,0xbcc2,0xbcc3,0xbcc4,0x9953,0x9954,
0x9955,0x9956,0x9957,0x9958,0xbcc5,0xbcc6,0x9959,0x995a,
0xbcc7,0x9961,0x9962,0x9963,0xbcc8,0x9964,0x9965,0x9966,
0x9967,0x9968,0x9969,0x996a,0xbcc9,0xbcca,0x996b,0xbccb,
0xbccc,0xbccd,0x996c,0x996d,0x996e,0x996f,0x9970,0x9971,
0xbcce,0x9972,0x9973,0x9974,0xbccf,0x9975,0x9976,0x9977,
0xbcd0,0x9978,0x9979,0x997a,0x9981,0x9982,0x9983,0x9984,
0x9985,0x9986,0x9987,0x9988,0x9989,0xbcd1,0x998a,0x998b,
0x998c,0x998d,0x998e,0x998f,0xbcd2,0xbcd3,0xbcd4,0x9990,
0xbcd5,0x9991,0x9992,0x9993,0xbcd6,0x9994,0xbcd7,0x9995,
0x9996,0x9997,0x9998,0x9999,0xbcd8,0xbcd9,0x999a,0xbcda,
0x999b,0xbcdb,0x999c,0x999d,0x999e,0xbcdc,0x999f,0x99a0,
0xbcdd,0xbcde,0x99a1,0x99a2,0xbcdf,0x99a3,0x99a4,0x99a5,
0xbce0,0x99a6,0x99a7,0x99a8,0x99a9,0x99aa,0x99ab,0x99ac,
0x99ad,0x99ae,0x99af,0x99b0,0x99b1,0xbce1,0x99b2,0x99b3,
0x99b4,0x99b5,0x99b6,0x99b7,0xbce2,0x99b8,0x99b9,0x99ba,
0xbce3,0x99bb,0x99bc,0x99bd,0xbce4,0x99be,0x99bf,0x99c0,
0x99c1,0x99c2,0x99c3,0x99c4,0xbce5,0x99c5,0x99c6,0xbce6,
0xbce7,0x99c7,0x99c8,0x99c9,0x99ca,0x99cb,0x99cc,0x99cd,
0xbce8,0x99ce,0x99cf,0x99d0,0xbce9,0x99d1,0x99d2,0x99d3,
0xbcea,0x99d4,0x99d5,0x99d6,0x99d7,0x99d8,0x99d9,0x99da,
0xbceb,0xbcec,0x99db,0xbced,0x99dc,0x99dd,0x99de,0x99df,
0x99e0,0x99e1,0x99e2,0x99e3,0xbcee,0xbcef,0x99e4,0x99e5,
/* 0xc200 */
0xbcf0,0x99e6,0x99e7,0x99e8,0xbcf1,0x99e9,0x99ea,0x99eb,
0x99ec,0x99ed,0x99ee,0x99ef,0xbcf2,0xbcf3,0x99f0,0xbcf4,
0x99f1,0xbcf5,0x99f2,0x99f3,0x99f4,0x99f5,0x99f6,0x99f7,
0xbcf6,0xbcf7,0x99f8,0x99f9,0xbcf8,0x99fa,0x99fb,0xbcf9,
0xbcfa,0x99fc,0x99fd,0x99fe,0x9a41,0x9a42,0x9a43,0x9a44,
0xbcfb,0xbcfc,0x9a45,0xbcfd,0x9a46,0xbcfe,0x9a47,0xbda1,
0x9a48,0xbda2,0xbda3,0x9a49,0xbda4,0x9a4a,0x9a4b,0x9a4c,
0x9a4d,0x9a4e,0x9a4f,0x9a50,0x9a51,0x9a52,0x9a53,0x9a54,
0x9a55,0x9a56,0x9a57,0x9a58,0x9a59,0x9a5a,0x9a61,0x9a62,
0xbda5,0x9a63,0x9a64,0x9a65,0x9a66,0x9a67,0x9a68,0x9a69,
0xbda6,0xbda7,0x9a6a,0x9a6b,0xbda8,0x9a6c,0x9a6d,0x9a6e,
0xbda9,0x9a6f,0x9a70,0x9a71,0x9a72,0x9a73,0x9a74,0x9a75,
0xbdaa,0x9a76,0x9a77,0x9a78,0x9a79,0xbdab,0x9a7a,0x9a81,
0x9a82,0x9a83,0x9a84,0x9a85,0xbdac,0xbdad,0x9a86,0x9a87,
0xbdae,0x9a88,0x9a89,0x9a8a,0xbdaf,0x9a8b,0x9a8c,0x9a8d,
0x9a8e,0x9a8f,0x9a90,0x9a91,0xbdb0,0xbdb1,0x9a92,0xbdb2,
0x9a93,0xbdb3,0x9a94,0x9a95,0x9a96,0x9a97,0x9a98,0x9a99,
0xbdb4,0xbdb5,0x9a9a,0x9a9b,0x9a9c,0x9a9d,0x9a9e,0x9a9f,
0xbdb6,0x9aa0,0x9aa1,0x9aa2,0x9aa3,0x9aa4,0x9aa5,0x9aa6,
0xbdb7,0x9aa7,0x9aa8,0xbdb8,0x9aa9,0xbdb9,0x9aaa,0x9aab,
0x9aac,0x9aad,0x9aae,0x9aaf,0xbdba,0xbdbb,0x9ab0,0x9ab1,
0xbdbc,0x9ab2,0x9ab3,0x9ab4,0xbdbd,0xbdbe,0x9ab5,0x9ab6,
0x9ab7,0x9ab8,0x9ab9,0x9aba,0xbdbf,0xbdc0,0x9abb,0xbdc1,
0x9abc,0xbdc2,0x9abd,0x9abe,0x9abf,0x9ac0,0x9ac1,0x9ac2,
0x9ac3,0x9ac4,0x9ac5,0x9ac6,0x9ac7,0x9ac8,0x9ac9,0x9aca,
0x9acb,0x9acc,0x9acd,0x9ace,0x9acf,0x9ad0,0x9ad1,0x9ad2,
0x9ad3,0x9ad4,0x9ad5,0x9ad6,0x9ad7,0x9ad8,0x9ad9,0x9ada,
0x9adb,0x9adc,0x9add,0x9ade,0xbdc3,0xbdc4,0x9adf,0x9ae0,
0xbdc5,0x9ae1,0x9ae2,0xbdc6,0xbdc7,0x9ae3,0x9ae4,0x9ae5,
0x9ae6,0x9ae7,0x9ae8,0xbdc8,0xbdc9,0xbdca,0x9ae9,0xbdcb,
0x9aea,0xbdcc,0x9aeb,0x9aec,0x9aed,0x9aee,0xbdcd,0x9aef,
0xbdce,0xbdcf,0x9af0,0xbdd0,0xbdd1,0x9af1,0x9af2,0x9af3,
/* 0xc300 */
0xbdd2,0x9af4,0x9af5,0x9af6,0x9af7,0x9af8,0x9af9,0x9afa,
0xbdd3,0xbdd4,0x9afb,0x9afc,0xbdd5,0xbdd6,0x9afd,0x9afe,
0x9b41,0x9b42,0x9b43,0xbdd7,0xbdd8,0xbdd9,0x9b44,0x9b45,
0xbdda,0x9b46,0x9b47,0x9b48,0xbddb,0x9b49,0x9b4a,0x9b4b,
0x9b4c,0x9b4d,0x9b4e,0x9b4f,0xbddc,0xbddd,0x9b50,0x9b51,
0xbdde,0xbddf,0x9b52,0x9b53,0x9b54,0x9b55,0x9b56,0x9b57,
0x9b58,0x9b59,0x9b5a,0x9b61,0x9b62,0x9b63,0x9b64,0x9b65,
0x9b66,0x9b67,0x9b68,0x9b69,0x9b6a,0x9b6b,0x9b6c,0x9b6d,
0x9b6e,0x9b6f,0x9b70,0x9b71,0x9b72,0xbde0,0x9b73,0x9b74,
0x9b75,0x9b76,0x9b77,0x9b78,0x9b79,0x9b7a,0x9b81,0x9b82,
0x9b83,0x9b84,0x9b85,0x9b86,0x9b87,0x9b88,0x9b89,0x9b8a,
0x9b8b,0x9b8c,0x9b8d,0x9b8e,0x9b8f,0x9b90,0x9b91,0x9b92,
0x9b93,0x9b94,0x9b95,0x9b96,0x9b97,0x9b98,0x9b99,0x9b9a,
0xbde1,0xbde2,0x9b9b,0x9b9c,0xbde3,0x9b9d,0x9b9e,0x9b9f,
0xbde4,0x9ba0,0xbde5,0x9ba1,0x9ba2,0x9ba3,0x9ba4,0x9ba5,
0xbde6,0xbde7,0x9ba6,0x9ba7,0xbde8,0xbde9,0x9ba8,0x9ba9,
0x9baa,0x9bab,0x9bac,0x9bad,0xbdea,0x9bae,0x9baf,0x9bb0,
0xbdeb,0x9bb1,0x9bb2,0x9bb3,0xbdec,0x9bb4,0x9bb5,0x9bb6,
0x9bb7,0x9bb8,0x9bb9,0x9bba,0x9bbb,0x9bbc,0x9bbd,0x9bbe,
0x9bbf,0x9bc0,0x9bc1,0x9bc2,0x9bc3,0x9bc4,0x9bc5,0x9bc6,
0x9bc7,0x9bc8,0x9bc9,0x9bca,0x9bcb,0x9bcc,0x9bcd,0x9bce,
0x9bcf,0x9bd0,0x9bd1,0x9bd2,0x9bd3,0x9bd4,0x9bd5,0x9bd6,
0x9bd7,0x9bd8,0x9bd9,0x9bda,0x9bdb,0x9bdc,0x9bdd,0x9bde,
0x9bdf,0x9be0,0x9be1,0x9be2,0x9be3,0x9be4,0x9be5,0x9be6,
0xbded,0x9be7,0x9be8,0x9be9,0x9bea,0x9beb,0x9bec,0x9bed,
0x9bee,0x9bef,0x9bf0,0x9bf1,0x9bf2,0x9bf3,0x9bf4,0x9bf5,
0x9bf6,0x9bf7,0x9bf8,0x9bf9,0x9bfa,0x9bfb,0x9bfc,0x9bfd,
0xbdee,0xbdef,0x9bfe,0x9c41,0xbdf0,0x9c42,0x9c43,0xbdf1,
0xbdf2,0x9c44,0xbdf3,0x9c45,0x9c46,0x9c47,0x9c48,0x9c49,
0xbdf4,0xbdf5,0x9c4a,0x9c4b,0x9c4c,0xbdf6,0x9c4d,0x9c4e,
0x9c4f,0x9c50,0x9c51,0x9c52,0xbdf7,0xbdf8,0x9c53,0x9c54,
0xbdf9,0x9c55,0x9c56,0x9c57,0x9c58,0x9c59,0x9c5a,0x9c61,
/* 0xc400 */
0x9c62,0x9c63,0x9c64,0x9c65,0x9c66,0x9c67,0x9c68,0x9c69,
0xbdfa,0x9c6a,0x9c6b,0x9c6c,0x9c6d,0x9c6e,0x9c6f,0x9c70,
0xbdfb,0x9c71,0x9c72,0x9c73,0x9c74,0x9c75,0x9c76,0x9c77,
0x9c78,0x9c79,0x9c7a,0x9c81,0x9c82,0x9c83,0x9c84,0x9c85,
0x9c86,0x9c87,0x9c88,0x9c89,0xbdfc,0x9c8a,0x9c8b,0x9c8c,
0x9c8d,0x9c8e,0x9c8f,0x9c90,0xbdfd,0x9c91,0x9c92,0x9c93,
0xbdfe,0x9c94,0x9c95,0x9c96,0xbea1,0x9c97,0x9c98,0x9c99,
0x9c9a,0x9c9b,0x9c9c,0x9c9d,0xbea2,0xbea3,0x9c9e,0x9c9f,
0x9ca0,0x9ca1,0x9ca2,0x9ca3,0x9ca4,0x9ca5,0x9ca6,0x9ca7,
0xbea4,0x9ca8,0x9ca9,0x9caa,0x9cab,0x9cac,0x9cad,0x9cae,
0x9caf,0x9cb0,0x9cb1,0x9cb2,0x9cb3,0x9cb4,0x9cb5,0x9cb6,
0x9cb7,0x9cb8,0x9cb9,0x9cba,0x9cbb,0x9cbc,0x9cbd,0x9cbe,
0x9cbf,0x9cc0,0x9cc1,0x9cc2,0xbea5,0xbea6,0x9cc3,0x9cc4,
0xbea7,0x9cc5,0x9cc6,0x9cc7,0xbea8,0x9cc8,0x9cc9,0x9cca,
0x9ccb,0x9ccc,0x9ccd,0x9cce,0xbea9,0xbeaa,0x9ccf,0x9cd0,
0x9cd1,0xbeab,0x9cd2,0x9cd3,0x9cd4,0x9cd5,0x9cd6,0x9cd7,
0xbeac,0x9cd8,0x9cd9,0x9cda,0x9cdb,0x9cdc,0x9cdd,0x9cde,
0x9cdf,0x9ce0,0x9ce1,0x9ce2,0x9ce3,0x9ce4,0x9ce5,0x9ce6,
0x9ce7,0x9ce8,0x9ce9,0x9cea,0xbead,0x9ceb,0x9cec,0x9ced,
0x9cee,0x9cef,0x9cf0,0x9cf1,0xbeae,0x9cf2,0x9cf3,0x9cf4,
0x9cf5,0x9cf6,0x9cf7,0x9cf8,0x9cf9,0x9cfa,0x9cfb,0x9cfc,
0x9cfd,0x9cfe,0x9d41,0x9d42,0x9d43,0x9d44,0x9d45,0x9d46,
0x9d47,0x9d48,0x9d49,0x9d4a,0x9d4b,0x9d4c,0x9d4d,0x9d4e,
0xbeaf,0x9d4f,0x9d50,0x9d51,0xbeb0,0x9d52,0x9d53,0x9d54,
0x9d55,0x9d56,0x9d57,0x9d58,0x9d59,0x9d5a,0x9d61,0x9d62,
0x9d63,0x9d64,0x9d65,0x9d66,0x9d67,0x9d68,0x9d69,0x9d6a,
0x9d6b,0x9d6c,0x9d6d,0x9d6e,0x9d6f,0x9d70,0x9d71,0x9d72,
0x9d73,0x9d74,0x9d75,0x9d76,0x9d77,0x9d78,0x9d79,0x9d7a,
0x9d81,0x9d82,0x9d83,0x9d84,0x9d85,0x9d86,0x9d87,0x9d88,
0x9d89,0xbeb1,0x9d8a,0x9d8b,0x9d8c,0x9d8d,0x9d8e,0x9d8f,
0xbeb2,0xbeb3,0x9d90,0x9d91,0xbeb4,0x9d92,0x9d93,0x9d94,
0xbeb5,0x9d95,0xbeb6,0x9d96,0x9d97,0x9d98,0x9d99,0xbeb7,
/* 0xc500 */
0xbeb8,0xbeb9,0x9d9a,0x9d9b,0x9d9c,0x9d9d,0x9d9e,0x9d9f,
0x9da0,0x9da1,0x9da2,0x9da3,0xbeba,0x9da4,0x9da5,0x9da6,
0xbebb,0x9da7,0x9da8,0x9da9,0xbebc,0x9daa,0x9dab,0x9dac,
0x9dad,0x9dae,0x9daf,0x9db0,0xbebd,0x9db1,0x9db2,0x9db3,
0x9db4,0x9db5,0x9db6,0x9db7,0x9db8,0x9db9,0x9dba,0x9dbb,
0xbebe,0xbebf,0x9dbc,0x9dbd,0xbec0,0x9dbe,0x9dbf,0x9dc0,
0xbec1,0x9dc1,0x9dc2,0x9dc3,0x9dc4,0x9dc5,0x9dc6,0x9dc7,
0xbec2,0xbec3,0x9dc8,0xbec4,0x9dc9,0xbec5,0x9dca,0x9dcb,
0x9dcc,0x9dcd,0x9dce,0x9dcf,0xbec6,0xbec7,0x9dd0,0x9dd1,
0xbec8,0xbec9,0xbeca,0x9dd2,0xbecb,0xbecc,0xbecd,0x9dd3,
0x9dd4,0x9dd5,0x9dd6,0xbece,0xbecf,0xbed0,0x9dd7,0xbed1,
0xbed2,0xbed3,0x9dd8,0x9dd9,0x9dda,0xbed4,0xbed5,0x9ddb,
0xbed6,0xbed7,0x9ddc,0x9ddd,0xbed8,0x9dde,0x9ddf,0x9de0,
0xbed9,0x9de1,0x9de2,0x9de3,0x9de4,0x9de5,0x9de6,0x9de7,
0xbeda,0xbedb,0x9de8,0xbedc,0xbedd,0xbede,0x9de9,0x9dea,
0x9deb,0x9dec,0x9ded,0x9dee,0xbedf,0xbee0,0x9def,0x9df0,
0xbee1,0x9df1,0x9df2,0x9df3,0xbee2,0x9df4,0x9df5,0xbee3,
0x9df6,0x9df7,0x9df8,0x9df9,0xbee4,0xbee5,0x9dfa,0xbee6,
0x9dfb,0xbee7,0x9dfc,0x9dfd,0x9dfe,0xbee8,0x9e41,0xbee9,
0xbeea,0x9e42,0x9e43,0x9e44,0xbeeb,0x9e45,0x9e46,0x9e47,
0xbeec,0x9e48,0x9e49,0x9e4a,0x9e4b,0x9e4c,0x9e4d,0x9e4e,
0x9e4f,0xbeed,0x9e50,0x9e51,0x9e52,0x9e53,0x9e54,0x9e55,
0x9e56,0x9e57,0x9e58,0x9e59,0xbeee,0xbeef,0x9e5a,0x9e61,
0xbef0,0xbef1,0x9e62,0xbef2,0xbef3,0xbef4,0xbef5,0x9e63,
0x9e64,0x9e65,0x9e66,0x9e67,0xbef6,0xbef7,0xbef8,0xbef9,
0xbefa,0xbefb,0xbefc,0x9e68,0xbefd,0x9e69,0xbefe,0x9e6a,
0xbfa1,0xbfa2,0x9e6b,0x9e6c,0xbfa3,0x9e6d,0x9e6e,0x9e6f,
0xbfa4,0x9e70,0x9e71,0x9e72,0x9e73,0x9e74,0x9e75,0x9e76,
0xbfa5,0xbfa6,0x9e77,0xbfa7,0x9e78,0xbfa8,0x9e79,0x9e7a,
0x9e81,0x9e82,0x9e83,0x9e84,0xbfa9,0xbfaa,0xbfab,0x9e85,
0xbfac,0x9e86,0x9e87,0x9e88,0xbfad,0x9e89,0xbfae,0xbfaf,
0x9e8a,0x9e8b,0x9e8c,0x9e8d,0xbfb0,0xbfb1,0xbfb2,0xbfb3,
/* 0xc600 */
0xbfb4,0xbfb5,0x9e8e,0x9e8f,0x9e90,0xbfb6,0xbfb7,0xbfb8,
0xbfb9,0x9e91,0x9e92,0x9e93,0xbfba,0x9e94,0x9e95,0x9e96,
0xbfbb,0x9e97,0x9e98,0x9e99,0x9e9a,0x9e9b,0x9e9c,0x9e9d,
0xbfbc,0xbfbd,0x9e9e,0xbfbe,0xbfbf,0x9e9f,0x9ea0,0x9ea1,
0x9ea2,0x9ea3,0x9ea4,0x9ea5,0xbfc0,0xbfc1,0x9ea6,0x9ea7,
0xbfc2,0x9ea8,0x9ea9,0x9eaa,0xbfc3,0xbfc4,0xbfc5,0x9eab,
0xbfc6,0x9eac,0x9ead,0xbfc7,0xbfc8,0xbfc9,0x9eae,0xbfca,
0x9eaf,0xbfcb,0x9eb0,0xbfcc,0x9eb1,0x9eb2,0x9eb3,0x9eb4,
0xbfcd,0xbfce,0x9eb5,0x9eb6,0xbfcf,0x9eb7,0x9eb8,0x9eb9,
0xbfd0,0x9eba,0x9ebb,0x9ebc,0x9ebd,0x9ebe,0x9ebf,0x9ec0,
0xbfd1,0xbfd2,0x9ec1,0xbfd3,0xbfd4,0xbfd5,0x9ec2,0x9ec3,
0x9ec4,0x9ec5,0x9ec6,0x9ec7,0xbfd6,0xbfd7,0x9ec8,0x9ec9,
0xbfd8,0x9eca,0x9ecb,0x9ecc,0x9ecd,0x9ece,0x9ecf,0x9ed0,
0x9ed1,0x9ed2,0x9ed3,0x9ed4,0xbfd9,0x9ed5,0x9ed6,0xbfda,
0x9ed7,0xbfdb,0x9ed8,0x9ed9,0x9eda,0x9edb,0x9edc,0x9edd,
0xbfdc,0xbfdd,0x9ede,0x9edf,0xbfde,0x9ee0,0x9ee1,0x9ee2,
0xbfdf,0x9ee3,0x9ee4,0x9ee5,0x9ee6,0x9ee7,0x9ee8,0x9ee9,
0xbfe0,0xbfe1,0x9eea,0xbfe2,0x9eeb,0xbfe3,0x9eec,0x9eed,
0x9eee,0x9eef,0x9ef0,0x9ef1,0xbfe4,0xbfe5,0x9ef2,0x9ef3,
0xbfe6,0x9ef4,0x9ef5,0x9ef6,0xbfe7,0x9ef7,0x9ef8,0x9ef9,
0x9efa,0x9efb,0x9efc,0x9efd,0xbfe8,0xbfe9,0x9efe,0xbfea,
0x9f41,0xbfeb,0x9f42,0x9f43,0x9f44,0x9f45,0x9f46,0x9f47,
0xbfec,0xbfed,0x9f48,0x9f49,0xbfee,0x9f4a,0x9f4b,0x9f4c,
0xbfef,0xbff0,0xbff1,0x9f4d,0x9f4e,0x9f4f,0x9f50,0x9f51,
0xbff2,0xbff3,0x9f52,0xbff4,0x9f53,0xbff5,0x9f54,0x9f55,
0x9f56,0x9f57,0x9f58,0x9f59,0xbff6,0xbff7,0x9f5a,0x9f61,
0xbff8,0x9f62,0x9f63,0x9f64,0xbff9,0x9f65,0x9f66,0x9f67,
0x9f68,0x9f69,0x9f6a,0x9f6b,0xbffa,0xbffb,0x9f6c,0x9f6d,
0xbffc,0xbffd,0x9f6e,0x9f6f,0x9f70,0x9f71,0x9f72,0x9f73,
0xbffe,0xc0a1,0x9f74,0x9f75,0xc0a2,0x9f76,0x9f77,0x9f78,
0xc0a3,0x9f79,0x9f7a,0x9f81,0x9f82,0x9f83,0x9f84,0x9f85,
0xc0a4,0xc0a5,0x9f86,0x9f87,0x9f88,0xc0a6,0x9f89,0x9f8a,
/* 0xc700 */
0x9f8b,0x9f8c,0x9f8d,0x9f8e,0xc0a7,0xc0a8,0x9f8f,0x9f90,
0xc0a9,0x9f91,0x9f92,0x9f93,0xc0aa,0x9f94,0x9f95,0x9f96,
0x9f97,0x9f98,0x9f99,0x9f9a,0xc0ab,0xc0ac,0x9f9b,0xc0ad,
0x9f9c,0xc0ae,0x9f9d,0x9f9e,0x9f9f,0x9fa0,0x9fa1,0x9fa2,
0xc0af,0xc0b0,0x9fa3,0x9fa4,0xc0b1,0x9fa5,0x9fa6,0x9fa7,
0xc0b2,0x9fa8,0x9fa9,0x9faa,0x9fab,0x9fac,0x9fad,0x9fae,
0xc0b3,0xc0b4,0x9faf,0xc0b5,0x9fb0,0xc0b6,0x9fb1,0xc0b7,
0x9fb2,0x9fb3,0x9fb4,0x9fb5,0xc0b8,0xc0b9,0x9fb6,0x9fb7,
0xc0ba,0x9fb8,0x9fb9,0x9fba,0xc0bb,0x9fbb,0x9fbc,0x9fbd,
0x9fbe,0x9fbf,0xc0bc,0x9fc0,0xc0bd,0xc0be,0x9fc1,0xc0bf,
0x9fc2,0xc0c0,0xc0c1,0xc0c2,0xc0c3,0xc0c4,0xc0c5,0xc0c6,
0xc0c7,0x9fc3,0x9fc4,0x9fc5,0xc0c8,0x9fc6,0x9fc7,0x9fc8,
0xc0c9,0x9fc9,0x9fca,0x9fcb,0x9fcc,0x9fcd,0x9fce,0x9fcf,
0xc0ca,0x9fd0,0x9fd1,0xc0cb,0x9fd2,0x9fd3,0x9fd4,0x9fd5,
0x9fd6,0x9fd7,0x9fd8,0x9fd9,0xc0cc,0xc0cd,0x9fda,0x9fdb,
0xc0ce,0x9fdc,0x9fdd,0x9fde,0xc0cf,0xc0d0,0xc0d1,0x9fdf,
0x9fe0,0x9fe1,0x9fe2,0xc0d2,0xc0d3,0xc0d4,0x9fe3,0xc0d5,
0xc0d6,0xc0d7,0xc0d8,0x9fe4,0x9fe5,0x9fe6,0xc0d9,0x9fe7,
0xc0da,0xc0db,0x9fe8,0x9fe9,0xc0dc,0x9fea,0xc0dd,0xc0de,
0xc0df,0x9feb,0xc0e0,0x9fec,0x9fed,0x9fee,0x9fef,0x9ff0,
0xc0e1,0xc0e2,0x9ff1,0xc0e3,0xc0e4,0xc0e5,0xc0e6,0x9ff2,
0x9ff3,0x9ff4,0x9ff5,0x9ff6,0xc0e7,0xc0e8,0x9ff7,0x9ff8,
0xc0e9,0x9ff9,0x9ffa,0x9ffb,0xc0ea,0x9ffc,0x9ffd,0x9ffe,
0xa041,0xa042,0xa043,0xa044,0xc0eb,0xc0ec,0xa045,0xc0ed,
0xc0ee,0xc0ef,0xa046,0xa047,0xa048,0xa049,0xa04a,0xa04b,
0xc0f0,0xc0f1,0xa04c,0xa04d,0xc0f2,0xa04e,0xc0f3,0xa04f,
0xc0f4,0xa050,0xa051,0xa052,0xa053,0xa054,0xa055,0xa056,
0xc0f5,0xa057,0xa058,0xa059,0xa05a,0xc0f6,0xa061,0xa062,
0xa063,0xa064,0xa065,0xa066,0xc0f7,0xa067,0xa068,0xa069,
0xc0f8,0xa06a,0xa06b,0xa06c,0xc0f9,0xa06d,0xa06e,0xa06f,
0xa070,0xa071,0xa072,0xa073,0xa074,0xa075,0xa076,0xa077,
0xa078,0xa079,0xa07a,0xa081,0xa082,0xa083,0xa084,0xa085,
/* 0xc800 */
0xc0fa,0xc0fb,0xa086,0xa087,0xc0fc,0xa088,0xa089,0xa08a,
0xc0fd,0xa08b,0xc0fe,0xa08c,0xa08d,0xa08e,0xa08f,0xa090,
0xc1a1,0xc1a2,0xa091,0xc1a3,0xa092,0xc1a4,0xc1a5,0xa093,
0xa094,0xa095,0xa096,0xa097,0xc1a6,0xc1a7,0xa098,0xa099,
0xc1a8,0xa09a,0xa09b,0xa09c,0xc1a9,0xa09d,0xa09e,0xa09f,
0xa0a0,0xa0a1,0xa0a2,0xa0a3,0xc1aa,0xc1ab,0xa0a4,0xc1ac,
0xa0a5,0xc1ad,0xa0a6,0xa0a7,0xa0a8,0xa0a9,0xa0aa,0xa0ab,
0xc1ae,0xa0ac,0xa0ad,0xa0ae,0xc1af,0xa0af,0xa0b0,0xa0b1,
0xc1b0,0xa0b2,0xa0b3,0xa0b4,0xa0b5,0xa0b6,0xa0b7,0xa0b8,
0xc1b1,0xc1b2,0xa0b9,0xa0ba,0xc1b3,0xc1b4,0xa0bb,0xa0bc,
0xa0bd,0xa0be,0xa0bf,0xa0c0,0xc1b5,0xa0c1,0xa0c2,0xa0c3,
0xa0c4,0xa0c5,0xa0c6,0xa0c7,0xa0c8,0xa0c9,0xa0ca,0xa0cb,
0xa0cc,0xa0cd,0xa0ce,0xa0cf,0xa0d0,0xa0d1,0xa0d2,0xa0d3,
0xa0d4,0xa0d5,0xa0d6,0xa0d7,0xa0d8,0xa0d9,0xa0da,0xa0db,
0xc1b6,0xc1b7,0xa0dc,0xa0dd,0xc1b8,0xa0de,0xa0df,0xa0e0,
0xc1b9,0xa0e1,0xc1ba,0xa0e2,0xa0e3,0xa0e4,0xa0e5,0xa0e6,
0xc1bb,0xc1bc,0xa0e7,0xc1bd,0xa0e8,0xc1be,0xc1bf,0xc1c0,
0xa0e9,0xa0ea,0xa0eb,0xc1c1,0xc1c2,0xc1c3,0xa0ec,0xa0ed,
0xa0ee,0xa0ef,0xa0f0,0xa0f1,0xc1c4,0xa0f2,0xa0f3,0xa0f4,
0xa0f5,0xa0f6,0xa0f7,0xa0f8,0xa0f9,0xc1c5,0xa0fa,0xc1c6,
0xa0fb,0xc1c7,0xa0fc,0xa0fd,0xa0fe,0xa141,0xa142,0xa143,
0xc1c8,0xa144,0xa145,0xa146,0xa147,0xa148,0xa149,0xa14a,
0xa14b,0xa14c,0xa14d,0xa14e,0xa14f,0xa150,0xa151,0xa152,
0xa153,0xa154,0xa155,0xa156,0xc1c9,0xc1ca,0xa157,0xa158,
0xa159,0xa15a,0xa161,0xa162,0xc1cb,0xa163,0xa164,0xa165,
0xc1cc,0xa166,0xa167,0xa168,0xc1cd,0xa169,0xa16a,0xa16b,
0xa16c,0xa16d,0xa16e,0xa16f,0xc1ce,0xc1cf,0xa170,0xc1d0,
0xa171,0xc1d1,0xa172,0xa173,0xa174,0xa175,0xa176,0xa177,
0xc1d2,0xc1d3,0xa178,0xa179,0xc1d4,0xa17a,0xa181,0xa182,
0xa183,0xa184,0xa185,0xa186,0xa187,0xa188,0xa189,0xa18a,
0xa18b,0xa18c,0xa18d,0xa18e,0xa18f,0xc1d5,0xa190,0xa191,
0xa192,0xa193,0xa194,0xa195,0xc1d6,0xc1d7,0xa196,0xa197,
/* 0xc900 */
0xc1d8,0xa198,0xa199,0xa19a,0xc1d9,0xc1da,0xc1db,0xa19b,
0xa19c,0xa19d,0xa19e,0xa19f,0xc1dc,0xc1dd,0xa1a0,0xc1de,
0xa241,0xc1df,0xa242,0xa243,0xa244,0xa245,0xa246,0xa247,
0xc1e0,0xa248,0xa249,0xa24a,0xa24b,0xa24c,0xa24d,0xa24e,
0xa24f,0xa250,0xa251,0xa252,0xa253,0xa254,0xa255,0xa256,
0xa257,0xa258,0xa259,0xa25a,0xc1e1,0xa261,0xa262,0xa263,
0xa264,0xa265,0xa266,0xa267,0xc1e2,0xa268,0xa269,0xa26a,
0xa26b,0xa26c,0xa26d,0xa26e,0xa26f,0xa270,0xa271,0xa272,
0xa273,0xa274,0xa275,0xa276,0xa277,0xa278,0xa279,0xa27a,
0xa281,0xa282,0xa283,0xa284,0xa285,0xa286,0xa287,0xa288,
0xc1e3,0xc1e4,0xa289,0xa28a,0xc1e5,0xa28b,0xa28c,0xa28d,
0xc1e6,0xa28e,0xa28f,0xa290,0xa291,0xa292,0xa293,0xa294,
0xc1e7,0xc1e8,0xa295,0xc1e9,0xa296,0xa297,0xa298,0xa299,
0xa29a,0xa29b,0xa29c,0xa29d,0xc1ea,0xa29e,0xa29f,0xa2a0,
0xc1eb,0xa341,0xa342,0xa343,0xc1ec,0xa344,0xa345,0xa346,
0xa347,0xa348,0xa349,0xa34a,0xc1ed,0xa34b,0xa34c,0xa34d,
0xa34e,0xa34f,0xa350,0xa351,0xa352,0xa353,0xa354,0xa355,
0xc1ee,0xc1ef,0xa356,0xa357,0xc1f0,0xa358,0xa359,0xa35a,
0xc1f1,0xa361,0xa362,0xa363,0xa364,0xa365,0xa366,0xa367,
0xc1f2,0xc1f3,0xa368,0xc1f4,0xa369,0xc1f5,0xa36a,0xa36b,
0xa36c,0xa36d,0xa36e,0xa36f,0xa370,0xa371,0xa372,0xa373,
0xa374,0xa375,0xa376,0xa377,0xa378,0xa379,0xa37a,0xa381,
0xa382,0xa383,0xa384,0xa385,0xa386,0xa387,0xa388,0xa389,
0xa38a,0xa38b,0xa38c,0xa38d,0xa38e,0xa38f,0xa390,0xa391,
0xc1f6,0xc1f7,0xa392,0xa393,0xc1f8,0xa394,0xa395,0xc1f9,
0xc1fa,0xa396,0xc1fb,0xa397,0xa398,0xa399,0xa39a,0xa39b,
0xc1fc,0xc1fd,0xa39c,0xc1fe,0xa39d,0xc2a1,0xc2a2,0xa39e,
0xa39f,0xc2a3,0xc2a4,0xa3a0,0xc2a5,0xc2a6,0xa441,0xa442,
0xc2a7,0xa443,0xc2a8,0xa444,0xc2a9,0xa445,0xa446,0xc2aa,
0xa447,0xa448,0xa449,0xa44a,0xc2ab,0xc2ac,0xa44b,0xc2ad,
0xc2ae,0xc2af,0xa44c,0xa44d,0xa44e,0xa44f,0xa450,0xa451,
0xc2b0,0xc2b1,0xa452,0xa453,0xc2b2,0xa454,0xa455,0xa456,
/* 0xca00 */
0xc2b3,0xa457,0xa458,0xa459,0xa45a,0xa461,0xa462,0xa463,
0xc2b4,0xc2b5,0xa464,0xc2b6,0xc2b7,0xc2b8,0xa465,0xa466,
0xa467,0xa468,0xa469,0xa46a,0xc2b9,0xa46b,0xa46c,0xa46d,
0xc2ba,0xa46e,0xa46f,0xa470,0xa471,0xa472,0xa473,0xa474,
0xa475,0xa476,0xa477,0xa478,0xa479,0xa47a,0xa481,0xa482,
0xa483,0xc2bb,0xa484,0xa485,0xa486,0xa487,0xa488,0xa489,
0xa48a,0xa48b,0xa48c,0xa48d,0xa48e,0xa48f,0xa490,0xa491,
0xa492,0xa493,0xa494,0xa495,0xa496,0xa497,0xa498,0xa499,
0xa49a,0xa49b,0xa49c,0xa49d,0xa49e,0xa49f,0xa4a0,0xa541,
0xa542,0xa543,0xa544,0xa545,0xc2bc,0xc2bd,0xa546,0xa547,
0xc2be,0xa548,0xa549,0xa54a,0xc2bf,0xa54b,0xa54c,0xa54d,
0xa54e,0xa54f,0xa550,0xa551,0xc2c0,0xc2c1,0xa552,0xc2c2,
0xc2c3,0xc2c4,0xa553,0xa554,0xa555,0xa556,0xa557,0xa558,
0xc2c5,0xa559,0xa55a,0xa561,0xa562,0xa563,0xa564,0xa565,
0xa566,0xa567,0xa568,0xa569,0xa56a,0xa56b,0xa56c,0xa56d,
0xa56e,0xa56f,0xa570,0xa571,0xa572,0xc2c6,0xa573,0xa574,
0xa575,0xa576,0xa577,0xa578,0xc2c7,0xa579,0xa57a,0xa581,
0xa582,0xa583,0xa584,0xa585,0xa586,0xa587,0xa588,0xa589,
0xa58a,0xa58b,0xa58c,0xa58d,0xa58e,0xa58f,0xa590,0xa591,
0xc2c8,0xa592,0xa593,0xa594,0xa595,0xa596,0xa597,0xa598,
0xa599,0xa59a,0xa59b,0xa59c,0xa59d,0xa59e,0xa59f,0xa5a0,
0xa641,0xa642,0xa643,0xa644,0xa645,0xa646,0xa647,0xa648,
0xa649,0xa64a,0xa64b,0xa64c,0xa64d,0xa64e,0xa64f,0xa650,
0xa651,0xa652,0xa653,0xa654,0xc2c9,0xc2ca,0xa655,0xa656,
0xc2cb,0xa657,0xa658,0xa659,0xc2cc,0xa65a,0xa661,0xa662,
0xa663,0xa664,0xa665,0xa666,0xc2cd,0xc2ce,0xa667,0xc2cf,
0xa668,0xc2d0,0xa669,0xc2d1,0xa66a,0xa66b,0xa66c,0xa66d,
0xc2d2,0xc2d3,0xa66e,0xa66f,0xa670,0xa671,0xa672,0xa673,
0xc2d4,0xa674,0xa675,0xa676,0xa677,0xa678,0xa679,0xa67a,
0xa681,0xa682,0xa683,0xa684,0xc2d5,0xa685,0xa686,0xa687,
0xa688,0xa689,0xa68a,0xa68b,0xc2d6,0xa68c,0xa68d,0xa68e,
0xa68f,0xa690,0xa691,0xa692,0xa693,0xa694,0xa695,0xa696,
/* 0xcb00 */
0xa697,0xa698,0xa699,0xa69a,0xa69b,0xa69c,0xa69d,0xa69e,
0xc2d7,0xa69f,0xa6a0,0xa741,0xa742,0xa743,0xa744,0xa745,
0xc2d8,0xa746,0xa747,0xa748,0xc2d9,0xa749,0xa74a,0xa74b,
0xc2da,0xa74c,0xa74d,0xa74e,0xa74f,0xa750,0xa751,0xa752,
0xc2db,0xc2dc,0xa753,0xa754,0xa755,0xa756,0xa757,0xa758,
0xa759,0xa75a,0xa761,0xa762,0xa763,0xa764,0xa765,0xa766,
0xa767,0xa768,0xa769,0xa76a,0xa76b,0xa76c,0xa76d,0xa76e,
0xa76f,0xa770,0xa771,0xa772,0xa773,0xa774,0xa775,0xa776,
0xa777,0xc2dd,0xa778,0xa779,0xa77a,0xa781,0xa782,0xa783,
0xc2de,0xc2df,0xa784,0xa785,0xc2e0,0xa786,0xa787,0xa788,
0xc2e1,0xa789,0xa78a,0xa78b,0xa78c,0xa78d,0xa78e,0xa78f,
0xc2e2,0xc2e3,0xa790,0xa791,0xa792,0xc2e4,0xa793,0xa794,
0xa795,0xa796,0xa797,0xa798,0xc2e5,0xa799,0xa79a,0xa79b,
0xa79c,0xa79d,0xa79e,0xa79f,0xa7a0,0xa841,0xa842,0xa843,
0xa844,0xa845,0xa846,0xa847,0xa848,0xa849,0xa84a,0xa84b,
0xc2e6,0xc2e7,0xa84c,0xa84d,0xa84e,0xa84f,0xa850,0xa851,
0xa852,0xa853,0xa854,0xa855,0xa856,0xa857,0xa858,0xa859,
0xa85a,0xa861,0xa862,0xa863,0xa864,0xa865,0xa866,0xa867,
0xa868,0xa869,0xa86a,0xa86b,0xa86c,0xa86d,0xa86e,0xa86f,
0xa870,0xa871,0xa872,0xa873,0xc2e8,0xa874,0xa875,0xa876,
0xa877,0xa878,0xa879,0xa87a,0xa881,0xa882,0xa883,0xa884,
0xa885,0xa886,0xa887,0xa888,0xa889,0xa88a,0xa88b,0xa88c,
0xa88d,0xa88e,0xa88f,0xa890,0xa891,0xa892,0xa893,0xa894,
0xc2e9,0xa895,0xa896,0xa897,0xa898,0xa899,0xa89a,0xa89b,
0xa89c,0xa89d,0xa89e,0xa89f,0xa8a0,0xa941,0xa942,0xa943,
0xa944,0xa945,0xa946,0xa947,0xa948,0xa949,0xa94a,0xa94b,
0xa94c,0xa94d,0xa94e,0xa94f,0xc2ea,0xa950,0xa951,0xa952,
0xa953,0xa954,0xa955,0xa956,0xa957,0xa958,0xa959,0xa95a,
0xa961,0xa962,0xa963,0xa964,0xc2eb,0xa965,0xa966,0xc2ec,
0xa967,0xc2ed,0xa968,0xa969,0xa96a,0xa96b,0xa96c,0xa96d,
0xa96e,0xa96f,0xa970,0xa971,0xa972,0xa973,0xa974,0xa975,
0xa976,0xa977,0xa978,0xa979,0xa97a,0xa981,0xa982,0xa983,
/* 0xcc00 */
0xa984,0xa985,0xa986,0xa987,0xa988,0xa989,0xa98a,0xa98b,
0xa98c,0xa98d,0xa98e,0xa98f,0xc2ee,0xc2ef,0xa990,0xa991,
0xc2f0,0xa992,0xa993,0xa994,0xc2f1,0xa995,0xa996,0xa997,
0xa998,0xa999,0xa99a,0xa99b,0xc2f2,0xc2f3,0xa99c,0xa99d,
0xa99e,0xc2f4,0xc2f5,0xa99f,0xa9a0,0xaa41,0xaa42,0xc2f6,
0xc2f7,0xc2f8,0xaa43,0xaa44,0xc2f9,0xaa45,0xc2fa,0xaa46,
0xc2fb,0xaa47,0xaa48,0xaa49,0xaa4a,0xaa4b,0xaa4c,0xaa4d,
0xc2fc,0xc2fd,0xaa4e,0xc2fe,0xc3a1,0xc3a2,0xc3a3,0xaa4f,
0xaa50,0xaa51,0xaa52,0xaa53,0xc3a4,0xc3a5,0xaa54,0xaa55,
0xc3a6,0xaa56,0xaa57,0xaa58,0xc3a7,0xaa59,0xaa5a,0xaa61,
0xaa62,0xaa63,0xaa64,0xaa65,0xc3a8,0xc3a9,0xaa66,0xc3aa,
0xc3ab,0xc3ac,0xaa67,0xaa68,0xaa69,0xaa6a,0xaa6b,0xaa6c,
0xc3ad,0xaa6d,0xaa6e,0xaa6f,0xc3ae,0xaa70,0xc3af,0xaa71,
0xc3b0,0xaa72,0xaa73,0xaa74,0xaa75,0xaa76,0xaa77,0xaa78,
0xc3b1,0xaa79,0xaa7a,0xaa81,0xaa82,0xc3b2,0xaa83,0xaa84,
0xaa85,0xaa86,0xaa87,0xaa88,0xaa89,0xaa8a,0xaa8b,0xaa8c,
0xaa8d,0xaa8e,0xaa8f,0xaa90,0xaa91,0xaa92,0xaa93,0xaa94,
0xaa95,0xaa96,0xaa97,0xaa98,0xaa99,0xaa9a,0xaa9b,0xaa9c,
0xaa9d,0xaa9e,0xaa9f,0xaaa0,0xab41,0xab42,0xab43,0xab44,
0xc3b3,0xc3b4,0xab45,0xab46,0xc3b5,0xab47,0xab48,0xab49,
0xc3b6,0xab4a,0xab4b,0xab4c,0xab4d,0xab4e,0xab4f,0xab50,
0xc3b7,0xc3b8,0xab51,0xc3b9,0xc3ba,0xc3bb,0xab52,0xab53,
0xab54,0xab55,0xab56,0xab57,0xc3bc,0xc3bd,0xab58,0xab59,
0xc3be,0xab5a,0xab61,0xab62,0xc3bf,0xab63,0xab64,0xab65,
0xab66,0xab67,0xab68,0xab69,0xc3c0,0xc3c1,0xab6a,0xc3c2,
0xab6b,0xc3c3,0xab6c,0xab6d,0xab6e,0xab6f,0xab70,0xab71,
0xc3c4,0xab72,0xab73,0xab74,0xc3c5,0xab75,0xab76,0xab77,
0xab78,0xab79,0xab7a,0xab81,0xab82,0xab83,0xab84,0xab85,
0xab86,0xab87,0xab88,0xab89,0xc3c6,0xab8a,0xab8b,0xab8c,
0xab8d,0xab8e,0xab8f,0xab90,0xc3c7,0xab91,0xab92,0xab93,
0xc3c8,0xab94,0xab95,0xab96,0xab97,0xab98,0xab99,0xab9a,
0xab9b,0xab9c,0xab9d,0xab9e,0xab9f,0xaba0,0xac41,0xac42,
/* 0xcd00 */
0xac43,0xc3c9,0xac44,0xac45,0xac46,0xac47,0xac48,0xac49,
0xc3ca,0xc3cb,0xac4a,0xac4b,0xc3cc,0xac4c,0xac4d,0xac4e,
0xc3cd,0xac4f,0xac50,0xac51,0xac52,0xac53,0xac54,0xac55,
0xc3ce,0xc3cf,0xac56,0xc3d0,0xac57,0xc3d1,0xac58,0xac59,
0xac5a,0xac61,0xac62,0xac63,0xc3d2,0xac64,0xac65,0xac66,
0xc3d3,0xac67,0xac68,0xac69,0xc3d4,0xac6a,0xac6b,0xac6c,
0xac6d,0xac6e,0xac6f,0xac70,0xac71,0xac72,0xac73,0xac74,
0xac75,0xc3d5,0xac76,0xac77,0xac78,0xac79,0xac7a,0xac81,
0xac82,0xac83,0xac84,0xac85,0xac86,0xac87,0xac88,0xac89,
0xac8a,0xac8b,0xac8c,0xac8d,0xac8e,0xac8f,0xac90,0xac91,
0xac92,0xac93,0xac94,0xac95,0xac96,0xac97,0xac98,0xac99,
0xac9a,0xac9b,0xac9c,0xac9d,0xc3d6,0xac9e,0xac9f,0xaca0,
0xc3d7,0xad41,0xad42,0xad43,0xc3d8,0xad44,0xad45,0xad46,
0xad47,0xad48,0xad49,0xad4a,0xc3d9,0xc3da,0xad4b,0xc3db,
0xad4c,0xc3dc,0xad4d,0xad4e,0xad4f,0xad50,0xad51,0xad52,
0xc3dd,0xad53,0xad54,0xad55,0xad56,0xad57,0xad58,0xad59,
0xad5a,0xad61,0xad62,0xad63,0xad64,0xad65,0xad66,0xad67,
0xc3de,0xad68,0xad69,0xad6a,0xad6b,0xad6c,0xad6d,0xad6e,
0xad6f,0xad70,0xad71,0xad72,0xc3df,0xc3e0,0xad73,0xad74,
0xc3e1,0xad75,0xad76,0xad77,0xc3e2,0xad78,0xad79,0xad7a,
0xad81,0xad82,0xad83,0xad84,0xc3e3,0xc3e4,0xad85,0xc3e5,
0xad86,0xc3e6,0xad87,0xad88,0xad89,0xad8a,0xad8b,0xad8c,
0xc3e7,0xad8d,0xad8e,0xad8f,0xad90,0xad91,0xad92,0xad93,
0xad94,0xad95,0xad96,0xad97,0xad98,0xad99,0xad9a,0xad9b,
0xad9c,0xad9d,0xad9e,0xad9f,0xc3e8,0xada0,0xae41,0xae42,
0xae43,0xae44,0xae45,0xae46,0xc3e9,0xae47,0xae48,0xae49,
0xc3ea,0xae4a,0xae4b,0xae4c,0xae4d,0xae4e,0xae4f,0xae50,
0xae51,0xae52,0xae53,0xae54,0xae55,0xae56,0xae57,0xae58,
0xae59,0xae5a,0xae61,0xae62,0xae63,0xae64,0xae65,0xae66,
0xc3eb,0xae67,0xae68,0xae69,0xc3ec,0xae6a,0xae6b,0xae6c,
0xc3ed,0xae6d,0xae6e,0xae6f,0xae70,0xae71,0xae72,0xae73,
0xc3ee,0xc3ef,0xae74,0xc3f0,0xae75,0xc3f1,0xae76,0xae77,
/* 0xce00 */
0xae78,0xae79,0xae7a,0xae81,0xc3f2,0xae82,0xae83,0xae84,
0xc3f3,0xae85,0xae86,0xae87,0xc3f4,0xae88,0xae89,0xae8a,
0xae8b,0xae8c,0xae8d,0xae8e,0xc3f5,0xae8f,0xae90,0xae91,
0xae92,0xc3f6,0xae93,0xae94,0xae95,0xae96,0xae97,0xae98,
0xc3f7,0xc3f8,0xae99,0xae9a,0xc3f9,0xae9b,0xae9c,0xae9d,
0xc3fa,0xae9e,0xae9f,0xaea0,0xaf41,0xaf42,0xaf43,0xaf44,
0xc3fb,0xc3fc,0xaf45,0xc3fd,0xaf46,0xc3fe,0xaf47,0xaf48,
0xaf49,0xaf4a,0xaf4b,0xaf4c,0xaf4d,0xaf4e,0xaf4f,0xaf50,
0xaf51,0xaf52,0xaf53,0xaf54,0xaf55,0xaf56,0xaf57,0xaf58,
0xaf59,0xaf5a,0xaf61,0xaf62,0xaf63,0xaf64,0xaf65,0xaf66,
0xaf67,0xaf68,0xaf69,0xaf6a,0xaf6b,0xaf6c,0xaf6d,0xaf6e,
0xc4a1,0xc4a2,0xaf6f,0xaf70,0xc4a3,0xaf71,0xaf72,0xc4a4,
0xc4a5,0xc4a6,0xaf73,0xaf74,0xaf75,0xaf76,0xaf77,0xaf78,
0xc4a7,0xc4a8,0xaf79,0xc4a9,0xaf7a,0xc4aa,0xaf81,0xaf82,
0xaf83,0xaf84,0xaf85,0xaf86,0xc4ab,0xc4ac,0xaf87,0xaf88,
0xc4ad,0xaf89,0xaf8a,0xaf8b,0xc4ae,0xaf8c,0xaf8d,0xaf8e,
0xaf8f,0xaf90,0xaf91,0xaf92,0xc4af,0xc4b0,0xaf93,0xc4b1,
0xaf94,0xc4b2,0xaf95,0xaf96,0xaf97,0xaf98,0xaf99,0xaf9a,
0xc4b3,0xc4b4,0xaf9b,0xaf9c,0xc4b5,0xaf9d,0xaf9e,0xaf9f,
0xc4b6,0xafa0,0xb041,0xb042,0xb043,0xb044,0xb045,0xb046,
0xc4b7,0xc4b8,0xb047,0xc4b9,0xc4ba,0xc4bb,0xb048,0xb049,
0xb04a,0xb04b,0xb04c,0xb04d,0xc4bc,0xc4bd,0xb04e,0xb04f,
0xb050,0xb051,0xb052,0xb053,0xb054,0xb055,0xb056,0xb057,
0xb058,0xb059,0xb05a,0xb061,0xb062,0xb063,0xb064,0xb065,
0xb066,0xc4be,0xb067,0xb068,0xb069,0xb06a,0xb06b,0xb06c,
0xb06d,0xb06e,0xb06f,0xb070,0xb071,0xb072,0xb073,0xb074,
0xb075,0xb076,0xb077,0xb078,0xb079,0xb07a,0xb081,0xb082,
0xb083,0xb084,0xb085,0xb086,0xb087,0xb088,0xb089,0xb08a,
0xb08b,0xb08c,0xb08d,0xb08e,0xc4bf,0xc4c0,0xb08f,0xb090,
0xc4c1,0xb091,0xb092,0xc4c2,0xc4c3,0xb093,0xb094,0xb095,
0xb096,0xb097,0xb098,0xb099,0xc4c4,0xc4c5,0xb09a,0xc4c6,
0xc4c7,0xc4c8,0xb09b,0xb09c,0xb09d,0xb09e,0xb09f,0xb0a0,
/* 0xcf00 */
0xc4c9,0xc4ca,0xb141,0xb142,0xc4cb,0xb143,0xb144,0xb145,
0xc4cc,0xb146,0xb147,0xb148,0xb149,0xb14a,0xb14b,0xb14c,
0xc4cd,0xc4ce,0xb14d,0xc4cf,0xb14e,0xc4d0,0xb14f,0xb150,
0xb151,0xb152,0xb153,0xb154,0xc4d1,0xb155,0xb156,0xb157,
0xc4d2,0xb158,0xb159,0xb15a,0xc4d3,0xb161,0xb162,0xb163,
0xb164,0xb165,0xb166,0xb167,0xc4d4,0xc4d5,0xb168,0xc4d6,
0xc4d7,0xc4d8,0xb169,0xb16a,0xb16b,0xb16c,0xb16d,0xb16e,
0xc4d9,0xb16f,0xb170,0xb171,0xb172,0xb173,0xb174,0xb175,
0xb176,0xb177,0xb178,0xb179,0xb17a,0xb181,0xb182,0xb183,
0xb184,0xb185,0xb186,0xb187,0xb188,0xb189,0xb18a,0xb18b,
0xb18c,0xb18d,0xb18e,0xb18f,0xc4da,0xc4db,0xb190,0xb191,
0xc4dc,0xb192,0xb193,0xb194,0xc4dd,0xb195,0xb196,0xb197,
0xb198,0xb199,0xb19a,0xb19b,0xc4de,0xc4df,0xb19c,0xc4e0,
0xb19d,0xc4e1,0xb19e,0xb19f,0xb1a0,0xb241,0xb242,0xb243,
0xc4e2,0xc4e3,0xb244,0xb245,0xc4e4,0xb246,0xb247,0xb248,
0xc4e5,0xb249,0xb24a,0xb24b,0xb24c,0xb24d,0xb24e,0xb24f,
0xc4e6,0xb250,0xb251,0xb252,0xb253,0xc4e7,0xb254,0xb255,
0xb256,0xb257,0xb258,0xb259,0xc4e8,0xb25a,0xb261,0xb262,
0xb263,0xb264,0xb265,0xb266,0xb267,0xb268,0xb269,0xb26a,
0xb26b,0xb26c,0xb26d,0xb26e,0xb26f,0xb270,0xb271,0xb272,
0xb273,0xc4e9,0xb274,0xb275,0xb276,0xb277,0xb278,0xb279,
0xc4ea,0xb27a,0xb281,0xb282,0xb283,0xb284,0xb285,0xb286,
0xc4eb,0xb287,0xb288,0xb289,0xb28a,0xb28b,0xb28c,0xb28d,
0xb28e,0xb28f,0xb290,0xb291,0xb292,0xb293,0xb294,0xb295,
0xb296,0xb297,0xb298,0xb299,0xc4ec,0xb29a,0xb29b,0xb29c,
0xb29d,0xb29e,0xb29f,0xb2a0,0xb341,0xb342,0xb343,0xb344,
0xb345,0xb346,0xb347,0xb348,0xb349,0xb34a,0xb34b,0xb34c,
0xb34d,0xb34e,0xb34f,0xb350,0xb351,0xb352,0xb353,0xb354,
0xc4ed,0xc4ee,0xb355,0xb356,0xc4ef,0xb357,0xb358,0xb359,
0xc4f0,0xb35a,0xb361,0xb362,0xb363,0xb364,0xb365,0xb366,
0xc4f1,0xc4f2,0xb367,0xc4f3,0xb368,0xc4f4,0xb369,0xb36a,
0xb36b,0xb36c,0xb36d,0xb36e,0xc4f5,0xb36f,0xb370,0xb371,
/* 0xd000 */
0xc4f6,0xb372,0xb373,0xb374,0xc4f7,0xb375,0xb376,0xb377,
0xb378,0xb379,0xb37a,0xb381,0xb382,0xb383,0xb384,0xb385,
0xb386,0xc4f8,0xb387,0xb388,0xb389,0xb38a,0xb38b,0xb38c,
0xc4f9,0xb38d,0xb38e,0xb38f,0xb390,0xb391,0xb392,0xb393,
0xb394,0xb395,0xb396,0xb397,0xb398,0xb399,0xb39a,0xb39b,
0xb39c,0xb39d,0xb39e,0xb39f,0xb3a0,0xc4fa,0xb441,0xb442,
0xb443,0xb444,0xb445,0xb446,0xc4fb,0xc4fc,0xb447,0xb448,
0xc4fd,0xb449,0xb44a,0xb44b,0xc4fe,0xb44c,0xb44d,0xb44e,
0xb44f,0xb450,0xb451,0xb452,0xc5a1,0xc5a2,0xb453,0xc5a3,
0xb454,0xc5a4,0xb455,0xb456,0xb457,0xb458,0xb459,0xb45a,
0xc5a5,0xb461,0xb462,0xb463,0xc5a6,0xb464,0xb465,0xb466,
0xc5a7,0xb467,0xb468,0xb469,0xb46a,0xb46b,0xb46c,0xb46d,
0xc5a8,0xb46e,0xb46f,0xb470,0xb471,0xb472,0xb473,0xb474,
0xb475,0xb476,0xb477,0xb478,0xc5a9,0xc5aa,0xb479,0xb47a,
0xc5ab,0xb481,0xb482,0xb483,0xc5ac,0xb484,0xb485,0xb486,
0xb487,0xb488,0xb489,0xb48a,0xc5ad,0xc5ae,0xb48b,0xb48c,
0xb48d,0xc5af,0xb48e,0xb48f,0xb490,0xb491,0xb492,0xb493,
0xb494,0xb495,0xb496,0xb497,0xb498,0xb499,0xb49a,0xb49b,
0xb49c,0xb49d,0xb49e,0xb49f,0xb4a0,0xb541,0xb542,0xb543,
0xb544,0xb545,0xb546,0xb547,0xb548,0xb549,0xb54a,0xb54b,
0xb54c,0xb54d,0xb54e,0xb54f,0xc5b0,0xc5b1,0xb550,0xb551,
0xc5b2,0xb552,0xb553,0xb554,0xc5b3,0xb555,0xb556,0xb557,
0xb558,0xb559,0xb55a,0xb561,0xc5b4,0xc5b5,0xb562,0xc5b6,
0xb563,0xc5b7,0xb564,0xb565,0xb566,0xb567,0xb568,0xb569,
0xc5b8,0xc5b9,0xb56a,0xb56b,0xc5ba,0xb56c,0xb56d,0xb56e,
0xc5bb,0xc5bc,0xb56f,0xb570,0xb571,0xb572,0xb573,0xb574,
0xc5bd,0xc5be,0xb575,0xc5bf,0xc5c0,0xc5c1,0xb576,0xb577,
0xb578,0xb579,0xb57a,0xb581,0xc5c2,0xc5c3,0xb582,0xb583,
0xc5c4,0xb584,0xb585,0xb586,0xc5c5,0xb587,0xb588,0xb589,
0xb58a,0xb58b,0xb58c,0xb58d,0xc5c6,0xc5c7,0xb58e,0xc5c8,
0xc5c9,0xc5ca,0xb58f,0xb590,0xb591,0xb592,0xb593,0xb594,
0xc5cb,0xb595,0xb596,0xb597,0xb598,0xb599,0xb59a,0xb59b,
/* 0xd100 */
0xb59c,0xb59d,0xb59e,0xb59f,0xb5a0,0xb641,0xb642,0xb643,
0xb644,0xb645,0xb646,0xb647,0xb648,0xc5cc,0xb649,0xb64a,
0xb64b,0xb64c,0xb64d,0xb64e,0xb64f,0xb650,0xb651,0xb652,
0xb653,0xb654,0xb655,0xb656,0xb657,0xb658,0xb659,0xb65a,
0xb661,0xb662,0xb663,0xb664,0xb665,0xb666,0xb667,0xb668,
0xb669,0xb66a,0xb66b,0xb66c,0xb66d,0xb66e,0xb66f,0xb670,
0xc5cd,0xc5ce,0xb671,0xb672,0xc5cf,0xb673,0xb674,0xb675,
0xc5d0,0xb676,0xc5d1,0xb677,0xb678,0xb679,0xb67a,0xb681,
0xc5d2,0xc5d3,0xb682,0xc5d4,0xc5d5,0xc5d6,0xb683,0xb684,
0xb685,0xb686,0xb687,0xb688,0xc5d7,0xc5d8,0xb689,0xb68a,
0xc5d9,0xb68b,0xb68c,0xb68d,0xc5da,0xb68e,0xb68f,0xb690,
0xb691,0xb692,0xb693,0xb694,0xc5db,0xc5dc,0xb695,0xc5dd,
0xb696,0xc5de,0xb697,0xb698,0xb699,0xb69a,0xb69b,0xb69c,
0xc5df,0xb69d,0xb69e,0xb69f,0xc5e0,0xb6a0,0xb741,0xb742,
0xb743,0xb744,0xb745,0xb746,0xb747,0xb748,0xb749,0xb74a,
0xb74b,0xb74c,0xb74d,0xb74e,0xc5e1,0xb74f,0xb750,0xb751,
0xb752,0xb753,0xb754,0xb755,0xc5e2,0xb756,0xb757,0xb758,
0xc5e3,0xb759,0xb75a,0xb761,0xb762,0xb763,0xb764,0xb765,
0xb766,0xb767,0xb768,0xb769,0xb76a,0xb76b,0xb76c,0xb76d,
0xb76e,0xb76f,0xb770,0xb771,0xb772,0xb773,0xb774,0xb775,
0xc5e4,0xc5e5,0xb776,0xb777,0xc5e6,0xb778,0xb779,0xb77a,
0xc5e7,0xb781,0xb782,0xb783,0xb784,0xb785,0xb786,0xb787,
0xc5e8,0xc5e9,0xb788,0xc5ea,0xb789,0xc5eb,0xb78a,0xb78b,
0xb78c,0xb78d,0xc5ec,0xb78e,0xc5ed,0xb78f,0xb790,0xb791,
0xc5ee,0xb792,0xb793,0xb794,0xb795,0xb796,0xb797,0xb798,
0xb799,0xb79a,0xb79b,0xb79c,0xb79d,0xb79e,0xb79f,0xb7a0,
0xb841,0xb842,0xb843,0xb844,0xb845,0xb846,0xb847,0xb848,
0xc5ef,0xb849,0xb84a,0xb84b,0xb84c,0xb84d,0xb84e,0xb84f,
0xb850,0xb851,0xb852,0xb853,0xb854,0xb855,0xb856,0xb857,
0xb858,0xb859,0xb85a,0xb861,0xb862,0xb863,0xb864,0xb865,
0xb866,0xb867,0xb868,0xb869,0xc5f0,0xb86a,0xb86b,0xb86c,
0xc5f1,0xb86d,0xb86e,0xb86f,0xb870,0xb871,0xb872,0xb873,
/* 0xd200 */
0xb874,0xb875,0xb876,0xb877,0xb878,0xb879,0xb87a,0xc5f2,
0xb881,0xc5f3,0xb882,0xb883,0xb884,0xb885,0xb886,0xb887,
0xc5f4,0xb888,0xb889,0xb88a,0xb88b,0xb88c,0xb88d,0xb88e,
0xb88f,0xb890,0xb891,0xb892,0xb893,0xb894,0xb895,0xb896,
0xb897,0xb898,0xb899,0xb89a,0xb89b,0xb89c,0xb89d,0xb89e,
0xb89f,0xb8a0,0xb941,0xb942,0xc5f5,0xc5f6,0xb943,0xb944,
0xc5f7,0xb945,0xb946,0xb947,0xc5f8,0xb948,0xb949,0xb94a,
0xb94b,0xb94c,0xb94d,0xb94e,0xc5f9,0xc5fa,0xb94f,0xc5fb,
0xb950,0xc5fc,0xb951,0xb952,0xb953,0xb954,0xb955,0xb956,
0xc5fd,0xb957,0xb958,0xb959,0xb95a,0xb961,0xb962,0xb963,
0xb964,0xb965,0xb966,0xb967,0xb968,0xb969,0xb96a,0xb96b,
0xb96c,0xb96d,0xb96e,0xb96f,0xc5fe,0xb970,0xb971,0xb972,
0xb973,0xb974,0xb975,0xb976,0xc6a1,0xb977,0xb978,0xb979,
0xb97a,0xb981,0xb982,0xb983,0xb984,0xb985,0xb986,0xb987,
0xb988,0xb989,0xb98a,0xb98b,0xb98c,0xb98d,0xb98e,0xb98f,
0xb990,0xb991,0xb992,0xb993,0xb994,0xb995,0xb996,0xb997,
0xc6a2,0xc6a3,0xb998,0xb999,0xc6a4,0xb99a,0xb99b,0xb99c,
0xc6a5,0xb99d,0xb99e,0xb99f,0xb9a0,0xba41,0xba42,0xba43,
0xc6a6,0xc6a7,0xba44,0xba45,0xba46,0xc6a8,0xba47,0xba48,
0xba49,0xba4a,0xba4b,0xba4c,0xc6a9,0xba4d,0xba4e,0xba4f,
0xc6aa,0xba50,0xba51,0xba52,0xc6ab,0xba53,0xba54,0xba55,
0xba56,0xba57,0xba58,0xba59,0xc6ac,0xba5a,0xba61,0xba62,
0xba63,0xc6ad,0xba64,0xba65,0xba66,0xba67,0xba68,0xba69,
0xc6ae,0xc6af,0xba6a,0xba6b,0xc6b0,0xba6c,0xba6d,0xc6b1,
0xc6b2,0xba6e,0xc6b3,0xba6f,0xba70,0xba71,0xba72,0xba73,
0xc6b4,0xc6b5,0xba74,0xc6b6,0xba75,0xba76,0xba77,0xba78,
0xba79,0xba7a,0xba81,0xba82,0xc6b7,0xba83,0xba84,0xba85,
0xc6b8,0xba86,0xba87,0xba88,0xc6b9,0xba89,0xba8a,0xba8b,
0xba8c,0xba8d,0xba8e,0xba8f,0xc6ba,0xc6bb,0xba90,0xba91,
0xba92,0xba93,0xba94,0xba95,0xba96,0xba97,0xba98,0xba99,
0xc6bc,0xc6bd,0xba9a,0xba9b,0xc6be,0xba9c,0xba9d,0xba9e,
0xc6bf,0xba9f,0xbaa0,0xbb41,0xbb42,0xbb43,0xbb44,0xbb45,
/* 0xd300 */
0xc6c0,0xc6c1,0xbb46,0xc6c2,0xbb47,0xc6c3,0xbb48,0xbb49,
0xbb4a,0xbb4b,0xbb4c,0xbb4d,0xc6c4,0xc6c5,0xc6c6,0xbb4e,
0xc6c7,0xbb4f,0xbb50,0xbb51,0xc6c8,0xbb52,0xc6c9,0xbb53,
0xbb54,0xbb55,0xbb56,0xbb57,0xc6ca,0xc6cb,0xbb58,0xc6cc,
0xc6cd,0xc6ce,0xbb59,0xbb5a,0xbb61,0xc6cf,0xbb62,0xbb63,
0xc6d0,0xc6d1,0xbb64,0xbb65,0xc6d2,0xbb66,0xbb67,0xbb68,
0xc6d3,0xbb69,0xbb6a,0xbb6b,0xbb6c,0xbb6d,0xbb6e,0xbb6f,
0xc6d4,0xc6d5,0xbb70,0xc6d6,0xc6d7,0xc6d8,0xbb71,0xbb72,
0xbb73,0xbb74,0xbb75,0xbb76,0xc6d9,0xc6da,0xbb77,0xbb78,
0xbb79,0xbb7a,0xbb81,0xbb82,0xbb83,0xbb84,0xbb85,0xbb86,
0xbb87,0xbb88,0xbb89,0xbb8a,0xbb8b,0xbb8c,0xbb8d,0xbb8e,
0xbb8f,0xbb90,0xbb91,0xbb92,0xbb93,0xbb94,0xbb95,0xbb96,
0xbb97,0xbb98,0xbb99,0xbb9a,0xbb9b,0xbb9c,0xbb9d,0xbb9e,
0xbb9f,0xbba0,0xbc41,0xbc42,0xbc43,0xbc44,0xbc45,0xbc46,
0xbc47,0xbc48,0xbc49,0xbc4a,0xbc4b,0xbc4c,0xbc4d,0xbc4e,
0xbc4f,0xbc50,0xbc51,0xbc52,0xc6db,0xc6dc,0xbc53,0xbc54,
0xc6dd,0xbc55,0xbc56,0xbc57,0xc6de,0xbc58,0xbc59,0xbc5a,
0xbc61,0xbc62,0xbc63,0xbc64,0xc6df,0xc6e0,0xbc65,0xc6e1,
0xc6e2,0xc6e3,0xbc66,0xbc67,0xbc68,0xbc69,0xbc6a,0xbc6b,
0xc6e4,0xc6e5,0xbc6c,0xbc6d,0xc6e6,0xbc6e,0xbc6f,0xbc70,
0xc6e7,0xbc71,0xbc72,0xbc73,0xbc74,0xbc75,0xbc76,0xbc77,
0xc6e8,0xc6e9,0xbc78,0xc6ea,0xbc79,0xc6eb,0xbc7a,0xbc81,
0xbc82,0xbc83,0xbc84,0xbc85,0xc6ec,0xbc86,0xbc87,0xbc88,
0xc6ed,0xbc89,0xbc8a,0xbc8b,0xc6ee,0xbc8c,0xbc8d,0xbc8e,
0xbc8f,0xbc90,0xbc91,0xbc92,0xc6ef,0xc6f0,0xbc93,0xbc94,
0xc6f1,0xc6f2,0xbc95,0xbc96,0xbc97,0xbc98,0xbc99,0xbc9a,
0xc6f3,0xbc9b,0xbc9c,0xbc9d,0xbc9e,0xbc9f,0xbca0,0xbd41,
0xc6f4,0xbd42,0xbd43,0xbd44,0xbd45,0xbd46,0xbd47,0xbd48,
0xbd49,0xc6f5,0xbd4a,0xc6f6,0xbd4b,0xbd4c,0xbd4d,0xbd4e,
0xbd4f,0xbd50,0xbd51,0xbd52,0xc6f7,0xc6f8,0xbd53,0xbd54,
0xc6f9,0xbd55,0xbd56,0xbd57,0xc6fa,0xbd58,0xbd59,0xbd5a,
0xbd61,0xbd62,0xbd63,0xbd64,0xc6fb,0xc6fc,0xbd65,0xc6fd,
/* 0xd400 */
0xbd66,0xc6fe,0xbd67,0xbd68,0xbd69,0xbd6a,0xbd6b,0xbd6c,
0xc7a1,0xbd6d,0xbd6e,0xbd6f,0xbd70,0xbd71,0xbd72,0xbd73,
0xbd74,0xbd75,0xbd76,0xbd77,0xbd78,0xbd79,0xbd7a,0xbd81,
0xbd82,0xbd83,0xbd84,0xbd85,0xbd86,0xc7a2,0xbd87,0xbd88,
0xbd89,0xbd8a,0xbd8b,0xbd8c,0xbd8d,0xbd8e,0xbd8f,0xbd90,
0xbd91,0xbd92,0xbd93,0xbd94,0xbd95,0xbd96,0xbd97,0xbd98,
0xbd99,0xbd9a,0xbd9b,0xbd9c,0xbd9d,0xbd9e,0xbd9f,0xbda0,
0xbe41,0xbe42,0xbe43,0xbe44,0xbe45,0xbe46,0xbe47,0xbe48,
0xc7a3,0xbe49,0xbe4a,0xbe4b,0xc7a4,0xbe4c,0xbe4d,0xbe4e,
0xbe4f,0xbe50,0xbe51,0xbe52,0xbe53,0xbe54,0xbe55,0xbe56,
0xbe57,0xbe58,0xbe59,0xbe5a,0xbe61,0xbe62,0xbe63,0xbe64,
0xbe65,0xbe66,0xbe67,0xbe68,0xc7a5,0xbe69,0xbe6a,0xbe6b,
0xc7a6,0xbe6c,0xbe6d,0xbe6e,0xc7a7,0xbe6f,0xbe70,0xbe71,
0xbe72,0xbe73,0xbe74,0xbe75,0xbe76,0xc7a8,0xbe77,0xc7a9,
0xbe78,0xbe79,0xbe7a,0xbe81,0xbe82,0xbe83,0xbe84,0xbe85,
0xc7aa,0xc7ab,0xbe86,0xbe87,0xc7ac,0xbe88,0xbe89,0xc7ad,
0xc7ae,0xbe8a,0xc7af,0xbe8b,0xbe8c,0xbe8d,0xbe8e,0xbe8f,
0xc7b0,0xc7b1,0xbe90,0xc7b2,0xbe91,0xc7b3,0xbe92,0xbe93,
0xbe94,0xbe95,0xbe96,0xbe97,0xc7b4,0xbe98,0xbe99,0xbe9a,
0xbe9b,0xbe9c,0xbe9d,0xbe9e,0xbe9f,0xbea0,0xbf41,0xbf42,
0xbf43,0xbf44,0xbf45,0xbf46,0xbf47,0xbf48,0xbf49,0xbf4a,
0xbf4b,0xc7b5,0xbf4c,0xbf4d,0xbf4e,0xbf4f,0xbf50,0xbf51,
0xbf52,0xbf53,0xbf54,0xbf55,0xbf56,0xbf57,0xbf58,0xbf59,
0xbf5a,0xbf61,0xbf62,0xbf63,0xbf64,0xbf65,0xbf66,0xbf67,
0xbf68,0xbf69,0xbf6a,0xbf6b,0xbf6c,0xbf6d,0xbf6e,0xbf6f,
0xbf70,0xbf71,0xbf72,0xbf73,0xc7b6,0xbf74,0xbf75,0xbf76,
0xc7b7,0xbf77,0xbf78,0xbf79,0xc7b8,0xbf7a,0xbf81,0xbf82,
0xbf83,0xbf84,0xbf85,0xbf86,0xc7b9,0xbf87,0xbf88,0xc7ba,
0xbf89,0xbf8a,0xbf8b,0xbf8c,0xbf8d,0xbf8e,0xbf8f,0xbf90,
0xc7bb,0xbf91,0xbf92,0xbf93,0xc7bc,0xbf94,0xbf95,0xbf96,
0xc7bd,0xbf97,0xbf98,0xbf99,0xbf9a,0xbf9b,0xbf9c,0xbf9d,
0xc7be,0xbf9e,0xbf9f,0xc7bf,0xbfa0,0xc7c0,0xc041,0xc042,
/* 0xd500 */
0xc043,0xc044,0xc045,0xc046,0xc7c1,0xc047,0xc048,0xc049,
0xc7c2,0xc04a,0xc04b,0xc04c,0xc7c3,0xc04d,0xc04e,0xc04f,
0xc050,0xc051,0xc052,0xc053,0xc7c4,0xc7c5,0xc054,0xc7c6,
0xc055,0xc056,0xc057,0xc058,0xc059,0xc05a,0xc061,0xc062,
0xc063,0xc064,0xc065,0xc066,0xc067,0xc068,0xc069,0xc06a,
0xc06b,0xc06c,0xc06d,0xc06e,0xc06f,0xc070,0xc071,0xc072,
0xc073,0xc074,0xc075,0xc076,0xc077,0xc078,0xc079,0xc07a,
0xc081,0xc082,0xc083,0xc084,0xc7c7,0xc7c8,0xc085,0xc086,
0xc7c9,0xc087,0xc088,0xc089,0xc7ca,0xc08a,0xc08b,0xc08c,
0xc08d,0xc08e,0xc08f,0xc090,0xc7cb,0xc7cc,0xc091,0xc7cd,
0xc092,0xc7ce,0xc093,0xc094,0xc095,0xc096,0xc097,0xc098,
0xc7cf,0xc7d0,0xc099,0xc09a,0xc7d1,0xc09b,0xc09c,0xc09d,
0xc7d2,0xc09e,0xc09f,0xc0a0,0xc141,0xc7d3,0xc142,0xc143,
0xc7d4,0xc7d5,0xc144,0xc7d6,0xc145,0xc7d7,0xc146,0xc147,
0xc148,0xc149,0xc14a,0xc14b,0xc7d8,0xc7d9,0xc14c,0xc14d,
0xc7da,0xc14e,0xc14f,0xc150,0xc7db,0xc151,0xc152,0xc153,
0xc154,0xc155,0xc156,0xc157,0xc7dc,0xc7dd,0xc158,0xc7de,
0xc7df,0xc7e0,0xc159,0xc15a,0xc161,0xc162,0xc163,0xc164,
0xc7e1,0xc165,0xc166,0xc167,0xc168,0xc169,0xc16a,0xc16b,
0xc16c,0xc16d,0xc16e,0xc16f,0xc170,0xc171,0xc172,0xc173,
0xc174,0xc175,0xc176,0xc177,0xc178,0xc7e2,0xc179,0xc17a,
0xc181,0xc182,0xc183,0xc184,0xc185,0xc186,0xc187,0xc188,
0xc189,0xc18a,0xc18b,0xc18c,0xc18d,0xc18e,0xc18f,0xc190,
0xc191,0xc192,0xc193,0xc194,0xc195,0xc196,0xc197,0xc198,
0xc199,0xc19a,0xc19b,0xc19c,0xc19d,0xc19e,0xc19f,0xc1a0,
0xc7e3,0xc7e4,0xc241,0xc242,0xc7e5,0xc243,0xc244,0xc245,
0xc7e6,0xc246,0xc7e7,0xc247,0xc248,0xc249,0xc24a,0xc24b,
0xc7e8,0xc7e9,0xc24c,0xc7ea,0xc24d,0xc7eb,0xc24e,0xc24f,
0xc250,0xc251,0xc252,0xc253,0xc7ec,0xc7ed,0xc254,0xc255,
0xc7ee,0xc256,0xc257,0xc258,0xc7ef,0xc259,0xc25a,0xc261,
0xc262,0xc263,0xc264,0xc265,0xc7f0,0xc7f1,0xc266,0xc7f2,
0xc267,0xc7f3,0xc268,0xc269,0xc26a,0xc26b,0xc26c,0xc26d,
/* 0xd600 */
0xc7f4,0xc7f5,0xc26e,0xc26f,0xc7f6,0xc270,0xc271,0xc272,
0xc7f7,0xc273,0xc274,0xc275,0xc276,0xc277,0xc278,0xc279,
0xc7f8,0xc7f9,0xc27a,0xc7fa,0xc7fb,0xc7fc,0xc281,0xc282,
0xc283,0xc284,0xc285,0xc286,0xc7fd,0xc287,0xc288,0xc289,
0xc7fe,0xc28a,0xc28b,0xc28c,0xc8a1,0xc28d,0xc28e,0xc28f,
0xc290,0xc291,0xc292,0xc293,0xc294,0xc8a2,0xc295,0xc296,
0xc297,0xc298,0xc299,0xc29a,0xc29b,0xc29c,0xc29d,0xc29e,
0xc8a3,0xc8a4,0xc29f,0xc2a0,0xc8a5,0xc341,0xc342,0xc343,
0xc8a6,0xc344,0xc345,0xc346,0xc347,0xc8a7,0xc348,0xc349,
0xc8a8,0xc8a9,0xc34a,0xc8aa,0xc34b,0xc8ab,0xc34c,0xc34d,
0xc34e,0xc8ac,0xc34f,0xc350,0xc8ad,0xc8ae,0xc351,0xc352,
0xc8af,0xc353,0xc354,0xc355,0xc8b0,0xc356,0xc357,0xc358,
0xc359,0xc35a,0xc361,0xc362,0xc363,0xc364,0xc365,0xc8b1,
0xc366,0xc8b2,0xc367,0xc368,0xc369,0xc36a,0xc36b,0xc36c,
0xc8b3,0xc8b4,0xc36d,0xc36e,0xc8b5,0xc36f,0xc370,0xc371,
0xc372,0xc373,0xc374,0xc375,0xc376,0xc377,0xc378,0xc379,
0xc37a,0xc381,0xc382,0xc8b6,0xc383,0xc8b7,0xc384,0xc385,
0xc386,0xc387,0xc388,0xc389,0xc8b8,0xc8b9,0xc38a,0xc38b,
0xc8ba,0xc38c,0xc38d,0xc38e,0xc8bb,0xc38f,0xc390,0xc391,
0xc392,0xc393,0xc394,0xc395,0xc396,0xc8bc,0xc397,0xc8bd,
0xc398,0xc8be,0xc399,0xc39a,0xc39b,0xc39c,0xc39d,0xc39e,
0xc8bf,0xc39f,0xc3a0,0xc441,0xc8c0,0xc442,0xc443,0xc444,
0xc8c1,0xc445,0xc446,0xc447,0xc448,0xc449,0xc44a,0xc44b,
0xc44c,0xc8c2,0xc44d,0xc8c3,0xc44e,0xc44f,0xc450,0xc451,
0xc452,0xc453,0xc454,0xc455,0xc8c4,0xc8c5,0xc456,0xc457,
0xc8c6,0xc458,0xc459,0xc45a,0xc8c7,0xc461,0xc462,0xc463,
0xc464,0xc8c8,0xc465,0xc466,0xc8c9,0xc467,0xc468,0xc8ca,
0xc469,0xc8cb,0xc46a,0xc46b,0xc46c,0xc46d,0xc46e,0xc46f,
0xc8cc,0xc470,0xc471,0xc472,0xc8cd,0xc473,0xc474,0xc475,
0xc8ce,0xc476,0xc477,0xc478,0xc479,0xc47a,0xc481,0xc482,
0xc8cf,0xc483,0xc484,0xc485,0xc486,0xc8d0,0xc487,0xc488,
0xc489,0xc48a,0xc48b,0xc48c,0xc8d1,0xc8d2,0xc48d,0xc48e,
/* 0xd700 */
0xc8d3,0xc48f,0xc490,0xc491,0xc8d4,0xc492,0xc493,0xc494,
0xc495,0xc496,0xc497,0xc498,0xc499,0xc49a,0xc49b,0xc49c,
0xc49d,0xc8d5,0xc49e,0xc49f,0xc4a0,0xc541,0xc542,0xc543,
0xc8d6,0xc8d7,0xc544,0xc545,0xc8d8,0xc546,0xc547,0xc548,
0xc8d9,0xc549,0xc54a,0xc54b,0xc54c,0xc54d,0xc54e,0xc54f,
0xc8da,0xc8db,0xc550,0xc8dc,0xc551,0xc8dd,0xc552,0xc553,
0xc554,0xc555,0xc556,0xc557,0xc8de,0xc8df,0xc558,0xc559,
0xc8e0,0xc55a,0xc561,0xc562,0xc8e1,0xc563,0xc564,0xc565,
0xc566,0xc567,0xc568,0xc569,0xc8e2,0xc56a,0xc56b,0xc8e3,
0xc56c,0xc8e4,0xc56d,0xc56e,0xc56f,0xc570,0xc571,0xc572,
0xc8e5,0xc8e6,0xc573,0xc574,0xc8e7,0xc575,0xc8e8,0xc8e9,
0xc8ea,0xc8eb,0xc576,0xc577,0xc578,0xc579,0xc57a,0xc581,
0xc8ec,0xc8ed,0xc582,0xc8ee,0xc583,0xc8ef,0xc584,0xc585,
0xc586,0xc8f0,0xc587,0xc588,0xc8f1,0xc589,0xc58a,0xc58b,
0xc8f2,0xc58c,0xc58d,0xc58e,0xc8f3,0xc58f,0xc590,0xc591,
0xc592,0xc593,0xc594,0xc595,0xc8f4,0xc8f5,0xc596,0xc597,
0xc598,0xc8f6,0xc599,0xc59a,0xc59b,0xc59c,0xc59d,0xc59e,
0xc8f7,0xc8f8,0xc59f,0xc5a0,0xc8f9,0xc641,0xc642,0xc643,
0xc8fa,0xc644,0xc645,0xc646,0xc647,0xc648,0xc649,0xc64a,
0xc8fb,0xc8fc,0xc64b,0xc8fd,0xc64c,0xc8fe,0xc64d,0xc64e,
0xc64f,0xc650,0xc651,0xc652};


static const int ucs_s_uhc_table_min = 0xab00;
static const int ucs_s_uhc_table_max = 0xab00 + (sizeof(ucs_s_uhc_table)/sizeof(unsigned short));

static const unsigned short ucs_r1_uhc_table[] = {
/* 0xf800 */
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xcbd0,0xcbd6,0xcbe7,0xcdcf,0xcde8,0xcead,0xcffb,0xd0a2,
0xd0b8,0xd0d0,0xd0dd,0xd1d4,0xd1d5,0xd1d8,0xd1db,0xd1dc,
0xd1dd,0xd1de,0xd1df,0xd1e0,0xd1e2,0xd1e3,0xd1e4,0xd1e5,
0xd1e6,0xd1e8,0xd1e9,0xd1ea,0xd1eb,0xd1ed,0xd1ef,0xd1f0,
0xd1f2,0xd1f6,0xd1fa,0xd1fc,0xd1fd,0xd1fe,0xd2a2,0xd2a3,
0xd2a7,0xd2a8,0xd2a9,0xd2aa,0xd2ab,0xd2ad,0xd2b2,0xd2be,
0xd2c2,0xd2c3,0xd2c4,0xd2c6,0xd2c7,0xd2c8,0xd2c9,0xd2ca,
0xd2cb,0xd2cd,0xd2ce,0xd2cf,0xd2d0,0xd2d1,0xd2d2,0xd2d3,
0xd2d4,0xd2d5,0xd2d6,0xd2d7,0xd2d9,0xd2da,0xd2de,0xd2df,
0xd2e1,0xd2e2,0xd2e4,0xd2e5,0xd2e6,0xd2e7,0xd2e8,0xd2e9,
0xd2ea,0xd2eb,0xd2f0,0xd2f1,0xd2f2,0xd2f3,0xd2f4,0xd2f5,
0xd2f7,0xd2f8,0xd4e6,0xd4fc,0xd5a5,0xd5ab,0xd5ae,0xd6b8,
0xd6cd,0xd7cb,0xd7e4,0xdbc5,0xdbe4,0xdca5,0xdda5,0xddd5,
0xddf4,0xdefc,0xdefe,0xdfb3,0xdfe1,0xdfe8,0xe0f1,0xe1ad,
0xe1ed,0xe3f5,0xe4a1,0xe4a9,0xe5ae,0xe5b1,0xe5b2,0xe5b9,
0xe5bb,0xe5bc,0xe5c4,0xe5ce,0xe5d0,0xe5d2,0xe5d6,0xe5fa,
0xe5fb,0xe5fc,0xe5fe,0xe6a1,0xe6a4,0xe6a7,0xe6ad,0xe6af,
0xe6b0,0xe6b1,0xe6b3,0xe6b7,0xe6b8,0xe6bc,0xe6c4,0xe6c6,
0xe6c7,0xe6ca,0xe6d2,0xe6d6,0xe6d9,0xe6dc,0xe6df,0xe6e1,
0xe6e4,0xe6e5,0xe6e6,0xe6e8,0xe6ea,0xe6eb,0xe6ec,0xe6ef,
0xe6f1,0xe6f2,0xe6f5,0xe6f6,0xe6f7,0xe6f9,0xe7a1,0xe7a6,
0xe7a9,0xe7aa,0xe7ac,0xe7ad,0xe7b0,0xe7bf,0xe7c1,0xe7c6,
0xe7c7,0xe7cb,0xe7cd,0xe7cf,0xe7d0,0xe7d3,0xe7df,0xe7e4,
0xe7e6,0xe7f7,0xe8e7,0xe8e8,0xe8f0,0xe8f1,0xe8f7,0xe8f9,
0xe8fb,0xe8fe,0xe9a7,0xe9ac,0xe9cc,0xe9f7,0xeac1,0xeae5,
0xeaf4,0xeaf7,0xeafc,0xeafe,0xeba4,0xeba7,0xeba9,0xebaa,
0xebba,0xebbb,0xebbd,0xebc1,0xebc2,0xebc6,0xebc7,0xebcc,
0xebcf,0xebd0,0xebd1,0xebd2,0xebd8,0xeca6,0xeca7,0xecaa,
0xecaf,0xecb0,0xecb1,0xecb2,0xecb5,0xecb8,0xecba,0xecc0,
0xecc1,0xecc5,0xecc6,0xecc9,0xecca,0xecd5,0xecdd,0xecde,
0xece1,0xece4,0xece7,0xece8,0xecf7,0xecf8,0xecfa,0xeda1,
0xeda2,0xeda3,0xedee,0xeedb,0xf2bd,0xf2fa,0xf3b1,0xf4a7,
0xf4ee,0xf6f4,0xf6f6,0xf7b8,0xf7c8,0xf7d3,0xf8db,0xf8f0,
0xfaa1,0xfaa2,0xfae6,0xfca9};

static const int ucs_r1_uhc_table_min = 0xf800;
static const int ucs_r1_uhc_table_max = 0xf800 + (sizeof(ucs_r1_uhc_table)/sizeof(unsigned short));

static const unsigned short ucs_r2_uhc_table[] = {
/* 0xff00 */
0x0000,0xa3a1,0xa3a2,0xa3a3,0xa3a4,0xa3a5,0xa3a6,0xa3a7,
0xa3a8,0xa3a9,0xa3aa,0xa3ab,0xa3ac,0xa3ad,0xa3ae,0xa3af,
0xa3b0,0xa3b1,0xa3b2,0xa3b3,0xa3b4,0xa3b5,0xa3b6,0xa3b7,
0xa3b8,0xa3b9,0xa3ba,0xa3bb,0xa3bc,0xa3bd,0xa3be,0xa3bf,
0xa3c0,0xa3c1,0xa3c2,0xa3c3,0xa3c4,0xa3c5,0xa3c6,0xa3c7,
0xa3c8,0xa3c9,0xa3ca,0xa3cb,0xa3cc,0xa3cd,0xa3ce,0xa3cf,
0xa3d0,0xa3d1,0xa3d2,0xa3d3,0xa3d4,0xa3d5,0xa3d6,0xa3d7,
0xa3d8,0xa3d9,0xa3da,0xa3db,0xa1ac,0xa3dd,0xa3de,0xa3df,
0xa3e0,0xa3e1,0xa3e2,0xa3e3,0xa3e4,0xa3e5,0xa3e6,0xa3e7,
0xa3e8,0xa3e9,0xa3ea,0xa3eb,0xa3ec,0xa3ed,0xa3ee,0xa3ef,
0xa3f0,0xa3f1,0xa3f2,0xa3f3,0xa3f4,0xa3f5,0xa3f6,0xa3f7,
0xa3f8,0xa3f9,0xa3fa,0xa3fb,0xa3fc,0xa3fd,0xa2a6,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xa1cb,0xa1cc,0xa1fe,0xa3fe,0x0000,0xa1cd,0xa3dc};

static const int ucs_r2_uhc_table_min = 0xff00;
static const int ucs_r2_uhc_table_max = 0xff00 + (sizeof (ucs_r2_uhc_table) / sizeof (unsigned short));




#endif /* UNICODE_TABLE_UHC_H */
