--TEST--
Bug #52063 (DateTime constructor's second argument doesn't have a null default value)
--FILE--
<?php
date_default_timezone_set("Europe/Lisbon");
$a = new DateTime("2009-01-01", null);
echo $a->format(DateTime::COOKIE);
echo "\n";
$a = date_create("2009-01-01", null);
echo $a->format(DateTime::COOKIE);
echo "\n";
?>
--EXPECTF--
Fatal error: Uncaught exception 'Exception' with message 'DateTime::__construct() expects parameter 2 to be DateTimeZone, null given' in /root/mountpoint-genprog/genprog-many-bugs/php-bug-2011-01-23-bc049ccb62-a6c0a4e474/php/ext/date/tests/bug52063-detect.php:3
Stack trace:
#0 /root/mountpoint-genprog/genprog-many-bugs/php-bug-2011-01-23-bc049ccb62-a6c0a4e474/php/ext/date/tests/bug52063-detect.php(3): DateTime->__construct('2009-01-01', NULL)
#1 {main}
  thrown in /root/mountpoint-genprog/genprog-many-bugs/php-bug-2011-01-23-bc049ccb62-a6c0a4e474/php/ext/date/tests/bug52063-detect.php on line 3